#include "searchvenueswindow.h"
#include "ui_searchvenueswindow.h"
#include <QMaemo5InformationBox>

#include <QDebug>
#include <QListWidgetItem>

SearchVenuesWindow::SearchVenuesWindow(QWidget *parent) :
    QWidget(parent), ui(new Ui::SearchVenuesWindow)
{
    ui->setupUi(this);
    fsc = FoursquareComm::instance();
    ps = PositionSource::instance();
    ic = new ImageCache(this);

    #if defined(Q_WS_MAEMO_5)
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
    this->setWindowFlags(this->windowFlags()| Qt::Window);
}

SearchVenuesWindow::~SearchVenuesWindow()
{
    delete ui;
}

void SearchVenuesWindow::on_pbSearch_clicked()
{
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator);
    if(!ps->isValidPosition())
    {
        QMaemo5InformationBox::information(this, "<p>Invalid GPS position.</p>", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    qDebug() << "Latitude " + QString::number(ps->gc.latitude());
    qDebug() << "Longitude " + QString::number(ps->gc.longitude());

    lastResult = fsc->searchVenues(ps->getLL(),QString(),ui->leQuery->text());

    parseAndShowResult();
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false);
}

void SearchVenuesWindow::on_pbNearby_clicked()
{
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator);
    if(!ps->isValidPosition())
    {
        QMaemo5InformationBox::information(this, "<p>Invalid GPS position.</p>", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    qDebug() << "Latitude " + QString::number(ps->gc.latitude());
    qDebug() << "Longitude " + QString::number(ps->gc.longitude());

    lastResult = fsc->searchVenues(ps->getLL());

    parseAndShowResult();
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false);
}

void SearchVenuesWindow::on_listWidget_clicked(QModelIndex index)
{
    vd = new VenueDetails(this);
    vd->setVenue(lastResult.at(index.row()));
    vd->show();
}

void SearchVenuesWindow::parseAndShowResult()
{
    ui->listWidget->clear();
    for (int i = 0; i < lastResult.size(); ++i) {
        QListWidgetItem * li = new QListWidgetItem();
        li->setIcon(QIcon(ic->getImage(lastResult.at(i).icon)));
        li->setText(lastResult.at(i).name);
        this->ui->listWidget->insertItem(i,li);
    }
}
