#include <QtCore>
#include <QtGui>
#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    progress("Setting up the fonts, please wait...", "Abort", 0, 0, this)
{
    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->widget);
//    readSettings();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::writeSettings()
{
    QSettings sett("FontChanger", "Boxes");
    sett.setValue("fontsize", ui->FontSize->currentIndex());
}

void MainWindow::readSettings()
{
    QSettings sett("FontChanger", "Boxes");
    int fontsize = sett.value("fontsize").toInt();
    ui->FontSize->setCurrentIndex(fontsize);
}



void MainWindow::on_pushButton_clicked()
{
        QString checkboxstate;
        if ( ui->checkBoxActivate->checkState() == Qt::Checked ) {
            checkboxstate = "Reboot";
        }
        else {
            checkboxstate = "0";
        }
//        writeSettings();
        QString varattu;
        varattu = "Font Changer";
        progress.setWindowModality(Qt::WindowModal);
        progress.setWindowTitle(varattu);
        progress.setCancelButton(0);
        QStringList arguments;
        arguments << ui->Fonter->currentText() << ui->FontSize->currentText() << checkboxstate ;
        QProcess *process = new QProcess(this);
        connect(process, SIGNAL(finished(int)), this, SLOT(processFinished(int)));
        process->start("/sbin/launcfontchanger", arguments);
        progress.show();


}

void MainWindow::processFinished(int)
{
        progress.cancel();
}
