/*
 * fmtx-faker: Tricks fmtxd into thinking the transmitter is not disabled.
 *
 * Copyright (C) 2009-2010 Faheem Pervez <trippin1@gmail.com>. All rights reserved.
 *
 *             DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 *                   Version 2, December 2004
 *
 *	Copyright (C) 2004 Sam Hocevar
 *	14 rue de Plaisance, 75014 Paris, France
 *	Everyone is permitted to copy and distribute verbatim or modified
 *	copies of this license document, and changing it is allowed as long
 *	as the name is changed.
 *
 *           DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 *  TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
 *
 * 	0. You just DO WHAT THE FUCK YOU WANT TO. 
 *
 * This program is free software. It comes without any warranty, to
 * the extent permitted by applicable law. You can redistribute it
 * and/or modify it under the terms of the Do What The Fuck You Want
 * To Public License, Version 2, as published by Sam Hocevar. See
 * http://sam.zoy.org/wtfpl/COPYING for more details.
 *
 */

/* fmtx-faker-obj.c */

#include "fmtx-faker-obj.h"
#include "fmtx-faker-objGlue.h"
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-bindings.h>

#define FMTX_FAKER_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), \
						FMTX_TYPE_FAKER, FMTXFakerPrivate))

typedef struct _FMTXFakerPrivate FMTXFakerPrivate;

struct _FMTXFakerPrivate
{
	DBusGConnection *dbus_connection;
	DBusGProxy *bus_proxy;

	guchar fmtx_mode;
};

enum
{
	PROP_0,
	FMTX_FAKER_PROP_FMTX_MODE
};

G_DEFINE_TYPE (FMTXFaker, fmtx_faker, G_TYPE_OBJECT)

static void fmtx_faker_finalize (GObject *object)
{
	FMTXFaker *self = FMTX_FAKER (object);
	FMTXFakerPrivate *priv = FMTX_FAKER_GET_PRIVATE (self);

	if (priv->bus_proxy)
	{
		org_freedesktop_DBus_release_name (priv->bus_proxy, FMTX_FAKER_SERVICE_NAME, NULL, NULL);
		g_object_unref (G_OBJECT (priv->bus_proxy));
	}

	if (priv->dbus_connection)
		dbus_g_connection_unref (priv->dbus_connection);

	G_OBJECT_CLASS (fmtx_faker_parent_class)->finalize (object);
}

static void fmtx_faker_get_property (GObject *object, guint property_id, GValue *value, GParamSpec * pspec)
{
	FMTXFaker *self = FMTX_FAKER (object);
	FMTXFakerPrivate *priv = FMTX_FAKER_GET_PRIVATE (self);

	g_return_if_fail (priv);
 	  	 
	switch (property_id)
	{
		case FMTX_FAKER_PROP_FMTX_MODE:
			g_value_set_uchar (value, priv->fmtx_mode);
			break;
 	  	 
		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
			break;
	}
}

static void fmtx_faker_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec * pspec)
{
	FMTXFaker *self = FMTX_FAKER (object);
	FMTXFakerPrivate *priv = FMTX_FAKER_GET_PRIVATE (self);

	g_return_if_fail (priv);
 	  	 
	switch (property_id)
	{
		case FMTX_FAKER_PROP_FMTX_MODE:
			priv->fmtx_mode = g_value_get_uchar (value);
			g_object_notify (object, "fmtx-mode");
			break;
 	  	 
		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
			break;
	}
}

static void fmtx_faker_class_init (FMTXFakerClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	object_class->get_property = fmtx_faker_get_property;
	object_class->set_property = fmtx_faker_set_property;
	object_class->finalize = (GObjectFinalizeFunc) fmtx_faker_finalize;

	g_object_class_install_property (object_class, FMTX_FAKER_PROP_FMTX_MODE, g_param_spec_uchar ("fmtx-mode", "FMTX Frequency Mode", "The mode in which the FM Transmitter will be enabled. Look at /etc/sysinfod.conf for (some) more info.", 1, 5, FMTX_FAKER_PROP_FMTX_MODE_DEFAULT_VAL, G_PARAM_CONSTRUCT_ONLY | G_PARAM_READWRITE));

	g_type_class_add_private (klass, sizeof (FMTXFakerPrivate));

	dbus_g_object_type_install_info (FMTX_TYPE_FAKER, &dbus_glib_fmtx_faker_object_info);
}

static void fmtx_faker_init (FMTXFaker *self)
{
	FMTXFakerPrivate *priv = FMTX_FAKER_GET_PRIVATE (self);
	guint request_name_ret;
	GError *error = NULL;

	priv->fmtx_mode = FMTX_FAKER_PROP_FMTX_MODE_DEFAULT_VAL;

	priv->dbus_connection = dbus_g_bus_get (DBUS_BUS_SYSTEM, &error);
	if (error)
	{
		g_warning ("Failed to open connection to system bus: %s\n", error->message);
		g_clear_error (&error);
		return;
	}

	priv->bus_proxy = dbus_g_proxy_new_for_name (priv->dbus_connection, DBUS_SERVICE_DBUS, DBUS_PATH_DBUS, DBUS_INTERFACE_DBUS);

	org_freedesktop_DBus_request_name (priv->bus_proxy, FMTX_FAKER_SERVICE_NAME, DBUS_NAME_FLAG_DO_NOT_QUEUE, &request_name_ret, &error);
	if (error)
	{
		g_warning ("Failed to request name: %s\n", error->message);
		g_clear_error (&error);
		return;
	}

	switch (request_name_ret)
	{
		case DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER:
			dbus_g_connection_register_g_object (priv->dbus_connection, FMTX_FAKER_OBJECT_PATH, G_OBJECT (self));
			break;

		case DBUS_REQUEST_NAME_REPLY_EXISTS:
			g_warning ("Already running\n");
		default:
			g_warning ("Some other motherfucker took our Nokla name!");
			g_object_unref (G_OBJECT (priv->bus_proxy));
			dbus_g_connection_unref (priv->dbus_connection);
	}
}

static gboolean fmtx_faker_shutdown (GObject *self)
{
	g_object_unref (self);
	return FALSE;
}

/* D-Bus, eh? */
gboolean fmtx_faker_get_config_value (FMTXFaker *self, const gchar *string, GArray **out_array, GError **error)
{
	gboolean retval = FALSE;

	if (G_LIKELY (!g_strcmp0 (string, "/certs/ccc/pp/fmtx-raw")))
	{
		FMTXFakerPrivate *priv = FMTX_FAKER_GET_PRIVATE (self);
		const guchar terminator = 0;

		if (G_UNLIKELY (!priv))
		{
			g_set_error (error, DBUS_GERROR, DBUS_GERROR_REMOTE_EXCEPTION, "FMTX Faker Int. Error: Couldn't retrieve private struct");
			goto ret;
		}

		*out_array = g_array_sized_new (FALSE, FALSE, sizeof (guchar), 2);
		if (!*out_array)
		{
			g_set_error (error, DBUS_GERROR, DBUS_GERROR_REMOTE_EXCEPTION, "FMTX Faker Int. Error: Unable to create GArray");
			goto ret;
		}

		g_array_append_val (*out_array, priv->fmtx_mode);
		g_array_append_val (*out_array, terminator); /* Hasta la vista, baby */

		retval = TRUE;
	}
	else /* We've been invoked for another key. Awesomeness! Based on code from hildon-control-panel */
	{
		#define SYSINFO_SERVICE_DBUS "com.nokia.SystemInfo"
		#define SYSINFO_PATH_DBUS "/com/nokia/SystemInfo"
		#define SYSINFO_INTERFACE_DBUS "com.nokia.SystemInfo"
		#define SYSINFO_METHOD "GetConfigValue"		

		DBusGProxy *sysinfo_proxy = dbus_g_proxy_new_for_name (FMTX_FAKER_GET_PRIVATE (self)->dbus_connection, SYSINFO_SERVICE_DBUS, SYSINFO_PATH_DBUS, SYSINFO_INTERFACE_DBUS);
		if (!sysinfo_proxy)
		{
			g_set_error (error, DBUS_GERROR, DBUS_GERROR_REMOTE_EXCEPTION, "Couldn't create SystemInfo proxy");
			goto ret;
		}
		
		dbus_g_proxy_call (sysinfo_proxy, SYSINFO_METHOD, error, G_TYPE_STRING, string, G_TYPE_INVALID, dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR), out_array, G_TYPE_INVALID);
		g_object_unref (G_OBJECT (sysinfo_proxy));

		if (!*error)
			retval = TRUE;
	}

ret:
	g_idle_add ((GSourceFunc) fmtx_faker_shutdown, self);
	return retval;
}

FMTXFaker* fmtx_faker_new_with_fmtx_mode_property (const guchar value)
{
	return FMTX_FAKER (g_object_new (FMTX_TYPE_FAKER, "fmtx-mode", value, NULL));
}

#if 0
FMTXFaker* fmtx_faker_new_with_properties (const gchar *first_property, ...)
{
	FMTXFaker *self;
	va_list args;

	va_start (args, first_property);
	self = FMTX_FAKER (g_object_new_valist (FMTX_TYPE_FAKER, first_property, args));
	va_end (args);

	return self;
}

FMTXFaker* fmtx_faker_new (void)
{
	return FMTX_FAKER (g_object_new (FMTX_TYPE_FAKER, NULL));
}
#endif
