/*
 * fmtx-faker: Tricks fmtxd into thinking the transmitter is not disabled.
 *
 * Copyright (C) 2009 Faheem Pervez <trippin1@gmail.com>. All rights reserved.
 *
 *             DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 *                   Version 2, December 2004
 *
 *	Copyright (C) 2004 Sam Hocevar
 *	14 rue de Plaisance, 75014 Paris, France
 *	Everyone is permitted to copy and distribute verbatim or modified
 *	copies of this license document, and changing it is allowed as long
 *	as the name is changed.
 *
 *           DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 *  TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
 *
 * 	0. You just DO WHAT THE FUCK YOU WANT TO. 
 *
 * This program is free software. It comes without any warranty, to
 * the extent permitted by applicable law. You can redistribute it
 * and/or modify it under the terms of the Do What The Fuck You Want
 * To Public License, Version 2, as published by Sam Hocevar. See
 * http://sam.zoy.org/wtfpl/COPYING for more details.
 *
 */

/* fmtx-fakerd.c */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <unistd.h>
#include <stdlib.h>
#include <glib.h>
#include <gconf/gconf-client.h>
#include <dbus/dbus-glib.h>
#include "fmtx-faker-obj.h"

#define USER_ID 29999

static GMainLoop *loop = NULL;

static void sig_handler (gint sig G_GNUC_UNUSED)
{
	if (g_main_loop_is_running (loop))
		g_main_loop_quit (loop);
}

gint main (void)
{
	GConfClient *gconf_client;
	FMTXFaker *fmtx_faker_obj;
	guchar fmtx_mode = FMTX_FAKER_PROP_FMTX_MODE_DEFAULT_VAL;

	if (getuid () != USER_ID)
	{
		setuid (USER_ID);
		seteuid (USER_ID);
	}

	g_type_init ();

	gconf_client = gconf_client_get_default ();
	if (gconf_client)
	{
		GError *error = NULL;
		gint stored_val = gconf_client_get_int (gconf_client, FMTX_MODE_GCONF_KEY, &error);
		if (error)
		{
			g_printerr ("Failed to get value from GConf; now using value %c: %s\n", fmtx_mode, error->message);
			g_clear_error (&error);
		}
		else
			fmtx_mode = stored_val;

		g_object_unref (gconf_client);
		gconf_client = NULL;
	}
	else
		g_printerr ("Failed to get value from GConf; now using value %c.", fmtx_mode);

	loop = g_main_loop_new (NULL, FALSE);
	if (!loop)
	{
		g_printerr ("Failed to create main loop.");
		return EXIT_FAILURE;
	}

	fmtx_faker_obj = fmtx_faker_new_with_fmtx_mode_property (fmtx_mode);
	if (!fmtx_faker_obj)
	{
		g_printerr ("FMTXFaker object instantiation failed.");
		return EXIT_FAILURE;
	}

	signal (SIGINT, sig_handler);
	signal (SIGQUIT, sig_handler);
	signal (SIGTERM, sig_handler);

	g_main_loop_run (loop);

	g_main_loop_unref (loop);
	g_object_unref (fmtx_faker_obj);

	return EXIT_SUCCESS;
}
