from ui.itemview import Item
from theme import theme


class StationItem(Item):

    def __init__(self, name, frequency):
    
        self.__name = name
        self.__frequency = frequency
    
        Item.__init__(self)
        
        
    def get_frequency(self):
    
        return self.__frequency

        
    def render_at(self, cnv, x, y):
    
        w, h = self.get_size()
        
        pmap, is_new = self._get_cached_pixmap()
        if (is_new):
            pmap.fill_area(0, 0, w, h, theme.color_mb_background)

            # render selection frame
            if (self.is_hilighted() or self.is_marked()):
                pmap.draw_frame(theme.mb_selection_frame, 0, 0, w, h, True,
                                pmap.TOP | pmap.BOTTOM | pmap.LEFT | pmap.RIGHT)
           
            offset = 20
            
            # render text
            pmap.set_clip_rect(0, 0, w - 80, h)
            pmap.draw_text(self.__name, theme.font_mb_listitem_text,
                           offset, 10,
                           theme.color_mb_listitem_text)
            pmap.draw_text("%0.2f MHz" % (self.__frequency / 1000.0),
                           theme.font_mb_listitem_subtext,
                           offset, h - 36,
                           theme.color_mb_listitem_subtext)
            pmap.set_clip_rect()
            
        #end if
        
        # copy to the given canvas
        cnv.copy_buffer(pmap, 0, 0, x, y, w, h)

