from com import Component, msgs
from utils import logging
import platforms

import dbus


_STATE_NONE = 0
_STATE_INCOMING = 1


class PhoneMonitor(Component):
    """
    Component for monitoring the phone state.
    """

    def __init__(self):

        self.__state = _STATE_NONE

        Component.__init__(self)

        bus = platforms.get_system_bus()
        obj = bus.get_object("com.nokia.mce", "/com/nokia/mce/signal")
        obj.connect_to_signal("sig_call_state_ind",
                              self.__on_signal)
       
        
    def __on_signal(self, call_state, emergency_state):
    
        if (call_state == "ringing"):
            self.__state = _STATE_INCOMING
            self.emit_message(msgs.SYSTEM_EV_PHONE_RINGING)
            
        elif (call_state == "active"):
            if (self.__state == _STATE_INCOMING):
                self.emit_message(msgs.SYSTEM_EV_PHONE_ANSWERING)
            else:
                self.emit_message(msgs.SYSTEM_EV_PHONE_DIALING)
                
        elif (call_state == "none"):
            self.emit_message(msgs.SYSTEM_EV_PHONE_HANGUP)
            self.__state = _STATE_NONE

