import gobject
import pygst; pygst.require("0.10")
import gst
import os


class SoundPipe(object):
    """
    Class for actually getting sound out of the FM radio.
    """

    def __init__(self):
    
        # gstreamer pipeline for capturing sound
        self.__pipe = gst.Pipeline("pipe")
        self.__pipe_source = gst.element_factory_make("pulsesrc", "source")
        self.__pipe_sink = gst.element_factory_make("pulsesink", "sink")
        self.__pipe.add(self.__pipe_source, self.__pipe_sink)
        gst.element_link_many(self.__pipe_source, self.__pipe_sink)
        
        
    def on(self):

        os.system("amixer -qc0 cset iface=MIXER,name='Input Select' 'ADC'")
        os.system("amixer -qc0 cset iface=MIXER,name='PGA Capture Switch' on")
        os.system("amixer -qc0 cset iface=MIXER,name='Left PGA Mixer Line2L Switch' on")
        os.system("amixer -qc0 cset iface=MIXER,name='Right PGA Mixer Line2R Switch' on")
        
        self.__pipe.set_state(gst.STATE_PLAYING)


    def off(self):
    
        os.system("amixer -qc0 cset iface=MIXER,name='Input Select' 'Digital Mic'")
        os.system("amixer -qc0 cset iface=MIXER,name='PGA Capture Switch' off")
        os.system("amixer -qc0 cset iface=MIXER,name='Left PGA Mixer Line2L Switch' off")
        os.system("amixer -qc0 cset iface=MIXER,name='Left DAC_L1 Mixer HP Switch' off")
        os.system("amixer -qc0 cset iface=MIXER,name='Right PGA Mixer Line2R Switch' off")
        os.system("amixer -qc0 cset iface=MIXER,name='Right DAC_R1 Mixer HP Switch' off")
        os.system("amixer -qc0 cset iface=MIXER,name='HP DAC Playback Volume' 0,0")
    
        self.__pipe.set_state(gst.STATE_NULL)
        
        
    def use_speaker(self, v):
    
        if (v):
            os.system("amixer -qc0 cset iface=MIXER,name='Headphone Playback Volume' 5,5")
            os.system("amixer -qc0 cset iface=MIXER,name='Left DAC_L1 Mixer Line Switch' off")
            os.system("amixer -qc0 cset iface=MIXER,name='Left DAC_L1 Mixer HP Switch' on")
            os.system("amixer -qc0 cset iface=MIXER,name='Right DAC_R1 Mixer Line Switch' off")
            os.system("amixer -qc0 cset iface=MIXER,name='Right DAC_R1 Mixer HP Switch' on")
            os.system("amixer -qc0 cset iface=MIXER,name='HP DAC Playback Volume' 100,100")
            os.system("amixer -qc0 cset iface=MIXER,name='Speaker Function' 1")
            
        else:
            os.system("amixer -qc0 cset iface=MIXER,name='Left DAC_L1 Mixer Line Switch' on")
            os.system("amixer -qc0 cset iface=MIXER,name='Left DAC_L1 Mixer HP Switch' off")
            os.system("amixer -qc0 cset iface=MIXER,name='Right DAC_R1 Mixer Line Switch' on")
            os.system("amixer -qc0 cset iface=MIXER,name='Right DAC_R1 Mixer HP Switch' off")
            os.system("amixer -qc0 cset iface=MIXER,name='HP DAC Playback Volume' 0,0")
            os.system("amixer -qc0 cset iface=MIXER,name='Speaker Function' 0")

