#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-
""" UI for fMMS

@author: Nick Leppänen Larsson <frals@frals.se>
@license: GNU GPL
"""
import gtk
import hildon
import os
import time
from wappushhandler import PushHandler
import locale
import osso
import fmms_config as fMMSconf
import fmms_sender_ui as fMMSSenderUI
import gobject
import dbus

class fMMS_GUI(hildon.Program):

	def __init__(self):
		self.config = fMMSconf.fMMS_config()
		self._mmsdir = self.config.get_mmsdir()
		self._pushdir = self.config.get_pushdir()
	
		if not os.path.isdir(self._mmsdir):
			print "creating dir", self._mmsdir
			os.makedirs(self._mmsdir)
		if not os.path.isdir(self._pushdir):
			print "creating dir", self._pushdir
			os.makedirs(self._pushdir)
	
		hildon.Program.__init__(self)
		program = hildon.Program.get_instance()
		
		self.window = hildon.StackableWindow()
		self.window.set_title("fMMS")
		program.add_window(self.window)
		
		self.window.connect("delete_event", self.quit)
		
		pan = hildon.PannableArea()
		pan.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)
		
		iconcell = gtk.CellRendererPixbuf()
		textcell = gtk.CellRendererText()
		cell2 = gtk.CellRendererText()
		cell2.set_property('xalign', 1.0)
		textcell.set_property('mode', gtk.CELL_RENDERER_MODE_INERT)
		textcell.set_fixed_size(-1, 60)
		
		self.liststore = gtk.ListStore(gtk.gdk.Pixbuf, str, str, str)
		treeview = hildon.GtkTreeView(gtk.HILDON_UI_MODE_EDIT)
		treeview.set_model(self.liststore)

		
		icon_col = gtk.TreeViewColumn('Icon')
		sender_col = gtk.TreeViewColumn('Sender')
		placeholder_col = gtk.TreeViewColumn('Placeholder')
		
		
		self.add_buttons_liststore()
		
		treeview.append_column(icon_col)
		treeview.append_column(sender_col)
		treeview.append_column(placeholder_col)
		
		icon_col.pack_start(iconcell, False)
		icon_col.set_attributes(iconcell, pixbuf=0) 
		sender_col.pack_start(textcell, True)
		sender_col.set_attributes(textcell, markup=1)
		placeholder_col.pack_start(cell2, True)
		placeholder_col.set_attributes(cell2, markup=2)
		
		selection = treeview.get_selection()
		#selection.set_mode(gtk.SELECTION_SINGLE)
		treeview.connect('hildon-row-tapped', self.show_mms)
		
		
		self.treeview = treeview
		pan.add_with_viewport(treeview)
		self.window.add(pan)
	
		self.menu = self.create_menu()
		self.window.set_app_menu(self.menu)
		self.window.show_all()
		self.add_window(self.window)
		
		if self.config.get_firstlaunch() == 1:
			print "firstlaunch"
			self.osso_c = osso.Context("fMMS", "0.1.0", False)
			note = osso.SystemNote(self.osso_c)
			firstlaunchmessage = "NOTE: Currently you have to connect manually to the MMS APN when sending and receiving.\nAlso, only implemented attachment is image."
			note.system_note_dialog(firstlaunchmessage , 'notice')
			self.create_config_dialog()
			self.config.set_firstlaunch(0)
		
	def create_menu(self):
		menu = hildon.AppMenu()
		
		send = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		send.set_label("New MMS")
		send.connect('clicked', self.menu_button_clicked)
		
		config = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		config.set_label("Configuration")
		config.connect('clicked', self.menu_button_clicked)
		
		about = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		about.set_label("About")
		about.connect('clicked', self.menu_button_clicked)
		
		menu.append(send)
		menu.append(config)
		menu.append(about)
		
		menu.show_all()
		
		return menu
		
	def menu_button_clicked(self, button):
		buttontext = button.get_label()
		if buttontext == "Configuration":
			ret = self.create_config_dialog()
		elif buttontext == "New MMS":
			ret = fMMSSenderUI.fMMS_GUI(self.window).run()
		elif buttontext == "About":
			ret = self.create_about_dialog()
		
	def create_about_dialog(self):
		dialog = gtk.AboutDialog()                                                 
		dialog.set_name("fMMS")
		fmms_logo = gtk.gdk.pixbuf_new_from_file("/opt/fmms/fmms.png")
		dialog.set_logo(fmms_logo)                                   
		dialog.set_comments('MMS send and receive support for Fremantle')                      
		dialog.set_version(self.config.get_version())                                                
		dialog.set_copyright("By Nick Leppänen Larsson (aka frals)")                    
		dialog.set_website("http://mms.frals.se/")                                  
		dialog.connect("response", lambda d, r: d.destroy())                      
		dialog.show() 
 
	def create_config_dialog(self):
		dialog = gtk.Dialog()
		dialog.set_title("Configuration")
		
		allVBox = gtk.VBox()
		
		self.active_apn_index = 0
		
		apnHBox = gtk.HBox()
		apn_label = gtk.Label("APN:")
		self.selector = self.create_apn_selector()
		self.apn = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
		self.apn.set_selector(self.selector)
		self.apn.set_active(self.active_apn_index)
		#self.apn.connect("value-changed", self.apn_picker_changed)


		"""self.apn = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
		apn_nicename = self.config.get_apn_nicename()
		if apn_nicename != None:
			self.apn.set_text(self.config.get_apn_nicename())
		else:
			self.apn.set_text("Not defined")"""
		apnHBox.pack_start(apn_label, False, True, 0)
		apnHBox.pack_start(self.apn, True, True, 0)
		
		mmscHBox = gtk.HBox()
		mmsc_label = gtk.Label("MMSC:")
		self.mmsc = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
		mmsc_text = self.config.get_mmsc()
		if mmsc_text != None:	
			self.mmsc.set_text(mmsc_text)
		else:
			self.mmsc.set_text("http://")
		mmscHBox.pack_start(mmsc_label, False, True, 0)
		mmscHBox.pack_start(self.mmsc, True, True, 0)
		
		numberHBox = gtk.HBox()
		number_label = gtk.Label("Your phonenumber:")
		self.number = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
		number_text = self.config.get_phonenumber()
		if number_text != None:
			self.number.set_text(number_text)
		else:
			self.number.set_text("")
		numberHBox.pack_start(number_label, False, True, 0)
		numberHBox.pack_start(self.number, True, True, 0)
		
		imgwidthHBox = gtk.HBox()
		imgwidth_label = gtk.Label("Resize image width:")
		self.imgwidth = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
		imgwidth_text = self.config.get_img_resize_width()
		if imgwidth_text != None:
			self.imgwidth.set_text(str(imgwidth_text))
		else:
			self.imgwidth.set_text("")
		imgwidthHBox.pack_start(imgwidth_label, False, True, 0)
		imgwidthHBox.pack_start(self.imgwidth, True, True, 0)
		
		notelabel = gtk.Label("APN refers to the name of the connection in\n \"Internet Connections\" to use.")
		
		allVBox.pack_start(notelabel, False, True, 0)
		allVBox.pack_start(apnHBox, False, False, 0)
		allVBox.pack_start(mmscHBox, False, False, 0)
		allVBox.pack_end(numberHBox, False, False, 0)
		allVBox.pack_end(imgwidthHBox, False, False, 0)
		
		#save = hildon.GtkButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
		#save.set_label("Save")
		#save.connect('clicked', self.config_menu_button_clicked, apn)
		
		
		#allVBox.pack_end(buttonHBox)
		allVBox.show_all()
		dialog.vbox.add(allVBox)
		dialog.add_button("Save", gtk.RESPONSE_APPLY)
		#dialog.show_all()
		while 1:
			ret = dialog.run()
			ret2 = self.config_menu_button_clicked(ret)
			if ret2 == 0 or ret2 == None: 
				break
			
		dialog.destroy()
		return ret
		
	"""def apn_picker_changed(self, button, user_data=None):
		current_selection = button.get_value()
		print "Current selection : %s" % (current_selection)"""

	def create_apn_selector(self):
		#Create a HildonTouchSelector with a single text column
		selector = hildon.TouchSelector(text = True)
		
		apnlist = self.config.get_gprs_apns()
		
		currval = self.config.get_apn_nicename()
		
		# Populate selector
		i = 0
		for apn in apnlist:
			if apn == currval:
				self.active_apn_index = i
			i += 1	
			# Add item to the column 
			selector.append_text(apn)
			
		selector.center_on_selected()
		selector.set_active(0, i)
		# Set selection mode to allow multiple selection
		selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
		return selector
		
		
	def config_menu_button_clicked(self, action):
		if action == gtk.RESPONSE_APPLY:
			print self.apn.get_selector().get_current_text()
			ret_setapn = self.config.get_apnid_from_name(self.apn.get_selector().get_current_text())
			if ret_setapn != None:
				self.config.set_apn(ret_setapn)
				print "Set apn to: %s" % ret_setapn
				ret = self.config.set_mmsc(self.mmsc.get_text())
				print "Set mmsc to %s" % self.mmsc.get_text()
				self.config.set_phonenumber(self.number.get_text())
				print "Set phonenumber to %s" % self.number.get_text()
				self.config.set_img_resize_width(self.imgwidth.get_text())
				print "Set image width to %s" % self.imgwidth.get_text()
				banner = hildon.hildon_banner_show_information(self.window, "", "Settings saved")
				return 0
			else:
				print "Set mmsc to %s" % self.mmsc.get_text()
				self.config.set_phonenumber(self.number.get_text())
				print "Set phonenumber to %s" % self.number.get_text()
				self.config.set_img_resize_width(self.imgwidth.get_text())
				print "Set image width to %s" % self.imgwidth.get_text()
				banner = hildon.hildon_banner_show_information(self.window, "", "Could not save APN settings. Did you enter a correct APN?")
				banner.set_timeout(5000)
				return -1
		
	""" sorts files based on mtime, newest first """
	def getfiles(self, dirpath):
		a = [s for s in os.listdir(dirpath)]
		a.sort(key=lambda s: os.path.getmtime(os.path.join(dirpath, s)))
		a.reverse()
		return a

	""" add each item to our liststore """
	def add_buttons_liststore(self):
			icon_theme = gtk.icon_theme_get_default()
			
			filelist = self.getfiles(self._pushdir)
			for fname in filelist:
				mtime = time.strftime("%Y-%m-%d | %H:%M", time.localtime(os.path.getmtime(self._pushdir + fname)))
				varlist = self._read_push_as_list(self._pushdir + fname)
				sender = varlist['From']
				sender = sender.replace("/TYPE=PLMN", "")
				#title = sender + " - " + mtime
				if self._is_fetched_push(fname):
					icon = icon_theme.load_icon("general_sms", 48, 0)
				else:
					icon = icon_theme.load_icon("chat_unread_sms", 48, 0)
				self.liststore.append([icon, sender + '  <span foreground="#666666" size="smaller"><sup>' + mtime + '</sup></span>\n<span foreground="#666666" size="x-small">' + fname + '</span>', "placeholder", fname])
	""" lets call it quits! """
	def quit(self, *args):
		gtk.main_quit()

	""" show the selected mms """		
	def show_mms(self, treeview, path):
		model = treeview.get_model()
		miter = model.get_iter(path)
		# the 4th value is the filename (start counting at 0)
		filename = model.get_value(miter, 3)
		
		### ugly workaround to get it show instantly
		bus = dbus.SystemBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.SystemNoteInfoprint ("fMMS: Opening message")
		
		
		gobject.timeout_add(100, self.return_false)
		hildon.hildon_gtk_window_set_progress_indicator(self.window, 1)
		# this is ugly i know, but i really want it to work!
		gobject.timeout_add(50, self.return_false)
		try:
			self.show_new_window(self, filename)
		except:
			pass
		# this is ugly i know, but i really want it to work!
		gobject.timeout_add(50, self.return_false)
		hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)
		
	def return_false(self):
		return False
		
	""" open a new window containing mms specified by fname """		
	def show_new_window(self, widget, fname):
		win = hildon.StackableWindow()
		win.set_title("Showing MMS: " + fname)
	
		vbox = gtk.VBox()
		pan = hildon.PannableArea()
		pan.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)
		
		self._parse_mms(fname, vbox)
		
		pan.add_with_viewport(vbox)
		win.add(pan)
		
		mms_menu = self.create_mms_menu(fname)
		win.set_app_menu(mms_menu)
		win.show_all()

	""" create app menu for mms viewing window """
	def create_mms_menu(self, fname):
		menu = hildon.AppMenu()
		
		headers = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		headers.set_label("Headers")
		headers.connect('clicked', self.mms_menu_button_clicked, fname)
		
		menu.append(headers)
	
		menu.show_all()
		
		return menu
		
	""" actions for mms menu """
	def mms_menu_button_clicked(self, button, fname):
		buttontext = button.get_label()
		if buttontext == "Headers":
			ret = self.create_headers_dialog(fname)

	""" show headers in a dialog """
	def create_headers_dialog(self, fname):
		dialog = gtk.Dialog()
		dialog.set_title("Headers")
		
		dialogVBox = gtk.VBox()
		
		pan = hildon.PannableArea()
		pan.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)
		pan.set_property("size-request-policy", hildon.SIZE_REQUEST_CHILDREN)
		
		allVBox = gtk.VBox()
		
		#print fname
		fullpath = self._mmsdir + "/" + str(fname) + "/headers"
		try: 
			fp = open(fullpath, 'r')
			for line in fp:
				line = line.replace("\n", "")
				label = gtk.Label(line)
				label.set_alignment(0, 0)
				#pan.add(label)
				allVBox.pack_start(label, False, False, 0)
		except:
			pass
			
		allVBox.show_all()
		
		pan.add_with_viewport(allVBox)
		#pan.add(allVBox)
		#dialogVBox.add(pan)
		#dialogVBox.show_all()
		
		#dialog.vbox.add(dialogVBox)
		dialog.vbox.add(pan)
		dialog.vbox.show_all()
		#dialog.show_all()
		ret = dialog.run()
		
		dialog.destroy()
		return ret

	""" this function takes the FILENAME, not the full path """
	def _is_fetched_push(self, filename):
		if os.path.isdir(self._mmsdir + filename):
			if os.path.isfile(self._mmsdir + filename + "/message"):
				return True
		else:
			return False
	
	""" parse mms and push each part to the container 
	    fetches the mms if its not downloaded         """
	# TODO: better file detection/support
	def _parse_mms(self, filename, container):
		if not self._is_fetched_push(filename):
			self._get_mms_from_push(self._pushdir + filename)
				
		textview = gtk.TextView()
		textview.set_editable(False)
		textview.set_cursor_visible(False)
		textbuffer = gtk.TextBuffer()
		path = self._mmsdir + filename
		filelist = os.listdir(path)
		for fname in filelist:
			(name, ext) = os.path.splitext(fname)
			if ext == ".jpg" or ext == ".png":
				#pixbuf = gtk.gdk.pixbuf_new_from_file(path + "/" + fname)
				#textbuffer.insert_pixbuf(textbuffer.get_end_iter(), pixbuf)
				img = gtk.Image()
				img.set_from_file(path + "/" + fname)
				#img.show()
				container.add(img)
			elif ext == ".txt" or ext.startswith(".txt"):
				fp = open(path + "/" + fname, 'r')
				contents = fp.read()
				fp.close()
				#print contents
				textbuffer.insert(textbuffer.get_end_iter(), contents)
				
		textview.set_buffer(textbuffer)
		container.add(textview)
	
	""" reads a saved push message into a dict """
	def _read_push_as_list(self, fname):
		fp = open(fname, 'r')
		pdict = {}
		for line in fp:
			line = line.replace("\n", "")
			lsplit = line.partition(" ")
			pdict[lsplit[0]] = lsplit[2]
		fp.close()
		#print pdict
		return pdict
		
	""" gets a mms from a previously received push """
	def _get_mms_from_push(self, fname):
		plist = self._read_push_as_list(fname)

		sndr = plist['From']
		url = plist['Content-Location']
		print url
		trans_id = plist['Transaction-Id']
		print trans_id
		
		PUSH = PushHandler()
		
		### ugly hack as well
		# TODO: clean up
		bus = dbus.SystemBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.SystemNoteInfoprint ("fMMS: Attempting to download MMS from server.")
		
		path = PUSH._get_mms_message(url, trans_id)
		PUSH.decodeMMS(path)
		
		#PUSH._create_html(path, sndr)
		return 0


	def run(self):
		self.window.show_all()
		gtk.main()
		
if __name__ == "__main__":
	app = fMMS_GUI()
	app.run()