#include "settings.h"
#include "ui_settings.h"

#include <QProcess>
#include <QtCore/QCoreApplication>
#include <QFileInfo>

Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings),

    m_process(new QProcess(this))

{
    ui->setupUi(this);

  // Check for existance of /etc/event.d/relocateswap to draw checkbox correctly
    if ( QFileInfo("/etc/event.d/relocateswap").exists() ) ui->checkBoxEventd->setChecked(true);

}

Settings::~Settings()
{
    delete ui;
}

void Settings::on_checkBoxEventd_clicked()
{
    if (ui->checkBoxEventd->isChecked())
    {
        m_process->start("sudo /opt/flopswap/script/setupstart.sh");
    }
    else
    {
        m_process->start("sudo /opt/flopswap/script/rmupstart.sh");
    }
}


