/* This file is part of "modern computer flatboat", a pdf viewer.
 * Copyright (C) 2012 Frank Fuhlbrück 
 * License: GPLv3 (or any later version, at your option)
 * See the file "LICENSE".
 */

#include "sethist.h"
#include <QtGui/QFileDialog>


SetHist::SetHist(QObject *parent) :
QObject(parent), qs("flatboat","flatboat") {
	documents_prv = qs.value("documentHistory",QVariantList()).toList();
}

SetHist::SetHist(const SetHist& copy) : QObject(copy.parent()), qs("flatboat","flatboat") {
	documents_prv = qs.value("documentHistory",QVariantList()).toList();
}


void SetHist::newDocument(QVariantMap doc){
	int i=0;
	for(;i<documents_prv.length();i++)
		if(doc["filepath"].toString() == documents_prv[i].toMap()["filepath"].toString())
			break;
	
	if(i<documents_prv.length())//in list
		documents_prv.move(i,0);
	else 
		documents_prv.prepend(doc);
	qs.setValue("documentHistory",documents_prv);
}

QVariantList SetHist::documents(){
	return documents_prv;
}

QVariantMap SetHist::curDoc(){
	if(documents_prv.length() > 0)
		return documents_prv[0].toMap();
	else
		return QVariantMap();
}

void SetHist::setCurDoc(QVariantMap doc){
	documents_prv[0] = doc;
	qs.setValue("documentHistory",documents_prv);
}

void SetHist::clearDocuments(){
	QVariantMap doc = documents_prv[0].toMap();
	documents_prv.clear();
	documents_prv.append(doc);
	qs.setValue("documentHistory",documents_prv);
}
#ifdef Q_OS_ANDROID
#define DEFPATH "/mnt/sdcard"
#else
#define DEFPATH QDir::homePath()
#endif
void SetHist::chooseFile(){
	QVariantMap doc;
	QString dir = DEFPATH;
	if(documents_prv.length() > 0){
		QFileInfo lf(documents_prv[0].toMap()["filepath"].toString());
		dir = lf.dir().exists() ? lf.dir().path() : DEFPATH;
	} 
	doc["filepath"] = QFileDialog::getOpenFileName(0, "Select PDF file", dir, "PDF (*.pdf)");
	newDocument(doc);
}