/* This file is part of "modern computer flatboat", a pdf viewer.
 * Copyright (C) 2012 Frank Fuhlbrück 
 * License: GPLv3 (or any later version, at your option)
 * See the file "LICENSE".
 */
import QtQuick 1.0

Rectangle {
	id: splash
	z: 2
	color: "#559900"
	width: splashText.implicitWidth + 30
	height: splashText.implicitHeight + 30
	radius: 10
	anchors.centerIn: parent
	Text {
		id: splashText
		color: "white"
		font.pointSize : 22
		horizontalAlignment: Text.AlignHCenter
		anchors.centerIn: parent
		text: "<a align=center><b>modern computer flatboat</b><br/>a viewer for the<br/><b>portable document format</b></a>"
	}
	Timer {
		interval: 3000;
		running: true;
		onTriggered: splash.visible = false
	}
}