/* This file is part of "modern computer flatboat", a pdf viewer.
 * Copyright (C) 2012 Frank Fuhlbrück 
 * License: GPLv3 (or any later version, at your option)
 * See the file "LICENSE".
 */

#include <QtGui/QApplication>
#include "qmlapplicationviewer.h"
#include "qpdfimage.h"
#include "sethist.h"
#include <QtGui/QImage>
#include <QtGui/QPixmap>
#include <QtGui/QLabel>
#include <QDeclarativeImageProvider>
#include <QDeclarativeEngine>
#include <QDeclarativeContext>
#include <QSettings>
#include <QDebug>
#include <QVariant>

SetHist sethist;

#ifdef Q_WS_MAEMO_5
#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
inline void grabVolKeys(WId wid){
	if (!wid)
		return;
	
	Atom atom = XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", False);
	if (!atom)
		return;
	
	unsigned long data = 1;
	XChangeProperty (QX11Info::display(),wid,atom,
		XA_INTEGER,32,PropModeReplace,
		reinterpret_cast<unsigned char *>(&data),1);
}
#endif

Q_DECL_EXPORT int main(int argc, char *argv[])
{
	qmlRegisterType<QPdfImage>("flatboat.PdfImage", 1, 0, "PdfImage");
	
	QScopedPointer<QApplication> app(createApplication(argc, argv));
	QScopedPointer<QmlApplicationViewer> viewer(QmlApplicationViewer::create());
	app->setOrganizationName("flatboat");
	app->setApplicationName("flatboat");
	
	QStringList args = app->arguments();
	if(args.length() >= 2){
		QString fn = QUrl(args[1]).scheme() == "file" ? QUrl(args[1]).toLocalFile() : args[1];
		QVariantMap doc;
		doc["filepath"] = fn;
		sethist.newDocument(doc);
	}
	
	
	viewer->setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
	viewer->rootContext()->setContextProperty("sethist", &sethist);
	viewer->setSource(QUrl(QLatin1String("qrc:/main.qml")));
	
	QObject::connect((*viewer).rootObject(), SIGNAL(showFullScreen()),
			 viewer.data(), SLOT(showFullScreen()));
	QObject::connect((*viewer).rootObject(), SIGNAL(showNormal()),
			 viewer.data(), SLOT(showNormal()));
	
	
	viewer->setWindowTitle("modern computer flatboat");
	viewer->showExpanded();
	
#ifdef Q_WS_MAEMO_5
	grabVolKeys(viewer->winId());
#endif
	
	return app->exec();
}
