import QtQuick 1.0

Rectangle {
	id: rect
	color: "#889988"
	border.color: lbl.color
	border.width: 1
	property alias text: lbl.text
	property alias pointSize: lbl.font.pointSize
	property bool bstate: state == "active"
	property bool mutex: false
	onMutexChanged:{if(mutex) state = ""}
	signal clicked
	width:  10 + 1.05 * lbl.implicitWidth
	height: 10 + lbl.implicitHeight
	radius: 4
	
	Text {
		id: lbl
		color: "#ffffff"
		text: "Button"
		font.pointSize: 22
		font.weight: Font.DemiBold
		style: Text.Raised
		anchors.verticalCenterOffset: 0
		anchors.horizontalCenterOffset: 1
		anchors.centerIn: parent
	}
	
	MouseArea {
		id : ma
		anchors.fill: parent
		onClicked: rect.clicked()
	}
	
	function toggleState(){
		if(state == "active")
			state = ""
		else
			state = "active"
	}
	
	states: [
	State {
		name: "active"
		PropertyChanges {target: rect; color: "#ffffff"; }
		PropertyChanges {target: lbl; color: "#889988"; }
	}
	]
}
