#! /bin/sh
### BEGIN INIT INFO
# Provides:		flashlight-extra
# Required-Start:	$remote_fs $syslog dbus
# Required-Stop:	$remote_fs $syslog dbus
# Default-Start:	2 3 4 5
# Default-Stop:		0 1 6
# Short-Description:	Flashlight-extra daemon
# Description:		
### END INIT INFO
#
# Startup script for the flashlight-extra.
#
# Contact Person: thecodecentral.com
#



PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/bin/flashlight-extra
NAME=flashlight-extra
DESC="Flashlight-extra Daemon"
INITFILE=/etc/init.d/$NAME
DSMETOOL=/usr/sbin/dsmetool


# abort if no executable exists
test -x $DAEMON || exit 0


#set -e


# only use dsmetool if it exists
test -x $DSMETOOL || USE_DSMETOOL=no


start_d()
{
    if [ x"$USE_DSMETOOL" = xno ]; then
	start-stop-daemon --start --quiet  \
	    --exec $DAEMON
    else
	dsmetool -f "$DAEMON"
    fi
}

stop_d()
{
    if [ x"$USE_DSMETOOL" = xno ]; then
	start-stop-daemon --stop --oknodo --quiet  \
	    $DAEMON
    else
	dsmetool -k "$DAEMON"
    fi
}

case "$1" in
start)
        printf "Starting $DESC: $NAME"
	start_d
        printf ".\n"
        ;;

stop)
        printf "Stopping: $DESC: $NAME"
	stop_d
        printf ".\n"
        ;;

restart|force-reload)
        printf "Restarting $DESC: $NAME"
	stop_d
        sleep 2
	start_d
        printf ".\n"
        ;;

*)
        printf "Usage: $INITFILE {start|stop|restart|force-reload}\n" >&2
        exit 1
        ;;
esac

exit 0
