/* REminiscence - Flashback interpreter
 * Copyright (C) 2005-2007 Gregory Montoir
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "game.h"
#include "resource.h"


const Cutscene::OpcodeStub Cutscene::_opcodeTable[] = {
	/* 0x00 */
	&Cutscene::op_markCurPos,
	&Cutscene::op_refreshScreen,
	&Cutscene::op_waitForSync,
	&Cutscene::op_drawShape,
	/* 0x04 */
	&Cutscene::op_setPalette,
	&Cutscene::op_markCurPos,
	&Cutscene::op_drawStringAtBottom,
	&Cutscene::op_nop,
	/* 0x08 */
	&Cutscene::op_skip3,
	&Cutscene::op_refreshAll,
	&Cutscene::op_drawShapeScale,
	&Cutscene::op_drawShapeScaleRotate,
	/* 0x0C */
	&Cutscene::op_drawCreditsText,
	&Cutscene::op_drawStringAtPos,
	&Cutscene::op_handleKeys
};

const char *Cutscene::_namesTable[] = {
	"DEBUT",
	"OBJET",
	"CARTE",
	"GEN",
	"CHUTE",
	"CODE",
	"DESINTEG",
	"INTRO1",
	"STREM",
	"HOLOSEQ",
	"CARTEID",
	"PONT",
	"ASC",
	"MAP",
	"METRO",
	"MISSIONS",
	"GENMIS",
	"MEMO",
	"TAXI",
	"ACCROCHE",
	"VOYAGE",
	"TELEPORT",
	"LIFT",
	"ESPIONS",
	"LOG",
	"FIN",
	"GENEXP",
	"LOGOS",
	"OVER",
	"SCORE",
	"INTRO2"
};

const uint16 Cutscene::_offsetsTable[] = {
	0x0000, 0x0000, 0x0001, 0x0003, 0x0001, 0x0004, 0xFFFF, 0x0000, 0x0001, 0x0002,
	0x0003, 0x0000, 0x0004, 0x0000, 0xFFFF, 0x0100, 0xFFFF, 0x0000, 0x0006, 0x0000,
	0x0001, 0x0001, 0xFFFF, 0x0000, 0xFFFF, 0x0200, 0x8007, 0x0000, 0x0003, 0x0001,
	0x0001, 0x000B, 0x0001, 0x0005, 0x0009, 0x0000, 0x0001, 0x0006, 0xFFFF, 0x0000,
	0x000B, 0x0000, 0x0001, 0x000A, 0xFFFF, 0x0001, 0xFFFF, 0x0002, 0xFFFF, 0x0000,
	0x000D, 0x0004, 0x000D, 0x0000, 0x000D, 0x0001, 0x000D, 0x0002, 0x000D, 0x0003,
	0xFFFF, 0x0000, 0xFFFF, 0x0001, 0x0001, 0x000C, 0x0001, 0x000D, 0x0001, 0x000E,
	0x0001, 0x000F, 0x0001, 0x0010, 0x000F, 0x0000, 0x000F, 0x0001, 0x000F, 0x0001,
	0x000F, 0x0003, 0x000F, 0x0002, 0x000F, 0x0004, 0x0001, 0x0008, 0x0001, 0x0007,
	0x000F, 0x0005, 0xFFFF, 0x0000, 0x0004, 0x0001, 0x0011, 0x0000, 0x0001, 0x0009,
	0x0012, 0x0000, 0xFFFF, 0x0000, 0x0014, 0x0000, 0x0015, 0x0000, 0x0016, 0x0000,
	0x0016, 0x0001, 0xFFFF, 0x0012, 0x0017, 0x0000, 0x0001, 0x0011, 0x0018, 0x0000,
	0x0001, 0x0013, 0x0019, 0x0000, 0x001A, 0x0000, 0x0019, 0x0001, 0x001B, 0x0000,
	0x001C, 0x0000, 0x000F, 0x0006, 0x000F, 0x0006, 0x000F, 0x0007, 0x000F, 0x0008,
	0x000F, 0x0009, 0x000F, 0x000A, 0x001D, 0x0000, 0x001B, 0x0001, 0x001E, 0x0000,
	0xFFFF, 0x0000
};

const uint16 Cutscene::_cosTable[] = {
	0x0100, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FE, 0x00FE,
	0x00FD, 0x00FC, 0x00FC, 0x00FB, 0x00FA, 0x00F9, 0x00F8, 0x00F7,
	0x00F6, 0x00F4, 0x00F3, 0x00F2, 0x00F0, 0x00EE, 0x00ED, 0x00EB,
	0x00E9, 0x00E8, 0x00E6, 0x00E4, 0x00E2, 0x00DF, 0x00DD, 0x00DB,
	0x00D9, 0x00D6, 0x00D4, 0x00D1, 0x00CF, 0x00CC, 0x00C9, 0x00C6,
	0x00C4, 0x00C1, 0x00BE, 0x00BB, 0x00B8, 0x00B5, 0x00B1, 0x00AE,
	0x00AB, 0x00A7, 0x00A4, 0x00A1, 0x009D, 0x009A, 0x0096, 0x0092,
	0x008F, 0x008B, 0x0087, 0x0083, 0x007F, 0x007C, 0x0078, 0x0074,
	0x0070, 0x006C, 0x0068, 0x0064, 0x005F, 0x005B, 0x0057, 0x0053,
	0x004F, 0x004A, 0x0046, 0x0042, 0x003D, 0x0039, 0x0035, 0x0030,
	0x002C, 0x0028, 0x0023, 0x001F, 0x001A, 0x0016, 0x0011, 0x000D,
	0x0008, 0x0004, 0x0000, 0xFFFC, 0xFFF8, 0xFFF3, 0xFFEF, 0xFFEA,
	0xFFE6, 0xFFE1, 0xFFDD, 0xFFD8, 0xFFD4, 0xFFD0, 0xFFCB, 0xFFC7,
	0xFFC3, 0xFFBE, 0xFFBA, 0xFFB6, 0xFFB1, 0xFFAD, 0xFFA9, 0xFFA5,
	0xFFA1, 0xFF9C, 0xFF98, 0xFF94, 0xFF90, 0xFF8C, 0xFF88, 0xFF84,
	0xFF80, 0xFF7D, 0xFF79, 0xFF75, 0xFF71, 0xFF6E, 0xFF6A, 0xFF66,
	0xFF63, 0xFF5F, 0xFF5C, 0xFF59, 0xFF55, 0xFF52, 0xFF4F, 0xFF4B,
	0xFF48, 0xFF45, 0xFF42, 0xFF3F, 0xFF3C, 0xFF3A, 0xFF37, 0xFF34,
	0xFF31, 0xFF2F, 0xFF2C, 0xFF2A, 0xFF27, 0xFF25, 0xFF23, 0xFF21,
	0xFF1E, 0xFF1C, 0xFF1A, 0xFF18, 0xFF17, 0xFF15, 0xFF13, 0xFF12,
	0xFF10, 0xFF0E, 0xFF0D, 0xFF0C, 0xFF0A, 0xFF09, 0xFF08, 0xFF07,
	0xFF06, 0xFF05, 0xFF04, 0xFF04, 0xFF03, 0xFF02, 0xFF02, 0xFF01,
	0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF00, 0xFF01, 0xFF01, 0xFF01,
	0xFF01, 0xFF01, 0xFF02, 0xFF02, 0xFF03, 0xFF04, 0xFF04, 0xFF05,
	0xFF06, 0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFF0C, 0xFF0D, 0xFF0E,
	0xFF10, 0xFF12, 0xFF13, 0xFF15, 0xFF17, 0xFF18, 0xFF1A, 0xFF1C,
	0xFF1E, 0xFF21, 0xFF23, 0xFF25, 0xFF27, 0xFF2A, 0xFF2C, 0xFF2F,
	0xFF31, 0xFF34, 0xFF37, 0xFF3A, 0xFF3C, 0xFF3F, 0xFF42, 0xFF45,
	0xFF48, 0xFF4B, 0xFF4F, 0xFF52, 0xFF55, 0xFF59, 0xFF5C, 0xFF5F,
	0xFF63, 0xFF66, 0xFF6A, 0xFF6E, 0xFF71, 0xFF75, 0xFF79, 0xFF7D,
	0xFF81, 0xFF84, 0xFF88, 0xFF8C, 0xFF90, 0xFF94, 0xFF98, 0xFF9C,
	0xFFA1, 0xFFA5, 0xFFA9, 0xFFAD, 0xFFB1, 0xFFB6, 0xFFBA, 0xFFBE,
	0xFFC3, 0xFFC7, 0xFFCB, 0xFFD0, 0xFFD4, 0xFFD8, 0xFFDD, 0xFFE1,
	0xFFE6, 0xFFEA, 0xFFEF, 0xFFF3, 0xFFF8, 0xFFFC, 0x0000, 0x0004,
	0x0008, 0x000D, 0x0011, 0x0016, 0x001A, 0x001F, 0x0023, 0x0028,
	0x002C, 0x0030, 0x0035, 0x0039, 0x003D, 0x0042, 0x0046, 0x004A,
	0x004F, 0x0053, 0x0057, 0x005B, 0x005F, 0x0064, 0x0068, 0x006C,
	0x0070, 0x0074, 0x0078, 0x007C, 0x0080, 0x0083, 0x0087, 0x008B,
	0x008F, 0x0092, 0x0096, 0x009A, 0x009D, 0x00A1, 0x00A4, 0x00A7,
	0x00AB, 0x00AE, 0x00B1, 0x00B5, 0x00B8, 0x00BB, 0x00BE, 0x00C1,
	0x00C4, 0x00C6, 0x00C9, 0x00CC, 0x00CF, 0x00D1, 0x00D4, 0x00D6,
	0x00D9, 0x00DB, 0x00DD, 0x00DF, 0x00E2, 0x00E4, 0x00E6, 0x00E8,
	0x00E9, 0x00EB, 0x00ED, 0x00EE, 0x00F0, 0x00F2, 0x00F3, 0x00F4,
	0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FC,
	0x00FD, 0x00FE, 0x00FE, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF
};

const uint16 Cutscene::_sinTable[] = {
	0x0000, 0x0004, 0x0008, 0x000D, 0x0011, 0x0016, 0x001A, 0x001F,
	0x0023, 0x0028, 0x002C, 0x0030, 0x0035, 0x0039, 0x003D, 0x0042,
	0x0046, 0x004A, 0x004F, 0x0053, 0x0057, 0x005B, 0x005F, 0x0064,
	0x0068, 0x006C, 0x0070, 0x0074, 0x0078, 0x007C, 0x007F, 0x0083,
	0x0087, 0x008B, 0x008F, 0x0092, 0x0096, 0x009A, 0x009D, 0x00A1,
	0x00A4, 0x00A7, 0x00AB, 0x00AE, 0x00B1, 0x00B5, 0x00B8, 0x00BB,
	0x00BE, 0x00C1, 0x00C4, 0x00C6, 0x00C9, 0x00CC, 0x00CF, 0x00D1,
	0x00D4, 0x00D6, 0x00D9, 0x00DB, 0x00DD, 0x00DF, 0x00E2, 0x00E4,
	0x00E6, 0x00E8, 0x00E9, 0x00EB, 0x00ED, 0x00EE, 0x00F0, 0x00F2,
	0x00F3, 0x00F4, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB,
	0x00FC, 0x00FC, 0x00FD, 0x00FE, 0x00FE, 0x00FF, 0x00FF, 0x00FF,
	0x00FF, 0x00FF, 0x0100, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF,
	0x00FE, 0x00FE, 0x00FD, 0x00FC, 0x00FC, 0x00FB, 0x00FA, 0x00F9,
	0x00F8, 0x00F7, 0x00F6, 0x00F4, 0x00F3, 0x00F2, 0x00F0, 0x00EE,
	0x00ED, 0x00EB, 0x00E9, 0x00E8, 0x00E6, 0x00E4, 0x00E2, 0x00DF,
	0x00DD, 0x00DB, 0x00D9, 0x00D6, 0x00D4, 0x00D1, 0x00CF, 0x00CC,
	0x00C9, 0x00C6, 0x00C4, 0x00C1, 0x00BE, 0x00BB, 0x00B8, 0x00B5,
	0x00B1, 0x00AE, 0x00AB, 0x00A7, 0x00A4, 0x00A1, 0x009D, 0x009A,
	0x0096, 0x0092, 0x008F, 0x008B, 0x0087, 0x0083, 0x007F, 0x007C,
	0x0078, 0x0074, 0x0070, 0x006C, 0x0068, 0x0064, 0x005F, 0x005B,
	0x0057, 0x0053, 0x004F, 0x004A, 0x0046, 0x0042, 0x003D, 0x0039,
	0x0035, 0x0030, 0x002C, 0x0028, 0x0023, 0x001F, 0x001A, 0x0016,
	0x0011, 0x000D, 0x0008, 0x0004, 0x0000, 0xFFFC, 0xFFF8, 0xFFF3,
	0xFFEF, 0xFFEA, 0xFFE6, 0xFFE1, 0xFFDD, 0xFFD8, 0xFFD4, 0xFFD0,
	0xFFCB, 0xFFC7, 0xFFC3, 0xFFBE, 0xFFBA, 0xFFB6, 0xFFB1, 0xFFAD,
	0xFFA9, 0xFFA5, 0xFFA1, 0xFF9C, 0xFF98, 0xFF94, 0xFF90, 0xFF8C,
	0xFF88, 0xFF84, 0xFF80, 0xFF7D, 0xFF79, 0xFF75, 0xFF71, 0xFF6E,
	0xFF6A, 0xFF66, 0xFF63, 0xFF5F, 0xFF5C, 0xFF59, 0xFF55, 0xFF52,
	0xFF4F, 0xFF4B, 0xFF48, 0xFF45, 0xFF42, 0xFF3F, 0xFF3C, 0xFF3A,
	0xFF37, 0xFF34, 0xFF31, 0xFF2F, 0xFF2C, 0xFF2A, 0xFF27, 0xFF25,
	0xFF23, 0xFF21, 0xFF1E, 0xFF1C, 0xFF1A, 0xFF18, 0xFF17, 0xFF15,
	0xFF13, 0xFF12, 0xFF10, 0xFF0E, 0xFF0D, 0xFF0C, 0xFF0A, 0xFF09,
	0xFF08, 0xFF07, 0xFF06, 0xFF05, 0xFF04, 0xFF04, 0xFF03, 0xFF02,
	0xFF02, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF00, 0xFF01,
	0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF02, 0xFF02, 0xFF03, 0xFF04,
	0xFF04, 0xFF05, 0xFF06, 0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFF0C,
	0xFF0D, 0xFF0E, 0xFF10, 0xFF12, 0xFF13, 0xFF15, 0xFF17, 0xFF18,
	0xFF1A, 0xFF1C, 0xFF1E, 0xFF21, 0xFF23, 0xFF25, 0xFF27, 0xFF2A,
	0xFF2C, 0xFF2F, 0xFF31, 0xFF34, 0xFF37, 0xFF3A, 0xFF3C, 0xFF3F,
	0xFF42, 0xFF45, 0xFF48, 0xFF4B, 0xFF4F, 0xFF52, 0xFF55, 0xFF59,
	0xFF5C, 0xFF5F, 0xFF63, 0xFF66, 0xFF6A, 0xFF6E, 0xFF71, 0xFF75,
	0xFF79, 0xFF7D, 0xFF81, 0xFF84, 0xFF88, 0xFF8C, 0xFF90, 0xFF94,
	0xFF98, 0xFF9C, 0xFFA1, 0xFFA5, 0xFFA9, 0xFFAD, 0xFFB1, 0xFFB6,
	0xFFBA, 0xFFBE, 0xFFC3, 0xFFC7, 0xFFCB, 0xFFD0, 0xFFD4, 0xFFD8,
	0xFFDD, 0xFFE1, 0xFFE6, 0xFFEA, 0xFFEF, 0xFFF3, 0xFFF8, 0xFFFC
};

const uint8 Cutscene::_creditsData[] = {
	0xFE, 0x14, 0x00, 0x01, 0x00, 0x04, 0x20, 0x20, 0x54, 0x68, 0x65, 0x20, 0x46, 0x6C, 0x61, 0x73,
	0x68, 0x42, 0x61, 0x63, 0x6B, 0x20, 0x54, 0x65, 0x61, 0x6D, 0x20, 0x69, 0x73, 0x2E, 0x2E, 0x2E,
	0xFE, 0x32, 0xFE, 0x14, 0x00, 0x01, 0x00, 0x07, 0x00, 0x01, 0x00, 0x05, 0x20, 0x20, 0x49, 0x6E,
	0x69, 0x74, 0x69, 0x61, 0x6C, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72,
	0x6F, 0x67, 0x72, 0x61, 0x6D, 0x6D, 0x65, 0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x42, 0x65, 0x6E, 0x6F, 0x69,
	0x73, 0x74, 0x20, 0x41, 0x72, 0x6F, 0x6E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x68, 0x69, 0x6C,
	0x69, 0x70, 0x70, 0x65, 0x20, 0x43, 0x68, 0x61, 0x73, 0x74, 0x65, 0x6C, 0x20, 0x20, 0x20, 0x7C,
	0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20,
	0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x46, 0x72, 0x65, 0x64, 0x65, 0x72, 0x69, 0x63, 0x20, 0x53, 0x61, 0x76, 0x6F, 0x69, 0x72, 0x20,
	0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x05, 0x20, 0x20, 0x47, 0x72,
	0x61, 0x70, 0x68, 0x69, 0x63, 0x20, 0x41, 0x72, 0x74, 0x69, 0x73, 0x74, 0x73, 0x3A, 0x7C, 0x7C,
	0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50,
	0x61, 0x74, 0x72, 0x69, 0x63, 0x6B, 0x20, 0x44, 0x61, 0x68, 0x65, 0x72, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x4C, 0x65, 0x76, 0x61, 0x73, 0x74, 0x72,
	0x65, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63, 0x69,
	0x65, 0x72, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72,
	0x72, 0x65, 0x61, 0x75, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61, 0x6E, 0x20, 0x52,
	0x6F, 0x62, 0x65, 0x72, 0x74, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65,
	0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E,
	0x00, 0x01, 0x00, 0x07, 0x20, 0x20, 0x50, 0x43, 0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E,
	0x20, 0x50, 0x72, 0x6F, 0x67, 0x72, 0x61, 0x6D, 0x6D, 0x65, 0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE,
	0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x68, 0x69,
	0x6C, 0x69, 0x70, 0x70, 0x65, 0x20, 0x43, 0x68, 0x61, 0x73, 0x74, 0x65, 0x6C, 0x20, 0x20, 0x20,
	0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20,
	0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x47, 0x61, 0x65, 0x72, 0x74, 0x68,
	0x6E, 0x65, 0x72, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x6C, 0x61, 0x69, 0x6E, 0x20, 0x52, 0x61, 0x6D, 0x6F,
	0x6E, 0x64, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0xB4, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x05, 0x20,
	0x20, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x43, 0x20, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x7C, 0x7C, 0xFE, 0x1E,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69,
	0x65, 0x72, 0x72, 0x79, 0x20, 0x4C, 0x65, 0x76, 0x61, 0x73, 0x74, 0x72, 0x65, 0x20, 0x20, 0x7C,
	0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63, 0x69, 0x65, 0x72, 0x20, 0x20,
	0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72, 0x72, 0x65, 0x61, 0x75,
	0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x05, 0x20, 0x20, 0x53, 0x74,
	0x6F, 0x72, 0x79, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69,
	0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x05,
	0x20, 0x20, 0x4C, 0x65, 0x76, 0x65, 0x6C, 0x20, 0x44, 0x65, 0x73, 0x69, 0x67, 0x6E, 0x3A, 0x7C,
	0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20,
	0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69, 0x63, 0x6B, 0x20, 0x44, 0x61, 0x68, 0x65, 0x72, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63,
	0x69, 0x65, 0x72, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x72, 0x65, 0x64, 0x65, 0x72, 0x69, 0x63, 0x20, 0x53, 0x61,
	0x76, 0x6F, 0x69, 0x72, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65, 0x20,
	0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00,
	0x01, 0x00, 0x05, 0x20, 0x20, 0x4D, 0x75, 0x73, 0x69, 0x63, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4A,
	0x65, 0x61, 0x6E, 0x20, 0x42, 0x61, 0x75, 0x64, 0x6C, 0x6F, 0x74, 0x20, 0x20, 0x20, 0x7C, 0xFE,
	0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61,
	0x62, 0x72, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20,
	0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x08, 0x20, 0x20, 0x53, 0x6F, 0x75, 0x6E, 0x64,
	0x20, 0x66, 0x78, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x42, 0x65, 0x6E, 0x6F, 0x69, 0x73, 0x74, 0x20, 0x41, 0x72, 0x6F,
	0x6E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x68, 0x69, 0x6C, 0x69, 0x70, 0x70, 0x65, 0x20, 0x43,
	0x68, 0x61, 0x73, 0x74, 0x65, 0x6C, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C,
	0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69,
	0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x50,
	0xFE, 0x1E, 0x00, 0x01, 0x00, 0x06, 0x20, 0x20, 0x41, 0x63, 0x74, 0x6F, 0x72, 0x73, 0x3A, 0x7C,
	0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x42, 0x65, 0x6E, 0x6F, 0x69, 0x73, 0x74, 0x20, 0x41, 0x72, 0x6F, 0x6E, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69, 0x63, 0x6B, 0x20, 0x44, 0x61, 0x68, 0x65, 0x72, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x4C, 0x65, 0x76, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65,
	0x72, 0x63, 0x69, 0x65, 0x72, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20,
	0x50, 0x65, 0x72, 0x72, 0x65, 0x61, 0x75, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61,
	0x6E, 0x20, 0x52, 0x6F, 0x62, 0x65, 0x72, 0x74, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72,
	0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE,
	0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x06, 0x20, 0x20, 0x53, 0x74, 0x75, 0x6E, 0x74, 0x6D, 0x61,
	0x6E, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20, 0x4D, 0x65, 0x72, 0x63, 0x69,
	0x65, 0x72, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x06, 0x20, 0x20,
	0x56, 0x69, 0x64, 0x65, 0x6F, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6F, 0x72, 0x73, 0x3A,
	0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x50, 0x61, 0x74, 0x72, 0x69, 0x63, 0x6B, 0x20, 0x44, 0x61, 0x68, 0x65, 0x72, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72, 0x72, 0x65,
	0x61, 0x75, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73,
	0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x06,
	0x20, 0x20, 0x56, 0x69, 0x64, 0x65, 0x6F, 0x20, 0x43, 0x6F, 0x2D, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6F, 0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x4C, 0x65,
	0x76, 0x61, 0x73, 0x74, 0x72, 0x65, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6E, 0x69, 0x73, 0x20,
	0x4D, 0x65, 0x72, 0x63, 0x69, 0x65, 0x72, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61,
	0x6E, 0x20, 0x52, 0x6F, 0x62, 0x65, 0x72, 0x74, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE,
	0x1E, 0x00, 0x01, 0x00, 0x06, 0x20, 0x20, 0x56, 0x69, 0x64, 0x65, 0x6F, 0x20, 0x73, 0x66, 0x78,
	0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65,
	0x74, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x54, 0x68, 0x69, 0x65, 0x72, 0x72, 0x79, 0x20, 0x50, 0x65, 0x72, 0x72,
	0x65, 0x61, 0x75, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x46, 0x61, 0x62, 0x72, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69,
	0x73, 0x73, 0x65, 0x72, 0x6F, 0x74, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00,
	0x07, 0x20, 0x20, 0x54, 0x65, 0x73, 0x74, 0x65, 0x72, 0x73, 0x3A, 0x7C, 0x7C, 0xFE, 0x1E, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50,
	0x68, 0x69, 0x6C, 0x20, 0x42, 0x72, 0x61, 0x64, 0x6C, 0x65, 0x79, 0x20, 0x20, 0x20, 0x7C, 0xFE,
	0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x74,
	0x72, 0x69, 0x63, 0x69, 0x61, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x20,
	0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x53, 0x69, 0x6D, 0x6F, 0x6E, 0x20, 0x48, 0x61, 0x64, 0x6C, 0x69, 0x6E, 0x67, 0x74,
	0x6F, 0x6E, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x44, 0x61, 0x6E, 0x69, 0x65, 0x6C, 0x20, 0x4C, 0x6C, 0x65, 0x77, 0x65, 0x6C,
	0x6C, 0x79, 0x6E, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x4A, 0x65, 0x61, 0x6E, 0x2D, 0x50, 0x69, 0x65, 0x72, 0x72, 0x65, 0x20, 0x4C, 0x75, 0x63, 0x6B,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4D, 0x61, 0x72, 0x74, 0x69, 0x6E, 0x20, 0x53, 0x6D,
	0x69, 0x74, 0x68, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00,
	0x08, 0x20, 0x20, 0x4D, 0x61, 0x6E, 0x79, 0x20, 0x74, 0x68, 0x61, 0x6E, 0x6B, 0x73, 0x20, 0x74,
	0x6F, 0x2E, 0x2E, 0x2E, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4C, 0x6F, 0x72, 0x69, 0x20, 0x43, 0x68, 0x72, 0x69,
	0x73, 0x74, 0x65, 0x6E, 0x73, 0x65, 0x6E, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x61, 0x74, 0x72, 0x69, 0x63, 0x69, 0x61, 0x20, 0x43, 0x75,
	0x69, 0x73, 0x73, 0x65, 0x74, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x6E, 0x6E, 0x65, 0x2D, 0x4D, 0x61, 0x72, 0x69, 0x65, 0x20,
	0x4A, 0x6F, 0x61, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4A, 0x65, 0x61, 0x6E, 0x2D, 0x50, 0x69, 0x65, 0x72, 0x72,
	0x65, 0x20, 0x4C, 0x75, 0x63, 0x6B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4D,
	0x61, 0x72, 0x63, 0x20, 0x4D, 0x69, 0x6E, 0x69, 0x65, 0x72, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C,
	0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00, 0x05, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x20, 0x62, 0x79, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x50, 0x61, 0x75, 0x6C, 0x20, 0x43, 0x75, 0x69, 0x73, 0x73, 0x65, 0x74, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0x1E, 0x00, 0x01, 0x00,
	0x03, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x72, 0x6F, 0x64, 0x75,
	0x63, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x7C, 0x7C, 0xFE, 0x1E, 0x20, 0x7C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x65, 0x6C,
	0x70, 0x68, 0x69, 0x6E, 0x65, 0x20, 0x53, 0x6F, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x55, 0x53, 0x20, 0x47, 0x4F, 0x4C, 0x44, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x1E, 0x20, 0x7C, 0x20, 0x7C,
	0x20, 0x7C, 0x20, 0x7C, 0x20, 0x7C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x28, 0x63, 0x29, 0x4D, 0x43, 0x4D, 0x58, 0x43, 0x49, 0x49, 0x49, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7C, 0xFE, 0x50, 0xFE, 0xFF, 0x00, 0xFF
};

const uint16 Cutscene::_creditsCutSeq[] =  {
	0x00, 0x05, 0x2F, 0x32, 0x36, 0x3E, 0x30, 0x39, 0x3F, 0x14, 0x34, 0xFFFF
};

const uint8 Cutscene::_musicTable[] = {
	0x10, 0x15, 0x15, 0xFF, 0x15, 0x19, 0x0F, 0xFF, 0x15, 0x04, 0x15, 0xFF, 0xFF, 0x00, 0x19, 0x15,
	0x15, 0x0D, 0x15, 0x0D, 0x18, 0x13, 0xFF, 0xFF, 0xFF, 0x14, 0x14, 0x14, 0x14, 0x14, 0xFF, 0xFF,
	0x13, 0x13, 0x13, 0x13, 0x15, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x13, 0x11, 0xFF, 0x03,
	0x0E, 0x13, 0x12, 0xFF, 0x06, 0x07, 0x0A, 0x0A, 0x15, 0x05, 0x13, 0x02, 0x15, 0x09, 0x17, 0x08,
	0x0B, 0x0C, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0xFF, 0xFF, 0xFF
};

const uint8 Cutscene::_protectionShapeData[] = {
	0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x06, 0xD4, 0x00, 0x00, 0x00, 0x92,
	0x00, 0x00, 0x08, 0x24, 0x00, 0x00, 0x00, 0x02, 0x00, 0x28, 0x00, 0x54, 0x00, 0x8C, 0x00, 0xB2,
	0x00, 0xDE, 0x01, 0x21, 0x01, 0x54, 0x01, 0x7B, 0x01, 0x9D, 0x01, 0xC2, 0x01, 0xF0, 0x02, 0x2C,
	0x02, 0x66, 0x02, 0x9F, 0x02, 0xBF, 0x02, 0xF7, 0x03, 0x35, 0x03, 0x75, 0x03, 0xA4, 0x03, 0xFE,
	0x04, 0x3B, 0x04, 0x7B, 0x04, 0xB6, 0x04, 0xF8, 0x05, 0x3B, 0x05, 0x66, 0x05, 0x9E, 0x05, 0xD2,
	0x06, 0x10, 0x00, 0x00, 0x0F, 0xFF, 0x02, 0x22, 0x03, 0x33, 0x04, 0x44, 0x05, 0x55, 0x06, 0x66,
	0x07, 0x77, 0x08, 0x88, 0x09, 0x99, 0x0A, 0xAA, 0x0B, 0xBB, 0x0C, 0xCC, 0x0D, 0xDD, 0x0E, 0xEE,
	0x0F, 0xFF, 0x00, 0x00, 0x04, 0x05, 0x05, 0x05, 0x00, 0x00, 0x04, 0x44, 0x05, 0x55, 0x06, 0x66,
	0x07, 0x77, 0x08, 0x88, 0x09, 0x99, 0x0A, 0xAA, 0x0B, 0xBB, 0x0C, 0xCC, 0x0D, 0xDD, 0x0E, 0xEE,
	0x0F, 0xFF, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x02, 0x00, 0x01, 0x01, 0x00, 0x02, 0x02, 0x00,
	0x03, 0x01, 0x00, 0x04, 0x02, 0x00, 0x05, 0x01, 0x00, 0x06, 0x02, 0x00, 0x07, 0x02, 0x00, 0x08,
	0x02, 0x00, 0x09, 0x01, 0x00, 0x0A, 0x02, 0x00, 0x0B, 0x02, 0x00, 0x0A, 0x00, 0x0C, 0x02, 0x00,
	0x0D, 0x01, 0x00, 0x0E, 0x02, 0x00, 0x0F, 0x01, 0x80, 0x0A, 0x00, 0x61, 0x00, 0x00, 0x02, 0x00,
	0x10, 0x01, 0x80, 0x02, 0xFF, 0xC9, 0xFF, 0xFF, 0x02, 0x80, 0x04, 0xFF, 0xB1, 0xFF, 0xFF, 0x02,
	0x00, 0x11, 0x01, 0x00, 0x12, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x02, 0x80, 0x0D, 0x00, 0x00, 0x00,
	0x0E, 0x01, 0x80, 0x0E, 0x00, 0x00, 0x00, 0x0E, 0x02, 0x00, 0x13, 0x01, 0x00, 0x14, 0x02, 0x00,
	0x15, 0x01, 0x00, 0x16, 0x02, 0x80, 0x0B, 0xFF, 0xEE, 0x00, 0x4C, 0x02, 0x00, 0x17, 0x01, 0x00,
	0x18, 0x01, 0x00, 0x19, 0x02, 0x00, 0x1A, 0x02, 0x00, 0x1B, 0x02, 0x00, 0x1C, 0x02, 0x00, 0x08,
	0x00, 0x00, 0x02, 0x00, 0x18, 0x01, 0x00, 0x19, 0x02, 0x80, 0x0D, 0x00, 0x00, 0x00, 0x46, 0x01,
	0x80, 0x0E, 0x00, 0x00, 0x00, 0x46, 0x02, 0x00, 0x1D, 0x01, 0x00, 0x1E, 0x02, 0x80, 0x0B, 0x00,
	0x08, 0x00, 0x4D, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x02, 0x00, 0x1F, 0x01, 0x00, 0x20, 0x02, 0x00,
	0x21, 0x02, 0x00, 0x22, 0x02, 0x00, 0x23, 0x01, 0x00, 0x24, 0x02, 0x00, 0x25, 0x01, 0x00, 0x26,
	0x01, 0x00, 0x27, 0x02, 0x00, 0x28, 0x01, 0x00, 0x29, 0x02, 0x00, 0x2A, 0x01, 0x00, 0x2B, 0x01,
	0x00, 0x0F, 0x00, 0x00, 0x02, 0x00, 0x2C, 0x01, 0x00, 0x2D, 0x01, 0x00, 0x2E, 0x02, 0x00, 0x2F,
	0x01, 0x00, 0x30, 0x02, 0x80, 0x18, 0x00, 0x00, 0x00, 0x7F, 0x01, 0x80, 0x19, 0x00, 0x00, 0x00,
	0x7F, 0x02, 0x80, 0x0A, 0x00, 0x03, 0xFF, 0xB2, 0x01, 0x80, 0x0A, 0x00, 0x03, 0xFF, 0xDB, 0x01,
	0x00, 0x31, 0x01, 0x00, 0x32, 0x01, 0x00, 0x33, 0x01, 0x80, 0x31, 0x00, 0x10, 0x00, 0x22, 0x02,
	0x00, 0x34, 0x02, 0x00, 0x0F, 0x00, 0x00, 0x02, 0x00, 0x14, 0x02, 0x00, 0x15, 0x01, 0x00, 0x16,
	0x02, 0x80, 0x0B, 0xFF, 0xEE, 0x00, 0x4C, 0x02, 0x00, 0x18, 0x01, 0x00, 0x19, 0x02, 0x00, 0x25,
	0x01, 0x00, 0x26, 0x01, 0x00, 0x27, 0x02, 0x00, 0x28, 0x01, 0x00, 0x29, 0x02, 0x00, 0x2A, 0x01,
	0x00, 0x35, 0x01, 0x00, 0x36, 0x02, 0x00, 0x0B, 0x00, 0x00, 0x02, 0x00, 0x37, 0x01, 0x00, 0x38,
	0x02, 0x00, 0x39, 0x01, 0x00, 0x3A, 0x02, 0x00, 0x3B, 0x02, 0x80, 0x28, 0xFF, 0xC8, 0x00, 0x0B,
	0x01, 0x00, 0x3C, 0x02, 0x00, 0x3D, 0x01, 0x00, 0x3E, 0x01, 0x00, 0x3F, 0x02, 0x00, 0x08, 0x00,
	0x00, 0x02, 0x00, 0x40, 0x01, 0x00, 0x41, 0x02, 0x00, 0x42, 0x01, 0x80, 0x2D, 0x00, 0x00, 0x00,
	0x7E, 0x01, 0x80, 0x2E, 0x00, 0x00, 0x00, 0x36, 0x02, 0x00, 0x43, 0x01, 0x00, 0x44, 0x02, 0x00,
	0x09, 0x00, 0x00, 0x02, 0x00, 0x45, 0x01, 0x00, 0x46, 0x02, 0x00, 0x47, 0x01, 0x00, 0x48, 0x02,
	0x00, 0x49, 0x01, 0x80, 0x2D, 0xFF, 0xDA, 0x00, 0x7D, 0x01, 0x80, 0x2E, 0xFF, 0xE5, 0x00, 0x36,
	0x02, 0x00, 0x4A, 0x01, 0x00, 0x0C, 0x00, 0x00, 0x02, 0x00, 0x25, 0x01, 0x00, 0x26, 0x01, 0x00,
	0x27, 0x02, 0x00, 0x28, 0x01, 0x00, 0x29, 0x02, 0x00, 0x2A, 0x01, 0x00, 0x10, 0x01, 0x80, 0x02,
	0xFF, 0xC9, 0xFF, 0xFF, 0x02, 0x80, 0x04, 0xFF, 0xB1, 0xFF, 0xFF, 0x02, 0x00, 0x11, 0x01, 0x00,
	0x12, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x02, 0x00, 0x4B, 0x01, 0x00, 0x4C, 0x02, 0x80, 0x14, 0x00,
	0x34, 0xFF, 0xDF, 0x02, 0x00, 0x4D, 0x01, 0x00, 0x4E, 0x02, 0x00, 0x4F, 0x01, 0x00, 0x50, 0x02,
	0x00, 0x51, 0x02, 0x00, 0x52, 0x02, 0x80, 0x18, 0x00, 0x7F, 0x00, 0x7F, 0x01, 0x80, 0x19, 0x00,
	0x7F, 0x00, 0x7F, 0x02, 0x00, 0x53, 0x03, 0x80, 0x2B, 0xFF, 0xF9, 0x00, 0x05, 0x01, 0x00, 0x0C,
	0x00, 0x00, 0x02, 0x00, 0x40, 0x01, 0x00, 0x41, 0x02, 0x00, 0x54, 0x01, 0x80, 0x38, 0xFF, 0xF3,
	0x00, 0x00, 0x02, 0x80, 0x2E, 0x00, 0x00, 0x00, 0x36, 0x02, 0x80, 0x47, 0x00, 0x00, 0x00, 0x2C,
	0x01, 0x00, 0x55, 0x02, 0x80, 0x47, 0x00, 0x00, 0x00, 0x0D, 0x01, 0x80, 0x55, 0x00, 0x00, 0xFF,
	0xE1, 0x02, 0x00, 0x43, 0x01, 0x00, 0x44, 0x02, 0x00, 0x0D, 0x00, 0x00, 0x02, 0x00, 0x39, 0x01,
	0x00, 0x3A, 0x02, 0x00, 0x3B, 0x02, 0x80, 0x28, 0xFF, 0xC8, 0x00, 0x0B, 0x01, 0x00, 0x3C, 0x02,
	0x80, 0x15, 0x00, 0x00, 0xFF, 0xF1, 0x01, 0x80, 0x16, 0x00, 0x00, 0xFF, 0xF1, 0x02, 0x80, 0x0B,
	0xFF, 0xEE, 0x00, 0x3D, 0x02, 0x00, 0x56, 0x01, 0x00, 0x57, 0x02, 0x00, 0x58, 0x01, 0x00, 0x59,
	0x02, 0x00, 0x0A, 0x00, 0x00, 0x02, 0x00, 0x5A, 0x01, 0x00, 0x5B, 0x02, 0x00, 0x5C, 0x01, 0x00,
	0x5D, 0x02, 0x00, 0x5E, 0x01, 0x00, 0x5F, 0x01, 0x00, 0x60, 0x02, 0x00, 0x61, 0x02, 0x00, 0x62,
	0x01, 0x00, 0x0A, 0x00, 0x00, 0x02, 0x00, 0x63, 0x01, 0x80, 0x41, 0x00, 0x3B, 0x00, 0x1F, 0x02,
	0x80, 0x56, 0x00, 0x00, 0xFF, 0xCB, 0x01, 0x80, 0x57, 0x00, 0x00, 0xFF, 0xCB, 0x02, 0x00, 0x64,
	0x01, 0x00, 0x65, 0x02, 0x80, 0x28, 0x00, 0x05, 0xFF, 0xF3, 0x01, 0x80, 0x18, 0x00, 0x00, 0x00,
	0x7F, 0x01, 0x80, 0x19, 0x00, 0x00, 0x00, 0x7F, 0x02, 0x00, 0x0C, 0x00, 0x00, 0x02, 0x00, 0x39,
	0x01, 0x00, 0x3A, 0x02, 0x00, 0x3B, 0x02, 0x80, 0x28, 0xFF, 0xC8, 0x00, 0x0B, 0x01, 0x00, 0x3C,
	0x02, 0x80, 0x15, 0x00, 0x00, 0xFF, 0xDF, 0x01, 0x80, 0x16, 0x00, 0x00, 0xFF, 0xDF, 0x02, 0x80,
	0x0B, 0xFF, 0xEE, 0x00, 0x2B, 0x02, 0x00, 0x66, 0x01, 0x80, 0x5B, 0x00, 0x2F, 0x00, 0x00, 0x02,
	0x80, 0x62, 0x00, 0x2F, 0x00, 0x00, 0x01, 0x00, 0x0A, 0x00, 0x00, 0x02, 0x80, 0x18, 0x00, 0x00,
	0x00, 0x7F, 0x01, 0x80, 0x19, 0x00, 0x00, 0x00, 0x7F, 0x02, 0x80, 0x5A, 0x00, 0x00, 0xFF, 0xA3,
	0x01, 0x80, 0x5B, 0x00, 0x00, 0xFF, 0xC5, 0x02, 0x80, 0x62, 0x00, 0x00, 0xFF, 0xC5, 0x01, 0x80,
	0x47, 0x00, 0x00, 0x00, 0x2C, 0x01, 0x00, 0x55, 0x02, 0x80, 0x47, 0x00, 0x00, 0x00, 0x0D, 0x01,
	0x80, 0x55, 0x00, 0x00, 0xFF, 0xE1, 0x02, 0x00, 0x0B, 0x00, 0x00, 0x02, 0x00, 0x67, 0x01, 0x00,
	0x68, 0x02, 0x00, 0x69, 0x01, 0x00, 0x6A, 0x01, 0x00, 0x6B, 0x02, 0x00, 0x6C, 0x02, 0x80, 0x58,
	0xFF, 0xD2, 0xFF, 0xE0, 0x01, 0x80, 0x59, 0xFF, 0xD2, 0xFF, 0xE0, 0x02, 0x00, 0x6D, 0x01, 0x80,
	0x14, 0xFF, 0xDB, 0x00, 0x16, 0x01, 0x00, 0x10, 0x00, 0x00, 0x02, 0x00, 0x42, 0x01, 0x80, 0x2D,
	0x00, 0x00, 0x00, 0x7E, 0x01, 0x80, 0x2E, 0x00, 0x00, 0x00, 0x36, 0x02, 0x00, 0x10, 0x01, 0x80,
	0x02, 0xFF, 0xC9, 0xFF, 0xFF, 0x02, 0x80, 0x04, 0xFF, 0xB1, 0xFF, 0xFF, 0x02, 0x00, 0x11, 0x01,
	0x00, 0x12, 0x02, 0x80, 0x31, 0x00, 0x04, 0xFF, 0xED, 0x01, 0x00, 0x6E, 0x01, 0x80, 0x33, 0x00,
	0x04, 0xFF, 0x97, 0x01, 0x80, 0x31, 0x00, 0x14, 0xFF, 0xCB, 0x02, 0x80, 0x34, 0x00, 0x04, 0xFF,
	0xEC, 0x02, 0x80, 0x47, 0x00, 0x00, 0x00, 0x04, 0x01, 0x80, 0x55, 0x00, 0x00, 0xFF, 0xD8, 0x02,
	0x00, 0x0D, 0x00, 0x00, 0x02, 0x80, 0x31, 0xFF, 0xBB, 0xFF, 0xFF, 0x01, 0x80, 0x32, 0xFF, 0xBB,
	0xFF, 0xFF, 0x01, 0x00, 0x6F, 0x01, 0x80, 0x31, 0xFF, 0xCB, 0x00, 0x21, 0x02, 0x80, 0x34, 0xFF,
	0xBB, 0xFF, 0xFF, 0x02, 0x00, 0x18, 0x01, 0x00, 0x19, 0x02, 0x00, 0x70, 0x01, 0x00, 0x71, 0x02,
	0x00, 0x72, 0x02, 0x00, 0x73, 0x02, 0x80, 0x28, 0xFF, 0xEE, 0x00, 0x2B, 0x01, 0x00, 0x0E, 0x00,
	0x00, 0x02, 0x00, 0x74, 0x01, 0x80, 0x2D, 0xFF, 0xF1, 0x00, 0x7D, 0x01, 0x80, 0x2E, 0x00, 0x00,
	0x00, 0x36, 0x02, 0x80, 0x31, 0xFF, 0xFB, 0xFF, 0xBF, 0x01, 0x00, 0x75, 0x01, 0x00, 0x76, 0x01,
	0x80, 0x31, 0x00, 0x1D, 0xFF, 0xCF, 0x02, 0x00, 0x77, 0x02, 0x00, 0x40, 0x01, 0x00, 0x41, 0x02,
	0x00, 0x78, 0x01, 0x00, 0x79, 0x01, 0x80, 0x28, 0xFF, 0xF8, 0x00, 0x05, 0x01, 0x00, 0x0F, 0x00,
	0x00, 0x02, 0x00, 0x4D, 0x01, 0x00, 0x4B, 0x01, 0x00, 0x7A, 0x02, 0x80, 0x14, 0x00, 0x33, 0xFF,
	0xDC, 0x02, 0x00, 0x4E, 0x02, 0x00, 0x7B, 0x01, 0x00, 0x7C, 0x02, 0x80, 0x15, 0x00, 0x66, 0xFF,
	0xD5, 0x01, 0x00, 0x7D, 0x02, 0x80, 0x0B, 0x00, 0x43, 0x00, 0x21, 0x02, 0x00, 0x7E, 0x01, 0x00,
	0x7F, 0x01, 0x00, 0x80, 0x01, 0x00, 0x81, 0x02, 0x00, 0x0C, 0x00, 0x00, 0x02, 0x80, 0x54, 0x00,
	0x00, 0xFF, 0xBA, 0x01, 0x80, 0x38, 0xFF, 0xF3, 0xFF, 0xF3, 0x02, 0x00, 0x56, 0x01, 0x00, 0x57,
	0x02, 0x00, 0x58, 0x01, 0x00, 0x59, 0x02, 0x80, 0x47, 0x00, 0x00, 0xFF, 0xEA, 0x01, 0x80, 0x55,
	0x00, 0x00, 0xFF, 0xBE, 0x02, 0x80, 0x47, 0x00, 0x00, 0xFF, 0xCB, 0x01, 0x80, 0x55, 0x00, 0x00,
	0xFF, 0x9F, 0x02, 0x80, 0x2B, 0x00, 0x0A, 0xFF, 0xC0, 0x01, 0x00, 0x0F, 0x00, 0x00, 0x02, 0x00,
	0x82, 0x01, 0x00, 0x83, 0x01, 0x80, 0x18, 0x00, 0x7F, 0x00, 0x00, 0x01, 0x80, 0x19, 0x00, 0x7F,
	0x00, 0x00, 0x02, 0x00, 0x53, 0x03, 0x00, 0x84, 0x01, 0x00, 0x85, 0x02, 0x00, 0x86, 0x02, 0x80,
	0x31, 0x00, 0x1D, 0x00, 0x1D, 0x02, 0x00, 0x87, 0x01, 0x80, 0x0A, 0x00, 0x16, 0xFF, 0xF6, 0x02,
	0x00, 0x88, 0x02, 0x80, 0x31, 0xFF, 0xFB, 0x00, 0x2D, 0x01, 0x00, 0x89, 0x01, 0x00, 0x0B, 0x00,
	0x00, 0x02, 0x00, 0x8A, 0x01, 0x80, 0x46, 0x00, 0x01, 0xFF, 0xE9, 0x02, 0x00, 0x8B, 0x01, 0x80,
	0x78, 0xFF, 0xDF, 0x00, 0x0B, 0x02, 0x00, 0x8C, 0x01, 0x00, 0x8D, 0x01, 0x00, 0x8E, 0x02, 0x00,
	0x8F, 0x01, 0x00, 0x90, 0x02, 0x00, 0x91, 0x01, 0x00, 0x0E, 0x00, 0x00, 0x02, 0x00, 0x92, 0x01,
	0x80, 0x02, 0xFF, 0xA7, 0x00, 0x58, 0x02, 0x00, 0x93, 0x01, 0x00, 0x94, 0x02, 0x00, 0x95, 0x02,
	0x00, 0x96, 0x01, 0x00, 0x97, 0x02, 0x00, 0x98, 0x01, 0x00, 0x99, 0x02, 0x00, 0x9A, 0x01, 0x00,
	0x9B, 0x02, 0x80, 0x9A, 0xFF, 0xE1, 0x00, 0x00, 0x01, 0x80, 0x9B, 0xFF, 0xE1, 0x00, 0x00, 0x02,
	0x00, 0x0A, 0x00, 0x00, 0x02, 0x80, 0x02, 0xFF, 0xA7, 0x00, 0x58, 0x02, 0x00, 0x9C, 0x01, 0x00,
	0x9D, 0x02, 0x00, 0x9E, 0x02, 0x80, 0x73, 0xFF, 0xBF, 0x00, 0x7F, 0x02, 0x80, 0x28, 0xFF, 0xAB,
	0x00, 0x2C, 0x01, 0x80, 0x18, 0x00, 0x7F, 0x00, 0x7F, 0x01, 0x80, 0x19, 0x00, 0x7F, 0x00, 0x7F,
	0x02, 0x00, 0x53, 0x03, 0x00, 0x0C, 0x00, 0x00, 0x02, 0x80, 0x17, 0x00, 0x01, 0x00, 0x00, 0x01,
	0x00, 0x9F, 0x01, 0x00, 0xA0, 0x02, 0x80, 0x14, 0x00, 0x02, 0x00, 0x03, 0x02, 0x80, 0x4E, 0x00,
	0x39, 0xFF, 0xF0, 0x02, 0x00, 0xA1, 0x01, 0x80, 0x7F, 0x00, 0x3B, 0x00, 0x26, 0x01, 0x00, 0xA2,
	0x01, 0x80, 0x78, 0x00, 0x01, 0xFF, 0xB4, 0x02, 0x00, 0xA3, 0x02, 0x80, 0x28, 0xFF, 0xF4, 0xFF,
	0xF6, 0x01, 0x00, 0x0D, 0x00, 0x00, 0x02, 0x00, 0x25, 0x01, 0x00, 0x26, 0x01, 0x00, 0x27, 0x02,
	0x00, 0x28, 0x01, 0x00, 0x29, 0x02, 0x00, 0x2A, 0x01, 0x00, 0xA4, 0x01, 0x00, 0xA5, 0x02, 0x00,
	0xA6, 0x01, 0x00, 0xA7, 0x02, 0x80, 0xA6, 0xFF, 0xE1, 0x00, 0x00, 0x01, 0x80, 0xA7, 0xFF, 0xE1,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x26, 0x00, 0x2F, 0x00, 0x3A, 0x00, 0x43,
	0x00, 0x54, 0x00, 0x65, 0x00, 0x6E, 0x00, 0x7F, 0x00, 0x8E, 0x00, 0x97, 0x00, 0xA0, 0x00, 0xAB,
	0x00, 0xC6, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0x0B, 0x01, 0x1C, 0x01, 0x25, 0x01, 0x30, 0x01, 0x39,
	0x01, 0x44, 0x01, 0x55, 0x01, 0x5E, 0x01, 0x67, 0x01, 0x70, 0x01, 0x7B, 0x01, 0x86, 0x01, 0x8F,
	0x01, 0x9A, 0x01, 0xAB, 0x01, 0xB4, 0x01, 0xC1, 0x01, 0xCA, 0x01, 0xD3, 0x01, 0xF8, 0x02, 0x11,
	0x02, 0x1C, 0x02, 0x25, 0x02, 0x2E, 0x02, 0x37, 0x02, 0x40, 0x02, 0x4F, 0x02, 0x5A, 0x02, 0x65,
	0x02, 0x6E, 0x02, 0x77, 0x02, 0x90, 0x02, 0xA7, 0x02, 0xB0, 0x02, 0xBB, 0x02, 0xC6, 0x02, 0xD1,
	0x02, 0xF6, 0x03, 0x0F, 0x03, 0x1A, 0x03, 0x23, 0x03, 0x2E, 0x03, 0x37, 0x03, 0x48, 0x03, 0x51,
	0x03, 0x6A, 0x03, 0x75, 0x03, 0x8E, 0x03, 0x99, 0x03, 0xA2, 0x03, 0xAD, 0x03, 0xCE, 0x03, 0xE9,
	0x03, 0xF4, 0x03, 0xFD, 0x04, 0x16, 0x04, 0x2D, 0x04, 0x38, 0x04, 0x41, 0x04, 0x4C, 0x04, 0x57,
	0x04, 0x60, 0x04, 0x69, 0x04, 0x72, 0x04, 0x7F, 0x04, 0x88, 0x04, 0x99, 0x04, 0xA6, 0x04, 0xB1,
	0x04, 0xC2, 0x04, 0xCD, 0x04, 0xE2, 0x04, 0xFB, 0x05, 0x0C, 0x05, 0x17, 0x05, 0x20, 0x05, 0x2B,
	0x05, 0x34, 0x05, 0x4D, 0x05, 0x58, 0x05, 0x71, 0x05, 0x84, 0x05, 0x8D, 0x05, 0x98, 0x05, 0xB3,
	0x05, 0xC4, 0x05, 0xCF, 0x05, 0xDA, 0x05, 0xE3, 0x05, 0xEE, 0x05, 0xF7, 0x06, 0x02, 0x06, 0x0F,
	0x06, 0x1A, 0x06, 0x25, 0x06, 0x30, 0x06, 0x3B, 0x06, 0x4C, 0x06, 0x55, 0x06, 0x5E, 0x06, 0x69,
	0x06, 0x74, 0x06, 0x7F, 0x06, 0x8A, 0x06, 0x93, 0x06, 0x9C, 0x06, 0xAB, 0x06, 0xB6, 0x06, 0xBF,
	0x06, 0xD0, 0x06, 0xD9, 0x06, 0xE2, 0x06, 0xFB, 0x07, 0x0C, 0x07, 0x17, 0x07, 0x22, 0x07, 0x2D,
	0x07, 0x3E, 0x07, 0x4F, 0x07, 0x58, 0x07, 0x63, 0x07, 0x6C, 0x07, 0x77, 0x07, 0x86, 0x07, 0x91,
	0x07, 0x9A, 0x07, 0xA3, 0x07, 0xAC, 0x07, 0xB5, 0x07, 0xBE, 0x07, 0xD9, 0x07, 0xEA, 0x07, 0xF3,
	0x07, 0xFC, 0x08, 0x07, 0x08, 0x1C, 0x08, 0x35, 0x08, 0x46, 0x08, 0x5F, 0x08, 0x70, 0x08, 0x7B,
	0x08, 0x8C, 0x08, 0x95, 0x08, 0xA0, 0x08, 0xAF, 0x08, 0xB6, 0x08, 0xBF, 0x08, 0xCA, 0x08, 0xEF,
	0x09, 0x08, 0x09, 0x21, 0x03, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x7F, 0x81, 0x00, 0x0B,
	0x00, 0x7F, 0x00, 0x00, 0x00, 0x7F, 0xFA, 0x00, 0xF8, 0xFE, 0xFA, 0xFD, 0xF7, 0xF7, 0xFC, 0xF9,
	0xFE, 0xF8, 0xFF, 0xFA, 0x00, 0xFC, 0x00, 0xA8, 0x1C, 0x00, 0xFF, 0x00, 0x5B, 0x00, 0x03, 0x00,
	0x1E, 0x00, 0x1E, 0x03, 0x00, 0x00, 0x00, 0x00, 0x53, 0x00, 0x00, 0x19, 0xAD, 0x00, 0xFF, 0x00,
	0x67, 0x00, 0x4A, 0x00, 0x0F, 0x00, 0x16, 0x06, 0x00, 0x5B, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x03,
	0xFE, 0x06, 0xFC, 0x04, 0xFC, 0x01, 0xFD, 0x00, 0x06, 0x00, 0x53, 0x00, 0x01, 0x00, 0x18, 0xEB,
	0x00, 0x01, 0xF9, 0x03, 0xF9, 0x06, 0xFA, 0x06, 0xFD, 0x02, 0x00, 0x5B, 0x00, 0x23, 0x17, 0x17,
	0xE9, 0x06, 0x06, 0x00, 0x00, 0x00, 0x02, 0x06, 0x03, 0x06, 0x06, 0x03, 0x07, 0x02, 0x0A, 0xEB,
	0x00, 0x00, 0xE5, 0x05, 0x00, 0x00, 0x00, 0x1A, 0x65, 0x65, 0x9B, 0x00, 0x00, 0xDE, 0x1E, 0xFA,
	0x01, 0x00, 0xFF, 0x00, 0x0F, 0x00, 0x5D, 0x00, 0x0F, 0x00, 0x0F, 0xFF, 0x00, 0x27, 0x00, 0x19,
	0x00, 0x15, 0x00, 0x18, 0x03, 0x00, 0x7F, 0x00, 0x7F, 0x82, 0x00, 0x00, 0x81, 0x7E, 0x00, 0x0B,
	0x00, 0x7F, 0x00, 0x11, 0xE6, 0x0D, 0x00, 0xFB, 0x01, 0xFB, 0x03, 0xF9, 0x04, 0xFA, 0x03, 0xFD,
	0x06, 0xFD, 0x02, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x05, 0x00, 0x0B, 0x00, 0x7F, 0x00, 0x22, 0xE3,
	0x0D, 0x00, 0xFB, 0x01, 0xFB, 0x03, 0xF9, 0x04, 0xFA, 0x03, 0xFD, 0x06, 0xFD, 0x02, 0x00, 0x00,
	0x00, 0x02, 0xFF, 0x08, 0x00, 0x05, 0x00, 0x60, 0x00, 0x57, 0x01, 0x00, 0x1E, 0x06, 0x00, 0x22,
	0x9B, 0x00, 0x65, 0x9B, 0x0B, 0x00, 0x08, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x57, 0x00, 0x04, 0xFF,
	0x06, 0xFE, 0x08, 0xFC, 0x07, 0xF7, 0x09, 0xFA, 0x03, 0xF8, 0x03, 0xFA, 0x00, 0x00, 0x81, 0x06,
	0x00, 0x24, 0x00, 0x0D, 0xFD, 0x00, 0xFC, 0xFF, 0xFC, 0xFC, 0xFE, 0xFA, 0x00, 0xFE, 0x0D, 0x00,
	0x02, 0x00, 0x24, 0x00, 0x3F, 0xE9, 0xFA, 0x17, 0xE9, 0x03, 0x00, 0x7F, 0x00, 0x2D, 0x00, 0x52,
	0x81, 0x00, 0x00, 0xEE, 0xFF, 0x00, 0x25, 0x00, 0x50, 0x00, 0x19, 0x00, 0x19, 0x03, 0x00, 0x00,
	0x00, 0x69, 0x00, 0xD0, 0x19, 0x00, 0x00, 0x30, 0x06, 0x00, 0x01, 0x00, 0x39, 0x18, 0x00, 0x00,
	0x15, 0xF9, 0xFF, 0xF9, 0xFD, 0xFA, 0xFA, 0xFD, 0xFA, 0x02, 0x00, 0x01, 0x00, 0x7F, 0x32, 0xE7,
	0x00, 0x19, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x00, 0x2A, 0xFF, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x00, 0x18, 0x03, 0x00, 0x7E, 0x00, 0x2D, 0xE9, 0x2D, 0xEE, 0xE5, 0x2A, 0xEB, 0x03,
	0x00, 0x31, 0x00, 0x66, 0xCF, 0x18, 0x00, 0xDF, 0x2A, 0xF5, 0xFF, 0x00, 0x56, 0x00, 0x4C, 0x00,
	0x16, 0x00, 0x16, 0x03, 0x00, 0x2F, 0x00, 0x66, 0x2C, 0x00, 0x00, 0x19, 0xD4, 0x00, 0x06, 0x00,
	0x56, 0x00, 0x7D, 0xFA, 0xFD, 0xFA, 0xFA, 0xFD, 0xF9, 0xFF, 0xF9, 0x15, 0x00, 0x00, 0x18, 0x02,
	0x00, 0x2C, 0x00, 0x7F, 0xD4, 0x00, 0x00, 0xAA, 0x04, 0x00, 0x11, 0x00, 0x70, 0xFE, 0xFC, 0x14,
	0x00, 0x0B, 0x13, 0xF2, 0x00, 0xFF, 0x00, 0x1C, 0x00, 0x69, 0x00, 0x0D, 0x00, 0x0B, 0xFF, 0x00,
	0x19, 0x00, 0x26, 0x00, 0x19, 0x00, 0x36, 0x10, 0x00, 0x2F, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x0A,
	0xFE, 0x0F, 0xFE, 0x09, 0xFD, 0x0A, 0xFB, 0x0A, 0xF8, 0x0A, 0xF9, 0x07, 0xF4, 0x08, 0xFC, 0x02,
	0xF9, 0x01, 0x00, 0xE9, 0x08, 0xF9, 0x06, 0xF5, 0x03, 0xF3, 0x02, 0xF3, 0x0A, 0x00, 0x17, 0x00,
	0x3C, 0x08, 0xFF, 0x0A, 0xFD, 0x05, 0xFC, 0x05, 0xFB, 0x06, 0xF7, 0xFE, 0x09, 0xFE, 0x06, 0xF7,
	0x0F, 0xF6, 0x0A, 0xF5, 0x09, 0x03, 0x00, 0x6F, 0x00, 0x1F, 0x10, 0x00, 0x00, 0x60, 0xF0, 0x00,
	0xFF, 0x00, 0x6B, 0x00, 0x2E, 0x00, 0x14, 0x00, 0x27, 0xFF, 0x00, 0x71, 0x00, 0x16, 0x00, 0x0E,
	0x00, 0x17, 0xFF, 0x00, 0x73, 0x00, 0x14, 0x00, 0x07, 0x00, 0x07, 0x02, 0x00, 0x6E, 0x00, 0x4D,
	0x00, 0x09, 0xF8, 0xFF, 0x05, 0x00, 0x6F, 0x00, 0x4D, 0x00, 0x32, 0xE1, 0x00, 0x0E, 0xF2, 0x08,
	0xF6, 0x06, 0xF5, 0x03, 0x00, 0x24, 0x00, 0x68, 0x2D, 0x00, 0x00, 0x07, 0xD3, 0x00, 0x03, 0x00,
	0x51, 0x00, 0x00, 0x2E, 0x00, 0x00, 0x27, 0xD2, 0x00, 0xFF, 0x00, 0x51, 0x00, 0x00, 0x00, 0x2B,
	0x00, 0x26, 0xFF, 0x00, 0x67, 0x00, 0x24, 0x00, 0x17, 0x00, 0x17, 0x0A, 0x00, 0x7F, 0x00, 0x4B,
	0xFB, 0x00, 0xFB, 0xFE, 0x01, 0x00, 0xFA, 0xFD, 0xFD, 0xFD, 0xFD, 0xFC, 0xFC, 0xF7, 0xFF, 0xFB,
	0x00, 0xFB, 0x1A, 0x0D, 0x09, 0x00, 0x7F, 0x00, 0x39, 0xF8, 0x00, 0xFC, 0xFF, 0xFA, 0xFD, 0xFD,
	0xFD, 0xFC, 0xFA, 0xFD, 0xF9, 0xFF, 0xFB, 0x00, 0xFC, 0x1D, 0x0C, 0xFF, 0x00, 0x4E, 0x00, 0x49,
	0x00, 0x13, 0x00, 0x13, 0x03, 0x00, 0x45, 0x00, 0x36, 0x0C, 0x00, 0x04, 0x47, 0xF0, 0x00, 0x03,
	0x00, 0x45, 0x00, 0x69, 0x1B, 0x00, 0x00, 0x16, 0xE5, 0x00, 0x03, 0x00, 0x38, 0x00, 0x36, 0x0C,
	0x00, 0x00, 0x27, 0xF4, 0x00, 0x10, 0x00, 0x3F, 0x00, 0x7F, 0xE2, 0x00, 0x00, 0xF5, 0x01, 0xF1,
	0x02, 0xF7, 0x03, 0xF6, 0x05, 0xF6, 0x08, 0xF6, 0x07, 0xF9, 0x0C, 0xF8, 0x04, 0xFE, 0x07, 0xFF,
	0x00, 0x17, 0xF8, 0x07, 0xFA, 0x0B, 0xFD, 0x0D, 0xFE, 0x0D, 0x0A, 0x00, 0x54, 0x00, 0x43, 0xF8,
	0x00, 0xF9, 0x03, 0xFB, 0x04, 0xFB, 0x05, 0xFA, 0x09, 0x02, 0xF7, 0x02, 0xFA, 0x09, 0xF1, 0x09,
	0xF7, 0x08, 0xF9, 0x03, 0x00, 0x46, 0x00, 0x46, 0x39, 0x00, 0x00, 0x39, 0xC7, 0x00, 0xFF, 0x00,
	0x46, 0x00, 0x46, 0x00, 0x2F, 0x00, 0x2F, 0x03, 0x00, 0x20, 0x00, 0x00, 0x5F, 0x00, 0x00, 0x2E,
	0xA1, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x21, 0x00, 0x49, 0x00, 0x24, 0x06, 0x00, 0x51, 0x00, 0x2E,
	0x09, 0xFE, 0x0F, 0xFE, 0x0A, 0x00, 0x0C, 0x02, 0x00, 0x04, 0xD0, 0x00, 0x02, 0x00, 0x43, 0x00,
	0x2A, 0x0C, 0x06, 0xF4, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC5, 0x19, 0x00, 0x0F, 0xFE,
	0x0D, 0xFC, 0x0E, 0x1A, 0xFB, 0x0C, 0xF8, 0x09, 0xF0, 0x0A, 0xF4, 0x04, 0xF1, 0x04, 0x03, 0x00,
	0x00, 0x00, 0x3D, 0x07, 0x04, 0x0C, 0x03, 0xED, 0x01, 0x0A, 0x00, 0x36, 0x00, 0x3D, 0x0D, 0x1A,
	0xF4, 0x07, 0xF3, 0x02, 0xF9, 0xFF, 0xFA, 0xFF, 0xFB, 0xFC, 0x06, 0xFF, 0x0A, 0xFB, 0x08, 0xF8,
	0x04, 0xF9, 0x03, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x21, 0xDF, 0x00, 0xFF, 0x00, 0x21,
	0x00, 0x30, 0x00, 0x23, 0x00, 0x23, 0x03, 0x00, 0x51, 0x00, 0x57, 0x2E, 0x00, 0x00, 0x28, 0xD2,
	0x00, 0x0E, 0x00, 0x60, 0x00, 0x0C, 0xFA, 0x0A, 0xFB, 0x0D, 0xFE, 0x0B, 0x01, 0x0A, 0xF0, 0x11,
	0xFC, 0xFA, 0xFE, 0xFC, 0xFD, 0xF2, 0x00, 0xF6, 0x01, 0xF3, 0x03, 0xF6, 0x05, 0xF7, 0x04, 0xF9,
	0x24, 0x00, 0x0B, 0x00, 0x43, 0x00, 0x4B, 0xFE, 0xF2, 0x01, 0xF7, 0x01, 0xF8, 0x03, 0xF7, 0x03,
	0xFA, 0x03, 0xFA, 0x00, 0x09, 0x00, 0x07, 0x01, 0x06, 0x03, 0x07, 0x05, 0x05, 0x03, 0x00, 0x00,
	0x00, 0x1B, 0x34, 0x00, 0x00, 0x2F, 0xCC, 0x00, 0xFF, 0x00, 0x34, 0x00, 0x4A, 0x00, 0x33, 0x00,
	0x21, 0x0A, 0x00, 0x7F, 0x00, 0x46, 0xE6, 0x0D, 0x00, 0xFB, 0x01, 0xFB, 0x04, 0xF7, 0x03, 0xFC,
	0x03, 0xFD, 0x06, 0xFD, 0xFF, 0x00, 0x05, 0xFF, 0x05, 0x00, 0x09, 0x00, 0x7F, 0x00, 0x57, 0xE3,
	0x0D, 0x00, 0xFB, 0x01, 0xFB, 0x03, 0xF9, 0x04, 0xFA, 0x03, 0xFD, 0x06, 0xFD, 0x04, 0xFF, 0x08,
	0x00, 0x03, 0x00, 0x30, 0x00, 0x57, 0x34, 0x00, 0x00, 0x28, 0xCC, 0x00, 0xFF, 0x00, 0x34, 0x00,
	0x00, 0x00, 0x0E, 0x00, 0x0E, 0x03, 0x00, 0x00, 0x00, 0x52, 0x00, 0xAE, 0x7F, 0x00, 0x00, 0x12,
	0x03, 0x00, 0x4D, 0x00, 0x19, 0x32, 0xE8, 0x00, 0x21, 0xD5, 0x0B, 0x02, 0x00, 0x7D, 0x00, 0x00,
	0xCE, 0x19, 0x00, 0xE7, 0xFF, 0x00, 0x22, 0x00, 0x4F, 0x00, 0x24, 0x00, 0x32, 0x02, 0x00, 0x25,
	0x00, 0x7F, 0xDB, 0x00, 0x00, 0xB7, 0x04, 0x00, 0x0E, 0x00, 0x72, 0xFF, 0xFD, 0x10, 0x00, 0x0A,
	0x10, 0xF4, 0x00, 0xFF, 0x00, 0x18, 0x00, 0x6C, 0x00, 0x0B, 0x00, 0x09, 0x06, 0x00, 0x01, 0x00,
	0x3D, 0x01, 0xFB, 0x15, 0x29, 0xF5, 0xFC, 0xFC, 0xFB, 0xFB, 0xF7, 0xFE, 0xF4, 0x04, 0x00, 0x80,
	0x00, 0x00, 0x29, 0x00, 0x00, 0x7F, 0x00, 0x2A, 0xD7, 0x00, 0x03, 0x00, 0x39, 0x00, 0x7F, 0xC7,
	0x00, 0x00, 0xC7, 0x39, 0x00, 0x06, 0x00, 0x7F, 0x00, 0x7F, 0xE7, 0x00, 0x04, 0xFA, 0x03, 0xFD,
	0x06, 0xFD, 0x04, 0xFF, 0x08, 0x00, 0x03, 0x00, 0x44, 0x00, 0x4C, 0x3B, 0x00, 0x00, 0x33, 0xC5,
	0x00, 0x08, 0x00, 0x7F, 0x00, 0x5A, 0x00, 0x25, 0xD1, 0x00, 0x01, 0xF6, 0x07, 0xF5, 0x07, 0xF9,
	0x08, 0xFB, 0x06, 0xFE, 0x0A, 0xFE, 0x0A, 0x00, 0x48, 0x00, 0x5C, 0xFB, 0x00, 0xFB, 0xFF, 0x01,
	0x00, 0xFA, 0xFD, 0xFD, 0xFD, 0xFD, 0xFC, 0xFC, 0xF7, 0xFF, 0xFB, 0x00, 0xFB, 0x1A, 0x0D, 0x06,
	0x00, 0x48, 0x00, 0x4B, 0xF8, 0x00, 0xFC, 0xFF, 0xFA, 0xFD, 0xFD, 0xFD, 0xFC, 0xFA, 0x19, 0x00,
	0x03, 0x00, 0x2F, 0x00, 0x5D, 0x50, 0x00, 0x00, 0x22, 0xB0, 0x00, 0xFF, 0x00, 0x2F, 0x00, 0x5D,
	0x00, 0x21, 0x00, 0x21, 0x03, 0x00, 0x00, 0x00, 0x1A, 0x21, 0x00, 0x00, 0x65, 0xDF, 0x00, 0xFF,
	0x00, 0x21, 0x00, 0x1A, 0x00, 0x20, 0x00, 0x20, 0x0A, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x39, 0xDC,
	0x02, 0xF7, 0x02, 0xF7, 0x04, 0xF3, 0xE6, 0x04, 0xF4, 0x08, 0xF7, 0x10, 0xF6, 0x0C, 0xFC, 0x0F,
	0xFC, 0x03, 0x00, 0x7F, 0x00, 0x42, 0xF7, 0xFA, 0xF6, 0xFE, 0x13, 0x00, 0x0A, 0x00, 0x48, 0x00,
	0x42, 0xF4, 0xE6, 0x0B, 0xF9, 0x0D, 0xFE, 0x07, 0x01, 0x06, 0x01, 0x05, 0x04, 0xFA, 0x01, 0xF5,
	0x06, 0xF9, 0x07, 0xFC, 0x07, 0x07, 0x00, 0x21, 0x00, 0x7F, 0xE6, 0x00, 0x00, 0xF2, 0x02, 0xF2,
	0x04, 0xF3, 0x04, 0xF5, 0x07, 0xF7, 0x09, 0xF9, 0xFF, 0x00, 0x2F, 0x00, 0x5D, 0x00, 0x0D, 0x00,
	0x0D, 0x03, 0x00, 0x7F, 0x00, 0x7F, 0xDF, 0x00, 0x00, 0xD9, 0x21, 0x00, 0x0B, 0x00, 0x48, 0x00,
	0x27, 0xFB, 0x00, 0xFB, 0xFF, 0x01, 0x00, 0xFA, 0xFD, 0xFD, 0xFD, 0xFD, 0xFC, 0xFC, 0xF7, 0xFF,
	0xFB, 0xFF, 0xFB, 0x00, 0xF9, 0x1B, 0x14, 0x06, 0x00, 0x47, 0x00, 0x10, 0x03, 0x06, 0xF4, 0xFD,
	0xF7, 0xF9, 0xFD, 0xFD, 0xFC, 0xFA, 0x19, 0x00, 0x03, 0x00, 0x5E, 0x00, 0x7F, 0xA2, 0x00, 0x00,
	0xDE, 0x5E, 0x00, 0x03, 0x00, 0x3F, 0x00, 0x3F, 0x40, 0x00, 0x00, 0x40, 0xC0, 0x00, 0xFF, 0x00,
	0x3F, 0x00, 0x3F, 0x00, 0x37, 0x00, 0x37, 0x03, 0x00, 0x3F, 0x00, 0x00, 0x1D, 0x00, 0x00, 0x4A,
	0xE3, 0x00, 0xFF, 0x00, 0x3F, 0x00, 0x4A, 0x00, 0x1D, 0x00, 0x1D, 0x03, 0x00, 0x22, 0x00, 0x2C,
	0x1C, 0x00, 0x00, 0x3E, 0xE4, 0x00, 0x04, 0x00, 0x5C, 0x00, 0x47, 0xF8, 0x00, 0x00, 0xED, 0x02,
	0xEA, 0x06, 0xE2, 0x03, 0x00, 0x00, 0x00, 0x66, 0x1A, 0x00, 0x00, 0x19, 0xE6, 0x00, 0x03, 0x00,
	0x49, 0x00, 0x02, 0x10, 0x00, 0xFC, 0x47, 0xF4, 0x00, 0x03, 0x00, 0x00, 0x00, 0x68, 0x1B, 0x00,
	0x00, 0x17, 0xE5, 0x00, 0x03, 0x00, 0x7F, 0x00, 0x14, 0x00, 0x6B, 0xD2, 0x00, 0x00, 0x95, 0x06,
	0x00, 0x51, 0x00, 0x51, 0x02, 0x09, 0x02, 0x0F, 0x00, 0x0A, 0xFE, 0x0C, 0xFC, 0x00, 0x00, 0xD0,
	0x02, 0x00, 0x55, 0x00, 0x43, 0xFA, 0x0C, 0x00, 0xF4, 0xFF, 0x00, 0x60, 0x00, 0x00, 0x00, 0x1F,
	0x00, 0x4D, 0x03, 0x00, 0x43, 0x00, 0x57, 0x3C, 0x00, 0x00, 0x28, 0xC4, 0x00, 0x03, 0x00, 0x7D,
	0xFF, 0xFF, 0x00, 0x10, 0xB9, 0xFC, 0x00, 0xF4, 0x03, 0x00, 0x7F, 0xFF, 0xFF, 0x00, 0x1B, 0xEA,
	0x00, 0x00, 0xE5, 0x03, 0x00, 0x5D, 0xFF, 0xF2, 0x00, 0x0C, 0xD9, 0x00, 0x00, 0xF4, 0xFF, 0x00,
	0x67, 0x00, 0x58, 0x00, 0x0C, 0x00, 0x0C, 0xFF, 0x00, 0x1A, 0x00, 0x2C, 0x00, 0x0A, 0x00, 0x0A,
	0x05, 0x00, 0x48, 0x00, 0x19, 0x0C, 0xF7, 0x12, 0xF7, 0x19, 0xFA, 0x00, 0x21, 0xD5, 0x0B, 0x03,
	0x00, 0x2E, 0x00, 0x53, 0x51, 0x00, 0x00, 0x2C, 0xAF, 0x00, 0xFF, 0x00, 0x1A, 0x00, 0x53, 0x00,
	0x64, 0x00, 0x20, 0x06, 0x00, 0x7D, 0x00, 0x13, 0xFD, 0x06, 0xFA, 0x06, 0xF9, 0x03, 0xF9, 0x01,
	0x00, 0xEB, 0x18, 0x00, 0x02, 0x00, 0x07, 0x00, 0x27, 0xF9, 0x15, 0x00, 0xF7, 0xFF, 0x00, 0x1F,
	0x00, 0x34, 0x00, 0x0B, 0x00, 0x0B, 0x0A, 0x00, 0x00, 0x00, 0x57, 0x1A, 0xF3, 0x00, 0x05, 0xFF,
	0x05, 0xFC, 0x09, 0xFD, 0x04, 0xFD, 0x03, 0xFA, 0x03, 0x01, 0x00, 0xFB, 0x01, 0xFB, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x4A, 0x19, 0x00, 0xFC, 0x06, 0xFD, 0x03, 0xFA, 0x03, 0xFC, 0x01, 0xF8, 0x00,
	0x03, 0x00, 0x69, 0x00, 0x7F, 0x00, 0xE5, 0x16, 0x00, 0x00, 0x1B, 0x03, 0x00, 0x36, 0x00, 0x7F,
	0x00, 0xF4, 0x47, 0xFC, 0x00, 0x10, 0x03, 0x00, 0x49, 0x00, 0x19, 0xD2, 0x00, 0x00, 0xE7, 0x2E,
	0x00, 0x06, 0x00, 0x21, 0x00, 0x02, 0x06, 0x03, 0x06, 0x06, 0x03, 0x07, 0x01, 0x07, 0xEA, 0x00,
	0x00, 0xE8, 0x06, 0x00, 0x49, 0x00, 0x01, 0x00, 0x18, 0xEA, 0x00, 0x01, 0xF9, 0x03, 0xF9, 0x06,
	0xFA, 0x06, 0xFD, 0x02, 0x00, 0x00, 0x00, 0x5E, 0x00, 0xA2, 0x5E, 0x5E, 0x03, 0x00, 0x2E, 0x00,
	0x47, 0x3D, 0x1E, 0xBE, 0x00, 0xFF, 0xE2, 0xFF, 0x00, 0x03, 0x00, 0x7D, 0x00, 0x11, 0x00, 0x11,
	0x03, 0x00, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x36, 0xCC, 0x00, 0x05, 0x00, 0x39, 0x00, 0x5E,
	0x01, 0x00, 0x19, 0x05, 0x00, 0x1C, 0xAD, 0x00, 0x53, 0xAD, 0x03, 0x00, 0x71, 0x00, 0x2E, 0x0E,
	0x00, 0x00, 0x51, 0xF2, 0x00, 0xFF, 0x00, 0x6E, 0x00, 0x3B, 0x00, 0x11, 0x00, 0x21, 0xFF, 0x00,
	0x73, 0x00, 0x26, 0x00, 0x0C, 0x00, 0x13, 0xFF, 0x00, 0x74, 0x00, 0x25, 0x00, 0x06, 0x00, 0x06,
	0x02, 0x00, 0x70, 0x00, 0x55, 0x00, 0x07, 0xF9, 0x00, 0x02, 0x00, 0x71, 0x00, 0x55, 0x00, 0x2A,
	0xEB, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x77, 0x00, 0xE4, 0x57, 0x00, 0x04, 0x00, 0x06, 0x01, 0x08,
	0x02, 0x07, 0x04, 0x09, 0x09, 0x03, 0x06, 0x03, 0x08, 0x00, 0x06, 0x81, 0x00, 0x06, 0x00, 0x0D,
	0x00, 0x5B, 0x00, 0x03, 0xFF, 0x04, 0xFC, 0x04, 0xFA, 0x02, 0xFE, 0x00, 0x00, 0xF3, 0x02, 0x00,
	0x3F, 0x00, 0x5B, 0xFA, 0x17, 0xE9, 0xE9, 0xFF, 0x00, 0x48, 0x00, 0x68, 0x00, 0x14, 0x00, 0x0F,
	0x03, 0x00, 0x4C, 0x00, 0x3B, 0x00, 0xC5, 0x33, 0x00, 0x00, 0x3B, 0x08, 0x00, 0x5A, 0x00, 0x00,
	0x25, 0x00, 0x00, 0x2F, 0xF6, 0xFF, 0xF5, 0xF9, 0xF9, 0xF9, 0xFB, 0xF8, 0xFE, 0xFA, 0xFE, 0xF6,
	0x0A, 0x00, 0x5C, 0x00, 0x37, 0x00, 0x05, 0xFF, 0x05, 0x00, 0xFF, 0xFD, 0x06, 0xFD, 0x03, 0xFC,
	0x03, 0xF7, 0x04, 0xFB, 0x01, 0xFB, 0x00, 0x0D, 0xE6, 0x06, 0x00, 0x4B, 0x00, 0x37, 0x00, 0x08,
	0xFF, 0x04, 0xFD, 0x06, 0xFD, 0x03, 0xFA, 0x04, 0x00, 0xE7, 0x0A, 0x00, 0x30, 0x00, 0x00, 0x0D,
	0x1A, 0xFB, 0x00, 0xFB, 0xFF, 0xF7, 0xFC, 0xFC, 0xFD, 0xFD, 0xFD, 0xFD, 0xFA, 0x00, 0x01, 0xFF,
	0xFB, 0x00, 0xFB, 0x06, 0x00, 0x3D, 0x00, 0x00, 0x00, 0x19, 0xFA, 0xFC, 0xFD, 0xFD, 0xFD, 0xFA,
	0xFF, 0xFC, 0x00, 0xF8, 0x03, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x94, 0x2E, 0x00, 0x00, 0x6C, 0x06,
	0x00, 0x2E, 0x00, 0x2E, 0xFE, 0xF7, 0xFE, 0xF1, 0x00, 0xF6, 0x02, 0xF4, 0x04, 0x00, 0x00, 0x30,
	0x02, 0x00, 0x2A, 0x00, 0x3C, 0x06, 0xF4, 0x00, 0x0C, 0x03, 0x00, 0x7F, 0x00, 0x3F, 0x00, 0x40,
	0x82, 0x00, 0x00, 0xEE, 0x05, 0x00, 0x37, 0x00, 0x66, 0xF4, 0x09, 0xEE, 0x09, 0xE8, 0x06, 0x00,
	0xDF, 0x2A, 0xF5, 0x01, 0x00, 0x7F, 0x00, 0x43, 0x00, 0x09, 0x02, 0x00, 0x7F, 0x00, 0x00, 0x00,
	0x4C, 0xB4, 0xB4, 0x03, 0x00, 0x33, 0x00, 0x00, 0x35, 0x00, 0x02, 0x17, 0xFA, 0x01, 0x10, 0x00,
	0x1E, 0x00, 0x0F, 0x02, 0x0D, 0x03, 0x0D, 0x06, 0x0B, 0x08, 0x07, 0x00, 0x17, 0xF9, 0xFF, 0xFC,
	0xFE, 0xF4, 0xF8, 0xF9, 0xF9, 0xF8, 0xF6, 0xFB, 0xF6, 0xFD, 0xF6, 0xFE, 0xF7, 0xFF, 0xF1, 0x00,
	0xF6, 0x1E, 0x00, 0x0A, 0x00, 0x37, 0x00, 0x57, 0xF4, 0xF7, 0xF6, 0xF6, 0xF7, 0xF1, 0xFE, 0xFA,
	0xFE, 0xF7, 0x06, 0x09, 0x05, 0x05, 0x05, 0x04, 0x0A, 0x03, 0x09, 0x01, 0x0A, 0x00, 0x2C, 0x00,
	0x7F, 0x00, 0xFB, 0x01, 0xFB, 0x00, 0x01, 0x03, 0xFA, 0x03, 0xFD, 0x04, 0xFD, 0x09, 0xFC, 0x05,
	0xFF, 0x05, 0x00, 0xF3, 0x1A, 0x06, 0x00, 0x3D, 0x00, 0x7F, 0x00, 0xF8, 0x01, 0xFC, 0x03, 0xFA,
	0x03, 0xFD, 0x06, 0xFC, 0x00, 0x19
};

const Level Game::_gameLevels[] = {
	{ "level1", "level1", 0x00 },
	{ "level2", "level2", 0x2F },
	{ "level3", "level3", 0xFFFF },
	{ "level4", "level4_1", 0x34 },
	{ "level4", "level4_2", 0x39 },
	{ "level5", "level5_1", 0x35 },
	{ "level5", "level5_2", 0xFFFF }
};

const uint16 Game::_scoreTable[] = {
	0, 200, 300, 400, 500, 800, 1000, 1200, 1500, 2000, 2200, 2500, 3000, 3200, 3500, 5000
};

const uint8 Game::_monsterListLevel1[] = {
	0x22, 0, 0x23, 0, 0xFF
};

const uint8 Game::_monsterListLevel2[] = {
	0x22, 0, 0x23, 0, 0x4B, 0, 0x49, 1, 0x4D, 1, 0x76, 2, 0xFF
};

const uint8 Game::_monsterListLevel3[] = {
	0x76, 2, 0xFF
};

const uint8 Game::_monsterListLevel4_1[] = {
	0x4D, 1, 0x76, 2, 0xFF
};

const uint8 Game::_monsterListLevel4_2[] = {
	0x76, 2, 0xAC, 2, 0xD7, 3, 0xFF
};

const uint8 Game::_monsterListLevel5_1[] = {
	0xB0, 3, 0xD7, 3, 0xFF
};

const uint8 Game::_monsterListLevel5_2[] = {
	0xB0, 3, 0xD7, 3, 0xD8, 3, 0xFF
};

const uint8 *Game::_monsterListLevels[] = {
	_monsterListLevel1,
	_monsterListLevel2,
	_monsterListLevel3,
	_monsterListLevel4_1,
	_monsterListLevel4_2,
	_monsterListLevel5_1,
	_monsterListLevel5_2
};

const uint8 Game::_monsterPals[4][32] = {
	{ // junkie
		0x00, 0x00, 0xAA, 0x0A, 0x65, 0x0A, 0x44, 0x08, 0x22, 0x06, 0x20, 0x03, 0x40, 0x05, 0x87, 0x0C,
		0x76, 0x0B, 0x34, 0x03, 0x55, 0x09, 0x30, 0x04, 0x60, 0x07, 0x55, 0x04, 0x77, 0x07, 0xFF, 0x0F
	},
	{ // mercenaire
		0x00, 0x00, 0x86, 0x0C, 0x66, 0x09, 0x44, 0x08, 0xFC, 0x05, 0xA2, 0x02, 0x49, 0x05, 0x02, 0x00,
		0x14, 0x02, 0x37, 0x04, 0x25, 0x03, 0x38, 0x06, 0xAF, 0x0C, 0x6F, 0x09, 0x4C, 0x07, 0xFF, 0x0F
	},
	{ // replicant
		0x00, 0x00, 0x79, 0x08, 0x44, 0x05, 0x55, 0x06, 0x66, 0x0B, 0x46, 0x05, 0x57, 0x06, 0x22, 0x03,
		0x44, 0x08, 0x33, 0x04, 0xAC, 0x08, 0x8A, 0x06, 0x68, 0x04, 0x56, 0x02, 0x35, 0x02, 0xCE, 0x0A
	},
	{ // glue
		0x00, 0x00, 0x6C, 0x00, 0x39, 0x02, 0x4C, 0x02, 0x27, 0x02, 0x10, 0x07, 0x15, 0x01, 0x00, 0x04,
		0x10, 0x05, 0x20, 0x08, 0x00, 0x02, 0x30, 0x09, 0x55, 0x0B, 0xFF, 0x0F, 0x33, 0x0A, 0xFF, 0x0F
	}
};

const char *Game::_monsterNames[] = {
	"junky",
	"mercenai",
	"replican",
	"glue"
};

const uint8 LocaleData::_stringsTableFR[] = {
	0x5A, 0x00, 0x71, 0x00, 0x90, 0x00, 0x97, 0x01, 0x58, 0x02, 0x7B, 0x02, 0xC5, 0x02, 0xEA, 0x02,
	0x50, 0x03, 0x6C, 0x03, 0xA8, 0x03, 0xF7, 0x03, 0x46, 0x04, 0x98, 0x04, 0x1C, 0x05, 0x57, 0x05,
	0x69, 0x05, 0xE1, 0x05, 0xF4, 0x05, 0x19, 0x06, 0xB5, 0x06, 0x9C, 0x08, 0x11, 0x09, 0x2B, 0x09,
	0x8D, 0x09, 0xA6, 0x09, 0xB9, 0x09, 0xDC, 0x09, 0xEF, 0x09, 0x13, 0x0A, 0x15, 0x0A, 0x17, 0x0A,
	0x7F, 0x0A, 0x90, 0x0A, 0x21, 0x0B, 0x4A, 0x0B, 0x08, 0x0C, 0x20, 0x0C, 0x44, 0x0C, 0x77, 0x0C,
	0x0E, 0x0D, 0x55, 0x0D, 0x93, 0x0D, 0xBB, 0x0D, 0xF5, 0x0D, 0x4C, 0x45, 0x20, 0x46, 0x55, 0x53,
	0x49, 0x42, 0x4C, 0x45, 0x20, 0x45, 0x53, 0x54, 0x0A, 0x47, 0x52, 0x49, 0x4C, 0x4C, 0x45, 0x2E,
	0x00, 0x4D, 0x41, 0x49, 0x4E, 0x54, 0x45, 0x4E, 0x41, 0x4E, 0x54, 0x20, 0x43, 0x41, 0x0A, 0x44,
	0x4F, 0x49, 0x54, 0x20, 0x46, 0x4F, 0x4E, 0x43, 0x54, 0x49, 0x4F, 0x4E, 0x4E, 0x45, 0x52, 0x00,
	0xFF, 0xEB, 0xEC, 0x4A, 0x27, 0x53, 0x55, 0x49, 0x53, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x2E, 0x0A,
	0x54, 0x55, 0x20, 0x56, 0x45, 0x55, 0x58, 0x20, 0x44, 0x45, 0x53, 0x20, 0x46, 0x41, 0x55, 0x58,
	0x0A, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52, 0x53, 0x3F, 0x0B, 0xFF, 0xE9, 0xEA, 0x4F, 0x55, 0x49,
	0x2C, 0x45, 0x54, 0x20, 0x4C, 0x45, 0x20, 0x50, 0x4C, 0x55, 0x53, 0x0A, 0x56, 0x49, 0x54, 0x45,
	0x20, 0x50, 0x4F, 0x53, 0x53, 0x49, 0x42, 0x4C, 0x45, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x31, 0x35,
	0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x21, 0x0B, 0xFF, 0xE9, 0xEA, 0x31,
	0x35, 0x30, 0x30, 0x3F, 0x3F, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x55, 0x41, 0x49, 0x53, 0x2C,
	0x4A, 0x27, 0x50, 0x52, 0x45, 0x4E, 0x44, 0x53, 0x0A, 0x55, 0x4E, 0x20, 0x47, 0x52, 0x4F, 0x53,
	0x20, 0x52, 0x49, 0x53, 0x51, 0x55, 0x45, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x4D, 0x41, 0x49, 0x53,
	0x20, 0x4A, 0x45, 0x20, 0x4E, 0x27, 0x41, 0x49, 0x20, 0x50, 0x41, 0x53, 0x0A, 0x41, 0x53, 0x53,
	0x45, 0x5A, 0x2E, 0x2E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x56, 0x41, 0x20, 0x41, 0x20, 0x4C, 0x27,
	0x41, 0x47, 0x45, 0x4E, 0x43, 0x45, 0x0A, 0x50, 0x4F, 0x55, 0x52, 0x20, 0x4C, 0x27, 0x45, 0x4D,
	0x50, 0x4C, 0x4F, 0x49, 0x20, 0x45, 0x54, 0x0A, 0x54, 0x55, 0x20, 0x41, 0x55, 0x52, 0x41, 0x53,
	0x20, 0x55, 0x4E, 0x20, 0x4A, 0x4F, 0x42, 0x2E, 0x0B, 0x45, 0x54, 0x20, 0x52, 0x45, 0x56, 0x49,
	0x45, 0x4E, 0x53, 0x20, 0x4D, 0x45, 0x0A, 0x56, 0x4F, 0x49, 0x52, 0x20, 0x51, 0x55, 0x41, 0x4E,
	0x44, 0x20, 0x54, 0x55, 0x0A, 0x41, 0x55, 0x52, 0x41, 0x53, 0x20, 0x44, 0x45, 0x0A, 0x4C, 0x27,
	0x41, 0x52, 0x47, 0x45, 0x4E, 0x54, 0x00, 0xFF, 0xEB, 0xEC, 0x4A, 0x27, 0x43, 0x4F, 0x4E, 0x4E,
	0x41, 0x49, 0x53, 0x20, 0x43, 0x45, 0x0A, 0x47, 0x41, 0x52, 0x53, 0x20, 0x4C, 0x41, 0x2E, 0x20,
	0x49, 0x4C, 0x20, 0x41, 0x0A, 0x55, 0x4E, 0x20, 0x41, 0x4D, 0x49, 0x20, 0x51, 0x55, 0x49, 0x20,
	0x45, 0x53, 0x54, 0x0A, 0x55, 0x4E, 0x20, 0x52, 0x4F, 0x42, 0x4F, 0x54, 0x2D, 0x46, 0x4C, 0x49,
	0x43, 0x2E, 0x0B, 0x4F, 0x55, 0x20, 0x50, 0x55, 0x49, 0x53, 0x2D, 0x4A, 0x45, 0x0A, 0x54, 0x52,
	0x4F, 0x55, 0x56, 0x45, 0x52, 0x20, 0x43, 0x45, 0x54, 0x20, 0x41, 0x4D, 0x49, 0x3F, 0x0B, 0x56,
	0x41, 0x20, 0x56, 0x4F, 0x49, 0x52, 0x20, 0x41, 0x20, 0x4C, 0x41, 0x0A, 0x52, 0x45, 0x53, 0x54,
	0x52, 0x49, 0x43, 0x54, 0x45, 0x44, 0x20, 0x41, 0x52, 0x45, 0x41, 0x0A, 0x31, 0x2E, 0x4A, 0x45,
	0x20, 0x43, 0x52, 0x4F, 0x49, 0x53, 0x20, 0x51, 0x55, 0x27, 0x49, 0x4C, 0x0A, 0x45, 0x53, 0x54,
	0x20, 0x44, 0x45, 0x20, 0x47, 0x41, 0x52, 0x44, 0x45, 0x0B, 0x4D, 0x41, 0x49, 0x53, 0x20, 0x46,
	0x41, 0x49, 0x53, 0x20, 0x47, 0x41, 0x46, 0x46, 0x45, 0x0A, 0x43, 0x45, 0x53, 0x20, 0x54, 0x59,
	0x50, 0x45, 0x53, 0x2D, 0x4C, 0x41, 0x20, 0x0A, 0x53, 0x4F, 0x4E, 0x54, 0x20, 0x44, 0x41, 0x4E,
	0x47, 0x45, 0x55, 0x52, 0x45, 0x55, 0x58, 0x00, 0xFF, 0xEB, 0xEC, 0x4A, 0x45, 0x20, 0x4E, 0x45,
	0x20, 0x53, 0x41, 0x49, 0x53, 0x20, 0x52, 0x49, 0x45, 0x4E, 0x0A, 0x44, 0x45, 0x20, 0x50, 0x4C,
	0x55, 0x53, 0x2C, 0x20, 0x47, 0x41, 0x4D, 0x49, 0x4E, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x43, 0x59,
	0x2D, 0x42, 0x30, 0x32, 0x31, 0x20, 0x56, 0x45, 0x55, 0x54, 0x0A, 0x50, 0x41, 0x53, 0x53, 0x45,
	0x52, 0x20, 0x55, 0x4E, 0x20, 0x4D, 0x41, 0x52, 0x43, 0x48, 0x45, 0x0A, 0x41, 0x56, 0x45, 0x43,
	0x20, 0x54, 0x4F, 0x49, 0x2E, 0x0B, 0x49, 0x4C, 0x20, 0x54, 0x27, 0x41, 0x54, 0x54, 0x45, 0x4E,
	0x44, 0x52, 0x41, 0x0A, 0x44, 0x45, 0x52, 0x52, 0x49, 0x45, 0x52, 0x45, 0x20, 0x4C, 0x45, 0x20,
	0x42, 0x41, 0x52, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x56, 0x41, 0x20, 0x41, 0x55, 0x20, 0x42, 0x41,
	0x52, 0x2C, 0x20, 0x50, 0x45, 0x54, 0x49, 0x54, 0x0A, 0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31,
	0x20, 0x54, 0x27, 0x41, 0x54, 0x54, 0x45, 0x4E, 0x44, 0x00, 0xFF, 0xEB, 0xEC, 0x4E, 0x45, 0x20,
	0x54, 0x49, 0x52, 0x45, 0x20, 0x50, 0x41, 0x53, 0x2E, 0x0A, 0x4A, 0x27, 0x53, 0x55, 0x49, 0x53,
	0x20, 0x50, 0x41, 0x53, 0x0A, 0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x2E, 0x0B, 0x53, 0x41,
	0x20, 0x50, 0x4C, 0x41, 0x4E, 0x51, 0x55, 0x45, 0x20, 0x45, 0x53, 0x54, 0x0A, 0x45, 0x4E, 0x20,
	0x44, 0x45, 0x53, 0x53, 0x4F, 0x55, 0x53, 0x0B, 0x43, 0x27, 0x45, 0x53, 0x54, 0x20, 0x53, 0x4F,
	0x4E, 0x20, 0x43, 0x4F, 0x50, 0x41, 0x49, 0x4E, 0x0A, 0x4C, 0x45, 0x20, 0x46, 0x4C, 0x49, 0x43,
	0x2C, 0x20, 0x51, 0x55, 0x49, 0x20, 0x41, 0x0A, 0x4C, 0x41, 0x20, 0x43, 0x4C, 0x45, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x4A, 0x45, 0x20, 0x4E, 0x45, 0x20, 0x53, 0x41, 0x49, 0x53, 0x20, 0x52, 0x49,
	0x45, 0x4E, 0x0A, 0x44, 0x45, 0x20, 0x50, 0x4C, 0x55, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4D,
	0x4F, 0x4E, 0x53, 0x49, 0x45, 0x55, 0x52, 0x2E, 0x2E, 0x2E, 0x0A, 0x55, 0x4E, 0x20, 0x44, 0x45,
	0x4E, 0x4F, 0x4D, 0x4D, 0x45, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x0A, 0x56, 0x4F, 0x55, 0x53, 0x20,
	0x44, 0x4F, 0x4E, 0x4E, 0x45, 0x20, 0x52, 0x2E, 0x44, 0x2E, 0x56, 0x0A, 0x50, 0x52, 0x45, 0x53,
	0x20, 0x44, 0x55, 0x20, 0x42, 0x41, 0x52, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52,
	0x41, 0x49, 0x53, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x20, 0x44, 0x45,
	0x0A, 0x54, 0x52, 0x41, 0x56, 0x41, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x48, 0x20,
	0x4E, 0x4F, 0x4E, 0x2E, 0x43, 0x27, 0x45, 0x53, 0x54, 0x20, 0x50, 0x41, 0x53, 0x0A, 0x49, 0x43,
	0x49, 0x2E, 0x20, 0x56, 0x4F, 0x59, 0x45, 0x5A, 0x20, 0x4C, 0x45, 0x0A, 0x47, 0x55, 0x49, 0x43,
	0x48, 0x45, 0x54, 0x20, 0x43, 0x2E, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52, 0x41,
	0x49, 0x53, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x20, 0x64, 0x65, 0x0A,
	0x54, 0x52, 0x41, 0x56, 0x41, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x4F, 0x4E, 0x2E,
	0x2E, 0x2E, 0x20, 0x4F, 0x4B, 0x2C, 0x4C, 0x45, 0x0A, 0x47, 0x4F, 0x55, 0x56, 0x45, 0x52, 0x4E,
	0x45, 0x55, 0x52, 0x20, 0x56, 0x41, 0x0A, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x52, 0x45, 0x43, 0x45,
	0x56, 0x4F, 0x49, 0x52, 0x2E, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52, 0x41, 0x49,
	0x53, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x20, 0x44, 0x45, 0x0A, 0x54,
	0x52, 0x41, 0x56, 0x41, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x48, 0x20, 0x4E, 0x4F,
	0x4E, 0x2E, 0x43, 0x45, 0x20, 0x4E, 0x27, 0x45, 0x53, 0x54, 0x0A, 0x50, 0x41, 0x53, 0x20, 0x49,
	0x43, 0x49, 0x2E, 0x20, 0x56, 0x4F, 0x59, 0x45, 0x5A, 0x0A, 0x4C, 0x45, 0x20, 0x47, 0x55, 0x49,
	0x43, 0x48, 0x45, 0x54, 0x20, 0x42, 0x2E, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52,
	0x41, 0x49, 0x53, 0x0A, 0x50, 0x41, 0x52, 0x4C, 0x45, 0x52, 0x20, 0x41, 0x20, 0x4A, 0x41, 0x43,
	0x4B, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x48, 0x20, 0x4F, 0x55, 0x41, 0x49, 0x53, 0x3F, 0x20,
	0x4A, 0x41, 0x43, 0x4B, 0x0A, 0x4E, 0x27, 0x45, 0x53, 0x54, 0x20, 0x50, 0x41, 0x53, 0x20, 0x4C,
	0x41, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x48, 0x55, 0x4D, 0x2E, 0x2E, 0x2E, 0x4A, 0x45, 0x20, 0x56,
	0x49, 0x45, 0x4E, 0x53, 0x0A, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x20, 0x50, 0x41, 0x52, 0x54, 0x20,
	0x44, 0x45, 0x0A, 0x4D, 0x4F, 0x4E, 0x20, 0x41, 0x4D, 0x49, 0x20, 0x49, 0x41, 0x4E, 0x2E, 0x0B,
	0xFF, 0xEB, 0xEC, 0x4F, 0x4B, 0x2E, 0x4A, 0x41, 0x43, 0x4B, 0x20, 0x54, 0x27, 0x41, 0x54, 0x54,
	0x45, 0x4E, 0x44, 0x0A, 0x44, 0x45, 0x48, 0x4F, 0x52, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x50,
	0x41, 0x53, 0x53, 0x45, 0x20, 0x54, 0x4F, 0x4E, 0x20, 0x43, 0x48, 0x45, 0x4D, 0x49, 0x4E, 0x0A,
	0x47, 0x41, 0x4D, 0x49, 0x4E, 0x2E, 0x20, 0x54, 0x27, 0x45, 0x53, 0x20, 0x54, 0x52, 0x4F, 0x50,
	0x0A, 0x4A, 0x45, 0x55, 0x4E, 0x45, 0x20, 0x50, 0x4F, 0x55, 0x52, 0x0A, 0x43, 0x4F, 0x4E, 0x53,
	0x4F, 0x4D, 0x4D, 0x45, 0x52, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52,
	0x53, 0x20, 0x53, 0x2E, 0x56, 0x2E, 0x50, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4A, 0x45, 0x20, 0x53,
	0x55, 0x49, 0x53, 0x20, 0x4C, 0x45, 0x0A, 0x43, 0x4F, 0x55, 0x52, 0x53, 0x49, 0x45, 0x52, 0x2E,
	0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x48, 0x20, 0x4F, 0x55, 0x49, 0x21, 0x56, 0x4F, 0x49, 0x4C, 0x41,
	0x2C, 0x0A, 0x41, 0x4D, 0x45, 0x4E, 0x45, 0x5A, 0x20, 0x43, 0x45, 0x20, 0x50, 0x41, 0x51, 0x55,
	0x45, 0x54, 0x0A, 0x41, 0x20, 0x4C, 0x27, 0x41, 0x47, 0x45, 0x4E, 0x43, 0x45, 0x20, 0x44, 0x45,
	0x0A, 0x56, 0x4F, 0x59, 0x41, 0x47, 0x45, 0x2E, 0x0B, 0x45, 0x54, 0x20, 0x46, 0x41, 0x49, 0x54,
	0x45, 0x53, 0x0A, 0x41, 0x54, 0x54, 0x45, 0x4E, 0x54, 0x49, 0x4F, 0x4E, 0x2C, 0x20, 0x43, 0x41,
	0x0A, 0x41, 0x20, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x20, 0x56, 0x41, 0x4C, 0x45, 0x55, 0x52, 0x2E,
	0x00, 0x4C, 0x45, 0x20, 0x54, 0x45, 0x4D, 0x50, 0x20, 0x45, 0x53, 0x54, 0x0A, 0x45, 0x43, 0x4F,
	0x55, 0x4C, 0x45, 0x00, 0x49, 0x4C, 0x20, 0x59, 0x20, 0x41, 0x20, 0x55, 0x4E, 0x0A, 0x45, 0x4D,
	0x50, 0x4C, 0x41, 0x43, 0x45, 0x4D, 0x45, 0x4E, 0x54, 0x20, 0x50, 0x4F, 0x55, 0x52, 0x0A, 0x4C,
	0x41, 0x20, 0x43, 0x41, 0x52, 0x54, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4D, 0x45, 0x52, 0x43,
	0x49, 0x20, 0x43, 0x4F, 0x4E, 0x52, 0x41, 0x44, 0x2E, 0x0A, 0x43, 0x45, 0x53, 0x20, 0x46, 0x4C,
	0x49, 0x43, 0x53, 0x0A, 0x4D, 0x27, 0x41, 0x55, 0x52, 0x41, 0x49, 0x45, 0x4E, 0x54, 0x20, 0x46,
	0x41, 0x49, 0x54, 0x0A, 0x4C, 0x41, 0x20, 0x50, 0x45, 0x41, 0x55, 0x0B, 0x42, 0x4F, 0x4E, 0x2C,
	0x4A, 0x45, 0x20, 0x53, 0x55, 0x50, 0x50, 0x4F, 0x53, 0x45, 0x0A, 0x51, 0x55, 0x45, 0x20, 0x54,
	0x55, 0x20, 0x4E, 0x45, 0x20, 0x54, 0x45, 0x0A, 0x52, 0x41, 0x50, 0x45, 0x4C, 0x4C, 0x45, 0x53,
	0x20, 0x50, 0x41, 0x53, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x4F, 0x4E, 0x20, 0x41, 0x4D, 0x49, 0x20,
	0x49, 0x41, 0x4E, 0x2E, 0x0B, 0x41, 0x4C, 0x4C, 0x45, 0x5A, 0x2C, 0x41, 0x53, 0x53, 0x49, 0x45,
	0x44, 0x53, 0x0A, 0x54, 0x4F, 0x49, 0x20, 0x53, 0x55, 0x52, 0x20, 0x43, 0x45, 0x0A, 0x53, 0x49,
	0x45, 0x47, 0x45, 0x2C, 0x4F, 0x4E, 0x20, 0x56, 0x41, 0x20, 0x59, 0x0A, 0x52, 0x45, 0x4D, 0x45,
	0x44, 0x49, 0x45, 0x52, 0x00, 0x49, 0x41, 0x4E, 0x2C, 0x43, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x54,
	0x0A, 0x46, 0x41, 0x49, 0x52, 0x45, 0x20, 0x50, 0x4F, 0x55, 0x52, 0x0A, 0x41, 0x4C, 0x4C, 0x45,
	0x52, 0x20, 0x53, 0x55, 0x52, 0x20, 0x54, 0x45, 0x52, 0x52, 0x45, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC,
	0x4C, 0x45, 0x20, 0x56, 0x4F, 0x59, 0x41, 0x47, 0x45, 0x20, 0x45, 0x53, 0x54, 0x0A, 0x48, 0x4F,
	0x52, 0x53, 0x20, 0x44, 0x45, 0x20, 0x50, 0x52, 0x49, 0x58, 0x2E, 0x0B, 0x4C, 0x45, 0x20, 0x53,
	0x45, 0x55, 0x4C, 0x20, 0x4D, 0x4F, 0x59, 0x45, 0x4E, 0x0A, 0x53, 0x45, 0x52, 0x41, 0x49, 0x54,
	0x20, 0x51, 0x55, 0x45, 0x20, 0x54, 0x55, 0x0A, 0x50, 0x41, 0x52, 0x54, 0x49, 0x43, 0x49, 0x50,
	0x45, 0x53, 0x20, 0x41, 0x55, 0x0A, 0x44, 0x45, 0x41, 0x54, 0x48, 0x20, 0x54, 0x4F, 0x57, 0x45,
	0x52, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x44, 0x45, 0x41, 0x54, 0x48, 0x20, 0x54, 0x4F, 0x57, 0x45,
	0x52, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x55, 0x49, 0x2C, 0x43, 0x27, 0x45, 0x53, 0x54, 0x20,
	0x55, 0x4E, 0x20, 0x4A, 0x45, 0x55, 0x0A, 0x54, 0x45, 0x4C, 0x45, 0x56, 0x49, 0x53, 0x45, 0x2E,
	0x4C, 0x45, 0x0A, 0x47, 0x41, 0x47, 0x4E, 0x41, 0x4E, 0x54, 0x20, 0x52, 0x45, 0x43, 0x4F, 0x49,
	0x54, 0x0A, 0x55, 0x4E, 0x20, 0x42, 0x49, 0x4C, 0x4C, 0x45, 0x54, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA,
	0x4F, 0x4B, 0x2E, 0x49, 0x4C, 0x20, 0x4D, 0x45, 0x20, 0x46, 0x41, 0x55, 0x54, 0x0A, 0x41, 0x55,
	0x53, 0x53, 0x49, 0x20, 0x44, 0x45, 0x53, 0x20, 0x46, 0x41, 0x55, 0x58, 0x0A, 0x50, 0x41, 0x50,
	0x49, 0x45, 0x52, 0x53, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x4F, 0x20, 0x50, 0x52, 0x4F, 0x42,
	0x4C, 0x45, 0x4D, 0x4F, 0x2C, 0x0A, 0x56, 0x41, 0x20, 0x41, 0x55, 0x20, 0x42, 0x41, 0x52, 0x2C,
	0x20, 0x45, 0x54, 0x0A, 0x44, 0x45, 0x4D, 0x41, 0x4E, 0x44, 0x45, 0x20, 0x4A, 0x41, 0x43, 0x4B,
	0x0A, 0x44, 0x45, 0x20, 0x4D, 0x41, 0x20, 0x50, 0x41, 0x52, 0x54, 0x2E, 0x0B, 0x41, 0x48, 0x2C,
	0x41, 0x55, 0x20, 0x46, 0x41, 0x49, 0x54, 0x2C, 0x4A, 0x45, 0x0A, 0x54, 0x27, 0x41, 0x49, 0x20,
	0x4D, 0x49, 0x53, 0x20, 0x44, 0x41, 0x4E, 0x53, 0x20, 0x4C, 0x41, 0x0A, 0x50, 0x4F, 0x43, 0x48,
	0x45, 0x20, 0x4C, 0x45, 0x20, 0x43, 0x48, 0x41, 0x4D, 0x50, 0x0A, 0x44, 0x45, 0x20, 0x50, 0x52,
	0x4F, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4F, 0x4E, 0x0B, 0x51, 0x55, 0x45, 0x20, 0x54, 0x55, 0x20,
	0x4D, 0x27, 0x41, 0x56, 0x41, 0x49, 0x53, 0x0A, 0x43, 0x4F, 0x4D, 0x4D, 0x41, 0x4E, 0x44, 0x45,
	0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x50, 0x41, 0x52, 0x46, 0x41, 0x49, 0x54, 0x2E, 0x4A, 0x45, 0x20,
	0x54, 0x45, 0x0A, 0x52, 0x45, 0x4D, 0x45, 0x52, 0x43, 0x49, 0x45, 0x2E, 0x20, 0x41, 0x20, 0x4C,
	0x41, 0x0A, 0x50, 0x52, 0x4F, 0x43, 0x48, 0x41, 0x49, 0x4E, 0x45, 0x2C, 0x20, 0x49, 0x41, 0x4E,
	0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x4F, 0x4E, 0x4E, 0x45, 0x20, 0x43, 0x48, 0x41, 0x4E, 0x43,
	0x45, 0x2E, 0x4A, 0x45, 0x0A, 0x54, 0x45, 0x20, 0x43, 0x4F, 0x4E, 0x54, 0x41, 0x43, 0x54, 0x45,
	0x52, 0x41, 0x49, 0x0A, 0x41, 0x20, 0x54, 0x4F, 0x4E, 0x20, 0x41, 0x52, 0x52, 0x49, 0x56, 0x45,
	0x20, 0x53, 0x55, 0x52, 0x0A, 0x54, 0x45, 0x52, 0x52, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42,
	0x49, 0x45, 0x4E, 0x56, 0x45, 0x4E, 0x55, 0x45, 0x20, 0x41, 0x0A, 0x4E, 0x45, 0x57, 0x20, 0x57,
	0x41, 0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x2C, 0x0A, 0x4A, 0x45, 0x55, 0x4E, 0x45,
	0x20, 0x48, 0x4F, 0x4D, 0x4D, 0x45, 0x2E, 0x0B, 0x56, 0x4F, 0x49, 0x43, 0x49, 0x20, 0x55, 0x4E,
	0x20, 0x50, 0x4C, 0x41, 0x4E, 0x0A, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x20, 0x56, 0x49, 0x4C, 0x4C,
	0x45, 0x2C, 0x20, 0x49, 0x4C, 0x0A, 0x50, 0x4F, 0x55, 0x52, 0x52, 0x41, 0x20, 0x56, 0x4F, 0x55,
	0x53, 0x20, 0x45, 0x54, 0x52, 0x45, 0x0A, 0x55, 0x54, 0x49, 0x4C, 0x45, 0x2E, 0x0B, 0xFF, 0xE9,
	0xEA, 0x4D, 0x45, 0x52, 0x43, 0x49, 0x2C, 0x4D, 0x4F, 0x4E, 0x53, 0x49, 0x45, 0x55, 0x52, 0x2E,
	0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x4F, 0x4E, 0x20, 0x53, 0x45, 0x4A, 0x4F, 0x55, 0x52, 0x2C, 0x50,
	0x41, 0x52, 0x4D, 0x49, 0x0A, 0x4E, 0x4F, 0x55, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x4F,
	0x55, 0x52, 0x20, 0x54, 0x52, 0x41, 0x56, 0x41, 0x49, 0x4C, 0x4C, 0x45, 0x52, 0x0A, 0x49, 0x4C,
	0x20, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x46, 0x41, 0x55, 0x54, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45,
	0x52, 0x4D, 0x49, 0x53, 0x2E, 0x0B, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x50, 0x4F, 0x55, 0x52, 0x52,
	0x45, 0x5A, 0x20, 0x45, 0x4E, 0x0A, 0x4F, 0x42, 0x54, 0x45, 0x4E, 0x49, 0x52, 0x20, 0x55, 0x4E,
	0x20, 0x41, 0x55, 0x0A, 0x43, 0x45, 0x4E, 0x54, 0x52, 0x45, 0x20, 0x41, 0x44, 0x4D, 0x49, 0x4E,
	0x49, 0x53, 0x2D, 0x0A, 0x2D, 0x54, 0x52, 0x41, 0x54, 0x49, 0x46, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x4A, 0x45, 0x20, 0x4E, 0x27, 0x41, 0x49, 0x20, 0x50, 0x41, 0x53, 0x20, 0x4C, 0x45, 0x0A, 0x54,
	0x45, 0x4D, 0x50, 0x53, 0x2E, 0x00, 0x42, 0x4F, 0x4E, 0x4A, 0x4F, 0x55, 0x52, 0x20, 0x43, 0x48,
	0x45, 0x5A, 0x0A, 0x56, 0x4F, 0x55, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4A, 0x27, 0x41, 0x49,
	0x20, 0x44, 0x45, 0x4A, 0x41, 0x20, 0x56, 0x55, 0x0A, 0x43, 0x45, 0x20, 0x54, 0x59, 0x50, 0x45,
	0x20, 0x4C, 0x41, 0x20, 0x41, 0x55, 0x0A, 0x42, 0x41, 0x52, 0x2E, 0x00, 0x42, 0x4F, 0x4E, 0x4A,
	0x4F, 0x55, 0x52, 0x20, 0x43, 0x48, 0x45, 0x5A, 0x0A, 0x56, 0x4F, 0x55, 0x53, 0x2E, 0x00, 0x4F,
	0x55, 0x49, 0x2C, 0x4A, 0x45, 0x20, 0x4C, 0x45, 0x0A, 0x43, 0x4F, 0x4E, 0x4E, 0x41, 0x49, 0x53,
	0x2E, 0x43, 0x27, 0x45, 0x53, 0x54, 0x20, 0x55, 0x4E, 0x0A, 0x48, 0x41, 0x42, 0x49, 0x54, 0x55,
	0x45, 0x2E, 0x00, 0x20, 0x00, 0x20, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52, 0x41,
	0x49, 0x53, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x20, 0x44, 0x45, 0x0A,
	0x54, 0x52, 0x41, 0x56, 0x41, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x50, 0x41, 0x53, 0x20,
	0x44, 0x45, 0x20, 0x50, 0x52, 0x4F, 0x42, 0x4C, 0x45, 0x4D, 0x45, 0x0A, 0x50, 0x4F, 0x55, 0x52,
	0x20, 0x41, 0x56, 0x4F, 0x49, 0x52, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53,
	0x2E, 0x2E, 0x2E, 0x0B, 0x49, 0x4C, 0x20, 0x4D, 0x45, 0x20, 0x46, 0x41, 0x55, 0x54, 0x0A, 0x56,
	0x4F, 0x54, 0x52, 0x45, 0x20, 0x43, 0x41, 0x52, 0x54, 0x45, 0x20, 0x49, 0x44, 0x2E, 0x00, 0xFF,
	0xEB, 0xEC, 0x41, 0x55, 0x20, 0x53, 0x45, 0x43, 0x4F, 0x55, 0x52, 0x53, 0x2E, 0x2E, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x41, 0x49, 0x44, 0x45, 0x5A, 0x20, 0x4D, 0x4F, 0x49, 0x2C, 0x4A, 0x45, 0x55,
	0x4E, 0x45, 0x0A, 0x48, 0x4F, 0x4D, 0x4D, 0x45, 0x2E, 0x4A, 0x27, 0x41, 0x49, 0x20, 0x45, 0x54,
	0x45, 0x0A, 0x41, 0x54, 0x54, 0x41, 0x51, 0x55, 0x45, 0x20, 0x50, 0x41, 0x52, 0x20, 0x44, 0x45,
	0x53, 0x0A, 0x4D, 0x55, 0x54, 0x41, 0x4E, 0x54, 0x53, 0x2E, 0x2E, 0x2E, 0x0B, 0x45, 0x54, 0x20,
	0x4A, 0x45, 0x20, 0x4E, 0x45, 0x20, 0x50, 0x45, 0x55, 0x58, 0x0A, 0x50, 0x4C, 0x55, 0x53, 0x20,
	0x4D, 0x41, 0x52, 0x43, 0x48, 0x45, 0x52, 0x0B, 0x52, 0x45, 0x54, 0x52, 0x4F, 0x55, 0x56, 0x45,
	0x5A, 0x20, 0x4D, 0x4F, 0x4E, 0x0A, 0x54, 0x45, 0x4C, 0x45, 0x50, 0x4F, 0x52, 0x54, 0x45, 0x55,
	0x52, 0x2C, 0x0A, 0x49, 0x4C, 0x20, 0x4D, 0x45, 0x20, 0x46, 0x41, 0x55, 0x54, 0x20, 0x44, 0x45,
	0x53, 0x0A, 0x53, 0x4F, 0x49, 0x4E, 0x53, 0x20, 0x55, 0x52, 0x47, 0x45, 0x4E, 0x54, 0x53, 0x2E,
	0x00, 0xFF, 0xEB, 0xEC, 0x4D, 0x45, 0x52, 0x43, 0x49, 0x2E, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x56,
	0x45, 0x4E, 0x45, 0x5A, 0x0A, 0x44, 0x45, 0x20, 0x4D, 0x45, 0x20, 0x53, 0x41, 0x55, 0x56, 0x45,
	0x52, 0x20, 0x4C, 0x41, 0x0A, 0x56, 0x49, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x4F, 0x55,
	0x52, 0x20, 0x41, 0x4C, 0x4C, 0x45, 0x52, 0x20, 0x41, 0x20, 0x4E, 0x45, 0x57, 0x0A, 0x57, 0x41,
	0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x2C, 0x54, 0x55, 0x0A, 0x44, 0x4F, 0x49, 0x53,
	0x20, 0x53, 0x41, 0x55, 0x54, 0x45, 0x52, 0x20, 0x44, 0x41, 0x4E, 0x53, 0x0A, 0x43, 0x45, 0x20,
	0x47, 0x52, 0x41, 0x4E, 0x44, 0x20, 0x54, 0x52, 0x4F, 0x55, 0x0B, 0x4D, 0x41, 0x49, 0x53, 0x20,
	0x41, 0x20, 0x54, 0x41, 0x20, 0x50, 0x4C, 0x41, 0x43, 0x45, 0x0A, 0x4A, 0x27, 0x55, 0x54, 0x49,
	0x4C, 0x49, 0x53, 0x45, 0x52, 0x41, 0x49, 0x53, 0x0A, 0x55, 0x4E, 0x45, 0x20, 0x43, 0x45, 0x49,
	0x4E, 0x54, 0x55, 0x52, 0x45, 0x0A, 0x41, 0x4E, 0x54, 0x49, 0x2D, 0x47, 0x2E, 0x0B, 0xFF, 0xE9,
	0xEA, 0x4F, 0x55, 0x20, 0x50, 0x55, 0x49, 0x53, 0x2D, 0x4A, 0x45, 0x20, 0x45, 0x4E, 0x0A, 0x54,
	0x52, 0x4F, 0x55, 0x56, 0x45, 0x52, 0x20, 0x55, 0x4E, 0x45, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x48,
	0x45, 0x2E, 0x48, 0x45, 0x2E, 0x4A, 0x45, 0x20, 0x50, 0x45, 0x55, 0x58, 0x0A, 0x54, 0x45, 0x20,
	0x4C, 0x41, 0x20, 0x56, 0x45, 0x4E, 0x44, 0x52, 0x45, 0x3A, 0x0A, 0x35, 0x30, 0x30, 0x20, 0x43,
	0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x2E, 0x00, 0x42, 0x4F, 0x4E, 0x20, 0x56, 0x4F, 0x59, 0x41,
	0x47, 0x45, 0x2C, 0x4A, 0x45, 0x55, 0x4E, 0x45, 0x0A, 0x48, 0x4F, 0x4D, 0x4D, 0x45, 0x2E, 0x00,
	0x49, 0x4C, 0x20, 0x46, 0x41, 0x55, 0x44, 0x52, 0x41, 0x49, 0x54, 0x0A, 0x55, 0x4E, 0x45, 0x20,
	0x50, 0x49, 0x4C, 0x45, 0x0A, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x45, 0x20, 0x41, 0x20, 0x42,
	0x4C, 0x4F, 0x43, 0x00, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x44, 0x52, 0x41, 0x49, 0x53, 0x20,
	0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x52, 0x41,
	0x56, 0x41, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x50, 0x52, 0x45, 0x4D, 0x49, 0x45, 0x52,
	0x20, 0x45, 0x54, 0x41, 0x47, 0x45, 0x00, 0x55, 0x4E, 0x45, 0x20, 0x56, 0x4F, 0x49, 0x58, 0x0A,
	0x49, 0x4E, 0x54, 0x45, 0x52, 0x49, 0x45, 0x55, 0x52, 0x45, 0x20, 0x73, 0x65, 0x0A, 0x46, 0x41,
	0x49, 0x54, 0x20, 0x45, 0x4E, 0x54, 0x45, 0x4E, 0x44, 0x52, 0x45, 0x3A, 0x0B, 0xFF, 0xEB, 0xEC,
	0x46, 0x41, 0x49, 0x53, 0x2D, 0x4D, 0x4F, 0x49, 0x0A, 0x43, 0x4F, 0x4E, 0x46, 0x49, 0x41, 0x4E,
	0x43, 0x45, 0x2E, 0x50, 0x4F, 0x53, 0x45, 0x0A, 0x4C, 0x41, 0x20, 0x43, 0x48, 0x41, 0x52, 0x47,
	0x45, 0x0A, 0x41, 0x54, 0x4F, 0x4D, 0x49, 0x51, 0x55, 0x45, 0x20, 0x49, 0x43, 0x49, 0x2E, 0x2E,
	0x2E, 0x0B, 0x45, 0x54, 0x20, 0x46, 0x55, 0x49, 0x53, 0x20, 0x41, 0x56, 0x41, 0x4E, 0x54, 0x0A,
	0x51, 0x55, 0x27, 0x45, 0x4C, 0x4C, 0x45, 0x20, 0x4E, 0x27, 0x41, 0x54, 0x2D, 0x0A, 0x2D, 0x54,
	0x45, 0x49, 0x47, 0x4E, 0x45, 0x20, 0x4C, 0x45, 0x20, 0x4E, 0x4F, 0x59, 0x41, 0x55, 0x0A, 0x44,
	0x45, 0x20, 0x4C, 0x41, 0x20, 0x50, 0x4C, 0x41, 0x4E, 0x45, 0x54, 0x45, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x4A, 0x45, 0x20, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x53, 0x55, 0x49, 0x53, 0x2C, 0x0A, 0x4A,
	0x45, 0x55, 0x4E, 0x45, 0x20, 0x48, 0x4F, 0x4D, 0x4D, 0x45, 0x2E, 0x0B, 0x47, 0x55, 0x49, 0x44,
	0x45, 0x5A, 0x2D, 0x4D, 0x4F, 0x49, 0x0A, 0x4A, 0x55, 0x53, 0x51, 0x55, 0x27, 0x41, 0x55, 0x20,
	0x43, 0x45, 0x4E, 0x54, 0x52, 0x45, 0x0A, 0x44, 0x45, 0x20, 0x52, 0x45, 0x43, 0x48, 0x45, 0x52,
	0x43, 0x48, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4D, 0x45, 0x52, 0x43, 0x49, 0x20, 0x44, 0x45,
	0x20, 0x56, 0x4F, 0x54, 0x52, 0x45, 0x0A, 0x41, 0x49, 0x44, 0x45, 0x2E, 0x2E, 0x2E, 0x0B, 0x49,
	0x4C, 0x20, 0x4E, 0x27, 0x59, 0x20, 0x41, 0x20, 0x50, 0x4C, 0x55, 0x53, 0x0A, 0x44, 0x45, 0x20,
	0x44, 0x41, 0x4E, 0x47, 0x45, 0x52, 0x2C, 0x0A, 0x4D, 0x41, 0x49, 0x4E, 0x54, 0x45, 0x4E, 0x41,
	0x4E, 0x54, 0x00, 0xFF, 0xEB, 0xEC, 0x41, 0x4C, 0x4F, 0x52, 0x53, 0x2C, 0x4D, 0x27, 0x41, 0x56,
	0x45, 0x5A, 0x0A, 0x56, 0x4F, 0x55, 0x53, 0x20, 0x41, 0x50, 0x50, 0x4F, 0x52, 0x54, 0x45, 0x0A,
	0x4C, 0x45, 0x20, 0x50, 0x41, 0x51, 0x55, 0x45, 0x54, 0x3F, 0x00, 0x43, 0x4F, 0x4D, 0x42, 0x49,
	0x45, 0x4E, 0x20, 0x43, 0x4F, 0x55, 0x54, 0x45, 0x0A, 0x55, 0x4E, 0x20, 0x42, 0x49, 0x4C, 0x4C,
	0x45, 0x54, 0x20, 0x50, 0x4F, 0x55, 0x52, 0x0A, 0x4C, 0x41, 0x20, 0x54, 0x45, 0x52, 0x52, 0x45,
	0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x35, 0x30, 0x20, 0x30, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44,
	0x49, 0x54, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x4F, 0x4E, 0x4E, 0x41, 0x4E, 0x54, 0x2C,
	0x44, 0x4F, 0x4E, 0x4E, 0x41, 0x4E, 0x54, 0x2E, 0x0A, 0x31, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52,
	0x45, 0x44, 0x49, 0x54, 0x53, 0x20, 0x45, 0x54, 0x0A, 0x4C, 0x45, 0x53, 0x20, 0x50, 0x41, 0x50,
	0x49, 0x45, 0x52, 0x53, 0x20, 0x53, 0x4F, 0x4E, 0x54, 0x0A, 0x41, 0x20, 0x54, 0x4F, 0x49, 0x2E,
	0x00
};

const uint8 LocaleData::_stringsTableEN[] = {
	0x5A, 0x00, 0x6D, 0x00, 0x83, 0x00, 0x97, 0x01, 0x48, 0x02, 0x6C, 0x02, 0xB7, 0x02, 0xE9, 0x02,
	0x40, 0x03, 0x5F, 0x03, 0x9F, 0x03, 0xDB, 0x03, 0x1D, 0x04, 0x59, 0x04, 0xDD, 0x04, 0x08, 0x05,
	0x1A, 0x05, 0x83, 0x05, 0x8E, 0x05, 0xAC, 0x05, 0x39, 0x06, 0x23, 0x08, 0x8E, 0x08, 0xA2, 0x08,
	0xF3, 0x08, 0x09, 0x09, 0x28, 0x09, 0x51, 0x09, 0x70, 0x09, 0x93, 0x09, 0x95, 0x09, 0x97, 0x09,
	0xEE, 0x09, 0x00, 0x0A, 0x80, 0x0A, 0xA2, 0x0A, 0x4B, 0x0B, 0x64, 0x0B, 0x8F, 0x0B, 0xB7, 0x0B,
	0x40, 0x0C, 0x76, 0x0C, 0xC7, 0x0C, 0xF4, 0x0C, 0x26, 0x0D, 0x54, 0x68, 0x65, 0x20, 0x66, 0x75,
	0x73, 0x65, 0x20, 0x69, 0x73, 0x0A, 0x62, 0x6C, 0x6F, 0x77, 0x6E, 0x2E, 0x00, 0x54, 0x68, 0x61,
	0x74, 0x20, 0x73, 0x68, 0x6F, 0x75, 0x6C, 0x64, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x6E, 0x6F,
	0x77, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x27, 0x6D, 0x20, 0x4A, 0x61, 0x63, 0x6B, 0x2E, 0x59,
	0x6F, 0x75, 0x27, 0x72, 0x65, 0x0A, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x73, 0x6F, 0x6D, 0x65,
	0x20, 0x66, 0x61, 0x6C, 0x73, 0x65, 0x0A, 0x70, 0x61, 0x70, 0x65, 0x72, 0x73, 0x3F, 0x0B, 0xFF,
	0xE9, 0xEA, 0x59, 0x65, 0x73, 0x2C, 0x61, 0x6E, 0x64, 0x20, 0x61, 0x73, 0x0A, 0x71, 0x75, 0x69,
	0x63, 0x6B, 0x6C, 0x79, 0x20, 0x61, 0x73, 0x0A, 0x70, 0x6F, 0x73, 0x73, 0x69, 0x62, 0x6C, 0x65,
	0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x31, 0x35, 0x30, 0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74,
	0x73, 0x21, 0x0B, 0xFF, 0xE9, 0xEA, 0x31, 0x35, 0x30, 0x30, 0x3F, 0x3F, 0x3F, 0x0B, 0xFF, 0xEB,
	0xEC, 0x59, 0x65, 0x61, 0x68, 0x2C, 0x49, 0x27, 0x6D, 0x20, 0x74, 0x61, 0x6B, 0x69, 0x6E, 0x67,
	0x0A, 0x61, 0x20, 0x62, 0x69, 0x67, 0x20, 0x72, 0x69, 0x73, 0x6B, 0x20, 0x68, 0x65, 0x72, 0x65,
	0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x42, 0x75, 0x74, 0x20, 0x49, 0x20, 0x64, 0x6F, 0x6E, 0x27, 0x74,
	0x0A, 0x68, 0x61, 0x76, 0x65, 0x20, 0x65, 0x6E, 0x6F, 0x75, 0x67, 0x68, 0x2E, 0x2E, 0x2E, 0x0B,
	0xFF, 0xEB, 0xEC, 0x47, 0x6F, 0x20, 0x74, 0x6F, 0x20, 0x74, 0x68, 0x65, 0x0A, 0x45, 0x6D, 0x70,
	0x6C, 0x6F, 0x79, 0x6D, 0x65, 0x6E, 0x74, 0x0A, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x2C, 0x20,
	0x79, 0x6F, 0x75, 0x27, 0x6C, 0x6C, 0x0A, 0x66, 0x69, 0x6E, 0x64, 0x20, 0x77, 0x6F, 0x72, 0x6B,
	0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x2E, 0x0B, 0x41, 0x6E, 0x64, 0x20, 0x63, 0x6F, 0x6D, 0x65,
	0x20, 0x62, 0x61, 0x63, 0x6B, 0x20, 0x74, 0x6F, 0x0A, 0x6D, 0x65, 0x20, 0x77, 0x68, 0x65, 0x6E,
	0x20, 0x79, 0x6F, 0x75, 0x27, 0x76, 0x65, 0x0A, 0x67, 0x6F, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x6D, 0x6F, 0x6E, 0x65, 0x79, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x20, 0x6B, 0x6E, 0x6F, 0x77,
	0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x67, 0x75, 0x79, 0x2E, 0x0A, 0x48, 0x65, 0x20, 0x68, 0x61,
	0x73, 0x20, 0x61, 0x20, 0x66, 0x72, 0x69, 0x65, 0x6E, 0x64, 0x0A, 0x69, 0x6E, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x70, 0x6F, 0x6C, 0x69, 0x63, 0x65, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x57, 0x68, 0x65,
	0x72, 0x65, 0x20, 0x63, 0x61, 0x6E, 0x20, 0x49, 0x20, 0x66, 0x69, 0x6E, 0x64, 0x0A, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x66, 0x72, 0x69, 0x65, 0x6E, 0x64, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x47, 0x6F,
	0x20, 0x74, 0x6F, 0x20, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x0A, 0x41,
	0x72, 0x65, 0x61, 0x20, 0x31, 0x2C, 0x20, 0x49, 0x20, 0x74, 0x68, 0x69, 0x6E, 0x6B, 0x0A, 0x68,
	0x65, 0x27, 0x73, 0x20, 0x6F, 0x6E, 0x20, 0x64, 0x75, 0x74, 0x79, 0x0A, 0x74, 0x68, 0x65, 0x72,
	0x65, 0x2E, 0x0B, 0x42, 0x75, 0x74, 0x20, 0x62, 0x65, 0x20, 0x63, 0x61, 0x72, 0x65, 0x66, 0x75,
	0x6C, 0x2C, 0x0A, 0x74, 0x68, 0x6F, 0x73, 0x65, 0x20, 0x67, 0x75, 0x79, 0x73, 0x20, 0x61, 0x72,
	0x65, 0x0A, 0x6D, 0x65, 0x61, 0x6E, 0x21, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x20, 0x64, 0x6F, 0x6E,
	0x27, 0x74, 0x20, 0x6B, 0x6E, 0x6F, 0x77, 0x0A, 0x61, 0x6E, 0x79, 0x74, 0x68, 0x69, 0x6E, 0x67,
	0x20, 0x6D, 0x6F, 0x72, 0x65, 0x2C, 0x0A, 0x73, 0x6F, 0x6E, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x43,
	0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x20, 0x77, 0x61, 0x6E, 0x74, 0x73, 0x0A, 0x74, 0x6F, 0x20,
	0x6D, 0x61, 0x6B, 0x65, 0x20, 0x61, 0x20, 0x64, 0x65, 0x61, 0x6C, 0x0A, 0x77, 0x69, 0x74, 0x68,
	0x20, 0x79, 0x6F, 0x75, 0x2E, 0x0B, 0x48, 0x65, 0x27, 0x6C, 0x6C, 0x20, 0x62, 0x65, 0x20, 0x77,
	0x61, 0x69, 0x74, 0x69, 0x6E, 0x67, 0x0A, 0x62, 0x65, 0x68, 0x69, 0x6E, 0x64, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x62, 0x61, 0x72, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x6F, 0x20, 0x74, 0x6F, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x72, 0x2C, 0x0A, 0x73, 0x6F, 0x6E, 0x2C, 0x20, 0x43, 0x59,
	0x2D, 0x42, 0x30, 0x32, 0x31, 0x27, 0x73, 0x0A, 0x77, 0x61, 0x69, 0x74, 0x69, 0x6E, 0x67, 0x20,
	0x66, 0x6F, 0x72, 0x20, 0x79, 0x6F, 0x75, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x6F, 0x6E, 0x27,
	0x74, 0x20, 0x73, 0x68, 0x6F, 0x6F, 0x74, 0x2C, 0x49, 0x27, 0x6D, 0x0A, 0x6E, 0x6F, 0x74, 0x20,
	0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x21, 0x0B, 0x48, 0x69, 0x73, 0x20, 0x68, 0x69, 0x64,
	0x65, 0x6F, 0x75, 0x74, 0x27, 0x73, 0x0A, 0x64, 0x6F, 0x77, 0x6E, 0x20, 0x62, 0x65, 0x6C, 0x6F,
	0x77, 0x2E, 0x0B, 0x48, 0x69, 0x73, 0x20, 0x70, 0x61, 0x6C, 0x2C, 0x74, 0x68, 0x65, 0x20, 0x63,
	0x6F, 0x70, 0x0A, 0x68, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6B, 0x65, 0x79, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x49, 0x20, 0x64, 0x6F, 0x6E, 0x27, 0x74, 0x20, 0x6B, 0x6E, 0x6F, 0x77, 0x0A,
	0x61, 0x6E, 0x79, 0x74, 0x68, 0x69, 0x6E, 0x67, 0x20, 0x65, 0x6C, 0x73, 0x65, 0x2E, 0x00, 0xFF,
	0xEB, 0xEC, 0x53, 0x69, 0x72, 0x2E, 0x2E, 0x2E, 0x20, 0x73, 0x6F, 0x6D, 0x65, 0x20, 0x67, 0x75,
	0x79, 0x0B, 0x63, 0x61, 0x6C, 0x6C, 0x65, 0x64, 0x20, 0x4A, 0x61, 0x63, 0x6B, 0x0A, 0x61, 0x72,
	0x72, 0x61, 0x6E, 0x67, 0x65, 0x64, 0x20, 0x74, 0x6F, 0x20, 0x6D, 0x65, 0x65, 0x74, 0x0A, 0x79,
	0x6F, 0x75, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x72, 0x2E, 0x00, 0x49,
	0x27, 0x64, 0x20, 0x6C, 0x69, 0x6B, 0x65, 0x20, 0x61, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x70,
	0x65, 0x72, 0x6D, 0x69, 0x74, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x2C, 0x20, 0x69, 0x74,
	0x27, 0x73, 0x20, 0x6E, 0x6F, 0x74, 0x0A, 0x68, 0x65, 0x72, 0x65, 0x2E, 0x20, 0x53, 0x65, 0x65,
	0x20, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x0A, 0x43, 0x2E, 0x00, 0x49, 0x27, 0x64, 0x20, 0x6C,
	0x69, 0x6B, 0x65, 0x20, 0x61, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x70, 0x65, 0x72, 0x6D, 0x69,
	0x74, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x47, 0x6F, 0x6F, 0x64, 0x2E, 0x2E, 0x2E, 0x4F, 0x2E, 0x6B,
	0x2E, 0x2C, 0x74, 0x68, 0x65, 0x0A, 0x62, 0x6F, 0x73, 0x73, 0x20, 0x77, 0x69, 0x6C, 0x6C, 0x20,
	0x73, 0x65, 0x65, 0x0A, 0x79, 0x6F, 0x75, 0x20, 0x6E, 0x6F, 0x77, 0x2E, 0x00, 0x49, 0x27, 0x64,
	0x20, 0x6C, 0x69, 0x6B, 0x65, 0x20, 0x61, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x70, 0x65, 0x72,
	0x6D, 0x69, 0x74, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x2C, 0x20, 0x69, 0x74, 0x27, 0x73,
	0x20, 0x6E, 0x6F, 0x74, 0x0A, 0x68, 0x65, 0x72, 0x65, 0x2E, 0x20, 0x53, 0x65, 0x65, 0x20, 0x57,
	0x69, 0x6E, 0x64, 0x6F, 0x77, 0x0A, 0x42, 0x2E, 0x00, 0x49, 0x27, 0x64, 0x20, 0x6C, 0x69, 0x6B,
	0x65, 0x20, 0x74, 0x6F, 0x0A, 0x73, 0x70, 0x65, 0x61, 0x6B, 0x20, 0x74, 0x6F, 0x20, 0x4A, 0x61,
	0x63, 0x6B, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x68, 0x20, 0x79, 0x65, 0x61, 0x68, 0x3F, 0x20,
	0x4A, 0x61, 0x63, 0x6B, 0x27, 0x73, 0x0A, 0x6E, 0x6F, 0x74, 0x20, 0x68, 0x65, 0x72, 0x65, 0x2E,
	0x0B, 0xFF, 0xE9, 0xEA, 0x49, 0x27, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6E, 0x20, 0x73, 0x65,
	0x6E, 0x74, 0x0A, 0x62, 0x79, 0x20, 0x6D, 0x79, 0x20, 0x66, 0x72, 0x69, 0x65, 0x6E, 0x64, 0x0A,
	0x49, 0x61, 0x6E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x2E, 0x6B, 0x2E, 0x20, 0x4A, 0x61, 0x63,
	0x6B, 0x27, 0x73, 0x0A, 0x77, 0x61, 0x69, 0x74, 0x69, 0x6E, 0x67, 0x20, 0x66, 0x6F, 0x72, 0x20,
	0x79, 0x6F, 0x75, 0x0A, 0x6F, 0x75, 0x74, 0x73, 0x69, 0x64, 0x65, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x42, 0x65, 0x61, 0x74, 0x20, 0x69, 0x74, 0x20, 0x73, 0x6F, 0x6E, 0x2E, 0x0A, 0x59, 0x6F, 0x75,
	0x27, 0x72, 0x65, 0x20, 0x74, 0x6F, 0x6F, 0x20, 0x79, 0x6F, 0x75, 0x6E, 0x67, 0x0A, 0x74, 0x6F,
	0x20, 0x64, 0x72, 0x69, 0x6E, 0x6B, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x61, 0x70, 0x65, 0x72,
	0x73, 0x20, 0x70, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x2E, 0x00, 0x49, 0x27, 0x6D, 0x20, 0x74, 0x68,
	0x65, 0x0A, 0x6D, 0x65, 0x73, 0x73, 0x65, 0x6E, 0x67, 0x65, 0x72, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC,
	0x4F, 0x68, 0x20, 0x79, 0x65, 0x73, 0x21, 0x20, 0x48, 0x65, 0x72, 0x65, 0x2C, 0x0A, 0x74, 0x61,
	0x6B, 0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x70, 0x61, 0x72, 0x63, 0x65, 0x6C, 0x0A, 0x74,
	0x6F, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6C, 0x0A, 0x61, 0x67, 0x65,
	0x6E, 0x63, 0x79, 0x2E, 0x0B, 0x41, 0x6E, 0x64, 0x20, 0x62, 0x65, 0x20, 0x63, 0x61, 0x72, 0x65,
	0x66, 0x75, 0x6C, 0x0A, 0x69, 0x74, 0x27, 0x73, 0x20, 0x76, 0x61, 0x6C, 0x75, 0x61, 0x62, 0x6C,
	0x65, 0x2E, 0x00, 0x54, 0x49, 0x4D, 0x45, 0x20, 0x49, 0x53, 0x20, 0x55, 0x50, 0x00, 0x54, 0x68,
	0x65, 0x72, 0x65, 0x27, 0x73, 0x20, 0x61, 0x20, 0x70, 0x6C, 0x61, 0x63, 0x65, 0x0A, 0x66, 0x6F,
	0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x61, 0x72, 0x64, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x54,
	0x68, 0x61, 0x6E, 0x6B, 0x73, 0x2C, 0x20, 0x43, 0x6F, 0x6E, 0x72, 0x61, 0x64, 0x2E, 0x0A, 0x54,
	0x68, 0x6F, 0x73, 0x65, 0x20, 0x63, 0x6F, 0x70, 0x73, 0x0A, 0x77, 0x6F, 0x75, 0x6C, 0x64, 0x27,
	0x76, 0x65, 0x20, 0x68, 0x61, 0x64, 0x20, 0x6D, 0x79, 0x0A, 0x68, 0x69, 0x64, 0x65, 0x21, 0x0B,
	0x57, 0x65, 0x6C, 0x6C, 0x2C, 0x49, 0x20, 0x73, 0x75, 0x70, 0x70, 0x6F, 0x73, 0x65, 0x0A, 0x79,
	0x6F, 0x75, 0x20, 0x64, 0x6F, 0x6E, 0x27, 0x74, 0x0A, 0x72, 0x65, 0x6D, 0x65, 0x6D, 0x62, 0x65,
	0x72, 0x20, 0x79, 0x6F, 0x75, 0x72, 0x0A, 0x6F, 0x6C, 0x64, 0x20, 0x70, 0x61, 0x6C, 0x20, 0x49,
	0x61, 0x6E, 0x2E, 0x0B, 0x54, 0x61, 0x6B, 0x65, 0x20, 0x61, 0x20, 0x73, 0x65, 0x61, 0x74, 0x2C,
	0x0A, 0x77, 0x65, 0x27, 0x6C, 0x6C, 0x20, 0x66, 0x69, 0x78, 0x20, 0x74, 0x68, 0x61, 0x74, 0x0A,
	0x73, 0x68, 0x6F, 0x72, 0x74, 0x6C, 0x79, 0x2E, 0x00, 0x49, 0x61, 0x6E, 0x2C, 0x77, 0x68, 0x61,
	0x74, 0x20, 0x64, 0x6F, 0x20, 0x79, 0x6F, 0x75, 0x0A, 0x68, 0x61, 0x76, 0x65, 0x20, 0x74, 0x6F,
	0x20, 0x64, 0x6F, 0x20, 0x74, 0x6F, 0x0A, 0x67, 0x65, 0x74, 0x20, 0x74, 0x6F, 0x20, 0x45, 0x41,
	0x52, 0x54, 0x48, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x54, 0x68, 0x65, 0x20, 0x63, 0x6F, 0x73, 0x74,
	0x20, 0x6F, 0x66, 0x20, 0x74, 0x68, 0x65, 0x0A, 0x74, 0x69, 0x63, 0x6B, 0x65, 0x74, 0x20, 0x69,
	0x73, 0x0A, 0x61, 0x73, 0x74, 0x72, 0x6F, 0x6E, 0x6F, 0x6D, 0x69, 0x63, 0x61, 0x6C, 0x2E, 0x0B,
	0x54, 0x68, 0x65, 0x20, 0x6F, 0x6E, 0x6C, 0x79, 0x20, 0x77, 0x61, 0x79, 0x0A, 0x77, 0x6F, 0x75,
	0x6C, 0x64, 0x20, 0x62, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x79, 0x6F, 0x75, 0x0A, 0x74, 0x6F,
	0x20, 0x74, 0x61, 0x6B, 0x65, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x69, 0x6E, 0x0A, 0x44, 0x65,
	0x61, 0x74, 0x68, 0x20, 0x54, 0x6F, 0x77, 0x65, 0x72, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x44, 0x65,
	0x61, 0x74, 0x68, 0x20, 0x54, 0x6F, 0x77, 0x65, 0x72, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x59, 0x65,
	0x73, 0x2C, 0x69, 0x74, 0x27, 0x73, 0x20, 0x61, 0x0A, 0x74, 0x65, 0x6C, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6F, 0x6E, 0x20, 0x67, 0x61, 0x6D, 0x65, 0x2E, 0x0A, 0x54, 0x68, 0x65, 0x20, 0x77, 0x69,
	0x6E, 0x6E, 0x65, 0x72, 0x20, 0x67, 0x65, 0x74, 0x73, 0x0A, 0x61, 0x20, 0x74, 0x69, 0x63, 0x6B,
	0x65, 0x74, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x4F, 0x2E, 0x6B, 0x2E, 0x43, 0x61, 0x6E, 0x20, 0x79,
	0x6F, 0x75, 0x0A, 0x73, 0x75, 0x70, 0x70, 0x6C, 0x79, 0x20, 0x66, 0x61, 0x6C, 0x73, 0x65, 0x0A,
	0x70, 0x61, 0x70, 0x65, 0x72, 0x73, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x20, 0x70, 0x72,
	0x6F, 0x62, 0x6C, 0x65, 0x6D, 0x2E, 0x0A, 0x47, 0x6F, 0x20, 0x74, 0x6F, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x62, 0x61, 0x72, 0x0A, 0x61, 0x6E, 0x64, 0x20, 0x61, 0x73, 0x6B, 0x20, 0x66, 0x6F, 0x72,
	0x0A, 0x4A, 0x61, 0x63, 0x6B, 0x2E, 0x0B, 0x53, 0x61, 0x79, 0x20, 0x49, 0x20, 0x73, 0x65, 0x6E,
	0x74, 0x20, 0x79, 0x6F, 0x75, 0x2E, 0x0A, 0x4F, 0x68, 0x2C, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x77, 0x61, 0x79, 0x2E, 0x2E, 0x2E, 0x0B, 0x49, 0x20, 0x70, 0x75, 0x74, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x66, 0x6F, 0x72, 0x63, 0x65, 0x0A, 0x66, 0x69, 0x65, 0x6C, 0x64, 0x20, 0x79, 0x6F,
	0x75, 0x20, 0x61, 0x73, 0x6B, 0x65, 0x64, 0x0A, 0x6D, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x69,
	0x6E, 0x20, 0x79, 0x6F, 0x75, 0x72, 0x0A, 0x70, 0x6F, 0x63, 0x6B, 0x65, 0x74, 0x2E, 0x0B, 0xFF,
	0xE9, 0xEA, 0x47, 0x72, 0x65, 0x61, 0x74, 0x2E, 0x54, 0x68, 0x61, 0x6E, 0x6B, 0x0A, 0x79, 0x6F,
	0x75, 0x2C, 0x20, 0x49, 0x61, 0x6E, 0x2E, 0x27, 0x54, 0x69, 0x6C, 0x6C, 0x0A, 0x74, 0x68, 0x65,
	0x20, 0x6E, 0x65, 0x78, 0x74, 0x20, 0x74, 0x69, 0x6D, 0x65, 0x2E, 0x2E, 0x2E, 0x0B, 0xFF, 0xEB,
	0xEC, 0x47, 0x6F, 0x6F, 0x64, 0x20, 0x6C, 0x75, 0x63, 0x6B, 0x2E, 0x49, 0x27, 0x6C, 0x6C, 0x0A,
	0x62, 0x65, 0x20, 0x69, 0x6E, 0x20, 0x74, 0x6F, 0x75, 0x63, 0x68, 0x20, 0x77, 0x68, 0x65, 0x6E,
	0x0A, 0x79, 0x6F, 0x75, 0x20, 0x67, 0x65, 0x74, 0x20, 0x74, 0x6F, 0x0A, 0x45, 0x61, 0x72, 0x74,
	0x68, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x57, 0x65, 0x6C, 0x63, 0x6F, 0x6D, 0x65, 0x20, 0x74, 0x6F,
	0x0A, 0x4E, 0x65, 0x77, 0x20, 0x57, 0x61, 0x73, 0x68, 0x69, 0x6E, 0x67, 0x74, 0x6F, 0x6E, 0x2C,
	0x0A, 0x79, 0x6F, 0x75, 0x6E, 0x67, 0x20, 0x6D, 0x61, 0x6E, 0x2E, 0x0B, 0x48, 0x65, 0x72, 0x65,
	0x27, 0x73, 0x20, 0x61, 0x20, 0x6D, 0x61, 0x70, 0x20, 0x6F, 0x66, 0x0A, 0x74, 0x68, 0x65, 0x20,
	0x63, 0x69, 0x74, 0x79, 0x2C, 0x77, 0x68, 0x69, 0x63, 0x68, 0x0A, 0x79, 0x6F, 0x75, 0x20, 0x6D,
	0x61, 0x79, 0x20, 0x66, 0x69, 0x6E, 0x64, 0x0A, 0x75, 0x73, 0x65, 0x66, 0x75, 0x6C, 0x2E, 0x0B,
	0xFF, 0xE9, 0xEA, 0x54, 0x68, 0x61, 0x6E, 0x6B, 0x20, 0x79, 0x6F, 0x75, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x48, 0x61, 0x76, 0x65, 0x20, 0x61, 0x20, 0x6E, 0x69, 0x63, 0x65, 0x0A, 0x64, 0x61, 0x79,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x59, 0x6F, 0x75, 0x20, 0x6D, 0x75, 0x73, 0x74, 0x20, 0x68, 0x61,
	0x76, 0x65, 0x20, 0x61, 0x0A, 0x70, 0x65, 0x72, 0x6D, 0x69, 0x74, 0x20, 0x69, 0x6E, 0x20, 0x6F,
	0x72, 0x64, 0x65, 0x72, 0x0A, 0x74, 0x6F, 0x20, 0x77, 0x6F, 0x72, 0x6B, 0x2E, 0x0B, 0x59, 0x6F,
	0x75, 0x20, 0x63, 0x61, 0x6E, 0x20, 0x67, 0x65, 0x74, 0x20, 0x6F, 0x6E, 0x65, 0x0A, 0x61, 0x74,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x64, 0x6D, 0x69, 0x6E, 0x0A, 0x43, 0x65, 0x6E, 0x74, 0x65,
	0x72, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x20, 0x64, 0x6F, 0x6E, 0x27, 0x74, 0x20, 0x68, 0x61,
	0x76, 0x65, 0x0A, 0x74, 0x69, 0x6D, 0x65, 0x2E, 0x00, 0x47, 0x6F, 0x6F, 0x64, 0x20, 0x6D, 0x6F,
	0x72, 0x6E, 0x69, 0x6E, 0x67, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x47, 0x6F, 0x6F, 0x64, 0x20, 0x6D,
	0x6F, 0x72, 0x6E, 0x69, 0x6E, 0x67, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x27, 0x76, 0x65, 0x20,
	0x73, 0x65, 0x65, 0x6E, 0x20, 0x74, 0x68, 0x61, 0x74, 0x0A, 0x67, 0x75, 0x79, 0x20, 0x62, 0x65,
	0x66, 0x6F, 0x72, 0x65, 0x20, 0x69, 0x6E, 0x0A, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x72, 0x2E,
	0x00, 0x47, 0x6F, 0x6F, 0x64, 0x20, 0x6D, 0x6F, 0x72, 0x6E, 0x69, 0x6E, 0x67, 0x2E, 0x0B, 0xFF,
	0xEB, 0xEC, 0x47, 0x6F, 0x6F, 0x64, 0x20, 0x6D, 0x6F, 0x72, 0x6E, 0x69, 0x6E, 0x67, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x59, 0x65, 0x73, 0x2C, 0x49, 0x20, 0x6B, 0x6E, 0x6F, 0x77, 0x20, 0x68, 0x69,
	0x6D, 0x2E, 0x0A, 0x48, 0x65, 0x27, 0x73, 0x20, 0x61, 0x20, 0x72, 0x65, 0x67, 0x75, 0x6C, 0x61,
	0x72, 0x2E, 0x00, 0x20, 0x00, 0x20, 0x00, 0x49, 0x27, 0x64, 0x20, 0x6C, 0x69, 0x6B, 0x65, 0x20,
	0x61, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x70, 0x65, 0x72, 0x6D, 0x69, 0x74, 0x2E, 0x0B, 0xFF,
	0xEB, 0xEC, 0x54, 0x68, 0x65, 0x72, 0x65, 0x27, 0x73, 0x20, 0x6E, 0x6F, 0x0A, 0x70, 0x72, 0x6F,
	0x62, 0x6C, 0x65, 0x6D, 0x20, 0x67, 0x65, 0x74, 0x74, 0x69, 0x6E, 0x67, 0x0A, 0x61, 0x20, 0x70,
	0x65, 0x72, 0x6D, 0x69, 0x74, 0x2E, 0x2E, 0x2E, 0x0B, 0x49, 0x20, 0x6E, 0x65, 0x65, 0x64, 0x20,
	0x79, 0x6F, 0x75, 0x72, 0x20, 0x49, 0x44, 0x0A, 0x63, 0x61, 0x72, 0x64, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x48, 0x45, 0x4C, 0x50, 0x2E, 0x2E, 0x2E, 0x48, 0x45, 0x4C, 0x50, 0x2E, 0x2E, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x48, 0x65, 0x6C, 0x70, 0x20, 0x6D, 0x65, 0x20, 0x79, 0x6F, 0x75, 0x6E, 0x67,
	0x0A, 0x6D, 0x61, 0x6E, 0x2E, 0x20, 0x49, 0x27, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6E, 0x0A,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x6B, 0x65, 0x64, 0x20, 0x62, 0x79, 0x0A, 0x6D, 0x75, 0x74, 0x61,
	0x6E, 0x74, 0x73, 0x2E, 0x2E, 0x2E, 0x0B, 0x61, 0x6E, 0x64, 0x20, 0x49, 0x20, 0x63, 0x61, 0x6E,
	0x27, 0x74, 0x0A, 0x77, 0x61, 0x6C, 0x6B, 0x2E, 0x0B, 0x46, 0x69, 0x6E, 0x64, 0x20, 0x6D, 0x79,
	0x0A, 0x74, 0x65, 0x6C, 0x65, 0x70, 0x6F, 0x72, 0x74, 0x65, 0x72, 0x2C, 0x49, 0x0A, 0x6E, 0x65,
	0x65, 0x64, 0x20, 0x75, 0x72, 0x67, 0x65, 0x6E, 0x74, 0x20, 0x6D, 0x65, 0x64, 0x2D, 0x0A, 0x69,
	0x63, 0x61, 0x6C, 0x20, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6E, 0x63, 0x65, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x54, 0x68, 0x61, 0x6E, 0x6B, 0x73, 0x2E, 0x59, 0x6F, 0x75, 0x20, 0x6A, 0x75,
	0x73, 0x74, 0x0A, 0x73, 0x61, 0x76, 0x65, 0x64, 0x20, 0x6D, 0x79, 0x20, 0x6C, 0x69, 0x66, 0x65,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x54, 0x6F, 0x20, 0x67, 0x65, 0x74, 0x20, 0x74, 0x6F, 0x20, 0x4E,
	0x65, 0x77, 0x0A, 0x57, 0x61, 0x73, 0x68, 0x69, 0x6E, 0x67, 0x74, 0x6F, 0x6E, 0x2C, 0x79, 0x6F,
	0x75, 0x0A, 0x68, 0x61, 0x76, 0x65, 0x20, 0x74, 0x6F, 0x20, 0x6A, 0x75, 0x6D, 0x70, 0x0A, 0x69,
	0x6E, 0x74, 0x6F, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x68, 0x6F, 0x6C, 0x65, 0x2C, 0x0B, 0x62,
	0x75, 0x74, 0x20, 0x69, 0x66, 0x20, 0x49, 0x20, 0x77, 0x65, 0x72, 0x65, 0x0A, 0x79, 0x6F, 0x75,
	0x20, 0x49, 0x27, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20, 0x61, 0x6E, 0x0A, 0x41, 0x6E, 0x74, 0x69,
	0x2D, 0x47, 0x20, 0x62, 0x65, 0x6C, 0x74, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x57, 0x68, 0x65, 0x72,
	0x65, 0x20, 0x63, 0x61, 0x6E, 0x20, 0x49, 0x20, 0x66, 0x69, 0x6E, 0x64, 0x0A, 0x6F, 0x6E, 0x65,
	0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x6F, 0x77, 0x2C, 0x20, 0x49, 0x20, 0x63, 0x61, 0x6E, 0x0A,
	0x73, 0x65, 0x6C, 0x6C, 0x20, 0x79, 0x6F, 0x75, 0x20, 0x6F, 0x6E, 0x65, 0x3A, 0x0A, 0x35, 0x30,
	0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x73, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x6F,
	0x6E, 0x20, 0x76, 0x6F, 0x79, 0x61, 0x67, 0x65, 0x2C, 0x79, 0x6F, 0x75, 0x6E, 0x67, 0x0A, 0x6D,
	0x61, 0x6E, 0x2E, 0x00, 0x49, 0x20, 0x6E, 0x65, 0x65, 0x64, 0x20, 0x61, 0x20, 0x66, 0x75, 0x6C,
	0x6C, 0x79, 0x0A, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x64, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x65,
	0x74, 0x69, 0x63, 0x0A, 0x63, 0x61, 0x72, 0x74, 0x72, 0x69, 0x64, 0x67, 0x65, 0x2E, 0x00, 0x49,
	0x27, 0x64, 0x20, 0x6C, 0x69, 0x6B, 0x65, 0x20, 0x61, 0x0A, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x70,
	0x65, 0x72, 0x6D, 0x69, 0x74, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x46, 0x69, 0x72, 0x73, 0x74, 0x20,
	0x66, 0x6C, 0x6F, 0x6F, 0x72, 0x2E, 0x00, 0x41, 0x6E, 0x20, 0x69, 0x6E, 0x6E, 0x65, 0x72, 0x20,
	0x76, 0x6F, 0x69, 0x63, 0x65, 0x0A, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x73,
	0x20, 0x79, 0x6F, 0x75, 0x72, 0x0A, 0x74, 0x68, 0x6F, 0x75, 0x67, 0x68, 0x74, 0x73, 0x2E, 0x0B,
	0xFF, 0xEB, 0xEC, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x6D, 0x65, 0x2C, 0x73, 0x6F, 0x6E, 0x2C,
	0x70, 0x75, 0x74, 0x0A, 0x74, 0x68, 0x65, 0x20, 0x61, 0x74, 0x6F, 0x6D, 0x69, 0x63, 0x0A, 0x63,
	0x68, 0x61, 0x72, 0x67, 0x65, 0x20, 0x68, 0x65, 0x72, 0x65, 0x2E, 0x2E, 0x2E, 0x0B, 0x61, 0x6E,
	0x64, 0x20, 0x66, 0x6C, 0x65, 0x65, 0x20, 0x61, 0x73, 0x0A, 0x73, 0x6F, 0x6F, 0x6E, 0x20, 0x61,
	0x73, 0x20, 0x69, 0x74, 0x0A, 0x72, 0x65, 0x61, 0x63, 0x68, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65,
	0x0A, 0x70, 0x6C, 0x61, 0x6E, 0x65, 0x74, 0x27, 0x73, 0x20, 0x63, 0x6F, 0x72, 0x65, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x4C, 0x65, 0x61, 0x64, 0x20, 0x6F, 0x6E, 0x2C, 0x79, 0x6F, 0x75, 0x6E, 0x67,
	0x0A, 0x6D, 0x61, 0x6E, 0x2E, 0x0B, 0x54, 0x61, 0x6B, 0x65, 0x20, 0x6D, 0x65, 0x20, 0x74, 0x6F,
	0x20, 0x74, 0x68, 0x65, 0x0A, 0x52, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x20, 0x43, 0x65,
	0x6E, 0x74, 0x65, 0x72, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x54, 0x68, 0x61, 0x6E, 0x6B, 0x20, 0x79,
	0x6F, 0x75, 0x20, 0x66, 0x6F, 0x72, 0x0A, 0x79, 0x6F, 0x75, 0x72, 0x20, 0x68, 0x65, 0x6C, 0x70,
	0x2E, 0x2E, 0x2E, 0x0B, 0x49, 0x20, 0x61, 0x72, 0x72, 0x69, 0x76, 0x65, 0x64, 0x20, 0x73, 0x61,
	0x66, 0x65, 0x6C, 0x79, 0x0A, 0x61, 0x6E, 0x64, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x27, 0x73,
	0x20, 0x6E, 0x6F, 0x0A, 0x6C, 0x6F, 0x6E, 0x67, 0x65, 0x72, 0x20, 0x61, 0x6E, 0x79, 0x0A, 0x64,
	0x61, 0x6E, 0x67, 0x65, 0x72, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x57, 0x65, 0x6C, 0x6C, 0x20, 0x74,
	0x68, 0x65, 0x6E, 0x2C, 0x68, 0x61, 0x76, 0x65, 0x0A, 0x79, 0x6F, 0x75, 0x20, 0x62, 0x72, 0x6F,
	0x75, 0x67, 0x68, 0x74, 0x20, 0x6D, 0x65, 0x0A, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x63,
	0x65, 0x6C, 0x3F, 0x00, 0x48, 0x6F, 0x77, 0x20, 0x6D, 0x75, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20,
	0x61, 0x0A, 0x74, 0x69, 0x63, 0x6B, 0x65, 0x74, 0x20, 0x74, 0x6F, 0x20, 0x45, 0x61, 0x72, 0x74,
	0x68, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x35, 0x30, 0x2C, 0x30, 0x30, 0x30, 0x20, 0x63, 0x72, 0x65,
	0x64, 0x69, 0x74, 0x73, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x20, 0x73, 0x63, 0x72, 0x61, 0x74,
	0x63, 0x68, 0x20, 0x79, 0x6F, 0x75, 0x72, 0x0A, 0x62, 0x61, 0x63, 0x6B, 0x2C, 0x79, 0x6F, 0x75,
	0x20, 0x73, 0x63, 0x72, 0x61, 0x74, 0x63, 0x68, 0x0A, 0x6D, 0x69, 0x6E, 0x65, 0x3A, 0x0B, 0x31,
	0x35, 0x30, 0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x73, 0x20, 0x61, 0x6E, 0x64, 0x0A,
	0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x70, 0x65, 0x72, 0x73, 0x20, 0x61, 0x72, 0x65, 0x0A, 0x79,
	0x6F, 0x75, 0x72, 0x73, 0x2E, 0x00
};

const uint8 LocaleData::_stringsTableDE[] = {
	0x5A, 0x00, 0x7B, 0x00, 0x9B, 0x00, 0xB0, 0x01, 0x63, 0x02, 0x87, 0x02, 0xD3, 0x02, 0x04, 0x03,
	0x6D, 0x03, 0x86, 0x03, 0xBF, 0x03, 0x0E, 0x04, 0x5E, 0x04, 0xAD, 0x04, 0x30, 0x05, 0x60, 0x05,
	0x73, 0x05, 0xDD, 0x05, 0xEE, 0x05, 0x09, 0x06, 0xC0, 0x06, 0xBB, 0x08, 0x24, 0x09, 0x39, 0x09,
	0x87, 0x09, 0x9F, 0x09, 0xBE, 0x09, 0xEF, 0x09, 0x0E, 0x0A, 0x30, 0x0A, 0x32, 0x0A, 0x34, 0x0A,
	0x9D, 0x0A, 0xB2, 0x0A, 0x42, 0x0B, 0x66, 0x0B, 0x1F, 0x0C, 0x3B, 0x0C, 0x6C, 0x0C, 0x9D, 0x0C,
	0x39, 0x0D, 0x74, 0x0D, 0xC5, 0x0D, 0xED, 0x0D, 0x20, 0x0E, 0x44, 0x49, 0x45, 0x20, 0x53, 0x49,
	0x43, 0x48, 0x45, 0x52, 0x55, 0x4E, 0x47, 0x0A, 0x49, 0x53, 0x54, 0x0A, 0x44, 0x55, 0x52, 0x43,
	0x48, 0x47, 0x45, 0x42, 0x52, 0x41, 0x4E, 0x4E, 0x54, 0x2E, 0x00, 0x44, 0x41, 0x53, 0x20, 0x4D,
	0x5B, 0x53, 0x53, 0x54, 0x45, 0x20, 0x4A, 0x45, 0x54, 0x5A, 0x54, 0x0A, 0x46, 0x55, 0x4E, 0x4B,
	0x54, 0x49, 0x4F, 0x4E, 0x49, 0x45, 0x52, 0x45, 0x4E, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x43,
	0x48, 0x20, 0x42, 0x49, 0x4E, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x2E, 0x0A, 0x53, 0x49, 0x45, 0x20,
	0x57, 0x4F, 0x4C, 0x4C, 0x45, 0x4E, 0x0A, 0x47, 0x45, 0x46, 0x5C, 0x4C, 0x53, 0x43, 0x48, 0x54,
	0x45, 0x0A, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52, 0x45, 0x3F, 0x0B, 0xFF, 0xE9, 0xEA, 0x4A, 0x41,
	0x2C, 0x20, 0x55, 0x4E, 0x44, 0x20, 0x53, 0x4F, 0x0A, 0x53, 0x43, 0x48, 0x4E, 0x45, 0x4C, 0x4C,
	0x20, 0x57, 0x49, 0x45, 0x0A, 0x4D, 0x5D, 0x47, 0x4C, 0x49, 0x43, 0x48, 0x2E, 0x0B, 0xFF, 0xEB,
	0xEC, 0x31, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x21, 0x0B, 0xFF,
	0xE9, 0xEA, 0x31, 0x35, 0x30, 0x30, 0x3F, 0x3F, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4A, 0x41, 0x2C,
	0x20, 0x45, 0x53, 0x20, 0x49, 0x53, 0x54, 0x20, 0x45, 0x49, 0x4E, 0x0A, 0x47, 0x52, 0x4F, 0x53,
	0x53, 0x45, 0x53, 0x20, 0x52, 0x49, 0x53, 0x49, 0x4B, 0x4F, 0x0B, 0xFF, 0xE9, 0xEA, 0x41, 0x42,
	0x45, 0x52, 0x20, 0x49, 0x43, 0x48, 0x20, 0x48, 0x41, 0x42, 0x45, 0x0A, 0x4E, 0x49, 0x43, 0x48,
	0x54, 0x20, 0x47, 0x45, 0x4E, 0x55, 0x47, 0x2E, 0x2E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x47, 0x45,
	0x48, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x20, 0x5A, 0x55, 0x4D, 0x0A, 0x41, 0x52, 0x42, 0x45,
	0x49, 0x54, 0x53, 0x41, 0x4D, 0x54, 0x2C, 0x20, 0x44, 0x4F, 0x52, 0x54, 0x0A, 0x46, 0x49, 0x4E,
	0x44, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A, 0x41, 0x52, 0x42, 0x45, 0x49, 0x54, 0x2E, 0x0B,
	0x55, 0x4E, 0x44, 0x20, 0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A, 0x5A,
	0x55, 0x52, 0x5B, 0x43, 0x4B, 0x2C, 0x20, 0x57, 0x45, 0x4E, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A,
	0x44, 0x41, 0x53, 0x20, 0x47, 0x45, 0x4C, 0x44, 0x20, 0x48, 0x41, 0x42, 0x45, 0x4E, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x49, 0x43, 0x48, 0x20, 0x4B, 0x45, 0x4E, 0x4E, 0x45, 0x0A, 0x43, 0x59, 0x2D,
	0x42, 0x30, 0x32, 0x31, 0x2E, 0x0A, 0x53, 0x45, 0x49, 0x4E, 0x20, 0x46, 0x52, 0x45, 0x55, 0x4E,
	0x44, 0x20, 0x49, 0x53, 0x54, 0x0A, 0x42, 0x45, 0x49, 0x20, 0x44, 0x45, 0x52, 0x20, 0x50, 0x4F,
	0x4C, 0x49, 0x5A, 0x45, 0x49, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x57, 0x4F, 0x20, 0x4B, 0x41, 0x4E,
	0x4E, 0x20, 0x49, 0x43, 0x48, 0x0A, 0x44, 0x45, 0x4E, 0x20, 0x46, 0x49, 0x4E, 0x44, 0x45, 0x4E,
	0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x49, 0x4E, 0x20, 0x44, 0x45, 0x52, 0x20, 0x56, 0x45, 0x52, 0x42,
	0x4F, 0x2D, 0x0A, 0x54, 0x45, 0x4E, 0x45, 0x4E, 0x20, 0x5A, 0x4F, 0x4E, 0x45, 0x2E, 0x20, 0x45,
	0x52, 0x0A, 0x49, 0x53, 0x54, 0x20, 0x44, 0x4F, 0x52, 0x54, 0x0A, 0x41, 0x4E, 0x47, 0x45, 0x53,
	0x54, 0x45, 0x4C, 0x4C, 0x54, 0x2E, 0x0B, 0x41, 0x42, 0x45, 0x52, 0x2C, 0x20, 0x50, 0x41, 0x53,
	0x53, 0x20, 0x41, 0x55, 0x46, 0x21, 0x0A, 0x44, 0x49, 0x45, 0x53, 0x45, 0x20, 0x4C, 0x45, 0x55,
	0x54, 0x45, 0x20, 0x53, 0x49, 0x4E, 0x44, 0x0A, 0x47, 0x45, 0x46, 0x5C, 0x48, 0x52, 0x4C, 0x49,
	0x43, 0x48, 0x00, 0xFF, 0xEB, 0xEC, 0x4D, 0x45, 0x48, 0x52, 0x20, 0x57, 0x45, 0x49, 0x53, 0x53,
	0x20, 0x49, 0x43, 0x48, 0x0A, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x2C, 0x20, 0x4D, 0x45, 0x49, 0x4E,
	0x0A, 0x53, 0x4F, 0x48, 0x4E, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x43, 0x59, 0x2D, 0x42, 0x4F, 0x32,
	0x31, 0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x0A, 0x45, 0x49, 0x4E, 0x20, 0x47, 0x45, 0x53,
	0x43, 0x48, 0x5C, 0x46, 0x54, 0x0A, 0x4D, 0x49, 0x54, 0x20, 0x44, 0x49, 0x52, 0x20, 0x4D, 0x41,
	0x43, 0x48, 0x45, 0x4E, 0x2E, 0x0B, 0x45, 0x52, 0x20, 0x57, 0x41, 0x52, 0x54, 0x45, 0x54, 0x20,
	0x48, 0x49, 0x4E, 0x54, 0x45, 0x52, 0x0A, 0x44, 0x45, 0x52, 0x20, 0x4B, 0x4E, 0x45, 0x49, 0x50,
	0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x45, 0x48, 0x20, 0x5A, 0x55, 0x52, 0x20, 0x4B, 0x4E,
	0x45, 0x49, 0x50, 0x45, 0x2C, 0x0A, 0x43, 0x59, 0x2D, 0x42, 0x4F, 0x32, 0x31, 0x20, 0x57, 0x41,
	0x52, 0x54, 0x45, 0x54, 0x0A, 0x44, 0x4F, 0x52, 0x54, 0x20, 0x41, 0x55, 0x46, 0x20, 0x44, 0x49,
	0x43, 0x48, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x20, 0x53, 0x43, 0x48,
	0x49, 0x45, 0x53, 0x53, 0x45, 0x4E, 0x2C, 0x0A, 0x49, 0x43, 0x48, 0x20, 0x42, 0x49, 0x4E, 0x20,
	0x4E, 0x49, 0x43, 0x48, 0x54, 0x0A, 0x43, 0x59, 0x2D, 0x42, 0x4F, 0x32, 0x31, 0x21, 0x0B, 0x53,
	0x45, 0x49, 0x4E, 0x20, 0x56, 0x45, 0x52, 0x53, 0x54, 0x45, 0x43, 0x4B, 0x0A, 0x49, 0x53, 0x54,
	0x20, 0x47, 0x41, 0x4E, 0x5A, 0x20, 0x55, 0x4E, 0x54, 0x45, 0x4E, 0x2E, 0x0B, 0x44, 0x45, 0x52,
	0x20, 0x50, 0x4F, 0x4C, 0x49, 0x5A, 0x49, 0x53, 0x54, 0x20, 0x48, 0x41, 0x54, 0x0A, 0x44, 0x45,
	0x4E, 0x20, 0x53, 0x43, 0x48, 0x4C, 0x5B, 0x53, 0x53, 0x45, 0x4C, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x4D, 0x45, 0x48, 0x52, 0x20, 0x57, 0x45, 0x49, 0x53, 0x53, 0x0A, 0x49, 0x43, 0x48, 0x20, 0x4E,
	0x49, 0x43, 0x48, 0x54, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x53, 0x49, 0x52, 0x2E, 0x2E, 0x2E, 0x20,
	0x4A, 0x41, 0x43, 0x4B, 0x20, 0x48, 0x41, 0x54, 0x0A, 0x45, 0x49, 0x4E, 0x20, 0x54, 0x52, 0x45,
	0x46, 0x46, 0x45, 0x4E, 0x0A, 0x42, 0x45, 0x49, 0x20, 0x44, 0x45, 0x52, 0x20, 0x4B, 0x4E, 0x45,
	0x49, 0x50, 0x45, 0x0A, 0x41, 0x52, 0x52, 0x41, 0x4E, 0x47, 0x49, 0x45, 0x52, 0x54, 0x00, 0x49,
	0x43, 0x48, 0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x41,
	0x52, 0x42, 0x45, 0x49, 0x54, 0x53, 0x45, 0x52, 0x4C, 0x41, 0x55, 0x42, 0x4E, 0x49, 0x53, 0x0B,
	0xFF, 0xEB, 0xEC, 0x4E, 0x45, 0x49, 0x4E, 0x2C, 0x20, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x0A, 0x48,
	0x49, 0x45, 0x52, 0x2E, 0x20, 0x47, 0x45, 0x48, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A, 0x5A,
	0x55, 0x20, 0x53, 0x43, 0x48, 0x41, 0x4C, 0x54, 0x45, 0x52, 0x20, 0x43, 0x2E, 0x00, 0x49, 0x43,
	0x48, 0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x41, 0x52,
	0x42, 0x45, 0x49, 0x54, 0x53, 0x45, 0x52, 0x4C, 0x41, 0x55, 0x42, 0x4E, 0x49, 0x53, 0x0B, 0xFF,
	0xEB, 0xEC, 0x47, 0x55, 0x54, 0x2E, 0x2E, 0x2E, 0x20, 0x4F, 0x2E, 0x4B, 0x2E, 0x2C, 0x20, 0x44,
	0x45, 0x52, 0x0A, 0x43, 0x48, 0x45, 0x46, 0x20, 0x57, 0x49, 0x4C, 0x4C, 0x20, 0x53, 0x49, 0x45,
	0x0A, 0x4A, 0x45, 0x54, 0x5A, 0x54, 0x20, 0x53, 0x45, 0x48, 0x45, 0x4E, 0x2E, 0x00, 0x49, 0x43,
	0x48, 0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x41, 0x52,
	0x42, 0x45, 0x49, 0x54, 0x53, 0x45, 0x52, 0x4C, 0x41, 0x55, 0x42, 0x4E, 0x49, 0x53, 0x0B, 0xFF,
	0xEB, 0xEC, 0x4E, 0x45, 0x49, 0x4E, 0x2C, 0x20, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x0A, 0x48, 0x49,
	0x45, 0x52, 0x2E, 0x20, 0x47, 0x45, 0x48, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A, 0x5A, 0x55,
	0x20, 0x53, 0x43, 0x48, 0x41, 0x4C, 0x54, 0x45, 0x52, 0x20, 0x42, 0x2E, 0x00, 0x49, 0x43, 0x48,
	0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x0A, 0x4A, 0x41, 0x43, 0x4B, 0x20, 0x53, 0x50, 0x52,
	0x45, 0x43, 0x48, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x43, 0x48, 0x20, 0x4A, 0x41,
	0x3F, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x0A, 0x49, 0x53, 0x54, 0x20, 0x4E, 0x49, 0x43, 0x48, 0x54,
	0x20, 0x44, 0x41, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x49, 0x43, 0x48, 0x20, 0x4B, 0x4F, 0x4D, 0x4D,
	0x45, 0x20, 0x56, 0x4F, 0x4E, 0x0A, 0x4D, 0x45, 0x49, 0x4E, 0x45, 0x4D, 0x20, 0x46, 0x52, 0x45,
	0x55, 0x4E, 0x44, 0x0A, 0x49, 0x41, 0x4E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x2E, 0x4B, 0x2E,
	0x20, 0x4A, 0x41, 0x43, 0x4B, 0x20, 0x57, 0x41, 0x52, 0x54, 0x45, 0x54, 0x0A, 0x44, 0x52, 0x41,
	0x55, 0x53, 0x53, 0x45, 0x4E, 0x20, 0x41, 0x55, 0x46, 0x0A, 0x44, 0x49, 0x43, 0x48, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x4E, 0x45, 0x45, 0x2C, 0x20, 0x4D, 0x45, 0x49, 0x4E, 0x20, 0x53, 0x4F, 0x48,
	0x4E, 0x2E, 0x0A, 0x44, 0x55, 0x20, 0x42, 0x49, 0x53, 0x54, 0x20, 0x5A, 0x55, 0x20, 0x4A, 0x55,
	0x4E, 0x47, 0x0A, 0x5A, 0x55, 0x4D, 0x20, 0x54, 0x52, 0x49, 0x4E, 0x4B, 0x45, 0x4E, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52, 0x45, 0x2C, 0x20, 0x42, 0x49, 0x54, 0x54,
	0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x43, 0x48, 0x20, 0x42, 0x49, 0x4E, 0x20, 0x44, 0x45,
	0x52, 0x0A, 0x42, 0x4F, 0x54, 0x45, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x48, 0x20, 0x4A, 0x41,
	0x21, 0x0A, 0x44, 0x49, 0x45, 0x53, 0x45, 0x53, 0x20, 0x50, 0x41, 0x4B, 0x45, 0x54, 0x0A, 0x4D,
	0x55, 0x53, 0x53, 0x20, 0x5A, 0x55, 0x4D, 0x0A, 0x52, 0x45, 0x49, 0x53, 0x45, 0x42, 0x5B, 0x52,
	0x4F, 0x0B, 0x53, 0x45, 0x49, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x0A, 0x56, 0x4F, 0x52, 0x53,
	0x49, 0x43, 0x48, 0x54, 0x49, 0x47, 0x2C, 0x0A, 0x45, 0x53, 0x20, 0x49, 0x53, 0x54, 0x20, 0x53,
	0x45, 0x48, 0x52, 0x0A, 0x57, 0x45, 0x52, 0x54, 0x56, 0x4F, 0x4C, 0x4C, 0x00, 0x5A, 0x45, 0x49,
	0x54, 0x20, 0x41, 0x42, 0x47, 0x45, 0x4C, 0x41, 0x55, 0x46, 0x45, 0x4E, 0x2E, 0x00, 0x44, 0x49,
	0x45, 0x20, 0x4B, 0x41, 0x52, 0x54, 0x45, 0x20, 0x48, 0x41, 0x54, 0x0A, 0x45, 0x49, 0x4E, 0x45,
	0x4E, 0x20, 0x50, 0x4C, 0x41, 0x54, 0x5A, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x41, 0x4E, 0x4B,
	0x45, 0x2C, 0x20, 0x43, 0x4F, 0x4E, 0x52, 0x41, 0x44, 0x2E, 0x0A, 0x44, 0x49, 0x45, 0x20, 0x50,
	0x4F, 0x4C, 0x49, 0x5A, 0x49, 0x53, 0x54, 0x45, 0x4E, 0x0A, 0x48, 0x5C, 0x54, 0x54, 0x45, 0x4E,
	0x20, 0x4D, 0x45, 0x49, 0x4E, 0x20, 0x56, 0x45, 0x52, 0x2D, 0x0A, 0x53, 0x54, 0x45, 0x43, 0x4B,
	0x20, 0x47, 0x45, 0x46, 0x55, 0x4E, 0x44, 0x45, 0x4E, 0x2E, 0x0B, 0x44, 0x55, 0x20, 0x45, 0x52,
	0x49, 0x4E, 0x4E, 0x45, 0x52, 0x53, 0x54, 0x0A, 0x44, 0x49, 0x43, 0x48, 0x20, 0x57, 0x4F, 0x48,
	0x4C, 0x20, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x0A, 0x41, 0x4E, 0x20, 0x44, 0x45, 0x49, 0x4E, 0x45,
	0x4E, 0x20, 0x41, 0x4C, 0x54, 0x45, 0x4E, 0x0A, 0x4B, 0x55, 0x4D, 0x50, 0x45, 0x4C, 0x20, 0x49,
	0x41, 0x4E, 0x2E, 0x0B, 0x53, 0x45, 0x54, 0x5A, 0x20, 0x44, 0x49, 0x43, 0x48, 0x2C, 0x20, 0x57,
	0x49, 0x52, 0x0A, 0x42, 0x52, 0x49, 0x4E, 0x47, 0x45, 0x4E, 0x20, 0x44, 0x45, 0x49, 0x4E, 0x20,
	0x47, 0x45, 0x2D, 0x0A, 0x44, 0x5C, 0x43, 0x48, 0x54, 0x4E, 0x49, 0x53, 0x20, 0x57, 0x49, 0x45,
	0x44, 0x45, 0x52, 0x0A, 0x49, 0x4E, 0x20, 0x4F, 0x52, 0x44, 0x4E, 0x55, 0x4E, 0x47, 0x2E, 0x00,
	0x49, 0x41, 0x4E, 0x2C, 0x20, 0x57, 0x41, 0x53, 0x20, 0x4D, 0x55, 0x53, 0x53, 0x0A, 0x49, 0x43,
	0x48, 0x20, 0x4D, 0x41, 0x43, 0x48, 0x45, 0x4E, 0x2C, 0x20, 0x55, 0x4D, 0x0A, 0x5A, 0x55, 0x52,
	0x20, 0x45, 0x52, 0x44, 0x45, 0x20, 0x5A, 0x55, 0x0A, 0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x3F,
	0x0B, 0x44, 0x45, 0x52, 0x20, 0x50, 0x52, 0x45, 0x49, 0x53, 0x20, 0x46, 0x5B, 0x52, 0x0A, 0x44,
	0x41, 0x53, 0x20, 0x54, 0x49, 0x43, 0x4B, 0x45, 0x54, 0x20, 0x49, 0x53, 0x54, 0x0A, 0x41, 0x53,
	0x54, 0x52, 0x4F, 0x4E, 0x4F, 0x4D, 0x49, 0x53, 0x43, 0x48, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x44,
	0x45, 0x52, 0x20, 0x45, 0x49, 0x4E, 0x5A, 0x49, 0x47, 0x45, 0x20, 0x57, 0x45, 0x47, 0x0A, 0x57,
	0x5C, 0x52, 0x45, 0x20, 0x44, 0x49, 0x45, 0x0A, 0x54, 0x45, 0x49, 0x4C, 0x4E, 0x41, 0x48, 0x4D,
	0x45, 0x0A, 0x41, 0x4D, 0x20, 0x54, 0x4F, 0x44, 0x45, 0x53, 0x54, 0x55, 0x52, 0x4D, 0x2E, 0x0B,
	0xFF, 0xE9, 0xEA, 0x54, 0x4F, 0x44, 0x45, 0x53, 0x54, 0x55, 0x52, 0x4D, 0x3F, 0x0B, 0xFF, 0xEB,
	0xEC, 0x44, 0x41, 0x53, 0x20, 0x49, 0x53, 0x54, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x46, 0x45,
	0x52, 0x4E, 0x53, 0x45, 0x48, 0x53, 0x48, 0x4F, 0x57, 0x2E, 0x0A, 0x44, 0x45, 0x52, 0x20, 0x47,
	0x45, 0x57, 0x49, 0x4E, 0x4E, 0x45, 0x52, 0x20, 0x42, 0x45, 0x2D, 0x0A, 0x4B, 0x4F, 0x4D, 0x4D,
	0x54, 0x20, 0x45, 0x49, 0x4E, 0x20, 0x54, 0x49, 0x43, 0x4B, 0x45, 0x54, 0x0B, 0xFF, 0xE9, 0xEA,
	0x4B, 0x41, 0x4E, 0x4E, 0x53, 0x54, 0x20, 0x44, 0x55, 0x20, 0x4D, 0x49, 0x52, 0x0A, 0x46, 0x41,
	0x4C, 0x53, 0x43, 0x48, 0x45, 0x20, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52, 0x45, 0x0A, 0x42, 0x45,
	0x53, 0x4F, 0x52, 0x47, 0x45, 0x4E, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4B, 0x45, 0x49, 0x4E, 0x20,
	0x50, 0x52, 0x4F, 0x42, 0x4C, 0x45, 0x4D, 0x2E, 0x0A, 0x47, 0x45, 0x48, 0x20, 0x5A, 0x55, 0x52,
	0x20, 0x4B, 0x4E, 0x45, 0x49, 0x50, 0x45, 0x2C, 0x0A, 0x55, 0x4E, 0x44, 0x20, 0x46, 0x52, 0x41,
	0x47, 0x0A, 0x4E, 0x41, 0x43, 0x48, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x2E, 0x0B, 0x53, 0x41, 0x47,
	0x2C, 0x20, 0x44, 0x41, 0x53, 0x53, 0x20, 0x44, 0x55, 0x20, 0x56, 0x4F, 0x4E, 0x0A, 0x4D, 0x49,
	0x52, 0x20, 0x4B, 0x4F, 0x4D, 0x4D, 0x53, 0x54, 0x2E, 0x0A, 0x41, 0x43, 0x48, 0x2E, 0x2E, 0x2E,
	0x0B, 0x2E, 0x2E, 0x49, 0x43, 0x48, 0x20, 0x48, 0x41, 0x42, 0x45, 0x20, 0x5B, 0x42, 0x52, 0x49,
	0x2D, 0x0A, 0x47, 0x45, 0x4E, 0x53, 0x20, 0x45, 0x49, 0x4E, 0x20, 0x53, 0x43, 0x48, 0x55, 0x54,
	0x5A, 0x2D, 0x0A, 0x46, 0x45, 0x4C, 0x44, 0x2C, 0x20, 0x49, 0x4E, 0x20, 0x44, 0x45, 0x49, 0x4E,
	0x45, 0x0A, 0x54, 0x41, 0x53, 0x43, 0x48, 0x45, 0x20, 0x47, 0x45, 0x53, 0x54, 0x45, 0x43, 0x4B,
	0x54, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x47, 0x52, 0x4F, 0x53, 0x53, 0x41, 0x52, 0x54, 0x49, 0x47,
	0x2E, 0x0A, 0x44, 0x41, 0x4E, 0x4B, 0x45, 0x2C, 0x20, 0x49, 0x41, 0x4E, 0x2E, 0x20, 0x42, 0x49,
	0x53, 0x0A, 0x44, 0x45, 0x4D, 0x4E, 0x5C, 0x43, 0x48, 0x53, 0x54, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC,
	0x49, 0x43, 0x48, 0x20, 0x4D, 0x45, 0x4C, 0x44, 0x45, 0x20, 0x4D, 0x49, 0x43, 0x48, 0x2C, 0x0A,
	0x57, 0x45, 0x4E, 0x4E, 0x20, 0x44, 0x55, 0x20, 0x41, 0x55, 0x46, 0x0A, 0x44, 0x45, 0x52, 0x20,
	0x45, 0x52, 0x44, 0x45, 0x20, 0x42, 0x49, 0x53, 0x54, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x57, 0x49,
	0x4C, 0x4C, 0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x20, 0x49, 0x4E, 0x0A, 0x4E, 0x45, 0x57, 0x20,
	0x57, 0x41, 0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x2C, 0x0A, 0x4A, 0x55, 0x4E, 0x47,
	0x45, 0x52, 0x20, 0x4D, 0x41, 0x4E, 0x4E, 0x2E, 0x0B, 0x48, 0x49, 0x45, 0x52, 0x20, 0x49, 0x53,
	0x54, 0x20, 0x45, 0x49, 0x4E, 0x0A, 0x53, 0x54, 0x41, 0x44, 0x54, 0x50, 0x4C, 0x41, 0x4E, 0x2C,
	0x0A, 0x53, 0x49, 0x45, 0x20, 0x57, 0x45, 0x52, 0x44, 0x45, 0x4E, 0x20, 0x49, 0x48, 0x4E, 0x0A,
	0x42, 0x52, 0x41, 0x55, 0x43, 0x48, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x44, 0x41, 0x4E,
	0x4B, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x53, 0x43, 0x48, 0x5D, 0x4E, 0x45, 0x4E, 0x20, 0x54,
	0x41, 0x47, 0x0A, 0x4E, 0x4F, 0x43, 0x48, 0x21, 0x00, 0xFF, 0xEB, 0xEC, 0x53, 0x49, 0x45, 0x20,
	0x42, 0x52, 0x41, 0x55, 0x43, 0x48, 0x45, 0x4E, 0x0A, 0x45, 0x49, 0x4E, 0x45, 0x20, 0x41, 0x52,
	0x42, 0x45, 0x49, 0x54, 0x53, 0x2D, 0x0A, 0x45, 0x52, 0x4C, 0x41, 0x55, 0x42, 0x4E, 0x49, 0x53,
	0x2E, 0x0B, 0x53, 0x49, 0x45, 0x20, 0x42, 0x45, 0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x0A, 0x45,
	0x49, 0x4E, 0x45, 0x20, 0x49, 0x4E, 0x20, 0x44, 0x45, 0x52, 0x0A, 0x56, 0x45, 0x52, 0x57, 0x41,
	0x4C, 0x54, 0x55, 0x4E, 0x47, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x49, 0x43, 0x48, 0x20, 0x48, 0x41,
	0x42, 0x45, 0x20, 0x4B, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x5A, 0x45, 0x49, 0x54, 0x2E, 0x00, 0x47,
	0x55, 0x54, 0x45, 0x4E, 0x20, 0x4D, 0x4F, 0x52, 0x47, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC,
	0x47, 0x55, 0x54, 0x45, 0x4E, 0x20, 0x4D, 0x4F, 0x52, 0x47, 0x45, 0x4E, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x49, 0x43, 0x48, 0x20, 0x53, 0x41, 0x48, 0x20, 0x44, 0x49, 0x45, 0x53, 0x45, 0x4E, 0x0A,
	0x54, 0x59, 0x50, 0x45, 0x4E, 0x20, 0x53, 0x43, 0x48, 0x4F, 0x4E, 0x20, 0x4D, 0x41, 0x4C, 0x0A,
	0x49, 0x4E, 0x20, 0x44, 0x45, 0x52, 0x20, 0x4B, 0x4E, 0x45, 0x49, 0x50, 0x45, 0x2E, 0x00, 0x47,
	0x55, 0x54, 0x45, 0x4E, 0x20, 0x4D, 0x4F, 0x52, 0x47, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC,
	0x47, 0x55, 0x54, 0x45, 0x4E, 0x20, 0x4D, 0x4F, 0x52, 0x47, 0x45, 0x4E, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x49, 0x43, 0x48, 0x20, 0x4B, 0x45, 0x4E, 0x4E, 0x45, 0x20, 0x49, 0x48, 0x4E, 0x2E, 0x0A,
	0x49, 0x53, 0x54, 0x20, 0x53, 0x54, 0x41, 0x4D, 0x4D, 0x4B, 0x55, 0x4E, 0x44, 0x45, 0x2E, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x49, 0x43, 0x48, 0x20, 0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x20, 0x45,
	0x49, 0x4E, 0x45, 0x0A, 0x41, 0x52, 0x42, 0x45, 0x49, 0x54, 0x53, 0x45, 0x52, 0x4C, 0x41, 0x55,
	0x42, 0x4E, 0x49, 0x53, 0x0B, 0xFF, 0xEB, 0xEC, 0x4B, 0x45, 0x49, 0x4E, 0x20, 0x50, 0x52, 0x4F,
	0x42, 0x4C, 0x45, 0x4D, 0x2C, 0x0A, 0x45, 0x49, 0x4E, 0x45, 0x20, 0x45, 0x52, 0x4C, 0x41, 0x55,
	0x42, 0x4E, 0x49, 0x53, 0x0A, 0x5A, 0x55, 0x20, 0x42, 0x45, 0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E,
	0x2E, 0x2E, 0x2E, 0x0B, 0x49, 0x43, 0x48, 0x20, 0x42, 0x45, 0x4E, 0x5D, 0x54, 0x49, 0x47, 0x45,
	0x0A, 0x49, 0x48, 0x52, 0x45, 0x20, 0x4B, 0x41, 0x52, 0x54, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x48, 0x49, 0x4C, 0x46, 0x45, 0x2E, 0x2E, 0x2E, 0x0A, 0x48, 0x49, 0x4C, 0x46, 0x45, 0x2E, 0x2E,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x48, 0x45, 0x4C, 0x46, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x20,
	0x4D, 0x49, 0x52, 0x2E, 0x0A, 0x49, 0x43, 0x48, 0x20, 0x57, 0x55, 0x52, 0x44, 0x45, 0x20, 0x56,
	0x4F, 0x4E, 0x0A, 0x4D, 0x55, 0x54, 0x41, 0x4E, 0x54, 0x45, 0x4E, 0x0A, 0x41, 0x4E, 0x47, 0x45,
	0x47, 0x52, 0x49, 0x46, 0x46, 0x45, 0x4E, 0x2E, 0x2E, 0x2E, 0x0B, 0x55, 0x4E, 0x44, 0x20, 0x49,
	0x43, 0x48, 0x20, 0x4B, 0x41, 0x4E, 0x4E, 0x0A, 0x4E, 0x49, 0x43, 0x48, 0x54, 0x20, 0x4C, 0x41,
	0x55, 0x46, 0x45, 0x4E, 0x2E, 0x0B, 0x48, 0x4F, 0x4C, 0x45, 0x4E, 0x20, 0x53, 0x49, 0x45, 0x20,
	0x4D, 0x45, 0x49, 0x4E, 0x45, 0x4E, 0x0A, 0x54, 0x45, 0x4C, 0x45, 0x50, 0x4F, 0x52, 0x54, 0x45,
	0x52, 0x2C, 0x20, 0x49, 0x43, 0x48, 0x0A, 0x42, 0x52, 0x41, 0x55, 0x43, 0x48, 0x45, 0x20, 0x5C,
	0x52, 0x5A, 0x54, 0x2D, 0x0A, 0x4C, 0x49, 0x43, 0x48, 0x45, 0x20, 0x48, 0x49, 0x4C, 0x46, 0x45,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x41, 0x4E, 0x4B, 0x45, 0x2E, 0x20, 0x53, 0x49, 0x45, 0x20,
	0x52, 0x45, 0x54, 0x2D, 0x0A, 0x54, 0x45, 0x54, 0x45, 0x4E, 0x20, 0x4D, 0x45, 0x49, 0x4E, 0x20,
	0x4C, 0x45, 0x42, 0x45, 0x4E, 0x00, 0xFF, 0xEB, 0xEC, 0x53, 0x50, 0x52, 0x49, 0x4E, 0x47, 0x45,
	0x4E, 0x20, 0x53, 0x49, 0x45, 0x20, 0x49, 0x4E, 0x0A, 0x44, 0x49, 0x45, 0x53, 0x45, 0x53, 0x20,
	0x4C, 0x4F, 0x43, 0x48, 0x2C, 0x0B, 0x55, 0x4D, 0x20, 0x4E, 0x41, 0x43, 0x48, 0x20, 0x4E, 0x45,
	0x57, 0x0A, 0x57, 0x41, 0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x0A, 0x5A, 0x55, 0x20,
	0x4B, 0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x2E, 0x0B, 0x41, 0x42, 0x45, 0x52, 0x2C, 0x20, 0x49, 0x43,
	0x48, 0x20, 0x57, 0x5B, 0x52, 0x44, 0x45, 0x0A, 0x45, 0x49, 0x4E, 0x45, 0x4E, 0x20, 0x41, 0x4E,
	0x54, 0x49, 0x2D, 0x47, 0x2D, 0x0A, 0x47, 0x5B, 0x52, 0x54, 0x45, 0x4C, 0x20, 0x42, 0x45, 0x4E,
	0x55, 0x54, 0x5A, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x57, 0x4F, 0x20, 0x4B, 0x41, 0x4E,
	0x4E, 0x20, 0x49, 0x43, 0x48, 0x0A, 0x45, 0x49, 0x4E, 0x45, 0x4E, 0x20, 0x42, 0x45, 0x4B, 0x4F,
	0x4D, 0x4D, 0x45, 0x4E, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x55, 0x4E, 0x2C, 0x20, 0x49, 0x43,
	0x48, 0x0A, 0x56, 0x45, 0x52, 0x4B, 0x41, 0x55, 0x46, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x4E,
	0x3A, 0x0A, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x2E, 0x00, 0xFF,
	0xEB, 0xEC, 0x47, 0x55, 0x54, 0x45, 0x20, 0x52, 0x45, 0x49, 0x53, 0x45, 0x2C, 0x0A, 0x4A, 0x55,
	0x4E, 0x47, 0x45, 0x52, 0x20, 0x4D, 0x41, 0x4E, 0x4E, 0x2E, 0x00, 0x49, 0x43, 0x48, 0x20, 0x42,
	0x52, 0x41, 0x55, 0x43, 0x48, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x0A, 0x41, 0x55, 0x46, 0x47, 0x45,
	0x4C, 0x41, 0x44, 0x45, 0x4E, 0x45, 0x53, 0x20, 0x4D, 0x41, 0x2D, 0x0A, 0x47, 0x4E, 0x45, 0x54,
	0x2D, 0x43, 0x41, 0x52, 0x54, 0x52, 0x49, 0x44, 0x47, 0x45, 0x2E, 0x00, 0x49, 0x43, 0x48, 0x20,
	0x4D, 0x5D, 0x43, 0x48, 0x54, 0x45, 0x20, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x41, 0x52, 0x42, 0x45,
	0x49, 0x54, 0x53, 0x45, 0x52, 0x4C, 0x41, 0x55, 0x42, 0x4E, 0x49, 0x53, 0x0B, 0xFF, 0xEB, 0xEC,
	0x45, 0x52, 0x53, 0x54, 0x45, 0x20, 0x45, 0x54, 0x41, 0x47, 0x45, 0x2E, 0x00, 0x45, 0x49, 0x4E,
	0x45, 0x20, 0x49, 0x4E, 0x4E, 0x45, 0x52, 0x45, 0x0A, 0x53, 0x54, 0x49, 0x4D, 0x4D, 0x45, 0x0A,
	0x55, 0x4E, 0x54, 0x45, 0x52, 0x42, 0x52, 0x49, 0x43, 0x48, 0x54, 0x0A, 0x44, 0x45, 0x49, 0x4E,
	0x45, 0x20, 0x47, 0x45, 0x44, 0x41, 0x4E, 0x4B, 0x45, 0x4E, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x56,
	0x45, 0x52, 0x54, 0x52, 0x41, 0x55, 0x20, 0x4D, 0x49, 0x52, 0x2C, 0x0A, 0x42, 0x52, 0x49, 0x4E,
	0x47, 0x20, 0x44, 0x49, 0x45, 0x20, 0x41, 0x54, 0x4F, 0x4D, 0x2D, 0x0A, 0x4C, 0x41, 0x44, 0x55,
	0x4E, 0x47, 0x20, 0x48, 0x49, 0x45, 0x52, 0x20, 0x41, 0x4E, 0x2E, 0x2E, 0x0B, 0x55, 0x4E, 0x44,
	0x20, 0x46, 0x4C, 0x49, 0x45, 0x48, 0x45, 0x2C, 0x20, 0x42, 0x45, 0x2D, 0x0A, 0x56, 0x4F, 0x52,
	0x20, 0x53, 0x49, 0x45, 0x20, 0x44, 0x41, 0x53, 0x20, 0x48, 0x45, 0x52, 0x5A, 0x0A, 0x44, 0x45,
	0x53, 0x20, 0x50, 0x4C, 0x41, 0x4E, 0x45, 0x54, 0x45, 0x4E, 0x0A, 0x45, 0x52, 0x52, 0x45, 0x49,
	0x43, 0x48, 0x54, 0x20, 0x48, 0x41, 0x54, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x5A, 0x55, 0x4D, 0x20,
	0x46, 0x4F, 0x52, 0x53, 0x43, 0x48, 0x55, 0x4E, 0x47, 0x53, 0x2D, 0x0A, 0x5A, 0x45, 0x4E, 0x54,
	0x52, 0x55, 0x4D, 0x2C, 0x20, 0x42, 0x49, 0x54, 0x54, 0x45, 0x2E, 0x0B, 0x4E, 0x41, 0x43, 0x48,
	0x20, 0x49, 0x48, 0x4E, 0x45, 0x4E, 0x2C, 0x0A, 0x4A, 0x55, 0x4E, 0x47, 0x45, 0x52, 0x20, 0x4D,
	0x41, 0x4E, 0x4E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x41, 0x4E, 0x4B, 0x45, 0x20, 0x46, 0x5B, 0x52,
	0x0A, 0x49, 0x48, 0x52, 0x45, 0x20, 0x48, 0x49, 0x4C, 0x46, 0x45, 0x0B, 0x49, 0x43, 0x48, 0x20,
	0x42, 0x49, 0x4E, 0x20, 0x53, 0x49, 0x43, 0x48, 0x45, 0x52, 0x0A, 0x41, 0x4E, 0x47, 0x45, 0x4B,
	0x4F, 0x4D, 0x4D, 0x45, 0x4E, 0x2E, 0x20, 0x45, 0x53, 0x0A, 0x42, 0x45, 0x53, 0x54, 0x45, 0x48,
	0x54, 0x20, 0x4B, 0x45, 0x49, 0x4E, 0x45, 0x0A, 0x47, 0x45, 0x46, 0x41, 0x48, 0x52, 0x20, 0x4D,
	0x45, 0x48, 0x52, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x48, 0x41, 0x42, 0x45, 0x4E, 0x20, 0x53, 0x49,
	0x45, 0x20, 0x4D, 0x49, 0x52, 0x0A, 0x44, 0x41, 0x53, 0x20, 0x50, 0x41, 0x4B, 0x45, 0x54, 0x0A,
	0x4D, 0x49, 0x54, 0x47, 0x45, 0x42, 0x52, 0x41, 0x43, 0x48, 0x54, 0x3F, 0x00, 0x57, 0x41, 0x53,
	0x20, 0x4B, 0x4F, 0x53, 0x54, 0x45, 0x54, 0x20, 0x45, 0x49, 0x4E, 0x0A, 0x54, 0x49, 0x43, 0x4B,
	0x45, 0x54, 0x20, 0x5A, 0x55, 0x52, 0x0A, 0x45, 0x52, 0x44, 0x45, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC,
	0x35, 0x30, 0x2E, 0x30, 0x30, 0x30, 0x20, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x73, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x45, 0x49, 0x4E, 0x45, 0x20, 0x48, 0x41, 0x4E, 0x44, 0x0A, 0x57, 0x5C, 0x53,
	0x43, 0x48, 0x54, 0x0A, 0x44, 0x49, 0x45, 0x20, 0x41, 0x4E, 0x44, 0x45, 0x52, 0x45, 0x2E, 0x0B,
	0x31, 0x2E, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x53, 0x0A, 0x55, 0x4E,
	0x44, 0x20, 0x44, 0x49, 0x45, 0x20, 0x50, 0x41, 0x50, 0x49, 0x45, 0x52, 0x45, 0x0A, 0x47, 0x45,
	0x48, 0x5D, 0x52, 0x45, 0x4E, 0x20, 0x44, 0x49, 0x52, 0x2E, 0x00
};

const uint8 LocaleData::_stringsTableSP[] = {
	0x5A, 0x00, 0x71, 0x00, 0x8F, 0x00, 0xA7, 0x01, 0x71, 0x02, 0x8D, 0x02, 0xD8, 0x02, 0x09, 0x03,
	0x6E, 0x03, 0x84, 0x03, 0xBE, 0x03, 0x08, 0x04, 0x51, 0x04, 0x9B, 0x04, 0x18, 0x05, 0x49, 0x05,
	0x60, 0x05, 0xC3, 0x05, 0xD4, 0x05, 0xF2, 0x05, 0x8D, 0x06, 0x9B, 0x08, 0x10, 0x09, 0x2A, 0x09,
	0x89, 0x09, 0x9D, 0x09, 0xBA, 0x09, 0xE1, 0x09, 0xFE, 0x09, 0x21, 0x0A, 0x23, 0x0A, 0x25, 0x0A,
	0x8D, 0x0A, 0xA1, 0x0A, 0x2A, 0x0B, 0x51, 0x0B, 0x05, 0x0C, 0x1F, 0x0C, 0x48, 0x0C, 0x7A, 0x0C,
	0x06, 0x0D, 0x40, 0x0D, 0x89, 0x0D, 0xAD, 0x0D, 0xE8, 0x0D, 0x48, 0x41, 0x20, 0x53, 0x41, 0x4C,
	0x54, 0x41, 0x44, 0x4F, 0x0A, 0x45, 0x4C, 0x20, 0x46, 0x55, 0x53, 0x49, 0x42, 0x4C, 0x45, 0x2E,
	0x00, 0x45, 0x53, 0x54, 0x4F, 0x20, 0x44, 0x45, 0x42, 0x45, 0x52, 0x49, 0x41, 0x0A, 0x46, 0x55,
	0x4E, 0x43, 0x49, 0x4F, 0x4E, 0x41, 0x52, 0x20, 0x41, 0x48, 0x4F, 0x52, 0x41, 0x2E, 0x00, 0xFF,
	0xEB, 0xEC, 0x53, 0x4F, 0x59, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x2E, 0x40, 0x45, 0x53, 0x54, 0x41,
	0x53, 0x0A, 0x42, 0x55, 0x53, 0x43, 0x41, 0x4E, 0x44, 0x4F, 0x0A, 0x44, 0x4F, 0x43, 0x55, 0x4D,
	0x45, 0x4E, 0x54, 0x41, 0x43, 0x49, 0x4F, 0x4E, 0x0A, 0x46, 0x41, 0x4C, 0x53, 0x41, 0x3F, 0x0B,
	0xFF, 0xE9, 0xEA, 0x53, 0x49, 0x2C, 0x20, 0x59, 0x20, 0x4C, 0x4F, 0x0A, 0x4D, 0x41, 0x53, 0x20,
	0x52, 0x41, 0x50, 0x49, 0x44, 0x4F, 0x0A, 0x50, 0x4F, 0x53, 0x49, 0x42, 0x4C, 0x45, 0x2E, 0x0B,
	0xFF, 0xEB, 0xEC, 0x7B, 0x31, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x4F,
	0x53, 0x21, 0x0B, 0xFF, 0xE9, 0xEA, 0x40, 0x40, 0x40, 0x31, 0x35, 0x30, 0x30, 0x3F, 0x3F, 0x3F,
	0x0B, 0xFF, 0xEB, 0xEC, 0x53, 0x49, 0x49, 0x49, 0x2C, 0x20, 0x43, 0x4F, 0x52, 0x52, 0x4F, 0x20,
	0x55, 0x4E, 0x0A, 0x47, 0x52, 0x41, 0x4E, 0x20, 0x50, 0x45, 0x4C, 0x49, 0x47, 0x52, 0x4F, 0x0A,
	0x41, 0x51, 0x55, 0x49, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x50, 0x45, 0x52, 0x4F, 0x2C, 0x20, 0x59,
	0x4F, 0x20, 0x4E, 0x4F, 0x0A, 0x54, 0x45, 0x4E, 0x47, 0x4F, 0x20, 0x53, 0x55, 0x46, 0x49, 0x43,
	0x49, 0x45, 0x4E, 0x54, 0x45, 0x0B, 0xFF, 0xEB, 0xEC, 0x56, 0x45, 0x20, 0x41, 0x20, 0x4C, 0x41,
	0x20, 0x4F, 0x46, 0x49, 0x43, 0x49, 0x4E, 0x41, 0x0A, 0x44, 0x45, 0x20, 0x45, 0x4D, 0x50, 0x4C,
	0x45, 0x4F, 0x2C, 0x0A, 0x41, 0x4C, 0x4C, 0x49, 0x20, 0x45, 0x4E, 0x43, 0x4F, 0x4E, 0x54, 0x52,
	0x41, 0x52, 0x41, 0x53, 0x0A, 0x54, 0x52, 0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B, 0x59, 0x20,
	0x56, 0x55, 0x45, 0x4C, 0x56, 0x45, 0x20, 0x41, 0x20, 0x56, 0x45, 0x52, 0x4D, 0x45, 0x0A, 0x43,
	0x55, 0x41, 0x4E, 0x44, 0x4F, 0x20, 0x54, 0x45, 0x4E, 0x47, 0x41, 0x53, 0x0A, 0x4C, 0x41, 0x20,
	0x50, 0x41, 0x53, 0x54, 0x41, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x43, 0x4F, 0x4E, 0x4F, 0x5A, 0x43,
	0x4F, 0x20, 0x41, 0x20, 0x45, 0x53, 0x45, 0x0A, 0x54, 0x49, 0x4F, 0x2E, 0x20, 0x54, 0x49, 0x45,
	0x4E, 0x45, 0x20, 0x55, 0x4E, 0x0A, 0x41, 0x4D, 0x49, 0x47, 0x4F, 0x20, 0x45, 0x4E, 0x20, 0x4C,
	0x41, 0x0A, 0x50, 0x4F, 0x4C, 0x49, 0x43, 0x49, 0x41, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x40, 0x44,
	0x4F, 0x4E, 0x44, 0x45, 0x20, 0x50, 0x55, 0x45, 0x44, 0x4F, 0x0A, 0x45, 0x4E, 0x43, 0x4F, 0x4E,
	0x54, 0x52, 0x41, 0x52, 0x20, 0x41, 0x0A, 0x45, 0x53, 0x45, 0x20, 0x41, 0x4D, 0x49, 0x47, 0x4F,
	0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x56, 0x45, 0x20, 0x41, 0x4C, 0x20, 0x41, 0x52, 0x45, 0x41, 0x0A,
	0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x4E, 0x47, 0x49, 0x44, 0x41, 0x20, 0x31, 0x2C, 0x0A, 0x43,
	0x52, 0x45, 0x4F, 0x20, 0x51, 0x55, 0x45, 0x20, 0x45, 0x53, 0x54, 0x41, 0x20, 0x44, 0x45, 0x0A,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x49, 0x4F, 0x20, 0x41, 0x4C, 0x4C, 0x49, 0x2E, 0x0B, 0x50,
	0x45, 0x52, 0x4F, 0x20, 0x54, 0x45, 0x4E, 0x20, 0x43, 0x55, 0x49, 0x44, 0x41, 0x44, 0x4F, 0x2C,
	0x0A, 0x7B, 0x45, 0x53, 0x4F, 0x53, 0x20, 0x54, 0x49, 0x4F, 0x53, 0x20, 0x53, 0x4F, 0x4E, 0x0A,
	0x55, 0x4E, 0x4F, 0x53, 0x20, 0x4D, 0x49, 0x53, 0x45, 0x52, 0x41, 0x42, 0x4C, 0x45, 0x53, 0x21,
	0x00, 0xFF, 0xEB, 0xEC, 0x59, 0x4F, 0x20, 0x4E, 0x4F, 0x20, 0x53, 0x45, 0x0A, 0x4E, 0x41, 0x44,
	0x41, 0x20, 0x4D, 0x41, 0x53, 0x2C, 0x0A, 0x48, 0x49, 0x4A, 0x4F, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x20, 0x51, 0x55, 0x49, 0x45, 0x52, 0x45, 0x0A, 0x48,
	0x41, 0x43, 0x45, 0x52, 0x20, 0x55, 0x4E, 0x20, 0x54, 0x52, 0x41, 0x54, 0x4F, 0x0A, 0x43, 0x4F,
	0x4E, 0x54, 0x49, 0x47, 0x4F, 0x2E, 0x0B, 0x45, 0x53, 0x54, 0x41, 0x52, 0x41, 0x20, 0x45, 0x53,
	0x50, 0x45, 0x52, 0x41, 0x4E, 0x44, 0x4F, 0x0A, 0x44, 0x45, 0x54, 0x52, 0x41, 0x53, 0x20, 0x44,
	0x45, 0x4C, 0x20, 0x42, 0x41, 0x52, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x56, 0x45, 0x54, 0x45, 0x20,
	0x41, 0x4C, 0x20, 0x42, 0x41, 0x52, 0x2C, 0x0A, 0x48, 0x49, 0x4A, 0x4F, 0x2C, 0x20, 0x43, 0x59,
	0x2D, 0x42, 0x30, 0x32, 0x31, 0x20, 0x54, 0x45, 0x0A, 0x45, 0x53, 0x54, 0x41, 0x20, 0x45, 0x53,
	0x50, 0x45, 0x52, 0x41, 0x4E, 0x44, 0x4F, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x7B, 0x4E, 0x4F, 0x20,
	0x44, 0x49, 0x53, 0x50, 0x41, 0x52, 0x45, 0x53, 0x2C, 0x20, 0x59, 0x4F, 0x0A, 0x4E, 0x4F, 0x20,
	0x53, 0x4F, 0x59, 0x20, 0x43, 0x59, 0x2D, 0x42, 0x30, 0x32, 0x31, 0x21, 0x0B, 0x53, 0x55, 0x20,
	0x45, 0x53, 0x43, 0x4F, 0x4E, 0x44, 0x52, 0x49, 0x4A, 0x4F, 0x0A, 0x45, 0x53, 0x54, 0x41, 0x20,
	0x41, 0x48, 0x49, 0x20, 0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B, 0x53, 0x55, 0x20, 0x43, 0x4F,
	0x4C, 0x45, 0x47, 0x41, 0x2C, 0x0A, 0x45, 0x4C, 0x20, 0x50, 0x4F, 0x4C, 0x49, 0x0A, 0x54, 0x49,
	0x45, 0x4E, 0x45, 0x20, 0x4C, 0x41, 0x20, 0x4C, 0x4C, 0x41, 0x56, 0x45, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x59, 0x4F, 0x20, 0x4E, 0x4F, 0x20, 0x53, 0x45, 0x0A, 0x4E, 0x41, 0x44, 0x41, 0x20, 0x4D,
	0x41, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x55, 0x4E, 0x20, 0x54, 0x49, 0x4F, 0x20, 0x4C, 0x4C,
	0x41, 0x4D, 0x41, 0x44, 0x4F, 0x0B, 0x4A, 0x41, 0x43, 0x4B, 0x20, 0x41, 0x43, 0x4F, 0x52, 0x44,
	0x4F, 0x0A, 0x52, 0x45, 0x55, 0x4E, 0x49, 0x52, 0x53, 0x45, 0x20, 0x43, 0x4F, 0x4E, 0x20, 0x55,
	0x44, 0x2E, 0x0A, 0x45, 0x4E, 0x20, 0x45, 0x4C, 0x20, 0x42, 0x41, 0x52, 0x2E, 0x00, 0x51, 0x55,
	0x45, 0x52, 0x52, 0x49, 0x41, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x4F,
	0x20, 0x44, 0x45, 0x0A, 0x54, 0x52, 0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC,
	0x4E, 0x4F, 0x2C, 0x20, 0x4E, 0x4F, 0x20, 0x45, 0x53, 0x20, 0x41, 0x51, 0x55, 0x49, 0x2E, 0x0A,
	0x56, 0x41, 0x59, 0x41, 0x20, 0x41, 0x20, 0x4C, 0x41, 0x0A, 0x56, 0x45, 0x4E, 0x54, 0x41, 0x4E,
	0x49, 0x4C, 0x4C, 0x41, 0x20, 0x43, 0x2E, 0x00, 0x51, 0x55, 0x45, 0x52, 0x52, 0x49, 0x41, 0x20,
	0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x4F, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x52,
	0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x49, 0x45, 0x4E, 0x20, 0x2E,
	0x2E, 0x4F, 0x2E, 0x4B, 0x2E, 0x2C, 0x0A, 0x45, 0x4C, 0x20, 0x4A, 0x45, 0x46, 0x45, 0x20, 0x4C,
	0x45, 0x0A, 0x52, 0x45, 0x43, 0x49, 0x42, 0x49, 0x52, 0x41, 0x20, 0x41, 0x48, 0x4F, 0x52, 0x41,
	0x00, 0x51, 0x55, 0x45, 0x52, 0x52, 0x49, 0x41, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D,
	0x49, 0x53, 0x4F, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x52, 0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B,
	0xFF, 0xEB, 0xEC, 0x4E, 0x4F, 0x2C, 0x20, 0x4E, 0x4F, 0x20, 0x45, 0x53, 0x20, 0x41, 0x51, 0x55,
	0x49, 0x2E, 0x0A, 0x56, 0x41, 0x59, 0x41, 0x20, 0x41, 0x20, 0x4C, 0x41, 0x0A, 0x56, 0x45, 0x4E,
	0x54, 0x41, 0x4E, 0x49, 0x4C, 0x4C, 0x41, 0x20, 0x42, 0x2E, 0x00, 0x51, 0x55, 0x49, 0x45, 0x52,
	0x4F, 0x20, 0x48, 0x41, 0x42, 0x4C, 0x41, 0x52, 0x0A, 0x43, 0x4F, 0x4E, 0x20, 0x4A, 0x41, 0x43,
	0x4B, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x40, 0x41, 0x48, 0x20, 0x53, 0x49, 0x3F, 0x20, 0x4A, 0x41,
	0x43, 0x4B, 0x20, 0x4E, 0x4F, 0x0A, 0x45, 0x53, 0x54, 0x41, 0x20, 0x41, 0x51, 0x55, 0x49, 0x20,
	0x41, 0x48, 0x4F, 0x52, 0x41, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x4D, 0x45, 0x20, 0x45, 0x4E, 0x56,
	0x49, 0x41, 0x0A, 0x4D, 0x49, 0x20, 0x41, 0x4D, 0x49, 0x47, 0x4F, 0x20, 0x49, 0x41, 0x4E, 0x2E,
	0x0B, 0xFF, 0xEB, 0xEC, 0x4F, 0x2E, 0x4B, 0x2E, 0x20, 0x4A, 0x41, 0x43, 0x4B, 0x20, 0x54, 0x45,
	0x0A, 0x45, 0x53, 0x54, 0x41, 0x20, 0x45, 0x53, 0x50, 0x45, 0x52, 0x41, 0x4E, 0x44, 0x4F, 0x0A,
	0x41, 0x46, 0x55, 0x45, 0x52, 0x41, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x54, 0x49, 0x52, 0x41, 0x4C,
	0x4F, 0x2C, 0x20, 0x48, 0x49, 0x4A, 0x4F, 0x2E, 0x0A, 0x45, 0x52, 0x45, 0x53, 0x20, 0x44, 0x45,
	0x4D, 0x41, 0x53, 0x49, 0x41, 0x44, 0x4F, 0x0A, 0x4A, 0x4F, 0x56, 0x45, 0x4E, 0x20, 0x50, 0x41,
	0x52, 0x41, 0x20, 0x42, 0x45, 0x42, 0x45, 0x52, 0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x41, 0x50, 0x45,
	0x4C, 0x45, 0x53, 0x2C, 0x0A, 0x50, 0x4F, 0x52, 0x20, 0x46, 0x41, 0x56, 0x4F, 0x52, 0x2E, 0x00,
	0x53, 0x4F, 0x59, 0x20, 0x45, 0x4C, 0x0A, 0x4D, 0x45, 0x4E, 0x53, 0x41, 0x4A, 0x45, 0x52, 0x4F,
	0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x7B, 0x41, 0x48, 0x20, 0x53, 0x49, 0x21, 0x20, 0x4C, 0x4C, 0x45,
	0x56, 0x41, 0x0A, 0x45, 0x53, 0x54, 0x45, 0x20, 0x50, 0x41, 0x51, 0x55, 0x45, 0x54, 0x45, 0x20,
	0x41, 0x0A, 0x4C, 0x41, 0x20, 0x41, 0x47, 0x45, 0x4E, 0x43, 0x49, 0x41, 0x20, 0x44, 0x45, 0x0A,
	0x56, 0x49, 0x41, 0x4A, 0x45, 0x53, 0x2E, 0x0B, 0x59, 0x20, 0x54, 0x45, 0x4E, 0x20, 0x43, 0x55,
	0x49, 0x44, 0x41, 0x44, 0x4F, 0x2C, 0x0A, 0x45, 0x53, 0x20, 0x56, 0x41, 0x4C, 0x49, 0x4F, 0x53,
	0x4F, 0x2E, 0x00, 0x54, 0x49, 0x45, 0x4D, 0x50, 0x4F, 0x20, 0x43, 0x4F, 0x4E, 0x43, 0x4C, 0x55,
	0x49, 0x44, 0x4F, 0x00, 0x48, 0x41, 0x59, 0x20, 0x55, 0x4E, 0x20, 0x4C, 0x55, 0x47, 0x41, 0x52,
	0x0A, 0x50, 0x41, 0x52, 0x41, 0x20, 0x4C, 0x41, 0x20, 0x54, 0x41, 0x52, 0x4A, 0x45, 0x54, 0x41,
	0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x52, 0x41, 0x43, 0x49, 0x41, 0x53, 0x2C, 0x20, 0x43, 0x4F,
	0x4E, 0x52, 0x41, 0x44, 0x2E, 0x0A, 0x7B, 0x45, 0x53, 0x54, 0x4F, 0x53, 0x20, 0x50, 0x4F, 0x4C,
	0x49, 0x53, 0x0A, 0x48, 0x41, 0x42, 0x52, 0x49, 0x41, 0x4E, 0x20, 0x43, 0x4F, 0x4E, 0x53, 0x45,
	0x47, 0x55, 0x49, 0x44, 0x4F, 0x0A, 0x4D, 0x49, 0x20, 0x50, 0x45, 0x4C, 0x4C, 0x45, 0x4A, 0x4F,
	0x21, 0x0B, 0x42, 0x49, 0x45, 0x4E, 0x2C, 0x53, 0x55, 0x50, 0x4F, 0x4E, 0x47, 0x4F, 0x20, 0x51,
	0x55, 0x45, 0x0A, 0x4E, 0x4F, 0x20, 0x52, 0x45, 0x43, 0x55, 0x45, 0x52, 0x44, 0x41, 0x53, 0x20,
	0x41, 0x0A, 0x54, 0x55, 0x20, 0x56, 0x49, 0x45, 0x4A, 0x4F, 0x0A, 0x41, 0x4D, 0x49, 0x47, 0x4F,
	0x20, 0x49, 0x41, 0x4E, 0x2E, 0x0B, 0x53, 0x49, 0x45, 0x4E, 0x54, 0x41, 0x54, 0x45, 0x2C, 0x0A,
	0x41, 0x52, 0x52, 0x45, 0x47, 0x4C, 0x41, 0x52, 0x45, 0x4D, 0x4F, 0x53, 0x0A, 0x45, 0x53, 0x54,
	0x4F, 0x20, 0x45, 0x4E, 0x53, 0x45, 0x47, 0x55, 0x49, 0x44, 0x41, 0x2E, 0x00, 0x49, 0x41, 0x4E,
	0x2C, 0x20, 0x40, 0x51, 0x55, 0x45, 0x20, 0x54, 0x49, 0x45, 0x4E, 0x45, 0x0A, 0x55, 0x4E, 0x4F,
	0x20, 0x51, 0x55, 0x45, 0x20, 0x48, 0x41, 0x43, 0x45, 0x52, 0x20, 0x0A, 0x50, 0x41, 0x52, 0x41,
	0x20, 0x49, 0x52, 0x20, 0x41, 0x0A, 0x4C, 0x41, 0x20, 0x54, 0x49, 0x45, 0x52, 0x52, 0x41, 0x3F,
	0x0B, 0xFF, 0xEB, 0xEC, 0x45, 0x4C, 0x20, 0x50, 0x52, 0x45, 0x43, 0x49, 0x4F, 0x20, 0x44, 0x45,
	0x4C, 0x0A, 0x42, 0x49, 0x4C, 0x4C, 0x45, 0x54, 0x45, 0x20, 0x45, 0x53, 0x0A, 0x41, 0x53, 0x54,
	0x52, 0x4F, 0x4E, 0x4F, 0x4D, 0x49, 0x43, 0x4F, 0x2E, 0x0B, 0x53, 0x4F, 0x4C, 0x4F, 0x20, 0x54,
	0x45, 0x20, 0x51, 0x55, 0x45, 0x44, 0x41, 0x0A, 0x50, 0x41, 0x52, 0x54, 0x49, 0x43, 0x49, 0x50,
	0x41, 0x52, 0x20, 0x45, 0x4E, 0x20, 0x4C, 0x41, 0x0A, 0x54, 0x4F, 0x52, 0x52, 0x45, 0x20, 0x44,
	0x45, 0x20, 0x4C, 0x41, 0x0A, 0x4D, 0x55, 0x45, 0x52, 0x54, 0x45, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA,
	0x40, 0x4C, 0x41, 0x20, 0x54, 0x4F, 0x52, 0x52, 0x45, 0x0A, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x20,
	0x4D, 0x55, 0x45, 0x52, 0x54, 0x45, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x45, 0x53, 0x20, 0x55, 0x4E,
	0x20, 0x43, 0x4F, 0x4E, 0x43, 0x55, 0x52, 0x53, 0x4F, 0x0A, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x20,
	0x54, 0x45, 0x4C, 0x45, 0x2E, 0x20, 0x45, 0x4C, 0x0A, 0x47, 0x41, 0x4E, 0x41, 0x44, 0x4F, 0x52,
	0x20, 0x4F, 0x42, 0x54, 0x49, 0x45, 0x4E, 0x45, 0x0A, 0x55, 0x4E, 0x20, 0x42, 0x49, 0x4C, 0x4C,
	0x45, 0x54, 0x45, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x4F, 0x2E, 0x4B, 0x2E, 0x20, 0x40, 0x50, 0x55,
	0x45, 0x44, 0x45, 0x53, 0x0A, 0x43, 0x4F, 0x4E, 0x53, 0x45, 0x47, 0x55, 0x49, 0x52, 0x4D, 0x45,
	0x0A, 0x44, 0x4F, 0x43, 0x55, 0x4D, 0x45, 0x4E, 0x54, 0x41, 0x43, 0x49, 0x4F, 0x4E, 0x0A, 0x46,
	0x41, 0x4C, 0x53, 0x41, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x53, 0x49, 0x4E, 0x20, 0x50, 0x52, 0x4F,
	0x42, 0x4C, 0x45, 0x4D, 0x41, 0x53, 0x2E, 0x0A, 0x56, 0x45, 0x20, 0x41, 0x4C, 0x20, 0x42, 0x41,
	0x52, 0x20, 0x59, 0x0A, 0x50, 0x52, 0x45, 0x47, 0x55, 0x4E, 0x54, 0x41, 0x20, 0x50, 0x4F, 0x52,
	0x0A, 0x4A, 0x41, 0x43, 0x4B, 0x2E, 0x0B, 0x44, 0x49, 0x4C, 0x45, 0x20, 0x51, 0x55, 0x45, 0x20,
	0x54, 0x45, 0x0A, 0x45, 0x4E, 0x56, 0x49, 0x4F, 0x20, 0x59, 0x4F, 0x2E, 0x20, 0x41, 0x48, 0x2C,
	0x0A, 0x50, 0x4F, 0x52, 0x20, 0x43, 0x49, 0x45, 0x52, 0x54, 0x4F, 0x2E, 0x2E, 0x2E, 0x0B, 0x50,
	0x55, 0x53, 0x45, 0x20, 0x45, 0x4C, 0x20, 0x43, 0x41, 0x4D, 0x50, 0x4F, 0x20, 0x44, 0x45, 0x0A,
	0x46, 0x55, 0x45, 0x52, 0x5A, 0x41, 0x20, 0x51, 0x55, 0x45, 0x20, 0x4D, 0x45, 0x0A, 0x50, 0x45,
	0x44, 0x49, 0x53, 0x54, 0x45, 0x20, 0x45, 0x4E, 0x20, 0x54, 0x55, 0x0A, 0x42, 0x4F, 0x4C, 0x53,
	0x49, 0x4C, 0x4C, 0x4F, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x43, 0x48, 0x41, 0x43, 0x48, 0x49, 0x2E,
	0x20, 0x47, 0x52, 0x41, 0x43, 0x49, 0x41, 0x53, 0x0A, 0x49, 0x41, 0x4E, 0x2E, 0x20, 0x48, 0x41,
	0x53, 0x54, 0x41, 0x20, 0x4C, 0x41, 0x0A, 0x50, 0x52, 0x4F, 0x58, 0x49, 0x4D, 0x41, 0x2E, 0x2E,
	0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x55, 0x45, 0x4E, 0x41, 0x20, 0x53, 0x55, 0x45, 0x52, 0x54,
	0x45, 0x2E, 0x0A, 0x43, 0x4F, 0x4E, 0x54, 0x41, 0x43, 0x54, 0x41, 0x52, 0x45, 0x4D, 0x4F, 0x53,
	0x0A, 0x41, 0x20, 0x54, 0x55, 0x20, 0x4C, 0x4C, 0x45, 0x47, 0x41, 0x44, 0x41, 0x20, 0x41, 0x0A,
	0x4C, 0x41, 0x20, 0x54, 0x49, 0x45, 0x52, 0x52, 0x41, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x49,
	0x45, 0x4E, 0x56, 0x45, 0x4E, 0x49, 0x44, 0x4F, 0x20, 0x41, 0x0A, 0x4E, 0x45, 0x57, 0x20, 0x57,
	0x41, 0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x2C, 0x0A, 0x4A, 0x4F, 0x56, 0x45, 0x4E,
	0x43, 0x49, 0x54, 0x4F, 0x2E, 0x0B, 0x41, 0x51, 0x55, 0x49, 0x20, 0x54, 0x49, 0x45, 0x4E, 0x45,
	0x53, 0x20, 0x55, 0x4E, 0x0A, 0x4D, 0x41, 0x50, 0x41, 0x20, 0x44, 0x45, 0x20, 0x4C, 0x41, 0x0A,
	0x43, 0x49, 0x55, 0x44, 0x41, 0x44, 0x20, 0x51, 0x55, 0x45, 0x20, 0x54, 0x45, 0x0A, 0x53, 0x45,
	0x52, 0x41, 0x20, 0x4D, 0x55, 0x59, 0x20, 0x55, 0x54, 0x49, 0x4C, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA,
	0x4D, 0x55, 0x43, 0x48, 0x41, 0x53, 0x20, 0x47, 0x52, 0x41, 0x43, 0x49, 0x41, 0x53, 0x2E, 0x00,
	0xFF, 0xEB, 0xEC, 0x51, 0x55, 0x45, 0x20, 0x54, 0x45, 0x4E, 0x47, 0x41, 0x20, 0x55, 0x4E, 0x0A,
	0x42, 0x55, 0x45, 0x4E, 0x20, 0x44, 0x49, 0x41, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x44, 0x45, 0x42,
	0x45, 0x20, 0x54, 0x45, 0x4E, 0x45, 0x52, 0x20, 0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49,
	0x53, 0x4F, 0x20, 0x50, 0x41, 0x52, 0x41, 0x0A, 0x50, 0x4F, 0x44, 0x45, 0x52, 0x20, 0x54, 0x52,
	0x41, 0x42, 0x41, 0x4A, 0x41, 0x52, 0x2E, 0x0B, 0x50, 0x55, 0x45, 0x44, 0x45, 0x20, 0x43, 0x4F,
	0x4E, 0x53, 0x45, 0x47, 0x55, 0x49, 0x52, 0x0A, 0x55, 0x4E, 0x4F, 0x20, 0x45, 0x4E, 0x20, 0x45,
	0x4C, 0x20, 0x43, 0x45, 0x4E, 0x54, 0x52, 0x4F, 0x0A, 0x41, 0x44, 0x4D, 0x49, 0x4E, 0x49, 0x53,
	0x54, 0x52, 0x41, 0x54, 0x49, 0x56, 0x4F, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x4E, 0x4F, 0x20, 0x54,
	0x45, 0x4E, 0x47, 0x4F, 0x0A, 0x54, 0x49, 0x45, 0x4D, 0x50, 0x4F, 0x2E, 0x00, 0x42, 0x55, 0x45,
	0x4E, 0x4F, 0x53, 0x20, 0x44, 0x49, 0x41, 0x53, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x42, 0x55, 0x45,
	0x4E, 0x4F, 0x53, 0x20, 0x44, 0x49, 0x41, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x48, 0x45, 0x20,
	0x56, 0x49, 0x53, 0x54, 0x4F, 0x20, 0x41, 0x20, 0x45, 0x53, 0x45, 0x0A, 0x54, 0x49, 0x4F, 0x20,
	0x41, 0x4E, 0x54, 0x45, 0x53, 0x20, 0x45, 0x4E, 0x0A, 0x45, 0x4C, 0x20, 0x42, 0x41, 0x52, 0x2E,
	0x00, 0x42, 0x55, 0x45, 0x4E, 0x4F, 0x53, 0x20, 0x44, 0x49, 0x41, 0x53, 0x2E, 0x0B, 0xFF, 0xEB,
	0xEC, 0x42, 0x55, 0x45, 0x4E, 0x4F, 0x53, 0x20, 0x44, 0x49, 0x41, 0x53, 0x2E, 0x00, 0xFF, 0xEB,
	0xEC, 0x53, 0x49, 0x2C, 0x20, 0x4C, 0x45, 0x20, 0x43, 0x4F, 0x4E, 0x4F, 0x5A, 0x43, 0x4F, 0x2E,
	0x0A, 0x45, 0x53, 0x20, 0x55, 0x4E, 0x20, 0x48, 0x41, 0x42, 0x49, 0x54, 0x55, 0x41, 0x4C, 0x2E,
	0x00, 0x20, 0x00, 0x20, 0x00, 0x51, 0x55, 0x45, 0x52, 0x52, 0x49, 0x41, 0x20, 0x55, 0x4E, 0x0A,
	0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x4F, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x52, 0x41, 0x42, 0x41,
	0x4A, 0x4F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x4E, 0x4F, 0x20, 0x48, 0x41, 0x59, 0x20, 0x50, 0x52,
	0x4F, 0x42, 0x4C, 0x45, 0x4D, 0x41, 0x2E, 0x0A, 0x50, 0x41, 0x52, 0x41, 0x20, 0x43, 0x4F, 0x4E,
	0x53, 0x45, 0x47, 0x55, 0x49, 0x52, 0x0A, 0x55, 0x4E, 0x20, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53,
	0x4F, 0x2E, 0x2E, 0x2E, 0x0B, 0x4E, 0x45, 0x43, 0x45, 0x53, 0x49, 0x54, 0x4F, 0x20, 0x53, 0x55,
	0x0A, 0x54, 0x41, 0x52, 0x4A, 0x45, 0x54, 0x41, 0x20, 0x49, 0x44, 0x2E, 0x00, 0xFF, 0xEB, 0xEC,
	0x41, 0x59, 0x55, 0x44, 0x41, 0x2E, 0x2E, 0x2E, 0x41, 0x59, 0x55, 0x44, 0x41, 0x2E, 0x2E, 0x2E,
	0x00, 0xFF, 0xEB, 0xEC, 0x41, 0x59, 0x55, 0x44, 0x45, 0x4D, 0x45, 0x2C, 0x20, 0x4A, 0x4F, 0x56,
	0x45, 0x4E, 0x2E, 0x0A, 0x48, 0x45, 0x20, 0x53, 0x49, 0x44, 0x4F, 0x20, 0x41, 0x54, 0x41, 0x43,
	0x41, 0x44, 0x4F, 0x0A, 0x50, 0x4F, 0x52, 0x20, 0x55, 0x4E, 0x4F, 0x53, 0x20, 0x0A, 0x4D, 0x55,
	0x54, 0x41, 0x4E, 0x54, 0x45, 0x53, 0x2E, 0x2E, 0x2E, 0x0B, 0x59, 0x20, 0x4E, 0x4F, 0x20, 0x50,
	0x55, 0x45, 0x44, 0x4F, 0x0A, 0x43, 0x41, 0x4D, 0x49, 0x4E, 0x41, 0x52, 0x2E, 0x0B, 0x42, 0x55,
	0x53, 0x51, 0x55, 0x45, 0x20, 0x4D, 0x49, 0x0A, 0x54, 0x45, 0x4C, 0x45, 0x50, 0x4F, 0x52, 0x54,
	0x41, 0x44, 0x4F, 0x52, 0x2E, 0x0B, 0x4E, 0x45, 0x43, 0x45, 0x53, 0x49, 0x54, 0x4F, 0x0A, 0x41,
	0x53, 0x49, 0x53, 0x54, 0x45, 0x4E, 0x43, 0x49, 0x41, 0x0A, 0x4D, 0x45, 0x44, 0x49, 0x43, 0x41,
	0x20, 0x55, 0x52, 0x47, 0x45, 0x4E, 0x54, 0x45, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x52, 0x41,
	0x43, 0x49, 0x41, 0x53, 0x2E, 0x41, 0x43, 0x41, 0x42, 0x41, 0x53, 0x0A, 0x44, 0x45, 0x20, 0x53,
	0x41, 0x4C, 0x56, 0x41, 0x52, 0x4D, 0x45, 0x0A, 0x4C, 0x41, 0x20, 0x56, 0x49, 0x44, 0x41, 0x2E,
	0x00, 0xFF, 0xEB, 0xEC, 0x50, 0x41, 0x52, 0x41, 0x20, 0x49, 0x52, 0x20, 0x41, 0x20, 0x4E, 0x45,
	0x57, 0x0A, 0x57, 0x41, 0x53, 0x48, 0x49, 0x4E, 0x47, 0x54, 0x4F, 0x4E, 0x2C, 0x0A, 0x54, 0x49,
	0x45, 0x4E, 0x45, 0x20, 0x51, 0x55, 0x45, 0x20, 0x53, 0x41, 0x4C, 0x54, 0x41, 0x52, 0x0A, 0x50,
	0x4F, 0x52, 0x20, 0x45, 0x53, 0x54, 0x45, 0x20, 0x41, 0x47, 0x55, 0x4A, 0x45, 0x52, 0x4F, 0x0B,
	0x50, 0x45, 0x52, 0x4F, 0x20, 0x59, 0x4F, 0x20, 0x51, 0x55, 0x45, 0x20, 0x54, 0x55, 0x0A, 0x55,
	0x53, 0x41, 0x52, 0x49, 0x41, 0x20, 0x55, 0x4E, 0x0A, 0x43, 0x49, 0x4E, 0x54, 0x55, 0x52, 0x4F,
	0x4E, 0x20, 0x41, 0x4E, 0x54, 0x49, 0x2D, 0x47, 0x2E, 0x0B, 0xFF, 0xE9, 0xEA, 0x40, 0x44, 0x4F,
	0x4E, 0x44, 0x45, 0x20, 0x50, 0x55, 0x45, 0x44, 0x4F, 0x0A, 0x45, 0x4E, 0x43, 0x4F, 0x4E, 0x54,
	0x52, 0x41, 0x52, 0x20, 0x55, 0x4E, 0x4F, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x41, 0x48, 0x4F, 0x52,
	0x41, 0x2C, 0x20, 0x50, 0x55, 0x45, 0x44, 0x4F, 0x0A, 0x56, 0x45, 0x4E, 0x44, 0x45, 0x52, 0x54,
	0x45, 0x20, 0x55, 0x4E, 0x4F, 0x3A, 0x0A, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49,
	0x54, 0x4F, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x4F, 0x4E, 0x20, 0x56, 0x4F, 0x59, 0x41,
	0x47, 0x45, 0x2C, 0x0A, 0x4A, 0x4F, 0x56, 0x45, 0x4E, 0x43, 0x49, 0x54, 0x4F, 0x2E, 0x00, 0x4E,
	0x45, 0x43, 0x45, 0x53, 0x49, 0x54, 0x4F, 0x20, 0x55, 0x4E, 0x0A, 0x43, 0x41, 0x52, 0x54, 0x55,
	0x43, 0x48, 0x4F, 0x0A, 0x4D, 0x41, 0x47, 0x4E, 0x45, 0x54, 0x49, 0x43, 0x4F, 0x0A, 0x52, 0x45,
	0x43, 0x41, 0x52, 0x47, 0x41, 0x44, 0x4F, 0x00, 0x51, 0x55, 0x45, 0x52, 0x52, 0x49, 0x41, 0x20,
	0x55, 0x4E, 0x0A, 0x50, 0x45, 0x52, 0x4D, 0x49, 0x53, 0x4F, 0x20, 0x44, 0x45, 0x0A, 0x54, 0x52,
	0x41, 0x42, 0x41, 0x4A, 0x4F, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x50, 0x52, 0x49, 0x4D, 0x45, 0x52,
	0x41, 0x20, 0x50, 0x4C, 0x41, 0x4E, 0x54, 0x41, 0x2E, 0x00, 0x55, 0x4E, 0x41, 0x20, 0x56, 0x4F,
	0x5A, 0x20, 0x49, 0x4E, 0x54, 0x45, 0x52, 0x49, 0x4F, 0x52, 0x0A, 0x49, 0x4E, 0x54, 0x45, 0x52,
	0x52, 0x55, 0x4D, 0x50, 0x45, 0x20, 0x54, 0x55, 0x53, 0x0A, 0x50, 0x45, 0x4E, 0x53, 0x41, 0x4D,
	0x49, 0x45, 0x4E, 0x54, 0x4F, 0x53, 0x2E, 0x0B, 0xFF, 0xEB, 0xEC, 0x43, 0x52, 0x45, 0x45, 0x4D,
	0x45, 0x2C, 0x20, 0x48, 0x49, 0x4A, 0x4F, 0x2C, 0x0A, 0x50, 0x4F, 0x4E, 0x20, 0x4C, 0x41, 0x20,
	0x43, 0x41, 0x52, 0x47, 0x41, 0x0A, 0x41, 0x54, 0x4F, 0x4D, 0x49, 0x43, 0x41, 0x20, 0x41, 0x51,
	0x55, 0x49, 0x2E, 0x2E, 0x2E, 0x0B, 0x59, 0x20, 0x48, 0x55, 0x59, 0x45, 0x20, 0x45, 0x4E, 0x20,
	0x43, 0x55, 0x41, 0x4E, 0x54, 0x4F, 0x0A, 0x41, 0x4C, 0x43, 0x41, 0x4E, 0x43, 0x45, 0x20, 0x45,
	0x4C, 0x0A, 0x4E, 0x55, 0x43, 0x4C, 0x45, 0x4F, 0x20, 0x44, 0x45, 0x4C, 0x0A, 0x50, 0x4C, 0x41,
	0x4E, 0x45, 0x54, 0x41, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x47, 0x55, 0x49, 0x41, 0x4D, 0x45, 0x2C,
	0x0A, 0x4A, 0x4F, 0x56, 0x45, 0x4E, 0x43, 0x49, 0x54, 0x4F, 0x2E, 0x0B, 0x4C, 0x4C, 0x45, 0x56,
	0x41, 0x4D, 0x45, 0x20, 0x41, 0x4C, 0x20, 0x0A, 0x43, 0x45, 0x4E, 0x54, 0x52, 0x4F, 0x20, 0x44,
	0x45, 0x0A, 0x49, 0x4E, 0x56, 0x45, 0x53, 0x54, 0x49, 0x47, 0x41, 0x43, 0x49, 0x4F, 0x4E, 0x00,
	0xFF, 0xEB, 0xEC, 0x47, 0x52, 0x41, 0x43, 0x49, 0x41, 0x53, 0x20, 0x50, 0x4F, 0x52, 0x0A, 0x54,
	0x55, 0x20, 0x41, 0x59, 0x55, 0x44, 0x41, 0x2E, 0x2E, 0x2E, 0x0B, 0x48, 0x45, 0x20, 0x4C, 0x4C,
	0x45, 0x47, 0x41, 0x44, 0x4F, 0x0A, 0x53, 0x49, 0x4E, 0x20, 0x50, 0x52, 0x4F, 0x42, 0x4C, 0x45,
	0x4D, 0x41, 0x53, 0x0A, 0x59, 0x20, 0x59, 0x41, 0x20, 0x4E, 0x4F, 0x20, 0x48, 0x41, 0x59, 0x0A,
	0x50, 0x45, 0x4C, 0x49, 0x47, 0x52, 0x4F, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x42, 0x49, 0x45, 0x4E,
	0x2C, 0x20, 0x40, 0x4D, 0x45, 0x20, 0x48, 0x41, 0x53, 0x0A, 0x54, 0x52, 0x41, 0x49, 0x44, 0x4F,
	0x20, 0x45, 0x4C, 0x0A, 0x50, 0x41, 0x51, 0x55, 0x45, 0x54, 0x45, 0x3F, 0x00, 0x40, 0x43, 0x55,
	0x41, 0x4E, 0x54, 0x4F, 0x20, 0x43, 0x55, 0x45, 0x53, 0x54, 0x41, 0x0A, 0x55, 0x4E, 0x20, 0x42,
	0x49, 0x4C, 0x4C, 0x45, 0x54, 0x45, 0x20, 0x41, 0x0A, 0x4C, 0x41, 0x20, 0x54, 0x49, 0x45, 0x52,
	0x52, 0x41, 0x3F, 0x0B, 0xFF, 0xEB, 0xEC, 0x35, 0x30, 0x2E, 0x30, 0x30, 0x30, 0x20, 0x43, 0x52,
	0x45, 0x44, 0x49, 0x54, 0x4F, 0x53, 0x2E, 0x00, 0xFF, 0xEB, 0xEC, 0x46, 0x41, 0x56, 0x4F, 0x52,
	0x2C, 0x20, 0x43, 0x4F, 0x4E, 0x0A, 0x46, 0x41, 0x56, 0x4F, 0x52, 0x20, 0x53, 0x45, 0x0A, 0x50,
	0x41, 0x47, 0x41, 0x3A, 0x0B, 0x31, 0x35, 0x30, 0x30, 0x20, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54,
	0x4F, 0x53, 0x20, 0x59, 0x0A, 0x4C, 0x4F, 0x53, 0x20, 0x50, 0x41, 0x50, 0x45, 0x4C, 0x45, 0x53,
	0x0A, 0x53, 0x4F, 0x4E, 0x20, 0x54, 0x55, 0x59, 0x4F, 0x53, 0x2E, 0x00
};

const char *LocaleData::_textsTableFR[] = {
	"CONTINUER OU ABANDONNER ?",
	"TEMPS",
	"CONTINUER",
	"ABANDONNER",
	"TERMINEE",
	"NIVEAU",
	"START",
	"DIFFICULTE",
	"MOT DE PASSE",
	"INFO",
	"QUITTER",
	"NIVEAU DE DIFFICULTE :",
	"FACILE",
	"NORMAL",
	"EXPERT",
	"ENTREZ LE MOT DE PASSE POUR",
	"ACCEDER AU NIVEAU SOUHAITE:",
	"REPRENDRE",
	"ABANDONNER",
	"CHARGER",
	"SAUVEGARDER",
	"PARTIE"
};

const char *LocaleData::_textsTableEN[] = {
	"CONTINUE OR ABORT THIS GAME ?",
	"TIME",
	"CONTINUE",
	"ABORT",
	"COMPLETED",
	"LEVEL",
	"START",
	"SKILL",
	"PASSWORD",
	"INFO",
	"QUIT",
	"SKILL LEVEL :",
	"EASY",
	"NORMAL",
	"EXPERT",
	"Enter password for desired",
	"level :",
	"RESUME GAME",
	"ABORT GAME",
	"LOAD GAME",
	"SAVE GAME",
	"SLOT"
};

const char *LocaleData::_textsTableDE[] = {
	"WEITERSPIELEN ODER ABBRECHEN ?",
	"ZEIT : ",
	"WEITERSPIELEN",
	"ABBRECHEN",
	"FERTIG",
	"LEVEL",
	"START",
	"SKILL",
	"PASSWORD",
	"INFO",
	"END",
	"SKILL LEVEL :",
	"LEICHT",
	"NORMAL",
	"PROFI",
	"GEBEN SIE DAS PASSWORT F[R",
	"DAS GEW[NSCHTE LEVEL EIN :",
	"WEITERSPIELEN",
	"SPIEL ABBRECHEN",
	"LADEN",
	"SPEICHERN",
	"SPIEL"
};

const char *LocaleData::_textsTableSP[] = {
	"CONTINUAR O TERMINAR JUEGO ?",
	"TIEMPO",
	"SEGUIR",
	"PARAR",
	"PUNTOS",
	"REANUDAR JUEGO",
	"EMPEZAR",
	"DIFICULTAD",
	"CONTRASE}A",
	"INFO",
	"SALIR",
	"NIVEL DE DIFICULTAD :",
	"SENCILLO",
	"NORMAL",
	"EXPERTO",
	"ESCRIBA LA CONTRASE}A",
	"PARA EL NIVEL DESEADO :",
	"REANUDAR JUEGO",
	"PARAR JUEGO",
	"CARGAR DATOS",
	"GUARDAR DATOS",
	"JUEGO"
};

const uint16 Resource::_voicesOffsetsTable[] = {
	0x0064, 0x006A, 0x0070, 0x0084, 0x0090, 0x0096, 0x009E, 0x00A4, 0x00AE, 0x00B4,
	0x00BC, 0x00C4, 0x00CC, 0x00D4, 0x00E0, 0x00E6, 0x00EC, 0x00F6, 0x00FC, 0x0102,
	0x010C, 0x0126, 0x0130, 0x0136, 0x013E, 0x0144, 0x014C, 0x0152, 0x015A, 0x0160,
	0x0166, 0x016C, 0x0176, 0x017C, 0x0186, 0x018C, 0x0198, 0x019E, 0x01A4, 0x01AC,
	0x01B6, 0x01BE, 0x01C6, 0x01CC, 0x01D4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0x0000, 0x0001, 0x0073, 0x0073, 0x0001, 0x0050, 0x00C3, 0x0008, 0x00D7, 0x007D,
	0x0078, 0x007D, 0x0087, 0x005A, 0x00E1, 0x0087, 0x0555, 0x0004, 0x00D7, 0x0069,
	0x00EB, 0x00A5, 0x0825, 0x0001, 0x008C, 0x08B1, 0x0002, 0x00CD, 0x0073, 0x09F1,
	0x0001, 0x0113, 0x0B04, 0x0003, 0x0113, 0x008C, 0x00B9, 0x0D5C, 0x0001, 0x0096,
	0x0DF2, 0x0002, 0x00AF, 0x0082, 0x0F23, 0x0002, 0x0069, 0x009B, 0x1027, 0x0002,
	0x0069, 0x00EB, 0x117B, 0x0002, 0x0069, 0x00C3, 0x12A7, 0x0004, 0x0064, 0x00AA,
	0x0078, 0x00DC, 0x1509, 0x0001, 0x00B4, 0x15BD, 0x0001, 0x0046, 0x1603, 0x0003,
	0x0050, 0x0118, 0x00A5, 0x1810, 0x0001, 0x0041, 0x1851, 0x0001, 0x0082, 0x18D3,
	0x0003, 0x0104, 0x00D7, 0x00AF, 0x1B5D, 0x000B, 0x00AA, 0x00BE, 0x0127, 0x005A,
	0x00F5, 0x00AA, 0x0104, 0x00BE, 0x00DC, 0x00B9, 0x00D7, 0x2413, 0x0003, 0x00C3,
	0x00E6, 0x003C, 0x25F8, 0x0001, 0x0069, 0x2661, 0x0002, 0x00BE, 0x00AF, 0x27CE,
	0x0001, 0x0050, 0x281E, 0x0002, 0x0041, 0x0037, 0x2896, 0x0001, 0x011D, 0x29B3,
	0x0002, 0x0041, 0x003C, 0x2A30, 0x0001, 0x00A5, 0x2AD5, 0x0001, 0x0000, 0x2AD5,
	0x0001, 0x0000, 0x2AD5, 0x0003, 0x005A, 0x00B9, 0x0073, 0x2C5B, 0x0001, 0x005F,
	0x2CBA, 0x0003, 0x00DC, 0x0064, 0x00F0, 0x2EEA, 0x0001, 0x00B9, 0x2FA3, 0x0004,
	0x0181, 0x013B, 0x005F, 0x0154, 0x3412, 0x0001, 0x00AF, 0x34C1, 0x0001, 0x00A0,
	0x3561, 0x0002, 0x0069, 0x003C, 0x3606, 0x0003, 0x0000, 0x00FA, 0x00F0, 0x37F0,
	0x0002, 0x006E, 0x00A0, 0x38FE, 0x0002, 0x0064, 0x00E6, 0x3A48, 0x0001, 0x00A5,
	0x3AED, 0x0002, 0x0078, 0x0087, 0x3BEC, 0x0002, 0x00AA, 0x00F0
};

const Game::pge_OpcodeProc Game::_pge_opcodeTable[] = {
	/* 0x00 */
	0,
	&Game::pge_op_isInpUp,
	&Game::pge_op_isInpBackward,
	&Game::pge_op_isInpDown,
	/* 0x04 */
	&Game::pge_op_isInpForward,
	&Game::pge_op_isInpUpMod,
	&Game::pge_op_isInpBackwardMod,
	&Game::pge_op_isInpDownMod,
	/* 0x08 */
	&Game::pge_op_isInpForwardMod,
	&Game::pge_op_isInpIdle,
	&Game::pge_op_isInpNoMod,
	&Game::pge_op_getCollision0u,
	/* 0x0C */
	&Game::pge_op_getCollision00,
	&Game::pge_op_getCollision0d,
	&Game::pge_op_getCollision1u,
	&Game::pge_op_getCollision10,
	/* 0x10 */
	&Game::pge_op_getCollision1d,
	&Game::pge_op_getCollision2u,
	&Game::pge_op_getCollision20,
	&Game::pge_op_getCollision2d,
	/* 0x14 */
	&Game::pge_op_doesNotCollide0u,
	&Game::pge_op_doesNotCollide00,
	&Game::pge_op_doesNotCollide0d,
	&Game::pge_op_doesNotCollide1u,
	/* 0x18 */
	&Game::pge_op_doesNotCollide10,
	&Game::pge_op_doesNotCollide1d,
	&Game::pge_op_doesNotCollide2u,
	&Game::pge_op_doesNotCollide20,
	/* 0x1C */
	&Game::pge_op_doesNotCollide2d,
	&Game::pge_op_collides0o0d,
	&Game::pge_op_collides2o2d,
	&Game::pge_op_collides0o0u,
	/* 0x20 */
	&Game::pge_op_collides2o2u,
	&Game::pge_op_collides2u2o,
	&Game::pge_op_isInGroup,
	&Game::pge_op_updateGroup0,
	/* 0x24 */
	&Game::pge_op_updateGroup1,
	&Game::pge_op_updateGroup2,
	&Game::pge_op_updateGroup3,
	&Game::pge_op_isPiegeDead,
	/* 0x28 */
	&Game::pge_op_collides1u2o,
	&Game::pge_op_collides1u1o,
	&Game::pge_op_collides1o1u,
	&Game::pge_o_unk0x2B,
	/* 0x2C */
	&Game::pge_o_unk0x2C,
	&Game::pge_o_unk0x2D,
	&Game::pge_op_nop,
	&Game::pge_op_pickupObject,
	/* 0x30 */
	&Game::pge_op_addItemToInventory,
	&Game::pge_op_copyPiege,
	&Game::pge_op_canUseCurrentInventoryItem,
	&Game::pge_op_removeItemFromInventory,
	/* 0x34 */
	&Game::pge_o_unk0x34,
	&Game::pge_op_isInpMod,
	&Game::pge_op_setCollisionState1,
	&Game::pge_op_setCollisionState0,
	/* 0x38 */
	&Game::pge_op_isInGroup1,
	&Game::pge_op_isInGroup2,
	&Game::pge_op_isInGroup3,
	&Game::pge_op_isInGroup4,
	/* 0x3C */
	&Game::pge_o_unk0x3C,
	&Game::pge_o_unk0x3D,
	&Game::pge_op_setPiegeCounter,
	&Game::pge_op_decPiegeCounter,
	/* 0x40 */
	&Game::pge_o_unk0x40,
	&Game::pge_op_wakeUpPiege,
	&Game::pge_op_removePiege,
	&Game::pge_op_removePiegeIfNotNear,
	/* 0x44 */
	&Game::pge_op_loadPiegeCounter,
	&Game::pge_o_unk0x45,
	&Game::pge_o_unk0x46,
	&Game::pge_o_unk0x47,
	/* 0x48 */
	&Game::pge_o_unk0x48,
	&Game::pge_o_unk0x49,
	&Game::pge_o_unk0x4A,
	&Game::pge_op_killPiege,
	/* 0x4C */
	&Game::pge_op_isInCurrentRoom,
	&Game::pge_op_isNotInCurrentRoom,
	&Game::pge_op_scrollPosY,
	&Game::pge_op_playDefaultDeathCutscene,
	/* 0x50 */
	&Game::pge_o_unk0x50,
	0,
	&Game::pge_o_unk0x52,
	&Game::pge_o_unk0x53,
	/* 0x54 */
	&Game::pge_op_isPiegeNear,
	&Game::pge_op_setLife,
	&Game::pge_op_incLife,
	&Game::pge_op_setPiegeDefaultAnim,
	/* 0x58 */
	&Game::pge_op_setLifeCounter,
	&Game::pge_op_decLifeCounter,
	&Game::pge_op_playCutscene,
	&Game::pge_op_isTempVar2Set,
	/* 0x5C */
	&Game::pge_op_playDeathCutscene,
	&Game::pge_o_unk0x5D,
	&Game::pge_o_unk0x5E,
	&Game::pge_o_unk0x5F,
	/* 0x60 */
	&Game::pge_op_findAndCopyPiege,
	&Game::pge_op_isInRandomRange,
	&Game::pge_o_unk0x62,
	&Game::pge_o_unk0x63,
	/* 0x64 */
	&Game::pge_o_unk0x64,
	&Game::pge_op_addToCredits,
	&Game::pge_op_subFromCredits,
	&Game::pge_o_unk0x67,
	/* 0x68 */
	&Game::pge_op_setCollisionState2,
	&Game::pge_op_saveState,
	&Game::pge_o_unk0x6A,
	&Game::pge_op_isInGroupSlice,
	/* 0x6C */
	&Game::pge_o_unk0x6C,
	&Game::pge_op_isCollidingObject,
	&Game::pge_o_unk0x6E,
	&Game::pge_o_unk0x6F,
	/* 0x70 */
	&Game::pge_o_unk0x70,
	&Game::pge_o_unk0x71,
	&Game::pge_o_unk0x72,
	&Game::pge_o_unk0x73,
	/* 0x74 */
	&Game::pge_op_collides4u,
	&Game::pge_op_doesNotCollide4u,
	&Game::pge_op_isBelowConrad,
	&Game::pge_op_isAboveConrad,
	/* 0x78 */
	&Game::pge_op_isNotFacingConrad,
	&Game::pge_op_isFacingConrad,
	&Game::pge_op_collides2u1u,
	&Game::pge_op_displayText,
	/* 0x7C */
	&Game::pge_o_unk0x7C,
	&Game::pge_op_playSound,
	&Game::pge_o_unk0x7E,
	&Game::pge_o_unk0x7F,
	/* 0x80 */
	&Game::pge_op_setPiegePosX,
	&Game::pge_op_setPiegePosModX,
	&Game::pge_op_changeRoom,
	&Game::pge_op_hasInventoryItem,
	/* 0x84 */
	&Game::pge_op_changeLevel,
	&Game::pge_op_shakeScreen,
	&Game::pge_o_unk0x86,
	&Game::pge_op_playSoundGroup,
	/* 0x88 */
	&Game::pge_op_adjustPos,
	0,
	&Game::pge_op_setTempVar1,
	&Game::pge_op_isTempVar1Set
};

const uint8 Game::_pge_modKeysTable[] = {
	0x40, 0x10, 0x20
};

const uint8 Game::_protectionCodeData[] = {
	0xF9, 0x77, 0x79, 0xF9, 0xF7, 0x39, 0x79, 0x97, 0x39, 0xF9, 0x19, 0x59, 0xB9, 0x59, 0x39, 0xC9,
	0xB9, 0x19, 0xB9, 0x47, 0xB7, 0x49, 0xC9, 0xF9, 0xB9, 0x77, 0xD9, 0x07, 0x77, 0x47, 0xC9, 0x79,
	0x47, 0xF9, 0xD9, 0x19, 0x39, 0xD9, 0xB9, 0x79, 0x39, 0xD9, 0x39, 0xB9, 0x39, 0xF9, 0x19, 0x59,
	0xF9, 0xB7, 0xB9, 0x39, 0x27, 0x79, 0xB9, 0x49, 0x39, 0xD9, 0xB7, 0x07, 0xF9, 0x37, 0x99, 0x07,
	0x37, 0xD9, 0x39, 0xF9, 0xB9, 0x99, 0xB9, 0x79, 0x19, 0x59, 0xB9, 0xF9, 0x39, 0xF7, 0x39, 0x07,
	0xF9, 0x39, 0xD9, 0xD9, 0x99, 0x17, 0xD9, 0xB9, 0x77, 0xD7, 0x47, 0x77, 0x87, 0x39, 0xF9, 0x77,
	0x19, 0x59, 0xB9, 0x79, 0xB9, 0x19, 0x49, 0xD7, 0xB9, 0x99, 0x19, 0x59, 0x47, 0xF9, 0x37, 0x59,
	0x87, 0x37, 0x49, 0xC9, 0xD7, 0x77, 0xB9, 0x17, 0xD9, 0xD9, 0x17, 0x19, 0x79, 0xB7, 0xB9, 0x39,
	0x39, 0xC9, 0x39, 0x97, 0x39, 0xD9, 0x39, 0xC9, 0x39, 0xF7, 0xF9, 0x17, 0xD9, 0xC9, 0xF9, 0x99,
	0xF9, 0xB7, 0x39, 0x17, 0x37, 0x99, 0xF9, 0x97, 0x27, 0x39, 0x19, 0x99, 0x19, 0x59, 0x39, 0x79,
	0x49, 0x19, 0x39, 0x39, 0x39, 0xD9, 0xB9, 0xF9, 0x0F, 0x1F, 0xDF, 0x17, 0x19, 0xD9, 0x49, 0x49,
	0x79, 0x17, 0x39, 0xD9, 0x79, 0x19, 0x97, 0x27, 0x87, 0x67, 0xB9, 0x79, 0x19, 0x59, 0x19, 0xD9,
	0x59, 0x59, 0x79, 0x99, 0xB9, 0x19, 0x19, 0x39, 0x97, 0x99, 0x3F, 0x17, 0x17, 0x97, 0x3F, 0x39,
	0xF9, 0x99, 0xF9, 0xB7, 0x17, 0x79, 0x39, 0xC9, 0x39, 0xD9, 0x39, 0x99, 0x39, 0x17, 0x39, 0xF9,
	0xB9, 0x19, 0x19, 0x59, 0xD9, 0x19, 0xB7, 0x99, 0xC9, 0xC9, 0xD9, 0xB7, 0x19, 0x79, 0x1F, 0x7F,
	0x79, 0xD9, 0x37, 0x99, 0xF7, 0xF9, 0xB9, 0xF9, 0x39, 0xF7, 0x19, 0x59, 0xB9, 0x99, 0x39, 0x37,
	0x39, 0x39, 0xC9, 0x19, 0xC9, 0x37, 0xF9, 0xD9, 0xE7, 0x4F, 0xD9, 0xF9, 0x9F, 0x19, 0xD9, 0xD9,
	0x19, 0x79, 0x99, 0x19, 0xB9, 0x79, 0x19, 0x59, 0x39, 0xF7, 0x19, 0xB9, 0x39, 0xD9, 0x19, 0x59,
	0x99, 0x37, 0x79, 0xF9, 0x39, 0xF7, 0x39, 0x49, 0x59, 0x99, 0x59, 0xF7, 0xD9, 0x87, 0xB7, 0x39,
	0xF9, 0xB9, 0xB9, 0x19, 0x39, 0xC9, 0x39, 0xF9, 0x39, 0xF7, 0x19, 0x59, 0x39, 0x79, 0x97, 0x1F,
	0xF9, 0x77, 0x39, 0x19, 0x39, 0x99, 0x1F, 0xC9, 0x49, 0xB9, 0xD9, 0xD9, 0xF9, 0xB7, 0x49, 0xF9,
	0x39, 0xF9, 0x19, 0x59, 0x39, 0xB9, 0x39, 0x97, 0x39, 0x37, 0xB9, 0x19, 0xD9, 0x47, 0x67, 0xE7,
	0x37, 0xC9, 0x19, 0x99, 0x27, 0x39, 0x47, 0xF9, 0x87, 0x87, 0x17, 0x37, 0xD9, 0x19, 0x39, 0xC9,
	0x39, 0xF9, 0xB9, 0xF9, 0xB9, 0x49, 0x19, 0x97, 0x19, 0x59, 0x67, 0xE7, 0x47, 0xC9, 0xF9, 0x37,
	0xD9, 0x17, 0x19, 0x99, 0xC9, 0xF9, 0x79, 0x79, 0x39, 0x9F, 0xB7, 0x19, 0x39, 0x99, 0x19, 0xB9,
	0x39, 0xF9, 0xB9, 0x99, 0xB9, 0x79, 0x19, 0x59, 0xC9, 0x47, 0x79, 0x39, 0x7F, 0xFF, 0xF9, 0xB7,
	0x37, 0x79, 0x39, 0xD9, 0xB9, 0x99, 0x47, 0xD9, 0x99, 0x19, 0x39, 0x99, 0x39, 0x37, 0x39, 0x77,
	0x39, 0x77, 0x39, 0xF9, 0x19, 0x59, 0xC9, 0x79, 0xF9, 0xB7, 0x99, 0xD9, 0xC9, 0x17, 0xF9, 0x39,
	0x37, 0xE7, 0xD9, 0xF9, 0x0F, 0x77, 0xC9, 0x39, 0xB9, 0x99, 0x39, 0xF9, 0x19, 0x59, 0xB9, 0x39,
	0x39, 0xD9, 0x39, 0xF7, 0x39, 0xB7, 0x1F, 0x99, 0x19, 0xD9, 0x79, 0x77, 0x99, 0x99, 0xC9, 0x39,
	0x19, 0x99, 0x9F, 0x17, 0xD9, 0x19, 0xB9, 0x79, 0x39, 0xF9, 0xB9, 0x19, 0x19, 0x59, 0x39, 0x79,
	0x39, 0xF9, 0xD9, 0xF9, 0xC9, 0x4F, 0xBF, 0x9F, 0xB9, 0xB9, 0x17, 0x1F, 0xC9, 0x99, 0x19, 0x79,
	0x37, 0x77, 0x77, 0xD9, 0x19, 0x59, 0xB9, 0x99, 0x39, 0xD9, 0xB9, 0x39, 0x39, 0x37, 0x39, 0xC9,
	0x39, 0x3F, 0x37, 0xF9, 0x39, 0x99, 0xC9, 0xC9, 0x17, 0xB7, 0x79, 0x19, 0xC9, 0xB9, 0x7F, 0x37,
	0x39, 0x79, 0xB9, 0x19, 0x19, 0x59, 0x39, 0x39, 0x39, 0xD9, 0x39, 0xC9, 0xB9, 0x19, 0xD9, 0xD9,
	0x19, 0x39, 0x49, 0x19, 0x17, 0x37, 0x77, 0x79, 0x39, 0xD9, 0x39, 0x37, 0xF9, 0xC9, 0xF9, 0x79,
	0x39, 0xF9, 0x19, 0x59, 0x39, 0x79, 0xB9, 0xF9, 0x19, 0x59, 0xB9, 0x39, 0xC9, 0xB9, 0x79, 0x77,
	0xB7, 0x9F, 0xF7, 0x0F, 0x49, 0xF9, 0x39, 0xD9, 0xF9, 0x79, 0xB7, 0x7F, 0xC7, 0xD7, 0x49, 0x19,
	0x39, 0x97, 0x39, 0x37, 0x19, 0xF7, 0x59, 0x59, 0x79, 0xF9, 0xF7, 0x39, 0x7F, 0x49, 0x9F, 0xF9,
	0x39, 0x9F, 0x47, 0x19, 0x59, 0xF9, 0xC9, 0xC9, 0x39, 0x37, 0xF9, 0x39, 0xB9, 0x79, 0x19, 0x59,
	0x39, 0x99, 0x19, 0xB9, 0x39, 0xF9, 0xB9, 0x99, 0x79, 0x9F, 0xE7, 0xD9, 0x19, 0x79, 0x87, 0x87,
	0xC9, 0xF9, 0x39, 0x99, 0xC9, 0x39, 0x39, 0x37, 0xF7, 0x99, 0xB9, 0x79, 0x19, 0x59, 0x39, 0xD9,
	0xB9, 0x39, 0x39, 0xD9, 0x39, 0xF7, 0xC9, 0x37, 0x77, 0x79, 0x39, 0x19, 0xD9, 0x37, 0xF9, 0x77,
	0x39, 0x19, 0x1F, 0x7F, 0xC9, 0x39, 0xF9, 0x37, 0xB9, 0x79, 0x19, 0x59, 0xB9, 0x79, 0x39, 0x37,
	0xB9, 0xF9, 0xB9, 0x79, 0xF9, 0x37, 0x37, 0xD7, 0x9F, 0xF9, 0x5F, 0xE7, 0x9F, 0xC9, 0x39, 0x99,
	0x39, 0x9F, 0x9F, 0x79, 0xF9, 0x19, 0x19, 0x59, 0xB9, 0x59, 0x39, 0xD9, 0xB9, 0x19, 0x39, 0x39,
	0x39, 0xD9, 0xC9, 0x77, 0x9F, 0x07, 0x99, 0x99, 0xC9, 0x37, 0x77, 0x79, 0x39, 0x19, 0xF7, 0x39,
	0x7F, 0x49, 0x9F, 0xF9, 0x39, 0xC9, 0xB9, 0x79, 0x39, 0xF9, 0x39, 0x77, 0x39, 0xF9, 0x39, 0xF7,
	0xD7, 0x79, 0xF9, 0x39, 0x9F, 0xF7, 0x79, 0xF9, 0x0F, 0x39, 0x49, 0xB9, 0xD9, 0x77, 0x39, 0xDF,
	0x07, 0x19, 0xB9, 0x79, 0x19, 0x59, 0x39, 0xC9, 0xB9, 0x19, 0xB9, 0x19, 0x39, 0xF9, 0xD9, 0xB7,
	0x37, 0x39, 0x37, 0x19, 0x39, 0x47, 0xF9, 0x39, 0x39, 0xB7, 0x19, 0xD9, 0xE7, 0x87, 0x07, 0xB7,
	0xB9, 0x99, 0xB9, 0x59, 0x39, 0x37, 0x39, 0xF7, 0xB9, 0x99, 0x39, 0xD9, 0xD9, 0x99, 0x99, 0x79,
	0xF9, 0x39, 0x79, 0xD9, 0x19, 0x79, 0xB9, 0x87, 0xD7, 0x1F, 0x77, 0xF9, 0x79, 0xB9, 0x39, 0x19,
	0x39, 0x97, 0x39, 0xF9, 0x99, 0x79, 0xE7, 0x07, 0xA7, 0x5F, 0xD9, 0x79, 0xF9, 0x39, 0x17, 0x3F,
	0x39, 0x79, 0x5F, 0xFF, 0x27, 0xF9, 0x99, 0x99, 0x47, 0xB7, 0x37, 0x27, 0xF9, 0x79, 0x87, 0x3F,
	0x97, 0x99, 0x47, 0xB7, 0x59, 0x99, 0xB9, 0xD9, 0xC9, 0x49, 0xB7, 0x39, 0x37, 0xD9, 0xF9, 0xB7,
	0x37, 0x37, 0x39, 0xF9
};

const uint8 Game::_protectionPal[] = {
	0x00, 0x00, 0x00, 0x42, 0x00, 0x63, 0x00, 0x00, 0x0F, 0xFF, 0x0F, 0xF0, 0x07, 0x77,	0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const char *Menu::_passwords[8][3] = {
	{ "JAGUAR", "BANTHA", "TOHOLD" },
	{ "COMBEL", "SHIVA",  "PICOLO" },
	{ "ANTIC",  "KASYYK", "FUGU" },
	{ "NOLAN",  "SARLAC", "CAPSUL" },
	{ "ARTHUR", "MAENOC", "ZZZAP" },
	{ "SHIRYU", "SULUST", "MANIAC" },
	{ "RENDER", "NEPTUN", "NO WAY" },
	{ "BELUGA", "BELUGA", "BELUGA" }
};

const uint8 Video::_conradPal1[] = {
	0x00, 0x00, 0xCC, 0x0C, 0x8F, 0x08, 0x7E, 0x07, 0x6C, 0x06, 0x5B, 0x05, 0x4A, 0x04, 0x63, 0x09,
	0x52, 0x07, 0x41, 0x06, 0x30, 0x06, 0x76, 0x0C, 0x14, 0x09, 0x25, 0x0B, 0x88, 0x08, 0xFF, 0x0F
};

const uint8 Video::_conradPal2[] = {
	0x00, 0x00, 0x7C, 0x0B, 0x04, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02, 0x02, 0x01, 0x01, 0x26, 0x0A,
	0x14, 0x08, 0x03, 0x06, 0x02, 0x04, 0x43, 0x09, 0x02, 0x06, 0x02, 0x07, 0x6A, 0x0A, 0xFF, 0x0F
};

const uint8 Video::_textPal[] = {
	0x00, 0x00, 0x11, 0x01, 0x22, 0x02, 0xEF, 0x0E, 0x00, 0x0F, 0xF0, 0x0F, 0xA0, 0x0E, 0xB0, 0x0F,
	0xA0, 0x0E, 0xA0, 0x0E, 0xAA, 0x0A, 0xF0, 0x00, 0xCC, 0x0C, 0xDF, 0x0D, 0xEE, 0x0E, 0xEE, 0x0E
};

const uint8 Video::_palSlot0xF[] = {
	0x00, 0x00, 0x00, 0x1F, 0x17, 0x2B, 0x2B, 0x1F, 0x37, 0x37, 0x2B, 0x47, 0x43, 0x37, 0x53, 0x4F,
	0x43, 0x63, 0x5F, 0x53, 0x6F, 0x6F, 0x63, 0x7F, 0x7F, 0x73, 0x8B, 0x8F, 0x87, 0x9B, 0x9F, 0x97,
	0xA7, 0xAF, 0xA7, 0xB3, 0xBF, 0xBB, 0xBF, 0xCF, 0xCF, 0xCF, 0x00, 0x33, 0x00, 0x17, 0x0F, 0x1F
};

const int8 ModPlayer::_sineWaveTable[] = {
   0,   24,   49,   74,   97,  120, -115,  -95,  -76,  -59,  -44,  -32,  -21,  -12,   -6,   -3,
  -1,   -3,   -6,  -12,  -21,  -32,  -44,  -59,  -76,  -95, -115,  120,   97,   74,   49,   24,
   0,  -24,  -49,  -74,  -97, -120,  115,   95,   76,   59,   44,   32,   21,   12,    6,    3,
   1,    3,    6,   12,   21,   32,   44,   59,   76,   95,  115, -120,  -97,  -74,  -49,  -24
};

const uint16 ModPlayer::_periodTable[] = {
	856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453, // C-1 to B-1 Finetune 0
	428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226, // C-2 to B-2 Finetune 0
	214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113, // C-3 to B-3 Finetune 0
	850, 802, 757, 715, 674, 637, 601, 567, 535, 505, 477, 450, // C-1 to B-1 Finetune +1
	425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 239, 225, // C-2 to B-2 Finetune +1
	213, 201, 189, 179, 169, 159, 150, 142, 134, 126, 119, 113, // C-3 to B-3 Finetune +1
	844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474, 447, // C-1 to B-1 Finetune +2
	422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237, 224, // C-2 to B-2 Finetune +2
	211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118, 112, // C-3 to B-3 Finetune +2
	838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470, 444, // C-1 to B-1 Finetune +3
	419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235, 222, // C-2 to B-2 Finetune +3
	209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118, 111, // C-3 to B-3 Finetune +3
	832, 785, 741, 699, 660, 623, 588, 555, 524, 495, 467, 441, // C-1 to B-1 Finetune +4
	416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233, 220, // C-2 to B-2 Finetune +4
	208, 196, 185, 175, 165, 156, 147, 139, 131, 124, 117, 110, // C-3 to B-3 Finetune +4
	826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463, 437, // C-1 to B-1 Finetune +5
	413, 390, 368, 347, 328, 309, 292, 276, 260, 245, 232, 219, // C-2 to B-2 Finetune +5
	206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116, 109, // C-3 to B-3 Finetune +5
	820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460, 434, // C-1 to B-1 Finetune +6
	410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230, 217, // C-2 to B-2 Finetune +6
	205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115, 109, // C-3 to B-3 Finetune +6
	814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457, 431, // C-1 to B-1 Finetune +7
	407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228, 216, // C-2 to B-2 Finetune +7
	204, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114, 108, // C-3 to B-3 Finetune +7
	907, 856, 808, 762, 720, 678, 640, 604, 570, 538, 504, 480, // C-1 to B-1 Finetune -8
	453, 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, // C-2 to B-2 Finetune -8
	226, 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, // C-3 to B-3 Finetune -8
	900, 850, 802, 757, 715, 675, 636, 601, 567, 535, 505, 477, // C-1 to B-1 Finetune -7
	450, 425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 238, // C-2 to B-2 Finetune -7
	225, 212, 200, 189, 179, 169, 159, 150, 142, 134, 126, 119, // C-3 to B-3 Finetune -7
	894, 844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474, // C-1 to B-1 Finetune -6
	447, 422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237, // C-2 to B-2 Finetune -6
	223, 211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118, // C-3 to B-3 Finetune -6
	887, 838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470, // C-1 to B-1 Finetune -5
	444, 419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235, // C-2 to B-2 Finetune -5
	222, 209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118, // C-3 to B-3 Finetune -5
	881, 832, 785, 741, 699, 660, 623, 588, 555, 524, 494, 467, // C-1 to B-1 Finetune -4
	441, 416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233, // C-2 to B-2 Finetune -4
	220, 208, 196, 185, 175, 165, 156, 147, 139, 131, 123, 117, // C-3 to B-3 Finetune -4
	875, 826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463, // C-1 to B-1 Finetune -3
	437, 413, 390, 368, 347, 338, 309, 292, 276, 260, 245, 232, // C-2 to B-2 Finetune -3
	219, 206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116, // C-3 to B-3 Finetune -3
	868, 820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460, // C-1 to B-1 Finetune -2
	434, 410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230, // C-2 to B-2 Finetune -2
	217, 205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115, // C-3 to B-3 Finetune -2
	862, 814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457, // C-1 to B-1 Finetune -1
	431, 407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228, // C-2 to B-2 Finetune -1
	216, 203, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114  // C-3 to B-3 Finetune -1
};

const char *ModPlayer::_modulesFiles[][2] = {
	{ "intro",       "mod.flashback-introb"    }, // introl3
	{ "options",     "mod.flashback-options2"  }, // option3
	{ "journal",     "mod.flashback-options1"  }, // journal3
	{ "ceinture",    "mod.flashback-ceinturea" }, // chute3
	{ "desinteg",    "mod.flashback-desintegr" }, // desinte3
	{ "reunion",     "mod.flashback-reunion"   }, // capture3
	{ "voyage",      "mod.flashback-voyage"    }, // voyage3
	{ "level4",      "mod.flashback-teleporta" }, // telepor3
	{ "planetexplo", "mod.flashback-teleport2" }, // planexp3
	{ "fin",         "mod.flashback-fin"       }, // end31
	{ "ascenseur",   "mod.flashback-ascenseur" }, // lift3
	{ "logo",        "mod.flashback-logo"      }, // present3
	{ "game_over",   "mod.flashback-game_over" }, // gameove3
	{ "holocube",    "mod.flashback-holocube"  }, // holo3
	{ "memoire",     "mod.flashback-memoire"   }, // memory3
	{ "chute",       "mod.flashback-chute"     }, // chutevi3
	{ "debut",       "mod.flashback-jungle"    }, // reveil3
	{ "missions",    "mod.flashback-missionca" }, // misvali3
	{ "taxi",        "mod.flashback-taxi"      }, // taxi3
	{ "donneobj",    "mod.flashback-donneobjt" }, // donner3
	{ "missions2",   "mod.flashback-fin2"      }  // mission3
//	{ 0,             0,                        }, // objet3
//	{ 0,             0,                        }, // recharg3
//	{ 0,             0,                        }, // generat3
//	{ 0,             0,                        }, // pont3
//	{ 0,             0,                        }  // rechage3
};

const int ModPlayer::_modulesFilesCount = ARRAYSIZE(_modulesFiles);

const uint8 SfxPlayer::_musicData68[] = {
	0x00, 0x1B, 0x00, 0x07, 0x00, 0x0C, 0x00, 0x18, 0xFF, 0xF4, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0A,
	0x02, 0x01, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x0A, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x0D, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x14, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x16, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x0F
};

const uint8 SfxPlayer::_musicData70[] = {
	0x00, 0x12, 0x00, 0x07, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0A, 0x02, 0x01, 0x00, 0x00, 0x01, 0x0D,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0A, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x03, 0x16, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00
};

const uint8 SfxPlayer::_musicData72[] = {
	0x00, 0x4F, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x24, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x05, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x05,
	0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1B,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0D, 0x00, 0x00,
	0x04, 0x1D, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0F, 0x02, 0x01, 0x04, 0x1D, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x11, 0x02, 0x01, 0x04, 0x1B,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x10, 0x02, 0x01, 0x04, 0x1B, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1B,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x10, 0x03, 0x01,
	0x04, 0x1D, 0x01, 0x0F, 0x03, 0x01, 0x04, 0x1B, 0x01, 0x0D, 0x02, 0x01, 0x04, 0x1D, 0x01, 0x0F,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0D, 0x02, 0x01, 0x04, 0x1D, 0x01, 0x0A, 0x03, 0x01, 0x04, 0x1B,
	0x01, 0x08, 0x03, 0x01, 0x04, 0x1D, 0x01, 0x08, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00,
	0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x02, 0x01,
	0x04, 0x1D, 0x00, 0x00, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x0D, 0x00, 0x00, 0x04, 0x1B,
	0x01, 0x0F, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00,
	0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x02, 0x01,
	0x04, 0x1D, 0x00, 0x00, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x03, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x05, 0x00, 0x00, 0x04, 0x1B,
	0x01, 0x08, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00,
	0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x00, 0x00,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x1D, 0x01, 0x08, 0x00, 0x00, 0x04, 0x1B, 0x01, 0x0A, 0x02, 0x01,
	0x04, 0x1D, 0x00, 0x00, 0x02, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x1D, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x1B, 0x01, 0x0A, 0x03, 0x01, 0x04, 0x1D, 0x01, 0x0D, 0x03, 0x01, 0x04, 0x1B,
	0x01, 0x0F, 0x03, 0x01, 0x04, 0x1D, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x1B
};

const uint8 SfxPlayer::_musicData73[] = {
	0x00, 0x41, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x0C, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x05, 0x00, 0x00,
	0x04, 0x11, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x05, 0x00, 0x00,
	0x04, 0x11, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x0D, 0x00, 0x00,
	0x04, 0x11, 0x00, 0x00, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0F, 0x02, 0x01, 0x04, 0x11, 0x01, 0x0C,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0D, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x05, 0x02, 0x01, 0x04, 0x12, 0x01, 0x08, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x0D, 0x00, 0x00,
	0x04, 0x11, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x05, 0x00, 0x00,
	0x04, 0x11, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x05, 0x00, 0x00,
	0x04, 0x11, 0x01, 0x08, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11, 0x01, 0x08,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x0A, 0x02, 0x01, 0x04, 0x12, 0x00, 0x00, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x0D, 0x00, 0x00,
	0x04, 0x11, 0x00, 0x00, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0F, 0x02, 0x01, 0x04, 0x11, 0x01, 0x0C,
	0x03, 0x01, 0x04, 0x12, 0x01, 0x0D, 0x02, 0x01, 0x04, 0x0A, 0x01, 0x0A, 0x00, 0x00, 0x04, 0x11,
	0x01, 0x05, 0x02, 0x01, 0x04, 0x12, 0x01, 0x08, 0x03, 0x01, 0x04, 0x0A, 0x01, 0x0D, 0x03, 0x01,
	0x04, 0x11, 0x01, 0x0A, 0x02, 0x01, 0x04, 0x0A
};

const uint8 SfxPlayer::_musicData74[] = {
	0x00, 0x41, 0x00, 0x07, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x24, 0x00, 0x0C, 0x00, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x0B, 0x02, 0x01, 0x00, 0x00,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0B, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x08, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x08,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27,
	0x04, 0x08, 0x01, 0x06, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x0B, 0x02, 0x01, 0x00, 0x00,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00, 0x01, 0x0B, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x08, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x08,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27,
	0x04, 0x08, 0x01, 0x06, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x0B, 0x02, 0x01, 0x00, 0x00,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00, 0x01, 0x0B, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x08, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x08,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27,
	0x04, 0x08, 0x01, 0x06, 0x02, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08,
	0x03, 0x01, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00,
	0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x0B, 0x03, 0x01, 0x00, 0x00, 0x01, 0x0D, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00
};

const uint8 SfxPlayer::_musicData75[] = {
	0x00, 0x41, 0x00, 0x05, 0x00, 0x0C, 0x00, 0x24, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x04, 0x12,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x12, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x04, 0x12,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x04, 0x12, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x06, 0x03, 0x01, 0x04, 0x11,
	0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x05, 0x27, 0x04, 0x12, 0x01, 0x06, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x04, 0x12,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x12, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x04, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x03, 0x01, 0x04, 0x12,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x04, 0x14, 0x01, 0x08, 0x05, 0x27,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08,
	0x05, 0x27, 0x00, 0x00, 0x01, 0x08, 0x05, 0x27, 0x00, 0x00, 0x01, 0x06, 0x03, 0x01, 0x00, 0x00,
	0x01, 0x06, 0x03, 0x01, 0x00, 0x00, 0x01, 0x05, 0x03, 0x01, 0x00, 0x00, 0x01, 0x06, 0x03, 0x01,
	0x00, 0x00, 0x01, 0x08, 0x02, 0x01, 0x00, 0x00
};

const uint8 SfxPlayer::_musicDataSample1[] = {
	0x08, 0x2C, 0x00, 0x40, 0x07, 0x2A, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04,
	0x03, 0x05, 0x07, 0x08, 0x08, 0x0B, 0x0E, 0x0F, 0x11, 0x14, 0x14, 0x16, 0x18, 0x1C, 0x20, 0x1E,
	0x1A, 0x1A, 0x1F, 0x22, 0x1F, 0x19, 0x16, 0x27, 0x1C, 0xC8, 0x0F, 0x7F, 0x30, 0xA0, 0x97, 0x0F,
	0x73, 0x50, 0xC4, 0x96, 0xE7, 0x15, 0xFC, 0xFD, 0x12, 0x0C, 0xE6, 0xEF, 0x0F, 0xF8, 0xE3, 0xFF,
	0x47, 0x4E, 0x08, 0xD2, 0xEA, 0x27, 0x3B, 0x22, 0x09, 0x03, 0xFF, 0xF2, 0xF3, 0x03, 0x00, 0xEA,
	0xDE, 0xD4, 0xC7, 0xC2, 0xBC, 0xB4, 0xB6, 0xB8, 0xA8, 0x96, 0x95, 0x99, 0x9C, 0x9F, 0xA0, 0xA0,
	0xA3, 0xA4, 0xA4, 0xB3, 0xCB, 0xD7, 0xDB, 0xDF, 0xEA, 0xFD, 0x0F, 0x1C, 0x26, 0x37, 0x4B, 0x57,
	0x5F, 0x6A, 0x73, 0x78, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x78, 0x6C, 0x64, 0x5E, 0x58, 0x4B, 0x40, 0x3A, 0x2E, 0x1E, 0x16, 0x11, 0x0B, 0x06, 0xFE,
	0xF3, 0xE9, 0xE2, 0xDD, 0xDE, 0xE3, 0xE0, 0xD7, 0xCE, 0xCC, 0xCE, 0xD3, 0xD4, 0xCF, 0xCB, 0xCF,
	0xD2, 0xCF, 0xCD, 0xCF, 0xD1, 0xD6, 0xD9, 0xD3, 0xCD, 0xD3, 0xDE, 0xDF, 0xDA, 0xD8, 0xD9, 0xDF,
	0xE5, 0xE4, 0xDE, 0xDF, 0xE4, 0xEA, 0xED, 0xEE, 0xF2, 0xF4, 0xF7, 0xF5, 0xF5, 0xFE, 0x0B, 0x0C,
	0x0B, 0x0F, 0x13, 0x13, 0x11, 0x13, 0x1B, 0x26, 0x23, 0x1B, 0x1D, 0x1C, 0x1E, 0x20, 0x1E, 0x1F,
	0x1E, 0x15, 0x17, 0x20, 0x10, 0x07, 0x15, 0x14, 0x0B, 0x0B, 0x08, 0x04, 0x07, 0x04, 0xFA, 0xFB,
	0xFE, 0xFB, 0xFB, 0xFB, 0xF6, 0xF1, 0xF4, 0xF9, 0xFC, 0x00, 0x01, 0xFE, 0xF8, 0xF7, 0xFB, 0x03,
	0x0C, 0x11, 0x0F, 0x08, 0xFE, 0xFE, 0x0B, 0x1B, 0x1E, 0x11, 0x04, 0x04, 0x09, 0x0C, 0x0D, 0x08,
	0x08, 0x0C, 0x09, 0x00, 0xF4, 0xF2, 0xFB, 0x03, 0x02, 0xFA, 0xF6, 0xF5, 0xF4, 0xF6, 0xF9, 0xFA,
	0xF9, 0xFD, 0x01, 0x02, 0x01, 0xFE, 0x01, 0x0C, 0x10, 0x0D, 0x0A, 0x08, 0x0B, 0x14, 0x19, 0x1A,
	0x1B, 0x19, 0x15, 0x17, 0x18, 0x15, 0x17, 0x1E, 0x1C, 0x16, 0x11, 0x11, 0x14, 0x19, 0x19, 0x17,
	0x15, 0x13, 0x15, 0x1A, 0x1C, 0x1E, 0x23, 0x28, 0x28, 0x24, 0x23, 0x28, 0x2D, 0x2F, 0x2E, 0x2E,
	0x2C, 0x28, 0x24, 0x20, 0x1C, 0x16, 0x0B, 0x02, 0xFF, 0xF9, 0xEB, 0xE0, 0xD6, 0xCC, 0xC3, 0xBA,
	0xB0, 0xA6, 0xA0, 0x99, 0x92, 0x8C, 0x88, 0x88, 0x88, 0x85, 0x83, 0x85, 0x89, 0x8C, 0x91, 0x9A,
	0xA2, 0xAB, 0xB2, 0xBB, 0xC7, 0xD6, 0xE3, 0xF1, 0xFF, 0x0C, 0x17, 0x23, 0x2D, 0x39, 0x45, 0x50,
	0x5A, 0x63, 0x67, 0x6A, 0x6E, 0x72, 0x76, 0x7A, 0x7A, 0x76, 0x73, 0x72, 0x6E, 0x6B, 0x6A, 0x66,
	0x61, 0x5D, 0x53, 0x4B, 0x48, 0x45, 0x40, 0x3C, 0x3A, 0x33, 0x2D, 0x2A, 0x24, 0x20, 0x20, 0x20,
	0x1C, 0x1B, 0x1A, 0x16, 0x13, 0x12, 0x11, 0x12, 0x12, 0x10, 0x0D, 0x0B, 0x0B, 0x09, 0x07, 0x07,
	0x06, 0x05, 0x04, 0x02, 0x01, 0xFE, 0xFC, 0xFC, 0xFF, 0x00, 0xFE, 0xFB, 0xFA, 0xFA, 0xFC, 0xFD,
	0xFC, 0xFD, 0x01, 0x02, 0x00, 0x00, 0x04, 0x08, 0x0C, 0x0E, 0x0D, 0x10, 0x13, 0x16, 0x19, 0x1B,
	0x1D, 0x1E, 0x21, 0x23, 0x23, 0x23, 0x24, 0x26, 0x28, 0x26, 0x23, 0x21, 0x21, 0x23, 0x23, 0x1F,
	0x1C, 0x1C, 0x1B, 0x1A, 0x18, 0x16, 0x15, 0x14, 0x13, 0x11, 0x0F, 0x0E, 0x0C, 0x0A, 0x08, 0x03,
	0xFD, 0xFA, 0xFA, 0xF9, 0xF6, 0xF3, 0xF1, 0xEF, 0xEF, 0xEF, 0xF0, 0xF3, 0xF4, 0xF2, 0xF4, 0xF9,
	0xFD, 0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x08, 0x05, 0x01, 0xFD, 0xF9, 0xF5, 0xF1,
	0xED, 0xE6, 0xDE, 0xD9, 0xD7, 0xD5, 0xD3, 0xD0, 0xCD, 0xCB, 0xCA, 0xC8, 0xC8, 0xCB, 0xCC, 0xCE,
	0xD1, 0xD4, 0xD4, 0xD6, 0xDD, 0xE4, 0xE9, 0xEB, 0xEC, 0xEF, 0xF6, 0xFC, 0xFD, 0xFB, 0xFB, 0xFC,
	0xFC, 0xFC, 0xF9, 0xF6, 0xF5, 0xF3, 0xEE, 0xEB, 0xE9, 0xE7, 0xE7, 0xE7, 0xE6, 0xE5, 0xE5, 0xE6,
	0xEA, 0xEE, 0xF2, 0xF6, 0xFA, 0xFE, 0x03, 0x0A, 0x10, 0x15, 0x1A, 0x1D, 0x20, 0x23, 0x25, 0x25,
	0x26, 0x26, 0x24, 0x20, 0x1A, 0x15, 0x0F, 0x09, 0x02, 0xF8, 0xEE, 0xE4, 0xD9, 0xCF, 0xC8, 0xC1,
	0xB8, 0xAF, 0xA7, 0xA0, 0x9A, 0x97, 0x94, 0x92, 0x92, 0x92, 0x94, 0x97, 0x99, 0x9D, 0xA5, 0xAD,
	0xB6, 0xBF, 0xC7, 0xD1, 0xDC, 0xE7, 0xF3, 0xFF, 0x0B, 0x16, 0x1F, 0x29, 0x33, 0x3B, 0x44, 0x4D,
	0x55, 0x5A, 0x5E, 0x62, 0x64, 0x66, 0x67, 0x68, 0x68, 0x68, 0x66, 0x63, 0x60, 0x5D, 0x5B, 0x59,
	0x56, 0x52, 0x4F, 0x4B, 0x48, 0x46, 0x44, 0x42, 0x40, 0x3F, 0x3E, 0x3D, 0x3A, 0x39, 0x39, 0x3A,
	0x39, 0x37, 0x36, 0x35, 0x35, 0x35, 0x35, 0x34, 0x32, 0x31, 0x30, 0x2E, 0x2D, 0x2B, 0x2A, 0x29,
	0x27, 0x26, 0x25, 0x24, 0x22, 0x21, 0x20, 0x20, 0x1F, 0x1D, 0x1D, 0x1F, 0x20, 0x1F, 0x1F, 0x1F,
	0x20, 0x23, 0x25, 0x26, 0x26, 0x29, 0x2B, 0x2C, 0x2D, 0x2E, 0x30, 0x32, 0x33, 0x34, 0x34, 0x35,
	0x35, 0x35, 0x36, 0x36, 0x35, 0x34, 0x33, 0x33, 0x32, 0x31, 0x30, 0x2F, 0x2E, 0x2B, 0x29, 0x29,
	0x29, 0x28, 0x27, 0x27, 0x27, 0x26, 0x26, 0x26, 0x28, 0x28, 0x28, 0x27, 0x27, 0x26, 0x24, 0x22,
	0x20, 0x1D, 0x1A, 0x15, 0x0F, 0x0A, 0x05, 0x01, 0xFE, 0xFA, 0xF5, 0xF2, 0xF0, 0xED, 0xEC, 0xEB,
	0xEA, 0xE9, 0xE9, 0xE9, 0xEA, 0xEB, 0xEB, 0xEB, 0xEB, 0xEA, 0xE9, 0xE6, 0xE3, 0xE1, 0xDC, 0xD8,
	0xD4, 0xCE, 0xC8, 0xC3, 0xBF, 0xBA, 0xB6, 0xB1, 0xAE, 0xAB, 0xAA, 0xA8, 0xA7, 0xA6, 0xA6, 0xA7,
	0xA9, 0xAB, 0xAE, 0xAF, 0xB1, 0xB3, 0xB8, 0xBC, 0xC0, 0xC3, 0xC5, 0xC7, 0xCA, 0xCD, 0xCE, 0xCF,
	0xD0, 0xD2, 0xD3, 0xD2, 0xD1, 0xCF, 0xD0, 0xD0, 0xD0, 0xCF, 0xCF, 0xCF, 0xCF, 0xD1, 0xD3, 0xD5,
	0xD8, 0xDB, 0xDF, 0xE3, 0xE7, 0xEB, 0xF0, 0xF6, 0xFB, 0xFF, 0x03, 0x08, 0x0C, 0x0E, 0x11, 0x12,
	0x13, 0x14, 0x13, 0x11, 0x0E, 0x0A, 0x05, 0x00, 0xFA, 0xF4, 0xED, 0xE5, 0xDE, 0xD6, 0xCE, 0xC6,
	0xC0, 0xBA, 0xB4, 0xAF, 0xAA, 0xA7, 0xA5, 0xA4, 0xA4, 0xA4, 0xA6, 0xA9, 0xAE, 0xB3, 0xB8, 0xBF,
	0xC7, 0xCF, 0xD7, 0xDF, 0xE9, 0xF4, 0xFE, 0x08, 0x11, 0x1B, 0x24, 0x2D, 0x35, 0x3D, 0x45, 0x4B,
	0x50, 0x55, 0x58, 0x5B, 0x5E, 0x60, 0x60, 0x60, 0x5F, 0x5E, 0x5D, 0x5B, 0x59, 0x58, 0x57, 0x54,
	0x52, 0x4F, 0x4E, 0x4D, 0x4C, 0x4A, 0x48, 0x47, 0x46, 0x46, 0x46, 0x46, 0x46, 0x45, 0x44, 0x44,
	0x44, 0x45, 0x44, 0x44, 0x43, 0x43, 0x43, 0x43, 0x42, 0x41, 0x41, 0x40, 0x3F, 0x3D, 0x3C, 0x3C,
	0x3B, 0x3A, 0x39, 0x38, 0x36, 0x36, 0x35, 0x34, 0x34, 0x34, 0x33, 0x32, 0x32, 0x33, 0x34, 0x35,
	0x34, 0x34, 0x34, 0x36, 0x36, 0x36, 0x36, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x36, 0x34,
	0x35, 0x34, 0x33, 0x32, 0x32, 0x32, 0x32, 0x31, 0x30, 0x30, 0x30, 0x2F, 0x2F, 0x30, 0x30, 0x30,
	0x31, 0x31, 0x32, 0x32, 0x33, 0x34, 0x35, 0x36, 0x36, 0x36, 0x37, 0x38, 0x38, 0x38, 0x37, 0x35,
	0x32, 0x2F, 0x2D, 0x29, 0x24, 0x20, 0x1A, 0x14, 0x0E, 0x08, 0x03, 0xFE, 0xF8, 0xF3, 0xEE, 0xEA,
	0xE6, 0xE2, 0xE0, 0xDE, 0xDB, 0xD9, 0xD8, 0xD6, 0xD5, 0xD3, 0xD1, 0xD0, 0xCD, 0xCA, 0xC7, 0xC4,
	0xC1, 0xBD, 0xBA, 0xB6, 0xB3, 0xB0, 0xAC, 0xA9, 0xA7, 0xA5, 0xA3, 0xA1, 0xA0, 0xA0, 0xA0, 0xA0,
	0xA1, 0xA1, 0xA2, 0xA2, 0xA4, 0xA6, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAC, 0xAD, 0xAE,
	0xAF, 0xB0, 0xB1, 0xB2, 0xB3, 0xB5, 0xB7, 0xB9, 0xBB, 0xBE, 0xC0, 0xC4, 0xC8, 0xCC, 0xD1, 0xD5,
	0xDA, 0xDF, 0xE5, 0xEA, 0xEF, 0xF5, 0xFA, 0xFF, 0x04, 0x08, 0x0B, 0x0D, 0x10, 0x12, 0x12, 0x11,
	0x10, 0x0E, 0x0B, 0x08, 0x03, 0xFE, 0xF8, 0xF1, 0xEB, 0xE4, 0xDD, 0xD6, 0xD0, 0xC9, 0xC3, 0xBD,
	0xB8, 0xB4, 0xB1, 0xAE, 0xAC, 0xAB, 0xAA, 0xAB, 0xAD, 0xB0, 0xB3, 0xB8, 0xBD, 0xC3, 0xCA, 0xD2,
	0xD9, 0xE1, 0xE9, 0xF2, 0xFA, 0x02, 0x0B, 0x13, 0x1C, 0x23, 0x2A, 0x31, 0x36, 0x3B, 0x40, 0x45,
	0x48, 0x4B, 0x4D, 0x4F, 0x50, 0x50, 0x50, 0x50, 0x50, 0x4F, 0x4E, 0x4C, 0x4C, 0x4B, 0x4B, 0x4A,
	0x49, 0x49, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x49, 0x48, 0x49, 0x49, 0x4A, 0x4B, 0x4B, 0x4B,
	0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4A, 0x4A, 0x49, 0x48, 0x47, 0x46, 0x44, 0x44, 0x43, 0x41,
	0x40, 0x3F, 0x3E, 0x3D, 0x3C, 0x3B, 0x3B, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x39, 0x3A, 0x3B, 0x3C,
	0x3C, 0x3C, 0x3C, 0x3D, 0x3E, 0x3E, 0x3E, 0x3F, 0x3F, 0x3E, 0x3E, 0x3E, 0x3E, 0x3D, 0x3D, 0x3C,
	0x3B, 0x39, 0x38, 0x38, 0x37, 0x36, 0x34, 0x33, 0x32, 0x32, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x31, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3A, 0x3B,
	0x3A, 0x3A, 0x38, 0x37, 0x34, 0x31, 0x2E, 0x2B, 0x27, 0x22, 0x1D, 0x18, 0x13, 0x0D, 0x08, 0x01,
	0xFC, 0xF7, 0xF2, 0xED, 0xE9, 0xE4, 0xE0, 0xDC, 0xD8, 0xD4, 0xD0, 0xCB, 0xC7, 0xC3, 0xBF, 0xBA,
	0xB6, 0xB2, 0xAF, 0xAB, 0xA8, 0xA5, 0xA3, 0xA0, 0x9F, 0x9E, 0x9D, 0x9D, 0x9D, 0x9C, 0x9D, 0x9D,
	0x9E, 0x9E, 0x9F, 0x9F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA1, 0xA1, 0xA1, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2,
	0xA3, 0xA5, 0xA5, 0xA7, 0xA8, 0xAB, 0xAD, 0xB0, 0xB2, 0xB6, 0xBA, 0xBF, 0xC3, 0xC8, 0xCE, 0xD3,
	0xD9, 0xDF, 0xE5, 0xEB, 0xF1, 0xF6, 0xFB, 0x00, 0x04, 0x08, 0x0B, 0x0D, 0x0E, 0x0E, 0x0E, 0x0C,
	0x0A, 0x08, 0x04, 0x00, 0xFA, 0xF5, 0xEF, 0xE8, 0xE2, 0xDC, 0xD6, 0xCF, 0xC9, 0xC3, 0xBE, 0xBA,
	0xB6, 0xB3, 0xB0, 0xAE, 0xAD, 0xAE, 0xAF, 0xB0, 0xB3, 0xB7, 0xBB, 0xBF, 0xC5, 0xCB, 0xD2, 0xD9,
	0xE1, 0xE8, 0xF0, 0xF9, 0x01, 0x09, 0x11, 0x18, 0x1F, 0x26, 0x2D, 0x32, 0x37, 0x3C, 0x40, 0x43,
	0x46, 0x48, 0x49, 0x4A, 0x4B, 0x4B, 0x4B, 0x4A, 0x4A, 0x49, 0x48, 0x47, 0x47, 0x46, 0x46, 0x45,
	0x45, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x45, 0x45, 0x46, 0x47, 0x47, 0x47, 0x48, 0x49,
	0x49, 0x49, 0x49, 0x4A, 0x49, 0x49, 0x49, 0x48, 0x48, 0x47, 0x46, 0x45, 0x45, 0x44, 0x43, 0x42,
	0x41, 0x41, 0x40, 0x40, 0x3F, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3F, 0x3F, 0x3F, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x3F, 0x3F, 0x3E, 0x3E, 0x3D, 0x3C, 0x3B, 0x3A, 0x39,
	0x38, 0x37, 0x36, 0x35, 0x34, 0x33, 0x32, 0x31, 0x31, 0x30, 0x30, 0x30, 0x2F, 0x2F, 0x30, 0x30,
	0x30, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x3A, 0x3B, 0x3D, 0x3D, 0x3E, 0x3F,
	0x3F, 0x3F, 0x3E, 0x3E, 0x3C, 0x3B, 0x38, 0x36, 0x33, 0x30, 0x2B, 0x27, 0x22, 0x1E, 0x19, 0x14,
	0x0E, 0x09, 0x04, 0xFE, 0xF8, 0xF3, 0xED, 0xE8, 0xE2, 0xDC, 0xD6, 0xD1, 0xCB, 0xC6, 0xC0, 0xBC,
	0xB7, 0xB2, 0xAE, 0xAB, 0xA8, 0xA5, 0xA2, 0xA0, 0x9F, 0x9E, 0x9C, 0x9B, 0x9B, 0x9A, 0x9A, 0x99,
	0x99, 0x99, 0x98, 0x98, 0x97, 0x97, 0x96, 0x95, 0x95, 0x95, 0x94, 0x94, 0x94, 0x94, 0x94, 0x95,
	0x96, 0x97, 0x99, 0x9B, 0x9E, 0xA0, 0xA4, 0xA8, 0xAD, 0xB2, 0xB7, 0xBD, 0xC3, 0xCA, 0xD1, 0xD7,
	0xDF, 0xE5, 0xEC, 0xF3, 0xF9, 0xFF, 0x04, 0x09, 0x0C, 0x0F, 0x11, 0x12, 0x12, 0x11, 0x10, 0x0D,
	0x09, 0x05, 0x00, 0xFB, 0xF5, 0xEF, 0xE9, 0xE2, 0xDC, 0xD6, 0xD0, 0xC9, 0xC4, 0xBF, 0xBB, 0xB7,
	0xB4, 0xB1, 0xB0, 0xAF, 0xAF, 0xAF, 0xB1, 0xB4, 0xB7, 0xBB, 0xBF, 0xC5, 0xCA, 0xD1, 0xD7, 0xDE,
	0xE5, 0xED, 0xF4, 0xFC, 0x03, 0x0B, 0x12, 0x19, 0x1F, 0x24, 0x29, 0x2E, 0x33, 0x36, 0x39, 0x3C,
	0x3E, 0x40, 0x41, 0x42, 0x42, 0x43, 0x43, 0x43, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x41, 0x41,
	0x41, 0x41, 0x41, 0x42, 0x42, 0x43, 0x43, 0x44, 0x44, 0x44, 0x45, 0x46, 0x47, 0x47, 0x47, 0x48,
	0x48, 0x48, 0x48, 0x48, 0x48, 0x47, 0x47, 0x46, 0x46, 0x45, 0x44, 0x43, 0x43, 0x42, 0x41, 0x40,
	0x40, 0x3F, 0x3F, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3F, 0x3F, 0x3F, 0x3F, 0x40, 0x40, 0x41, 0x41,
	0x41, 0x41, 0x41, 0x41, 0x41, 0x40, 0x40, 0x40, 0x3F, 0x3E, 0x3D, 0x3C, 0x3B, 0x3A, 0x39, 0x38,
	0x37, 0x35, 0x34, 0x33, 0x32, 0x31, 0x30, 0x30, 0x2F, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
	0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x35, 0x36, 0x37, 0x39, 0x3A, 0x3C, 0x3D, 0x3E, 0x3F, 0x40,
	0x41, 0x42, 0x42, 0x42, 0x41, 0x40, 0x3F, 0x3E, 0x3C, 0x39, 0x37, 0x34, 0x31, 0x2D, 0x29, 0x24,
	0x20, 0x1B, 0x16, 0x10, 0x0A, 0x05, 0xFE, 0xF8, 0xF2, 0xEC, 0xE6, 0xE0, 0xDA, 0xD4, 0xCE, 0xC9,
	0xC4, 0xBF, 0xBB, 0xB7, 0xB3, 0xB0, 0xAD, 0xAA, 0xA8, 0xA6, 0xA4, 0xA2, 0xA0, 0x9F, 0x9D, 0x9B,
	0x9A, 0x98, 0x96, 0x95, 0x93, 0x91, 0x8F, 0x8E, 0x8C, 0x8B, 0x89, 0x88, 0x88, 0x87, 0x87, 0x87,
	0x88, 0x89, 0x8A, 0x8C, 0x8F, 0x92, 0x96, 0x9B, 0xA0, 0xA6, 0xAC, 0xB3, 0xB9, 0xC1, 0xC8, 0xD0,
	0xD8, 0xDF, 0xE7, 0xEE, 0xF5, 0xFB, 0xFF, 0x04, 0x08, 0x0B, 0x0D, 0x0E, 0x0E, 0x0E, 0x0C, 0x09,
	0x06, 0x03, 0xFE, 0xFA, 0xF4, 0xEF, 0xE9, 0xE3, 0xDD, 0xD8, 0xD2, 0xCD, 0xC8, 0xC4, 0xC0, 0xBC,
	0xBA, 0xB8, 0xB7, 0xB6, 0xB6, 0xB7, 0xB9, 0xBC, 0xBF, 0xC2, 0xC7, 0xCB, 0xD0, 0xD6, 0xDC, 0xE2,
	0xE8, 0xEF, 0xF5, 0xFB, 0x01, 0x07, 0x0D, 0x12, 0x17, 0x1B, 0x1F, 0x23, 0x27, 0x29, 0x2C, 0x2E,
	0x30, 0x32, 0x33, 0x34, 0x35, 0x36, 0x36, 0x37, 0x38, 0x38, 0x39, 0x39, 0x3A, 0x3B, 0x3B, 0x3C,
	0x3C, 0x3D, 0x3E, 0x3F, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x47, 0x48, 0x48, 0x49,
	0x49, 0x49, 0x49, 0x49, 0x48, 0x48, 0x47, 0x46, 0x46, 0x45, 0x44, 0x44, 0x43, 0x42, 0x42, 0x41,
	0x41, 0x41, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x41, 0x41, 0x40, 0x40, 0x3F, 0x3E, 0x3E, 0x3D, 0x3B, 0x3A, 0x39, 0x38, 0x37, 0x36,
	0x35, 0x34, 0x33, 0x32, 0x31, 0x30, 0x2F, 0x2E, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2E, 0x2F,
	0x2F, 0x30, 0x31, 0x33, 0x34, 0x35, 0x36, 0x38, 0x39, 0x3B, 0x3C, 0x3D, 0x3F, 0x40, 0x41, 0x42,
	0x43, 0x44, 0x45, 0x45, 0x45, 0x45, 0x44, 0x43, 0x42, 0x40, 0x3E, 0x3C, 0x39, 0x36, 0x32, 0x2E,
	0x2A, 0x26, 0x21, 0x1C, 0x16, 0x10, 0x0A, 0x04, 0xFE, 0xF8, 0xF2, 0xEC, 0xE6, 0xE0, 0xDB, 0xD6,
	0xD1, 0xCC, 0xC8, 0xC4, 0xC0, 0xBD, 0xB9, 0xB6, 0xB3, 0xB1, 0xAE, 0xAB, 0xA8, 0xA5, 0xA3, 0xA0,
	0x9D, 0x9A, 0x98, 0x95, 0x92, 0x8F, 0x8D, 0x8A, 0x88, 0x86, 0x84, 0x83, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x83, 0x84, 0x86, 0x86
};

const uint8 SfxPlayer::_musicDataSample2[] = {
	0x0D, 0x90, 0x00, 0x40, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x22, 0x1E, 0x18, 0x14, 0x10, 0x10,
	0x12, 0x16, 0x18, 0x1E, 0x22, 0x22, 0x1E, 0x20, 0x24, 0x22, 0x28, 0x38, 0x30, 0x36, 0x38, 0x2A,
	0x38, 0x32, 0x48, 0x30, 0x36, 0x58, 0x2E, 0x78, 0x24, 0x1A, 0x60, 0x1A, 0x78, 0xF6, 0x7F, 0x80,
	0x7F, 0x00, 0xFE, 0x7F, 0xB8, 0x7E, 0xE8, 0x0A, 0x7C, 0x28, 0x80, 0x9A, 0x7F, 0x6C, 0x60, 0xE4,
	0x5E, 0x6C, 0x7F, 0x7F, 0x76, 0x7F, 0x7C, 0x7F, 0x7F, 0x42, 0x7E, 0x48, 0x9E, 0x7F, 0xE8, 0x6C,
	0x08, 0x1A, 0x7F, 0x20, 0xEC, 0xFE, 0x7F, 0x32, 0x1C, 0xD8, 0x3E, 0x18, 0xCA, 0x48, 0xE0, 0xD8,
	0x4C, 0x24, 0xDC, 0x80, 0x80, 0x02, 0xA0, 0xCA, 0xD8, 0x94, 0xF2, 0xE6, 0x80, 0xAE, 0xA0, 0x80,
	0xCA, 0xA2, 0x82, 0x88, 0xAE, 0x80, 0x80, 0xB8, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x8E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x96, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x90, 0x80, 0x8E, 0x9A, 0x84, 0xD6, 0xB8, 0x82, 0x98, 0x80, 0x96, 0x90, 0xFE, 0x18,
	0xE4, 0xFE, 0x50, 0x90, 0xBE, 0x4C, 0x00, 0xE8, 0xFE, 0x18, 0xDA, 0x7F, 0x60, 0x46, 0x60, 0x3C,
	0x50, 0x34, 0x7F, 0x7A, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x70, 0x54,
	0x58, 0x60, 0x3C, 0x3A, 0x40, 0x1C, 0x12, 0x08, 0x00, 0xE4, 0xCC, 0xCA, 0xC0, 0xE2, 0xD6, 0xBA,
	0x96, 0x80, 0x9A, 0x82, 0x80, 0x9C, 0x8E, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82,
	0x88, 0x90, 0x8E, 0x92, 0x9E, 0xAE, 0xD8, 0xE0, 0xC2, 0xB0, 0xA8, 0xBA, 0xD8, 0xFC, 0x10, 0x02,
	0xF0, 0xEA, 0x0C, 0x3A, 0x48, 0x34, 0x24, 0x16, 0x1E, 0x3E, 0x6C, 0x7F, 0x7F, 0x62, 0x46, 0x3C,
	0x54, 0x76, 0x7E, 0x74, 0x7A, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7A, 0x78, 0x72, 0x66, 0x6E, 0x6E, 0x6C, 0x70, 0x72, 0x66, 0x60,
	0x60, 0x58, 0x52, 0x5C, 0x54, 0x54, 0x50, 0x4A, 0x48, 0x4A, 0x40, 0x42, 0x3A, 0x2A, 0x2E, 0x30,
	0x34, 0x34, 0x28, 0x22, 0x1E, 0x1A, 0x18, 0x16, 0x14, 0x0E, 0x06, 0x0A, 0x0E, 0x0A, 0x00, 0xF4,
	0xF6, 0xF0, 0xF8, 0xF8, 0xF0, 0xE8, 0xD8, 0xD0, 0xCE, 0xD0, 0xD0, 0xCE, 0xCE, 0xCC, 0xCE, 0xC2,
	0xB2, 0xB0, 0xB4, 0xBA, 0xB4, 0xAE, 0xAE, 0xA8, 0xA6, 0xA8, 0x9A, 0x98, 0x94, 0x8E, 0x8E, 0x8E,
	0x8E, 0x88, 0x8C, 0x8A, 0x84, 0x86, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x84, 0x8E, 0x9A, 0x92, 0x90, 0x90, 0x9A, 0x98, 0x9E, 0xB6, 0xBA, 0xC0, 0xC0, 0xA8, 0xB0, 0xC0,
	0xCC, 0xE2, 0xE4, 0xD8, 0xDC, 0xD4, 0xE2, 0xF2, 0xF0, 0x00, 0x06, 0x02, 0x00, 0x06, 0x06, 0x0E,
	0x14, 0x16, 0x22, 0x30, 0x2A, 0x22, 0x28, 0x34, 0x3A, 0x4A, 0x4E, 0x52, 0x54, 0x4A, 0x56, 0x54,
	0x52, 0x5E, 0x5E, 0x64, 0x68, 0x6E, 0x78, 0x7F, 0x7A, 0x7C, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C, 0x78, 0x76,
	0x72, 0x6E, 0x6C, 0x68, 0x64, 0x60, 0x5C, 0x58, 0x56, 0x52, 0x50, 0x4C, 0x44, 0x46, 0x3E, 0x38,
	0x38, 0x2E, 0x2A, 0x1C, 0x1E, 0x18, 0x0E, 0x16, 0x02, 0xF0, 0xFA, 0xFC, 0xEC, 0xEC, 0xDC, 0xE2,
	0xD4, 0xDA, 0xCC, 0xC8, 0xCC, 0xBE, 0xC6, 0xC0, 0xBA, 0xBC, 0xB6, 0xB0, 0xA2, 0xA6, 0x9E, 0x94,
	0x96, 0x8C, 0x98, 0x80, 0x92, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x86, 0x8E, 0x8C, 0x8C, 0x94, 0x90,
	0x98, 0xA0, 0xA6, 0xB4, 0xBA, 0xB8, 0xC4, 0xC4, 0xD0, 0xCE, 0xD2, 0xD8, 0xDC, 0xE2, 0xE4, 0xEA,
	0xEA, 0xEC, 0xF6, 0xFE, 0xFE, 0x04, 0x0E, 0x06, 0x0E, 0x1E, 0x1E, 0x24, 0x2A, 0x32, 0x30, 0x3C,
	0x42, 0x3E, 0x46, 0x46, 0x48, 0x4C, 0x54, 0x5C, 0x64, 0x66, 0x6C, 0x6E, 0x72, 0x76, 0x72, 0x76,
	0x7A, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7A, 0x78, 0x78, 0x72, 0x72, 0x68, 0x68,
	0x68, 0x68, 0x64, 0x64, 0x60, 0x5A, 0x5E, 0x58, 0x56, 0x58, 0x58, 0x54, 0x56, 0x52, 0x50, 0x52,
	0x4A, 0x4E, 0x4A, 0x48, 0x4C, 0x46, 0x44, 0x3E, 0x3C, 0x34, 0x36, 0x38, 0x34, 0x36, 0x30, 0x34,
	0x2E, 0x30, 0x2C, 0x26, 0x32, 0x26, 0x26, 0x26, 0x24, 0x26, 0x22, 0x22, 0x1E, 0x20, 0x20, 0x22,
	0x1E, 0x1A, 0x18, 0x18, 0x1C, 0x18, 0x18, 0x1A, 0x10, 0x14, 0x12, 0x10, 0x14, 0x14, 0x18, 0x16,
	0x1A, 0x14, 0x14, 0x12, 0x18, 0x16, 0x0E, 0x16, 0x0C, 0x0C, 0x10, 0x04, 0x10, 0x04, 0x0E, 0x00,
	0x06, 0x0E, 0x06, 0x04, 0x04, 0x06, 0x0A, 0x08, 0xFC, 0x06, 0x0E, 0x0A, 0x0C, 0x04, 0x06, 0x08,
	0x10, 0x0A, 0x06, 0x08, 0x04, 0x04, 0x06, 0x02, 0x06, 0x00, 0xFE, 0x06, 0xFE, 0xFC, 0xFA, 0x02,
	0x02, 0x00, 0xF6, 0xF6, 0x00, 0xF6, 0xF8, 0xF4, 0xFA, 0xF8, 0xF2, 0xF6, 0xF0, 0xEC, 0xF4, 0xF0,
	0xE6, 0xEA, 0xEC, 0xF0, 0xF0, 0xE4, 0xEA, 0xEC, 0xEC, 0xF0, 0xE0, 0xE4, 0xE4, 0xDE, 0xE2, 0xE2,
	0xE4, 0xE0, 0xE4, 0xDE, 0xDA, 0xE6, 0xDA, 0xDC, 0xD6, 0xCE, 0xD8, 0xDA, 0xD4, 0xCE, 0xD8, 0xD4,
	0xD8, 0xDA, 0xD0, 0xD2, 0xD0, 0xCE, 0xCC, 0xD0, 0xD2, 0xCE, 0xD4, 0xCC, 0xCA, 0xCC, 0xC6, 0xC8,
	0xC6, 0xC2, 0xC6, 0xCE, 0xC6, 0xCE, 0xCC, 0xC0, 0xCA, 0xC4, 0xCC, 0xCC, 0xCA, 0xCC, 0xCA, 0xCC,
	0xCA, 0xC6, 0xC6, 0xC6, 0xC6, 0xC0, 0xC2, 0xC6, 0xC0, 0xC8, 0xCC, 0xCC, 0xD0, 0xD0, 0xCC, 0xCC,
	0xCA, 0xCE, 0xD8, 0xD2, 0xDC, 0xDC, 0xD8, 0xDC, 0xD4, 0xD2, 0xD2, 0xD4, 0xD8, 0xDA, 0xE0, 0xDA,
	0xE0, 0xEE, 0xEE, 0xF8, 0xF4, 0xEE, 0xF6, 0xFE, 0xF8, 0xFC, 0x00, 0x02, 0x04, 0x00, 0xFE, 0xFE,
	0x06, 0x08, 0x0E, 0x0C, 0x0C, 0x0E, 0x0E, 0x10, 0x18, 0x12, 0x14, 0x18, 0x20, 0x20, 0x24, 0x2A,
	0x2A, 0x2C, 0x28, 0x26, 0x2A, 0x32, 0x34, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x36, 0x38, 0x42, 0x46,
	0x48, 0x4A, 0x48, 0x4E, 0x50, 0x4C, 0x52, 0x4E, 0x50, 0x58, 0x52, 0x54, 0x54, 0x5A, 0x56, 0x5A,
	0x5A, 0x5C, 0x62, 0x64, 0x62, 0x60, 0x68, 0x64, 0x6A, 0x6C, 0x6E, 0x72, 0x66, 0x6C, 0x68, 0x6C,
	0x72, 0x6E, 0x72, 0x6E, 0x72, 0x78, 0x70, 0x70, 0x72, 0x74, 0x7A, 0x74, 0x74, 0x74, 0x74, 0x76,
	0x7A, 0x7A, 0x7C, 0x7F, 0x78, 0x7C, 0x78, 0x70, 0x78, 0x78, 0x7A, 0x7F, 0x78, 0x7A, 0x7F, 0x78,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C, 0x7E,
	0x7C, 0x7C, 0x7F, 0x7F, 0x7A, 0x7C, 0x70, 0x72, 0x7C, 0x74, 0x70, 0x6E, 0x6E, 0x6E, 0x6E, 0x68,
	0x6E, 0x6A, 0x64, 0x64, 0x5C, 0x5E, 0x5A, 0x56, 0x50, 0x48, 0x48, 0x4E, 0x4A, 0x44, 0x3A, 0x38,
	0x32, 0x2A, 0x36, 0x34, 0x24, 0x26, 0x20, 0x1C, 0x1E, 0x1E, 0x1C, 0x18, 0x12, 0x0C, 0x06, 0xFC,
	0x02, 0xFA, 0xF6, 0xF8, 0xEE, 0xEE, 0xF0, 0xEE, 0xEA, 0xE0, 0xDE, 0xE0, 0xDE, 0xCE, 0xD6, 0xD0,
	0xC8, 0xD2, 0xC4, 0xBA, 0xC8, 0xBA, 0xB8, 0xC0, 0xAC, 0xB0, 0xB0, 0xA8, 0xB4, 0xAA, 0xA8, 0xA8,
	0xA0, 0x9A, 0xA2, 0xA0, 0x9C, 0x9C, 0x9C, 0x98, 0x94, 0x98, 0x8C, 0x92, 0x94, 0x8A, 0x8A, 0x88,
	0x80, 0x86, 0x84, 0x82, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x82, 0x80, 0x86, 0x80,
	0x82, 0x88, 0x82, 0x8E, 0x88, 0x8A, 0x8E, 0x8E, 0x96, 0x92, 0x96, 0x9A, 0x98, 0x9A, 0x9E, 0x9E,
	0xAA, 0xB0, 0xB0, 0xB0, 0xB8, 0xB2, 0xB8, 0xC4, 0xC2, 0xCC, 0xC6, 0xCC, 0xD6, 0xD0, 0xD0, 0xD6,
	0xDE, 0xE2, 0xE4, 0xF0, 0xEE, 0xE4, 0xF4, 0xF4, 0xF6, 0xFE, 0x00, 0x0A, 0x10, 0x10, 0x14, 0x1E,
	0x1A, 0x22, 0x2A, 0x22, 0x32, 0x36, 0x34, 0x3E, 0x3E, 0x3C, 0x40, 0x46, 0x4A, 0x50, 0x50, 0x56,
	0x54, 0x60, 0x6A, 0x6A, 0x6E, 0x6A, 0x6C, 0x76, 0x78, 0x7A, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C, 0x78, 0x74,
	0x76, 0x76, 0x6A, 0x72, 0x62, 0x62, 0x68, 0x5C, 0x58, 0x52, 0x50, 0x44, 0x48, 0x4A, 0x42, 0x48,
	0x3A, 0x32, 0x3E, 0x34, 0x30, 0x38, 0x30, 0x2E, 0x2A, 0x2A, 0x26, 0x1E, 0x1A, 0x16, 0x10, 0x0C,
	0x0C, 0x00, 0xF0, 0xF4, 0xFA, 0xF8, 0xF6, 0xF2, 0xF0, 0xF0, 0xF0, 0xEA, 0xDC, 0xE2, 0xDE, 0xDC,
	0xE0, 0xD2, 0xCA, 0xDA, 0xCC, 0xD2, 0xD6, 0xCA, 0xDC, 0xD0, 0xC8, 0xD6, 0xC6, 0xC6, 0xC0, 0xBC,
	0xB8, 0xBA, 0xBA, 0xC0, 0xC2, 0xB8, 0xB8, 0xB4, 0xB0, 0xB4, 0xB0, 0xB2, 0xAE, 0xAC, 0xB2, 0xB2,
	0xAC, 0xA6, 0xAC, 0xAA, 0xAC, 0xAA, 0xAC, 0xA8, 0xA2, 0xA4, 0xA6, 0x9E, 0xA2, 0xA4, 0xA6, 0xA8,
	0x9E, 0xAC, 0xA4, 0xA6, 0xAC, 0xA4, 0xA8, 0xA6, 0xA2, 0xA0, 0xA2, 0xA4, 0xA0, 0xA0, 0x9C, 0x9C,
	0x98, 0x9C, 0x94, 0x9A, 0x9E, 0x9A, 0x9E, 0xA2, 0xA0, 0x9A, 0x98, 0x9A, 0x94, 0x98, 0x96, 0x8C,
	0x9E, 0x98, 0x9E, 0xA4, 0xA8, 0xA4, 0xA6, 0xA4, 0xA2, 0xAA, 0xA6, 0xAA, 0xAA, 0xA6, 0xAE, 0xB2,
	0xB2, 0xBA, 0xB0, 0xAA, 0xB2, 0xB8, 0xB2, 0xB6, 0xC2, 0xC8, 0xCE, 0xC8, 0xC8, 0xCA, 0xCA, 0xCC,
	0xD4, 0xD2, 0xD4, 0xD6, 0xE6, 0xE8, 0xE6, 0xE8, 0xE0, 0xE6, 0xEC, 0xEE, 0xF8, 0xF6, 0xF2, 0xFA,
	0xFC, 0xF6, 0xFE, 0x08, 0x08, 0x10, 0x10, 0x12, 0x18, 0x1C, 0x24, 0x22, 0x24, 0x2E, 0x2A, 0x34,
	0x34, 0x40, 0x42, 0x3E, 0x42, 0x3E, 0x46, 0x42, 0x46, 0x50, 0x4E, 0x56, 0x50, 0x4E, 0x5C, 0x5E,
	0x56, 0x5E, 0x60, 0x68, 0x62, 0x66, 0x60, 0x62, 0x6C, 0x66, 0x6C, 0x66, 0x60, 0x6A, 0x66, 0x6A,
	0x70, 0x68, 0x5E, 0x64, 0x68, 0x62, 0x6C, 0x68, 0x64, 0x68, 0x60, 0x66, 0x60, 0x5A, 0x58, 0x58,
	0x58, 0x50, 0x50, 0x4A, 0x46, 0x42, 0x44, 0x44, 0x48, 0x40, 0x3E, 0x42, 0x38, 0x3C, 0x30, 0x30,
	0x30, 0x2C, 0x34, 0x28, 0x28, 0x26, 0x1C, 0x28, 0x22, 0x1A, 0x16, 0x12, 0x0E, 0x0C, 0x0C, 0x0C,
	0x0C, 0x02, 0x06, 0x06, 0x00, 0x00, 0x00, 0xFA, 0xFA, 0xFC, 0xF2, 0xF6, 0xFA, 0xF6, 0xF4, 0xF0,
	0xF0, 0xE8, 0xE8, 0xF2, 0xF0, 0xF0, 0xE6, 0xE4, 0xE6, 0xEC, 0xEE, 0xEE, 0xE2, 0xE6, 0xEE, 0xE4,
	0xF0, 0xEC, 0xE6, 0xEC, 0xEA, 0xEC, 0xF0, 0xF0, 0xEA, 0xE8, 0xEA, 0xEC, 0xFA, 0xF0, 0xE8, 0xEE,
	0xEA, 0xF4, 0xFC, 0xFE, 0xFA, 0x00, 0xF8, 0xF8, 0xF8, 0xFC, 0x00, 0xFC, 0x02, 0x00, 0x06, 0x0A,
	0x0A, 0x0C, 0x10, 0x0C, 0x0E, 0x08, 0x0C, 0x10, 0x0E, 0x18, 0x14, 0x1E, 0x1C, 0x20, 0x1E, 0x1C,
	0x1E, 0x1E, 0x20, 0x26, 0x22, 0x1E, 0x20, 0x22, 0x28, 0x20, 0x26, 0x2A, 0x26, 0x2C, 0x26, 0x26,
	0x26, 0x28, 0x30, 0x38, 0x2E, 0x2E, 0x30, 0x2A, 0x34, 0x30, 0x32, 0x2E, 0x26, 0x2C, 0x2C, 0x26,
	0x26, 0x2A, 0x28, 0x2A, 0x28, 0x26, 0x2A, 0x24, 0x20, 0x28, 0x26, 0x28, 0x26, 0x22, 0x1E, 0x20,
	0x24, 0x1C, 0x12, 0x1C, 0x0E, 0x14, 0x14, 0x0E, 0x18, 0x12, 0x10, 0x12, 0x0C, 0x0C, 0x04, 0x0C,
	0x0A, 0x0C, 0x08, 0x02, 0x0C, 0x10, 0x0E, 0x0A, 0x02, 0xFE, 0x06, 0x06, 0x06, 0x04, 0xFC, 0x06,
	0x08, 0x02, 0x00, 0xF8, 0xFC, 0xFC, 0xF4, 0xFC, 0x00, 0x00, 0xFE, 0xF8, 0xF0, 0xF6, 0xFC, 0xF6,
	0xF4, 0xF2, 0xF6, 0xFA, 0xF2, 0xF8, 0xF8, 0xFA, 0xF6, 0xFC, 0xFC, 0xF6, 0xFC, 0xF2, 0xFC, 0xFA,
	0xFE, 0xFC, 0xFE, 0x00, 0xFC, 0xFE, 0x00, 0xFE, 0x06, 0x02, 0x04, 0x10, 0x0E, 0x12, 0x0C, 0x0E,
	0x0E, 0x0C, 0x0E, 0x10, 0x10, 0x1A, 0x0E, 0x08, 0x16, 0x1A, 0x20, 0x20, 0x22, 0x2C, 0x2C, 0x30,
	0x30, 0x38, 0x3E, 0x34, 0x36, 0x3E, 0x40, 0x3C, 0x42, 0x3C, 0x44, 0x46, 0x46, 0x4A, 0x4C, 0x4A,
	0x4A, 0x52, 0x50, 0x56, 0x5E, 0x5E, 0x60, 0x60, 0x62, 0x60, 0x62, 0x64, 0x60, 0x64, 0x64, 0x6A,
	0x72, 0x68, 0x66, 0x6C, 0x6E, 0x6E, 0x74, 0x70, 0x6C, 0x6C, 0x66, 0x70, 0x7A, 0x7A, 0x7A, 0x78,
	0x74, 0x72, 0x72, 0x78, 0x72, 0x76, 0x76, 0x74, 0x78, 0x72, 0x76, 0x72, 0x70, 0x74, 0x70, 0x72,
	0x70, 0x76, 0x74, 0x6E, 0x6A, 0x66, 0x68, 0x64, 0x64, 0x60, 0x64, 0x64, 0x64, 0x68, 0x60, 0x5A,
	0x5C, 0x58, 0x56, 0x54, 0x58, 0x4C, 0x50, 0x4E, 0x4A, 0x4A, 0x46, 0x46, 0x42, 0x42, 0x46, 0x46,
	0x42, 0x40, 0x40, 0x3C, 0x3A, 0x3A, 0x3A, 0x36, 0x3A, 0x36, 0x34, 0x30, 0x2E, 0x30, 0x28, 0x24,
	0x26, 0x1E, 0x26, 0x1E, 0x18, 0x1A, 0x14, 0x16, 0x1C, 0x12, 0x08, 0x02, 0x04, 0x04, 0x08, 0x04,
	0x00, 0x00, 0xFA, 0xF8, 0xF2, 0xF2, 0xEC, 0xE8, 0xEA, 0xE4, 0xE2, 0xE0, 0xDA, 0xDE, 0xDC, 0xD6,
	0xD2, 0xD2, 0xCE, 0xCC, 0xC4, 0xC0, 0xC4, 0xBC, 0xC0, 0xC0, 0xB8, 0xAE, 0xAA, 0xAC, 0xAE, 0xA4,
	0xA0, 0x9C, 0x9C, 0xA6, 0x9E, 0xA0, 0x9A, 0x9C, 0x9A, 0x94, 0x98, 0x94, 0x98, 0x96, 0x9C, 0x92,
	0x8E, 0x8E, 0x8E, 0x90, 0x8A, 0x84, 0x82, 0x82, 0x84, 0x80, 0x86, 0x86, 0x86, 0x8A, 0x88, 0x90,
	0x96, 0x94, 0x98, 0x8E, 0x90, 0x98, 0x9A, 0x9A, 0x98, 0x90, 0x9A, 0xA0, 0xA0, 0xAC, 0xA8, 0xAE,
	0xB2, 0xB0, 0xB2, 0xBE, 0xBC, 0xBC, 0xC2, 0xC4, 0xCC, 0xCC, 0xCE, 0xD4, 0xD8, 0xDA, 0xDC, 0xEA,
	0xEA, 0xEC, 0xF2, 0xF4, 0xFC, 0xFA, 0x00, 0x06, 0x0A, 0x12, 0x14, 0x16, 0x16, 0x2A, 0x36, 0x34,
	0x34, 0x3A, 0x3A, 0x46, 0x4C, 0x52, 0x5A, 0x5A, 0x60, 0x5C, 0x5E, 0x68, 0x6A, 0x66, 0x72, 0x76,
	0x78, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C,
	0x76, 0x76, 0x72, 0x74, 0x70, 0x68, 0x68, 0x60, 0x5E, 0x5E, 0x56, 0x58, 0x56, 0x4C, 0x4C, 0x46,
	0x44, 0x46, 0x3C, 0x3A, 0x30, 0x30, 0x2A, 0x2C, 0x26, 0x20, 0x1E, 0x1E, 0x1E, 0x18, 0x16, 0x14,
	0x0E, 0x10, 0x08, 0x08, 0x06, 0x04, 0x00, 0xFC, 0xFA, 0xF6, 0xEE, 0xF0, 0xEE, 0xEA, 0xE4, 0xE6,
	0xE6, 0xE2, 0xDE, 0xE0, 0xE0, 0xDE, 0xE2, 0xDA, 0xD8, 0xD8, 0xD8, 0xD6, 0xDA, 0xD6, 0xD4, 0xD4,
	0xCE, 0xCA, 0xC8, 0xCA, 0xD0, 0xCE, 0xCA, 0xCC, 0xC6, 0xC2, 0xC6, 0xC8, 0xC8, 0xCE, 0xCA, 0xCA,
	0xC6, 0xCC, 0xC0, 0xC0, 0xC4, 0xC2, 0xC6, 0xC0, 0xBE, 0xC2, 0xC2, 0xBC, 0xB8, 0xBC, 0xC0, 0xC0,
	0xC0, 0xC0, 0xC0, 0xC8, 0xC6, 0xC4, 0xC2, 0xC6, 0xC2, 0xC2, 0xC4, 0xC6, 0xC0, 0xBC, 0xC4, 0xC2,
	0xC6, 0xC6, 0xC6, 0xC6, 0xC4, 0xC0, 0xC6, 0xCE, 0xC6, 0xC8, 0xC8, 0xC6, 0xC0, 0xC2, 0xC8, 0xCC,
	0xCA, 0xCC, 0xCA, 0xC4, 0xCC, 0xCE, 0xC8, 0xCC, 0xC8, 0xC6, 0xC6, 0xC6, 0xD0, 0xCA, 0xC8, 0xC6,
	0xC8, 0xD2, 0xD0, 0xCC, 0xCA, 0xCE, 0xD0, 0xD4, 0xD4, 0xD6, 0xD4, 0xD6, 0xD6, 0xD6, 0xD4, 0xD2,
	0xD4, 0xD8, 0xD2, 0xD6, 0xD8, 0xD6, 0xDA, 0xD4, 0xD4, 0xD2, 0xD8, 0xE0, 0xE0, 0xE0, 0xDC, 0xDE,
	0xDE, 0xE2, 0xE0, 0xDC, 0xE2, 0xE0, 0xE0, 0xE4, 0xE6, 0xE6, 0xE4, 0xE4, 0xE2, 0xE0, 0xE6, 0xEC,
	0xE8, 0xE6, 0xE8, 0xE8, 0xEA, 0xEC, 0xEE, 0xF0, 0xEC, 0xEA, 0xEA, 0xEC, 0xF4, 0xF2, 0xF2, 0xEC,
	0xEE, 0xF0, 0xEE, 0xF2, 0xF2, 0xF2, 0xF6, 0xF8, 0xF4, 0xF6, 0xFA, 0xF8, 0xF8, 0xF8, 0xFC, 0xFC,
	0xF8, 0xF8, 0xFA, 0x00, 0x00, 0x04, 0x08, 0x04, 0x02, 0x02, 0x04, 0x10, 0x14, 0x10, 0x12, 0x0C,
	0x0C, 0x12, 0x12, 0x14, 0x16, 0x16, 0x18, 0x1A, 0x1E, 0x20, 0x20, 0x22, 0x20, 0x1E, 0x22, 0x28,
	0x28, 0x2A, 0x2C, 0x2E, 0x30, 0x32, 0x34, 0x38, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x42, 0x42, 0x42,
	0x42, 0x46, 0x48, 0x48, 0x4E, 0x4A, 0x54, 0x58, 0x58, 0x5A, 0x5A, 0x5C, 0x62, 0x62, 0x5E, 0x68,
	0x66, 0x6A, 0x70, 0x6E, 0x70, 0x72, 0x72, 0x76, 0x7A, 0x76, 0x74, 0x78, 0x78, 0x7C, 0x7F, 0x7A,
	0x7C, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7A, 0x7C,
	0x7C, 0x7C, 0x74, 0x6A, 0x6C, 0x6E, 0x6E, 0x6C, 0x60, 0x60, 0x5E, 0x5E, 0x5C, 0x56, 0x54, 0x56,
	0x54, 0x52, 0x54, 0x4C, 0x46, 0x44, 0x42, 0x40, 0x3C, 0x3C, 0x3C, 0x38, 0x32, 0x32, 0x2C, 0x2C,
	0x26, 0x24, 0x26, 0x20, 0x22, 0x1E, 0x1C, 0x18, 0x10, 0x18, 0x10, 0x10, 0x0C, 0x0C, 0x08, 0x0C,
	0x0C, 0x02, 0x00, 0xFC, 0x00, 0xFC, 0xF8, 0xF2, 0xF2, 0xEA, 0xEA, 0xEE, 0xF0, 0xF2, 0xE6, 0xE4,
	0xE4, 0xE6, 0xE8, 0xEA, 0xE6, 0xE2, 0xE4, 0xE0, 0xE2, 0xE0, 0xDC, 0xD2, 0xD6, 0xD8, 0xDA, 0xDA,
	0xD0, 0xD4, 0xD6, 0xD0, 0xCE, 0xD2, 0xD0, 0xCC, 0xCA, 0xCC, 0xCC, 0xCA, 0xCC, 0xCC, 0xCC, 0xCA,
	0xC6, 0xC6, 0xC4, 0xC4, 0xC4, 0xC4, 0xC0, 0xC6, 0xC2, 0xC6, 0xC8, 0xC2, 0xC2, 0xC2, 0xC0, 0xC6,
	0xC6, 0xC2, 0xC4, 0xC6, 0xC2, 0xC2, 0xC4, 0xC8, 0xC6, 0xC4, 0xC0, 0xC0, 0xBC, 0xBE, 0xBE, 0xC0,
	0xC2, 0xC0, 0xC4, 0xC0, 0xC0, 0xC2, 0xBE, 0xC2, 0xC6, 0xCA, 0xC6, 0xC4, 0xC0, 0xC0, 0xC0, 0xC2,
	0xC6, 0xC8, 0xC6, 0xC8, 0xC8, 0xC6, 0xC6, 0xCA, 0xCA, 0xCC, 0xCE, 0xCC, 0xCC, 0xD6, 0xDA, 0xDC,
	0xDC, 0xDE, 0xDA, 0xDA, 0xE2, 0xE2, 0xE8, 0xE6, 0xE6, 0xE6, 0xEC, 0xF0, 0xF2, 0xF2, 0xF2, 0xF4,
	0xF8, 0xFC, 0xFC, 0x02, 0x04, 0x04, 0x06, 0x0C, 0x0E, 0x10, 0x10, 0x16, 0x1A, 0x1A, 0x1E, 0x20,
	0x24, 0x24, 0x24, 0x26, 0x2A, 0x30, 0x2E, 0x32, 0x36, 0x38, 0x40, 0x3E, 0x3E, 0x3E, 0x42, 0x42,
	0x44, 0x4C, 0x50, 0x54, 0x54, 0x52, 0x50, 0x54, 0x5C, 0x5A, 0x5C, 0x5E, 0x5C, 0x5E, 0x62, 0x64,
	0x66, 0x64, 0x64, 0x66, 0x66, 0x66, 0x68, 0x6C, 0x6E, 0x6E, 0x6C, 0x6A, 0x6C, 0x6A, 0x6E, 0x6A,
	0x6E, 0x6A, 0x70, 0x70, 0x6A, 0x6C, 0x68, 0x6A, 0x6E, 0x6C, 0x6C, 0x64, 0x62, 0x64, 0x66, 0x6C,
	0x68, 0x62, 0x60, 0x5E, 0x64, 0x66, 0x60, 0x5E, 0x5C, 0x5C, 0x5C, 0x58, 0x54, 0x56, 0x50, 0x52,
	0x4C, 0x46, 0x48, 0x42, 0x46, 0x4A, 0x40, 0x3A, 0x38, 0x3A, 0x36, 0x30, 0x2A, 0x26, 0x2C, 0x30,
	0x2A, 0x26, 0x2A, 0x2A, 0x22, 0x1C, 0x18, 0x1C, 0x16, 0x14, 0x16, 0x0E, 0x12, 0x14, 0x0A, 0x06,
	0x08, 0x00, 0x04, 0x02, 0x00, 0xFC, 0xFC, 0xFE, 0xF8, 0xF6, 0xF2, 0xF0, 0xF2, 0xF0, 0xEC, 0xEA,
	0xEA, 0xEA, 0xEE, 0xEA, 0xE6, 0xE8, 0xE2, 0xE6, 0xE8, 0xE6, 0xEA, 0xE4, 0xE2, 0xE0, 0xE0, 0xE0,
	0xDE, 0xE2, 0xE4, 0xE0, 0xE0, 0xE0, 0xE2, 0xE2, 0xE0, 0xE2, 0xE4, 0xE0, 0xE0, 0xE2, 0xE2, 0xE4,
	0xE6, 0xE6, 0xE6, 0xE6, 0xEE, 0xE8, 0xE6, 0xE8, 0xE6, 0xE6, 0xEC, 0xF0, 0xEE, 0xEE, 0xEC, 0xEE,
	0xF2, 0xF4, 0xF8, 0xF4, 0xF8, 0xF8, 0xF8, 0xFA, 0xFE, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04,
	0x08, 0x0A, 0x08, 0x0C, 0x0A, 0x0E, 0x0E, 0x0C, 0x0C, 0x10, 0x10, 0x12, 0x16, 0x18, 0x1A, 0x18,
	0x16, 0x18, 0x18, 0x16, 0x1A, 0x1E, 0x1E, 0x1E, 0x18, 0x1C, 0x1E, 0x1E, 0x1C, 0x1A, 0x20, 0x1E,
	0x24, 0x24, 0x24, 0x22, 0x20, 0x22, 0x22, 0x26, 0x22, 0x20, 0x20, 0x26, 0x26, 0x20, 0x1E, 0x1E,
	0x1E, 0x1C, 0x1A, 0x1C, 0x20, 0x20, 0x22, 0x22, 0x24, 0x20, 0x1E, 0x20, 0x22, 0x26, 0x20, 0x22,
	0x24, 0x24, 0x1E, 0x1C, 0x1C, 0x22, 0x22, 0x1C, 0x20, 0x20, 0x1E, 0x1C, 0x1C, 0x1A, 0x1A, 0x1C,
	0x1E, 0x1C, 0x1A, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1E, 0x18, 0x1C, 0x14, 0x12, 0x12, 0x16, 0x10,
	0x0E, 0x16, 0x14, 0x16, 0x10, 0x0E, 0x12, 0x16, 0x16, 0x14, 0x18, 0x10, 0x10, 0x10, 0x12, 0x10,
	0x10, 0x08, 0x08, 0x06, 0x08, 0x08, 0x06, 0x0C, 0x08, 0x08, 0x06, 0x08, 0x08, 0x0A, 0x08, 0x0A,
	0x0C, 0x06, 0x04, 0x04, 0x06, 0x04, 0x04, 0x06, 0x04, 0x02, 0x06, 0x06, 0x02, 0x04, 0x04, 0x06,
	0x08, 0x06, 0x04, 0x04, 0x06, 0x0C, 0x0A, 0x02, 0x02
};

const uint8 SfxPlayer::_musicDataSample3[] = {
	0x11, 0x8C, 0x00, 0x20, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x42, 0x50, 0x43, 0x18, 0xF6, 0xEE,
	0xE5, 0xCF, 0xC7, 0xB7, 0xAC, 0xAA, 0xAB, 0xD9, 0x2E, 0x7B, 0x7F, 0x79, 0x27, 0xEC, 0xCD, 0xE6,
	0x03, 0xFC, 0xE9, 0xE1, 0xE2, 0xF5, 0xFF, 0x0E, 0x23, 0x29, 0x13, 0xD5, 0x98, 0x8B, 0xA1, 0xBB,
	0xDF, 0xE9, 0x03, 0x36, 0x65, 0x72, 0x55, 0x23, 0x01, 0xDF, 0xC2, 0xA0, 0x85, 0x90, 0xC3, 0xEF,
	0x18, 0x40, 0x53, 0x55, 0x26, 0xDB, 0x9E, 0x90, 0xC1, 0x0A, 0x3D, 0x59, 0x58, 0x54, 0x62, 0x68,
	0x57, 0x4A, 0x2B, 0xF3, 0xB5, 0x8C, 0x94, 0xC3, 0x02, 0x20, 0x04, 0xCD, 0xAF, 0xAC, 0xD9, 0x03,
	0x0D, 0x0D, 0x0F, 0x01, 0xFA, 0x06, 0x30, 0x5C, 0x75, 0x6F, 0x3A, 0x00, 0xF1, 0xFF, 0xFA, 0xE2,
	0xB2, 0xA3, 0xBC, 0xD8, 0xD7, 0xCD, 0xC5, 0xC6, 0xCA, 0xCE, 0xC7, 0xC1, 0xE8, 0x29, 0x46, 0x47,
	0x58, 0x73, 0x7F, 0x5F, 0x0E, 0xBE, 0xAC, 0xDA, 0x23, 0x50, 0x4F, 0x1F, 0xFE, 0xFB, 0xED, 0xCC,
	0xC6, 0xCB, 0xC0, 0xAB, 0xAB, 0xD6, 0x23, 0x7F, 0x7F, 0x7F, 0x3E, 0xEB, 0xCA, 0xE6, 0xFF, 0xF6,
	0xE8, 0xEB, 0xE7, 0xE5, 0xF6, 0x14, 0x22, 0x24, 0x17, 0xDC, 0x9D, 0x91, 0xB2, 0xDC, 0xED, 0xE2,
	0xEE, 0x21, 0x5A, 0x6E, 0x62, 0x3A, 0xFE, 0xCA, 0xBD, 0xAD, 0x93, 0x9D, 0xC7, 0xE8, 0xFF, 0x24,
	0x50, 0x60, 0x3A, 0xF1, 0xA9, 0x9A, 0xBE, 0x00, 0x48, 0x6D, 0x59, 0x48, 0x58, 0x5C, 0x4A, 0x38,
	0x24, 0xE7, 0x95, 0x84, 0x85, 0xC4, 0x13, 0x36, 0x1F, 0xE2, 0xA4, 0xA2, 0xD8, 0x02, 0x06, 0x01,
	0x0F, 0x15, 0x0E, 0x2E, 0x62, 0x73, 0x6A, 0x53, 0x19, 0xE0, 0xD2, 0xE4, 0xF1, 0xD0, 0xA6, 0xA6,
	0xCF, 0xF7, 0xEB, 0xD2, 0xC4, 0xB1, 0xA9, 0xC6, 0xD4, 0xD3, 0xFB, 0x3A, 0x56, 0x50, 0x4F, 0x6E,
	0x7C, 0x52, 0xFC, 0xA7, 0x9A, 0xC6, 0x0A, 0x44, 0x49, 0x18, 0x00, 0x0F, 0x09, 0xDF, 0xC4, 0xCB,
	0xCE, 0xB9, 0xC2, 0xE8, 0x26, 0x76, 0x7F, 0x7F, 0x3A, 0xD7, 0xBB, 0xE4, 0x01, 0xED, 0xCB, 0xCD,
	0xD8, 0xD9, 0xF2, 0x1C, 0x1F, 0x1B, 0x1E, 0xF2, 0xBF, 0xAC, 0xC6, 0xF6, 0xFD, 0xEC, 0xF0, 0x1B,
	0x58, 0x68, 0x58, 0x3E, 0xFE, 0xC5, 0xBA, 0xAD, 0x90, 0x98, 0xC2, 0xE7, 0xF7, 0x06, 0x39, 0x57,
	0x4A, 0x11, 0xBD, 0xA4, 0xC7, 0x03, 0x59, 0x7E, 0x5A, 0x3B, 0x41, 0x48, 0x37, 0x24, 0x18, 0xEA,
	0x95, 0x84, 0x8E, 0xC9, 0x20, 0x3F, 0x1F, 0xDE, 0x99, 0xAC, 0xFD, 0x3B, 0x42, 0x25, 0x23, 0x1D,
	0xFA, 0x05, 0x3E, 0x54, 0x57, 0x46, 0x0C, 0xDC, 0xD7, 0xF5, 0x11, 0xDA, 0x8A, 0x84, 0x8B, 0xDC,
	0xFB, 0xF1, 0xEF, 0xD7, 0xC5, 0xE5, 0xFB, 0xF2, 0xFA, 0x1F, 0x38, 0x35, 0x33, 0x6C, 0x7F, 0x78,
	0x1F, 0xA6, 0x84, 0x98, 0xD6, 0x23, 0x3B, 0x08, 0xE7, 0x02, 0x1A, 0x02, 0xE2, 0xE3, 0xE4, 0xB9,
	0xB1, 0xDA, 0x22, 0x7B, 0x7F, 0x7F, 0x34, 0xD3, 0xC7, 0x0C, 0x33, 0x0C, 0xC9, 0xB3, 0xC1, 0xC1,
	0xDD, 0x1D, 0x2E, 0x20, 0x14, 0xEF, 0xCB, 0xD0, 0xF7, 0x26, 0x0C, 0xC3, 0xA6, 0xD6, 0x36, 0x67,
	0x68, 0x59, 0x1B, 0xCD, 0xBA, 0xB8, 0x9C, 0x8F, 0xA6, 0xC2, 0xD0, 0xEC, 0x3B, 0x77, 0x6D, 0x29,
	0xC6, 0xA2, 0xC6, 0x07, 0x59, 0x7F, 0x5C, 0x2B, 0x2D, 0x41, 0x35, 0x25, 0x1F, 0xF5, 0x95, 0x84,
	0x8B, 0xD6, 0x2E, 0x43, 0x0E, 0xBC, 0x84, 0x84, 0xED, 0x3B, 0x41, 0x21, 0x22, 0x2A, 0x17, 0x24,
	0x64, 0x73, 0x4F, 0x29, 0xF5, 0xD7, 0xE9, 0x12, 0x29, 0xE5, 0x86, 0x84, 0x84, 0xDE, 0x06, 0xF9,
	0xF1, 0xD5, 0xB0, 0xC7, 0xE4, 0xDF, 0xE0, 0x01, 0x1B, 0x22, 0x32, 0x76, 0x7F, 0x7F, 0x3B, 0xB7,
	0x85, 0x9A, 0xD0, 0x17, 0x32, 0x01, 0xE2, 0xFB, 0x1A, 0x0B, 0xF1, 0xF0, 0xE4, 0xA0, 0x87, 0xAF,
	0xFE, 0x62, 0x7F, 0x79, 0x35, 0xE1, 0xDA, 0x26, 0x4E, 0x2B, 0xE4, 0xC8, 0xC8, 0xBA, 0xC8, 0x0A,
	0x1F, 0x13, 0x0E, 0xFB, 0xEB, 0xF8, 0x1A, 0x3F, 0x11, 0xB7, 0x95, 0xBD, 0x1C, 0x4E, 0x57, 0x53,
	0x21, 0xD8, 0xCB, 0xD1, 0xBA, 0xA7, 0xA8, 0xAC, 0xA7, 0xBA, 0x1E, 0x76, 0x7E, 0x45, 0xDC, 0xAA,
	0xBB, 0xEE, 0x44, 0x78, 0x5B, 0x36, 0x3A, 0x4A, 0x37, 0x27, 0x2D, 0x15, 0xBB, 0x86, 0x92, 0xC7,
	0x0C, 0x27, 0x04, 0xC7, 0x8F, 0x9D, 0xF8, 0x37, 0x2E, 0x05, 0x08, 0x15, 0x0D, 0x1C, 0x58, 0x67,
	0x4C, 0x2E, 0x12, 0x01, 0x0D, 0x2A, 0x35, 0xE7, 0x8A, 0x84, 0x84, 0xDA, 0x08, 0x11, 0x0D, 0xEC,
	0xBC, 0xBE, 0xD5, 0xD4, 0xD3, 0xED, 0xFF, 0x00, 0x13, 0x68, 0x7F, 0x7F, 0x61, 0xE1, 0x90, 0x83,
	0xA4, 0xEC, 0x1F, 0x0D, 0xF6, 0x0C, 0x2B, 0x1F, 0x0F, 0x14, 0x09, 0xC4, 0x98, 0xA9, 0xEC, 0x41,
	0x7C, 0x78, 0x39, 0xE8, 0xD8, 0x16, 0x46, 0x27, 0xE1, 0xC0, 0xAF, 0xA0, 0xB5, 0xFB, 0x23, 0x1F,
	0x16, 0x06, 0xF8, 0x05, 0x2D, 0x4E, 0x27, 0xC9, 0x8E, 0xAD, 0x05, 0x46, 0x68, 0x6A, 0x36, 0xE8,
	0xCA, 0xCA, 0xB8, 0xA4, 0xA5, 0xA4, 0x9A, 0xAE, 0x05, 0x66, 0x7F, 0x55, 0xF0, 0xAE, 0xA6, 0xD4,
	0x2A, 0x66, 0x55, 0x29, 0x2E, 0x49, 0x47, 0x40, 0x3D, 0x18, 0xC2, 0x86, 0x85, 0xBC, 0x06, 0x31,
	0x28, 0xE5, 0x9A, 0x8D, 0xD5, 0x2C, 0x37, 0x15, 0x04, 0x00, 0xFA, 0x18, 0x60, 0x7E, 0x6B, 0x3C,
	0x11, 0xF2, 0xF2, 0x16, 0x2B, 0xF8, 0x99, 0x84, 0x84, 0xC1, 0xFA, 0x10, 0x0D, 0xE7, 0xBC, 0xB6,
	0xD1, 0xDE, 0xDA, 0xE9, 0xFA, 0xFD, 0x15, 0x5A, 0x7F, 0x7F, 0x76, 0x0C, 0xB9, 0x91, 0xA5, 0xE1,
	0x0F, 0x01, 0xDE, 0xE6, 0x09, 0x13, 0x18, 0x25, 0x18, 0xE0, 0xB4, 0xB2, 0xE4, 0x28, 0x5E, 0x70,
	0x47, 0x05, 0xEE, 0x15, 0x46, 0x3A, 0x01, 0xD8, 0xBE, 0xA5, 0xAD, 0xDF, 0x0A, 0x17, 0x09, 0xF8,
	0xEC, 0xF5, 0x21, 0x45, 0x34, 0xEB, 0xA7, 0xB4, 0xF9, 0x34, 0x5E, 0x63, 0x35, 0xEF, 0xC2, 0xBB,
	0xBF, 0xB9, 0xB5, 0xAD, 0x94, 0x99, 0xD0, 0x1D, 0x58, 0x44, 0x03, 0xD5, 0xC5, 0xEA, 0x3A, 0x73,
	0x73, 0x42, 0x30, 0x3A, 0x3C, 0x3B, 0x43, 0x2B, 0xEC, 0xB2, 0x9C, 0xBF, 0xF4, 0x14, 0x14, 0xE0,
	0x9B, 0x89, 0xC1, 0x1E, 0x3F, 0x29, 0x14, 0x03, 0xF8, 0x17, 0x4C, 0x6C, 0x5F, 0x33, 0x0F, 0xFF,
	0xFC, 0x13, 0x1F, 0xFA, 0xB2, 0x84, 0x84, 0xB0, 0xE5, 0x10, 0x1B, 0xF5, 0xC3, 0xA8, 0xC0, 0xE6,
	0xF8, 0x04, 0x09, 0xFC, 0x0C, 0x3F, 0x79, 0x7F, 0x62, 0x08, 0xC2, 0x95, 0x98, 0xCF, 0x04, 0x19,
	0x03, 0xF9, 0x04, 0x0E, 0x1B, 0x30, 0x27, 0xFE, 0xD1, 0xC1, 0xED, 0x24, 0x45, 0x58, 0x3E, 0x0E,
	0xFA, 0x10, 0x3E, 0x3A, 0x0F, 0xE6, 0xBB, 0x94, 0x9A, 0xC0, 0xF3, 0x0B, 0x03, 0xF6, 0xFA, 0x0C,
	0x36, 0x52, 0x38, 0xEF, 0xA2, 0xA3, 0xDC, 0x1A, 0x51, 0x68, 0x3F, 0x03, 0xD3, 0xC8, 0xCD, 0xCE,
	0xC4, 0xB0, 0x8C, 0x86, 0xB6, 0x06, 0x4F, 0x4F, 0x23, 0xF8, 0xDD, 0xEF, 0x2F, 0x5B, 0x5B, 0x31,
	0x1B, 0x1D, 0x22, 0x2D, 0x3F, 0x2C, 0x05, 0xDE, 0xC0, 0xCA, 0xE7, 0xF6, 0xFA, 0xD9, 0xA8, 0xA2,
	0xD1, 0x22, 0x44, 0x38, 0x1F, 0x02, 0xF0, 0x11, 0x38, 0x4D, 0x48, 0x27, 0x0A, 0x03, 0x01, 0x15,
	0x1C, 0xFC, 0xBE, 0x85, 0x84, 0xA8, 0xE0, 0x18, 0x2C, 0x04, 0xD7, 0xC2, 0xD1, 0xED, 0xFF, 0x02,
	0x02, 0xFC, 0x19, 0x44, 0x6B, 0x7F, 0x5D, 0x1B, 0xDD, 0xA8, 0x9B, 0xBB, 0xD9, 0xE5, 0xD8, 0xDA,
	0xEC, 0x08, 0x29, 0x41, 0x2C, 0x08, 0xE9, 0xDB, 0xF9, 0x22, 0x37, 0x41, 0x32, 0x1A, 0x22, 0x3C,
	0x5F, 0x4E, 0x18, 0xDE, 0xA1, 0x84, 0x86, 0xA4, 0xC8, 0xE9, 0xF6, 0xFF, 0x0E, 0x21, 0x42, 0x4E,
	0x35, 0xFF, 0xC1, 0xC0, 0xED, 0x20, 0x55, 0x67, 0x3E, 0x14, 0xED, 0xD9, 0xCC, 0xC2, 0xB5, 0xA9,
	0x94, 0x9C, 0xBA, 0xE7, 0x20, 0x2B, 0x13, 0xF6, 0xDC, 0xF1, 0x32, 0x57, 0x5F, 0x3F, 0x2C, 0x2A,
	0x2A, 0x2A, 0x1F, 0xF7, 0xDE, 0xD8, 0xCD, 0xDC, 0xEF, 0xF7, 0xFB, 0xE1, 0xBC, 0xB7, 0xD7, 0x15,
	0x31, 0x26, 0x0B, 0xEE, 0xF8, 0x35, 0x5F, 0x64, 0x53, 0x33, 0x15, 0x03, 0xF6, 0xF1, 0xE7, 0xD3,
	0xB8, 0x8E, 0x89, 0xA8, 0xDE, 0x26, 0x40, 0x1A, 0xED, 0xCC, 0xC6, 0xD9, 0xEE, 0xFB, 0x01, 0x0B,
	0x2E, 0x4A, 0x58, 0x6C, 0x53, 0x27, 0xF5, 0xBC, 0xA0, 0xAF, 0xC2, 0xD6, 0xDC, 0xEC, 0x05, 0x1D,
	0x3D, 0x42, 0x20, 0x0B, 0xFD, 0xEF, 0xFE, 0x12, 0x1F, 0x22, 0x0F, 0xFB, 0x05, 0x23, 0x4F, 0x55,
	0x31, 0xF6, 0xAF, 0x8C, 0x9B, 0xB1, 0xD0, 0xF2, 0xFF, 0x01, 0x03, 0x1E, 0x4A, 0x66, 0x60, 0x2E,
	0xD5, 0xAB, 0xAE, 0xD9, 0x1F, 0x38, 0x1E, 0x07, 0xF3, 0xE6, 0xDD, 0xD4, 0xCE, 0xBC, 0xAD, 0xAC,
	0xAD, 0xC4, 0x02, 0x26, 0x2E, 0x25, 0x0B, 0x13, 0x38, 0x49, 0x41, 0x25, 0x17, 0x1B, 0x23, 0x2B,
	0x15, 0xE7, 0xDE, 0xEB, 0xEB, 0xF7, 0xFE, 0x01, 0x04, 0xE6, 0xC4, 0xBD, 0xD6, 0x16, 0x36, 0x31,
	0x12, 0xE6, 0xF1, 0x34, 0x5C, 0x55, 0x3A, 0x0F, 0xEF, 0xE1, 0xE6, 0xF8, 0x03, 0x01, 0xEB, 0xB7,
	0xA2, 0xAB, 0xD9, 0x2A, 0x4A, 0x24, 0xF5, 0xDB, 0xD8, 0xE2, 0xEC, 0xF2, 0xE3, 0xE2, 0xFA, 0x09,
	0x15, 0x2F, 0x36, 0x31, 0x19, 0xE5, 0xC7, 0xC3, 0xCA, 0xD2, 0xD8, 0xEB, 0x08, 0x29, 0x55, 0x5F,
	0x3A, 0x23, 0x1B, 0x0B, 0x0B, 0x0A, 0x04, 0xF8, 0xDC, 0xCF, 0xDF, 0x08, 0x3C, 0x47, 0x2F, 0x00,
	0xBA, 0xA5, 0xC7, 0xDE, 0xE0, 0xE3, 0xDE, 0xE0, 0xEF, 0x1B, 0x56, 0x77, 0x76, 0x48, 0xFA, 0xCB,
	0xBD, 0xD0, 0x02, 0x0D, 0xF0, 0xE0, 0xE9, 0xFB, 0x04, 0x01, 0xFE, 0xE6, 0xD3, 0xCD, 0xB8, 0xB3,
	0xD3, 0xF0, 0x0A, 0x13, 0x03, 0x13, 0x3B, 0x50, 0x3F, 0x1C, 0x08, 0x08, 0x12, 0x23, 0x0B, 0xD5,
	0xCF, 0xF1, 0x0A, 0x1F, 0x23, 0x1B, 0x10, 0xEE, 0xCD, 0xC3, 0xDB, 0x0C, 0x29, 0x27, 0x0A, 0xD6,
	0xDB, 0x25, 0x51, 0x4D, 0x32, 0x0A, 0xEE, 0xE6, 0xF4, 0x07, 0x0A, 0x04, 0xEF, 0xC7, 0xB0, 0xAE,
	0xCB, 0x13, 0x39, 0x22, 0x05, 0xF8, 0xF7, 0xFB, 0xFA, 0xEF, 0xD5, 0xD0, 0xF3, 0x08, 0x14, 0x2B,
	0x33, 0x30, 0x24, 0xFC, 0xE0, 0xD5, 0xCA, 0xBD, 0xB8, 0xC9, 0xE9, 0x15, 0x4D, 0x5B, 0x30, 0x1A,
	0x1A, 0x17, 0x1A, 0x18, 0x07, 0xF2, 0xD6, 0xCF, 0xEB, 0x18, 0x44, 0x50, 0x40, 0x1A, 0xD6, 0xB8,
	0xD0, 0xD8, 0xCC, 0xC9, 0xC8, 0xD1, 0xE6, 0x10, 0x47, 0x67, 0x71, 0x4F, 0x09, 0xD3, 0xBA, 0xBF,
	0xEC, 0x04, 0xF2, 0xEA, 0xFB, 0x0A, 0x0E, 0x05, 0xF7, 0xDC, 0xCB, 0xCB, 0xBA, 0xB4, 0xD5, 0xFB,
	0x1C, 0x29, 0x1C, 0x20, 0x3B, 0x48, 0x31, 0x13, 0x01, 0x02, 0x14, 0x2F, 0x22, 0xE9, 0xD4, 0xE6,
	0xF5, 0x01, 0x07, 0x06, 0x00, 0xED, 0xD6, 0xCE, 0xE6, 0x12, 0x2F, 0x31, 0x15, 0xDF, 0xD9, 0x16,
	0x42, 0x3F, 0x2A, 0x0E, 0xF8, 0xED, 0xF5, 0xFF, 0x01, 0x04, 0xF0, 0xC7, 0xA8, 0xA1, 0xC0, 0x09,
	0x37, 0x29, 0x0B, 0x01, 0xFD, 0xFE, 0xFF, 0xF4, 0xD9, 0xD1, 0xE9, 0xFA, 0x07, 0x21, 0x31, 0x34,
	0x29, 0x07, 0xE9, 0xDF, 0xD5, 0xC2, 0xB9, 0xC6, 0xE2, 0x0D, 0x47, 0x5B, 0x3C, 0x28, 0x28, 0x1E,
	0x0F, 0x05, 0xFA, 0xEF, 0xE2, 0xD7, 0xE2, 0x0D, 0x3A, 0x51, 0x4B, 0x24, 0xE0, 0xC0, 0xD6, 0xE0,
	0xCE, 0xC2, 0xC8, 0xDB, 0xF5, 0x19, 0x39, 0x51, 0x60, 0x48, 0x14, 0xDE, 0xBA, 0xBE, 0xE8, 0x01,
	0xEF, 0xE3, 0xF7, 0x0E, 0x17, 0x16, 0x06, 0xE8, 0xD8, 0xD1, 0xBA, 0xAC, 0xBC, 0xE7, 0x12, 0x29,
	0x24, 0x1D, 0x31, 0x3F, 0x2C, 0x11, 0xFF, 0xF5, 0xFC, 0x15, 0x14, 0xF2, 0xEF, 0x0B, 0x1A, 0x14,
	0x03, 0xFB, 0xFB, 0xFC, 0xED, 0xDD, 0xE7, 0xFE, 0x18, 0x28, 0x1D, 0xF6, 0xE3, 0x0D, 0x2E, 0x28,
	0x18, 0x0E, 0x02, 0xFC, 0xFE, 0xFF, 0xFC, 0x01, 0xEE, 0xD0, 0xB3, 0xA8, 0xBF, 0xFC, 0x27, 0x1D,
	0xFF, 0xF3, 0xF1, 0xEA, 0xF0, 0xF6, 0xEB, 0xE8, 0xF2, 0xF3, 0xFD, 0x12, 0x30, 0x40, 0x39, 0x19,
	0xF4, 0xE3, 0xDD, 0xCC, 0xC8, 0xDD, 0xEE, 0x0A, 0x2E, 0x3C, 0x28, 0x20, 0x26, 0x26, 0x11, 0xFA,
	0xF1, 0xEB, 0xEA, 0xEA, 0xF3, 0x19, 0x3A, 0x46, 0x45, 0x23, 0xEC, 0xCC, 0xD6, 0xDE, 0xD1, 0xC6,
	0xD6, 0xE7, 0xF8, 0x10, 0x21, 0x32, 0x46, 0x37, 0x14, 0xE8, 0xC5, 0xC2, 0xE3, 0x01, 0xFD, 0xF5,
	0xFD, 0x0A, 0x04, 0x02, 0xFE, 0xEC, 0xE2, 0xDD, 0xC2, 0xB2, 0xBA, 0xE2, 0x0F, 0x23, 0x20, 0x13,
	0x18, 0x2B, 0x29, 0x1E, 0x18, 0x08, 0x02, 0x0D, 0x0A, 0xF6, 0xFC, 0x13, 0x27, 0x17, 0xFF, 0xF3,
	0xEF, 0xF8, 0xF8, 0xE5, 0xE4, 0xF0, 0xFF, 0x15, 0x13, 0xFB, 0xF1, 0x09, 0x24, 0x28, 0x19, 0x17,
	0x0E, 0x01, 0xFD, 0xF6, 0xF5, 0x06, 0x00, 0xEC, 0xD1, 0xBC, 0xCC, 0xF9, 0x1E, 0x1C, 0xFF, 0xEB,
	0xE6, 0xDE, 0xE9, 0xF3, 0xF1, 0xF0, 0xF5, 0xED, 0xF1, 0x03, 0x27, 0x40, 0x37, 0x16, 0xEE, 0xDE,
	0xE1, 0xDE, 0xD6, 0xDC, 0xE5, 0xFA, 0x1F, 0x30, 0x2A, 0x2B, 0x2F, 0x30, 0x15, 0xF6, 0xEB, 0xEB,
	0xF5, 0xFF, 0xFD, 0x10, 0x2C, 0x3E, 0x43, 0x2A, 0xFA, 0xDA, 0xD8, 0xDD, 0xD1, 0xC1, 0xCD, 0xE1,
	0xF6, 0x12, 0x1F, 0x29, 0x39, 0x32, 0x18, 0xEF, 0xCB, 0xC8, 0xE0, 0xF8, 0xFA, 0xF3, 0xFF, 0x19,
	0x1F, 0x1C, 0x10, 0xF3, 0xE2, 0xD9, 0xBC, 0xA2, 0x9D, 0xBF, 0xF6, 0x1A, 0x29, 0x25, 0x20, 0x26,
	0x24, 0x16, 0x0C, 0xFE, 0xFA, 0x07, 0x0A, 0x01, 0x0C, 0x25, 0x3F, 0x38, 0x1B, 0x02, 0xEA, 0xE6,
	0xEA, 0xE2, 0xE1, 0xED, 0xFD, 0x12, 0x13, 0x04, 0xFE, 0x0A, 0x19, 0x18, 0x05, 0x00, 0xFF, 0xFA,
	0x01, 0xFD, 0xF7, 0x04, 0x0A, 0xFF, 0xE6, 0xCA, 0xCE, 0xE4, 0xFE, 0x09, 0x00, 0xFB, 0x02, 0xFE,
	0xFC, 0xFE, 0xF1, 0xF5, 0xFB, 0xEF, 0xE4, 0xE5, 0x02, 0x27, 0x32, 0x2C, 0x12, 0xF7, 0xEB, 0xE0,
	0xD1, 0xD3, 0xD9, 0xED, 0x0E, 0x1B, 0x1A, 0x21, 0x32, 0x44, 0x38, 0x14, 0xF7, 0xDD, 0xDE, 0xF1,
	0xFD, 0x11, 0x2A, 0x37, 0x3B, 0x23, 0xFF, 0xEF, 0xEF, 0xED, 0xD6, 0xB4, 0xAD, 0xC6, 0xE6, 0x12,
	0x20, 0x1E, 0x2A, 0x32, 0x2B, 0x0C, 0xE3, 0xD6, 0xD8, 0xE2, 0xEF, 0xF2, 0xFE, 0x18, 0x20, 0x1A,
	0x0A, 0xF0, 0xEB, 0xEC, 0xD7, 0xB8, 0xA4, 0xB3, 0xE6, 0x12, 0x30, 0x33, 0x21, 0x1D, 0x19, 0x10,
	0x14, 0x13, 0x0D, 0x0C, 0xFB, 0xEF, 0xF4, 0x0C, 0x2D, 0x31, 0x15, 0xFF, 0xE9, 0xED, 0xFE, 0xFD,
	0xF7, 0xF3, 0xF2, 0xFD, 0x01, 0x00, 0x0A, 0x16, 0x24, 0x25, 0x12, 0x0B, 0x06, 0xFA, 0xF9, 0xE9,
	0xE1, 0xEF, 0xFE, 0x00, 0xF2, 0xDC, 0xE0, 0xEB, 0xF5, 0xFB, 0xF3, 0xF0, 0xFF, 0xFB, 0xF7, 0xF8,
	0xF3, 0x03, 0x0C, 0xFE, 0xEF, 0xE8, 0xF8, 0x1C, 0x23, 0x21, 0x10, 0xFA, 0xF3, 0xE6, 0xCE, 0xD1,
	0xE1, 0xFF, 0x1C, 0x1A, 0x0F, 0x0B, 0x19, 0x34, 0x36, 0x17, 0xFD, 0xE1, 0xE2, 0xF8, 0x05, 0x14,
	0x2B, 0x33, 0x30, 0x14, 0xF7, 0xF3, 0xF9, 0x01, 0xF2, 0xC9, 0xB8, 0xC6, 0xE0, 0x07, 0x11, 0x0C,
	0x14, 0x23, 0x26, 0x18, 0xF9, 0xE8, 0xE0, 0xD9, 0xDA, 0xDB, 0xEE, 0x12, 0x21, 0x1A, 0x0C, 0xFB,
	0xFE, 0x03, 0xF2, 0xD0, 0xAD, 0xAA, 0xD1, 0xFB, 0x20, 0x2E, 0x22, 0x1B, 0x15, 0x08, 0x07, 0x0D,
	0x10, 0x14, 0x02, 0xF5, 0xF5, 0x09, 0x28, 0x32, 0x1C, 0x08, 0xF4, 0xF7, 0x08, 0x08, 0xFA, 0xF6,
	0xF2, 0xF3, 0xF1, 0xED, 0xFC, 0x08, 0x18, 0x1E, 0x0B, 0xFF, 0x00, 0x01, 0x04, 0xF7, 0xEA, 0xEC,
	0xFB, 0x00, 0xF8, 0xEF, 0xF0, 0xF7, 0xF7, 0xF7, 0xEB, 0xEC, 0xFF, 0x0B, 0x04, 0xF8, 0xE9, 0xEE,
	0xF7, 0xF7, 0xEE, 0xEB, 0xF7, 0x10, 0x1D, 0x22, 0x1E, 0x0E, 0x04, 0xF8, 0xDE, 0xD0, 0xE0, 0xFF,
	0x1D, 0x20, 0x17, 0x10, 0x14, 0x28, 0x2F, 0x18, 0xF8, 0xDD, 0xDA, 0xF3, 0x08, 0x0F, 0x1F, 0x26,
	0x1C, 0x07, 0xF6, 0xF8, 0x02, 0x0B, 0x02, 0xDE, 0xC2, 0xC9, 0xE6, 0x08, 0x10, 0x02, 0xFE, 0x0D,
	0x18, 0x17, 0x06, 0xF1, 0xE2, 0xD6, 0xDB, 0xE2, 0xEB, 0x09, 0x25, 0x27, 0x1A, 0x09, 0x03, 0x05,
	0xF9, 0xDD, 0xC1, 0xB7, 0xCC, 0xF1, 0x15, 0x25, 0x15, 0x06, 0x05, 0x00, 0xFB, 0x02, 0x07, 0x07,
	0xFC, 0xF7, 0xFF, 0x0F, 0x24, 0x34, 0x2C, 0x15, 0x04, 0x03, 0x13, 0x17, 0x01, 0xF1, 0xEC, 0xEA,
	0xED, 0xF5, 0x05, 0x0C, 0x12, 0x17, 0x0F, 0xFB, 0xF2, 0xF1, 0xF3, 0xEE, 0xE8, 0xEF, 0x05, 0x10,
	0x0A, 0x02, 0xFA, 0xF4, 0xEC, 0xED, 0xE9, 0xE3, 0xEC, 0x01, 0x0B, 0x08, 0x01, 0xFB, 0xF5, 0xED,
	0xE5, 0xEA, 0xF8, 0x07, 0x16, 0x1B, 0x1B, 0x0E, 0x05, 0x02, 0xED, 0xD5, 0xD6, 0xEF, 0x0D, 0x1A,
	0x1E, 0x1A, 0x15, 0x17, 0x1D, 0x18, 0x04, 0xF1, 0xEC, 0xFA, 0x0B, 0x0B, 0x15, 0x23, 0x1C, 0x08,
	0xF8, 0xF6, 0x00, 0x0A, 0x09, 0xF6, 0xD6, 0xCA, 0xDF, 0xFC, 0x09, 0x04, 0xFB, 0x06, 0x10, 0x10,
	0x0D, 0x02, 0xEE, 0xDB, 0xD5, 0xD7, 0xDE, 0xF6, 0x19, 0x2D, 0x24, 0x12, 0x03, 0xFB, 0xF4, 0xDF,
	0xCB, 0xC3, 0xCA, 0xE9, 0x0C, 0x21, 0x1E, 0x11, 0x10, 0x0B, 0xFE, 0xF9, 0xFF, 0xFF, 0xFB, 0xFF,
	0x06, 0x13, 0x1C, 0x25, 0x2A, 0x1B, 0x0D, 0x09, 0x15, 0x1B, 0x0A, 0xF9, 0xF3, 0xEE, 0xE9, 0xF0,
	0xFC, 0x03, 0x07, 0x0C, 0x0D, 0x04, 0xF3, 0xF4, 0xF6, 0xEF, 0xE6, 0xE2, 0xF3, 0x03, 0x06, 0x0D,
	0x11, 0x0B, 0x00, 0xF6, 0xEE, 0xE9, 0xEB, 0xFB, 0x09, 0x03, 0xFA, 0xF2, 0xEA, 0xE9, 0xE7, 0xEF,
	0xFD, 0xFF, 0x01, 0x03, 0x06, 0x08, 0x07, 0x06, 0xFB, 0xE6, 0xDF, 0xF2, 0x07, 0x17, 0x20, 0x1D,
	0x1B, 0x16, 0x10, 0x0D, 0xFC, 0xEC, 0xED, 0xF9, 0x08, 0x0D, 0x0D, 0x17, 0x18, 0x0E, 0x0B, 0x0E,
	0x12, 0x10, 0x04, 0xF3, 0xE0, 0xD5, 0xE7, 0xFE, 0x08, 0x04, 0xF6, 0xF5, 0xFE, 0x01, 0x03, 0x01,
	0xEF, 0xD9, 0xCE, 0xD1, 0xE7, 0x01, 0x1F, 0x33, 0x2B, 0x16, 0x03, 0xF5, 0xF4, 0xEA, 0xE0, 0xDE,
	0xDD, 0xEC, 0xFE, 0x0D, 0x11, 0x0A, 0x04, 0x03, 0xFB, 0xEE, 0xED, 0xF0, 0xFC, 0x0C, 0x17, 0x1F,
	0x20, 0x1A, 0x1F, 0x19, 0x11, 0x0D, 0x10, 0x17, 0x11, 0xFE, 0xF6, 0xF4, 0xF2, 0xF6, 0xFF, 0xFE,
	0xF9, 0xF5, 0xF9, 0xFF, 0xF5, 0xF4, 0xFA, 0xFC, 0xFE, 0xFB, 0xFF, 0x0B, 0x0C, 0x0A, 0x0B, 0x02,
	0xF5, 0xEC, 0xEB, 0xED, 0xEF, 0xF7, 0x0A, 0x0A, 0xFC, 0xEA, 0xDB, 0xDC, 0xE6, 0xF3, 0x04, 0x08,
	0x07, 0x0B, 0x10, 0x13, 0x11, 0x09, 0x03, 0xF4, 0xE1, 0xE3, 0xF0, 0x07, 0x1E, 0x25, 0x1F, 0x0D,
	0xFB, 0xFC, 0xFA, 0xF3, 0xF6, 0xFC, 0x0A, 0x10, 0x10, 0x10, 0x15, 0x13, 0x15, 0x13, 0x0E, 0x02,
	0xF7, 0xF3, 0xF0, 0xE3, 0xE9, 0xFA, 0x04, 0x02, 0xF5, 0xEF, 0xF5, 0xFF, 0x08, 0x0B, 0xFD, 0xEA,
	0xE1, 0xE2, 0xED, 0xF9, 0x09, 0x23, 0x24, 0x13, 0xFC, 0xE9, 0xE5, 0xE9, 0xEC, 0xEE, 0xE8, 0xE8,
	0xF1, 0xFA, 0x00, 0x00, 0x01, 0x08, 0x0B, 0xFB, 0xF3, 0xF1, 0xFE, 0x15, 0x24, 0x27, 0x1B, 0x0B,
	0x09, 0x06, 0x05, 0x0C, 0x14, 0x18, 0x0F, 0xFA, 0xE9, 0xEA, 0xF3, 0x01, 0x05, 0xFF, 0xF7, 0xF7,
	0x05, 0x0E, 0x05, 0x00, 0x03, 0x03, 0xFE, 0xF3, 0xED, 0xF2, 0x01, 0x0B, 0x11, 0x07, 0xF7, 0xEB,
	0xE5, 0xE4, 0xE3, 0xEA, 0x03, 0x11, 0x07, 0xF1, 0xE0, 0xE0, 0xF4, 0x0B, 0x15, 0x0D, 0x01, 0xFD,
	0x01, 0x06, 0x09, 0x09, 0x09, 0x04, 0xF1, 0xE5, 0xE9, 0xFC, 0x11, 0x19, 0x11, 0xFF, 0xF7, 0x00,
	0x04, 0x02, 0x01, 0x09, 0x17, 0x1F, 0x1B, 0x0A, 0x03, 0x01, 0x07, 0x0A, 0x09, 0x05, 0x01, 0xFF,
	0xF9, 0xE7, 0xE5, 0xF5, 0x01, 0xFD, 0xEF, 0xE3, 0xE5, 0xFD, 0x13, 0x19, 0x0B, 0xF7, 0xEA, 0xE9,
	0xF1, 0xF9, 0x01, 0x15, 0x1E, 0x0F, 0xF9, 0xE9, 0xE8, 0xF3, 0xFB, 0xF4, 0xE8, 0xE5, 0xEE, 0xF8,
	0xFE, 0xFF, 0xFF, 0x06, 0x0D, 0x04, 0xF7, 0xF8, 0x09, 0x1F, 0x29, 0x23, 0x12, 0x09, 0x09, 0x07,
	0xFD, 0xFD, 0x06, 0x10, 0x14, 0x03, 0xE9, 0xE2, 0xEE, 0x00, 0x09, 0x04, 0xFF, 0x00, 0x09, 0x0F,
	0x01, 0xF7, 0xFF, 0x06, 0x05, 0xF9, 0xEB, 0xEC, 0x03, 0x13, 0x13, 0x04, 0xF1, 0xE5, 0xDD, 0xDD,
	0xDD, 0xE7, 0x03, 0x1A, 0x11, 0xF7, 0xE1, 0xE5, 0xFD, 0x15, 0x13, 0x01, 0xF5, 0xF6, 0xFD, 0x05,
	0x0A, 0x08, 0x08, 0x09, 0xF9, 0xE7, 0xEA, 0x01, 0x1A, 0x23, 0x16, 0xFE, 0xF6, 0x00, 0x07, 0x04,
	0x04, 0x0E, 0x1C, 0x27, 0x22, 0x06, 0xF7, 0xF9, 0xFE, 0x02, 0x00, 0xFC, 0xFA, 0xFF, 0xFE, 0xF2,
	0xEB, 0xF9, 0x06, 0x03, 0xF3, 0xE1, 0xDD, 0xF8, 0x12, 0x16, 0x0B, 0xFC, 0xEF, 0xE9, 0xEF, 0xF4,
	0xFD, 0x10, 0x1B, 0x0B, 0xE9, 0xD6, 0xD5, 0xE8, 0xFD, 0xFA, 0xF2, 0xF1, 0xFC, 0x04, 0x09, 0x0B,
	0x05, 0x06, 0x0B, 0x01, 0xED, 0xEE, 0x0B, 0x23, 0x30, 0x27, 0x11, 0x05, 0x04, 0x00, 0xF8, 0xF4,
	0xFE, 0x0C, 0x15, 0x0F, 0xF5, 0xED, 0xFD, 0x0A, 0x0B, 0x04, 0x01, 0x01, 0x0B, 0x0E, 0xFE, 0xEF,
	0xF4, 0x03, 0x07, 0xFE, 0xE8, 0xE1, 0xF8, 0x0F, 0x11, 0x05, 0xF4, 0xE5, 0xDC, 0xDF, 0xE1, 0xEA,
	0x04, 0x1D, 0x18, 0xFC, 0xE7, 0xE6, 0xFC, 0x12, 0x0B, 0xFA, 0xEE, 0xF0, 0xFA, 0x03, 0x09, 0x03,
	0x01, 0x06, 0xFD, 0xE9, 0xEB, 0x05, 0x1D, 0x23, 0x16, 0xFC, 0xF2, 0xF9, 0x07, 0x0D, 0x0D, 0x12,
	0x1B, 0x27, 0x27, 0x0B, 0xF7, 0xF9, 0xF8, 0xF7, 0xF3, 0xF6, 0xF7, 0x01, 0x03, 0xFB, 0xF3, 0xFD,
	0x0B, 0x0A, 0xF8, 0xDF, 0xD4, 0xEE, 0x0C, 0x13, 0x11, 0x07, 0xF9, 0xF1, 0xF3, 0xF7, 0xFF, 0x0D,
	0x1B, 0x06, 0xE1, 0xCD, 0xCF, 0xE6, 0x00, 0x01, 0xF5, 0xF3, 0xFA, 0x03, 0x05, 0x05, 0xFD, 0xF9,
	0x01, 0xFD, 0xEA, 0xF3, 0x12, 0x2C, 0x35, 0x28, 0x10, 0x04, 0x03, 0x06, 0xFF, 0xF7, 0xFA, 0x06,
	0x15, 0x15, 0xFD, 0xEE, 0xFF, 0x09, 0x06, 0x00, 0xFC, 0xFE, 0x08, 0x09, 0xFB, 0xEE, 0xF3, 0x05,
	0x0A, 0x01, 0xEC, 0xE5, 0xFD, 0x13, 0x10, 0x02, 0xF3, 0xE9, 0xE2, 0xE2, 0xE0, 0xE5, 0xFD, 0x1C,
	0x1C, 0xFE, 0xE8, 0xE6, 0xFC, 0x14, 0x11, 0xFD, 0xF4, 0xF3, 0xF9, 0xFB, 0xFD, 0xF8, 0xF9, 0x04,
	0x02, 0xEA, 0xEC, 0x07, 0x1E, 0x25, 0x16, 0xF8, 0xEB, 0xF3, 0x00, 0x0A, 0x11, 0x1E, 0x28, 0x33,
	0x2E, 0x0F, 0xF8, 0xFE, 0x01, 0xF7, 0xEE, 0xEB, 0xF2, 0x03, 0x09, 0x01, 0xF3, 0xF3, 0xFC, 0xFA,
	0xEF, 0xDC, 0xD5, 0xED, 0x0C, 0x10, 0x0D, 0x0A, 0x08, 0x02, 0xFC, 0xF6, 0xF4, 0x03, 0x1B, 0x15,
	0xF0, 0xD7, 0xCE, 0xE2, 0xFE, 0x03, 0xF7, 0xF5, 0xF3, 0xF5, 0xF6, 0xFE, 0x03, 0x08, 0x10, 0x03,
	0xE5, 0xE5, 0x06, 0x27, 0x37, 0x2B, 0x0C, 0xFE, 0xFE, 0x04, 0x09, 0x06, 0x07, 0x08, 0x0B, 0x08,
	0xF4, 0xEB, 0x04, 0x15, 0x0D, 0x01, 0xF9, 0x02, 0x11, 0x14, 0x04, 0xF0, 0xED, 0xFF, 0x07, 0x03,
	0xEE, 0xE2, 0xF6, 0x11, 0x0D, 0x01, 0xF7, 0xED, 0xE1, 0xD8, 0xD5, 0xDD, 0xF9, 0x1C, 0x1F, 0x00,
	0xE7, 0xE1, 0xF9, 0x1B, 0x1E, 0x0B, 0xFC, 0xF4, 0xF0, 0xF1, 0xFA, 0x01, 0x0A, 0x10, 0x06, 0xE5,
	0xDB, 0xF6, 0x14, 0x24, 0x17, 0xF8, 0xE8, 0xED, 0xFD, 0x0D, 0x16, 0x1F, 0x23, 0x26, 0x23, 0x0A,
	0xF7, 0x03, 0x0C, 0xFF, 0xF2, 0xEC, 0xF3, 0x04, 0x10, 0x0B, 0xFD, 0xF7, 0xFE, 0x00, 0xF9, 0xE8,
	0xDA, 0xEA, 0x03, 0x07, 0x04, 0x0B, 0x0D, 0x08, 0xFB, 0xEE, 0xE9, 0xF8, 0x10, 0x11, 0xED, 0xD3,
	0xC9, 0xE0, 0x04, 0x13, 0x0C, 0x03, 0xF8, 0xEC, 0xE7, 0xEE, 0xFC, 0x08, 0x12, 0x09, 0xEA, 0xE2,
	0x02, 0x27, 0x3C, 0x31, 0x11, 0xF9, 0xF2, 0xF8, 0x01, 0x07, 0x10, 0x11, 0x10, 0x09, 0xF7, 0xEF,
	0x05, 0x15, 0x09, 0xFA, 0xF2, 0xF9, 0x07, 0x0F, 0x07, 0xF6, 0xF1, 0x01, 0x0C, 0x0F, 0xFD, 0xEC,
	0xF3, 0x07, 0x0A, 0x03, 0x01, 0xFB, 0xF2, 0xE5, 0xDD, 0xDE, 0xF3, 0x14, 0x1B, 0xFE, 0xE2, 0xD4,
	0xE6, 0x07, 0x17, 0x0E, 0x00, 0xF2, 0xE8, 0xE6, 0xEF, 0x01, 0x11, 0x1B, 0x14, 0xF3, 0xE3, 0xF7,
	0x10, 0x21, 0x1A, 0xFD, 0xE6, 0xE4, 0xF4, 0x09, 0x19, 0x25, 0x28, 0x26, 0x1C, 0x02, 0xF2, 0xFF,
	0x0D, 0x08, 0xFC, 0xF1, 0xF4, 0x05, 0x15, 0x15, 0x04, 0xF6, 0xF7, 0xF7, 0xF6, 0xE9, 0xDE, 0xE3,
	0xF6, 0xFC, 0xFB, 0x03, 0x0A, 0x0D, 0x05, 0xF9, 0xF1, 0xFA, 0x13, 0x18, 0xFC, 0xDF, 0xCD, 0xD4,
	0xF4, 0x0F, 0x13, 0x0B, 0xFB, 0xEA, 0xE2, 0xE4, 0xF4, 0x02, 0x0D, 0x05, 0xE6, 0xDB, 0xF6, 0x1E,
	0x3D, 0x40, 0x26, 0x08, 0xF7, 0xFA, 0x04, 0x0D, 0x11, 0x0E, 0x08, 0x01, 0xF5, 0xF2, 0x07, 0x1A,
	0x14, 0x02, 0xF0, 0xEE, 0xF9, 0x07, 0x04, 0xF5, 0xEE, 0xF7, 0x06, 0x12, 0x0E, 0xFE, 0xFB, 0x02,
	0x04, 0xFD, 0xFB, 0xFA, 0xF3, 0xE9, 0xE2, 0xDE, 0xEF, 0x0D, 0x19, 0x08, 0xEE, 0xDB, 0xE2, 0xFE,
	0x11, 0x13, 0x05, 0xF6, 0xE9, 0xE5, 0xEC, 0xFD, 0x0E, 0x1A, 0x16, 0xF9, 0xE5, 0xEE, 0x02, 0x17,
	0x13, 0xFF, 0xE9, 0xE2, 0xF1, 0x06, 0x19, 0x27, 0x2A, 0x25, 0x1E, 0x0A, 0xFC, 0x04, 0x11, 0x0D,
	0xFD, 0xEF, 0xF1, 0xFE, 0x10, 0x18, 0x0B, 0xFD, 0xF6, 0xF5, 0xF6, 0xEE, 0xE0, 0xDE, 0xE7, 0xEF,
	0xF5, 0x02, 0x12, 0x19, 0x13, 0x09, 0xFB, 0xF8, 0x08, 0x0B, 0xF7, 0xDB, 0xCB, 0xD4, 0xF2, 0x11,
	0x1E, 0x19, 0x0A, 0xF1, 0xE2, 0xDE, 0xE7, 0xF2, 0xFE, 0xFD, 0xEA, 0xE2, 0xF6, 0x1C, 0x37, 0x39,
	0x24, 0x07, 0xF3, 0xF2, 0xF8, 0x05, 0x0D, 0x0C, 0x0B, 0x0E, 0x06, 0x01, 0x0C, 0x1C, 0x18, 0x06,
	0xF6, 0xF2, 0xF5, 0xFB, 0xFE, 0xF4, 0xF1, 0xF9, 0x09, 0x14, 0x13, 0x03, 0xFE, 0xFE, 0xFD, 0xF4,
	0xF1, 0xF1, 0xF2, 0xEB, 0xE7, 0xE6, 0xEF, 0x05, 0x15, 0x0E, 0xF8, 0xE3, 0xE3, 0xF2, 0x02, 0x09,
	0x05, 0xFF, 0xF2, 0xE9, 0xE9, 0xF4, 0x04, 0x13, 0x19, 0x07, 0xF3, 0xEF, 0xFF, 0x10, 0x12, 0x03,
	0xF0, 0xE3, 0xE8, 0xF8, 0x11, 0x27, 0x30, 0x2E, 0x26, 0x12, 0x00, 0x00, 0x09, 0x09, 0xFB, 0xEC,
	0xEB, 0xF9, 0x0C, 0x1B, 0x17, 0x0A, 0xFC, 0xF5, 0xF3, 0xEF, 0xE4, 0xDF, 0xE2, 0xE7, 0xEC, 0xFD,
	0x14, 0x22, 0x1F, 0x10, 0x00, 0xF6, 0xFC, 0x01, 0xF7, 0xDE, 0xCB, 0xCC, 0xE5, 0x04, 0x17, 0x1B,
	0x13, 0xFF, 0xE9, 0xE0, 0xE2, 0xEA, 0xF4, 0xF7, 0xEE, 0xE7, 0xF5, 0x17, 0x37, 0x40, 0x2F, 0x15,
	0xFC, 0xF4, 0xF6, 0x00, 0x06, 0x09, 0x05, 0x06, 0x06, 0x06, 0x10, 0x1C, 0x1E, 0x0E, 0xF9, 0xF0,
	0xF1, 0xF9, 0x01, 0xFE, 0xFA, 0xF9, 0x00, 0x0A, 0x10, 0x08, 0x01, 0xFE, 0xFA, 0xF0, 0xEB, 0xED,
	0xF2, 0xF2, 0xED, 0xE9, 0xE9, 0xFD, 0x0E, 0x13, 0x06, 0xF3, 0xEA, 0xF2, 0xFE, 0x05, 0x01, 0xFB,
	0xF1, 0xEA, 0xE9, 0xF2, 0xFD, 0x0B, 0x13, 0x0B, 0xFA, 0xEE, 0xF2, 0x03, 0x0C, 0x07, 0xF8, 0xE9,
	0xED, 0xFD, 0x18, 0x2A, 0x30, 0x2B, 0x22, 0x16, 0x09, 0x07, 0x0A, 0x0A, 0xFF, 0xEF, 0xEA, 0xF6,
	0x0A, 0x1C, 0x1A, 0x0B, 0xFB, 0xF3, 0xF3, 0xF7, 0xEE, 0xE4, 0xDF, 0xE3, 0xEB, 0xFA, 0x0D, 0x1D,
	0x1E, 0x14, 0x03, 0xF5, 0xF2, 0xF7, 0xFA, 0xEB, 0xD7, 0xD0, 0xDF, 0xFB, 0x14, 0x1B, 0x13, 0x02,
	0xF3, 0xE8, 0xE8, 0xED, 0xF1, 0xF2, 0xEE, 0xE9, 0xF0, 0x0A, 0x26, 0x32, 0x2A, 0x14, 0xFE, 0xF7,
	0xFD, 0x05, 0x07, 0x01, 0xFB, 0xFF, 0x08, 0x12, 0x1A, 0x22, 0x23, 0x17, 0x03, 0xF7, 0xF7, 0xFE,
	0x04, 0xFF, 0xF6, 0xF0, 0xF8, 0x06, 0x10, 0x0E, 0x05, 0xFD, 0xF9, 0xF5, 0xEC, 0xE9, 0xEB, 0xEE,
	0xEE, 0xED, 0xEF, 0xFA, 0x08, 0x12, 0x0D, 0xFD, 0xF0, 0xEF, 0xF8, 0xFE, 0xFA, 0xF3, 0xEB, 0xE9,
	0xEA, 0xF3, 0xFF, 0x06, 0x0D, 0x0A, 0x00, 0xF3, 0xF4, 0x02, 0x0C, 0x0A, 0xFB, 0xEE, 0xF1, 0x03,
	0x19, 0x28, 0x2A, 0x24, 0x19, 0x11, 0x09, 0x06, 0x03, 0x05, 0xFC, 0xED, 0xE7, 0xF4, 0x0B, 0x22,
	0x26, 0x17, 0x00, 0xF3, 0xF6, 0xFD, 0xFF, 0xF0, 0xE3, 0xDE, 0xE7, 0xF6, 0x0B, 0x1B, 0x20, 0x13,
	0xFF, 0xF0, 0xE8, 0xEB, 0xF1, 0xED, 0xDC, 0xD4, 0xDA, 0xF5, 0x10, 0x1F, 0x1B, 0x0D, 0xFA, 0xEE,
	0xEB, 0xEF, 0xF1, 0xF0, 0xEF, 0xF1, 0xF6, 0x09, 0x22, 0x2D, 0x29, 0x12, 0xFB, 0xF1, 0xF4, 0xFC,
	0x03, 0x00, 0xFE, 0xFD, 0x07, 0x17, 0x21, 0x24, 0x24, 0x15, 0xFD, 0xF1, 0xF1, 0xFB, 0x03, 0x02,
	0xF9, 0xF0, 0xF4, 0x04, 0x11, 0x17, 0x0B, 0xFA, 0xF0, 0xEC, 0xEA, 0xF1, 0xF9, 0xFD, 0xF9, 0xF1,
	0xEF, 0xF5, 0x02, 0x14, 0x12, 0xFD, 0xEB, 0xE3, 0xEC, 0xFB, 0x00, 0xFB, 0xF3, 0xE8, 0xE7, 0xEC,
	0xF8, 0x04, 0x08, 0x0B, 0x03, 0xF3, 0xF3, 0x02, 0x10, 0x13, 0x04, 0xF4, 0xF1, 0x00, 0x17, 0x28,
	0x28, 0x1F, 0x12, 0x0B, 0x0D, 0x0B, 0x08, 0x06, 0xF8, 0xE8, 0xE3, 0xEC, 0x07, 0x1F, 0x26, 0x19,
	0xFF, 0xF2, 0xF6, 0xFE, 0x04, 0xF8, 0xE4, 0xDC, 0xE0, 0xF1, 0x0B, 0x1D, 0x23, 0x17, 0x01, 0xF1,
	0xE7, 0xE8, 0xF3, 0xEF, 0xDF, 0xD3, 0xD5, 0xEF, 0x0F, 0x21, 0x1F, 0x0D, 0xF7, 0xEC, 0xEB, 0xF2,
	0xF6, 0xF1, 0xED, 0xEE, 0xF0, 0x01, 0x1B, 0x2A, 0x2B, 0x14, 0xFD, 0xF2, 0xF6, 0x00, 0x07, 0x00,
	0xFB, 0xF7, 0x02, 0x18, 0x28, 0x2D, 0x2A, 0x1A, 0x05, 0xF6, 0xF1, 0xFB, 0x01, 0xFF, 0xF3, 0xE7,
	0xEB, 0x01, 0x14, 0x1F, 0x19, 0x00, 0xEC, 0xE4, 0xE2, 0xEA, 0xF3, 0xF8, 0xF8, 0xF3, 0xF3, 0xFB,
	0x09, 0x1B, 0x1C, 0x07, 0xF1, 0xE0, 0xE2, 0xF2, 0xFA, 0xF8, 0xF1, 0xE8, 0xE7, 0xEE, 0xF9, 0x06,
	0x09, 0x09, 0x06, 0xF7, 0xF1, 0xFD, 0x08, 0x0F, 0x04, 0xF6, 0xF3, 0x03, 0x1A, 0x29, 0x26, 0x19,
	0x09, 0x03, 0x0A, 0x0F, 0x09, 0x04, 0xF8, 0xEB, 0xE8, 0xF2, 0x09, 0x1E, 0x25, 0x17, 0xFB, 0xEB,
	0xF2, 0x01, 0x0C, 0x05, 0xEB, 0xD8, 0xDA, 0xEC, 0x06, 0x1B, 0x1F, 0x13, 0xFF, 0xF1, 0xE7, 0xE7,
	0xF2, 0xF7, 0xE8, 0xDA, 0xD5, 0xE9, 0x0C, 0x23, 0x25, 0x15, 0xFC, 0xF1, 0xED, 0xF1, 0xF4, 0xE8,
	0xE4, 0xE9, 0xEF, 0xFB, 0x12, 0x1F, 0x23, 0x15, 0x02, 0xF7, 0xFC, 0x05, 0x0D, 0x04, 0xF9, 0xF3,
	0xFB, 0x16, 0x2A, 0x30, 0x2A, 0x1B, 0x05, 0xF8, 0xF4, 0xFD, 0x03, 0x02, 0xF5, 0xE7, 0xE3, 0xF8,
	0x11, 0x21, 0x1E, 0x05, 0xED, 0xE4, 0xE3, 0xEC, 0xF6, 0xFD, 0xFC, 0xF4, 0xF3, 0xF3, 0xFB, 0x0E,
	0x18, 0x0B, 0xF5, 0xE4, 0xE5, 0xF5, 0xFF, 0xFB, 0xF0, 0xE5, 0xE6, 0xF1, 0xFF, 0x0A, 0x09, 0x09,
	0x08, 0xFD, 0xF4, 0xFA, 0x05, 0x0A, 0x00, 0xF1, 0xEC, 0xFD, 0x19, 0x2D, 0x2A, 0x18, 0x03, 0xFC,
	0x0A, 0x13, 0x12, 0x0B, 0x02, 0xF6, 0xF0, 0xF5, 0x08, 0x19, 0x21, 0x14, 0xF8, 0xE6, 0xEC, 0x01,
	0x10, 0x0A, 0xEC, 0xD5, 0xD8, 0xE9, 0x03, 0x13, 0x19, 0x11, 0x03, 0xF7, 0xEF, 0xED, 0xF6, 0xFC,
	0xEE, 0xDC, 0xD6, 0xE3, 0x01, 0x1A, 0x1B, 0x0A, 0xF5, 0xED, 0xEE, 0xF2, 0xF4, 0xEA, 0xE7, 0xED,
	0xF5, 0xFF, 0x11, 0x20, 0x25, 0x1B, 0x0A, 0x02, 0x03, 0x0C, 0x10, 0x03, 0xF4, 0xEC, 0xF5, 0x0F,
	0x25, 0x27, 0x21, 0x17, 0x09, 0xFB, 0xF7, 0xFD, 0x01, 0x01, 0xF9, 0xEC, 0xEA, 0xFD, 0x17, 0x26,
	0x22, 0x07, 0xEC, 0xE3, 0xE2, 0xE7, 0xEE, 0xF8, 0xFD, 0xF9, 0xF7, 0xF3, 0xF7, 0x07, 0x15, 0x0D,
	0xF7, 0xE5, 0xE1, 0xEF, 0xFD, 0xFF, 0xF8, 0xF3, 0xF3, 0xF5, 0xF8, 0xFD, 0xFD, 0x00, 0x03, 0xFC,
	0xF1, 0xEF, 0xFD, 0x06, 0x04, 0xF8, 0xF4, 0x01, 0x19, 0x27, 0x25, 0x15, 0x05, 0x01, 0x0F, 0x18,
	0x15, 0x0D, 0x07, 0x02, 0xFA, 0xF9, 0x03, 0x10, 0x19, 0x13, 0xFB, 0xE7, 0xE9, 0xFD, 0x0F, 0x0F,
	0xF4, 0xDC, 0xD7, 0xE6, 0xF9, 0x09, 0x12, 0x13, 0x08, 0xFD, 0xF3, 0xEE, 0xF8, 0x04, 0xFF, 0xEA,
	0xDB, 0xDD, 0xF4, 0x0D, 0x14, 0x0A, 0xFD, 0xF5, 0xF3, 0xF3, 0xF3, 0xEA, 0xE7, 0xEF, 0xF6, 0xF9,
	0x00, 0x0F, 0x19, 0x19, 0x10, 0x06, 0x04, 0x0D, 0x11, 0x06, 0xF6, 0xEF, 0xF4, 0x0D, 0x21, 0x27,
	0x22, 0x1A, 0x11, 0x04, 0xFB, 0xFB, 0x01, 0x02, 0xFB, 0xEC, 0xE5, 0xF3, 0x0D, 0x21, 0x22, 0x0E,
	0xF5, 0xE8, 0xE7, 0xEB, 0xEF, 0xF7, 0xFB, 0xF9, 0xF4, 0xF0, 0xF2, 0x02, 0x13, 0x13, 0xFD, 0xE8,
	0xE0, 0xE8, 0xF6, 0xFD, 0xFA, 0xF7, 0xF8, 0xFB, 0xFE, 0xFF, 0xFE, 0x00, 0x05, 0x02, 0xF4, 0xED,
	0xF5, 0x01, 0x05, 0xFE, 0xF9, 0xFF, 0x0F, 0x1B, 0x19, 0x0B, 0x00, 0x00, 0x0D, 0x1A, 0x1A, 0x13,
	0x0E, 0x09, 0xFF, 0xFB, 0x01, 0x10, 0x1C, 0x1A, 0x04, 0xEB, 0xE8, 0xFB, 0x0C, 0x0E, 0xF8, 0xE0,
	0xD8, 0xE3, 0xF5, 0x05, 0x11, 0x14, 0x0E, 0xFF, 0xF3, 0xE9, 0xF0, 0xFE, 0x03, 0xF3, 0xE3, 0xE1,
	0xF0, 0x03, 0x0E, 0x09, 0xFD, 0xF6, 0xF1, 0xED, 0xEA, 0xE7, 0xE9, 0xF6, 0xFD, 0xFD, 0xFF, 0x0B,
	0x16, 0x18, 0x11, 0x08, 0x08
};

const uint8 SfxPlayer::_musicDataSample4[] = {
	0x01, 0xF8, 0x00, 0x40, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x0E, 0x0D, 0xF4, 0x0F, 0xFF, 0x0C,
	0x10, 0xE1, 0xC9, 0xD5, 0xF2, 0x17, 0x2C, 0x05, 0x1B, 0x50, 0x1D, 0x1F, 0x40, 0x1B, 0x09, 0x2B,
	0xFE, 0xE0, 0x0A, 0x27, 0xDF, 0xEB, 0x1F, 0x41, 0x56, 0x2E, 0x06, 0xEC, 0xC0, 0xA7, 0xCF, 0xE5,
	0x24, 0x2C, 0x2B, 0x53, 0x36, 0x2C, 0x15, 0x1F, 0x1E, 0x18, 0x18, 0x15, 0xD9, 0xD6, 0x03, 0xEE,
	0xEF, 0x3F, 0x38, 0x36, 0x36, 0x0F, 0xE8, 0xC9, 0xC6, 0xE0, 0x21, 0xF7, 0x08, 0x3C, 0x45, 0x14,
	0x33, 0x37, 0x2A, 0x17, 0x03, 0x21, 0x10, 0x15, 0xFC, 0xCD, 0xD5, 0xF6, 0x12, 0x46, 0x24, 0xFC,
	0xF3, 0x22, 0x0A, 0xD7, 0xE8, 0x02, 0xF9, 0x0C, 0x3D, 0x46, 0x25, 0x16, 0x30, 0x0C, 0xF2, 0x16,
	0x35, 0xF8, 0xF1, 0x01, 0x03, 0x07, 0xF6, 0x11, 0x08, 0x0E, 0x14, 0x1F, 0x0F, 0xF5, 0xFD, 0x03,
	0x0E, 0xE3, 0x11, 0x2B, 0x26, 0x23, 0x21, 0x18, 0xFF, 0x11, 0x0C, 0x08, 0x07, 0x05, 0x06, 0x0A,
	0x18, 0x0F, 0x0F, 0x0E, 0x0C, 0x05, 0x12, 0x2C, 0x01, 0xFD, 0x05, 0xF6, 0xF6, 0x15, 0x29, 0x1B,
	0x0C, 0x09, 0x2A, 0x12, 0x08, 0x14, 0x00, 0xF8, 0x03, 0x26, 0x14, 0x11, 0x0C, 0x1E, 0x00, 0xFA,
	0x14, 0x15, 0x0A, 0x04, 0x07, 0x05, 0x08, 0x09, 0x18, 0x03, 0x09, 0x1A, 0x1A, 0x21, 0x12, 0x11,
	0x06, 0x01, 0x0C, 0xF3, 0x1D, 0x1F, 0x15, 0x10, 0x11, 0x10, 0x05, 0x06, 0x15, 0x02, 0xF7, 0x0C,
	0x17, 0x16, 0x01, 0xFB, 0x09, 0x01, 0x13, 0x2D, 0x28, 0x0E, 0x07, 0x1C, 0xFB, 0x01, 0x17, 0x19,
	0x02, 0x07, 0x15, 0x14, 0x0D, 0x14, 0xFD, 0xF6, 0x05, 0x16, 0x23, 0x10, 0x0E, 0x08, 0xFD, 0x09,
	0x0B, 0x16, 0x1A, 0x11, 0x13, 0x07, 0x10, 0x18, 0x0B, 0x02, 0x0D, 0x0E, 0x13, 0x1E, 0x23, 0x0C,
	0xF8, 0x00, 0x05, 0x09, 0x06, 0x1A, 0x1B, 0x01, 0x0C, 0x0C, 0x08, 0x0C, 0x17, 0x18, 0x08, 0x0C,
	0x19, 0x13, 0x06, 0x06, 0x04, 0x04, 0x11, 0x23, 0x21, 0x14, 0x0C, 0x09, 0x03, 0x08, 0x0E, 0x12,
	0x08, 0x0A, 0x0A, 0x02, 0x10, 0x15, 0x0C, 0x0A, 0x0F, 0x16, 0x1F, 0x1C, 0x14, 0x05, 0xF5, 0x02,
	0x16, 0x14, 0x17, 0x1C, 0x1B, 0x08, 0x06, 0x0F, 0x0A, 0x03, 0x0C, 0x14, 0x09, 0x0E, 0x1B, 0x09,
	0xFB, 0x05, 0x0F, 0x10, 0x1D, 0x21, 0x1B, 0x09, 0x09, 0x02, 0x06, 0x07, 0x0E, 0x16, 0x10, 0x15,
	0x17, 0x0E, 0x0D, 0x0A, 0x08, 0x02, 0x0F, 0x21, 0x16, 0x0C, 0x09, 0x03, 0xFC, 0x07, 0x19, 0x19,
	0x0F, 0x22, 0x17, 0x06, 0x03, 0x0C, 0x0D, 0xFE, 0x11, 0x1C, 0x13, 0x14, 0x17, 0x0D, 0xFC, 0xFD,
	0x16, 0x16, 0x14, 0x19, 0x10, 0x02, 0x00, 0x0A, 0x0C, 0x0A, 0x17, 0x15, 0x16, 0x11, 0x12, 0x14,
	0x04, 0xFF, 0x0C, 0x10, 0x11, 0x1D, 0x1A, 0x0A, 0x06, 0x0E, 0x00, 0x07, 0x16, 0x12, 0x0F, 0x0F,
	0x12, 0x07, 0x02, 0x13, 0x0A, 0x09, 0x15, 0x1B, 0x19, 0x0D, 0x0C, 0x07, 0x00, 0x07, 0x15, 0x17,
	0x10, 0x14, 0x19, 0x06, 0x02, 0x10, 0x0C, 0x0A, 0x0F, 0x15, 0x11, 0x0C, 0x12, 0x0D, 0x06, 0x06,
	0x0E, 0x17, 0x13, 0x12, 0x16, 0x0A, 0x06, 0x0E, 0x12, 0x0C, 0x13, 0x1C, 0x0C, 0x0C, 0x14, 0x0C,
	0x07, 0x0F, 0x0D, 0x07, 0x0F, 0x19, 0x11, 0x0F, 0x10, 0x0D, 0x09, 0x0B, 0x13, 0x14, 0x10, 0x0E,
	0x11, 0x0A, 0x07, 0x0B, 0x17, 0x0F, 0x0D, 0x17, 0x14, 0x0B, 0x10, 0x11, 0x06, 0x06, 0x10, 0x13,
	0x0F, 0x10, 0x13, 0x0E, 0x07, 0x0E, 0x13, 0x0E, 0x0D, 0x13, 0x0F, 0x0E, 0x15, 0x11, 0x0B, 0x0D,
	0x0F, 0x0A, 0x0E, 0x14, 0x14, 0x0C, 0x0F, 0x0B, 0x0B, 0x11, 0x13, 0x10, 0x0C, 0x0B, 0x0F, 0x10,
	0x10
};

const uint8 SfxPlayer::_musicDataSample5[] = {
	0x09, 0xE4, 0x00, 0x40, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
	0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x08, 0x0C, 0x0C, 0x0C, 0x10, 0x14, 0x28, 0x28, 0x28,
	0x28, 0x2C, 0x28, 0x24, 0x24, 0x1C, 0x1C, 0x1C, 0x10, 0x14, 0x14, 0x10, 0x10, 0x08, 0x08, 0x04,
	0x0C, 0x00, 0x0C, 0x04, 0x04, 0x04, 0x14, 0x04, 0x00, 0x14, 0x1C, 0x0C, 0x00, 0xF4, 0xE4, 0xC4,
	0xB8, 0xB4, 0xB0, 0xA8, 0xA4, 0xA0, 0xA0, 0xA0, 0xA4, 0xB0, 0xC4, 0xCC, 0xD4, 0xDC, 0xE0, 0xE8,
	0xEC, 0xF4, 0xF8, 0xFC, 0x04, 0x04, 0x24, 0x3C, 0x3C, 0x44, 0x50, 0x5C, 0x5C, 0x5C, 0x64, 0x68,
	0x68, 0x5C, 0x64, 0x64, 0x6C, 0x68, 0x6C, 0x78, 0x74, 0x68, 0x64, 0x6C, 0x6C, 0x58, 0x68, 0x58,
	0x34, 0x38, 0x48, 0x58, 0x58, 0x3C, 0x08, 0xDC, 0xC4, 0x9C, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x8C, 0x98, 0x9C, 0xA4, 0xA8, 0xBC, 0xD0, 0xD8, 0xF0, 0x08, 0x0C,
	0x0C, 0x10, 0x18, 0x20, 0x28, 0x48, 0x5C, 0x6C, 0x7C, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C, 0x7F,
	0x7F, 0x74, 0x68, 0x5C, 0x4C, 0x3C, 0x2C, 0x28, 0x2C, 0x30, 0x34, 0x34, 0x24, 0x1C, 0x14, 0x1C,
	0x20, 0x20, 0x0C, 0x00, 0xF4, 0xE4, 0xCC, 0xBC, 0xB4, 0xB4, 0xA8, 0x94, 0x80, 0x80, 0x80, 0x80,
	0x84, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x84, 0x84, 0x8C, 0xA0, 0xC0, 0xD4, 0xD0, 0xE4, 0xEC, 0xF0,
	0xF8, 0x10, 0x20, 0x4C, 0x64, 0x68, 0x6C, 0x78, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x6C, 0x64, 0x58,
	0x34, 0x2C, 0x34, 0x38, 0x2C, 0x14, 0x14, 0x20, 0x2C, 0x38, 0x34, 0x34, 0x3C, 0x3C, 0x3C, 0x2C,
	0x38, 0x54, 0x70, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x74, 0x78, 0x78, 0x7C, 0x6C, 0x74, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x74, 0x4C, 0x4C, 0x4C, 0x30, 0x14, 0x14, 0x04, 0x10, 0x1C, 0xF4, 0xCC, 0xAC, 0x84, 0x88, 0x80,
	0x80, 0x80, 0x84, 0xA8, 0x80, 0x80, 0x80, 0x84, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xAC,
	0x80, 0x80, 0xA4, 0xFC, 0x14, 0x00, 0x00, 0xF8, 0x3C, 0x70, 0x64, 0x30, 0xEC, 0x34, 0x7F, 0x44,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x70, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x70, 0x68, 0x4C, 0x68, 0x7F, 0x7F, 0x7F, 0x48, 0x3C, 0x44, 0x2C, 0x5C,
	0x68, 0x30, 0x18, 0x30, 0xF8, 0x44, 0x4C, 0x54, 0x48, 0x20, 0x14, 0xEC, 0xE0, 0xF4, 0x0C, 0x20,
	0xFC, 0x1C, 0x1C, 0x04, 0x5C, 0x3C, 0x14, 0x40, 0xCC, 0xBC, 0xF4, 0x00, 0x2C, 0xEC, 0xEC, 0x84,
	0x80, 0x9C, 0xCC, 0x90, 0x80, 0x8C, 0x80, 0x80, 0x80, 0xB4, 0xEC, 0x90, 0xC4, 0x38, 0xAC, 0xBC,
	0xAC, 0x80, 0x84, 0xA4, 0x94, 0xCC, 0xCC, 0xD4, 0x10, 0x94, 0xA4, 0xDC, 0xAC, 0xCC, 0x08, 0xF4,
	0xE4, 0x04, 0xEC, 0x4C, 0x0C, 0x04, 0x34, 0x28, 0x24, 0x50, 0x28, 0x18, 0x1C, 0x00, 0x0C, 0x1C,
	0x48, 0x74, 0x54, 0x3C, 0x1C, 0xE0, 0xCC, 0x04, 0xD8, 0xD4, 0xD8, 0xF4, 0x48, 0x44, 0x3C, 0x54,
	0x3C, 0x7F, 0x40, 0x1C, 0x6C, 0x6C, 0x7F, 0x7F, 0x5C, 0x64, 0x48, 0x50, 0x20, 0x00, 0x30, 0x0C,
	0x14, 0x28, 0x2C, 0x50, 0x70, 0x6C, 0x54, 0x54, 0x6C, 0x54, 0x28, 0x5C, 0x3C, 0x7F, 0x74, 0x7F,
	0x7F, 0x5C, 0x7C, 0x58, 0x58, 0x3C, 0xD8, 0x10, 0xCC, 0xCC, 0xA0, 0x88, 0xA4, 0xBC, 0x8C, 0xCC,
	0xF0, 0xC8, 0xB0, 0x8C, 0xBC, 0xD4, 0x80, 0x80, 0x94, 0x94, 0x84, 0xA8, 0x80, 0xF8, 0xD0, 0xE0,
	0xBC, 0x80, 0x80, 0xB4, 0x84, 0xD4, 0x9C, 0xA0, 0xD4, 0xC8, 0x00, 0xCC, 0x14, 0xD4, 0x08, 0xE8,
	0x44, 0x4C, 0xEC, 0x10, 0x1C, 0x04, 0x24, 0x50, 0x2C, 0x54, 0x64, 0x74, 0x3C, 0x24, 0x00, 0x20,
	0x24, 0x50, 0x78, 0x68, 0x24, 0x28, 0x44, 0x5C, 0x58, 0x54, 0x5C, 0x7C, 0x7F, 0x64, 0xFC, 0x2C,
	0x08, 0x58, 0x24, 0x50, 0xD4, 0x04, 0x48, 0x4C, 0x50, 0x4C, 0xE0, 0xDC, 0xDC, 0x4C, 0xD8, 0x28,
	0x60, 0xC8, 0x2C, 0xCC, 0x94, 0xC0, 0x5C, 0x54, 0x44, 0x1C, 0xEC, 0x24, 0xF0, 0xCC, 0x1C, 0xE4,
	0x7F, 0x1C, 0xD4, 0xAC, 0xA0, 0x9C, 0xEC, 0xD8, 0x1C, 0xF8, 0x20, 0x04, 0xD8, 0xD8, 0xE4, 0xC4,
	0x14, 0xCC, 0xD4, 0xD0, 0xA0, 0xDC, 0xB8, 0x80, 0xE8, 0x00, 0x2C, 0xEC, 0xE4, 0x24, 0x7F, 0xE8,
	0x14, 0xD4, 0xDC, 0xF4, 0xEC, 0x44, 0x74, 0x1C, 0xA0, 0x9C, 0xCC, 0xCC, 0x04, 0xC4, 0x14, 0x6C,
	0x7F, 0x10, 0xA0, 0x1C, 0x7F, 0x58, 0x44, 0x58, 0x4C, 0x1C, 0x08, 0x34, 0xF4, 0xCC, 0x10, 0xE4,
	0xF8, 0x50, 0x18, 0x10, 0x3C, 0x0C, 0x30, 0x44, 0xCC, 0xD4, 0x48, 0x70, 0xC8, 0x20, 0x54, 0x0C,
	0xD0, 0xF8, 0x60, 0xAC, 0xE4, 0xE8, 0x38, 0xE8, 0xFC, 0xF4, 0xD4, 0x34, 0x54, 0x0C, 0x14, 0x74,
	0x44, 0x14, 0x0C, 0x00, 0x0C, 0xC8, 0x34, 0x54, 0x6C, 0x7F, 0x30, 0xE8, 0x18, 0xD0, 0xB0, 0x08,
	0x20, 0xD0, 0x38, 0x34, 0xCC, 0x7F, 0x1C, 0x14, 0x2C, 0x30, 0xDC, 0xE0, 0xF4, 0x34, 0x28, 0xC8,
	0xAC, 0xA8, 0x14, 0xAC, 0x90, 0xBC, 0xCC, 0xD4, 0xD4, 0xD4, 0xE4, 0x0C, 0x14, 0xFC, 0xD0, 0xEC,
	0x1C, 0x24, 0x0C, 0x08, 0xEC, 0x14, 0x70, 0x2C, 0xC4, 0x84, 0xCC, 0xA4, 0x2C, 0x24, 0xA0, 0x0C,
	0x74, 0x04, 0xE4, 0x0C, 0x04, 0xDC, 0x1C, 0xF4, 0xD4, 0xFC, 0xCC, 0x94, 0xD4, 0x54, 0x24, 0x08,
	0xCC, 0xD4, 0xF4, 0x44, 0x54, 0x0C, 0x18, 0x28, 0xF0, 0x18, 0x68, 0x28, 0x60, 0x6C, 0x44, 0xC4,
	0x14, 0x64, 0x74, 0x7C, 0x5C, 0x7F, 0x7F, 0x7F, 0x20, 0x58, 0x7F, 0x28, 0x7F, 0x58, 0x68, 0x18,
	0x54, 0x04, 0x08, 0xE4, 0x14, 0x34, 0x08, 0xDC, 0xE4, 0x08, 0x3C, 0x24, 0xAC, 0xEC, 0xF4, 0xCC,
	0xF4, 0x1C, 0xE4, 0x0C, 0xF4, 0xD0, 0xE8, 0xD0, 0xDC, 0xBC, 0xA0, 0xEC, 0xB4, 0xB4, 0x28, 0xD8,
	0xF4, 0xDC, 0xBC, 0x28, 0x44, 0xF0, 0xF8, 0xE0, 0xFC, 0xC8, 0x1C, 0x4C, 0xEC, 0x00, 0xF8, 0x00,
	0xC8, 0xCC, 0xDC, 0xBC, 0xD0, 0xAC, 0xE0, 0xCC, 0xF4, 0xF8, 0xF0, 0x08, 0x10, 0x1C, 0xEC, 0x30,
	0x28, 0x44, 0x34, 0x90, 0x34, 0x3C, 0xC4, 0xE0, 0xCC, 0x00, 0x34, 0xF8, 0x34, 0xB4, 0x34, 0x3C,
	0x34, 0xEC, 0xFC, 0x7C, 0x34, 0xCC, 0x0C, 0x4C, 0x10, 0x44, 0x20, 0x14, 0x3C, 0x78, 0x64, 0x50,
	0x20, 0x4C, 0x7F, 0x20, 0x24, 0x34, 0x0C, 0x1C, 0x28, 0x04, 0x48, 0x04, 0x5C, 0x60, 0x10, 0x1C,
	0x18, 0x10, 0xEC, 0x20, 0x10, 0xAC, 0xE0, 0x10, 0x0C, 0xD0, 0xCC, 0x24, 0xE4, 0xBC, 0xE8, 0x58,
	0x00, 0xBC, 0x00, 0x4C, 0xF4, 0xBC, 0xF4, 0x28, 0xDC, 0xB4, 0xEC, 0x24, 0xF0, 0x04, 0xE4, 0xB0,
	0xF0, 0xB0, 0xC8, 0x3C, 0x2C, 0xB8, 0xB8, 0xDC, 0xF0, 0x10, 0xD8, 0xEC, 0x2C, 0x08, 0xF8, 0xC8,
	0xF4, 0x2C, 0x0C, 0x0C, 0x10, 0xE0, 0xDC, 0x28, 0x1C, 0x20, 0x38, 0xFC, 0x34, 0xF4, 0x08, 0x3C,
	0x64, 0x2C, 0xC4, 0xE4, 0xE4, 0xCC, 0x08, 0x7F, 0x3C, 0xEC, 0x14, 0xD8, 0x14, 0x48, 0x1C, 0x74,
	0x1C, 0x18, 0x74, 0x34, 0xF4, 0xE0, 0x44, 0x44, 0x58, 0x4C, 0x50, 0x28, 0x4C, 0x48, 0x08, 0x08,
	0x40, 0x64, 0x3C, 0x2C, 0x14, 0x4C, 0x40, 0x5C, 0x10, 0xFC, 0x3C, 0x28, 0xF4, 0xF4, 0x08, 0xEC,
	0x00, 0x34, 0x28, 0x80, 0xF0, 0xDC, 0xF4, 0xFC, 0xD4, 0xF0, 0x34, 0xE8, 0xEC, 0xBC, 0x90, 0x88,
	0x34, 0xF4, 0x9C, 0xAC, 0xC4, 0xDC, 0xD4, 0xCC, 0xF4, 0xE4, 0xE4, 0x2C, 0xD4, 0x08, 0xEC, 0x3C,
	0x10, 0x14, 0x24, 0x00, 0x44, 0x34, 0x2C, 0xF8, 0x0C, 0x1C, 0x44, 0x5C, 0xFC, 0x24, 0x14, 0xD4,
	0x24, 0x7F, 0xF0, 0x34, 0xE4, 0xC8, 0xE8, 0xF0, 0x2C, 0xDC, 0x0C, 0x28, 0xA4, 0xBC, 0x14, 0x60,
	0xF4, 0x2C, 0xF4, 0xE8, 0x14, 0xE8, 0x1C, 0x04, 0x28, 0x60, 0x0C, 0x0C, 0x28, 0x44, 0x3C, 0x18,
	0x4C, 0x4C, 0x68, 0x04, 0xE8, 0x28, 0x0C, 0x2C, 0x7C, 0x58, 0x5C, 0x4C, 0x68, 0x7F, 0x60, 0x6C,
	0x30, 0xEC, 0x0C, 0xFC, 0xE0, 0x30, 0x34, 0x00, 0x08, 0x1C, 0xF8, 0xAC, 0xCC, 0x0C, 0x08, 0x2C,
	0xE8, 0x08, 0x0C, 0xB4, 0xD4, 0xC4, 0x00, 0xEC, 0xCC, 0xE4, 0x10, 0xE4, 0xF8, 0xA0, 0xAC, 0xD0,
	0xF4, 0x14, 0x04, 0xC4, 0xE8, 0xDC, 0x00, 0x08, 0xF0, 0xD0, 0xD8, 0xD4, 0x10, 0xE0, 0x08, 0x1C,
	0xF8, 0xCC, 0xF4, 0xF8, 0x14, 0x04, 0x1C, 0x20, 0x04, 0xD8, 0xEC, 0x00, 0x14, 0x14, 0xEC, 0x24,
	0xF4, 0x10, 0x04, 0xC4, 0x14, 0x30, 0x28, 0x3C, 0xCC, 0x30, 0x44, 0x44, 0x10, 0x3C, 0x4C, 0x0C,
	0x4C, 0x2C, 0x48, 0x50, 0x5C, 0x2C, 0x24, 0x7F, 0x48, 0x4C, 0x24, 0x30, 0x18, 0x40, 0x24, 0x0C,
	0xF4, 0x44, 0x30, 0x48, 0x28, 0x18, 0xFC, 0xDC, 0xDC, 0x34, 0xFC, 0xE8, 0xEC, 0x4C, 0x50, 0xF4,
	0xE8, 0x20, 0x18, 0x0C, 0x20, 0x20, 0x2C, 0xE8, 0xEC, 0x10, 0xE0, 0xFC, 0x1C, 0x3C, 0x24, 0x1C,
	0x3C, 0x1C, 0x0C, 0x1C, 0xBC, 0xAC, 0x04, 0x50, 0x14, 0xE4, 0xF8, 0xEC, 0xCC, 0xE4, 0xD4, 0xE0,
	0xD8, 0xF4, 0xF4, 0xD4, 0xB4, 0xBC, 0xC8, 0xFC, 0xCC, 0xD0, 0xEC, 0xE4, 0xF0, 0xEC, 0xCC, 0xD0,
	0xE0, 0x94, 0xB8, 0xE8, 0x24, 0x04, 0xCC, 0x0C, 0xE4, 0xEC, 0xD4, 0x00, 0xE4, 0x08, 0x18, 0x00,
	0xEC, 0xEC, 0xEC, 0x28, 0xD4, 0xEC, 0x2C, 0x44, 0x44, 0x2C, 0x30, 0x54, 0x78, 0x70, 0x3C, 0x34,
	0x7C, 0x7F, 0x44, 0x2C, 0x5C, 0x54, 0x4C, 0x44, 0x5C, 0x20, 0x14, 0x1C, 0x5C, 0x78, 0x34, 0x3C,
	0x34, 0x40, 0x40, 0x54, 0x3C, 0x04, 0x14, 0x14, 0x2C, 0x2C, 0x2C, 0x2C, 0x0C, 0xD4, 0x34, 0x08,
	0xE4, 0x00, 0x14, 0x14, 0x04, 0x0C, 0xDC, 0xE4, 0xF4, 0x24, 0xEC, 0xC8, 0xB4, 0xCC, 0xD8, 0xBC,
	0xD0, 0xE0, 0xEC, 0xC4, 0xF8, 0xC4, 0xE4, 0xD4, 0xC4, 0x14, 0xF4, 0xDC, 0xDC, 0xB0, 0xA0, 0xE4,
	0x0C, 0xF8, 0x0C, 0xEC, 0xB4, 0xAC, 0xEC, 0x0C, 0xD8, 0x1C, 0x30, 0x3C, 0x0C, 0xD4, 0x0C, 0xF8,
	0xF4, 0xFC, 0x28, 0x3C, 0x28, 0x30, 0x3C, 0x38, 0x04, 0x04, 0xF4, 0x18, 0x50, 0x0C, 0xF8, 0x24,
	0xF0, 0x34, 0x20, 0x0C, 0x08, 0xF4, 0x18, 0xD8, 0xDC, 0x14, 0x24, 0xEC, 0x04, 0x2C, 0xF8, 0x30,
	0x1C, 0x2C, 0x0C, 0x0C, 0x1C, 0x18, 0x24, 0x34, 0x3C, 0x2C, 0x38, 0x3C, 0x1C, 0x38, 0x3C, 0x28,
	0x58, 0x54, 0x24, 0x24, 0x44, 0x30, 0x10, 0xEC, 0x2C, 0x1C, 0x1C, 0x14, 0xF8, 0x0C, 0x08, 0x00,
	0x04, 0xF8, 0xE8, 0x00, 0x14, 0xDC, 0xF4, 0xE4, 0xDC, 0xF0, 0xF4, 0xEC, 0xE4, 0x20, 0x1C, 0xE4,
	0x00, 0xDC, 0xF4, 0xF4, 0xE8, 0xF8, 0x28, 0x14, 0x00, 0x04, 0x5C, 0x1C, 0xE0, 0x04, 0xF0, 0xF4,
	0x0C, 0x24, 0xE4, 0xF0, 0xDC, 0xF4, 0xF8, 0xE0, 0x0C, 0xEC, 0xEC, 0xF8, 0xE4, 0xD4, 0x08, 0x04,
	0xE4, 0xF0, 0x14, 0xF4, 0xF4, 0xF0, 0x08, 0x08, 0x04, 0x04, 0xE4, 0xE8, 0xFC, 0x14, 0x14, 0x0C,
	0x24, 0x2C, 0x34, 0x14, 0x0C, 0x0C, 0x2C, 0x14, 0xF8, 0x1C, 0x10, 0x0C, 0x14, 0x14, 0x1C, 0x44,
	0x30, 0x14, 0x1C, 0x04, 0x24, 0x44, 0x18, 0x24, 0x1C, 0xFC, 0xF0, 0xEC, 0xFC, 0xEC, 0x0C, 0xF8,
	0x04, 0xFC, 0xF0, 0xE8, 0x0C, 0x2C, 0x20, 0xE4, 0xFC, 0x18, 0xF4, 0xFC, 0x0C, 0x18, 0x08, 0xF0,
	0x04, 0x0C, 0x00, 0x0C, 0x0C, 0x28, 0x1C, 0xF4, 0x08, 0x0C, 0x10, 0x14, 0x1C, 0x28, 0x2C, 0xFC,
	0x1C, 0x18, 0x10, 0x04, 0x0C, 0x24, 0x34, 0x14, 0x0C, 0x1C, 0x1C, 0x00, 0xE4, 0xFC, 0x0C, 0x28,
	0xF0, 0xEC, 0xE8, 0xFC, 0x00, 0xE4, 0x00, 0xF4, 0x24, 0x18, 0xE0, 0x0C, 0xFC, 0xF0, 0x14, 0x04,
	0x14, 0xE8, 0xEC, 0x0C, 0x08, 0x10, 0x00, 0xF0, 0xEC, 0x04, 0x14, 0xEC, 0x1C, 0x10, 0x0C, 0x14,
	0xE0, 0xF4, 0x00, 0x18, 0x04, 0xFC, 0xE4, 0xE4, 0xE0, 0x00, 0x04, 0xF0, 0xF0, 0x10, 0x00, 0x04,
	0x10, 0x0C, 0x1C, 0x08, 0x00, 0x10, 0x04, 0x0C, 0xF8, 0x04, 0x14, 0x04, 0xFC, 0x20, 0x24, 0x14,
	0x1C, 0x2C, 0x1C, 0xF0, 0x28, 0x44, 0x0C, 0x14, 0x40, 0x34, 0x1C, 0x08, 0x0C, 0x28, 0x20, 0x20,
	0x14, 0x0C, 0x04, 0x0C, 0x2C, 0x1C, 0x0C, 0x04, 0x10, 0x18, 0x14, 0x10, 0x2C, 0x2C, 0x1C, 0x04,
	0x00, 0xFC, 0x18, 0x10, 0x1C, 0x24, 0x0C, 0x28, 0x14, 0x04, 0xF8, 0x1C, 0x0C, 0x18, 0x18, 0xF8,
	0xFC, 0x08, 0xD4, 0xFC, 0xEC, 0xE4, 0xE0, 0xF4, 0x0C, 0xE8, 0xE8, 0xE8, 0xBC, 0xEC, 0x04, 0xEC,
	0xEC, 0xE0, 0xE4, 0x04, 0x10, 0x0C, 0xF8, 0xF8, 0xEC, 0xDC, 0xF4, 0x0C, 0x0C, 0xF4, 0x0C, 0x04,
	0xF0, 0xFC, 0x0C, 0x20, 0x14, 0x1C, 0x28, 0x34, 0x28, 0x18, 0x20, 0x54, 0x3C, 0x1C, 0x24, 0x24,
	0x28, 0x3C, 0x28, 0x1C, 0x18, 0x1C, 0x14, 0x00, 0x0C, 0x14, 0xF0, 0xFC, 0x24, 0x0C, 0x00, 0xF4,
	0x04, 0x24, 0x1C, 0xF4, 0x08, 0xEC, 0xF4, 0x0C, 0xF8, 0xEC, 0xF4, 0x0C, 0xF4, 0xEC, 0xEC, 0x18,
	0x18, 0x08, 0xE0, 0xF4, 0x0C, 0x20, 0x0C, 0x00, 0x00, 0x10, 0x1C, 0x00, 0xEC, 0x0C, 0x10, 0x14,
	0x10, 0x0C, 0xF8, 0xF8, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x04, 0x1C, 0x30, 0x24, 0x0C, 0xE4, 0xF4,
	0x08, 0x14, 0x0C, 0x00, 0x00, 0x0C, 0x08, 0x00, 0xEC, 0x04, 0x1C, 0x14, 0x08, 0x1C, 0x24, 0x2C,
	0x18, 0x10, 0x20, 0x0C, 0x20, 0x3C, 0x24, 0x20, 0x20, 0x38, 0x38, 0x18, 0x14, 0x1C, 0x18, 0x24,
	0x2C, 0x0C, 0x14, 0x24, 0x00, 0xEC, 0xF4, 0xEC, 0xD8, 0xD8, 0xE8, 0xE0, 0xB4, 0xC4, 0xF0, 0xEC,
	0xD0, 0xD4, 0xE0, 0xE4, 0xE0, 0xE4, 0xDC, 0x0C, 0x0C, 0x00, 0x00, 0x10, 0x20, 0x14, 0x14, 0x18,
	0x14, 0x14, 0x14, 0x10, 0x08, 0x24, 0x2C, 0x28, 0x24, 0x34, 0x30, 0x30, 0x34, 0x34, 0x38, 0x2C,
	0x1C, 0x1C, 0x34, 0x18, 0x04, 0x14, 0x10, 0x14, 0x14, 0x00, 0xE4, 0xEC, 0xE4, 0xFC, 0x10, 0x0C,
	0x0C, 0x14, 0x20, 0x04, 0x0C, 0x2C, 0x20, 0x14, 0x04, 0x08, 0x10, 0x2C, 0x2C, 0x14, 0x24, 0x00,
	0xEC, 0xFC, 0x10, 0x0C, 0x00, 0x10, 0x08, 0xF4, 0x00, 0xF4, 0x00, 0xFC, 0x08, 0x18, 0xF4, 0x00,
	0x0C, 0x0C, 0xF8, 0xF8, 0x10, 0x0C, 0x10, 0xE4, 0xE8, 0xFC, 0x04, 0x18, 0x0C, 0x0C, 0x04, 0x18,
	0x18, 0x14, 0x04, 0x0C, 0x10, 0x20, 0x0C, 0x10, 0x28, 0x34, 0x30, 0x34, 0x2C, 0x20, 0x1C, 0x1C,
	0x2C, 0x40, 0x3C, 0x24, 0x24, 0x1C, 0x18, 0x14, 0x24, 0x14, 0xEC, 0xFC, 0x04, 0xF8, 0xF4, 0xE4,
	0xE4, 0xFC, 0x04, 0xF8, 0xEC, 0xF8, 0xF8, 0xF4, 0x00, 0xF0, 0x00, 0xF4, 0xEC, 0x10, 0x04, 0xFC,
	0x08, 0x04, 0x00, 0xEC, 0x00, 0x00, 0x00, 0x14, 0x10, 0x0C, 0x04, 0x20, 0x1C, 0x24, 0x14, 0xF8,
	0x08, 0x28, 0x14, 0x0C, 0x24, 0x2C, 0x18, 0x0C, 0x24, 0x34, 0x04, 0xF8, 0xEC, 0x0C, 0x1C, 0x18,
	0x00, 0x04, 0x28, 0x1C, 0x14, 0x24, 0x18, 0x14, 0x20, 0x10, 0x10, 0x24, 0x1C, 0x04, 0x0C, 0x14,
	0x1C, 0x1C, 0x1C, 0x28, 0x24, 0x20, 0x2C, 0x24, 0x14, 0x04, 0x1C, 0x2C, 0x24, 0x24, 0x00, 0xF8,
	0xFC, 0x18, 0xF4, 0xEC, 0xFC, 0x04, 0xE4, 0xE4, 0xF4, 0xF0, 0xF8, 0x1C, 0x14, 0x14, 0x04, 0x04,
	0x00, 0x04, 0x1C, 0x1C, 0x08, 0xF4, 0xF0, 0xF8, 0x14, 0xFC, 0xF4, 0x10, 0x10, 0x18, 0x20, 0x24,
	0x14, 0x1C, 0x38, 0x28, 0x24, 0x14, 0x34, 0x44, 0x20, 0x24, 0x14, 0x10, 0x28, 0x24, 0x0C, 0x18,
	0x04, 0xF4, 0xF8, 0x14, 0xF8, 0xDC, 0xE4, 0xEC, 0xE4, 0x04, 0xFC, 0xEC, 0xF4, 0xFC, 0xFC, 0xFC,
	0xE4, 0xE4, 0xF0, 0xE0, 0xD4, 0xE8, 0xE4, 0xE4, 0xF8, 0xF0, 0xE4, 0xEC, 0xE4, 0xE4, 0xF4, 0xF8,
	0xFC, 0x04, 0x14, 0x04, 0x00, 0xF8, 0x14, 0x10, 0x14, 0x20, 0x20, 0x14, 0x08, 0x04, 0x20, 0x2C,
	0x1C, 0x0C, 0x1C, 0x1C, 0x0C, 0x1C, 0x1C, 0x00, 0x04, 0xF8, 0x20, 0x24, 0x2C, 0x3C, 0x1C, 0x28,
	0x34, 0x20, 0x2C, 0x20, 0x30, 0x2C, 0x28, 0x28, 0x24, 0x24, 0x3C, 0x3C, 0x34, 0x34, 0x34, 0x3C,
	0x24, 0x3C, 0x3C, 0x3C, 0x34, 0x34, 0x2C, 0x24, 0x18, 0x0C, 0x1C, 0x1C, 0x14, 0xF4, 0xFC, 0x0C,
	0x0C, 0x00, 0xF8, 0xFC, 0x04, 0x0C, 0x00, 0xF8, 0xF8, 0xEC, 0xEC, 0xE8, 0xF0, 0xDC, 0xE4, 0xF4,
	0xF0, 0xF0, 0xF4, 0x04, 0xDC, 0xEC, 0xEC, 0xDC, 0xE0, 0xEC, 0xEC, 0xF4, 0xEC, 0xE8, 0xF0, 0xE4,
	0xDC, 0xC4, 0xC4, 0xE4, 0xF4, 0x04, 0xF4, 0xF0, 0x08, 0x24, 0x14, 0x1C, 0x1C, 0x14, 0x30, 0x2C,
	0x08, 0x08, 0x1C, 0x14, 0x0C, 0x00, 0x08, 0x18, 0x10, 0x04, 0x04, 0x08, 0x14, 0x04, 0x10, 0x0C,
	0x00, 0x2C, 0x34, 0x1C, 0x0C, 0x1C, 0x20, 0x2C, 0x1C, 0x2C, 0x38, 0x44, 0x2C, 0x1C, 0x20, 0x44,
	0x48, 0x1C, 0x18, 0x1C, 0x24, 0x3C, 0x28, 0x24, 0x38, 0x28, 0x18, 0x1C, 0x1C, 0x1C, 0x2C, 0x14,
	0x04, 0x10, 0x24, 0x18, 0xF4, 0xFC, 0x24, 0x24, 0x14, 0xFC, 0x04, 0xF0, 0xF4, 0xF8, 0xEC, 0xE4,
	0xEC, 0xF8, 0xF4, 0xEC, 0xE4, 0x04, 0xF4, 0xEC, 0xE8, 0xFC, 0xF4, 0xF4, 0x0C, 0x0C, 0x04, 0x04,
	0x00, 0x00, 0x0C, 0x00, 0xFC, 0x00, 0x04, 0xEC, 0xEC, 0xEC, 0xF4, 0x04, 0x14, 0x0C, 0x04, 0xE0,
	0xE4, 0xF4, 0xDC, 0xE8, 0x08, 0xEC, 0xF4, 0xEC, 0xE4, 0xF4, 0x08, 0x0C, 0x08, 0xFC, 0xF0, 0xF0,
	0x00, 0xF8, 0xFC, 0xFC, 0xF8, 0xF8, 0x08, 0x0C, 0xFC, 0xF8, 0x04, 0x14, 0x18, 0x0C, 0x0C, 0x20,
	0x28, 0x34, 0x24, 0x24, 0x1C, 0x28, 0x34, 0x38, 0x2C, 0x28, 0x20, 0x1C, 0x1C, 0x1C, 0x20, 0x20,
	0x24, 0x18, 0x0C, 0x20, 0x28, 0x24, 0x0C, 0x0C, 0x2C, 0x1C, 0x14, 0x04, 0x08, 0x1C, 0x24, 0x10,
	0x04, 0x18, 0x18, 0x08, 0x04, 0x18, 0x24, 0x14, 0x04, 0xF8, 0xE4, 0x00, 0x00, 0x04, 0x08, 0xFC,
	0xF4, 0xFC, 0xF0, 0xF0, 0x00, 0x08, 0xF4, 0xE4, 0xF4, 0xEC, 0xEC, 0xEC, 0xE8, 0xF4, 0xE8, 0xD8,
	0xDC, 0xE4, 0xF0, 0xEC, 0xF0, 0x04, 0xF4, 0xE8, 0xFC, 0xFC, 0xE4, 0xE8, 0xF4, 0xF4, 0x04, 0xEC,
	0xF0, 0xE4, 0xE8, 0x10, 0x0C, 0xF4, 0xEC, 0x00, 0x14, 0x0C, 0x0C, 0x04, 0x04
};

const uint8 SfxPlayer::_musicDataSample6[] = {
	0x09, 0x2E, 0x00, 0x20, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x03, 0x03, 0x03, 0x06, 0x06, 0x0A,
	0x00, 0x10, 0x05, 0x0C, 0x04, 0x07, 0x08, 0xEF, 0xF4, 0xEB, 0xFC, 0xE3, 0x21, 0x10, 0x10, 0x08,
	0x22, 0x0E, 0x27, 0x3A, 0x35, 0x38, 0x2D, 0x38, 0x19, 0x0B, 0xCE, 0xDA, 0xCA, 0xD2, 0xCE, 0xEB,
	0x0B, 0x16, 0x14, 0x05, 0x04, 0xED, 0xF1, 0xB8, 0xCD, 0xCB, 0xD5, 0xE9, 0xF3, 0x22, 0x29, 0x2A,
	0x13, 0x1A, 0x3A, 0x32, 0x1F, 0x3B, 0x42, 0x4F, 0x3C, 0x2E, 0x08, 0x14, 0xFF, 0xE7, 0xF0, 0xF6,
	0x0D, 0xF5, 0x0E, 0xFE, 0x08, 0x05, 0xDD, 0xC4, 0xC9, 0xB1, 0xB7, 0xCC, 0xE6, 0xF8, 0x0D, 0x20,
	0xFF, 0x3A, 0x40, 0x4F, 0x2F, 0x57, 0x4C, 0x4A, 0x39, 0xF6, 0xF4, 0xDA, 0xD1, 0xBF, 0xD4, 0xE8,
	0x02, 0xFE, 0x0B, 0xF8, 0x06, 0xF0, 0xC6, 0xB8, 0xCA, 0xB3, 0xCF, 0xDF, 0x09, 0x27, 0x2D, 0x21,
	0x1F, 0x46, 0x59, 0x40, 0x5F, 0x67, 0x6C, 0x62, 0x3A, 0x0E, 0x08, 0xE9, 0xCF, 0xCC, 0xCE, 0xED,
	0xE4, 0xF3, 0xF0, 0xF3, 0x00, 0xE5, 0xB9, 0xDD, 0xB0, 0xBF, 0xC3, 0xDF, 0x01, 0x13, 0x2D, 0x06,
	0x3C, 0x49, 0x58, 0x37, 0x65, 0x5A, 0x5F, 0x50, 0x0C, 0xFE, 0xDF, 0xC5, 0xB9, 0xB5, 0xCB, 0xE4,
	0xE2, 0x0B, 0xE7, 0x17, 0x02, 0xDA, 0xD2, 0xD8, 0xC2, 0xD7, 0xE2, 0x0D, 0x24, 0x3F, 0x2E, 0x2D,
	0x3B, 0x58, 0x36, 0x4E, 0x60, 0x56, 0x6A, 0x31, 0x15, 0xF8, 0xE0, 0xCA, 0xBC, 0xC1, 0xD8, 0xD1,
	0xF5, 0xE1, 0xF3, 0x04, 0xED, 0xC7, 0xDE, 0xC2, 0xC9, 0xC9, 0xE3, 0x09, 0x1F, 0x39, 0x1C, 0x31,
	0x4E, 0x46, 0x3A, 0x55, 0x54, 0x66, 0x5C, 0x2D, 0x14, 0xF6, 0xDA, 0xC4, 0xBF, 0xC5, 0xD2, 0xDB,
	0xF4, 0xE3, 0x0C, 0x0F, 0xE6, 0xD9, 0xD4, 0xCA, 0xCB, 0xD9, 0x03, 0x0E, 0x3F, 0x2C, 0x29, 0x33,
	0x43, 0x36, 0x39, 0x55, 0x4E, 0x6B, 0x45, 0x24, 0x04, 0xE6, 0xCC, 0xBB, 0xB9, 0xCA, 0xC7, 0xE7,
	0xDE, 0xE9, 0x03, 0x00, 0xDC, 0xE2, 0xD8, 0xCC, 0xCF, 0xEB, 0xF9, 0x25, 0x2C, 0x2B, 0x1E, 0x3B,
	0x3B, 0x2E, 0x43, 0x4C, 0x5B, 0x6A, 0x44, 0x2A, 0x0C, 0xE8, 0xD1, 0xC0, 0xC9, 0xC9, 0xD7, 0xE7,
	0xE6, 0xF8, 0x1B, 0xF0, 0xE7, 0xE0, 0xCC, 0xC6, 0xCF, 0xEC, 0xFF, 0x25, 0x2D, 0x20, 0x23, 0x37,
	0x2D, 0x2A, 0x46, 0x42, 0x66, 0x5A, 0x38, 0x25, 0x00, 0xE3, 0xCA, 0xC0, 0xCD, 0xC7, 0xDE, 0xE4,
	0xDA, 0x07, 0x04, 0xEA, 0xE9, 0xD4, 0xD1, 0xBF, 0xE2, 0xEB, 0x19, 0x27, 0x35, 0x1C, 0x39, 0x3A,
	0x2D, 0x3F, 0x43, 0x53, 0x6B, 0x4C, 0x3A, 0x20, 0xF8, 0xE8, 0xC3, 0xD3, 0xC6, 0xD1, 0xDE, 0xDC,
	0xE5, 0x0E, 0xF1, 0xEF, 0xDA, 0xD7, 0xBC, 0xC9, 0xD7, 0xF3, 0x13, 0x31, 0x1C, 0x21, 0x32, 0x28,
	0x29, 0x38, 0x3E, 0x5D, 0x62, 0x45, 0x3B, 0x10, 0xFE, 0xD4, 0xCF, 0xD0, 0xCD, 0xD7, 0xE7, 0xD6,
	0xFB, 0x04, 0xF2, 0xF0, 0xDA, 0xD8, 0xBF, 0xDB, 0xE1, 0x06, 0x23, 0x36, 0x24, 0x32, 0x39, 0x2C,
	0x35, 0x38, 0x47, 0x5D, 0x58, 0x42, 0x2E, 0x08, 0xF3, 0xCF, 0xD4, 0xC9, 0xCA, 0xD8, 0xDB, 0xD6,
	0xFF, 0xF3, 0xF5, 0xDC, 0xE0, 0xC2, 0xCB, 0xD2, 0xED, 0x07, 0x2D, 0x2A, 0x22, 0x32, 0x2C, 0x26,
	0x31, 0x37, 0x49, 0x63, 0x4A, 0x48, 0x21, 0x0C, 0xE6, 0xD8, 0xD3, 0xD0, 0xCF, 0xE7, 0xD3, 0xEB,
	0x00, 0xFB, 0xEE, 0xE4, 0xD8, 0xC5, 0xD0, 0xDD, 0xF7, 0x17, 0x33, 0x28, 0x29, 0x3C, 0x28, 0x33,
	0x34, 0x3A, 0x57, 0x57, 0x4C, 0x38, 0x17, 0x00, 0xE0, 0xD5, 0xD2, 0xC4, 0xD5, 0xDC, 0xCB, 0xF4,
	0xF7, 0xF8, 0xE6, 0xE2, 0xC9, 0xC5, 0xC9, 0xE1, 0xF6, 0x22, 0x2D, 0x1E, 0x33, 0x2A, 0x27, 0x2E,
	0x30, 0x3F, 0x59, 0x54, 0x51, 0x30, 0x19, 0xF8, 0xDE, 0xDD, 0xD2, 0xCB, 0xEB, 0xD0, 0xE7, 0xF6,
	0x03, 0xF5, 0xF1, 0xE0, 0xCE, 0xC4, 0xD7, 0xE0, 0x03, 0x25, 0x26, 0x1F, 0x34, 0x26, 0x2C, 0x32,
	0x2C, 0x4B, 0x50, 0x58, 0x42, 0x2C, 0x11, 0xF1, 0xDE, 0xDB, 0xC6, 0xDA, 0xDA, 0xD5, 0xE4, 0xF7,
	0xFB, 0xF1, 0xEA, 0xD6, 0xC6, 0xC6, 0xD4, 0xE3, 0x0B, 0x27, 0x1B, 0x2D, 0x2C, 0x26, 0x32, 0x2A,
	0x3A, 0x4B, 0x5B, 0x55, 0x41, 0x28, 0x0A, 0xEA, 0xDE, 0xD8, 0xC7, 0xE8, 0xD7, 0xE2, 0xED, 0x03,
	0xF6, 0xF8, 0xE3, 0xD6, 0xC1, 0xD1, 0xD2, 0xEF, 0x15, 0x21, 0x1B, 0x2A, 0x24, 0x23, 0x30, 0x22,
	0x3F, 0x49, 0x5A, 0x4E, 0x3A, 0x22, 0x06, 0xE4, 0xEA, 0xC4, 0xDB, 0xDA, 0xDC, 0xDB, 0xF6, 0xFC,
	0xFA, 0xF2, 0xE2, 0xCC, 0xC7, 0xCE, 0xD9, 0xF7, 0x22, 0x1E, 0x25, 0x31, 0x20, 0x35, 0x24, 0x33,
	0x3F, 0x55, 0x5B, 0x4B, 0x36, 0x1D, 0xF8, 0xEB, 0xDC, 0xC9, 0xDE, 0xDB, 0xDA, 0xE3, 0xFB, 0xF8,
	0xFB, 0xE8, 0xE0, 0xC5, 0xCC, 0xCF, 0xD9, 0x07, 0x1C, 0x1B, 0x27, 0x24, 0x24, 0x2C, 0x23, 0x33,
	0x43, 0x57, 0x58, 0x48, 0x31, 0x1C, 0xF0, 0xF6, 0xCA, 0xD7, 0xDB, 0xDD, 0xD5, 0xEA, 0xF7, 0xFB,
	0xF2, 0xEC, 0xD0, 0xCA, 0xC9, 0xCC, 0xDF, 0x0F, 0x1B, 0x1C, 0x30, 0x1F, 0x34, 0x28, 0x2B, 0x38,
	0x47, 0x5D, 0x54, 0x41, 0x34, 0x04, 0xFB, 0xE2, 0xCF, 0xD7, 0xDF, 0xD7, 0xDB, 0xF1, 0xF8, 0xF9,
	0xF2, 0xE2, 0xD0, 0xC7, 0xCF, 0xC9, 0xF3, 0x12, 0x13, 0x25, 0x20, 0x28, 0x2A, 0x28, 0x2C, 0x3A,
	0x51, 0x5B, 0x51, 0x40, 0x2C, 0x02, 0x00, 0xDB, 0xD5, 0xDF, 0xE0, 0xD5, 0xE3, 0xF1, 0xFD, 0xF4,
	0xF2, 0xDA, 0xCC, 0xCB, 0xC5, 0xCF, 0xFD, 0x12, 0x17, 0x26, 0x21, 0x2A, 0x2C, 0x24, 0x2F, 0x3D,
	0x53, 0x5C, 0x44, 0x46, 0x12, 0x0A, 0xEE, 0xD7, 0xD4, 0xDF, 0xD8, 0xD6, 0xE3, 0xF8, 0xF4, 0xFA,
	0xE8, 0xDB, 0xC9, 0xD0, 0xC3, 0xDB, 0x09, 0x0B, 0x23, 0x1E, 0x27, 0x2C, 0x29, 0x29, 0x32, 0x44,
	0x5D, 0x52, 0x4F, 0x38, 0x17, 0x04, 0xEE, 0xD6, 0xDE, 0xE3, 0xD6, 0xDD, 0xE9, 0xF8, 0xF6, 0xF4,
	0xE8, 0xD0, 0xCF, 0xC6, 0xC0, 0xEB, 0x01, 0x15, 0x1C, 0x22, 0x26, 0x2C, 0x26, 0x27, 0x35, 0x46,
	0x5E, 0x49, 0x52, 0x28, 0x16, 0x00, 0xE2, 0xD4, 0xE1, 0xD8, 0xD8, 0xD8, 0xF3, 0xF0, 0xF9, 0xF0,
	0xE0, 0xD0, 0xCF, 0xC4, 0xC7, 0xF9, 0x05, 0x1B, 0x1F, 0x23, 0x2D, 0x2C, 0x26, 0x2E, 0x33, 0x59,
	0x4D, 0x57, 0x44, 0x28, 0x12, 0xFC, 0xDE, 0xDC, 0xE3, 0xDB, 0xD6, 0xE5, 0xF1, 0xF7, 0xF5, 0xF2,
	0xD9, 0xD2, 0xD0, 0xB6, 0xDD, 0xF1, 0x0D, 0x16, 0x1D, 0x25, 0x29, 0x28, 0x24, 0x2A, 0x3D, 0x54,
	0x4D, 0x53, 0x3C, 0x20, 0x0E, 0xF4, 0xD8, 0xE2, 0xDD, 0xDB, 0xD6, 0xEA, 0xF3, 0xF4, 0xF9, 0xE8,
	0xD8, 0xD5, 0xC4, 0xBF, 0xE3, 0xFD, 0x11, 0x1C, 0x21, 0x29, 0x2E, 0x24, 0x2E, 0x27, 0x4F, 0x4B,
	0x56, 0x50, 0x34, 0x1E, 0x0A, 0xE8, 0xDD, 0xDE, 0xE0, 0xD1, 0xDE, 0xE8, 0xF3, 0xF5, 0xF6, 0xE6,
	0xD4, 0xD8, 0xB9, 0xCB, 0xE5, 0xFE, 0x12, 0x18, 0x22, 0x29, 0x26, 0x2A, 0x20, 0x37, 0x47, 0x4E,
	0x53, 0x49, 0x2C, 0x1B, 0x02, 0xE2, 0xE0, 0xE3, 0xDB, 0xD7, 0xDF, 0xF2, 0xEF, 0xF9, 0xF4, 0xDA,
	0xDE, 0xC8, 0xBF, 0xD1, 0xED, 0x05, 0x15, 0x1E, 0x25, 0x2D, 0x27, 0x2C, 0x23, 0x3F, 0x4A, 0x51,
	0x57, 0x42, 0x28, 0x1A, 0xF5, 0xE4, 0xDD, 0xE4, 0xD4, 0xD8, 0xE4, 0xED, 0xF1, 0xF9, 0xEC, 0xDB,
	0xDB, 0xC2, 0xC0, 0xD7, 0xEF, 0x07, 0x16, 0x19, 0x2C, 0x21, 0x32, 0x1E, 0x2F, 0x3F, 0x4A, 0x53,
	0x54, 0x38, 0x29, 0x10, 0xF3, 0xDE, 0xE6, 0xDC, 0xD9, 0xDB, 0xEB, 0xEF, 0xF4, 0xFE, 0xE0, 0xE5,
	0xD2, 0xC1, 0xC7, 0xDD, 0xF7, 0x0D, 0x13, 0x23, 0x24, 0x2B, 0x28, 0x21, 0x34, 0x44, 0x4B, 0x58,
	0x4E, 0x33, 0x28, 0x07, 0xEE, 0xE1, 0xE4, 0xDC, 0xD6, 0xDF, 0xEB, 0xEB, 0xFD, 0xF2, 0xE3, 0xE0,
	0xCE, 0xBF, 0xCB, 0xE2, 0xFA, 0x12, 0x13, 0x29, 0x20, 0x31, 0x21, 0x26, 0x37, 0x42, 0x4D, 0x59,
	0x42, 0x37, 0x1D, 0x06, 0xE5, 0xE5, 0xE2, 0xD8, 0xD8, 0xE1, 0xEB, 0xEF, 0x00, 0xEB, 0xE7, 0xE0,
	0xC9, 0xC3, 0xD2, 0xE6, 0x06, 0x0A, 0x1F, 0x1F, 0x29, 0x2B, 0x21, 0x29, 0x3A, 0x43, 0x54, 0x54,
	0x3F, 0x30, 0x1C, 0xFA, 0xE7, 0xE5, 0xE1, 0xD8, 0xD9, 0xE9, 0xE4, 0xFA, 0xF8, 0xE9, 0xE7, 0xD8,
	0xC6, 0xC5, 0xD5, 0xEF, 0x06, 0x0F, 0x20, 0x1E, 0x2C, 0x26, 0x20, 0x2D, 0x3A, 0x43, 0x58, 0x49,
	0x3E, 0x2B, 0x16, 0xF3, 0xE6, 0xE6, 0xDD, 0xD5, 0xDE, 0xE4, 0xE9, 0xFC, 0xF2, 0xE9, 0xE6, 0xD4,
	0xC3, 0xCB, 0xD7, 0xFB, 0x02, 0x18, 0x1A, 0x23, 0x2C, 0x23, 0x23, 0x34, 0x39, 0x4F, 0x54, 0x4B,
	0x38, 0x2C, 0x0C, 0xF0, 0xE8, 0xE6, 0xDD, 0xD8, 0xE6, 0xE2, 0xF3, 0xFC, 0xEE, 0xEA, 0xE4, 0xCD,
	0xC7, 0xC8, 0xE1, 0xF8, 0x07, 0x16, 0x19, 0x25, 0x2A, 0x1E, 0x27, 0x31, 0x3D, 0x51, 0x51, 0x44,
	0x38, 0x26, 0x04, 0xEE, 0xE8, 0xE6, 0xD8, 0xDF, 0xE2, 0xE6, 0xF9, 0xF8, 0xEE, 0xEC, 0xE0, 0xCB,
	0xC7, 0xCA, 0xE9, 0xF8, 0x0D, 0x13, 0x1B, 0x27, 0x25, 0x1C, 0x2D, 0x2F, 0x46, 0x51, 0x50, 0x40,
	0x38, 0x20, 0xFE, 0xEC, 0xEA, 0xE1, 0xD8, 0xE2, 0xDF, 0xED, 0xFB, 0xF6, 0xED, 0xEE, 0xD8, 0xCE,
	0xC1, 0xD6, 0xE9, 0xFF, 0x0D, 0x14, 0x1D, 0x2B, 0x1E, 0x24, 0x2A, 0x35, 0x48, 0x52, 0x4A, 0x3E,
	0x34, 0x14, 0xFA, 0xEB, 0xED, 0xDB, 0xDF, 0xE0, 0xE1, 0xF1, 0xFB, 0xEF, 0xF0, 0xE6, 0xD6, 0xC8,
	0xC5, 0xDC, 0xED, 0x05, 0x0E, 0x14, 0x23, 0x27, 0x1D, 0x28, 0x2B, 0x3B, 0x4B, 0x53, 0x45, 0x40,
	0x2C, 0x10, 0xF2, 0xEF, 0xE8, 0xDB, 0xE3, 0xDE, 0xE6, 0xF6, 0xF8, 0xEE, 0xF2, 0xE0, 0xD7, 0xC2,
	0xCD, 0xDD, 0xF4, 0x06, 0x0F, 0x17, 0x2A, 0x21, 0x22, 0x27, 0x2E, 0x3E, 0x4F, 0x4E, 0x44, 0x3D,
	0x26, 0x06, 0xF0, 0xF0, 0xE0, 0xDD, 0xDF, 0xDE, 0xE9, 0xFA, 0xF1, 0xF3, 0xEC, 0xE1, 0xCE, 0xC2,
	0xD1, 0xE1, 0xF9, 0x09, 0x0E, 0x1F, 0x27, 0x21, 0x24, 0x27, 0x32, 0x43, 0x51, 0x49, 0x45, 0x39,
	0x20, 0x00, 0xF2, 0xEE, 0xDE, 0xE1, 0xDF, 0xDF, 0xF2, 0xF8, 0xF3, 0xF4, 0xEA, 0xE0, 0xC8, 0xC7,
	0xD2, 0xE5, 0xFC, 0x08, 0x0F, 0x23, 0x24, 0x21, 0x24, 0x29, 0x33, 0x47, 0x4C, 0x47, 0x41, 0x34,
	0x16, 0xF8, 0xF5, 0xE8, 0xE0, 0xE1, 0xDE, 0xE3, 0xF7, 0xF4, 0xF6, 0xF2, 0xEB, 0xD9, 0xC7, 0xC8,
	0xD7, 0xE9, 0x03, 0x04, 0x17, 0x24, 0x22, 0x22, 0x25, 0x2A, 0x39, 0x4A, 0x4B, 0x46, 0x40, 0x2E,
	0x0C, 0xF9, 0xF3, 0xE5, 0xE0, 0xE4, 0xDA, 0xED, 0xF5, 0xF6, 0xF7, 0xF1, 0xEA, 0xD4, 0xC7, 0xCC,
	0xD7, 0xF2, 0x00, 0x06, 0x19, 0x21, 0x21, 0x20, 0x26, 0x28, 0x3E, 0x47, 0x49, 0x44, 0x3E, 0x28,
	0x06, 0xFB, 0xF0, 0xE4, 0xE5, 0xE0, 0xDF, 0xF1, 0xF4, 0xF8, 0xF4, 0xF3, 0xE4, 0xD2, 0xC6, 0xD0,
	0xDB, 0xF9, 0xFD, 0x0B, 0x1B, 0x20, 0x1F, 0x23, 0x23, 0x2F, 0x40, 0x4A, 0x48, 0x43, 0x3E, 0x20,
	0x06, 0xF9, 0xF0, 0xE4, 0xE9, 0xDC, 0xE7, 0xF2, 0xF6, 0xF8, 0xF5, 0xF1, 0xE0, 0xCA, 0xCB, 0xCC,
	0xE5, 0xF9, 0xFD, 0x0F, 0x1A, 0x1F, 0x1D, 0x24, 0x21, 0x32, 0x43, 0x49, 0x44, 0x44, 0x38, 0x16,
	0x02, 0xFA, 0xE8, 0xEA, 0xE4, 0xDF, 0xED, 0xF2, 0xFB, 0xF5, 0xF8, 0xEE, 0xDA, 0xCB, 0xCA, 0xCF,
	0xEC, 0xF7, 0x02, 0x12, 0x1D, 0x1C, 0x22, 0x1F, 0x25, 0x36, 0x45, 0x49, 0x43, 0x47, 0x2D, 0x13,
	0x01, 0xF6, 0xE7, 0xEB, 0xDF, 0xE2, 0xED, 0xF6, 0xF8, 0xF8, 0xF5, 0xED, 0xD3, 0xCD, 0xC7, 0xD7,
	0xEF, 0xF6, 0x05, 0x13, 0x1C, 0x1D, 0x20, 0x1F, 0x28, 0x3B, 0x48, 0x46, 0x47, 0x42, 0x2A, 0x0D,
	0x03, 0xF0, 0xEB, 0xE8, 0xDD, 0xE7, 0xED, 0xF8, 0xF7, 0xF7, 0xF6, 0xE4, 0xD3, 0xCA, 0xC7, 0xDD,
	0xEE, 0xF8, 0x06, 0x17, 0x19, 0x20, 0x1F, 0x20, 0x2E, 0x3F, 0x4A, 0x45, 0x4C, 0x40, 0x20, 0x0F,
	0xFE, 0xEE, 0xED, 0xE3, 0xE1, 0xE7, 0xF3, 0xF6, 0xF8, 0xF6, 0xF4, 0xDD, 0xD1, 0xC5, 0xC9, 0xE3,
	0xEF, 0xF9, 0x0C, 0x16, 0x1C, 0x1F, 0x1F, 0x22, 0x31, 0x46, 0x46, 0x49, 0x4B, 0x3A, 0x1C, 0x0D,
	0xF8, 0xEE, 0xEC, 0xE0, 0xE2, 0xEB, 0xF3, 0xF9, 0xF5, 0xFB, 0xEC, 0xDC, 0xCE, 0xC2, 0xD2, 0xE5,
	0xEF, 0xFD, 0x0F, 0x16, 0x1D, 0x20, 0x1D, 0x24, 0x37, 0x46, 0x46, 0x49, 0x4C, 0x2E, 0x1C, 0x07,
	0xF4, 0xF0, 0xE7, 0xE2, 0xE3, 0xEE, 0xF6, 0xF6, 0xF9, 0xF8, 0xE8, 0xDA, 0xC8, 0xC6, 0xD7, 0xE9,
	0xEF, 0x05, 0x0F, 0x19, 0x1E, 0x1E, 0x1E, 0x25, 0x3E, 0x43, 0x45, 0x4E, 0x45, 0x2B, 0x19, 0x01,
	0xF4, 0xEE, 0xE7, 0xDE, 0xE7, 0xEE, 0xF9, 0xF5, 0xFD, 0xF5, 0xE6, 0xD9, 0xC5, 0xC9, 0xDC, 0xE8,
	0xF5, 0x05, 0x11, 0x19, 0x1E, 0x1F, 0x1B, 0x2D, 0x3C, 0x44, 0x43, 0x4E, 0x3B, 0x27, 0x13, 0xFB,
	0xF4, 0xEC, 0xE3, 0xE1, 0xE7, 0xF4, 0xF6, 0xF9, 0xFE, 0xF1, 0xE8, 0xD2, 0xC7, 0xCD, 0xE1, 0xE9,
	0xFA, 0x09, 0x14, 0x1D, 0x20, 0x1D, 0x1F, 0x31, 0x3F, 0x3E, 0x48, 0x4A, 0x34, 0x24, 0x0A, 0xFA,
	0xF0, 0xEB, 0xDF, 0xE2, 0xE9, 0xF5, 0xF6, 0xFC, 0xFC, 0xF0, 0xE4, 0xCE, 0xC6, 0xD3, 0xE1, 0xED,
	0xFE, 0x0B, 0x17, 0x1C, 0x22, 0x19, 0x24, 0x35, 0x3F, 0x3F, 0x4C, 0x45, 0x32, 0x20, 0x06, 0xF8,
	0xF1, 0xE5, 0xE1, 0xE1, 0xEF, 0xF5, 0xF7, 0xFF, 0xF8, 0xF2, 0xE0, 0xCC, 0xC8, 0xD7, 0xE3, 0xEF,
	0xFF, 0x0D, 0x17, 0x1F, 0x1D, 0x1B, 0x25, 0x3A, 0x3B, 0x43, 0x4D, 0x3E, 0x30, 0x19, 0x04, 0xF6,
	0xEE, 0xE5, 0xE0, 0xE5, 0xF2, 0xF5, 0xFB, 0xFE, 0xF9, 0xEE, 0xDC, 0xC9, 0xCC, 0xDA, 0xE4, 0xF3,
	0x01, 0x0F, 0x17, 0x1F, 0x1B, 0x1A, 0x2B, 0x39, 0x3B, 0x47, 0x4A, 0x3E, 0x2C, 0x16, 0x00, 0xF7,
	0xEB, 0xE5, 0xDF, 0xE9, 0xF4, 0xF6, 0xFE, 0xFD, 0xF8, 0xEC, 0xD5, 0xC8, 0xCF, 0xDC, 0xE7, 0xF5,
	0x06, 0x0E, 0x1B, 0x1C, 0x18, 0x1B, 0x30, 0x37, 0x3D, 0x4B, 0x48, 0x3B, 0x2A, 0x10, 0x00, 0xF4,
	0xEB, 0xE0, 0xDF, 0xED, 0xF2, 0xF8, 0xFD, 0xFD, 0xF6, 0xE8, 0xD0, 0xC8, 0xD2, 0xDC, 0xE7, 0xF9,
	0x05, 0x12, 0x1B, 0x1D, 0x16, 0x22, 0x33, 0x36, 0x41, 0x4B, 0x46, 0x38, 0x26, 0x0C, 0xFF, 0xF2,
	0xEA, 0xDF, 0xE5, 0xEF, 0xF3, 0xF9, 0xFF, 0xFB, 0xF6, 0xE1, 0xCC, 0xCB, 0xD4, 0xDF, 0xEB, 0xFD,
	0x06, 0x15, 0x1C, 0x1A, 0x16, 0x27, 0x32, 0x37, 0x45, 0x4C, 0x42, 0x38, 0x20, 0x0B, 0xFC, 0xF2,
	0xE6, 0xDE, 0xE8, 0xEE, 0xF4, 0xFB, 0xFD, 0xFB, 0xF2, 0xDC, 0xCB, 0xCD, 0xD7, 0xDF, 0xEF, 0xFC,
	0x09, 0x15, 0x1D, 0x16, 0x1A, 0x2C, 0x32, 0x3B, 0x48, 0x4A, 0x42, 0x34, 0x1A, 0x08, 0xF9, 0xF1,
	0xE2, 0xE3, 0xE9, 0xF0, 0xF6, 0xFD, 0xFC, 0xFB, 0xEE, 0xD5, 0xCB, 0xCE, 0xD8, 0xE3, 0xF3, 0xFF,
	0x0C, 0x19, 0x1B, 0x14, 0x1F, 0x2C, 0x32, 0x3D, 0x49, 0x47, 0x40, 0x2C, 0x16, 0x03, 0xF8, 0xEC,
	0xE1, 0xE4, 0xEB, 0xF1, 0xF9, 0xFC, 0xFD, 0xFA, 0xE8, 0xD2, 0xCA, 0xD1, 0xD7, 0xE7, 0xF5, 0x01,
	0x0F, 0x1B, 0x18, 0x15, 0x23, 0x2D, 0x33, 0x43, 0x49, 0x49, 0x3E, 0x29, 0x13, 0x01, 0xF7, 0xE8,
	0xE1, 0xE5, 0xEB, 0xF2, 0xF9, 0xFC, 0xFD, 0xF8, 0xE2, 0xCF, 0xCD, 0xD1, 0xDC, 0xEA, 0xF7, 0x04,
	0x13, 0x1C, 0x15, 0x18, 0x27, 0x2D, 0x37, 0x45, 0x49, 0x48, 0x39, 0x24, 0x0D, 0x00, 0xF4, 0xE6,
	0xE1, 0xE7, 0xEC, 0xF4, 0xF9, 0xFB, 0xFE, 0xF3, 0xDD, 0xCE, 0xCF, 0xD2, 0xDF, 0xEC, 0xFA, 0x06,
	0x17, 0x1A, 0x15, 0x1C, 0x29, 0x2D, 0x3B, 0x46, 0x4B, 0x45, 0x36, 0x20, 0x0B, 0xFE, 0xF1, 0xE4,
	0xE4, 0xE8, 0xED, 0xF5, 0xF9, 0xFD, 0xFB, 0xEE, 0xD6, 0xCF, 0xCD, 0xD5, 0xE1, 0xEF, 0xFB, 0x0A,
	0x18, 0x18, 0x15, 0x1F, 0x27, 0x2F, 0x3F, 0x47, 0x4B, 0x42, 0x33, 0x1A, 0x0A, 0xFC, 0xEE, 0xE4,
	0xE6, 0xE9, 0xF0, 0xF6, 0xFA, 0xFD, 0xFA, 0xE8, 0xD4, 0xCE, 0xCE, 0xD7, 0xE3, 0xF2, 0xFD, 0x0E,
	0x19, 0x15, 0x16, 0x21, 0x26, 0x33, 0x3F, 0x48, 0x49, 0x41, 0x2E, 0x18, 0x08, 0xFA, 0xEB, 0xE4,
	0xE7, 0xEA, 0xF2, 0xF7, 0xFB, 0xFD, 0xF8, 0xE1, 0xD3, 0xCB, 0xD0, 0xD7, 0xE7, 0xF2, 0xFF, 0x12,
	0x19, 0x13, 0x1A, 0x21, 0x28, 0x36, 0x40, 0x49, 0x47, 0x3D, 0x29, 0x14, 0x06, 0xF8, 0xE9, 0xE6,
	0xE7, 0xED, 0xF3, 0xF8, 0xFB, 0xFE, 0xF2, 0xDF, 0xD2, 0xCD, 0xD1, 0xDB, 0xE9, 0xF3, 0x02, 0x14,
	0x16, 0x13, 0x1D, 0x21, 0x2C, 0x37, 0x44, 0x49, 0x47, 0x3A, 0x25, 0x12, 0x04, 0xF4, 0xE9, 0xE7,
	0xE8, 0xEE, 0xF5, 0xF8, 0xFC, 0xFD, 0xEE, 0xDC, 0xD0, 0xCE, 0xD2, 0xDF, 0xEB, 0xF6, 0x07, 0x16,
	0x13, 0x17, 0x1D, 0x23, 0x2E, 0x3B, 0x45, 0x4A, 0x45, 0x36, 0x21, 0x10, 0x01, 0xF0, 0xEA, 0xE6,
	0xEB, 0xEF, 0xF7, 0xF8, 0xFF, 0xFA, 0xEA, 0xD8, 0xD0, 0xCD, 0xD4, 0xE0, 0xEC, 0xF7, 0x0C, 0x15,
	0x12, 0x19, 0x1D, 0x26, 0x30, 0x3E, 0x47, 0x49, 0x44, 0x32, 0x1E, 0x0F, 0xFE, 0xF0, 0xE8, 0xE7,
	0xEA, 0xF2, 0xF5, 0xFA, 0xFF, 0xF8, 0xE6, 0xD6, 0xCF, 0xCD, 0xD5, 0xE3, 0xEB, 0xFB, 0x0F, 0x12,
	0x15, 0x19, 0x1F, 0x27, 0x34, 0x3F, 0x3F
};

const uint8 SfxPlayer::_musicDataSample7[] = {
	0x03, 0x46, 0x00, 0x40, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x0F, 0x0A, 0x0F, 0x08, 0x15, 0x0D,
	0x11, 0x16, 0x08, 0x0B, 0x17, 0xFA, 0x0E, 0x17, 0x06, 0x0F, 0x0F, 0x13, 0x11, 0xFA, 0x28, 0xFF,
	0x0E, 0x23, 0xFD, 0x14, 0x1F, 0xF2, 0x1C, 0x0F, 0x00, 0x37, 0xF7, 0x04, 0x1B, 0xF3, 0x1C, 0x0F,
	0x06, 0x0F, 0x12, 0xFF, 0x14, 0x0D, 0x10, 0x0B, 0xF4, 0x4F, 0xCF, 0x28, 0xEA, 0x2B, 0xFF, 0x10,
	0x2F, 0xE4, 0x13, 0xFF, 0x12, 0x0F, 0x16, 0x07, 0x2F, 0xD4, 0x24, 0xFF, 0x00, 0x18, 0x11, 0x00,
	0x17, 0x02, 0x11, 0xFA, 0x2F, 0xEA, 0x18, 0xFF, 0x0C, 0x04, 0x30, 0xFF, 0x24, 0xE3, 0x30, 0xFF,
	0x00, 0x3F, 0xEF, 0x1C, 0xFC, 0x17, 0xEF, 0x28, 0xF7, 0x2B, 0x03, 0x07, 0x10, 0x22, 0xEF, 0x18,
	0x2F, 0xD9, 0x21, 0x08, 0x1F, 0xEC, 0x2C, 0xFC, 0x05, 0x0C, 0x2C, 0xF0, 0x1F, 0x0A, 0x02, 0x17,
	0x0C, 0xF2, 0x34, 0xFF, 0xF8, 0x19, 0x13, 0x09, 0xFC, 0x55, 0xAF, 0x10, 0x37, 0xD2, 0x31, 0x08,
	0x07, 0x09, 0x0C, 0x17, 0x04, 0xFE, 0x24, 0x00, 0x1D, 0x10, 0x10, 0x07, 0x19, 0x03, 0x05, 0x06,
	0x07, 0x0F, 0x18, 0x17, 0x00, 0x24, 0xDF, 0x20, 0x07, 0xF8, 0x1F, 0x00, 0x3F, 0xD2, 0x2A, 0x07,
	0x0C, 0x05, 0x20, 0x0F, 0xE8, 0x27, 0x0D, 0x0C, 0x0F, 0x1D, 0xEF, 0x1C, 0x00, 0x13, 0x0E, 0x00,
	0x2B, 0xF5, 0x08, 0x1F, 0xD0, 0x50, 0xFB, 0xE8, 0x3F, 0xE0, 0x20, 0x05, 0x1C, 0xEE, 0x1C, 0x02,
	0x2B, 0xE3, 0x20, 0x17, 0xE0, 0x58, 0xDF, 0x20, 0x11, 0xEF, 0x1C, 0x06, 0x27, 0xFA, 0x07, 0x1F,
	0xE1, 0x2C, 0xFF, 0x0A, 0x1F, 0x06, 0xFF, 0x00, 0x2F, 0xEB, 0x1A, 0x08, 0x2B, 0xDB, 0x20, 0x1B,
	0xE8, 0x30, 0xF7, 0x08, 0x23, 0xEF, 0x20, 0xFF, 0x27, 0xFB, 0x12, 0x0A, 0x15, 0xFE, 0x0E, 0x17,
	0x11, 0xF7, 0x11, 0x09, 0x15, 0xFF, 0x10, 0x1F, 0xEA, 0x1A, 0x0C, 0xFF, 0x19, 0x1C, 0xFF, 0x15,
	0x06, 0x05, 0x11, 0x19, 0xFA, 0x12, 0x0B, 0x04, 0x1B, 0x0E, 0x04, 0x13, 0x15, 0xFF, 0x04, 0x27,
	0xEC, 0x24, 0xFF, 0x00, 0x2B, 0xE6, 0x20, 0x08, 0x06, 0x0B, 0x08, 0x1B, 0x00, 0x1C, 0x0B, 0x04,
	0x09, 0x0C, 0x0F, 0x06, 0x0C, 0x13, 0x07, 0x03, 0x1F, 0xF3, 0x20, 0x0D, 0xF8, 0x20, 0x0B, 0xF8,
	0x26, 0xFF, 0x14, 0x0F, 0x09, 0x09, 0x0E, 0x1B, 0xE4, 0x40, 0xF7, 0x00, 0x22, 0xFF, 0x11, 0x00,
	0x2B, 0xFA, 0x0A, 0x11, 0x16, 0x03, 0x0C, 0x1B, 0xFC, 0x07, 0x08, 0x1F, 0xE2, 0x40, 0xFB, 0x00,
	0x23, 0xFB, 0x10, 0x16, 0x05, 0x12, 0x06, 0x06, 0x2C, 0xEF, 0x10, 0x17, 0xF8, 0x20, 0xFF, 0x10,
	0x0A, 0x0B, 0x12, 0x05, 0x17, 0x0C, 0x0D, 0x08, 0x0E, 0x12, 0x08, 0x17, 0x05, 0x0C, 0x0F, 0x04,
	0x10, 0x15, 0x04, 0x1D, 0xEF, 0x2C, 0xFF, 0x00, 0x1F, 0x03, 0x12, 0x08, 0x09, 0x18, 0x0B, 0x00,
	0x1E, 0xFF, 0x08, 0xFF, 0x2C, 0xFD, 0x08, 0x1F, 0xF2, 0x14, 0x17, 0xF4, 0x2D, 0xFF, 0x02, 0x2F,
	0xF0, 0x07, 0x10, 0x17, 0xFD, 0x20, 0xFF, 0x0C, 0x0E, 0x06, 0x08, 0x19, 0xFB, 0x12, 0x17, 0xF8,
	0x18, 0x0B, 0x17, 0xF8, 0x16, 0x07, 0x0C, 0x13, 0x08, 0x07, 0x04, 0x0F, 0x09, 0x10, 0x08, 0x1F,
	0xEC, 0x18, 0x17, 0xF8, 0x1F, 0x05, 0x04, 0x17, 0xFF, 0x18, 0x0F, 0x08, 0x0C, 0x08, 0x10, 0x04,
	0x16, 0x09, 0x16, 0x02, 0x0E, 0x12, 0x0F, 0xF6, 0x32, 0xEF, 0x10, 0x1F, 0xF7, 0x16, 0x0C, 0x0E,
	0x16, 0xFB, 0x13, 0x04, 0x11, 0x11, 0x06, 0x1F, 0xFB, 0x12, 0x0F, 0x04, 0x14, 0x07, 0x04, 0x1F,
	0xF3, 0x18, 0x09, 0x16, 0x06, 0x0A, 0x13, 0xFC, 0x1A, 0x07, 0x0C, 0x1C, 0xEF, 0x14, 0x15, 0xF1,
	0x30, 0xFF, 0x08, 0x1C, 0xEF, 0x18, 0x08, 0x13, 0x09, 0x0C, 0x17, 0xF0, 0x28, 0x07, 0x08, 0x1D,
	0xFD, 0x10, 0x15, 0xFD, 0x28, 0xFF, 0x04, 0x1C, 0xF7, 0x18, 0x07, 0x1E, 0x07, 0x08, 0x17, 0xF4,
	0x1C, 0x07, 0x0B, 0x0C, 0x1A, 0x06, 0x06, 0x19, 0x04, 0x10, 0x04, 0x14, 0x07, 0x0A, 0x1F, 0xEE,
	0x28, 0xFF, 0x09, 0x0F, 0x10, 0x07, 0x08, 0x18, 0x02, 0x14, 0x00, 0x1C, 0x05, 0x0B, 0x06, 0x1F,
	0xEF, 0x18, 0x0F, 0x0C, 0x0E, 0x06, 0x13, 0x02, 0x0D, 0x14, 0x04, 0x13, 0x0B, 0x0F, 0x04, 0x1B,
	0xFF, 0x0C, 0x13, 0x06, 0x0E, 0x0E, 0x0F, 0x09, 0x0B, 0x0E, 0x06, 0x12, 0x0B, 0x0A, 0x11, 0x0B,
	0x09, 0x0C, 0x0E, 0x07, 0x11, 0x08, 0x11, 0x0F, 0x09, 0x0C, 0x17, 0xFA, 0x1A, 0x07, 0x16, 0xFF,
	0x18, 0x0F, 0x02, 0x17, 0x05, 0x10, 0x04, 0x19, 0x06, 0x11, 0x02, 0x1D, 0xFF, 0x08, 0x1B, 0xFE,
	0x18, 0x0A, 0x11, 0x07, 0x14, 0x0E, 0x0C, 0x0D, 0x0D, 0x0E, 0x03, 0x16, 0x09, 0x10, 0x03, 0x1A,
	0x06, 0x08, 0x1B, 0xFF, 0x11, 0x0B, 0x0A, 0x0E, 0x0A, 0x0F, 0x06, 0x16, 0x06, 0x06, 0x15, 0x05,
	0x14, 0x0B, 0x07, 0x12, 0x0A, 0x11, 0x02, 0x1C, 0x09, 0x07, 0x1E, 0x00, 0x10, 0x0D, 0x0C, 0x12,
	0x0A, 0x0E, 0x0D, 0x12, 0x07, 0x08, 0x0F, 0x0E, 0x11, 0x08, 0x17, 0x06, 0x0E, 0x0D, 0x0F, 0x10,
	0x07, 0x10, 0x10, 0x08, 0x0E, 0x09, 0x10, 0x0B, 0x10, 0x0A, 0x14, 0x06, 0x10, 0x0F, 0x0D, 0x09,
	0x0E, 0x0B, 0x12, 0x07, 0x0E, 0x13, 0x05, 0x15, 0x08, 0x0D, 0x0D, 0x0E, 0x0B, 0x12, 0x09, 0x0B,
	0x10, 0x0E, 0x0B, 0x0B, 0x10, 0x08, 0x17, 0x03, 0x13, 0x0A, 0x15, 0x03, 0x10, 0x0F, 0x05, 0x14,
	0x0D, 0x0E, 0x0B, 0x13, 0x0A, 0x0E, 0x10, 0x07, 0x10, 0x17, 0xFC, 0x1C, 0x0D, 0x02, 0x1A, 0x0B,
	0x0B, 0x0F, 0x0F, 0x0C, 0x0E, 0x0A, 0x11, 0x0A, 0x11, 0x09, 0x10, 0x0F, 0x0B, 0x17, 0x0B, 0x0C,
	0x0E, 0x0F, 0x0A, 0x11, 0x0B, 0x0E, 0x0C, 0x10, 0x0E, 0x08, 0x14, 0x0B, 0x0E, 0x14, 0x04, 0x16,
	0x0A, 0x10, 0x0E, 0x0C, 0x0F, 0x02, 0x1B, 0x07, 0x10, 0x13, 0x08, 0x14, 0x07, 0x12, 0x07, 0x10,
	0x0F, 0x08, 0x14, 0x0B, 0x0E, 0x0F, 0x0E, 0x10, 0x0B, 0x11, 0x10, 0x0E, 0x0D, 0x08, 0x14, 0x0B,
	0x0E, 0x0F, 0x10, 0x0D, 0x0C, 0x13, 0x0C, 0x10, 0x0F, 0x0C, 0x0E, 0x0E, 0x0F, 0x00, 0x00
};

const uint8 SfxPlayer::_musicDataSample8[] = {
	0x00, 0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00
};

const SfxPlayer::Module SfxPlayer::_module68 = {
	{ _musicDataSample1, _musicDataSample8, _musicDataSample3, _musicDataSample4, _musicDataSample8 },
	_musicData68
};

const SfxPlayer::Module SfxPlayer::_module70 = {
	{ _musicDataSample1, _musicDataSample2, _musicDataSample3, _musicDataSample3, _musicDataSample8	},
	_musicData70
};

const SfxPlayer::Module SfxPlayer::_module72 = {
	{ _musicDataSample1, _musicDataSample2, _musicDataSample5, _musicDataSample4, _musicDataSample8 },
	_musicData72
};

const SfxPlayer::Module SfxPlayer::_module73 = {
	{ _musicDataSample1, _musicDataSample2, _musicDataSample4, _musicDataSample3, _musicDataSample8 },
	_musicData73
};

const SfxPlayer::Module SfxPlayer::_module74 = {
	{ _musicDataSample1, _musicDataSample2, _musicDataSample5, _musicDataSample6, _musicDataSample7	},
	_musicData74
};

const SfxPlayer::Module SfxPlayer::_module75 = {
	{ _musicDataSample1, _musicDataSample2, _musicDataSample5, _musicDataSample6, _musicDataSample7 },
	_musicData75
};

const uint16 SfxPlayer::_periodTable[] = {
	0x434, 0x3F8, 0x3C0, 0x38A, 0x358, 0x328, 0x2FA, 0x2D0, 0x2A6, 0x280,
	0x25C, 0x23A, 0x21A, 0x1FC, 0x1E0, 0x1C5, 0x1AC, 0x194, 0x17D, 0x168,
	0x153, 0x140, 0x12E, 0x11D, 0x10D, 0x0FE, 0x0F0, 0x0E2, 0x0D6, 0x0CA,
	0x0BE, 0x0B4, 0x0AA, 0x0A0, 0x097, 0x08F, 0x087, 0x07F, 0x078, 0x071
};
