#!/usr/bin/env python2.5

# 
# Copyright (c) 2007-2008 INdT.
# Copyright (c) 2011 Neal H. Walfield
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# ============================================================================
# Name        : FeedingIt.py
# Author      : Yves Marcoz
# Version     : 0.6.1
# Description : Simple RSS Reader
# ============================================================================

import dbus.service
import logging
logger = logging.getLogger(__name__)

_update_server_object = None
def update_server_object():
    global _update_server_object
    assert _update_server_object is not None, \
        "No UpdateServerObject instantiated!"
    return _update_server_object

class UpdateServerObject(dbus.service.Object):
    def __init__(self, bus_name):
        """
        Start listening for requests.
        """
        global _update_server_object
        assert _update_server_object is None, \
            "Attempt to instantiate multiple UpdateServerObject objects."
        _update_server_object = self

        dbus.service.Object.__init__(self, bus_name,
                                     '/org/marcoz/feedingit/update')

    @dbus.service.method('org.marcoz.feedingit')
    def StopUpdate(self):
        logger.debug("Stop update called.")

    @dbus.service.method('org.marcoz.feedingit')
    def UpdateAll(self):
        logger.debug("UpdateAll called.")

    @dbus.service.method('org.marcoz.feedingit', in_signature='s')
    def Update(self, feed):
        logger.debug("Update(%s) called." % feed)
    
    # A signal that will be exported to dbus
    @dbus.service.signal('org.marcoz.feedingit', signature='')
    def ArticleCountUpdated(self):
        pass

    # A signal that will be exported to dbus
    @dbus.service.signal('org.marcoz.feedingit', signature='uuuuttus')
    def UpdateProgress(self, percent_complete,
                       feeds_downloaded, feeds_downloading, feeds_pending,
                       bytes_downloaded, bytes_uploaded, bytes_per_second,
                       updated_feed):
        pass

    # A signal that will be exported to dbus
    @dbus.service.signal('org.marcoz.feedingit', signature='')
    def UpdateStarted(self):
        pass
    
    # A signal that will be exported to dbus
    @dbus.service.signal('org.marcoz.feedingit', signature='')
    def UpdateFinished(self):
        pass


