import Thread

class Download(Thread):
    def __init__(self, listing, key, config):
        Thread.__init__(self)
        self.listing = listing
        self.key = key
        self.config = config
        
    def run (self):
        (use_proxy, proxy) = self.config.getProxy()
        key_lock = get_lock(self.key)
        if key_lock != None:
            if use_proxy:
                self.listing.updateFeed(self.key, self.config.getExpiry(), proxy=proxy, imageCache=self.config.getImageCache() )
            else:
                self.listing.updateFeed(self.key, self.config.getExpiry(), imageCache=self.config.getImageCache() )
        del key_lock