import Qt 4.7

Item {
//    anchors.fill: parent;
    width: parent.width; height: parent.height;
    //anchors.top: parent.top; anchors.bottom: parent.bottom
    property bool inEditMode: true

    function reload() {
        categories.reload();
    }

    ListView {
        id: categoryList; model: categories; delegate: categoryDelegate; z: 6;
        cacheBuffer: 100; width: parent.width; height: parent.height;
    }

    XmlListModel {

        id: categories

        source: "http://localhost:8000/categories"
        query: "/xml/category"

        XmlRole { name: "title"; query: "catname/string()" }
        XmlRole { name: "catid"; query: "catid/string()"; isKey: true }
    }

    Component {
        id: categoryDelegate

        Item {

            id: wrapper; width: wrapper.ListView.view.width; height: 86
            Item {
                id: moveMe
                height: parent.height
                Rectangle { color: "black"; opacity: index % 2 ? 0.2 : 0.4; height: 84; width: wrapper.width; y: 1 }
                Rectangle {
                    x: 6; y: 4; width: 77; height: parent.height - 9; color: "white"; smooth: true

                }
                Column {
                    x: 92; width: wrapper.ListView.view.width - 95; y: 15; spacing: 2
                    Text { text: title; color: "white"; width: parent.width; font.bold: true; elide: Text.ElideRight; style: Text.Raised; styleColor: "black" }
                    //Text { text: feedname; width: parent.width; elide: Text.ElideLeft; color: "#cccccc"; style: Text.Raised; styleColor: "black" }
                }
                Item {
                    x: wrapper.ListView.view.width - 128; y: 12
                    height: 58; width: 58;
                    //anchors.horizontalCenter: parent.horizontalCenter;
                    Image { source: "common/images/wmEditIcon.png" }
                    MouseArea {
                        anchors.fill: parent; onClicked: { container.categoryEdit(catname, catid); }
                    }
                    visible: inEditMode
                }
                Item {
                    x: wrapper.ListView.view.width - 64; y: 12
                    height: 58; width: 58;
                    //anchors.horizontalCenter: parent.horizontalCenter;
                    Image { source: "common/images/delete.png" }
                    MouseArea {
                        anchors.fill: parent; onClicked: { container.categoryDeleted(catid); }
                    }
                    visible: inEditMode
                }
            }
            MouseArea { enabled: !inEditMode; anchors.fill: wrapper; onClicked: { container.categoryClicked(catid); } }
        }
    }
}
