import Qt 4.7
import "common" as Common
// Depends on qt4-declarative-qmlviewer

Item {
    width: 480
    height: 640
    id: screen

    Rectangle {
        id: container
        /*anchors.fill: parent;*/ color: "#343434";
        anchors.centerIn: parent
        transformOrigin: Item.Center
        property bool editMode: false

        function categoryClicked(catid) {
            feedsItem.catid = catid;
            categoriesItem.isShown = false;
            feedsItem.visible = true;
        }

        function feedClicked(feedid, updating) {
            flipper.feedid = feedid;
            toolBar.feedUpdating = updating;
            flipper.visible = true;
        }

//        function articleClicked(articleid, index) {
//            // Assign the articleId for the current, next and previous article to the associated variables
//            // Note the modulo, so it goes around
//            //articleDisplay.articleindex = modulo(index,articlesItem.count)
//            //articleDisplay.nextArticle = articlesItem.getArticleid(modulo(index+1,articlesItem.count))
//            //articleDisplay.prevArticle = articlesItem.getArticleid(modulo(index-1,articlesItem.count))
//            //articleDisplay.articleid = articleid
//            //flipper.model = articlesItem.articles
//            flipper.visible = true;
//        }

        function backClicked() {
            if (flipper.visible && flipper.articleShown) {
                // We're viewing an article, and going back to article listing
                flipper.articleShown = false;
                flipper.reload()
                //flipper.articleid = "";
                //flipper.value = 1;
                //articlesItem.reload()
                return;
            }
            if (flipper.visible) {
                feedsItem.reload();
                toolBar.feedUpdating = false;
                flipper.visible = false;
                flipper.feedid = "";
                return;
            }

//            if (articlesItem.visible) {
//                // Viewing articles, going back to feeds
//                //articlesItem.feedid = "";
//                feedsItem.reload();
//                articlesItem.visible = false;
//                //articlesItem.reload();
//                return;
//            }
            if (feedsItem.visible) {
                // Viewing feeds, going back to categories
                //feedsItem.catid = "";
                feedsItem.visible = false;
                //feedsItem.reload();
                categoriesItem.isShown = true;
                return;
            }
            if (!feedsItem.visible) {
                // Viewing categories, quitting
                Qt.quit();
            }
        }

        function categoryDeleted(catid) {
            confirmationMessage.catid=catid;
            confirmationMessage.state="deleteCat";
        }

        function feedDeleted(catid, feedid) {
            confirmationMessage.catid=catid;
            confirmationMessage.feedid=feedid;
            confirmationMessage.state="deleteFeed";
        }

        function feedEdit(feedname, feedid, url) {
            addFeed.feedEdit = true;
            addFeed.feedName = feedname;
            addFeed.feedUrl = url;
            addFeed.visible = true;
        }

        function addCategory(categoryName) {
            var doc = new XMLHttpRequest();
            var url = "http://localhost:8000/addCat/"+categoryName
            doc.open("GET", url);
            doc.send();
            categoriesItem.reload();
            addCat.visible=false;
        }

        function addFeed(catid, feedName, feedURL) {
            var doc = new XMLHttpRequest();
            var url = "http://localhost:8000/addFeed/"+catid + "/" + feedName + "?url=" + feedURL
            doc.open("GET", url);
            doc.send();
            feedsItem.reload();
            //console.log(addFeedDialog.visible)
            addFeedDialog.visible=false;
            //console.log(addFeedDialog.visible)
        }

        function updateClicked(feedid) {
            var doc = new XMLHttpRequest();
            var url = "http://localhost:8000/updateFeed/" + feedid
            doc.open("GET", url);
            doc.send();
        }

        function updateAllClicked() {
            var doc = new XMLHttpRequest();
            var url = "http://localhost:8000/updateAll"
            doc.open("GET", url);
            doc.send();
        }

        Common.Menu {
            id: config
            z: 5
            property string hideReadFeeds : "False"
            property string hideReadArticles : "False"

            property bool isShown: false;

            //width: parent.width; height: parent.height;

            //height: 0
            states: State {
                name: "shown"; when: config.isShown == true
                PropertyChanges { target: config; y: 66 }
            }

            transitions: Transition {
                NumberAnimation { properties: "y"; duration: 300; easing.type: "InOutQuad" }
            }

        }

        Common.ConfirmationMessage {
            id: confirmationMessage;
            property string catid: "";
            property string feedid: "";

            function action() {
                if (state=="markAll") {
                    flipper.markAllAsRead();
                    state="hidden"
                    feedsItem.reload()
                    return;
                }
                if (state=="deleteCat") {
                    var doc = new XMLHttpRequest();
                    var url = "http://localhost:8000/deleteCat/"+catid
                    doc.open("GET", url);
                    doc.send();
                    categoriesItem.reload();
                    state="hidden";
                    return;
                }
                if (state=="deleteFeed") {
                    var doc = new XMLHttpRequest();
                    var url = "http://localhost:8000/deleteFeed/"+catid+"/"+feedid
                    doc.open("GET", url);
                    doc.send();
                    feedsItem.reload();
                    state="hidden";
                    return;
                }
            }
            visible: false
            onOkClicked: action()
            onCancelClicked: visible=false
            state: "hidden"
            states: [ State {name: "markAll";
                    PropertyChanges { target: confirmationMessage; text: qsTr("Do you want to mark all items as read?") }
                    PropertyChanges { target: confirmationMessage; visible: true; }

                }, State {name: "deleteCat";
                    PropertyChanges { target: confirmationMessage; text: qsTr("Do you want to delete this category?") }
                    PropertyChanges { target: confirmationMessage; visible: true; }
                }, State {name: "deleteFeed";
                    PropertyChanges { target: confirmationMessage; text: qsTr("Do you want to delete this feed and all its articles?") }
                    PropertyChanges { target: confirmationMessage; visible: true; }
                }, State {name: "hidden";
                    PropertyChanges { target: confirmationMessage; visible: false; }
                }
            ]

        }

        Common.ToolBar {
            id: toolBar; z: 7
            height: 66; anchors.top: parent.top; width: parent.width; opacity: 0.9
            menuLabel: qsTr("Config"); backLabel: qsTr("Back")
            nextLabel: qsTr("Next"); prevLabel: qsTr("Previous")
            markAllLabel: qsTr("Mark All As Read"); zoomLabel: qsTr("Zoom")
            taskSwitcherLabel: qsTr("Task Switch")
            onMenuClicked: config.isShown = !config.isShown;
            onBackClicked: container.backClicked()
            onPrevClicked: flipper.prev();
            onNextClicked: flipper.next();
            onMarkAllClicked: {
                confirmationMessage.state = "markAll";
            }
            onZoomClicked: { flipper.zoomEnabled = !flipper.zoomEnabled; }
            onTaskSwitcherClicked: {
                var doc = new XMLHttpRequest();
                var url = "http://localhost:8000/task"
                doc.open("GET", url);
                doc.send();
            }
            onAddClicked: {
                if (feedsItem.visible) {
                    addFeedDialog.feedName="";
                    addFeedDialog.catid = feedsItem.catid;
                    addFeedDialog.visible = true;
                    return;
                }
                if (categoriesItem.visible) {
                    addCat.catName="";
                    addCat.visible=true;
                    return;
                }
            }
            onUpdateClicked: {
                if (flipper.visible) {
                    toolBar.feedUpdating = true
                    container.updateClicked(flipper.feedid);
                } else {
                    container.updateAllClicked();
                }
            }

            states: [ State {
                name: "navButtons"; when: flipper.articleShown
                PropertyChanges { target: toolBar; nextVisible: !container.inPortrait; }
                PropertyChanges { target: toolBar; prevVisible: !container.inPortrait; }
                PropertyChanges { target: toolBar; zoomVisible: true; }
                PropertyChanges { target: toolBar; addVisible: false; }
            },
                State {
                    name: "feedButtons"; when: (flipper.visible)&&(!flipper.articleShown)
                    PropertyChanges { target: toolBar; markAllVisible: true; }
                    PropertyChanges { target: toolBar; addVisible: false; }
                    PropertyChanges { target: toolBar; updateVisible: true; }
                },
                State {
                    name: "quitButton"; when: (!feedsItem.visible)
                    PropertyChanges { target: toolBar; quitVisible: true;}
                    PropertyChanges { target: toolBar; backVisible: false; }
                    PropertyChanges { target: toolBar; updateVisible: true; }
                    //PropertyChanges { target: toolBar; addVisible: true; }
                }
            ]
        }

        Item {
            id: views
            //x: 2;
            //y:66;
            width: parent.width // - 4
            height: parent.height-toolBar.height;
            anchors.top: toolBar.bottom; anchors.bottom: parent.bottom
            y: toolBar.height;

            Common.AddCat {
                visible: false;
                id: addCat
                width: parent.width;
                height: parent.height;
                z: 10;
            }

            Common.AddFeed {
                visible: false;
                id: addFeedDialog
                width: parent.width;
                height: parent.height;
                z: 10;
            }

            Timer {
                function checkUpdates() {
                        if (categoriesItem.visible && !feedsItem.visible) {
                            var doc = new XMLHttpRequest();
                            var url = "http://localhost:8000/isUpdating/"
                            doc.onreadystatechange = function() {
                                if (doc.readyState == XMLHttpRequest.DONE) {
                                    var xmlDoc = doc.responseXML.documentElement;
                                    //var els = xmlDoc.getElementsByTagName("updating");
                                    var isUpdating = xmlDoc.firstChild.firstChild.nodeValue;

                                    //console.log(isUpdating);
                                    if (isUpdating=="True") {
                                            toolBar.feedUpdating = true;
                                    } else {
                                        if (toolBar.feedUpdating) {
                                            // We changed from updating to not updating, so we reload the listing
                                            toolBar.feedUpdating = false;
                                            categoriesItem.reload();
                                        }
                                    }
                                    var commands = xmlDoc.lastChild.childNodes;
                                    for (var ii = 0; ii < commands.length; ++ii) {
                                        // process the commands
                                        var command = commands[ii].attributes[0].value; //("c")
                                        //console.log(command)
                                        if (command=="openFeed") {
                                            // Open feed feed
                                            var catid = commands[ii].attributes[1].value;
                                            var feedid = commands[ii].firstChild.nodeValue;
                                            if (!flipper.visible) {
                                                container.categoryClicked(catid);
                                                container.feedClicked(feedid,false);
                                                console.log("feedid: " + feedid);
                                            }
                                        }
                                        if (command=="openArticle") {
                                            // Open feed and article
                                            var catid = commands[ii].attributes[1].value;
                                            var feedid = commands[ii].attributes[2].value; //("key");
                                            var articleid = commands[ii].firstChild.nodeValue;
                                            if (!flipper.visible) {
                                                container.categoryClicked(catid);
                                                container.feedClicked(feedid,false);
                                                flipper.viewArticle(articleid)
                                            }
                                        }
                                        if (command=="addFeed") {
                                            // Open the addFeed dialog
                                            var url = commands[ii].firstChild.nodeValue;
                                            //console.log("add: "+url)

                                        }
                                    }

                                }
                            }
                            doc.open("GET", url);
                            doc.send();
                            //categoriesItem.reload()
                        }
                        if (feedsItem.visible && !flipper.visible) {
                            //feedsItem.reload()
                        }
                        if (flipper.visible) {
                            var doc = new XMLHttpRequest();
                            var url = "http://localhost:8000/isUpdating/" + flipper.feedid
                            doc.onreadystatechange = function() {
                                if (doc.readyState == XMLHttpRequest.DONE) {
                                    var xmlDoc = doc.responseXML.documentElement;
                                    var isUpdating = xmlDoc.firstChild.firstChild.nodeValue;
                                    //console.log(isUpdating);
                                    if (isUpdating=="True") {
                                            toolBar.feedUpdating = true;
                                    } else {
                                        if (toolBar.feedUpdating) {
                                            // We changed from updating to not updating, so we reload the listing
                                            toolBar.feedUpdating = false;
                                            flipper.reload();
                                        }
                                    }
                                }
                            }
                            doc.open("GET", url);
                            doc.send();

                            //flipper.reload()
                        }
                    }
                interval: 2000; running: true; repeat: true
                onTriggered: checkUpdates();
            }

            Categories {
                // Loads the categoryList view and delegate
                id: categoriesItem
                property bool isShown: true;
                inEditMode: container.editMode;

                states: State {
                    name: "shown"; when: categoriesItem.isShown == false
                    PropertyChanges { target: categoriesItem; x: -screen.width }
                }

                transitions: Transition {
                    NumberAnimation { properties: "x"; duration: 300; easing.type: "InOutQuad" }
                }

            }

            Feeds {

                // Loads the feedList view and delegate
                id: feedsItem;
                property string hideReadFeeds: config.hideReadFeeds
                visible: false;
                inEditMode: container.editMode;

                states: [
                    State { name: "articlesShown"; when: flipper.visible; PropertyChanges { target: feedsItem; x: -parent.width } },
                    State { name: "shown"; when: feedsItem.visible; PropertyChanges { target: feedsItem; x: 0 } }
                ]

                transitions: Transition {
                    NumberAnimation { properties: "x"; duration: 300; easing.type: "InOutQuad" }
                }

            }

            ArticleViewer {
                id: flipper
                visible: false;
                property string hideReadArticles: config.hideReadArticles
                property string feedid: ""
                x: parent.width

                states: State { name: "shown"; when: flipper.visible; PropertyChanges { target: flipper; x: 0 }
                    }

                transitions: Transition {
                    NumberAnimation { properties: "x"; duration: 300; easing.type: "InOutQuad" }
                }
            }
        }

//        Text {
//            x: container.width/2
//            y:container.height/2
//            text: runtime.orientation;
//        }

        property bool lockRotation: false
        property variant selectedOrientation: Orientation.UnknownOrientation
        property variant activeOrientation: selectedOrientation == Orientation.UnknownOrientation ? runtime.orientation : selectedOrientation
        property variant oldOrientation: Orientation.Portrait
        state: "orientation " + activeOrientation
        property bool inPortrait: (activeOrientation == Orientation.Portrait || activeOrientation == Orientation.PortraitInverted || activeOrientation==Orientation.UnknownOrientation && (oldOrientation==Orientation.Portrait||oldOrientation==Orientation.PortraitInverted)) ;

        // rotation correction for landscape devices like N900
        property bool landscapeWindow: screen.width > screen.height
        property variant rotationDelta: landscapeWindow ? -90 : 0
        rotation: rotationDelta

        // initial state is portrait
        property real baseWidth: landscapeWindow ? screen.height : screen.width
        property real baseHeight: landscapeWindow ? screen.width : screen.height

        width: baseWidth
        height: baseHeight

        function getAngle(orientation) {
            var angle;
            if (orientation == Orientation.Portrait) {
                angle = 0;
            } else if (orientation == Orientation.Landscape) {
                angle = 90;
            } else if (orientation == Orientation.PortraitInverted) {
                angle = 180;
            } else if (orientation == Orientation.LandscapeInverted) {
                angle = 270;
            } else {
                angle = getAngle(oldOrientation);
            }
            return angle;
        }

        states: [
            State {
                name: "orientation " + Orientation.Landscape
                PropertyChanges {
                    target: container
                    rotation: getAngle(Orientation.Landscape)+rotationDelta
                    width: baseHeight
                    height: baseWidth
                }
                StateChangeScript { script: container.oldOrientation=Orientation.Landscape }
            },
            State {
                name: "orientation " + Orientation.PortraitInverted
                PropertyChanges {
                    target: container
                    rotation: getAngle(Orientation.PortraitInverted)+rotationDelta
                    width: baseWidth
                    height: baseHeight
                }
                StateChangeScript { script: container.oldOrientation=Orientation.PortraitInverted }
            },
            State {
                name: "orientation " + Orientation.LandscapeInverted
                PropertyChanges {
                    target: container
                    rotation: getAngle(Orientation.LandscapeInverted)+rotationDelta
                    width: baseHeight
                    height: baseWidth
                }
                StateChangeScript { script: container.oldOrientation=Orientation.LandscapeInverted }
            },
            State {
                name: "orientation " + Orientation.Portrait
                PropertyChanges {
                    target: container
                    rotation: getAngle(Orientation.Portrait)+rotationDelta
                    width: baseWidth
                    height: baseHeight
                }
                StateChangeScript { script: container.oldOrientation=Orientation.Portrait }
            },
            State {
                name: "orientation 0"
                PropertyChanges {
                    target: container
                    rotation: getAngle(container.oldOrientation)+rotationDelta
                    width: container.inPortrait ? baseWidth : baseHeight
                    height: container.inPortrait ? baseHeight : baseWidth
                }
                //StateChangeScript {  }
            }
        ]
        transitions: Transition {
            ParallelAnimation {
                RotationAnimation {
                    direction: RotationAnimation.Shortest
                    duration: 300
                    easing.type: Easing.InOutQuint
                }
                NumberAnimation {
                    properties: "x,y,width,height"
                    duration: 300
                    easing.type: Easing.InOutQuint
                }
            }
        }

    }
}
