import BaseHTTPServer
import sys
from rss_sqlite import Listing
from xml import sax
from cgi import escape
from re import sub
from htmlentitydefs import name2codepoint
from gconf import client_get_default
from urllib2 import ProxyHandler
from threading import Thread
from os.path import isfile, isdir, exists
from os import mkdir, remove, stat, environ

import logging
logger = logging.getLogger(__name__)

import debugging
debugging.init(dot_directory=".feedingit", program_name="feedingit-web")

CONFIGDIR = environ.get("HOME", "/home/user") + "/.feedingit"
#CONFIGDIR = "/home/user/.feedingit/"

updatingFeeds = []
#commands = [("addFeed","httpwww"), ("openFeed", "xxxx"), ("openArticle", ("feedid","artid"))]
commands = []

def unescape(text):
    def fixup(m):
        text = m.group(0)
        if text[:2] == "&#":
            # character reference
            try:
                if text[:3] == "&#x":
                    return unichr(int(text[3:-1], 16))
                else:
                    return unichr(int(text[2:-1]))
            except ValueError:
                pass
        else:
            # named entity
            try:
                text = unichr(name2codepoint[text[1:-1]])
            except KeyError:
                pass
        return text # leave as is
    return sub("&#?\w+;", fixup, text)

def sanitize(text):
    from cgi import escape
    return escape(text).encode('ascii', 'xmlcharrefreplace')

def start_server():
    global listing
    listing = Listing(config, CONFIGDIR)
    httpd = BaseHTTPServer.HTTPServer(("127.0.0.1", PORT), Handler)
    httpd.serve_forever()

class App():
    def addFeed(self, url):
        commands.append(("addFeed",url))
    
    def getStatus(self):
        pass
    
    def openFeed(self, key):
        commands.append( ("openFeed", key) )
    
    def openArticle(self, key, id):
        commands.append( ("openArticle", key, id) )
        
    def automaticUpdate(self):
        commands.append(("updateAll",))
#        for cat in listing.getListOfCategories():
#            for feed in listing.getSortedListOfKeys("Manual", category=cat):
#                feeds.append(feed)
#        download = Download(listing, feeds)
#        download.start()
    
class Handler(BaseHTTPServer.BaseHTTPRequestHandler):
    def updateAll(self):
        for cat in listing.getListOfCategories():
            for feed in listing.getSortedListOfKeys("Manual", category=cat):
                listing.updateFeed(feed)
    
    def openTaskSwitch(self):
        import subprocess
        subprocess.Popen("dbus-send /com/nokia/hildon_desktop com.nokia.hildon_desktop.exit_app_view", shell=True)
    
    def getCommands(self):
        commandXml = "<commands>"
        for item in commands:
            if item[0]=="addFeed":
                commandXml += "<command c='addFeed'>%s</command>" %(sanitize(item[1]))
            if item[0]=="openFeed":
                key = item[1]
                cat = str(listing.getFeedCategory(key))
                commandXml += "<command c='openFeed' cat='%s'>%s</command>" % (sanitize(cat), sanitize(key) )
            if item[0]=="openArticle":
                key = item[1]
                cat = str(listing.getFeedCategory(key))
                articleid = item[2]
                commandXml += "<command c='openArticle' cat='%s' key='%s'>%s</command>" %(sanitize(cat), sanitize(key), sanitize(articleid) )
            if item[0]=="updateAll":
                self.updateAll()
            commands.remove(item)
        commandXml += "</commands>"
        return commandXml
    
    def getConfigXml(self):
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?><xml>"
        xml += "<hideReadFeed>True</hideReadFeed>"
        xml += "<hideReadArticles>True</hideReadArticles>"
        xml += "</xml>"
        return xml
    
    def generateCategoryXml(self):
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?><xml>"
        for cat in listing.getListOfCategories():
            xml += "<category>"
            xml += "<catname>%s</catname>" %sanitize(listing.getCategoryTitle(cat))
            xml += "<catid>%s</catid>" % cat
            xml += "</category>"
        xml += "</xml>"
        return xml

    def fix_title(self, title):
        return escape(unescape(title).replace("<em>","").replace("</em>","").replace("<nobr>","").replace("</nobr>","").replace("<wbr>","").replace("&mdash;","-"))
    
    def generateFeedsXml(self, catid):
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?><xml>"
        for key in listing.getSortedListOfKeys("Manual", category=catid):
            xml += "<feed>"
            xml += "<feedname>%s</feedname>" %sanitize(listing.getFeedTitle(key))
            xml += "<feedid>%s</feedid>" %key
            xml += "<unread>%s</unread>" %listing.getFeedNumberOfUnreadItems(key)
            xml += "<updatedDate>%s</updatedDate>" %listing.getFeedUpdateTime(key)
            xml += "<icon>%s</icon>" %listing.getFavicon(key)
            if key in updatingFeeds:
                xml += "<updating>True</updating>"
            else:
                xml += "<updating>False</updating>"
            xml += "</feed>"
        xml += "</xml>"
        return xml
    
    def generateArticlesXml(self, key, onlyUnread, markAllAsRead):
        feed = listing.getFeed(key)
        if markAllAsRead=="True":
            feed.markAllAsRead()
            listing.updateUnread(key)
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?><xml>"
        if onlyUnread == "False":
            onlyUnread = False
        for id in feed.getIds(onlyUnread):
            xml += "<article>"
            xml += "<title>%s</title>" %self.fix_title(feed.getTitle(id))
            xml += "<articleid>%s</articleid>" %id
            xml += "<unread>%s</unread>" %str(feed.isEntryRead(id))
            xml += "<updatedDate>%s</updatedDate>" %feed.getDateStamp(id)
            xml += "<path>%s</path>" %feed.getContentLink(id)
            xml += "</article>"
        xml += "</xml>"
        return xml

    def do_GET(self):
        (req, sep, arg) = self.path.partition("?")
        request = req.split("/")
        arguments = {}
        if arg != "":
            args = arg.split("&")
            for arg in args:
                ele = arg.split("=")
                arguments[ele[0]] = ele[1]
        if request[1] == "categories":
            xml = self.generateCategoryXml()
        elif request[1] == "feeds":
            catid = request[2]
            xml = self.generateFeedsXml(catid)
        elif request[1] == "articles":
            key = request[2]
            onlyUnread = arguments.get("onlyUnread","False")
            markAllAsRead = arguments.get("markAllAsRead", "False")
            xml = self.generateArticlesXml(key, onlyUnread, markAllAsRead)
        elif request[1] == "html":
            key = request[2]
            article = request[3]
            feed = listing.getFeed(key)
            try:
                file = open(feed.getContentLink(article))
                html = file.read().replace("body", "body bgcolor='#ffffff'", 1)
                file.close()
            except:
                html = "<html><body>Error retrieving article</body></html>"
            self.send_response(200)
            self.send_header("Content-type", "text/html")
            self.end_headers()
            self.wfile.write(html)
            #listing.updateUnread(key)
            return
        elif request[1] == "isUpdating":
            xml = "<xml>"
            key = request[2]
            if (key in updatingFeeds) or ((key=="") and (len(updatingFeeds)>0)):
                xml += "<updating>True</updating>"
            else:
                xml += "<updating>False</updating>"
            xml += self.getCommands()
            xml += "</xml>"
        elif request[1] == "read":
            key = request[2]
            article = request[3]
            feed = listing.getFeed(key)
            feed.setEntryRead(article)
            listing.updateUnread(key)
            self.send_response(200)
            self.send_header("Content-type", "text/html")
            self.end_headers()
            self.wfile.write("OK")
            return
        elif request[1] == "config":
            xml = self.getConfigXml()
        elif request[1] == "home":
            file = open(self.path)
            self.send_response(200)
            self.send_header("Content-type", "text/html")
            self.end_headers()
            self.wfile.write(file.read())
            file.close()
            return
        elif request[1] == "task":
            self.openTaskSwitch()
            xml = "<xml>OK</xml>"
        elif request[1] == "deleteCat":
            key = request[2]
            listing.removeCategory(key)
            xml = "<xml>OK</xml>"
        elif request[1] == "deleteFeed":
            key = request[3]
            listing.removeFeed(key)
            xml = "<xml>OK</xml>"
        elif request[1] == "addFeed":
            cat = request[2]
            name = request[3]
            url = arguments.get("url","")
            listing.addFeed(name, url, category=cat)
            xml = "<xml>OK</xml>"
        elif request[1] == "updateFeed":
            key = request[2]
            listing.updateFeed(key)
            xml = "<xml>OK</xml>"
        elif request[1]=="updateAll":
            #app.automaticUpdate()
            self.updateAll()
            xml = "<xml>OK</xml>"
        elif request[1] == "addCat":
            catName = request[2]
            listing.addCategory(catName)
            xml = "<xml>OK</xml>"
        else:
            self.send_error(404, "File not found")
            return
        self.send_response(200)
        self.send_header("Content-type", "text/xml")
        self.end_headers()
        self.wfile.write(xml.encode("utf-8"))

PORT = 8000

if not isdir(CONFIGDIR):
    try:
        mkdir(CONFIGDIR)
    except:
        logger.error("Error: Can't create configuration directory")
        from sys import exit
        exit(1)

from config import Config
config = Config(None,CONFIGDIR+"config.ini")

import thread



# Initialize the glib mainloop, for dbus purposes
from feedingitdbus import ServerObject
from updatedbus import UpdateServerObject

import gobject
gobject.threads_init()
import dbus.mainloop.glib
dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
import mainthread
mainthread.init()
from jobmanager import JobManager
JobManager(True)

app = App()
dbusHandler = ServerObject(app)

# Start the HTTP server in a new thread
thread.start_new_thread(start_server, ())

mainloop = gobject.MainLoop()
mainloop.run()
