/***************************************************************************
 *   Copyright (C) 2002~2005 by Yuking                                     *
 *   yuking_net@sohu.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <sys/stat.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>

#ifdef HAVE_MACHINE_ENDIAN_H
#include <machine/endian.h>
#endif

#include "py.h"
#include "PYFA.h"
#include "utf8.c"

static FcitxConfig fc;

#include "pyParser.c"

static int iPYFACount;
static PYFA *PYFAList;
static uint iCounter = 0;
static uint iOrigCounter = 0;
static Bool bPYBaseDictLoaded = False;
static Bool bPYOtherDictLoaded = False;

static PyFreq *pyFreq = NULL, *pCurFreq = NULL;
static uint iPYFreqCount = 0;

static char strFindString[MAX_USER_INPUT + 2];
static ParsePYStruct findMap;
static int iPYInsertPoint = 0;

static PY_SELECTED pySelected[MAX_WORDS_USER_INPUT + 1];
static uint iPYSelected = 0;

static PYCandWord PYCandWords[MAX_CAND_WORD];
static char strPYAuto[MAX_WORDS_USER_INPUT * UTF8_MAX_LENGTH + 1];
static char strPYAutoMap[MAX_WORDS_USER_INPUT * 2 + 1];

static INT8 iNewPYPhraseCount = 0;
static INT8 iOrderCount = 0;
static INT8 iNewFreqCount = 0;

static Bool bIsPYAddFreq = False;
static Bool bIsPYDelFreq = False;
static Bool bIsPYDelUserPhr = False;

static Bool isSavingPYIndex = False;

static int iCandWordCount = 0;
static int iCandPageCount = 0;
static int iCodeInputCount = 0;
static int iCurrentCandPage = 0;
static char strCodeInput[MAX_USER_INPUT + 1];

static char strStringGet[MAX_USER_INPUT + 1];
static Bool bIsDoInputOnly = True;

static void LoadPYPhraseDict(FILE *fp, Bool isSystem);

static void PYInit(void)
{
    if (!bPYBaseDictLoaded)
        LoadPYBaseDict();
    if (!bPYOtherDictLoaded)
        LoadPYOtherDict();
}

static Bool LoadPYBaseDict(void)
{
    fc.iMaxCandWord = 5;
    fc.bFullPY = False;
    fc.bPYCreateAuto = True;
    fc.bPYSaveAutoAsPhrase = False;
    fc.baseOrder = AD_FREQ;
    fc.phraseOrder = AD_FAST;
    fc.freqOrder = AD_NO;

    FILE *fp;
    int i, j;
    uint iLen;

    fp = fopen(PY_BASE_FILE, "r");
    if (!fp)
        return False;

    fread(&iPYFACount, sizeof(int), 1, fp);
    PYFAList = (PYFA *) malloc(sizeof(PYFA) * iPYFACount);
    for (i = 0; i < iPYFACount; i++) {
        fread(PYFAList[i].strMap, sizeof(char) * 2, 1, fp);
        PYFAList[i].strMap[2] = '\0';

        fread(&(PYFAList[i].iBase), sizeof(int), 1, fp);
        PYFAList[i].pyBase = (PyBase *) malloc(sizeof(PyBase) * PYFAList[i].iBase);
        for (j = 0; j < PYFAList[i].iBase; j++) {
            INT8 len;
            fread(&len, sizeof(INT8), 1, fp);
            fread(PYFAList[i].pyBase[j].strHZ, sizeof(char) * len, 1, fp);
            PYFAList[i].pyBase[j].strHZ[len] = '\0';
            fread(&iLen, sizeof(uint), 1, fp);
            PYFAList[i].pyBase[j].iIndex = iLen;
            PYFAList[i].pyBase[j].iHit = iLen;
            PYFAList[i].pyBase[j].flag = 0;
            if (iLen > iCounter)
                iCounter = iLen;
            PYFAList[i].pyBase[j].iPhrase = 0;
            PYFAList[i].pyBase[j].iUserPhrase = 0;
            PYFAList[i].pyBase[j].userPhrase = (PyPhrase *) malloc(sizeof(PyPhrase));
            PYFAList[i].pyBase[j].userPhrase->next = PYFAList[i].pyBase[j].userPhrase;
        }
    }

    fclose(fp);
    bPYBaseDictLoaded = True;

    iOrigCounter = iCounter;

    pyFreq = (PyFreq *) malloc(sizeof(PyFreq));
    pyFreq->next = NULL;

    return True;
}
static void LoadPYPhraseDict(FILE *fp, Bool isSystem)
{
    uint iLen;
    int i, j ,k, count;
    char strBase[UTF8_MAX_LENGTH + 1];
    PyPhrase *temp, *phrase;
    while (!feof(fp)) {
        INT8 clen;
        if (!fread(&i, sizeof(int), 1, fp))
            break;
        if (!fread(&clen, sizeof(INT8), 1, fp))
            break;
        if (!fread(strBase, sizeof(char) * clen, 1, fp))
            break;
        strBase[clen] = '\0';
        if (!fread(&count, sizeof(int), 1, fp))
            break;

        j = GetBaseIndex(i, strBase);
        if (j == -1)
            break;

        if (isSystem)
        {
            phrase = (PyPhrase *) malloc(sizeof(PyPhrase) * count);
            temp = phrase;
        }
        else
        {
            PYFAList[i].pyBase[j].iUserPhrase = count;
            temp = PYFAList[i].pyBase[j].userPhrase;
        }

        for (k = 0; k < count; k++) {
            if (!isSystem)
                phrase = (PyPhrase *) malloc(sizeof(PyPhrase));
            fread(&iLen, sizeof(int), 1, fp);
            phrase->strMap = (char *) malloc(sizeof(char) * (iLen + 1));
            fread(phrase->strMap, sizeof(char) * iLen, 1, fp);
            phrase->strMap[iLen] = '\0';
            fread(&iLen, sizeof(int), 1, fp);
            phrase->strPhrase = (char *) malloc(sizeof(char) * (iLen + 1));
            fread(phrase->strPhrase, sizeof(char) * iLen, 1, fp);
            phrase->strPhrase[iLen] = '\0';
            fread(&iLen, sizeof(uint), 1, fp);
            phrase->iIndex = iLen;
            if (iLen > iCounter)
                iCounter = iLen;
            if (isSystem)
            {
                phrase->iHit = 0;
                phrase->flag = 0;
                phrase ++;
            }
            else
            {
                fread(&iLen, sizeof(int), 1, fp);
                phrase->iHit = iLen;
                phrase->flag = 0;

                phrase->next = temp->next;
                temp->next = phrase;

                temp = phrase;
            }
        }

        if (isSystem)
        {
            if (PYFAList[i].pyBase[j].iPhrase == 0)
            {
                PYFAList[i].pyBase[j].iPhrase = count;
                PYFAList[i].pyBase[j].phrase = temp;
            }
            else
            {
                int m, n;
                Bool *flag = malloc(sizeof(Bool) * count);
                memset(flag, 0, sizeof(Bool) * count);
                int left = count;
                phrase = temp;
                for (m = 0; m < count; m++)
                {
                    for (n = 0; n < PYFAList[i].pyBase[j].iPhrase; n++)
                    {
                        int result = strcmp(PYFAList[i].pyBase[j].phrase[n].strMap, phrase[m].strMap);
                        if (result == 0)
                        {
                            if (strcmp(PYFAList[i].pyBase[j].phrase[n].strPhrase, phrase[m].strPhrase) == 0)
                                break;
                        }
                    }
                    if (n != PYFAList[i].pyBase[j].iPhrase)
                    {
                        flag[m] = 1;
                        left -- ;
                    }
                }
                int orig = PYFAList[i].pyBase[j].iPhrase;
                if (left >= 0)
                {
                    PYFAList[i].pyBase[j].iPhrase += left;
                    PYFAList[i].pyBase[j].phrase = realloc(PYFAList[i].pyBase[j].phrase, sizeof(PyPhrase) * PYFAList[i].pyBase[j].iPhrase);
                }
                for (m = 0; m < count; m ++)
                {
                    if (flag[m])
                    {
                        free(phrase[m].strMap);
                        free(phrase[m].strPhrase);
                    }
                    else
                    {
                        memcpy(&PYFAList[i].pyBase[j].phrase[orig], &phrase[m], sizeof(PyPhrase));
                        orig ++ ;
                    }
                }
                free(flag);
                free(phrase);
            }
        }
    }
}

static Bool LoadPYOtherDict(void)
{
    //下面开始读系统词组
    FILE *fp;
/*    int i, j, k, iLen;
    uint iIndex;
*/
    bPYOtherDictLoaded = True;

    fp = fopen(PY_PHRASE_FILE, "r");
    if (!fp)
        fprintf(stderr, "Can not find System Database of Pinyin!");
    else {
        LoadPYPhraseDict(fp, True);
        fclose(fp);
    }
#if 0
    //下面读取索引文件
    fp = fopen(PY_INDEX_FILE, "rb");
    if (fp) {
        fread(&iLen, sizeof(uint), 1, fp);
        if (iLen > iCounter)
            iCounter = iLen;
        while (!feof(fp)) {
            fread(&i, sizeof(int), 1, fp);
            fread(&j, sizeof(int), 1, fp);
            fread(&k, sizeof(int), 1, fp);
            fread(&iIndex, sizeof(uint), 1, fp);
            fread(&iLen, sizeof(uint), 1, fp);
            /* data is bad, break */
            if (i>=0 && i < iPYFACount) {
                if (j>=0 && j < PYFAList[i].iBase) {
                    if (k < PYFAList[i].pyBase[j].iPhrase) {
                        if (k >= 0) {
                            PYFAList[i].pyBase[j].phrase[k].iIndex = iIndex;
                            PYFAList[i].pyBase[j].phrase[k].iHit = iLen;
                        } else {
                            PYFAList[i].pyBase[j].iIndex = iIndex;
                            PYFAList[i].pyBase[j].iHit = iLen;
                        }
                    }
                }
            }
        }

        fclose(fp);
    }
#endif
    return True;
}

static void ResetPYStatus()
{
    iPYInsertPoint = 0;
    iPYSelected = 0;
    strFindString[0] = '\0';
    strPYAuto[0] = '\0';

    bIsPYAddFreq = False;
    bIsPYDelFreq = False;
    bIsPYDelUserPhr = False;

    findMap.iMode = PARSE_SINGLEHZ;     //只要不是PARSE_ERROR就可以
}

static int GetBaseIndex(int iPYFA, char *strBase)
{
    int i;

    if (iPYFA < iPYFACount) {
        for (i = 0; i < PYFAList[iPYFA].iBase; i++) {
            if (!strcmp(strBase, PYFAList[iPYFA].pyBase[i].strHZ))
                return i;
        }
    }

    return -1;
}
static void PYGetSelectedText(char *strText)
{
  if(iPYSelected == 0)
    return;
  int i = 0;
  for(; i < iPYSelected; i++){
    strcat(strText, pySelected[i].strHZ);
  }
}
static INPUT_RETURN_VALUE DoPYInput(unsigned int iKey)
{
    int i = 0;
    int val;
    char *strGet = NULL;
    char strTemp[MAX_USER_INPUT + 1];

    if (!bPYBaseDictLoaded)
        LoadPYBaseDict();
    if (!bPYOtherDictLoaded)
        LoadPYOtherDict();

    val = IRV_TO_PROCESS;
    if (!bIsPYAddFreq && !bIsPYDelFreq && !bIsPYDelUserPhr) {
        if(iKey == ',' || iKey == '.')
            iKey = PY_SEPARATOR;
        if ((iKey >= 'a' && iKey <= 'z') || iKey == PY_SEPARATOR) {

            if (iKey == PY_SEPARATOR) {
                if (!iPYInsertPoint)
                    return IRV_TO_PROCESS;
                if (strFindString[iPYInsertPoint - 1] == PY_SEPARATOR)
                    return IRV_DO_NOTHING;
            }

            val = i = strlen(strFindString);

            for (; i > iPYInsertPoint; i--)
                strFindString[i] = strFindString[i - 1];

            strFindString[iPYInsertPoint++] = iKey;
            strFindString[val + 1] = '\0';
            ParsePY(strFindString, &findMap, PY_PARSE_INPUT_USER, False);

            val = 0;
            for (i = 0; i < iPYSelected; i++)
                val += utf8_strlen(pySelected[i].strHZ);

            if (findMap.iHZCount > (MAX_WORDS_USER_INPUT - val)) {
                UpdateFindString(val);
                ParsePY(strFindString, &findMap, PY_PARSE_INPUT_USER, False);
            }

            val = IRV_DISPLAY_CANDWORDS;
        } else if (iKey == 8) /*XK_BackSpace*/ {
            if (iPYInsertPoint) {
                val = ((iPYInsertPoint > 1)
                       && (strFindString[iPYInsertPoint - 2] == PY_SEPARATOR)) ? 2 : 1;
                int len = strlen(strFindString + iPYInsertPoint), i = 0;
                /* 这里使用<=而不是<是因为还有'\0'需要拷贝 */
                for (i = 0; i <= len; i++)
                    strFindString[i + iPYInsertPoint - val] = strFindString[i + iPYInsertPoint];
                ParsePY(strFindString, &findMap, PY_PARSE_INPUT_USER, False);
                iPYInsertPoint -= val;
                val = IRV_DISPLAY_CANDWORDS;

                if (!strlen(strFindString)) {
                    if (!iPYSelected)
                        return IRV_CLEAN;

                    val = strlen(strFindString);
                    strcpy(strTemp, pySelected[iPYSelected - 1].strPY);
                    strcat(strTemp, strFindString);
                    strcpy(strFindString, strTemp);
                    iPYInsertPoint = strlen(strFindString) - val;
                    iPYSelected--;
                    ParsePY(strFindString, &findMap, PY_PARSE_INPUT_USER, False);
                }

                val = IRV_DISPLAY_CANDWORDS;
            }
        } else if (iKey == ' ') {
            if (True) {
                if (findMap.iMode == PARSE_ERROR)
                    return IRV_DO_NOTHING;

                if (!iCandWordCount) {
                    return IRV_TO_PROCESS;
                }

                strGet = PYGetCandWord(0);

                if (strGet) {
                    strcpy(strStringGet, strGet);

                    val = IRV_GET_CANDWORDS;
                } else
                    val = IRV_DISPLAY_CANDWORDS;
            }
        }
    }

    if (val == IRV_TO_PROCESS) {
        if (iKey >= '0' && iKey <= '9') {
            iKey -= '0';
            if (iKey == 0)
                iKey = 10;

            if (True) {
                if (!iCodeInputCount)
                    return IRV_TO_PROCESS;
                else if (!iCandWordCount || (iKey > iCandWordCount))
                    return IRV_DO_NOTHING;
                else {
                    if (bIsPYAddFreq || bIsPYDelFreq || bIsPYDelUserPhr) {
                        if (bIsPYAddFreq) {
                            PYAddFreq(iKey - 1);
                            bIsPYAddFreq = False;
                        } else if (bIsPYDelFreq) {
                            PYDelFreq(iKey - 1);
                            bIsPYDelFreq = False;
                        } else {
                            if (PYCandWords[iKey - 1].iWhich == PY_CAND_USERPHRASE)
                                PYDelUserPhrase(PYCandWords[iKey - 1].cand.phrase.iPYFA,
                                                PYCandWords[iKey - 1].cand.phrase.iBase, PYCandWords[iKey - 1].cand.phrase.phrase);
                            bIsPYDelUserPhr = False;
                        }
                        bIsDoInputOnly = False;

                        val = IRV_DISPLAY_CANDWORDS;
                    } else {
                        strGet = PYGetCandWord(iKey - 1);
                        if (strGet) {
                            strcpy(strStringGet, strGet);

                            val = IRV_GET_CANDWORDS;
                        } else
                            val = IRV_DISPLAY_CANDWORDS;
                    }
                }
            }
        } else if (iKey == -1) {
            ParsePY(strFindString, &findMap, PY_PARSE_INPUT_USER, False);
            iPYInsertPoint = 0;
            val = IRV_DISPLAY_CANDWORDS;
        } else {
            if (bIsPYAddFreq || bIsPYDelFreq || bIsPYDelUserPhr)
                return IRV_DO_NOTHING;
        }
    }

    UpdateCodeInputPY();
    if (val == IRV_DISPLAY_CANDWORDS) {
        return PYGetCandWords(SM_FIRST);
    }
    return (INPUT_RETURN_VALUE) val;
}

/*
 * 由于拼音的编辑功能修改了strFindString，必须保证strCodeInput与用户的输入一致
 */
static void UpdateCodeInputPY(void)
{
    int i;

    strCodeInput[0] = '\0';
    for (i = 0; i < iPYSelected; i++)
        strcat(strCodeInput, pySelected[i].strPY);
    strcat(strCodeInput, strFindString);
    iCodeInputCount = strlen(strCodeInput);
}

static void PYResetFlags(void)
{
    int i, j, k;
    PyPhrase *phrase;
    PyFreq *freq;
    HZ *hz;

    for (i = 0; i < iPYFACount; i++) {
        for (j = 0; j < PYFAList[i].iBase; j++) {
            PYFAList[i].pyBase[j].flag = 0;
            for (k = 0; k < PYFAList[i].pyBase[j].iPhrase; k++)
                PYFAList[i].pyBase[j].phrase[k].flag = 0;
            phrase = PYFAList[i].pyBase[j].userPhrase->next;
            for (k = 0; k < PYFAList[i].pyBase[j].iUserPhrase; k++) {
                phrase->flag = 0;
                phrase = phrase->next;
            }
        }
    }

    freq = pyFreq->next;
    for (i = 0; i < iPYFreqCount; i++) {
        hz = freq->HZList->next;
        for (j = 0; j < freq->iCount; j++) {
            hz->flag = False;
            hz = hz->next;
        }
        freq = freq->next;
    }
}

static void UpdateFindString(int val)
{
    int i;

    strFindString[0] = '\0';
    for (i = 0; i < findMap.iHZCount; i++) {
        if (i >= MAX_WORDS_USER_INPUT - val)
            break;
        strcat(strFindString, findMap.strPYParsed[i]);
    }
    if (iPYInsertPoint > strlen(strFindString))
        iPYInsertPoint = strlen(strFindString);
}

static INPUT_RETURN_VALUE PYGetCandWords(SEARCH_MODE mode)
{
    int iVal;

    if (findMap.iMode == PARSE_ERROR) {
        iCandPageCount = 0;
        iCandWordCount = 0;

        return IRV_DISPLAY_MESSAGE;
    }

    if (mode == SM_FIRST) {
        iCurrentCandPage = 0;
        iCandPageCount = 0;
        iCandWordCount = 0;

        PYResetFlags();

        //判断是不是要输入常用字或符号
        pCurFreq = pyFreq->next;
        for (iVal = 0; iVal < iPYFreqCount; iVal++) {
            if (!strcmp(strFindString, pCurFreq->strPY))
                break;
            pCurFreq = pCurFreq->next;
        }

        if (fc.bPYCreateAuto)
            PYCreateAuto();
    } else {
        if (!iCandPageCount)
            return IRV_TO_PROCESS;

        if (mode == SM_NEXT) {
            if (iCurrentCandPage == iCandPageCount)
                return IRV_DO_NOTHING;

            iCurrentCandPage++;
        } else {
            if (!iCurrentCandPage)
                return IRV_DO_NOTHING;

            iCurrentCandPage--;
            //需要将目前的候选词的标志重置
            PYSetCandWordsFlag(False);
        }

        iCandWordCount = 0;
    }

    if (!(pCurFreq && pCurFreq->bIsSym)) {
        if (!iCurrentCandPage && strPYAuto[0]) {
            iCandWordCount = 1;
            PYCandWords[0].iWhich = PY_CAND_AUTO;
        }
    }

    if (mode != SM_PREV) {
        PYGetCandWordsForward();

        if (iCurrentCandPage == iCandPageCount) {
            if (PYCheckNextCandPage())
                iCandPageCount++;
        }
    } else
        PYGetCandWordsBackward();

    return IRV_DISPLAY_CANDWORDS;
}

static void PYGetCandText(int iIndex, char *strText)
{
    char *pBase = NULL, *pPhrase;

    if (PYCandWords[iIndex].iWhich == PY_CAND_AUTO)
        strcpy(strText, strPYAuto);
    else {
        pPhrase = NULL;

        switch (PYCandWords[iIndex].iWhich) {
        case PY_CAND_BASE:     //是系统单字
            pBase = PYFAList[PYCandWords[iIndex].cand.base.iPYFA].pyBase[PYCandWords[iIndex].cand.base.iBase].strHZ;
            break;
        case PY_CAND_USERPHRASE:       //是用户词组
        case PY_CAND_SYMPHRASE:        //是系统词组
            pBase = PYFAList[PYCandWords[iIndex].cand.phrase.iPYFA].pyBase[PYCandWords[iIndex].cand.phrase.iBase].strHZ;
            pPhrase = PYCandWords[iIndex].cand.phrase.phrase->strPhrase;
            break;
        case PY_CAND_FREQ:     //是常用字
            pBase = PYCandWords[iIndex].cand.freq.hz->strHZ;
            break;
        case PY_CAND_SYMBOL:   //是特殊符号
            pBase = PYCandWords[iIndex].cand.freq.hz->strHZ;
            break;
        }

        strcpy(strText, pBase);
        if (pPhrase)
            strcat(strText, pPhrase);
    }
}

static void PYSetCandWordsFlag(Bool flag)
{
    int i;

    for (i = 0; i < iCandWordCount; i++)
        PYSetCandWordFlag(i, flag);
}

static void PYSetCandWordFlag(int iIndex, Bool flag)
{
    switch (PYCandWords[iIndex].iWhich) {
    case PY_CAND_BASE:
        PYFAList[PYCandWords[iIndex].cand.base.iPYFA].pyBase[PYCandWords[iIndex].cand.base.iBase].flag = flag;
        break;
    case PY_CAND_SYMPHRASE:
    case PY_CAND_USERPHRASE:
        PYCandWords[iIndex].cand.phrase.phrase->flag = flag;
        break;
    case PY_CAND_FREQ:
        PYCandWords[iIndex].cand.freq.hz->flag = flag;
    case PY_CAND_SYMBOL:
        PYCandWords[iIndex].cand.sym.hz->flag = flag;
        break;
    }
}

/*
 * 根据用户的录入自动生成一个汉字组合
 * 此处采用的策略是按照使用频率最高的字/词
 */
static void PYCreateAuto(void)
{
    PYCandIndex candPos;
    int val;
    int iMatchedLength;
    char str[3];
    PyPhrase *phrase;
    PyPhrase *phraseSelected = NULL;
    PyBase *baseSelected = NULL;
    PYFA *pPYFA = NULL;
    char strMap[MAX_WORDS_USER_INPUT * 2 + 1];
    int iCount;

    strPYAuto[0] = '\0';
    strPYAutoMap[0] = '\0';
    str[2] = '\0';

    if (findMap.iHZCount == 1)
        return;

    while (utf8_strlen(strPYAuto) < findMap.iHZCount) {
        phraseSelected = NULL;
        baseSelected = NULL;

        iCount = utf8_strlen(strPYAuto);
        str[0] = findMap.strMap[iCount][0];
        str[1] = findMap.strMap[iCount][1];

        strMap[0] = '\0';

        for (val = iCount + 1; val < findMap.iHZCount; val++)
            strcat(strMap, findMap.strMap[val]);

        candPos.iPYFA = 0;
        candPos.iBase = 0;
        candPos.iPhrase = 0;
        if ((findMap.iHZCount - iCount) > 1) {
            for (candPos.iPYFA = 0; candPos.iPYFA < iPYFACount; candPos.iPYFA++) {
                if (!Cmp2Map(PYFAList[candPos.iPYFA].strMap, str, False)) {
                    for (candPos.iBase = 0; candPos.iBase < PYFAList[candPos.iPYFA].iBase; candPos.iBase++) {
                        phrase = PYFAList[candPos.iPYFA].pyBase[candPos.iBase].userPhrase->next;
                        for (candPos.iPhrase = 0;
                             candPos.iPhrase < PYFAList[candPos.iPYFA].pyBase[candPos.iBase].iUserPhrase; candPos.iPhrase++) {
                            val = CmpMap(phrase->strMap, strMap, &iMatchedLength, False);
                            if (!val && iMatchedLength == (findMap.iHZCount - 1) * 2)
                                return;
                            if (!val || (val && (strlen(phrase->strMap) == iMatchedLength))) {
                                if (!phraseSelected) {
                                    baseSelected = &(PYFAList[candPos.iPYFA].pyBase[candPos.iBase]);
                                    pPYFA = &PYFAList[candPos.iPYFA];
                                    phraseSelected = phrase;
                                } else if (strlen(phrase->strMap) <= (findMap.iHZCount - 1) * 2) {
                                    if (strlen(phrase->strMap) == strlen(phraseSelected->strMap)) {
                                        //先看词频，如果词频一样，再最近优先
                                        if ((phrase->iHit > phraseSelected->iHit)
                                            || ((phrase->iHit == phraseSelected->iHit)
                                                && (phrase->iIndex > phraseSelected->iIndex))) {
                                            baseSelected = &(PYFAList[candPos.iPYFA].pyBase[candPos.iBase]);
                                            pPYFA = &PYFAList[candPos.iPYFA];
                                            phraseSelected = phrase;
                                        }
                                    } else if (strlen(phrase->strMap) > strlen(phraseSelected->strMap)) {
                                        baseSelected = &(PYFAList[candPos.iPYFA].pyBase[candPos.iBase]);
                                        pPYFA = &PYFAList[candPos.iPYFA];
                                        phraseSelected = phrase;
                                    }
                                }
                            }
                            phrase = phrase->next;
                        }
                    }
                }
            }

            for (candPos.iPYFA = 0; candPos.iPYFA < iPYFACount; candPos.iPYFA++) {
                if (!Cmp2Map(PYFAList[candPos.iPYFA].strMap, str, False)) {
                    for (candPos.iBase = 0; candPos.iBase < PYFAList[candPos.iPYFA].iBase; candPos.iBase++) {
                        for (candPos.iPhrase = 0;
                             candPos.iPhrase < PYFAList[candPos.iPYFA].pyBase[candPos.iBase].iPhrase; candPos.iPhrase++) {
                                val =
                                    CmpMap(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].strMap,
                                           strMap, &iMatchedLength, False);
                                if (!val && iMatchedLength == (findMap.iHZCount - 1) * 2)
                                    return;
                                if (!val || (val && (strlen(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].strMap)
                                                     == iMatchedLength))) {
                                    if (!phraseSelected) {
                                        baseSelected = &(PYFAList[candPos.iPYFA].pyBase[candPos.iBase]);
                                        pPYFA = &PYFAList[candPos.iPYFA];
                                        phraseSelected = &(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase]);
                                    } else if (strlen(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].strMap)
                                               <= (findMap.iHZCount - 1) * 2) {
                                        if (strlen(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].strMap)
                                            == strlen(phraseSelected->strMap)) {
                                            //先看词频，如果词频一样，再最近优先
                                            if ((PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].iHit >
                                                 phraseSelected->iHit)
                                                ||
                                                ((PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].iHit ==
                                                  phraseSelected->iHit)
                                                 &&
                                                 (PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].iIndex >
                                                  phraseSelected->iIndex))) {
                                                baseSelected = &(PYFAList[candPos.iPYFA].pyBase[candPos.iBase]);
                                                pPYFA = &PYFAList[candPos.iPYFA];
                                                phraseSelected = &(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase]);
                                            }
                                        } else if (strlen(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].strMap)
                                                   > strlen(phraseSelected->strMap)) {
                                            baseSelected = &(PYFAList[candPos.iPYFA].pyBase[candPos.iBase]);
                                            pPYFA = &PYFAList[candPos.iPYFA];
                                            phraseSelected = &(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase]);
                                        }
                                    }
                            }
                        }
                    }
                }
            }
            if (baseSelected) {
                strcat(strPYAuto, baseSelected->strHZ);
                strcat(strPYAutoMap, pPYFA->strMap);
                strcat(strPYAuto, phraseSelected->strPhrase);
                strcat(strPYAutoMap, phraseSelected->strMap);
            }
        }

        if (!baseSelected) {
            val = -1;
            baseSelected = NULL;
            for (candPos.iPYFA = 0; candPos.iPYFA < iPYFACount; candPos.iPYFA++) {
                if (!Cmp2Map(PYFAList[candPos.iPYFA].strMap, str, False)) {
                    for (candPos.iBase = 0; candPos.iBase < PYFAList[candPos.iPYFA].iBase; candPos.iBase++) {
                            if ((int)
                                (PYFAList[candPos.iPYFA].pyBase[candPos.iBase].iHit) > val) {
                                val = PYFAList[candPos.iPYFA].pyBase[candPos.iBase].iHit;
                                baseSelected = &(PYFAList[candPos.iPYFA].pyBase[candPos.iBase]);
                                pPYFA = &PYFAList[candPos.iPYFA];
                            }
                    }
                }
            }

            if (baseSelected) {
                strcat(strPYAuto, baseSelected->strHZ);
                strcat(strPYAutoMap, pPYFA->strMap);
            } else {            //出错了
                strPYAuto[0] = '\0';
                return;
            }
        }
    }
}

static char *PYGetCandWord(int iIndex)
{
    char *pBase = NULL, *pPhrase = NULL;
    char *pBaseMap = NULL, *pPhraseMap = NULL;
    uint *pIndex = NULL;
    Bool bAddNewPhrase = True;
    int i;
    char strHZString[MAX_WORDS_USER_INPUT * UTF8_MAX_LENGTH + 1];
    int iLen;

    if (!iCandWordCount)
        return NULL;
    if (iIndex > (iCandWordCount - 1))
        iIndex = iCandWordCount - 1;
    switch (PYCandWords[iIndex].iWhich) {
    case PY_CAND_AUTO:
        pBase = strPYAuto;
        pBaseMap = strPYAutoMap;
        bAddNewPhrase = fc.bPYSaveAutoAsPhrase;
        break;
    case PY_CAND_BASE:         //是系统单字
        pBase = PYFAList[PYCandWords[iIndex].cand.base.iPYFA].pyBase[PYCandWords[iIndex].cand.base.iBase].strHZ;
        pBaseMap = PYFAList[PYCandWords[iIndex].cand.base.iPYFA].strMap;
        pIndex = &(PYFAList[PYCandWords[iIndex].cand.base.iPYFA].pyBase[PYCandWords[iIndex].cand.base.iBase].iIndex);
        PYFAList[PYCandWords[iIndex].cand.base.iPYFA].pyBase[PYCandWords[iIndex].cand.base.iBase].iHit++;
        iOrderCount++;
        break;
    case PY_CAND_SYMPHRASE:    //是系统词组
    case PY_CAND_USERPHRASE:   //是用户词组
        pBase = PYFAList[PYCandWords[iIndex].cand.phrase.iPYFA].pyBase[PYCandWords[iIndex].cand.phrase.iBase].strHZ;
        pBaseMap = PYFAList[PYCandWords[iIndex].cand.phrase.iPYFA].strMap;
        pPhrase = PYCandWords[iIndex].cand.phrase.phrase->strPhrase;
        pPhraseMap = PYCandWords[iIndex].cand.phrase.phrase->strMap;
        pIndex = &(PYCandWords[iIndex].cand.phrase.phrase->iIndex);
        PYCandWords[iIndex].cand.phrase.phrase->iHit++;
        iOrderCount++;
        break;
    case PY_CAND_FREQ:         //是常用字
        pBase = PYCandWords[iIndex].cand.freq.hz->strHZ;
        pBaseMap = PYFAList[PYCandWords[iIndex].cand.freq.hz->iPYFA].strMap;
        PYCandWords[iIndex].cand.freq.hz->iHit++;
        pIndex = &(PYCandWords[iIndex].cand.freq.hz->iIndex);
        iNewFreqCount++;
        break;
    case PY_CAND_SYMBOL:       //是特殊符号
        pBase = PYCandWords[iIndex].cand.freq.hz->strHZ;
        bAddNewPhrase = False;
        break;
    }

    if (pIndex && (*pIndex != iCounter))
        *pIndex = ++iCounter;
    if (iOrderCount >= AUTOSAVE_ORDER_COUNT) {
        SavePYIndex();
        iOrderCount = 0;
    }
    if (iNewFreqCount >= AUTOSAVE_FREQ_COUNT) {
        iNewFreqCount = 0;
    }

    strcpy(strHZString, pBase);
    if (pPhrase)
        strcat(strHZString, pPhrase);
    iLen = utf8_strlen(strHZString);
    if (iLen == findMap.iHZCount || PYCandWords[iIndex].iWhich == PY_CAND_SYMBOL) {
        strPYAuto[0] = '\0';
        for (iLen = 0; iLen < iPYSelected; iLen++)
            strcat(strPYAuto, pySelected[iLen].strHZ);
        strcat(strPYAuto, strHZString);
        ParsePY(strCodeInput, &findMap, PY_PARSE_INPUT_USER, False);
        strHZString[0] = '\0';
        for (i = 0; i < iPYSelected; i++)
            strcat(strHZString, pySelected[i].strMap);
        if (pBaseMap)
            strcat(strHZString, pBaseMap);
        if (pPhraseMap)
            strcat(strHZString, pPhraseMap);
        if (bAddNewPhrase && (utf8_strlen(strPYAuto) <= (MAX_PY_PHRASE_LENGTH)))
            PYAddUserPhrase(strPYAuto, strHZString);

        return strPYAuto;
    }
    //此时进入自造词状态
    pySelected[iPYSelected].strPY[0] = '\0';
    pySelected[iPYSelected].strMap[0] = '\0';
    for (i = 0; i < iLen; i++)
        strcat(pySelected[iPYSelected].strPY, findMap.strPYParsed[i]);
    if (pBaseMap)
        strcat(pySelected[iPYSelected].strMap, pBaseMap);
    if (pPhraseMap)
        strcat(pySelected[iPYSelected].strMap, pPhraseMap);
    strcpy(pySelected[iPYSelected].strHZ, strHZString);
    iPYSelected++;
    strFindString[0] = '\0';
    for (; i < findMap.iHZCount; i++)
        strcat(strFindString, findMap.strPYParsed[i]);
    DoPYInput(-1);
    iPYInsertPoint = strlen(strFindString);
    return NULL;
}

static void PYGetCandWordsForward(void)
{
    PYGetPhraseCandWords(SM_NEXT);
    if (pCurFreq)
        PYGetFreqCandWords(SM_NEXT);

    if (!(pCurFreq && pCurFreq->bIsSym))
        PYGetBaseCandWords(SM_NEXT);
}

static void PYGetCandWordsBackward(void)
{
    PYGetFreqCandWords(SM_PREV);
    PYGetBaseCandWords(SM_PREV);
    if (iCandWordCount == fc.iMaxCandWord)
        return;
    PYGetPhraseCandWords(SM_PREV);
}

static Bool PYCheckNextCandPage(void)
{
    PYCandIndex candPos;
    int val;
    int iMatchedLength;
    char str[3];
    PyPhrase *phrase;
    char strMap[MAX_WORDS_USER_INPUT * 2 + 1];
    HZ *hz;

    str[0] = findMap.strMap[0][0];
    str[1] = findMap.strMap[0][1];
    str[2] = '\0';
    strMap[0] = '\0';
    if (pCurFreq && pCurFreq->bIsSym) {
        hz = pCurFreq->HZList->next;
        for (val = 0; val < pCurFreq->iCount; val++) {
            if (!hz->flag)
                return True;
            hz = hz->next;
        }
    } else {
        if (findMap.iHZCount > 1) {
            for (val = 1; val < findMap.iHZCount; val++)
                strcat(strMap, findMap.strMap[val]);
            for (candPos.iPYFA = 0; candPos.iPYFA < iPYFACount; candPos.iPYFA++) {
                if (!Cmp2Map(PYFAList[candPos.iPYFA].strMap, str, False)) {
                    for (candPos.iBase = 0; candPos.iBase < PYFAList[candPos.iPYFA].iBase; candPos.iBase++) {
                        phrase = PYFAList[candPos.iPYFA].pyBase[candPos.iBase].userPhrase->next;
                        for (candPos.iPhrase = 0;
                             candPos.iPhrase < PYFAList[candPos.iPYFA].pyBase[candPos.iBase].iUserPhrase; candPos.iPhrase++) {
                            val = CmpMap(phrase->strMap, strMap, &iMatchedLength, False);
                            if (!val || (val && (strlen(phrase->strMap) == iMatchedLength))) {
                                    if (!phrase->flag)
                                        return True;
                            }
                            phrase = phrase->next;
                        }
                    }
                }
            }

            for (candPos.iPYFA = 0; candPos.iPYFA < iPYFACount; candPos.iPYFA++) {
                if (!Cmp2Map(PYFAList[candPos.iPYFA].strMap, str, False)) {
                    for (candPos.iBase = 0; candPos.iBase < PYFAList[candPos.iPYFA].iBase; candPos.iBase++) {
                        for (candPos.iPhrase = 0;
                             candPos.iPhrase < PYFAList[candPos.iPYFA].pyBase[candPos.iBase].iPhrase; candPos.iPhrase++) {
                            if (!PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].flag) {
                                val =
                                    CmpMap(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].strMap,
                                           strMap, &iMatchedLength, False);
                                if (!val || (val && (strlen(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].strMap)
                                                     == iMatchedLength))) {
                                        return True;
                                }
                            }
                        }
                    }
                }
            }
        }

        if (pCurFreq) {
            hz = pCurFreq->HZList->next;
            for (val = 0; val < pCurFreq->iCount; val++) {
                if (!hz->flag)
                    return True;
                hz = hz->next;
            }
        }

        for (candPos.iPYFA = 0; candPos.iPYFA < iPYFACount; candPos.iPYFA++) {
            if (!Cmp2Map(PYFAList[candPos.iPYFA].strMap, str, False)) {
                for (candPos.iBase = 0; candPos.iBase < PYFAList[candPos.iPYFA].iBase; candPos.iBase++) {
                    if (!PYFAList[candPos.iPYFA].pyBase[candPos.iBase].flag) {
                            return True;
                    }
                }
            }
        }
    }

    return False;
}

static void PYGetPhraseCandWords(SEARCH_MODE mode)
{
    PYCandIndex candPos;
    char str[3];
    int val, iMatchedLength;
    char strMap[MAX_WORDS_USER_INPUT * 2 + 1];
    PyPhrase *phrase;

    if (findMap.iHZCount == 1)
        return;
    str[0] = findMap.strMap[0][0];
    str[1] = findMap.strMap[0][1];
    str[2] = '\0';
    strMap[0] = '\0';
    for (val = 1; val < findMap.iHZCount; val++)
        strcat(strMap, findMap.strMap[val]);
    for (candPos.iPYFA = 0; candPos.iPYFA < iPYFACount; candPos.iPYFA++) {
        if (!Cmp2Map(PYFAList[candPos.iPYFA].strMap, str, False)) {
            for (candPos.iBase = 0; candPos.iBase < PYFAList[candPos.iPYFA].iBase; candPos.iBase++) {
                    phrase = PYFAList[candPos.iPYFA].pyBase[candPos.iBase].userPhrase->next;
                    for (candPos.iPhrase = 0;
                         candPos.iPhrase < PYFAList[candPos.iPYFA].pyBase[candPos.iBase].iUserPhrase; candPos.iPhrase++) {
                            val = CmpMap(phrase->strMap, strMap, &iMatchedLength, False);
                            if (!val || (val && (strlen(phrase->strMap) == iMatchedLength))) {
                                if ((mode != SM_PREV && !phrase->flag)
                                    || (mode == SM_PREV && phrase->flag)) {
                                    if (!PYAddPhraseCandWord(candPos, phrase, mode, False))
                                        goto _end;
                                }
                            }

                        phrase = phrase->next;
                    }
            }
        }
    }

    for (candPos.iPYFA = 0; candPos.iPYFA < iPYFACount; candPos.iPYFA++) {
        if (!Cmp2Map(PYFAList[candPos.iPYFA].strMap, str, False)) {
            for (candPos.iBase = 0; candPos.iBase < PYFAList[candPos.iPYFA].iBase; candPos.iBase++) {
                    for (candPos.iPhrase = 0; candPos.iPhrase < PYFAList[candPos.iPYFA].pyBase[candPos.iBase].iPhrase; candPos.iPhrase++) {
                            val =
                                CmpMap(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].strMap,
                                       strMap, &iMatchedLength, False);
                            if (!val
                                || (val
                                    &&
                                    (strlen
                                     (PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].strMap) == iMatchedLength))) {
                                if ((mode != SM_PREV && !PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].flag)
                                    || (mode == SM_PREV && PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase].flag)) {
                                    if (!PYAddPhraseCandWord
                                        (candPos, &(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].phrase[candPos.iPhrase]), mode, True))
                                        goto _end;
                                }
                            }
                    }
            }
        }
    }

  _end:
    PYSetCandWordsFlag(True);
}

/*
 * 将一个词加入到候选列表的合适位置中
 * b = True 表示是系统词组，False表示是用户词组
 */
static Bool PYAddPhraseCandWord(PYCandIndex pos, PyPhrase * phrase, SEARCH_MODE mode, Bool b)
{
    char str[MAX_WORDS_USER_INPUT * UTF8_MAX_LENGTH + 1];
    int i = 0, j, iStart = 0;

    strcpy(str, PYFAList[pos.iPYFA].pyBase[pos.iBase].strHZ);
    strcat(str, phrase->strPhrase);
    if (strPYAuto[0]) {
        if (!strcmp(strPYAuto, str)) {
            phrase->flag = 1;
            return True;
        }
    }

    switch (fc.phraseOrder) {
    case AD_NO:
        if (mode == SM_PREV) {
            for (i = (iCandWordCount - 1); i >= 0; i--) {
                if (PYCandWords[i].iWhich == PY_CAND_AUTO) {
                    iStart = i + 1;
                    i++;
                    break;
                } else if (PYCandWords[i].iWhich == PY_CAND_USERPHRASE || PYCandWords[i].iWhich == PY_CAND_SYMPHRASE) {
                    if (strlen(PYCandWords[i].cand.phrase.phrase->strPhrase) >= strlen(phrase->strPhrase)) {
                        i++;
                        break;
                    }
                }
            }

            if (i < 0) {
                if (iCandWordCount == fc.iMaxCandWord)
                    return False;
                else
                    i = 0;
            } else if (iCandWordCount == fc.iMaxCandWord)
                i--;
        } else {
            for (i = 0; i < iCandWordCount; i++) {
                if (PYCandWords[i].iWhich == PY_CAND_USERPHRASE || PYCandWords[i].iWhich == PY_CAND_SYMPHRASE)
                    if (strlen(PYCandWords[i].cand.phrase.phrase->strPhrase) < strlen(phrase->strPhrase))
                        break;
            }
            if (i > fc.iMaxCandWord)
                return False;
        }
        break;
        //下面两部分可以放在一起××××××××××××××××××××××××××××××××××××××××××
    case AD_FAST:
        if (mode == SM_PREV) {
            for (i = (iCandWordCount - 1); i >= 0; i--) {
                if (PYCandWords[i].iWhich == PY_CAND_AUTO) {
                    iStart = ++i;
                    break;
                } else if (PYCandWords[i].iWhich == PY_CAND_USERPHRASE || PYCandWords[i].iWhich == PY_CAND_SYMPHRASE) {
                    if (strlen(phrase->strPhrase) < strlen(PYCandWords[i].cand.phrase.phrase->strPhrase)) {
                        i++;
                        break;
                    } else if (strlen(PYCandWords[i].cand.phrase.phrase->strPhrase) == strlen(phrase->strPhrase)) {
                        if (phrase->iIndex < PYCandWords[i].cand.phrase.phrase->iIndex) {
                            i++;
                            break;
                        }
                        if (phrase->iIndex == PYCandWords[i].cand.phrase.phrase->iIndex) {
                            if (phrase->iHit <= PYCandWords[i].cand.phrase.phrase->iHit) {
                                i++;
                                break;
                            }
                        }
                    }
                }
            }

            if (i < 0) {
                if (iCandWordCount == fc.iMaxCandWord)
                    return True;
                i = 0;
            } else if (iCandWordCount == fc.iMaxCandWord)
                i--;
        } else {
            for (i = 0; i < iCandWordCount; i++) {
                if (PYCandWords[i].iWhich == PY_CAND_USERPHRASE || PYCandWords[i].iWhich == PY_CAND_SYMPHRASE) {
                    if (strlen(PYCandWords[i].cand.phrase.phrase->strPhrase) < strlen(phrase->strPhrase))
                        break;
                    else if (strlen(PYCandWords[i].cand.phrase.phrase->strPhrase) == strlen(phrase->strPhrase)) {
                        if (phrase->iIndex > PYCandWords[i].cand.phrase.phrase->iIndex)
                            break;
                        if (phrase->iIndex == PYCandWords[i].cand.phrase.phrase->iIndex) {
                            if (phrase->iHit > PYCandWords[i].cand.phrase.phrase->iHit)
                                break;
                        }
                    }
                }
            }

            if (i == fc.iMaxCandWord)
                return True;
        }
        break;
    case AD_FREQ:
        if (mode == SM_PREV) {
            for (i = (iCandWordCount - 1); i >= 0; i--) {
                if (PYCandWords[i].iWhich == PY_CAND_AUTO) {
                    iStart = ++i;
                    break;
                } else if (PYCandWords[i].iWhich == PY_CAND_USERPHRASE || PYCandWords[i].iWhich == PY_CAND_SYMPHRASE) {
                    if (strlen(PYCandWords[i].cand.phrase.phrase->strPhrase) < strlen(phrase->strPhrase)) {
                        i++;
                        break;
                    } else if (strlen(PYCandWords[i].cand.phrase.phrase->strPhrase) == strlen(phrase->strPhrase)) {
                        if (phrase->iHit < PYCandWords[i].cand.phrase.phrase->iHit) {
                            i++;
                            break;
                        }
                        if (phrase->iHit == PYCandWords[i].cand.phrase.phrase->iHit) {
                            if (phrase->iIndex <= PYCandWords[i].cand.phrase.phrase->iIndex) {
                                i++;
                                break;
                            }
                        }
                    }
                }
            }

            if (i < 0) {
                if (iCandWordCount == fc.iMaxCandWord)
                    return True;
                i = 0;
            } else if (iCandWordCount == fc.iMaxCandWord)
                i--;
        } else {
            for (i = 0; i < iCandWordCount; i++) {
                if (PYCandWords[i].iWhich == PY_CAND_USERPHRASE || PYCandWords[i].iWhich == PY_CAND_SYMPHRASE) {
                    if (strlen(PYCandWords[i].cand.phrase.phrase->strPhrase) < strlen(phrase->strPhrase))
                        break;
                    else if (strlen(PYCandWords[i].cand.phrase.phrase->strPhrase) == strlen(phrase->strPhrase)) {
                        if (phrase->iHit > PYCandWords[i].cand.phrase.phrase->iHit)
                            break;
                        if (phrase->iHit == PYCandWords[i].cand.phrase.phrase->iHit) {
                            if (phrase->iIndex > PYCandWords[i].cand.phrase.phrase->iIndex)
                                break;
                        }
                    }
                }
            }
            if (i == fc.iMaxCandWord)
                return True;
        }
        break;
    }
    //×××××××××××××××××××××××××××××××××××××××××××××××××××××

    if (mode == SM_PREV) {
        if (iCandWordCount == fc.iMaxCandWord) {
            for (j = iStart; j < i; j++) {
                PYCandWords[j].iWhich = PYCandWords[j + 1].iWhich;
                switch (PYCandWords[j].iWhich) {
                case PY_CAND_BASE:
                    PYCandWords[j].cand.base.iPYFA = PYCandWords[j + 1].cand.base.iPYFA;
                    PYCandWords[j].cand.base.iBase = PYCandWords[j + 1].cand.base.iBase;
                    break;
                case PY_CAND_SYMPHRASE:
                case PY_CAND_USERPHRASE:
                    PYCandWords[j].cand.phrase.phrase = PYCandWords[j + 1].cand.phrase.phrase;
                    PYCandWords[j].cand.phrase.iPYFA = PYCandWords[j + 1].cand.phrase.iPYFA;
                    PYCandWords[j].cand.phrase.iBase = PYCandWords[j + 1].cand.phrase.iBase;
                    break;
                case PY_CAND_FREQ:
                    PYCandWords[j].cand.freq.hz = PYCandWords[j + 1].cand.freq.hz;
                    PYCandWords[j].cand.freq.strPY = PYCandWords[j + 1].cand.freq.strPY;
                    break;
                }
            }
        } else {
            //插在i的前面
            for (j = iCandWordCount; j > i; j--) {
                PYCandWords[j].iWhich = PYCandWords[j - 1].iWhich;
                switch (PYCandWords[j].iWhich) {
                case PY_CAND_BASE:
                    PYCandWords[j].cand.base.iPYFA = PYCandWords[j - 1].cand.base.iPYFA;
                    PYCandWords[j].cand.base.iBase = PYCandWords[j - 1].cand.base.iBase;
                    break;
                case PY_CAND_SYMPHRASE:
                case PY_CAND_USERPHRASE:
                    PYCandWords[j].cand.phrase.phrase = PYCandWords[j - 1].cand.phrase.phrase;
                    PYCandWords[j].cand.phrase.iPYFA = PYCandWords[j - 1].cand.phrase.iPYFA;
                    PYCandWords[j].cand.phrase.iBase = PYCandWords[j - 1].cand.phrase.iBase;
                    break;
                case PY_CAND_FREQ:
                    PYCandWords[j].cand.freq.hz = PYCandWords[j - 1].cand.freq.hz;
                    PYCandWords[j].cand.freq.strPY = PYCandWords[j - 1].cand.freq.strPY;
                    break;
                }
            }
        }
    } else {
        j = iCandWordCount;
        if (iCandWordCount == fc.iMaxCandWord)
            j--;
        for (; j > i; j--) {
            PYCandWords[j].iWhich = PYCandWords[j - 1].iWhich;
            switch (PYCandWords[j].iWhich) {
            case PY_CAND_BASE:
                PYCandWords[j].cand.base.iPYFA = PYCandWords[j - 1].cand.base.iPYFA;
                PYCandWords[j].cand.base.iBase = PYCandWords[j - 1].cand.base.iBase;
                break;
            case PY_CAND_SYMPHRASE:
            case PY_CAND_USERPHRASE:
                PYCandWords[j].cand.phrase.phrase = PYCandWords[j - 1].cand.phrase.phrase;
                PYCandWords[j].cand.phrase.iPYFA = PYCandWords[j - 1].cand.phrase.iPYFA;
                PYCandWords[j].cand.phrase.iBase = PYCandWords[j - 1].cand.phrase.iBase;
                break;
            case PY_CAND_FREQ:
                PYCandWords[j].cand.freq.hz = PYCandWords[j - 1].cand.freq.hz;
                PYCandWords[j].cand.freq.strPY = PYCandWords[j - 1].cand.freq.strPY;
                break;
            }
        }
    }

    PYCandWords[i].iWhich = (b) ? PY_CAND_SYMPHRASE : PY_CAND_USERPHRASE;
    PYCandWords[i].cand.phrase.phrase = phrase;
    PYCandWords[i].cand.phrase.iPYFA = pos.iPYFA;
    PYCandWords[i].cand.phrase.iBase = pos.iBase;
    if (iCandWordCount != fc.iMaxCandWord)
        iCandWordCount++;
    return True;
}

static void PYGetBaseCandWords(SEARCH_MODE mode)
{
    PYCandIndex candPos = {
        0, 0, 0
    };
    char str[3];

    str[0] = findMap.strMap[0][0];
    str[1] = findMap.strMap[0][1];
    str[2] = '\0';
    for (candPos.iPYFA = 0; candPos.iPYFA < iPYFACount; candPos.iPYFA++) {
        if (!Cmp2Map(PYFAList[candPos.iPYFA].strMap, str, False)) {
            for (candPos.iBase = 0; candPos.iBase < PYFAList[candPos.iPYFA].iBase; candPos.iBase++) {
                    if ((mode != SM_PREV && !PYFAList[candPos.iPYFA].pyBase[candPos.iBase].flag)
                        || (mode == SM_PREV && PYFAList[candPos.iPYFA].pyBase[candPos.iBase].flag)) {
                        if (!PYIsInFreq(PYFAList[candPos.iPYFA].pyBase[candPos.iBase].strHZ)) {
                            if (!PYAddBaseCandWord(candPos, mode))
                                goto _end;
                        }
                    }
            }
        }
    }

  _end:
    PYSetCandWordsFlag(True);
}

/*
 * 将一个字加入到候选列表的合适位置中
 */
static Bool PYAddBaseCandWord(PYCandIndex pos, SEARCH_MODE mode)
{
    int i = 0, j;
    int iStart = 0;

    switch (fc.baseOrder) {
    case AD_NO:
        if (mode == SM_PREV) {
            if (iCandWordCount == fc.iMaxCandWord)
                i = iCandWordCount - 1;
            else
                i = iCandWordCount;
        } else {
            if (iCandWordCount == fc.iMaxCandWord)
                return False;
            i = iCandWordCount;
        }
        break;
    case AD_FAST:
        if (mode == SM_PREV) {
            for (i = (iCandWordCount - 1); i >= 0; i--) {
                if (PYCandWords[i].iWhich == PY_CAND_AUTO || PYCandWords[i].iWhich == PY_CAND_FREQ) {
                    iStart = i + 1;
                    i++;
                    break;
                } else if (PYCandWords[i].iWhich == PY_CAND_BASE) {
                    if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase
                        [PYCandWords[i].cand.base.iBase].iIndex > PYFAList[pos.iPYFA].pyBase[pos.iBase].iIndex) {
                        i++;
                        break;
                    } else
                        if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase
                            [PYCandWords[i].cand.base.iBase].iIndex == PYFAList[pos.iPYFA].pyBase[pos.iBase].iIndex) {
                        if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase
                            [PYCandWords[i].cand.base.iBase].iHit >= PYFAList[pos.iPYFA].pyBase[pos.iBase].iHit) {
                            i++;
                            break;
                        }
                    }
                }
            }

            if (i < 0) {
                if (iCandWordCount == fc.iMaxCandWord)
                    return True;
                i = 0;
            } else if (iCandWordCount == fc.iMaxCandWord)
                i--;
        } else {
            for (i = 0; i < iCandWordCount; i++) {
                if (PYCandWords[i].iWhich == PY_CAND_BASE) {
                    if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase
                        [PYCandWords[i].cand.base.iBase].iIndex < PYFAList[pos.iPYFA].pyBase[pos.iBase].iIndex)
                        break;
                    else if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase[PYCandWords[i].cand.base.iBase].iIndex ==
                             PYFAList[pos.iPYFA].pyBase[pos.iBase].iIndex) {
                        if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase[PYCandWords[i].cand.base.iBase].iHit <
                            PYFAList[pos.iPYFA].pyBase[pos.iBase].iHit)
                            break;
                    }
                }
            }

            if (i == fc.iMaxCandWord)
                return True;
        }

        break;
    case AD_FREQ:
        if (mode == SM_PREV) {
            for (i = (iCandWordCount - 1); i >= 0; i--) {
                if (PYCandWords[i].iWhich == PY_CAND_AUTO || PYCandWords[i].iWhich == PY_CAND_FREQ) {
                    iStart = i + 1;
                    i++;
                    break;
                } else if (PYCandWords[i].iWhich == PY_CAND_BASE) {
                    if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase
                        [PYCandWords[i].cand.base.iBase].iHit > PYFAList[pos.iPYFA].pyBase[pos.iBase].iHit) {
                        i++;
                        break;
                    } else
                        if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase
                            [PYCandWords[i].cand.base.iBase].iHit == PYFAList[pos.iPYFA].pyBase[pos.iBase].iHit) {
                        if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase
                            [PYCandWords[i].cand.base.iBase].iIndex >= PYFAList[pos.iPYFA].pyBase[pos.iBase].iIndex) {
                            i++;
                            break;
                        }
                    }
                }
            }

            if (i < 0) {
                if (iCandWordCount == fc.iMaxCandWord)
                    return True;
                i = 0;
            } else if (iCandWordCount == fc.iMaxCandWord)
                i--;
        } else {
            for (i = 0; i < iCandWordCount; i++) {
                if (PYCandWords[i].iWhich == PY_CAND_BASE) {
                    if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase
                        [PYCandWords[i].cand.base.iBase].iHit < PYFAList[pos.iPYFA].pyBase[pos.iBase].iHit)
                        break;
                    else if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase[PYCandWords[i].cand.base.iBase].iHit ==
                             PYFAList[pos.iPYFA].pyBase[pos.iBase].iHit) {
                        if (PYFAList[PYCandWords[i].cand.base.iPYFA].pyBase[PYCandWords[i].cand.base.iBase].iIndex <
                            PYFAList[pos.iPYFA].pyBase[pos.iBase].iIndex)
                            break;
                    }
                }
            }
            if (i == fc.iMaxCandWord)
                return True;
        }
        break;
    }

    if (mode == SM_PREV) {
        if (iCandWordCount == fc.iMaxCandWord) {
            for (j = iStart; j < i; j++) {
                PYCandWords[j].iWhich = PYCandWords[j + 1].iWhich;
                switch (PYCandWords[j].iWhich) {
                case PY_CAND_BASE:
                    PYCandWords[j].cand.base.iPYFA = PYCandWords[j + 1].cand.base.iPYFA;
                    PYCandWords[j].cand.base.iBase = PYCandWords[j + 1].cand.base.iBase;
                    break;
                case PY_CAND_SYMPHRASE:
                case PY_CAND_USERPHRASE:
                    PYCandWords[j].cand.phrase.phrase = PYCandWords[j + 1].cand.phrase.phrase;
                    PYCandWords[j].cand.phrase.iPYFA = PYCandWords[j + 1].cand.phrase.iPYFA;
                    PYCandWords[j].cand.phrase.iBase = PYCandWords[j + 1].cand.phrase.iBase;
                    break;
                case PY_CAND_FREQ:
                    PYCandWords[j].cand.freq.hz = PYCandWords[j + 1].cand.freq.hz;
                    PYCandWords[j].cand.freq.strPY = PYCandWords[j + 1].cand.freq.strPY;
                    break;
                }
            }
        } else {
            for (j = iCandWordCount; j > i; j--) {
                PYCandWords[j].iWhich = PYCandWords[j - 1].iWhich;
                switch (PYCandWords[j].iWhich) {
                case PY_CAND_BASE:
                    PYCandWords[j].cand.base.iPYFA = PYCandWords[j - 1].cand.base.iPYFA;
                    PYCandWords[j].cand.base.iBase = PYCandWords[j - 1].cand.base.iBase;
                    break;
                case PY_CAND_SYMPHRASE:
                case PY_CAND_USERPHRASE:
                    PYCandWords[j].cand.phrase.phrase = PYCandWords[j - 1].cand.phrase.phrase;
                    PYCandWords[j].cand.phrase.iPYFA = PYCandWords[j - 1].cand.phrase.iPYFA;
                    PYCandWords[j].cand.phrase.iBase = PYCandWords[j - 1].cand.phrase.iBase;
                    break;
                case PY_CAND_FREQ:
                    PYCandWords[j].cand.freq.hz = PYCandWords[j - 1].cand.freq.hz;
                    PYCandWords[j].cand.freq.strPY = PYCandWords[j - 1].cand.freq.strPY;
                    break;
                }
            }
        }
    } else {
        j = iCandWordCount;
        if (iCandWordCount == fc.iMaxCandWord)
            j--;
        for (; j > i; j--) {
            PYCandWords[j].iWhich = PYCandWords[j - 1].iWhich;
            switch (PYCandWords[j].iWhich) {
            case PY_CAND_BASE:
                PYCandWords[j].cand.base.iPYFA = PYCandWords[j - 1].cand.base.iPYFA;
                PYCandWords[j].cand.base.iBase = PYCandWords[j - 1].cand.base.iBase;
                break;
            case PY_CAND_SYMPHRASE:
            case PY_CAND_USERPHRASE:
                PYCandWords[j].cand.phrase.phrase = PYCandWords[j - 1].cand.phrase.phrase;
                PYCandWords[j].cand.phrase.iPYFA = PYCandWords[j - 1].cand.phrase.iPYFA;
                PYCandWords[j].cand.phrase.iBase = PYCandWords[j - 1].cand.phrase.iBase;
                break;
            case PY_CAND_FREQ:
                PYCandWords[j].cand.freq.hz = PYCandWords[j - 1].cand.freq.hz;
                PYCandWords[j].cand.freq.strPY = PYCandWords[j - 1].cand.freq.strPY;
                break;
            }
        }
    }

    PYCandWords[i].iWhich = PY_CAND_BASE;
    PYCandWords[i].cand.base.iPYFA = pos.iPYFA;
    PYCandWords[i].cand.base.iBase = pos.iBase;
    if (iCandWordCount != fc.iMaxCandWord)
        iCandWordCount++;
    return True;
}

static void PYGetFreqCandWords(SEARCH_MODE mode)
{
    int i;
    HZ *hz;

    if (pCurFreq && !pCurFreq->bIsSym) {
        hz = pCurFreq->HZList->next;
        for (i = 0; i < pCurFreq->iCount; i++) {
            if ((mode != SM_PREV && !hz->flag)
                || (mode == SM_PREV && hz->flag)) {
                if (!PYAddFreqCandWord(hz, pCurFreq->strPY, mode))
                    break;
            }
            hz = hz->next;
        }
    }

    PYSetCandWordsFlag(True);
}

/*
 * 将一个常用字加入到候选列表的合适位置中
 */
static Bool PYAddFreqCandWord(HZ * hz, char *strPY, SEARCH_MODE mode)
{
    int i = 0, j;
    int iStart = 0;

    switch (fc.freqOrder) {
    case AD_NO:
        if (mode == SM_PREV) {
            if (iCandWordCount == fc.iMaxCandWord)
                i = iCandWordCount - 1;
        } else {
            if (iCandWordCount == fc.iMaxCandWord)
                return False;
            i = iCandWordCount;
        }
        break;
    case AD_FAST:
        if (mode == SM_PREV) {
            for (i = (iCandWordCount - 1); i >= 0; i--) {
                if (PYCandWords[i].iWhich == PY_CAND_AUTO) {
                    iStart = i + 1;
                    i++;
                    break;
                } else if (PYCandWords[i].iWhich == PY_CAND_FREQ && (hz->iIndex <= PYCandWords[i].cand.freq.hz->iIndex)) {
                    i++;
                    break;
                }
            }

            if (i < 0) {
                if (iCandWordCount == fc.iMaxCandWord)
                    return True;
                i = 0;
            } else if (iCandWordCount == fc.iMaxCandWord)
                i--;
        } else {
            for (i = 0; i < iCandWordCount; i++) {
                if (PYCandWords[i].iWhich == PY_CAND_FREQ && (hz->iIndex > PYCandWords[i].cand.freq.hz->iIndex))
                    break;
            }
            if (i == fc.iMaxCandWord)
                return True;
        }
        break;
    case AD_FREQ:
        if (mode == SM_PREV) {
            for (i = (iCandWordCount - 1); i >= 0; i--) {
                if (PYCandWords[i].iWhich == PY_CAND_AUTO) {
                    iStart = i + 1;
                    i++;
                    break;
                } else if (PYCandWords[i].iWhich == PY_CAND_FREQ && (hz->iHit <= PYCandWords[i].cand.freq.hz->iHit)) {
                    i++;
                    break;
                }
            }

            if (i < 0) {
                if (iCandWordCount == fc.iMaxCandWord)
                    return True;
                i = 0;
            } else if (iCandWordCount == fc.iMaxCandWord)
                i--;
        } else {
            for (i = 0; i < iCandWordCount; i++) {
                if (PYCandWords[i].iWhich == PY_CAND_FREQ && (hz->iHit > PYCandWords[i].cand.freq.hz->iHit))
                    break;
            }
            if (i == fc.iMaxCandWord)
                return True;
        }
        break;
    }

    if (mode == SM_PREV) {
        if (iCandWordCount == fc.iMaxCandWord) {
            for (j = iStart; j < i; j++) {
                PYCandWords[j].iWhich = PYCandWords[j + 1].iWhich;
                switch (PYCandWords[j].iWhich) {
                case PY_CAND_BASE:
                    PYCandWords[j].cand.base.iPYFA = PYCandWords[j + 1].cand.base.iPYFA;
                    PYCandWords[j].cand.base.iBase = PYCandWords[j + 1].cand.base.iBase;
                    break;
                case PY_CAND_SYMPHRASE:
                case PY_CAND_USERPHRASE:
                    PYCandWords[j].cand.phrase.phrase = PYCandWords[j + 1].cand.phrase.phrase;
                    PYCandWords[j].cand.phrase.iPYFA = PYCandWords[j + 1].cand.phrase.iPYFA;
                    PYCandWords[j].cand.phrase.iBase = PYCandWords[j + 1].cand.phrase.iBase;
                    break;
                case PY_CAND_FREQ:
                    PYCandWords[j].cand.freq.hz = PYCandWords[j + 1].cand.freq.hz;
                    PYCandWords[j].cand.freq.strPY = PYCandWords[j + 1].cand.freq.strPY;
                    break;
                }
            }
        } else {
            for (j = iCandWordCount; j > i; j--) {
                PYCandWords[j].iWhich = PYCandWords[j - 1].iWhich;
                switch (PYCandWords[j].iWhich) {
                case PY_CAND_BASE:
                    PYCandWords[j].cand.base.iPYFA = PYCandWords[j - 1].cand.base.iPYFA;
                    PYCandWords[j].cand.base.iBase = PYCandWords[j - 1].cand.base.iBase;
                    break;
                case PY_CAND_SYMPHRASE:
                case PY_CAND_USERPHRASE:
                    PYCandWords[j].cand.phrase.phrase = PYCandWords[j - 1].cand.phrase.phrase;
                    PYCandWords[j].cand.phrase.iPYFA = PYCandWords[j - 1].cand.phrase.iPYFA;
                    PYCandWords[j].cand.phrase.iBase = PYCandWords[j - 1].cand.phrase.iBase;
                    break;
                case PY_CAND_FREQ:
                    PYCandWords[j].cand.freq.hz = PYCandWords[j - 1].cand.freq.hz;
                    PYCandWords[j].cand.freq.strPY = PYCandWords[j - 1].cand.freq.strPY;
                    break;
                }
            }
        }
    } else {
        j = iCandWordCount;
        if (iCandWordCount == fc.iMaxCandWord)
            j--;
        for (; j > i; j--) {
            PYCandWords[j].iWhich = PYCandWords[j - 1].iWhich;
            switch (PYCandWords[j].iWhich) {
            case PY_CAND_BASE:
                PYCandWords[j].cand.base.iPYFA = PYCandWords[j - 1].cand.base.iPYFA;
                PYCandWords[j].cand.base.iBase = PYCandWords[j - 1].cand.base.iBase;
                break;
            case PY_CAND_SYMPHRASE:
            case PY_CAND_USERPHRASE:
                PYCandWords[j].cand.phrase.phrase = PYCandWords[j - 1].cand.phrase.phrase;
                PYCandWords[j].cand.phrase.iPYFA = PYCandWords[j - 1].cand.phrase.iPYFA;
                PYCandWords[j].cand.phrase.iBase = PYCandWords[j - 1].cand.phrase.iBase;
                break;
            case PY_CAND_FREQ:
                PYCandWords[j].cand.freq.hz = PYCandWords[j - 1].cand.freq.hz;
                PYCandWords[j].cand.freq.strPY = PYCandWords[j - 1].cand.freq.strPY;
                break;
            }
        }
    }

    PYCandWords[i].iWhich = PY_CAND_FREQ;
    PYCandWords[i].cand.freq.hz = hz;
    PYCandWords[i].cand.freq.strPY = strPY;
    if (iCandWordCount != fc.iMaxCandWord)
        iCandWordCount++;
    return True;
}

/*
 * 将一个词组保存到用户词组库中
 * 返回True表示是新词组
 */
static Bool PYAddUserPhrase(char *phrase, char *map)
{
    PyPhrase *userPhrase, *newPhrase, *temp;
    char str[UTF8_MAX_LENGTH + 1];
    int i, j, k, iTemp;
    int clen;

    //如果短于两个汉字，则不能组成词组
    if (utf8_strlen(phrase) < 2)
        return False;
    str[0] = map[0];
    str[1] = map[1];
    str[2] = '\0';
    i = GetBaseMapIndex(str);

    clen = utf8_char_len(phrase);
    strncpy(str, phrase, clen);
    str[clen] = '\0';
    j = GetBaseIndex(i, str);;
    //判断该词组是否已经在库中
    //首先，看它是不是在用户词组库中
    userPhrase = PYFAList[i].pyBase[j].userPhrase->next;
    for (k = 0; k < PYFAList[i].pyBase[j].iUserPhrase; k++) {
        if (!strcmp(map + 2, userPhrase->strMap)
            && !strcmp(phrase + clen, userPhrase->strPhrase))
            return False;
        userPhrase = userPhrase->next;
    }

    //然后，看它是不是在系统词组库中
    for (k = 0; k < PYFAList[i].pyBase[j].iPhrase; k++)
        if (!strcmp(map + 2, PYFAList[i].pyBase[j].phrase[k].strMap)
            && !strcmp(phrase + clen, PYFAList[i].pyBase[j].phrase[k].strPhrase))
            return False;
    //下面将词组添加到列表中
    newPhrase = (PyPhrase *) malloc(sizeof(PyPhrase));
    newPhrase->strMap = (char *) malloc(sizeof(char) * strlen(map + 2) + 1);
    newPhrase->strPhrase = (char *) malloc(sizeof(char) * strlen(phrase + clen) + 1);
    strcpy(newPhrase->strMap, map + 2);
    strcpy(newPhrase->strPhrase, phrase + clen);
    newPhrase->iIndex = ++iCounter;
    newPhrase->iHit = 1;
    newPhrase->flag = 0;
    temp = PYFAList[i].pyBase[j].userPhrase;
    userPhrase = PYFAList[i].pyBase[j].userPhrase->next;
    for (k = 0; k < PYFAList[i].pyBase[j].iUserPhrase; k++) {
        if (CmpMap(map + 2, userPhrase->strMap, &iTemp, False) > 0)
            break;
        temp = userPhrase;
        userPhrase = userPhrase->next;
    }

    newPhrase->next = temp->next;
    temp->next = newPhrase;
    PYFAList[i].pyBase[j].iUserPhrase++;
    iNewPYPhraseCount++;
    if (iNewPYPhraseCount == AUTOSAVE_PHRASE_COUNT) {
        iNewPYPhraseCount = 0;
    }

    return True;
}

static void PYDelUserPhrase(int iPYFA, int iBase, PyPhrase * phrase)
{
    PyPhrase *temp;

    //首先定位该词组
    temp = PYFAList[iPYFA].pyBase[iBase].userPhrase;
    while (temp) {
        if (temp->next == phrase)
            break;
        temp = temp->next;
    }
    if (!temp)
        return;
    temp->next = phrase->next;
    free(phrase->strPhrase);
    free(phrase->strMap);
    free(phrase);
    PYFAList[iPYFA].pyBase[iBase].iUserPhrase--;
    iNewPYPhraseCount++;
    if (iNewPYPhraseCount == AUTOSAVE_PHRASE_COUNT) {
        iNewPYPhraseCount = 0;
    }
}

static int GetBaseMapIndex(char *strMap)
{
    int i;

    for (i = 0; i < iPYFACount; i++) {
        if (!strcmp(strMap, PYFAList[i].strMap))
            return i;
    }
    return -1;
}

/*
 * 保存索引文件
 */
static void SavePYIndex(void)
{
    int i, j, k, l;
    FILE *fp;

    if (isSavingPYIndex)
        return;

    if(access(CONFIG_PATH, F_OK))
        mkdir(CONFIG_PATH, S_IRWXU);
    isSavingPYIndex = True;
    fp = fopen(TEMP_FILE, "wb");
    if (!fp) {
        isSavingPYIndex = False;
        fprintf(stderr, "Cannot Save Pinyin Index");
        return;
    }

    //保存计数器
    fwrite(&iCounter, sizeof(uint), 1, fp);
    //先保存索引不为0的单字
    k = -1;
    for (i = 0; i < iPYFACount; i++) {
        for (j = 0; j < PYFAList[i].iBase; j++) {
            if (PYFAList[i].pyBase[j].iIndex > iOrigCounter) {
                fwrite(&i, sizeof(int), 1, fp);
                fwrite(&j, sizeof(int), 1, fp);
                fwrite(&k, sizeof(int), 1, fp);
                l = PYFAList[i].pyBase[j].iIndex;
                fwrite(&l, sizeof(uint), 1, fp);
                l = PYFAList[i].pyBase[j].iHit;
                fwrite(&l, sizeof(uint), 1, fp);
            }
        }
    }

    //再保存索引不为0的系统词组
    for (i = 0; i < iPYFACount; i++) {
        for (j = 0; j < PYFAList[i].iBase; j++) {
            for (k = 0; k < PYFAList[i].pyBase[j].iPhrase; k++) {
                if (PYFAList[i].pyBase[j].phrase[k].iIndex > iOrigCounter) {
                    fwrite(&i, sizeof(int), 1, fp);
                    fwrite(&j, sizeof(int), 1, fp);
                    fwrite(&k, sizeof(int), 1, fp);
                    l = PYFAList[i].pyBase[j].phrase[k].iIndex;
                    fwrite(&l, sizeof(uint), 1, fp);
                    l = PYFAList[i].pyBase[j].phrase[k].iHit;
                    fwrite(&l, sizeof(uint), 1, fp);
                }
            }
        }
    }

    fclose(fp);

    rename(TEMP_FILE, PY_INDEX_FILE);

    isSavingPYIndex = False;
}

/*
 * 设置拼音的常用字表
 * 只有以下情形才能设置
 *	当用户输入单字时
 * 至于常用词的问题暂时不考虑
 */
static void PYAddFreq(int iIndex)
{
    int i;
    HZ *HZTemp;
    PyFreq *freq;
    HZ *hz;

    //能到这儿来，就说明候选列表中都是单字
    //首先，看这个字是不是已经在常用字表中
    i = 1;
    if (pCurFreq) {
        i = -1;
        if (PYCandWords[iIndex].iWhich != PY_CAND_FREQ) {
            //说明该字是系统单字
            HZTemp = pCurFreq->HZList->next;
            for (i = 0; i < pCurFreq->iCount; i++) {
                if (!strcmp(PYFAList[PYCandWords[iIndex].cand.base.iPYFA].pyBase[PYCandWords[iIndex].cand.base.iBase].strHZ, HZTemp->strHZ)) {
                    i = -1;
                    break;
                }
                HZTemp = HZTemp->next;
            }
        }
    }
    //借用i来指示是否需要添加新的常用字
    if (i < 0)
        return;
    PYSetCandWordsFlag(False);
    //需要添加该字，此时该字必然是系统单字
    if (!pCurFreq) {
        freq = (PyFreq *) malloc(sizeof(PyFreq));
        freq->HZList = (HZ *) malloc(sizeof(HZ));
        freq->HZList->next = NULL;
        strcpy(freq->strPY, strFindString);
        freq->next = NULL;
        freq->iCount = 0;
        freq->bIsSym = False;
        pCurFreq = pyFreq;
        for (i = 0; i < iPYFreqCount; i++)
            pCurFreq = pCurFreq->next;
        pCurFreq->next = freq;
        iPYFreqCount++;
        pCurFreq = freq;
    }

    HZTemp = (HZ *) malloc(sizeof(HZ));
    strcpy(HZTemp->strHZ, PYFAList[PYCandWords[iIndex].cand.base.iPYFA].pyBase[PYCandWords[iIndex].cand.base.iBase].strHZ);
    HZTemp->iPYFA = PYCandWords[iIndex].cand.base.iPYFA;
    HZTemp->iHit = 0;
    HZTemp->iIndex = 0;
    HZTemp->flag = 0;
    HZTemp->next = NULL;
    //将HZTemp加到链表尾部
    hz = pCurFreq->HZList;
    for (i = 0; i < pCurFreq->iCount; i++)
        hz = hz->next;
    hz->next = HZTemp;
    pCurFreq->iCount++;
    iNewFreqCount++;
    if (iNewFreqCount == AUTOSAVE_FREQ_COUNT) {
        iNewFreqCount = 0;
    }
}

/*
 * 删除拼音常用字表中的某个字
 */
static void PYDelFreq(int iIndex)
{
    HZ *hz;

    //能到这儿来，就说明候选列表中都是单字
    //首先，看这个字是不是已经在常用字表中
    if (PYCandWords[iIndex].iWhich != PY_CAND_FREQ)
        return;
    PYSetCandWordsFlag(False);
    //先找到需要删除单字的位置
    hz = pCurFreq->HZList;
    while (hz->next != PYCandWords[iIndex].cand.freq.hz)
        hz = hz->next;
    hz->next = PYCandWords[iIndex].cand.freq.hz->next;
    free(PYCandWords[iIndex].cand.freq.hz);
    pCurFreq->iCount--;
    iNewFreqCount++;
    if (iNewFreqCount == AUTOSAVE_FREQ_COUNT) {
        iNewFreqCount = 0;
    }
}

/*
 * 判断一个字是否已经是常用字
 */
static Bool PYIsInFreq(char *strHZ)
{
    HZ *hz;
    int i;

    if (!pCurFreq || pCurFreq->bIsSym)
        return False;
    hz = pCurFreq->HZList->next;
    for (i = 0; i < pCurFreq->iCount; i++) {
        if (!strcmp(strHZ, hz->strHZ))
            return True;
        hz = hz->next;
    }

    return False;
}
