/*
 * This file is part of hildon-input-method-plugins-example 
 *
 * Copyright (C) 2009 Nokia Corporation. All rights reserved.
 *
 * Author: Felipe Erias Morandeira <femorandeira@maemo.org>
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * Neither the name of Nokia Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 输入法界面由示例代码修改而来，所以保留以上信息  --Eveing
 */

#include "py.c"

#include <X11/Xatom.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <hildon-im-plugin.h>
#include <hildon-im-ui.h>
#include <hildon/hildon.h>

#define G_DEBUG_DISABLE 1
#define BUTTON_HEIGHT 60
#define HILDON_IM_FCITX_FKB_TYPE hildon_im_fcitx_fkb_get_type()
#define HILDON_IM_FCITX_FKB(obj) GTK_CHECK_CAST(obj, hildon_im_fcitx_fkb_get_type(), HildonIMFcitxFKB)
#define HILDON_IM_FCITX_FKB_CLASS(klass) \
        GTK_CHECK_CLASS_CAST(klass, hildon_im_fcitx_fkb_get_type, \
                             HildonIMFcitxFKBClass)
#define HILDON_IS_IM_FCITX_FKB(obj) \
        GTK_CHECK_TYPE(obj, hildon_im_fcitx_fkb_get_type())
#define HILDON_IM_FCITX_FKB_GET_PRIVATE(obj) \
        (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HILDON_IM_FCITX_FKB_TYPE,\
                                      HildonIMFcitxFKBPrivate))
/* ***** LAYOUTS ***** */

static const gchar* alpha_lower_0[] = {"q", "w", "e", "r", "t", "y", "u", "i", "o", "p", NULL};
static const gchar* alpha_lower_1[] = {"a", "s", "d", "f", "g", "h", "j", "k", "l", NULL};
static const gchar* alpha_lower_2[] = {"z", "x", "c", "v", "b", "n", "m", NULL};
static const gchar* alpha_lower_3[] = {",", ".", NULL};
static const gchar** alpha_lower[] = {alpha_lower_0,
                                      alpha_lower_1,
                                      alpha_lower_2,
                                      alpha_lower_3, NULL};

static const gchar* alpha_upper_0[] = {"Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", NULL};
static const gchar* alpha_upper_1[] = {"A", "S", "D", "F", "G", "H", "J", "K", "L", NULL};
static const gchar* alpha_upper_2[] = {"Z", "X", "C", "V", "B", "N", "M", NULL};
static const gchar* alpha_upper_3[] = {"?", "!", NULL};
static const gchar** alpha_upper[] = {alpha_upper_0,
                                      alpha_upper_1,
                                      alpha_upper_2,
                                      alpha_upper_3, NULL};

static const gchar* special_lower_0[] = {"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", NULL};
static const gchar* special_lower_1[] = {"@", "|", "#", "\"", "\'", "&", "*", "+", "=", NULL};
static const gchar* special_lower_2[] = {"/", "-", "_", "%", "\\", ":", ";", NULL};
static const gchar* special_lower_3[] = {",", ".", NULL};
static const gchar** special_lower[] = {special_lower_0,
                                        special_lower_1,
                                        special_lower_2,
                                        special_lower_3, NULL};
static const gchar* special_upper_0[] = {"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", NULL};
static const gchar* special_upper_1[] = {"`", "<", ">", "{", "}", "[", "]", "(", ")", NULL};
static const gchar* special_upper_2[] = {"%", "^", "½", "°", "¥", "~", "$", NULL};
static const gchar* special_upper_3[] = {"©", "®", NULL};
static const gchar** special_upper[] = {special_upper_0,
                                        special_upper_1,
                                        special_upper_2,
                                        special_upper_3, NULL};
static const gchar* special_cn_0[] = {"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", NULL};
static const gchar* special_cn_1[] = {"《", "》", "（", "）", "【", "】", "‘", "’", "、", NULL};
static const gchar* special_cn_2[] = {"“", "”", "：", "；", "——", "！", "？", NULL};
static const gchar* special_cn_3[] = {"～", "……", NULL};
static const gchar** special_cn[] = {special_cn_0,
                                     special_cn_1,
                                     special_cn_2,
                                     special_cn_3, NULL};
/*static osso_context_t *osso_context;*/
static gboolean chinese_mode;

typedef struct
{
  GtkContainerClass parent;
}
HildonIMFcitxFKBClass;

typedef struct
{
  GtkContainer parent;

}
HildonIMFcitxFKB;

typedef struct
{
  HildonIMUI *ui;
  GtkWidget *window;
  GtkWidget *text_view;

  gint saved_offset;
  gint timeout_handler;
  gint deleted;

  HildonGtkInputMode input_mode;

  GtkWidget *vbox;

  GtkWidget *shift_button;
  GtkWidget *symbols_button;
  GtkWidget *space_button;
  GtkWidget *return_button;
  GtkWidget *delete_button;
  GtkWidget *mode_button;
  GtkWidget* buttons[4][10];
}
HildonIMFcitxFKBPrivate;

static GType hildon_im_fcitx_fkb_type = 0;
static GtkWidgetClass *parent_class = NULL;

GType hildon_im_fcitx_fkb_get_type (void);
GtkWidget *hildon_im_fcitx_fkb_new (HildonIMUI *kbd);

/*
 * HildonIMPlugin interface
 */

static void hildon_im_fcitx_fkb_iface_init (HildonIMPluginIface *iface);

static void hildon_im_fcitx_fkb_enable (HildonIMPlugin *plugin, gboolean init);
static void hildon_im_fcitx_fkb_disable                   (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_surrounding_received      (HildonIMPlugin *plugin,
                                                             const gchar *surrounding,
                                                             gint offset);
/*
static void hildon_im_fcitx_fkb_settings_changed          (HildonIMPlugin *plugin,
                                                             const gchar *key,
                                                             const GConfValue *value);
static void hildon_im_fcitx_fkb_language_settings_changed (HildonIMPlugin *plugin,
                                                             gint index);
static void hildon_im_fcitx_fkb_input_mode_changed        (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_keyboard_state_changed    (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_client_widget_changed     (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_character_autocase        (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_clear                     (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_save_data                 (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_mode_a                    (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_mode_b                    (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_language                  (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_backspace                 (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_enter                     (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_tab                       (HildonIMPlugin *plugin);
static void hildon_im_fcitx_fkb_fullscreen                (HildonIMPlugin *plugin,
                                                             gboolean fullscreen);
static void hildon_im_fcitx_fkb_select_region             (HildonIMPlugin *plugin,
                                                             gint start,
                                                             gint end);
static void hildon_im_fcitx_fkb_transition                (HildonIMPlugin *plugin,
                                                             gboolean from);
static void hildon_im_fcitx_fkb_button_activated          (HildonIMPlugin *plugin,
                                                             HildonIMButton button,
                                                             gboolean long_press);
static void hildon_im_fcitx_fkb_preedit_committed         (HildonIMPlugin *plugin,
                                                             const gchar *committed_preedit);
static void hildon_im_fcitx_fkb_key_event                 (HildonIMPlugin *plugin,
                                                             GdkEventType type,
                                                             guint state,
                                                             guint keyval,
                                                             guint hardware_keycode);
*/

/*
 * GObject functions
 */
static void hildon_im_fcitx_fkb_finalize     (GObject *obj);
static void hildon_im_fcitx_fkb_get_property (GObject *object,
                                                guint prop_id,
                                                GValue *value,
                                                GParamSpec *pspec);
static void hildon_im_fcitx_fkb_set_property (GObject *object,
                                                guint prop_id,
                                                const GValue *value,
                                                GParamSpec *pspec);

static void hildon_im_fcitx_fkb_class_init (HildonIMFcitxFKBClass *klass);
static void hildon_im_fcitx_fkb_init       (HildonIMFcitxFKB *self);

/*
 * Internal functions
 */
static void populate_window (HildonIMFcitxFKB *self);
static void button_update ( HildonIMFcitxFKBPrivate *priv, const gchar** keyboard_layout[]);
static void close_fkb (GtkWidget *button, gpointer user_data);
/*
 * Module functions
 */

HildonIMPlugin*
module_create (HildonIMUI *keyboard)
{
  return HILDON_IM_PLUGIN (hildon_im_fcitx_fkb_new (keyboard));
}

void
module_exit(void)
{
  /* empty */
}

void
module_init(GTypeModule *module)
{
  static const GTypeInfo type_info = {
    sizeof(HildonIMFcitxFKBClass),
    NULL, /* base_init */
    NULL, /* base_finalize */
    (GClassInitFunc) hildon_im_fcitx_fkb_class_init,
    NULL, /* class_finalize */
    NULL, /* class_data */
    sizeof(HildonIMFcitxFKB),
    0, /* n_preallocs */
    (GInstanceInitFunc) hildon_im_fcitx_fkb_init,
  };

  static const GInterfaceInfo plugin_info = {
    (GInterfaceInitFunc) hildon_im_fcitx_fkb_iface_init,
    NULL, /* interface_finalize */
    NULL, /* interface_data */
  };

  hildon_im_fcitx_fkb_type =
          g_type_module_register_type(module,
                                      GTK_TYPE_CONTAINER, "HildonIMFcitxFKB",
                                      &type_info,
                                      0);

  g_type_module_add_interface(module,
                              HILDON_IM_FCITX_FKB_TYPE,
                              HILDON_IM_TYPE_PLUGIN,
                              &plugin_info);
  chinese_mode = TRUE;
/*  osso_context = osso_initialize("org.maemo.fcitm", VERSION, TRUE, NULL);
  osso_hw_set_event_cb(osso_context, NULL, power_off_save_data, NULL);*/
}

/*
 * This is used to know the plugin's information when loading the module
 */
const HildonIMPluginInfo *
hildon_im_plugin_get_info(void)
{
  static const HildonIMPluginInfo info =
  {
    "Hildon IM Fcitx FKB",              /* description */
    "hildon_im_fcitx_fkb",              /* name */
    NULL,                               /* menu title */
    NULL,                               /* gettext domain */
    TRUE,                               /* visible in menu */
    FALSE,                               /* cached TODO make it TRUE */
    HILDON_IM_TYPE_FULLSCREEN,          /* UI type */
    HILDON_IM_GROUP_CJK,                /* group */
    HILDON_IM_DEFAULT_PLUGIN_PRIORITY,  /* priority */
    NULL,                               /* special character plugin */
    NULL,                               /* help page */
    TRUE,                               /* disable common UI buttons */
    0,                                  /* plugin height */
    HILDON_IM_TRIGGER_FINGER            /* trigger */
  };

  return &info;
}

/*
 * This function returns the list of available languages supported
 * by the plugin.
 */
gchar **
hildon_im_plugin_get_available_languages (gboolean *free)
{
  static gchar *list[] = { "zh_CN", NULL };
  *free = FALSE;

  return list;
}

GType
hildon_im_fcitx_fkb_get_type (void)
{
  return hildon_im_fcitx_fkb_type;
}

/*
 * Implement the interface.
 */
static void
hildon_im_fcitx_fkb_iface_init (HildonIMPluginIface *iface)
{
  iface->enable = hildon_im_fcitx_fkb_enable;
  iface->disable = hildon_im_fcitx_fkb_disable;
  iface->surrounding_received = hildon_im_fcitx_fkb_surrounding_received;
  /*
  iface->key_event = hildon_im_fcitx_fkb_key_event;
  iface->settings_changed = hildon_im_fcitx_fkb_settings_changed;
  iface->language_settings_changed = hildon_im_fcitx_fkb_language_settings_changed;
  iface->input_mode_changed = hildon_im_fcitx_fkb_input_mode_changed;
  iface->keyboard_state_changed = hildon_im_fcitx_fkb_keyboard_state_changed;
  iface->client_widget_changed = hildon_im_fcitx_fkb_client_widget_changed;

  iface->character_autocase = hildon_im_fcitx_fkb_character_autocase;
  iface->clear = hildon_im_fcitx_fkb_clear;
  iface->save_data = hildon_im_fcitx_fkb_save_data;
  iface->mode_a = hildon_im_fcitx_fkb_mode_a;
  iface->mode_b = hildon_im_fcitx_fkb_mode_b;
  iface->language = hildon_im_fcitx_fkb_language;
  iface->backspace = hildon_im_fcitx_fkb_backspace;
  iface->enter = hildon_im_fcitx_fkb_enter;
  iface->tab = hildon_im_fcitx_fkb_tab;
  iface->fullscreen = hildon_im_fcitx_fkb_fullscreen;
  iface->select_region = hildon_im_fcitx_fkb_select_region;
  iface->transition = hildon_im_fcitx_fkb_transition;
  iface->button_activated = hildon_im_fcitx_fkb_button_activated;
  iface->preedit_committed = hildon_im_fcitx_fkb_preedit_committed;
  */
}

static void
hildon_im_fcitx_fkb_class_init (HildonIMFcitxFKBClass *klass)
{
  GObjectClass *object_class;
  GtkObjectClass *gtk_object_class;
  GtkWidgetClass *widget_class;
  GtkContainerClass *container_class;

  parent_class = g_type_class_peek_parent(klass);
  g_type_class_add_private(klass, sizeof(HildonIMFcitxFKBPrivate));

  object_class = G_OBJECT_CLASS(klass);
  gtk_object_class = GTK_OBJECT_CLASS(klass);
  widget_class = GTK_WIDGET_CLASS(klass);
  container_class = GTK_CONTAINER_CLASS(klass);

  object_class->set_property  = hildon_im_fcitx_fkb_set_property;
  object_class->get_property  = hildon_im_fcitx_fkb_get_property;
  object_class->finalize      = hildon_im_fcitx_fkb_finalize;

  /* install properties and signals as needed */

  g_object_class_install_property(object_class, HILDON_IM_PROP_UI,
                                  g_param_spec_object (HILDON_IM_PROP_UI_DESCRIPTION,
                                                       HILDON_IM_PROP_UI_DESCRIPTION,
                                                       "UI that uses plugin",
                                                       HILDON_IM_TYPE_UI,
                                                       G_PARAM_READWRITE
                                                       | G_PARAM_CONSTRUCT_ONLY));
}

static void
hildon_im_fcitx_fkb_init (HildonIMFcitxFKB *self)
{
  HildonIMFcitxFKBPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_FCITX_FKB (self));
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);

  priv->window = NULL;
}

static void
hildon_im_fcitx_fkb_finalize(GObject *obj)
{
  if (G_OBJECT_CLASS(parent_class)->finalize)
  {
    G_OBJECT_CLASS(parent_class)->finalize(obj);
  }
}

GtkWidget *
hildon_im_fcitx_fkb_new (HildonIMUI *kbd)
{
  return g_object_new (HILDON_IM_FCITX_FKB_TYPE,
                       HILDON_IM_PROP_UI_DESCRIPTION, kbd, NULL);
}

static void
hildon_im_fcitx_fkb_get_property (GObject *object,
                                    guint prop_id,
                                    GValue *value,
                                    GParamSpec *pspec)
{
  HildonIMFcitxFKBPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_FCITX_FKB(object));
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(object);

  switch (prop_id)
  {
    case HILDON_IM_PROP_UI:
      g_value_set_object(value, priv->ui);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
      break;
  }
}

static void
hildon_im_fcitx_fkb_set_property (GObject *object,
                                    guint prop_id,
                                    const GValue *value,
                                    GParamSpec *pspec)
{
  HildonIMFcitxFKBPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_FCITX_FKB (object));
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(object);

  switch (prop_id)
  {
    case HILDON_IM_PROP_UI:
      priv->ui = g_value_get_object(value);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
      break;
  }
}
#ifndef G_DEBUG_DISABLE
static void LogToFile (const gchar *log_domain, GLogLevelFlags log_level, const gchar *message, gpointer user_data)
{
  FILE *logfile = fopen ("/tmp/fcitm_fkb.log", "a");
  if (logfile == NULL)
  {
    /*  Fall  back  to  console  output  if  unable  to  open  file  */
    printf ("Rerouted to console: %s\n", message);
    return;
  }
  fprintf (logfile, "%s\n", message);
  fclose (logfile);
}
#endif
/*static void power_off_save_data(osso_hw_state_t *state, gpointer data)
{
  if(state->shutdown_ind)
    SavePYIndex();
}*/
static void
hildon_im_fcitx_fkb_enable (HildonIMPlugin *plugin,gboolean init)
{
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;
  gboolean window_is_new;

  g_return_if_fail (HILDON_IS_IM_FCITX_FKB (plugin));
  self = HILDON_IM_FCITX_FKB(plugin);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);
  window_is_new = (priv->window == NULL);
  /*  Send  g_debug() to the file log */
#ifndef G_DEBUG_DISABLE
  g_log_set_handler (NULL, G_LOG_LEVEL_DEBUG, LogToFile, NULL);
#endif
  if (!window_is_new && !GTK_WIDGET_VISIBLE(GTK_WIDGET(priv->window)))
  {
    gtk_widget_destroy(priv->window);
    window_is_new = TRUE;
  }
  hildon_im_ui_play_sound(priv->ui, HILDON_IM_FINGER_TRIGGER_SOUND);
  if (window_is_new)
  {
    priv->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_type_hint(GTK_WINDOW(priv->window), GDK_WINDOW_TYPE_HINT_DIALOG/* | GDK_WINDOW_TYPE_HINT_NOTIFICATION*/);
    gtk_window_fullscreen(GTK_WINDOW (priv->window));
    gtk_window_set_decorated (GTK_WINDOW (priv->window), FALSE);
    /*gtk_window_set_default_size(GTK_WINDOW(priv->window),800,480);
    g_signal_connect(priv->window, "destroy", G_CALLBACK(close_fkb), self);*/
  }
  hildon_im_ui_send_communication_message(priv->ui,
                                          HILDON_IM_CONTEXT_REQUEST_SURROUNDING_FULL);
  /* Get current input mode. */
  priv->input_mode = hildon_im_ui_get_current_input_mode( priv->ui );
  priv->saved_offset = 0;

  gtk_widget_show(GTK_WIDGET(priv->window));
  gdk_window_set_transient_for(GTK_WIDGET(priv->window)->window,
                               gtk_widget_get_root_window(GTK_WIDGET(priv->window)));

  if (window_is_new)
  {
    populate_window(self);
    gtk_widget_show_all(GTK_WIDGET(priv->window));
    gtk_widget_hide(GTK_WIDGET(priv->buttons[3][2]));/* Dont show in english mode*/
    PYInit();
    gtk_widget_grab_focus(priv->text_view);
  }
}

static void
hildon_im_fcitx_fkb_disable (HildonIMPlugin *plugin)
{
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_FCITX_FKB (plugin));
  self = HILDON_IM_FCITX_FKB(plugin);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);

  if(priv->window)
    gtk_widget_destroy(priv->window);
}
/*static void
hildon_im_fcitx_fkb_key_event(HildonIMPlugin *plugin,
                                       GdkEventType type,
                                       guint state,
                                       guint keyval,
                                       guint hardware_keycode)
{
 HildonIMFcitxFKBPrivate *priv = HILDON_IM_FCITX_FKB_GET_PRIVATE (plugin);
}*/
static void
hildon_im_fcitx_fkb_surrounding_received(HildonIMPlugin *plugin,
                                           const gchar *surrounding,
                                           gint offset)
{
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;
  GtkTextBuffer *buffer;
  GtkTextIter cursor_iter;

  self = HILDON_IM_FCITX_FKB(plugin);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);

  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(priv->text_view));

  /* I don't know why, but the view doesn't reflect the changes immediately */
  gtk_text_buffer_set_text(buffer, surrounding, -1);
  gtk_text_buffer_get_iter_at_offset(buffer, &cursor_iter, offset);
  gtk_text_buffer_place_cursor(buffer, &cursor_iter);

  priv->saved_offset = offset;
}
static gboolean
textview_button_release_cb(GtkWidget *textview, GdkEventButton *event, gpointer data)
{
 if(event->type == GDK_BUTTON_RELEASE){
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;
  GtkTextBuffer *buffer;
  GtkTextIter iter;
  gint offset;

  g_return_val_if_fail (HILDON_IS_IM_FCITX_FKB (data), FALSE);
  self = HILDON_IM_FCITX_FKB(data);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);
  /* update the cursor position */
  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(priv->text_view));
  gtk_text_buffer_get_iter_at_mark(buffer, &iter,
                                   gtk_text_buffer_get_selection_bound(buffer));
  offset = gtk_text_iter_get_offset(&iter);
  if (hildon_im_ui_get_commit_mode(priv->ui) == HILDON_IM_COMMIT_REDIRECT)
  {
    hildon_im_ui_send_surrounding_offset(priv->ui,
                                         TRUE,
                                         offset - priv->saved_offset);
    priv->saved_offset = offset;
  }
 }
 return FALSE;
}

static gboolean
delete_selection (gpointer data)
{
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;
  GtkTextIter start, end;
  GtkTextBuffer *buffer;

  g_return_val_if_fail (HILDON_IS_IM_FCITX_FKB (data), FALSE);
  self = HILDON_IM_FCITX_FKB(data);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE (self);

  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (priv->text_view));

  if (gtk_text_buffer_get_selection_bounds (buffer, &start, &end))
  {
    if (hildon_im_ui_get_commit_mode (priv->ui) == HILDON_IM_COMMIT_REDIRECT)
    {
      gchar *selected_text = gtk_text_buffer_get_text (buffer, &start, &end, TRUE);

      hildon_im_ui_send_surrounding_offset (priv->ui,
                                            TRUE,
                                            gtk_text_iter_get_offset (&end) - priv->saved_offset);

      gint i;
      for (i = 0; i < g_utf8_strlen (selected_text, -1); i++)
      {
        hildon_im_ui_send_communication_message (priv->ui,
                                                 HILDON_IM_CONTEXT_HANDLE_BACKSPACE);
      }
    }
    gtk_text_buffer_delete (buffer, &start, &end);
    priv->saved_offset = gtk_text_iter_get_offset(&start);

    return TRUE;
  }

  return FALSE;
}
static void show_candwords(HildonIMFcitxFKBPrivate *priv)
{
  gchar tmp[MAX_USER_INPUT + 1];
  gchar *wd = tmp;
  tmp[0] = '\0';
  if(iPYInsertPoint){
    PYGetSelectedText(wd);
    g_strlcat(wd,(const gchar *)(&strFindString),-1);
    gtk_button_set_label(GTK_BUTTON(priv->buttons[1][9]),(const gchar *)wd);
    gtk_widget_show(GTK_WIDGET(priv->buttons[3][2]));
    gtk_button_set_label(GTK_BUTTON(priv->symbols_button),"翻页");
  }else{
    gtk_button_set_label(GTK_BUTTON(priv->buttons[1][9])," ");
    gtk_widget_hide(GTK_WIDGET(priv->buttons[3][2]));
    gtk_button_set_label(GTK_BUTTON(priv->symbols_button),"符");
    return;
  }
  PYGetCandText(0,wd);
  gtk_button_set_label(GTK_BUTTON(priv->buttons[3][5]),(const gchar *)wd);
  PYGetCandText(1,wd);
  gtk_button_set_label(GTK_BUTTON(priv->buttons[3][6]),(const gchar *)wd);
  PYGetCandText(2,wd);
  gtk_button_set_label(GTK_BUTTON(priv->buttons[3][4]),(const gchar *)wd);
  PYGetCandText(3,wd);
  gtk_button_set_label(GTK_BUTTON(priv->buttons[3][7]),(const gchar *)wd);
  PYGetCandText(4,wd);
  gtk_button_set_label(GTK_BUTTON(priv->buttons[3][3]),(const gchar *)wd);
}
static void
text_button_clicked (GtkButton *button, gpointer user_data)
{
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;
  GtkTextBuffer *buffer;
  GtkTextIter iter;
  const gchar *text;

  g_return_if_fail (HILDON_IS_IM_FCITX_FKB (user_data));
  self = HILDON_IM_FCITX_FKB(user_data);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);

  text = gtk_button_get_label(button);
  if(chinese_mode){
    if(('a' <= *text && 'z' >= *text) || ',' == *text || '.' == *text){
      if(iPYInsertPoint == 0 && ',' == *text)
        text = "，";
      else if(iPYInsertPoint == 0 && '.' == *text)
        text = "。";
      else{
        DoPYInput(*text);
        show_candwords(priv);
        return;
      }
    }else if(' ' == *text && iPYInsertPoint){
      strStringGet[0] = '\0';
      DoPYInput(*text);
      text = strStringGet;
      if(*text == '\0'){
        show_candwords(priv);
        return;
      }
      ResetPYStatus();
      show_candwords(priv);
    }else if(button == GTK_BUTTON(priv->buttons[3][3])
          || button == GTK_BUTTON(priv->buttons[3][4])
          || button == GTK_BUTTON(priv->buttons[3][5])
          || button == GTK_BUTTON(priv->buttons[3][6])
          || button == GTK_BUTTON(priv->buttons[3][7])){
      strStringGet[0] = '\0';
      if(button == GTK_BUTTON(priv->buttons[3][5])){
        DoPYInput('1');
      }else if(button == GTK_BUTTON(priv->buttons[3][6])){
        DoPYInput('2');
      }else if(button == GTK_BUTTON(priv->buttons[3][4])){
        DoPYInput('3');
      }else if(button == GTK_BUTTON(priv->buttons[3][7])){
        DoPYInput('4');
      }else if(button == GTK_BUTTON(priv->buttons[3][3])){
        DoPYInput('5');
      }
      text = strStringGet;
      if(*text == '\0'){
        show_candwords(priv);
        return;
      }
      ResetPYStatus();
      show_candwords(priv);
    }
  }

  delete_selection (self);
  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(priv->text_view));
  gtk_text_buffer_insert_at_cursor(buffer, text, -1);

  if (hildon_im_ui_get_commit_mode(priv->ui) == HILDON_IM_COMMIT_REDIRECT)
  {
    hildon_im_ui_send_utf8(priv->ui, text);
    gtk_text_buffer_get_iter_at_mark(buffer, &iter,
                                      gtk_text_buffer_get_insert (buffer));
    priv->saved_offset = gtk_text_iter_get_offset(&iter);
  }
  gtk_text_view_scroll_mark_onscreen (GTK_TEXT_VIEW (priv->text_view),
                                      gtk_text_buffer_get_insert (buffer));
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(priv->symbols_button)))
    if(*text < '0' || *text > '9'){
      button_update(priv, alpha_lower);
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(priv->symbols_button),FALSE);
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(priv->shift_button)))
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(priv->shift_button),FALSE);
  }
}

static gboolean
delete_button_clicked (gpointer user_data)
{
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;
  GtkTextIter iter;
  GtkTextBuffer *buffer;

  g_return_val_if_fail (HILDON_IS_IM_FCITX_FKB (user_data),FALSE);
  self = HILDON_IM_FCITX_FKB(user_data);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);

  priv->deleted = priv->deleted + 1;
  if(priv->deleted > 1 && priv->deleted <7)
    return TRUE;
  if(iPYInsertPoint){
    if(IRV_CLEAN  == DoPYInput(8))
      ResetPYStatus();
    show_candwords(priv);
    return TRUE;
  }

  if(delete_selection (self)) return TRUE;

  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(priv->text_view));
  gtk_text_buffer_get_iter_at_mark(buffer, &iter, gtk_text_buffer_get_insert(buffer));
  gint offset = gtk_text_iter_get_offset(&iter);
  if (offset <= 0)
    return FALSE;
  gtk_text_buffer_backspace (buffer, &iter, TRUE, TRUE);

  if (hildon_im_ui_get_commit_mode(priv->ui) == HILDON_IM_COMMIT_REDIRECT)
  {
    hildon_im_ui_send_communication_message(priv->ui,
                                            HILDON_IM_CONTEXT_HANDLE_BACKSPACE);
    gtk_text_buffer_get_iter_at_mark(buffer, &iter,
                                     gtk_text_buffer_get_selection_bound(buffer));
    priv->saved_offset = gtk_text_iter_get_offset(&iter);
  }
  return TRUE;
}

static void
button_update ( HildonIMFcitxFKBPrivate *priv, const gchar** keyboard_layout[])
{
  GtkWidget *labelchild;
  gchar *fontname = "Nokia Sans 24";
  if(gdk_screen_width() == 480) fontname = "Nokia Sans 20";
  PangoFontDescription *font = pango_font_description_from_string("Nokia Sans 24");
  gint i,j;
  for (i = 0; keyboard_layout[i] != NULL; i++)
  {
    for (j = 0; keyboard_layout[i][j] != NULL; j++)
    {
      gtk_button_set_label(GTK_BUTTON(priv->buttons[i][j]) ,keyboard_layout[i][j]);
      labelchild = gtk_bin_get_child(GTK_BIN(priv->buttons[i][j]));
      gtk_widget_modify_font(GTK_WIDGET(labelchild),font);
    }
  }
  pango_font_description_free(font);
  const gchar *t = gtk_button_get_label(GTK_BUTTON(priv->buttons[0][0]));
  if(*t == 'q')
    gtk_button_set_label(GTK_BUTTON(priv->space_button)," ");
}

static void
switch_button_clicked (GtkButton *button,
                               gpointer user_data)
{
  if(iPYInsertPoint)
    return;
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_FCITX_FKB (user_data));
  self = HILDON_IM_FCITX_FKB(user_data);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);

  if (chinese_mode)
  {
    chinese_mode = FALSE;
    gtk_button_set_label (GTK_BUTTON(priv->mode_button),"英");
  }
  else
  {
    chinese_mode = TRUE;
    gtk_button_set_label (GTK_BUTTON(priv->mode_button),"拼");
  }
}

static void
shift_symbols_buttons_toggled (GtkToggleButton *togglebutton,
                               gpointer user_data)
{
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_FCITX_FKB (user_data));
  self = HILDON_IM_FCITX_FKB(user_data);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(priv->symbols_button)))
  {
    if(iPYInsertPoint && chinese_mode){
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(priv->symbols_button), FALSE);
      PYGetCandWords(SM_NEXT);
      show_candwords(priv);
      return;
    }
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(priv->shift_button)))
    {
      button_update(priv, special_upper);
    }
    else
    {
      gtk_button_set_label(GTK_BUTTON(priv->space_button),"\t");
      if(chinese_mode)
        button_update(priv, special_cn);
      else
        button_update(priv, special_lower);
    }
  }else{
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(priv->shift_button)))
    {
      if(iPYInsertPoint && chinese_mode){
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(priv->shift_button), FALSE);
        PYGetCandWords(SM_PREV);
        show_candwords(priv);
        return;
      }
      button_update(priv, alpha_upper);
    }
    else
    {
      button_update(priv, alpha_lower);
    }
  }
}

static void
return_button_clicked (GtkButton *button, gpointer user_data)
{
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;
  GtkTextIter iter;
  GtkTextBuffer *buffer;

  g_return_if_fail (HILDON_IS_IM_FCITX_FKB (user_data));
  self = HILDON_IM_FCITX_FKB(user_data);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);

  if(iPYInsertPoint || (priv->input_mode & HILDON_GTK_INPUT_MODE_MULTILINE))
    delete_selection (self);
  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(priv->text_view));
  if(chinese_mode && iPYInsertPoint){
    if (hildon_im_ui_get_commit_mode(priv->ui) == HILDON_IM_COMMIT_REDIRECT){
      hildon_im_ui_send_utf8(priv->ui, (const char*)(&strCodeInput));
      gtk_text_buffer_get_iter_at_mark(buffer, &iter,
                                      gtk_text_buffer_get_insert (buffer));
      priv->saved_offset = gtk_text_iter_get_offset(&iter);
    }
    gtk_text_buffer_insert_at_cursor(buffer, (const char*)(&strCodeInput), -1);
    gtk_text_view_scroll_mark_onscreen (GTK_TEXT_VIEW (priv->text_view),
                                      gtk_text_buffer_get_insert (buffer));
    ResetPYStatus();
    show_candwords(priv);
    return;
  }

  if((priv->input_mode & HILDON_GTK_INPUT_MODE_MULTILINE) == 0){
    close_fkb(priv->window,self);
    return;
  }
  gtk_text_buffer_insert_at_cursor(buffer, "\n", 1);

  if (hildon_im_ui_get_commit_mode(priv->ui) == HILDON_IM_COMMIT_REDIRECT)
  {
    hildon_im_ui_send_utf8(priv->ui, "\n");
    gtk_text_buffer_get_iter_at_mark(buffer, &iter,
                                     gtk_text_buffer_get_selection_bound(buffer));
    priv->saved_offset = gtk_text_iter_get_offset(&iter);
  }
  gtk_text_view_scroll_mark_onscreen (GTK_TEXT_VIEW (priv->text_view),
                                      gtk_text_buffer_get_insert (buffer));
}
static void backspace_released(GtkButton *button,gpointer user_data)
{
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;
  g_return_if_fail (HILDON_IS_IM_FCITX_FKB (user_data));
  self = HILDON_IM_FCITX_FKB(user_data);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);
  priv->deleted = 0;
  if(priv->timeout_handler)
    g_source_remove(priv->timeout_handler);
}
static void backspace_pressed(GtkButton *button,gpointer user_data)
{
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;
  g_return_if_fail (HILDON_IS_IM_FCITX_FKB (user_data));
  self = HILDON_IM_FCITX_FKB(user_data);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);
  priv->deleted = 0;
  if (delete_button_clicked(self))
    priv->timeout_handler = g_timeout_add(100,delete_button_clicked,self);
}
static void
close_fkb (GtkWidget *button, gpointer user_data)
{
  HildonIMFcitxFKB *self;
  HildonIMFcitxFKBPrivate *priv;
  GtkTextIter start,end;
  GtkTextBuffer *buffer;

  g_return_if_fail (HILDON_IS_IM_FCITX_FKB (user_data));
  self = HILDON_IM_FCITX_FKB(user_data);
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);

  if(iPYInsertPoint){
    ResetPYStatus();
    show_candwords(priv);
  }
  hildon_im_ui_restore_previous_mode(priv->ui);

  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(priv->text_view));
  gtk_text_buffer_get_iter_at_mark(buffer, &start,
                                   gtk_text_buffer_get_selection_bound(buffer));
  gtk_text_buffer_get_bounds(buffer, &start, &end);
  gchar *text = gtk_text_buffer_get_text (buffer, &start, &end, FALSE);
  if(hildon_im_ui_get_commit_mode(priv->ui) == HILDON_IM_COMMIT_SURROUNDING)
    hildon_im_ui_send_surrounding_content( priv->ui, text);
  if(button == priv->window){
    hildon_im_ui_send_communication_message (priv->ui,
                                            HILDON_IM_CONTEXT_ENTER_ON_FOCUS);
  }
}
static gboolean textview_copy (GtkButton *button, gpointer data)
{
  HildonIMFcitxFKBPrivate *priv;
  GtkClipboard *clipboard = NULL;

  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(data);
  GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(priv->text_view));
  clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
  gtk_text_buffer_copy_clipboard (GTK_TEXT_BUFFER(buffer), clipboard);
  gtk_button_set_label(GTK_BUTTON(priv->buttons[1][9]),"复制");
  return TRUE;
}
static gboolean textview_paste (GtkButton *button, gpointer data)
{
  HildonIMFcitxFKBPrivate *priv;
  GtkClipboard *clipboard = NULL;
  GtkTextIter iter;
  gchar *text;

  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(data);
  delete_selection (data);
  GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(priv->text_view));
  clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
  text = gtk_clipboard_wait_for_text(clipboard);
  if (hildon_im_ui_get_commit_mode(priv->ui) == HILDON_IM_COMMIT_REDIRECT)
  {
    gtk_text_buffer_get_iter_at_mark(buffer, &iter,
                                      gtk_text_buffer_get_insert (buffer));
    hildon_im_ui_send_surrounding_offset (priv->ui,
                                            TRUE,
                                            gtk_text_iter_get_offset (&iter) - priv->saved_offset);
    hildon_im_ui_send_utf8(priv->ui, text);
    gtk_text_buffer_get_iter_at_mark(buffer, &iter,
                                      gtk_text_buffer_get_insert (buffer));
    priv->saved_offset = gtk_text_iter_get_offset(&iter);
  }
  gtk_text_buffer_paste_clipboard (GTK_TEXT_BUFFER(buffer), clipboard,NULL,TRUE);
  gtk_text_view_scroll_mark_onscreen (GTK_TEXT_VIEW (priv->text_view),
                                      gtk_text_buffer_get_insert (buffer));
  return TRUE;
}
static gboolean textview_cut (GtkButton *button, gpointer data)
{
  HildonIMFcitxFKBPrivate *priv;
  GtkClipboard *clipboard = NULL;
  GtkTextIter start, end;

  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(data);
  GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(priv->text_view));
  if (gtk_text_buffer_get_selection_bounds (buffer, &start, &end))
  {
    if (hildon_im_ui_get_commit_mode (priv->ui) == HILDON_IM_COMMIT_REDIRECT)
    {
      gchar *selected_text = gtk_text_buffer_get_text (buffer, &start, &end, FALSE);

      hildon_im_ui_send_surrounding_offset (priv->ui,
                                            TRUE,
                                            gtk_text_iter_get_offset (&end) - priv->saved_offset);

      gint i;
      for (i = 0; i < g_utf8_strlen (selected_text, -1); i++)
      {
        hildon_im_ui_send_communication_message (priv->ui,
                                                 HILDON_IM_CONTEXT_HANDLE_BACKSPACE);
      }
    }
    priv->saved_offset = gtk_text_iter_get_offset(&start);
  }
  clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
  gtk_text_buffer_cut_clipboard (GTK_TEXT_BUFFER(buffer), clipboard,TRUE);
  gtk_text_view_scroll_mark_onscreen (GTK_TEXT_VIEW (priv->text_view),
                                      gtk_text_buffer_get_insert (buffer));
  return TRUE;
}
static void
populate_window (HildonIMFcitxFKB *self)
{
  HildonIMFcitxFKBPrivate *priv;
  GtkWidget *parea, *labelchild;
  gint button_width = gdk_screen_width() / 10;
  gint fix_height = (button_width == 80)? 0:30;
  gchar *fontname = "Nokia Sans 24";
  priv = HILDON_IM_FCITX_FKB_GET_PRIVATE(self);
  if(button_width == 48){
    fontname = "Nokia Sans 20";
    hildon_gtk_window_set_portrait_flags (GTK_WINDOW (priv->window), HILDON_PORTRAIT_MODE_REQUEST);
  }
  PangoFontDescription *font = pango_font_description_from_string(fontname);
  priv->vbox = gtk_vbox_new(FALSE, 1);

  priv->buttons[1][9] = gtk_button_new();
  gtk_button_set_focus_on_click(GTK_BUTTON(priv->buttons[1][9]),FALSE);
  gtk_widget_set_size_request(priv->buttons[1][9], button_width*10, BUTTON_HEIGHT);
  g_signal_connect (priv->buttons[1][9], "clicked", G_CALLBACK(close_fkb), self);
  gtk_box_pack_start(GTK_BOX(priv->vbox), priv->buttons[1][9], FALSE, FALSE, 0);

  priv->text_view = gtk_text_view_new();
  gtk_text_view_set_editable (GTK_TEXT_VIEW (priv->text_view), TRUE);
  gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(priv->text_view), GTK_WRAP_CHAR);
  gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(priv->text_view), TRUE);
  gtk_text_view_set_left_margin(GTK_TEXT_VIEW(priv->text_view), 10);

  gtk_widget_modify_font(GTK_WIDGET(priv->text_view),font);
  g_signal_connect(G_OBJECT(priv->text_view), "button-release-event",
                         G_CALLBACK(textview_button_release_cb), self);

  GtkWidget *menu = gtk_menu_new();
  GtkWidget *separator1 = gtk_separator_menu_item_new();
  GtkWidget *separator2 = gtk_separator_menu_item_new();
  GtkWidget *copy_item = gtk_menu_item_new_with_label("复制");
  GtkWidget *cut_item = gtk_menu_item_new_with_label("剪切");
  GtkWidget *paste_item = gtk_menu_item_new_with_label("粘贴");
  gtk_menu_shell_append(GTK_MENU_SHELL(menu), copy_item);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu), separator1);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu), cut_item);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu), separator2);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu), paste_item);
  g_signal_connect(G_OBJECT(copy_item), "activate",
                         G_CALLBACK(textview_copy), self);
  g_signal_connect(G_OBJECT(cut_item), "activate",
                         G_CALLBACK(textview_cut), self);
  g_signal_connect(G_OBJECT(paste_item), "activate",
                         G_CALLBACK(textview_paste), self);
  gtk_widget_tap_and_hold_setup(priv->text_view, menu, NULL, 0);
  gtk_widget_show_all (menu);

  parea = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (parea),
                                  GTK_POLICY_NEVER,
                                  GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (parea), priv->text_view);
  gtk_container_add (GTK_CONTAINER (priv->vbox), parea);

  gint i, j;
  /* now we create the chinese word button in a hbox, use buttons[3][2] handler */
  priv->buttons[3][2]  = gtk_hbox_new(FALSE, 0);
  for (i = 3; i < 8; i++)
  {
        priv->buttons[3][i] = gtk_button_new();
        gtk_button_set_focus_on_click(GTK_BUTTON(priv->buttons[3][i]),FALSE);
        g_signal_connect(G_OBJECT(priv->buttons[3][i]), "clicked", G_CALLBACK(text_button_clicked), self);
        gtk_box_pack_start(GTK_BOX(priv->buttons[3][2]), GTK_WIDGET(priv->buttons[3][i]), TRUE, TRUE, 0);
  }
  gtk_box_pack_start(GTK_BOX(priv->vbox), priv->buttons[3][2], FALSE, FALSE, 0);

  for (i = 0; alpha_lower[i] != NULL; i++)
  {
    GtkWidget *hbox  = gtk_hbox_new(FALSE, 0);
    if (i == 1){
        GtkWidget *label = gtk_label_new(" ");
        gtk_widget_set_size_request(label, button_width*0.5, BUTTON_HEIGHT+fix_height);
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
    }
    else if (i == 2){
        priv->shift_button = gtk_toggle_button_new();
        gtk_button_set_focus_on_click(GTK_BUTTON(priv->shift_button),FALSE);
        gtk_container_add (GTK_CONTAINER (priv->shift_button),
                          gtk_image_new_from_icon_name("keyboard_shift",
                                                       -1));
        gtk_widget_set_size_request(priv->shift_button, button_width*1.5, BUTTON_HEIGHT+fix_height);
        gtk_box_pack_start(GTK_BOX(hbox), priv->shift_button, FALSE, FALSE, 0);
        g_signal_connect(G_OBJECT(priv->shift_button), "toggled", G_CALLBACK(shift_symbols_buttons_toggled), self);
    }
    else if (i == 3){
  /* Symbols button */

      priv->symbols_button = gtk_toggle_button_new_with_label ("符");
      gtk_button_set_focus_on_click(GTK_BUTTON(priv->symbols_button),FALSE);
      gtk_widget_set_size_request(priv->symbols_button, button_width*1.5, BUTTON_HEIGHT+fix_height);
      gtk_box_pack_start(GTK_BOX(hbox), priv->symbols_button, FALSE, FALSE, 0);
      g_signal_connect(priv->symbols_button, "toggled",
                   G_CALLBACK(shift_symbols_buttons_toggled), self);

      /* Chinese_switch button */

      priv->mode_button = gtk_button_new_with_label (chinese_mode?"拼":"英");
      gtk_button_set_focus_on_click(GTK_BUTTON(priv->mode_button),FALSE);
      gtk_widget_set_size_request(priv->mode_button, button_width, BUTTON_HEIGHT+fix_height);
      gtk_box_pack_start(GTK_BOX(hbox), priv->mode_button, FALSE, FALSE, 0);
      g_signal_connect(priv->mode_button, "clicked", G_CALLBACK(switch_button_clicked), self);

      /* Space button */

      priv->space_button = gtk_button_new_with_label(" ");
      gtk_button_set_focus_on_click(GTK_BUTTON(priv->space_button),FALSE);
      gtk_box_pack_start(GTK_BOX(hbox), priv->space_button, TRUE, TRUE, 0);
      g_signal_connect(G_OBJECT(priv->space_button), "pressed", G_CALLBACK(text_button_clicked), self);
    }
    for (j = 0; alpha_lower[i][j] != NULL; j++)
    {
        priv->buttons[i][j] = gtk_button_new_with_label(alpha_lower[i][j]);
        gtk_button_set_focus_on_click(GTK_BUTTON(priv->buttons[i][j]),FALSE);
        labelchild = gtk_bin_get_child(GTK_BIN(priv->buttons[i][j]));
        gtk_widget_modify_font(GTK_WIDGET(labelchild),font);
        gtk_widget_set_size_request(GTK_WIDGET(priv->buttons[i][j]),button_width,BUTTON_HEIGHT+fix_height);
        g_signal_connect(G_OBJECT(priv->buttons[i][j]), "pressed", G_CALLBACK(text_button_clicked), self);
        gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(priv->buttons[i][j]), FALSE, FALSE, 0);
    }
    if (i == 2){
        priv->delete_button = gtk_button_new();
        gtk_button_set_focus_on_click(GTK_BUTTON(priv->delete_button),FALSE);
        gtk_button_set_image(GTK_BUTTON(priv->delete_button),
                          gtk_image_new_from_icon_name("keyboard_backspace",
                                                       1));
        gtk_widget_set_size_request(priv->delete_button, button_width*1.5, BUTTON_HEIGHT+fix_height);
        g_signal_connect(G_OBJECT(priv->delete_button), "pressed", G_CALLBACK(backspace_pressed), self);
        g_signal_connect(G_OBJECT(priv->delete_button), "released", G_CALLBACK(backspace_released), self);
        gtk_box_pack_start(GTK_BOX(hbox), priv->delete_button, FALSE, FALSE, 0);
    }
    else if (i == 3){
      /* Return button */

      priv->return_button = gtk_button_new();
      gtk_button_set_focus_on_click(GTK_BUTTON(priv->return_button),FALSE);
      gtk_button_set_image(GTK_BUTTON(priv->return_button),
                          gtk_image_new_from_icon_name("keyboard_enter",
                                                       -1));
      gtk_widget_set_size_request(priv->return_button, button_width*1.5, BUTTON_HEIGHT+fix_height);
      gtk_box_pack_start(GTK_BOX(hbox), priv->return_button, FALSE, FALSE, 0);
      g_signal_connect(priv->return_button, "clicked", G_CALLBACK(return_button_clicked), self);
    }
    gtk_box_pack_start(GTK_BOX(priv->vbox), hbox, FALSE, FALSE, 0);
  }
  gtk_container_add (GTK_CONTAINER(priv->window), priv->vbox);
  pango_font_description_free(font);
  font = pango_font_description_from_string("Nokia Sans 32");
  gtk_widget_modify_font(GTK_WIDGET(GTK_BIN(copy_item)->child),font);
  gtk_widget_modify_font(GTK_WIDGET(GTK_BIN(cut_item)->child),font);
  gtk_widget_modify_font(GTK_WIDGET(GTK_BIN(paste_item)->child),font);
  pango_font_description_free(font);
}
