/***************************************************************************
 *   Copyright (C) 2002~2005 by Yuking                                     *
 *   yuking_net@sohu.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _PY_H
#define _PY_H

#include	<X11/Xlib.h>
#include	"im.h"
#include	"utf8.h"

#define PY_BASE_FILE	"/opt/usr/share/fcitx/pybase.mb"
#define PY_PHRASE_FILE	"/opt/usr/share/fcitx/pyphrase.mb"
#define PY_INDEX_FILE	"/home/user/.config/fcitx/pyindex.dat"

#define MAX_WORDS_USER_INPUT	32
#define MAX_PY_PHRASE_LENGTH	10
#define MAX_PY_LENGTH		6

#define AUTOSAVE_PHRASE_COUNT 	32
#define AUTOSAVE_ORDER_COUNT  	32
#define AUTOSAVE_FREQ_COUNT  	32

typedef enum FIND_MODE {
    FIND_PHRASE,
    FIND_BASE,
    FIND_FREQ,
    FIND_SYM
} FINDMODE;

typedef enum {
    PY_CAND_AUTO,
    PY_CAND_SYMBOL,
    PY_CAND_BASE,
    PY_CAND_SYMPHRASE,
    PY_CAND_USERPHRASE,
    PY_CAND_FREQ,
    PY_CAND_LEGEND
} PY_CAND_WORD_TYPE;

typedef struct _HZ {
    char            strHZ[MAX_PY_PHRASE_LENGTH * UTF8_MAX_LENGTH + 1];
    int             iPYFA;
    uint            iHit;
    uint            iIndex;
    struct _HZ     *next;
    uint            flag:1;
} HZ;

typedef struct PYFREQ {
    HZ             *HZList;
    char            strPY[MAX_PY_PHRASE_LENGTH * MAX_PY_LENGTH + 1];
    uint            iCount;
    Bool            bIsSym;	//For special symbols
    struct PYFREQ  *next;
} PyFreq;

typedef struct PYPHRASE {
    char           *strPhrase;
    char           *strMap;
    struct PYPHRASE *next;
    uint            iIndex;
    uint            iHit;
    uint            flag:1;
} PyPhrase;

typedef struct PYBASE {
    char            strHZ[UTF8_MAX_LENGTH + 1];
    struct PYPHRASE *phrase;
    int             iPhrase;
    struct PYPHRASE *userPhrase;
    int             iUserPhrase;
    uint            iIndex;
    uint            iHit;
    uint            flag:1;
} PyBase;

typedef struct _PYFA {
    char            strMap[3];
    struct PYBASE  *pyBase;
    int             iBase;
} PYFA;

typedef struct PYINDEX {
    int             iPYFA;
    int             iBase;
    int             iPhrase;
    struct PYINDEXCANDWORD *next;
    struct PYINDEXCANDWORD *prev;
} PYIndex;

typedef struct PYFREQCANDWORD {
    HZ             *hz;
    char           *strPY;
} PYFreqCandWord;

typedef struct PYPHRASECANDWORD {
    int             iPYFA;
    int             iBase;
    struct PYPHRASE *phrase;
} PYPhraseCandWord;

typedef struct PYBASECANDWORD {
    int             iPYFA;
    int             iBase;
} PYBaseCandWord;

typedef struct PYLEGENDCANDWORD {
    PyPhrase       *phrase;
    int             iLength;
} PYLegendCandWord;

typedef union {
    PYFreqCandWord  sym;
    PYFreqCandWord  freq;
    PYBaseCandWord  base;
    PYPhraseCandWord phrase;
} PCand;

typedef struct PYCANDWORD {
    PCand           cand;
    uint            iWhich:3;	//0->Auto 1->System single HZ 2->System phrase 3->User phrase 4->frequent HZ
} PYCandWord;

typedef struct PYCANDINDEX {
    int             iPYFA;
    int             iBase;
    int             iPhrase;
} PYCandIndex;

typedef struct {
    char            strPY[(MAX_PY_LENGTH + 1) * MAX_PY_PHRASE_LENGTH + 1];
    char            strHZ[MAX_PY_PHRASE_LENGTH * UTF8_MAX_LENGTH + 1];
    char            strMap[MAX_PY_PHRASE_LENGTH * 2 + 1];
} PY_SELECTED;

static void            PYInit (void);
static Bool            LoadPYBaseDict (void);
static Bool            LoadPYOtherDict (void);
static void            ResetPYStatus ();
static int             GetBaseIndex (int iPYFA, char *strBase);
static INPUT_RETURN_VALUE DoPYInput(unsigned int iKey);
static void            UpdateCodeInputPY (void);
static void            UpdateFindString (int val);

static void            PYResetFlags (void);
static void            PYCreateAuto (void);
static INPUT_RETURN_VALUE PYGetCandWords (SEARCH_MODE mode);
static void		PYGetCandText(int iIndex, char *strText);
static void		PYGetSelectedText(char *strText);
static char           *PYGetCandWord (int iIndex);
static void            PYGetBaseCandWords (SEARCH_MODE mode);
static Bool            PYAddBaseCandWord (PYCandIndex pos, SEARCH_MODE mode);
static void            PYGetFreqCandWords (SEARCH_MODE mode);
static Bool            PYAddFreqCandWord (HZ * hz, char *strPY, SEARCH_MODE mode);
static void            PYGetPhraseCandWords (SEARCH_MODE mode);
static Bool            PYAddPhraseCandWord (PYCandIndex pos, PyPhrase * phrase, SEARCH_MODE mode, Bool b);
static void            PYGetCandWordsForward (void);
static void            PYGetCandWordsBackward (void);
static Bool            PYCheckNextCandPage (void);
static void            PYSetCandWordFlag (int iIndex, Bool flag);
static void            PYSetCandWordsFlag (Bool flag);
static Bool            PYAddUserPhrase (char *phrase, char *map);
static void            PYDelUserPhrase (int iPYFA, int iBase, PyPhrase * phrase);
static int             GetBaseMapIndex (char *strMap);
static void            SavePYIndex (void);

static void            PYAddFreq (int iIndex);
static void            PYDelFreq (int iIndex);
static Bool            PYIsInFreq (char *strHZ);

//void            PP ();
#endif
