#include <FCam/processing/Color.h>
#include "Platform.h"

namespace FCam { namespace Dummy {
    
    void Platform::rawToRGBColorMatrix(int kelvin, float *matrix) {      
        float alpha = ((float)kelvin-3200)/(7000-3200);
        colorMatrixInterpolate(RawToRGBColorMatrix3200K,
                               RawToRGBColorMatrix7000K,
                               alpha, matrix);
    }

    // Utterly made up matrix - a bit of crosstalk and non-zero black level
    float Platform::RawToRGBColorMatrix3200K[] = {
        1.20, -0.1, -0.1, -10,
        -0.1, 1.20, -0.1, -10,
        -0.1, -0.1, 1.20, -10
    };

    // Utterly made up matrix - a bit of crosstalk and non-zero black level
    float Platform::RawToRGBColorMatrix7000K[] = {
        1.40, -0.2, -0.2, -10,
        -0.15, 1.30, -0.15, -10,
        0.1, 0.1, 1.00, -10
    };
            
    std::string Platform::manufacturer = "Stanford University";
    std::string Platform::model = "FCam Dummy Test Rig";
    unsigned short Platform::minRawValue = 0;
    unsigned short Platform::maxRawValue = 1024;
    BayerPattern Platform::bayerPattern = GRBG;
}}
