/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef FASTSMSWIDGET_H
#define FASTSMSWIDGET_H

#include <QWidget>
#include "dictionary.h"
#include "layoutmanager.h"
#include "textprocessor.h"

namespace Ui {
    class FastSMSWidget;
}

class FastSMSWidget : public QWidget
{
    Q_OBJECT

public:
    explicit FastSMSWidget(QWidget *parent = 0);
    ~FastSMSWidget();
    void enableQwerty();
    void setStandalone(bool bStandalone = true);
    QString getDeviceOrientation();

public Q_SLOTS: // METHODS
    bool addRecipient(const QString &phone, const QString &name);
    QString commitRequest();
    void standalone();
    void surroundRequest(const QString &text);

public slots:
    void insertNewWord();
    void openAboutDialog();
    void donate();
    void openOptionDialog();
    void loadSettings(bool bLoadDictionary = false);
    void orientationChanged(QString);

private:
    Ui::FastSMSWidget *ui;
    dictionary *m_dictionary;
    LayoutManager *m_layoutManager;
    TextProcessor *m_textProcessor;
    QDialog *m_dialNewWord;
    QLineEdit *m_inputNewWord;
    bool m_bDictionaryUpdated;
    bool m_bStandalone;
    QString m_sCurrOrientation;

private slots:
    void newWordInserted();
    void composite(QString,Core::Keyboards);
    //void commit();

protected:
    void closeEvent(QCloseEvent *);
};

#endif // FASTSMSWIDGET_H
