/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "fastsms.h"
#include "ui_fastsms.h"
#include "busManagerServ.h"
#include "kb_qwerty.h"
#include "dialogabout.h"
#include "dialogsettings.h"


Fastsms::Fastsms(QWidget *parent) :
        QMainWindow(parent),
        ui(new Ui::Fastsms)
{
    //Setup for QSettings
    QCoreApplication::setOrganizationName(Core::SETTING_ORG);
    QCoreApplication::setApplicationName(Core::SETTING_APPNAME);

//    //Test purpose: reset all settings
//    QSettings settings;
//    settings.remove("");

    //Manage signals from DBus
    new busManagerServ(this);
    registerService();
    //

    ui->setupUi(this);
    m_layoutManager = qobject_cast<LayoutManager *> (ui->centralwidget);
    m_textProcessor = m_layoutManager->getTextProcessor();
    m_bDictionaryUpdated = false;
    m_dictionary = NULL;

    //Setup and Load Settings
    loadSettings(true);
    //

    connect(ui->actionAbout,SIGNAL(triggered()),this,SLOT(openAboutDialog()));
    connect(ui->actionDonate,SIGNAL(triggered()),this,SLOT(donate()));
    connect(ui->actionNewWord,SIGNAL(triggered()),this,SLOT(insertNewWord()));
    connect(ui->actionOptions,SIGNAL(triggered()),this,SLOT(openOptionDialog()));
    connect(ui->actionQuit,SIGNAL(triggered()),this,SLOT(close()));
}

Fastsms::~Fastsms()
{
    delete ui;
}

void Fastsms::saveDictionaryOnExit()
{
    if(m_bDictionaryUpdated)
    {
        m_dictionary->saveDictionaryToFile();
    }
}

/** Menu Management */
void Fastsms::openAboutDialog()
{
    DialogAbout *about = new DialogAbout(this);
    about->setAttribute(Qt::WA_DeleteOnClose);
    about->show();
}

void Fastsms::donate()
{
    QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=V353RBQ6TATN6"));
}

void Fastsms::openOptionDialog()
{
    DialogSettings *dialSettings = new DialogSettings(this);
    dialSettings->setAttribute(Qt::WA_DeleteOnClose);
    connect(dialSettings,SIGNAL(settingsChanged(bool)),this,SLOT(loadSettings(bool)));
    dialSettings->show();
}

void Fastsms::loadSettings(bool bLoadDictionary)
{
    QSettings settings;

    //Language
    if(bLoadDictionary)
    {
        QString sLang = settings.value(Core::SETTING_LANGUAGE,"").toString();

        //First start
        if(sLang.isEmpty())
        {
            openOptionDialog();
            return;
        }

        if(m_bDictionaryUpdated)
            m_dictionary->saveDictionaryToFile();

        if(m_dictionary != NULL)
            delete m_dictionary;

        m_dictionary = new dictionary(new QString(sLang),this);
        m_textProcessor->setDictionary(m_dictionary);
        settings.setValue(Core::SETTING_LANGUAGE,sLang);
    }

    //Orientation
#if defined(Q_WS_MAEMO_5)
    QString sCurrOrient = settings.value(Core::SETTING_ORIENTATION).toString();
    if(sCurrOrient.compare(Core::ORIENTATION_LANDSCAPE) == 0)
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
    else if(sCurrOrient.compare(Core::ORIENTATION_PORTRAIT) == 0)
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
    else
        setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    //Font
    int nFontSize = settings.value(Core::SETTING_FONTSIZE).toInt();
    m_textProcessor->setSmsFontSize(nFontSize * 9 + 18); //we will have 18,27 or 36
}

bool Fastsms::registerService()
{
    QDBusConnection connection = QDBusConnection::sessionBus();
    if ( !connection.registerService("it.rsc.fastsms") ) {
        qDebug() << "error registering service.";
        return false;
    }
    if ( !connection.registerObject("/", this) ) {
        qDebug() << "error registering object";
        return false;
    }

    return true;
}

bool Fastsms::addRecipient(const QString &phone, const QString &name)
{
    return m_textProcessor->m_recipient->addRecipient(phone,name);
}

void Fastsms::insertNewWord()
{
    m_dialNewWord = new QDialog(this);
    m_dialNewWord->setAttribute(Qt::WA_DeleteOnClose);
    m_inputNewWord = new QLineEdit(m_dialNewWord);
    QPushButton *btOk = new QPushButton("Ok",m_dialNewWord);
    connect(btOk,SIGNAL(clicked()),this,SLOT(newWordInserted()));
    QGridLayout *insWordLayout = new QGridLayout();
    insWordLayout->addWidget(m_inputNewWord,0,0);
    kb_Qwerty *kb = new kb_Qwerty(m_dialNewWord,true);
    connect(kb,SIGNAL(input(QString,Core::Keyboards)),this,SLOT(composite(QString,Core::Keyboards)));
    insWordLayout->addWidget(kb,1,0);
    insWordLayout->addWidget(btOk,2,0);
    insWordLayout->setContentsMargins(0,0,0,0);
    m_inputNewWord->setFocus();

    m_dialNewWord->setWindowTitle("Type new word");
    m_dialNewWord->setLayout(insWordLayout);
    m_dialNewWord->showMaximized();
}

void Fastsms::composite(QString sChar, Core::Keyboards)
{
    if(sChar.compare(Keyboard::DELETE) == 0)
        m_inputNewWord->backspace();
    else
        m_inputNewWord->insert(sChar);
}

void Fastsms::newWordInserted()
{
    QString *newWord = new QString(m_inputNewWord->text().toLower());
    if(!newWord->isEmpty())
    {
        qDebug() << "New word is:" << newWord->toAscii();
        m_bDictionaryUpdated = m_dictionary->addWord(newWord);
        m_textProcessor->addNewWord(newWord);
    }

    m_dialNewWord->close();
}

void Fastsms::enableQwerty()
{
    m_layoutManager->enableQwerty();
}







