#include "settingsmenu.h"
#include <QDebug>

SettingsMenu* SettingsMenu::m_instance;

SettingsMenu::SettingsMenu(QWidget *parent) :
    QMenu(parent)
{
    //Add menu for functions button
    setTitle("Functions");

    QSettings settings;

    m_aEnableQwerty = new QAction(Core::LBL_QWERTY,this);
    m_aEnableQwerty->setData(QwertyOn);
    connect(m_aEnableQwerty,SIGNAL(triggered()),this, SLOT(settingsChanged()));
    addAction(m_aEnableQwerty);

    m_aEnableAlfanum = new QAction(Core::LBL_ALFANUM,this);
    m_aEnableAlfanum->setData(AlfanumOn);
    connect(m_aEnableAlfanum,SIGNAL(triggered()),this, SLOT(settingsChanged()));
    addAction(m_aEnableAlfanum);

    addSeparator();

    m_aFastWrite = new QAction(Core::LBL_FASTWRITE_OFF,this);
    m_aFastWrite->setData(FastWriteOff);
    connect(m_aFastWrite,SIGNAL(triggered()),this, SLOT(settingsChanged()));
    addAction(m_aFastWrite);

    addSeparator();

    m_aAutoCapitalization = new QAction(Core::LBL_AUTOCAPITALIZATION,this);
    m_aAutoCapitalization->setData(AutoCapitalize);
    connect(m_aAutoCapitalization,SIGNAL(triggered()),this, SLOT(settingsChanged()));
    addAction(m_aAutoCapitalization);

    m_aUpperCase = new QAction(Core::LBL_UPPERCASE,this);
    m_aUpperCase->setData(UpperCase);
    connect(m_aUpperCase,SIGNAL(triggered()),this, SLOT(settingsChanged()));
    addAction(m_aUpperCase);

    m_aLowerCase = new QAction(Core::LBL_LOWERCASE,this);
    m_aLowerCase->setData(LowerCase);
    connect(m_aLowerCase,SIGNAL(triggered()),this, SLOT(settingsChanged()));
    addAction(m_aLowerCase);

    m_aDigit = new QAction(Core::LBL_DIGIT,this);
    m_aDigit->setData(DigitOnly);
    connect(m_aDigit,SIGNAL(triggered()),this, SLOT(settingsChanged()));
    addAction(m_aDigit);
    //

    //Synchronize with active kb
    if(settings.value(Core::SETTING_CURRENT_KEYBOARD) == (Core::Qwerty))
        qwertyEnabled();
    else
        alfanumEnabled();
}

SettingsMenu* SettingsMenu::instance(QWidget *parent)
{
    if(!m_instance)
        m_instance = new SettingsMenu(parent);

    return m_instance;
}

void SettingsMenu::drop()
{
    delete m_instance;
    m_instance = 0;
}

SettingsMenu::~SettingsMenu()
{
    if(!m_instance)
        drop();
}

void SettingsMenu::settingsChanged()
{
    QAction *action = qobject_cast<QAction *>(sender());

    int nAction = action->data().toInt();

    switch (nAction)
    {
    case AutoCapitalize:
        break;
    case UpperCase:
        break;
    case LowerCase:
        break;
    case DigitOnly:
        break;
    case FastWriteOn:
        m_aFastWrite->setText(Core::LBL_FASTWRITE_OFF);
        m_aFastWrite->setData(SettingsMenu::FastWriteOff);
        break;
    case FastWriteOff:
        m_aFastWrite->setText(Core::LBL_FASTWRITE_ON);
        m_aFastWrite->setData(SettingsMenu::FastWriteOn);
        break;
    case QwertyOn:
        qwertyEnabled();
        break;
    case AlfanumOn:
        alfanumEnabled();
        break;
    }

    emit inputStyleChanged(nAction);
}

void SettingsMenu::qwertyEnabled()
{
    m_aEnableAlfanum->setVisible(true);
    m_aEnableQwerty->setVisible(false);
    m_aDigit->setVisible(false);
    m_aFastWrite->setVisible(false);
    m_aUpperCase->setVisible(false);
}

void SettingsMenu::alfanumEnabled()
{
    m_aEnableAlfanum->setVisible(false);
    m_aEnableQwerty->setVisible(true);
    m_aDigit->setVisible(true);
    m_aFastWrite->setVisible(true);
    m_aUpperCase->setVisible(true);
}

void SettingsMenu::updateMenu(int nActiveKeyboard)
{
    if(nActiveKeyboard == Core::Qwerty)
        qwertyEnabled();
    else
        alfanumEnabled();
}

