#include "phonebook.h"
#include "ui_phonebook.h"

PhoneBook::PhoneBook(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::PhoneBook)
{
    ui->setupUi(this);
    connect(ui->listWidget,SIGNAL(itemDoubleClicked(QListWidgetItem*)),this,SLOT(contactSelected(QListWidgetItem*)));

    loadContacts();

    hide();
}

PhoneBook::~PhoneBook()
{
    delete ui;
    m_contacts.clear();
}

void PhoneBook::loadContacts()
{
    m_fetchRequest = new QContactFetchRequest();
    m_availableManagers = new QContactManager();
    m_fetchRequest->setManager(m_availableManagers);
    QContactSortOrder nameOrder;
    nameOrder.setDetailDefinitionName(QContactName::DefinitionName, QContactName::FieldFirstName);
    m_fetchRequest->setSorting(QList<QContactSortOrder>() << nameOrder);
    connect(m_fetchRequest, SIGNAL(resultsAvailable()), this, SLOT(contactsReady()));

    // async
    QContactFetchHint fetchHint;
    fetchHint.setOptimizationHints(QContactFetchHint::NoBinaryBlobs);
    fetchHint.setDetailDefinitionsHint(QStringList() << QContactName::DefinitionName <<QContactPhoneNumber::DefinitionName);
    m_fetchRequest->setFetchHint(fetchHint);
    if (!m_fetchRequest->start())
        qDebug() << "Can't start contacts fetch";
}

void PhoneBook::contactsReady()
{
   qDebug() << "Contacts fetch finished";

   QList<QContact> lstContacts = m_fetchRequest->contacts();
   qDebug() << "Got " << lstContacts.size() << " contacts";

   for (int i = 0; i < lstContacts.size(); i++)
   {
       QContact temp = lstContacts.at(i);

       QList<QContactPhoneNumber> allPhones = temp.details<QContactPhoneNumber>();
       foreach (const QContactPhoneNumber& pn, allPhones)
       {
           if(pn.hasValue(QContactPhoneNumber::FieldNumber))
           {
               QString contact = temp.displayLabel() + ": " + pn.value(QContactPhoneNumber::FieldNumber);
               m_contacts.append(contact);
           }
       }
   }

   delete m_fetchRequest;
   delete m_availableManagers;
}

void PhoneBook::open()
{
    move(0,70);
    int nWidth = parentWidget()->size().width();
    int nHeight = parentWidget()->size().height();
    setFixedSize(nWidth, nHeight);
    show();
    raise();
}

void PhoneBook::updateContactsList(QString *sFilterText)
{
    if(sFilterText->isEmpty())
    {
        hide();
        return;
    }

    ui->listWidget->clear();

    QString sRegExp = *sFilterText;

    if(sFilterText->contains(QRegExp("[0-9]")))
    {
        sRegExp.clear();
        for(int i=0; i<sFilterText->length(); i++)
        {
            if(sFilterText->at(i).isDigit())
            {
                if(sFilterText->at(i) == '2')
                    sRegExp.append("[a|b|c|2]");
                else if(sFilterText->at(i) == '3')
                    sRegExp.append("[d|e|f|3]");
                else if(sFilterText->at(i) == '4')
                    sRegExp.append("[g|h|i|4]");
                else if(sFilterText->at(i) == '5')
                    sRegExp.append("[j|k|l|5]");
                else if(sFilterText->at(i) == '6')
                    sRegExp.append("[m|n|o|6]");
                else if(sFilterText->at(i) == '7')
                    sRegExp.append("[p|q|r|s|7]");
                else if(sFilterText->at(i) == '8')
                    sRegExp.append("[t|u|v|8]");
                else if(sFilterText->at(i) == '9')
                    sRegExp.append("[w|x|y|z|9]");
                else
                    sRegExp.append(QString("[").append(sFilterText->at(i)).append("]"));
            }
        }
    }

    QRegExp regExp(sRegExp,Qt::CaseInsensitive);
    foreach(QString sContact, m_contacts)
    {
        if(sContact.contains(regExp))
        {
            ui->listWidget->addItem(sContact);
        }
    }

    if(ui->listWidget->count() > 0)
        open();
    else
        hide();

//     TOO SLOW ON N900
//    QContactUnionFilter filter;
//    QContactDetailFilter filName;
//    filName.setDetailDefinitionName(QContactName::DefinitionName, QContactName::FieldFirstName);
//    filName.setValue(*sFilterText);
//    filName.setMatchFlags(QContactFilter::MatchContains);
//    filter.append(filName);

//    QContactDetailFilter filSurname;
//    filSurname.setDetailDefinitionName(QContactName::DefinitionName, QContactName::FieldLastName);
//    filSurname.setValue(*sFilterText);
//    filSurname.setMatchFlags(QContactFilter::MatchContains);
//    filter.append(filSurname);

//    QContactDetailFilter filAlfanumName;
//    filAlfanumName.setDetailDefinitionName(QContactName::DefinitionName, QContactName::FieldFirstName);
//    filAlfanumName.setValue(*sFilterText);
//    filAlfanumName.setMatchFlags(QContactFilter::MatchContains | QContactFilter::MatchKeypadCollation);
//    filter.append(filAlfanumName);

//    QContactDetailFilter filAlfanumSurname;
//    filAlfanumSurname.setDetailDefinitionName(QContactName::DefinitionName, QContactName::FieldLastName);
//    filAlfanumSurname.setValue(*sFilterText);
//    filAlfanumSurname.setMatchFlags(QContactFilter::MatchContains | QContactFilter::MatchKeypadCollation);
//    filter.append(filAlfanumSurname);

//    QContactDetailFilter filPhone;
//    filPhone.setDetailDefinitionName(QContactPhoneNumber::DefinitionName, QContactPhoneNumber::FieldNumber);
//    filPhone.setValue(*sFilterText);
//    filPhone.setMatchFlags(QContactFilter::MatchContains);
//    filter.append(filPhone);
}

void PhoneBook::contactSelected(QListWidgetItem* item)
{
    QString sFull = item->text();
    QStringList sList = sFull.split(":");
    QString sPhone = sList.at(1);
    emit addRecipient(sPhone.trimmed(), sList.at(0));
    hide();
}
