#ifndef TEXTPROCESSOR_H
#define TEXTPROCESSOR_H

#include <QWidget>
#include "recipient.h"
#include "core.h"
#include "dictionary.h"
#include "settingsmenu.h"
#include "keyboard.h"
#include <QtGui>

namespace Ui {
    class TextProcessor;
}

class TextProcessor : public QWidget
{
    Q_OBJECT

public:
    explicit TextProcessor(QWidget *parent = 0);
    void setDictionary(dictionary *dict);
    void setSmsFontSize(int nSize);
    ~TextProcessor();
    QList<QString> m_lWord;
    Recipient *m_recipient;
    void enableNewWordLayout();
    void addNewWord(QString *sWord);


private:
    dictionary *m_dict;
    Ui::TextProcessor *ui;
    QTextEdit *m_smsEdit;
    QLineEdit *m_phoneNumber;
    void addText(QString sWord);
    void processQwerty(QString sInput);
    void processAlfanumeric(QString sInput);
    void resetFastWriteStatus();
    void loadDict();
    bool m_bFastInput;
    int m_nInputSyle;
    int m_nState;
    int m_nMsgLength;
    QString m_sCompleteValue;
    int m_nWordIndex;
    int m_nBeginWord;
    int m_nEndWord;
    QTextCursor m_cursorSmsText;
    bool m_bTimerNewChar;
    QString m_sLastPress;
    bool m_bRememberUppercase;
    void updateCharCounter(int action);
    void updateText(QString sWord);
    QTimer *m_timerNewChar;
    QString capitalizeIfNeeded(QString sWord);
    int m_nCharCount;
    int m_nSMSCount;
    QString m_sCapitalization;
    void processDigit(QString sInput);
    void moveCursorBt(bool bMoveRight);
    void deleteChar();
    void nextWord();
    void prevWord();
    QString *m_sMessage;
    int m_nSavedStyle;
    bool m_bQwertyEnable;

public slots:
    void processInput(QString, Core::Keyboards);
    void settingsChanged(int);
    void sendSms();

private slots:
    void alarmNewChar();
    void cursorPosChanged();
    void smsChanged();
};

#endif // TEXTPROCESSOR_H
