#include "recipient.h"
#include "ui_recipient.h"
#include <QMessageService>
#include <QDebug>
#include <QDBusMessage>
#include <QDBusConnection>
#include <QSettings>
#include <QLabel>
#include <QDialog>
#include "core.h"

#if defined(Q_WS_MAEMO_5)
#include <QMaemo5InformationBox>
#endif

#define PHONEBOOK_HORIZONTALCALL 0
#define PHONEBOOK_MYCONTACTS 1

//using namespace QtMobility;
QTM_USE_NAMESPACE

Recipient::Recipient(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::Recipient)
{
    ui->setupUi(this);

    m_btSend = ui->btSend;
    connect(ui->btTo,SIGNAL(clicked()), this, SLOT(openPhoneBook()));
}

Recipient::~Recipient()
{
    delete ui;
}

QLineEdit* Recipient::getPhoneNumberField()
{
    return ui->lePhoneNumber;
}

bool Recipient::sendSMS(QString sMessage)
{
    bool bSuccess = false;
    QMessageService service;
    QMessageManager manager;

    //Find right account for SMS: default one doesnt work well
    QMessageAccountIdList lstMsgAccountId = manager.queryAccounts();

    if(!sMessage.isEmpty() && !ui->lePhoneNumber->text().isEmpty())
    {
        //Message box
        #if defined(Q_WS_MAEMO_5)
        QMaemo5InformationBox::information(this, "Sending...",
                                           QMaemo5InformationBox::DefaultTimeout);
        #endif
        //

        if(!lstMsgAccountId.isEmpty())
        {
            qDebug() << "SMS text:" << sMessage;
            for(int i = 0; i < lstMsgAccountId.count(); ++i)
            {
                QMessageAccount account(lstMsgAccountId[i]);
                bool isSmsAccount = (account.messageTypes() & QMessage::Sms) > 0;

                if(isSmsAccount)
                {
                    QMessage myMessage;
                    myMessage.setType(QMessage::Sms);
                    myMessage.setParentAccountId(lstMsgAccountId[i]);
                    myMessage.setTo(QMessageAddress(QMessageAddress::Phone, ui->lePhoneNumber->text()));
                    myMessage.setBody(sMessage.toAscii());

                    bSuccess = service.send(myMessage);
                    break;
                }
            }
        }
    }
    return bSuccess;
}

bool Recipient::addRecipient(const QString &phone, const QString &name)
{
    ui->lePhoneNumber->clear();
    ui->lePhoneNumber->setText(phone);

    this->activateWindow();
    this->raise();

    return true;
}

void Recipient::openPhoneBook()
{
    QSettings settings;

    bool ok = false;
    int Pb = settings.value(Core::SETTING_PHONEBOOK).toInt();

    if(Pb == PHONEBOOK_MYCONTACTS)
    {
        QDBusMessage msg = QDBusMessage::createMethodCall(
                "com.crochik.MyContacts", // --dest
                "/", // destination object path
                "com.crochik.MyContacts",
                "select_phone"
                );

        msg << "Opening Mycontacts";
        QList<QVariant> args;
        args.append("FastSMS");
        msg.setArguments(args);
        msg = QDBusConnection::sessionBus().call(msg);
        qDebug() << msg;
        ok = msg.type() != QDBusMessage::ErrorMessage;
    }

    else if((Pb) == PHONEBOOK_HORIZONTALCALL)
    {
        QDBusMessage msg = QDBusMessage::createMethodCall(
                "com.eitam.horizontalcall", // --dest
                "/com/eitam/horizontalcall", // destination object path
                "com.eitam.horizontalcall", // message name (w/o method)
                "top_application" // method
                );

        msg = QDBusConnection::sessionBus().call(msg);
        qDebug() << msg;
        ok = msg.type() != QDBusMessage::ErrorMessage;
    }

    if(!ok)
    {
        QString sPhoneBook;
        if((Pb) == PHONEBOOK_HORIZONTALCALL)
            sPhoneBook = "Horizontal-Call";
        else if (Pb == PHONEBOOK_MYCONTACTS)
            sPhoneBook = "My-Contacts";
        QDialog *dlCont = new QDialog(this);
        dlCont->setAttribute(Qt::WA_DeleteOnClose);

        dlCont->setWindowTitle("Can't open selected phonebook");
        QGridLayout *layout = new QGridLayout();
        QString sInfo = QString("\nInstall " + sPhoneBook + "\n"
                                "from Application Manager \n"
                                "or change it in Option Menu.\n");
        QLabel *msg = new QLabel(sInfo);
        layout->addWidget(msg,0,0);
        dlCont->setLayout(layout);
        dlCont->show();
    }
}

