#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) 2011 Marian Kluehspies <marian300@gmx.de>

# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
#Importe

import sys
import kissen
import random
import osso
import dbus
import webbrowser
import subprocess
from PyQt4.phonon import Phonon
from PyQt4 import QtGui
from PyQt4.uic import loadUi

random.seed()

class MainWindow(QtGui.QMainWindow):
    def __init__(self, parent=None):
        QtGui.QMainWindow.__init__(self,parent)
       
        #MainWindow Initialisierung/Laden des Stylesheets
        self.ui=loadUi("/opt/farty/furzkissen.ui")
        self.ui.show()
        self.ui.showFullScreen()
        
 
        #Vibration
        self._MCE_SERVICE = 'com.nokia.mce'
        self._MCE_REQUEST_PATH = '/com/nokia/mce/request'
        self._MCE_REQUEST_IF = 'com.nokia.mce.request'
        self._VIBRATE = 'req_vibrator_pattern_activate'
        self._VIBRATE_PATTERN= 'PatternChatAndEmail'
        self.osso_c = osso.Context('program', '1.0', False)
        self.rpc = osso.Rpc(self.osso_c)
        

        #Verstecken der Wolken, Aufruf durch Signal-Slot-System des Designers
        self.ui.wolke.hide()
        self.ui.wolke2.hide()
        self.ui.wolke3.hide()
        self.ui.checkedButton.hide()
        
        
        self.m_media = Phonon.MediaObject(self)
        audioOutput = Phonon.AudioOutput(Phonon.MusicCategory, self)
        Phonon.createPath(self.m_media, audioOutput)
       
        #Zuordnung der Buttons mit Verweis auf deren Methoden
       
        self.ui.fart.pressed.connect(self.fartrandom)
        self.ui.close.clicked.connect(self.closefunc)
        self.ui.minimize.clicked.connect(self.minimizefunc)
        self.ui.idea.clicked.connect(self.ideafunc)
        self.ui.about.clicked.connect(self.donate)
        self.ui.craveo.clicked.connect(self.craveobrowser)
        self.ui.checkButton.toggled.connect(self.checked)
        self.ui.checkedButton.toggled.connect(self.unchecked)
                
    def checked(self):    
        self.ui.checkButton.hide()
        self.ui.checkedButton.show()
        self.ui.checkedButton.setChecked(False)
            
    def unchecked(self):
        self.ui.checkedButton.hide()
        self.ui.checkButton.show()
        self.ui.checkButton.setChecked(False)
        
       
    def fartrandom(self):#Zufallsmechanismus für Abspielen der Furzsounds 10-81 
        
        if self.ui.checkButton.isChecked():
            for _ in range(2):
                self.rpc.rpc_run(self._MCE_SERVICE, self._MCE_REQUEST_PATH,self._MCE_REQUEST_IF,
                                 self._VIBRATE,rpc_args=(self._VIBRATE_PATTERN,"",""),use_system_bus=True)
        else:
            pass  
           
        fartnumber=random.randint(10,81)
        path="/opt/farty/Furzsounds/furz0"+str(fartnumber)+".wav"
        self.m_media.setCurrentSource(Phonon.MediaSource(path))
        self.m_media.play()
   
    def closefunc(self):#Methode zum Schließen des Mainwindows
        sys.exit()
        
    def minimizefunc(self):#Experimentell, schließt statt zu minimieren
        subprocess.Popen(['dbus-send', '--type=signal', '--session', '/com/nokia/hildon_desktop', 'com.nokia.hildon_desktop.exit_app_view'])
                
         
    def ideafunc(self):
        QtGui.QMessageBox.about(self, "Farty the Farter:\n",
                 "Click me, in order to let me fart.\n"
                 "I can do more than 65 different\n"
                 "kind of fart sounds\n"
                 "Have fun and keep farting ;)\n")
    def craveobrowser(self):
        webbrowser.open("http://www.craveo.de")
        
    def donate(self):
	webbrowser.open("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=QFCCCX495Q392")
        sys.exit()        
        #QtGui.QMessageBox.aboutQt(self) 
                          
    
app = QtGui.QApplication(sys.argv)
main = MainWindow()
sys.exit(app.exec_())
