#ifdef MYDEF_GTK_EXISTS
extern "C"
{
    #include <gdk/gdk.h>
    #include <gtk/gtk.h>
}
#endif

#include <QtCore>
#include <QtGui>
#include <QDBusConnection>
#include <QDBusInterface>
#include <phonon/AudioOutput>
#include <phonon/MediaObject>

#ifdef Q_WS_MAEMO_5
#include <QtMaemo5>
#endif

extern "C"
{
#include <sys/vfs.h>
#include <unistd.h>
}

#include "mainwindow.h"
#include "version.h"
#include "ui_mainwindow.h"
#include "aaptinterface.h"
#include "packageview.h"
#include "confirmdialog.h"
#include "dimmer.h"
#include "repoview.h"
#include "help.h"
#include "settings.h"
#include "logview.h"
#include "rotatingbackground.h"
#include "dpkginterface.h"
#include "installfile.h"
#include "repository.h"


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    iAptInterface = new AAptInterface(this);
    iWinPackageView = new PackageView(this);
    iWinPackageView->setAptInterface(iAptInterface);
    iWinRepoView = new RepoView(this);
    iWinRepoView->setAptInterface(iAptInterface);
    iSettings = new Settings(this);
    iSettings->setAptInterface(iAptInterface);
    iSettings->setPackageView(iWinPackageView);
    iWinPackageView->setSettings(iSettings);
    iAptInterface->setSettings(iSettings);
    iDpkgInterface = new DpkgInterface(this);

    iWinPackageView->setSortOrder( (PackageView::sortOrder)iSettings->qsettings()->value("default_sort_order",0).toInt() );

    iWinPackageView->setSearchOptions( iSettings->qsettings()->value("search_pkgnames",true).toBool(),
                                       iSettings->qsettings()->value("search_displaynames",true).toBool(),
                                       iSettings->qsettings()->value("search_descshort",true).toBool(),
                                       iSettings->qsettings()->value("search_desclong",false).toBool() );

#ifdef Q_WS_MAEMO_5
    if( !iSettings->qsettings()->value("disable_autorotation",false).toBool() ) {
        this->setAttribute(Qt::WA_Maemo5AutoOrientation);
    } else {
        this->setAttribute(Qt::WA_Maemo5LandscapeOrientation);
    }
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    iDimmer = new dimmer(this);

    iReposAutoUpdating = false;
    iUpgradeAutoUpdate = true;
    iNextOperation = OpNone;

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));

    ui->centralWidget->loadWallpaper();

    /*
    QString stylesheet_mainscreen =
            "QPushButton {"
            "border-radius: 16px;"
            "border-width: 1px;"
            "border-color: palette(light);"
            "border-style: outset;"
            "padding-right: 10px;"
            "padding-left: 10px;"
            "color: palette(buttontext);"
            "background: rgba(255,255,255,80);"
            "}"
            "QPushButton:pressed {"
            "border-style: inset;"
            "background-color: rgba(255,255,255,150);"
            "}";
    */

    if( ((QApplication*)QApplication::instance())->styleSheet().isEmpty() )
    {
        QString stylesheet_file;
        QFile f("/root/.fapman/style.css");
        if( f.open(QIODevice::ReadOnly | QIODevice::Text ) )
        {
            while(!f.atEnd()) {
                stylesheet_file += f.readLine().trimmed();
            }
            f.close();
        }

        if( stylesheet_file.isEmpty() ) {
            //ui->centralWidget->setStyleSheet(stylesheet_mainscreen);
        } else {
            ((QApplication*)QApplication::instance())->setStyleSheet(stylesheet_file);
        }
    }

    // workaround for Trolltech.conf getting owned by root..
#ifdef Q_WS_MAEMO_5
    QFileInfo trollConf("/home/user/.config/Trolltech.conf");
    if( trollConf.exists() && trollConf.ownerId() == 0 )
    {
        uint uid = 29999; // "user" (maemo5)
        uint gid = 29999; // "users" (maemo5)
        chown(trollConf.absoluteFilePath().toAscii(), uid, gid);
    }
#endif

    iMediaObject = new Phonon::MediaObject(this);
    Phonon::AudioOutput* aout = new Phonon::AudioOutput(Phonon::NotificationCategory, this);
    Phonon::createPath(iMediaObject, aout);

    showFreeSpace();

    iNetworkConfigurationManager = new QNetworkConfigurationManager(this);
    iNetworkSession = new QNetworkSession(iNetworkConfigurationManager->defaultConfiguration(),this);

    show();
    rescaleMenuView();
}

MainWindow::~MainWindow()
{
    // save "need repo refresh" status
    iSettings->qsettings()->setValue("need_repo_refresh", iAptInterface->needRepoRefresh());

    if( iNetworkSession && iNetworkSession->isOpen() ) {
        iNetworkSession->close();
    }
    // iNetworkSession automatically deleted by parent

    delete iWinPackageView; iWinPackageView=0;
    delete iWinRepoView; iWinRepoView=0;
    delete iAptInterface; iAptInterface=0;
    delete iDpkgInterface; iDpkgInterface=0;
    delete iDimmer; iDimmer=0;
    delete iSettings; iSettings=0;
    delete ui; ui=0;
    //iMediaObject and aout automatically deleted by their parent
}

void MainWindow::openNetworkConnection()
{
    if( iNetworkSession->isOpen() )
        return;

    iNetworkSession->open();
    if( !iNetworkSession->waitForOpened(20000) )
    {
        ConfirmDialog d(false, this);
        d.setText("Network error","Unable to open a network connection");
        d.exec();
    }
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::on_btnRepos_clicked()
{
    iWinRepoView->openWin();
}

void MainWindow::on_btnUpdate_clicked()
{
    // update catalogs

    openNetworkConnection();

    busyDialog(true, tr("Operation in progress"), tr("Updating catalogs"));

    iAptInterface->addQueuedOperation(AAptInterface::ModeAptGetUpdate);
    iAptInterface->run(iDimmer);
}

#ifdef Q_WS_MAEMO_5
int MainWindow::top_application()
{
    show();
    activateWindow();
    raise();
    return 0;
}
#endif

void MainWindow::dateFetchAsk()
{
    if( !iSettings->qsettings()->value("firstrun_asked_fetch_dates",false).toBool() &&
        !iSettings->qsettings()->value("fetch_dates",false).toBool() )
    {
        iSettings->qsettings()->setValue("firstrun_asked_fetch_dates", true);
        ConfirmDialog d(true, this);
        d.setText("Fetch date information?","Enable date information fetching for packages? You have to enable it in order to be "
                  "able to sort packages by date. The first fetch can be slow but the dates are cached for later use. You can later "
                  "change this selection from the options menu.");
        if( d.exec() )
            iSettings->qsettings()->setValue("fetch_dates", true);
    }
    if( iSettings->qsettings()->value("fetch_dates",false).toBool() )
    {
        iSettings->qsettings()->setValue("firstrun_asked_fetch_dates", true);	// don't ask if the option has already been enabled
        if( !iAptInterface->dateCacheExists() )
        {
            ConfirmDialog d(false, this);
            d.setText("Notice","Date information will be fetched only for packages from maemo.org and only for user categories.");
            d.exec();
        }
        iAptInterface->addQueuedOperation(AAptInterface::ModeFetchDates);
    }
}

void MainWindow::on_btnListInstallable_clicked()
{
    //install

    openNetworkConnection();

    int listupd = -1;
    int dpkgupd = -1;
    if( iAptInterface->lastListUpdate() < QDateTime::currentDateTime().addSecs(-KListExpireTime) )
        listupd = 1;
    if( iAptInterface->lastDpkgUpdate() < QDateTime::currentDateTime().addSecs(-KListExpireTime) )
        dpkgupd = 1;
    iAptInterface->setNeedRefresh(-1,listupd,dpkgupd,listupd);

    iWinPackageView->setStatFilter( Package::PkgStatNotInstalled );

    if( iAptInterface->needRepoRefresh() && !iSettings->qsettings()->value("no_catalogs_autoupdate",false).toBool() )
        iAptInterface->addQueuedOperation(AAptInterface::ModeAptGetUpdate);

    busyDialog(true, tr("Operation in progress"), tr("Reading package lists"));

    iNextOperation = OpOpenPkgView;
    iAptInterface->addQueuedOperation(AAptInterface::ModeReadPackages);

    dateFetchAsk();

    iAptInterface->run(iDimmer);
}

void MainWindow::on_btnUpgrade_clicked()
{
    // upgrade

    openNetworkConnection();

    int listupd = -1;
    int dpkgupd = -1;
    if( iAptInterface->lastListUpdate() < QDateTime::currentDateTime().addSecs(-KListExpireTime) )
        listupd = 1;
    if( iAptInterface->lastDpkgUpdate() < QDateTime::currentDateTime().addSecs(-KListExpireTime) )
        dpkgupd = 1;
    iAptInterface->setNeedRefresh(-1,listupd,dpkgupd,listupd);

    iWinPackageView->setStatFilter( Package::PkgStatUpgradeable );

    if( iAptInterface->needRepoRefresh() && !iSettings->qsettings()->value("no_catalogs_autoupdate",false).toBool() )
        iAptInterface->addQueuedOperation(AAptInterface::ModeAptGetUpdate);

    busyDialog(true, tr("Operation in progress"), tr("Reading package lists"));

    iNextOperation = OpOpenPkgView;
    iAptInterface->addQueuedOperation(AAptInterface::ModeReadPackages);

    dateFetchAsk();

    iAptInterface->run(iDimmer);
}

void MainWindow::on_btnListInstalled_clicked()
{
    //remove

    if( !iSettings->qsettings()->value("remove_readfull",false).toBool() )
        iAptInterface->setSkipListAndDates();

    int dpkgupd = -1;
    if( iAptInterface->lastDpkgUpdate() < QDateTime::currentDateTime().addSecs(-KListExpireTime) )
        dpkgupd = 1;
    iAptInterface->setNeedRefresh(-1,-1,dpkgupd,-1);

    iWinPackageView->setStatFilter( Package::PkgStatInstalled );

    busyDialog(true, tr("Operation in progress"), tr("Reading package lists"));

    iNextOperation = OpOpenPkgView;
    iAptInterface->addQueuedOperation(AAptInterface::ModeReadPackages);

    dateFetchAsk();

    iAptInterface->run(iDimmer);
}

void MainWindow::operationQueueFinished(QList<AAptInterface::interfaceMode> lastModes, bool success, QString title, QStringList msgs)
{
    if( lastModes.contains(AAptInterface::ModeAptGetSimulate) && success ) {
        iNextOperation = OpPromptSimulated;
    }
    if( lastModes.contains(AAptInterface::ModeAptGetInstall) && success ) {
        iWinPackageView->clearSelections();
        busyDialog(false);
        iWinPackageView->close();
        iNextOperation = OpNone;

        GdkEventIconThemeReload();
    }

    QWidget* dialogParent = this;
    if( iWinPackageView->isVisible() )
        dialogParent = iWinPackageView;

    if( iNextOperation == OpOpenPkgView && success )
    {
        iWinPackageView->openWin();
        busyDialog(false);
        iNextOperation = OpNone;
    } else if( iNextOperation == OpPromptSimulated && success )
    {
        QStringList inst,remv,instver,remvver;
        QStringList all = iAptInterface->processPackages();
        QStringList vers = iAptInterface->processPackageVersions();
        for(int zyx=0; zyx<all.count(); zyx++)
        {
            if( all.at(zyx).endsWith('-') )
            {
                remv.append( all.at(zyx).left( all.at(zyx).size()-1 ) );
                if( vers.count()>zyx )
                    remvver.append( vers.at(zyx) );
            } else {
                inst.append( all.at(zyx) );
                if( vers.count()>zyx )
                    instver.append( vers.at(zyx) );
            }
        }

        int total_dl_size = 0;
        for( int i=0; i<inst.count(); i++ ) {
            Package* pkg = iAptInterface->packagesAvailable()->value(inst.at(i),0);
            if( pkg ) {
                total_dl_size += pkg->size()/1024;
            }
        }

        QString pkglist;
        pkglist = QString("<b>The following operations will be performed:</b><br>"
                  "%1 to install/upgrade, %2 to remove<br>").arg(inst.count()).arg(remv.count());
        if( inst.count()>0 )
            pkglist += QString("Total download size: %L1 kB<br>").arg(total_dl_size);
        bool mismatch = false;
        bool warn_system_package_remove = false;
        bool warn_system_package_install = false;

        if( remv.count()>0 ) {
            pkglist += "<br><b><u>REMOVE:</u></b><br><font size=\"-1\">";
            for( int i=0; i<remv.count(); i++ ) {
                pkglist += "<b>" + remv.at(i) + "</b>";
                Package* pkg = iAptInterface->packagesInstalled()->value(remv.at(i),0);
                if( !pkg ) {
                    qDebug() << "Warning: unknown package" << remv.at(i);
                    pkglist += "<font color=\"red\">***UNKNOWN***</font>";
                    mismatch = true;
                }
#ifdef Q_WS_MAEMO_5
                if( pkg && pkg->maemoDisplayName()=="Maemo 5" ) {
                    warn_system_package_remove = true;
                }
#endif
                if( remvver.count()>i ) {
                    pkglist += " " + remvver.at(i);
                    if( pkg && remvver.at(i) != pkg->version() ) {
                        qDebug() << "Version mismatch, database version is" << pkg->version() << "but removing" << remvver.at(i);
                        mismatch = true;
                        pkglist += " <font color=\"red\">***TRYING TO REMOVE " + pkg->version() + "***</font> ";
                    }
                }
                if( pkg && pkg->installedSize()>0 )
                    pkglist += QString(" (%L1 kB)").arg(pkg->installedSize());
                pkglist += "<br>";
            }
        }
        pkglist += "</font>";

        bool installing_blacklisted = false;
        if( inst.count()>0 ) {
            pkglist += "<br><b><u>INSTALL/UPGRADE:</u></b><br><font size=\"-1\">";
            for( int i=0; i<inst.count(); i++ ) {
                pkglist += "<b>" + inst.at(i) + "</b>";
                Package* pkg = iAptInterface->packagesAvailable()->value(inst.at(i),0);
                if( !pkg ) {
                    qDebug() << "Warning: unknown package" << inst.at(i);
                    pkglist += "<font color=\"red\">***NEW/UNKNOWN***</font>";
                    mismatch = true;
                }
                if( pkg && pkg->isBlacklisted() ) {
                    qDebug() << "Warning: installing blacklisted package" << inst.at(i);
                    pkglist += "<font color=\"red\">***BLACKLISTED***</font>";
                    installing_blacklisted = true;
                }
#ifdef Q_WS_MAEMO_5
                if( pkg && pkg->maemoDisplayName()=="Maemo 5" ) {	// unreliable?
                    warn_system_package_install = true;
                }
#endif
                if( instver.count()>i ) {
                    pkglist += " " + instver.at(i);
                    if( pkg && instver.at(i) != pkg->version() ) {
                        qDebug() << "Version mismatch, database version is" << pkg->version() << "but installing" << instver.at(i);
                        mismatch = true;
                        pkglist += " <font color=\"red\">***TRYING TO INSTALL " + pkg->version() + "***</font> ";
                    }
                }
                if( pkg && pkg->size()>0 ) {
                    pkglist += QString(" (%L1 kB)").arg(pkg->size()/1024);
                }
                pkglist += "<br>";
            }
        }
        pkglist += "</font>";

        if( mismatch ) {
            ConfirmDialog m(false, dialogParent);
            m.setText("Warning", "There is a version mismatch between your original package selections and some of the packages being installed " \
                      "from the repositories. This could be due to your application catalogs being out of date.");
            m.exec();
        }
        if( installing_blacklisted ) {
            ConfirmDialog b(false, dialogParent);
            b.setText("Warning","Blacklisted package(s) will be installed");
            b.exec();
        }
        if( warn_system_package_remove ) {
            ConfirmDialog s(false, dialogParent);
            s.setText("Warning","You are about to remove a critical system package.");
            s.exec();
        }
        if( warn_system_package_install ) {
            ConfirmDialog s(false, dialogParent);
            s.setText("Warning","You are trying to perform an install/upgrade operation on a critical system package. Doing a system upgrade with " \
                      "Faster Application Manager has not been tested and it could result in a horrible failure. You have been warned.");
            s.exec();
        }

        busyDialog(false);
        ConfirmDialog d(true, dialogParent);
        if( inst.count()==0 && remv.count()==0 )
        {
            pkglist = "None of the packages can be installed";
            d.disableButton();
        }
        d.setText("Confirmation",pkglist);
        if( d.exec() ) {
            iAptInterface->addQueuedOperation(AAptInterface::ModeAptGetInstall);

            if( iSettings->qsettings()->value("enable_autoclean",true).toBool() && inst.count()>0 )
                iAptInterface->addQueuedOperation(AAptInterface::ModeAptGetClean);

            QString busytext;
            if( remv.count() > 0 )
                busytext += QString("Remove %1 package(s)<br>").arg(remv.count());
            if( inst.count() > 0 )
                busytext += QString("Install %1 package(s)<br>").arg(inst.count());
            busytext += "Preparing...";
            busyDialog(true, "Operation in progress", busytext);

            // "run" really does nothing here since the previous item should still be running
            if( iWinPackageView->isVisible() ) {
                iAptInterface->run(iWinPackageView->mydimmer());
            } else {
                iAptInterface->run(iDimmer);
            }
        }
        iNextOperation = OpNone;
        return;
    } else {
        busyDialog(false);
        iNextOperation = OpNone;

        if( iSettings->qsettings()->value("sound_notify",false).toBool() )
        {
            qDebug() << "playing sound";
            iMediaObject->setCurrentSource( Phonon::MediaSource(iSettings->qsettings()->value("sound_file","/usr/share/sounds/ui-operation_ready.wav").toString()) );
            iMediaObject->play();
        }

        QString text = "<br><b><u>Faster Application Manager</u></b><br>"
                       "<b>"+title+"</b><br>" + msgs.join("<br>") + "<br>";

        QRect r = QApplication::desktop()->rect();
        if(r.width() < r.height()) {
            ConfirmDialog d(false, dialogParent);
            d.setText(title,msgs.join("<br>"));
            d.exec();
        } else {
#ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(0, text, QMaemo5InformationBox::NoTimeout);
#else
            ConfirmDialog d(false, dialogParent);
            d.setText(title,msgs.join("<br>"));
            d.exec();
#endif
        }

        showFreeSpace();
    }

}

void MainWindow::busyDialog(bool show_, QString title, QString text)
{
    if( show_ ) {
        iDimmer->setProgress(-1);
        ui->menuMenu->setEnabled(false);
        ui->centralWidget->setEnabled(false);
        iWinPackageView->disableMenu();
        iDimmer->resizeEvent(0);
        iDimmer->dim(title, text);
        iWinPackageView->mydimmer()->resizeEvent(0);
        iWinPackageView->mydimmer()->dim(title, text);
    } else {
        iDimmer->undim();
        iWinPackageView->mydimmer()->undim();
        ui->menuMenu->setEnabled(true);
        ui->centralWidget->setEnabled(true);
        iWinPackageView->enableMenu();
    }
}

void MainWindow::on_actionAbout_triggered()
{
    ConfirmDialog d(false, this);
    d.setText("About","Faster Application Manager<br>"
              "<font size=\"-1\">Version " + PROGRAM_VERSION + "</font><br><br>"
              "(C) Heikki Holstila 2010<br>Donate using "
              "<a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=6ZKRY5QFHL42A&lc=FI&item_name=Faster%20Application%20Manager"
              "%20for%20Maemo5&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted\">PayPal</a>");
    d.exec();
}

void MainWindow::on_actionClean_triggered()
{
    //if( iOperation != OpNone ) return;
    //iOperation = OpClean;
    iAptInterface->addQueuedOperation(AAptInterface::ModeAptGetClean);
    iAptInterface->run(iDimmer);
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    if( iDimmer->busy() ) {
        iAptInterface->cancel();
        event->ignore();
    } else {
        event->accept();
    }
}

void MainWindow::on_actionView_log_triggered()
{
    QByteArray log = iAptInterface->readLogFile();
    LogView l(log, this);
    l.exec();
}

void MainWindow::on_actionOptions_triggered()
{
    iSettings->openWin();
}

void MainWindow::notifyDialog(QString title, QString msg)
{
    QWidget* dialogParent = this;
    if( iWinPackageView->isVisible() )
        dialogParent = iWinPackageView;

    ConfirmDialog d(false, dialogParent);
    d.setText(title, msg);
    d.exec();
}

bool MainWindow::confirmDialog(QString title, QString msg)
{
    QWidget* dialogParent = this;
    if( iWinPackageView->isVisible() )
        dialogParent = iWinPackageView;

    ConfirmDialog d(true, dialogParent);
    d.setText(title, msg);
    return d.exec();
}

void MainWindow::GdkEventIconThemeReload()
{
    // DOES NOT EVEN WORK (at least not reliably) - disabled from the project file

#ifdef MYDEF_GTK_EXISTS
    qDebug() << "Sending GDK icon theme reload event";

    gdk_init((int*)QApplication::argc(),(gchar***)QApplication::argv());

    // taken from hildon application manager
    GdkEventClient ev;
    ev.type = GDK_CLIENT_EVENT;
    ev.window = NULL;
    ev.send_event = TRUE;
    ev.message_type = gdk_atom_intern_static_string("_GTK_LOAD_ICONTHEMES");
    ev.data_format = 32;
    gdk_event_send_clientmessage_toall((GdkEvent*)&ev);

    while(gdk_events_pending()) {
        g_main_context_iteration(NULL, true);
    }

#endif
}

void MainWindow::on_actionLoad_file_triggered()
{
    /*
    QStringList files = QFileDialog::getOpenFileNames(this, "Open files", "/", "Files (*.deb *.install)");
    QStringList debs;
    QStringList installs;
    if( files.count() > 0 ) {
        debs = files.filter(QRegExp(".*\\.deb$"));
        installs = files.filter(QRegExp(".*\\.install$"));
        if( debs.count()>0 && installs.count()>0 ) {
            ConfirmDialog d(false, this);
            d.setText("Error", "You can't mix different file types in your selection");
            d.exec();
            return;
        } else if( installs.count() != 1 ) {
            ConfirmDialog d(false, this);
            d.setText("Error","Select only one install file");
            d.exec();
            return;
        }
        if( debs.count()>0 )
            iDpkgInterface->loadDebFiles(debs);
        else if( installs.count()==1 )
            InstallFile instf(installs.at(0));
    }
    */

    QString file = QFileDialog::getOpenFileName(this, "Open file", "/", "Install files (*.install)");
    if( !file.isEmpty() ) {
        InstallFile instf( file );
        bool reposchanged = false;
        if( instf.isValid() ) {
            qDebug() << "SUCCESS";
            for(int i=0; i<instf.repositories().count(); i++) {
                qDebug() << instf.repositories().at(i)->toString();
                bool found=false;
                for(int j=0; j<iAptInterface->repositories()->count(); j++) {
                    if( instf.repositories().at(i) && iAptInterface->repositories()->at(j) &&
                        instf.repositories().at(i)->toString(true) == iAptInterface->repositories()->at(j)->toString(true) )
                    {
                        found = true;
                        qDebug() << "found";
                        if( !iAptInterface->repositories()->at(j)->enabled() ) {
                            iAptInterface->repositories()->at(j)->setEnabled(true);
                            reposchanged = true;
                            qDebug() << "not enabled, enabling";
                        }
                    }
                }
                if( !found ) {
                    qDebug() << "repo not found, adding";
                    Repository* r = new Repository();
                    r->setFromString( instf.repositories().at(i)->toString(true) );
                    iAptInterface->repositories()->append(r);
                    reposchanged = true;
                }
            }


            if( reposchanged ) {
                iAptInterface->writeRepositories();
            }
            iAptInterface->setNeedRefresh(1,1,-1,1);
            this->on_btnUpdate_clicked();

        } else {
            qDebug() << "FAIL";
            ConfirmDialog d(false, this);
            d.setText("Error",instf.errorString());
            d.exec();
        }
    }
}

void MainWindow::resizeEvent(QResizeEvent* event)
{
    rescaleMenuView();

    if( iDimmer ) {
        iDimmer->resize( this->size() );
    }

    QMainWindow::resizeEvent(event);
}

void MainWindow::rescaleMenuView()
{
    QRect sg = ui->listWidget->rect();

    if( sg.width() > sg.height() ) {
        ui->listWidget->setGridSize( QSize((sg.width()-12)/5, (sg.height()-12)/2) );
    } else {
        ui->listWidget->setGridSize( QSize((sg.width()-12)/3, (sg.height()-12)/3) );
    }
}

void MainWindow::orientationChanged()
{
}


void MainWindow::showFreeSpace()
{
    quint64 warn_limit_root = 5120;
    quint64 warn_limit_opt = 51200;
    struct statfs root_stat;
    struct statfs opt_stat;
    statfs("/",&root_stat);
    statfs("/opt",&opt_stat);
    quint64 free_root = static_cast<quint64>(root_stat.f_bavail) * static_cast<quint64>(root_stat.f_bsize) / 1024;
    quint64 free_opt = static_cast<quint64>(opt_stat.f_bavail) * static_cast<quint64>(opt_stat.f_bsize) / 1024;
    quint64 total_root = static_cast<quint64>(root_stat.f_blocks) * static_cast<quint64>(root_stat.f_bsize) / 1024;
    quint64 total_opt = static_cast<quint64>(opt_stat.f_blocks) * static_cast<quint64>(opt_stat.f_bsize) / 1024;
    qDebug() << "rootfs" << free_root << "/" << total_root << "kB free";
    qDebug() << "opt fs" << free_opt << "/" << total_opt << "kB free";

    QString rootstr = QString("rootfs: %L1 / %L2 MB free").arg(free_root/1024).arg(total_root/1024);
    QString optstr = QString("opt: %L1 / %L2 MB free").arg(free_opt/1024).arg(total_opt/1024);

    ui->label->setText("<font size=\"-1\">" + rootstr + "<br>" + optstr + "</font>");

    /*
    ui->progressBarRoot->setFormat(rootstr);
    ui->progressBarRoot->setMaximum(total_root/1024);
    ui->progressBarRoot->setValue(free_root/1024);
    ui->progressBarOpt->setFormat(optstr);
    ui->progressBarOpt->setMaximum(total_opt/1024);
    ui->progressBarOpt->setValue(free_opt/1024);
    */

    if( free_root < warn_limit_root || free_opt < warn_limit_opt )
    {
        ConfirmDialog d(false, this);
        QString t;
        if( free_root < warn_limit_root )
            t += QString("Root filesystem has %L1 kB available<br>").arg(free_root);
        if( free_opt < warn_limit_opt )
            t += QString("Opt (home) filesystem has %L1 kB available<br>").arg(free_opt);
        t += "<br>You may proceed, but consider freeing up space to prevent problems in the future";
        d.setText("Warning: Low disk space",t);
        d.exec();
    }
}

void MainWindow::on_listWidget_itemClicked(QListWidgetItem* item)
{
    qDebug() << "main menu:" << item->statusTip();

    if( item->statusTip() == "manage_repos" ) {
        on_btnRepos_clicked();
    }
    else if( item->statusTip() == "update_catalogs" ) {
        on_btnUpdate_clicked();
    }
    else if( item->statusTip() == "install_apps" ) {
        on_btnListInstallable_clicked();
    }
    else if( item->statusTip() == "remove_apps" ) {
        on_btnListInstalled_clicked();
    }
    else if( item->statusTip() == "upgrade_apps" ) {
        on_btnUpgrade_clicked();
    }
    else {
        qDebug() << "Warning: Unhandled main menu item";
    }
    item->setSelected(false);
}
