/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include <QtGui>
#include "repoview.h"
#include "ui_repoview.h"
#include "mainwindow.h"
#include "aaptinterface.h"
#include "confirmdialog.h"
#include "repository.h"
#include "repoedit.h"

RepoView::RepoView(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::RepoView)
{
	iMainWindow = dynamic_cast<MainWindow*>(parent);
	ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5StackedWindow);
	this->setWindowFlags(Qt::Window);
	this->setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif

	iModified = false;
}

RepoView::~RepoView()
{
    delete ui;
}

void RepoView::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void RepoView::openWin()
{
	if( !isVisible() ) {
		iModified = false;
	}

	ui->listWidget->clear();

	for( int i=0; i<iAptInterface->repositories()->count(); i++ )
	{
		QListWidgetItem* l = new QListWidgetItem( ui->listWidget );
		if( iAptInterface->repositories()->at(i)->enabled() )
			l->setIcon(QPixmap(":/icons/icons/pkg_install.png"));
		else
			l->setIcon(QPixmap(":/icons/icons/pkg_remove.png"));
		l->setText( iAptInterface->repositories()->at(i)->name() );
		l->setData(Qt::UserRole, i);
		ui->listWidget->addItem( l );
	}

	show();
}

void RepoView::closeEvent(QCloseEvent *event)
{
	event->accept();

	if( iModified )
	{
		iAptInterface->writeRepositories();
		iMainWindow->on_btnUpdate_clicked();
	}
}

void RepoView::on_btnNew_clicked()
{
	Repository* n = new Repository();
	iAptInterface->repositories()->append(n);

	// add an option to set these directly
	//"deb http://repository.maemo.org/extras-testing/ fremantle free non-free"
	//"deb http://repository.maemo.org/extras-devel/ fremantle free non-free";

	RepoEdit e(iAptInterface, n, iAptInterface->repositories()->count()-1, this);
	if( !e.exec() ) {
		if( n ) {
			delete n;
			iAptInterface->repositories()->removeAt( iAptInterface->repositories()->count()-1 );
			n=0;
		}
	} else {
		iModified = true;
	}

	openWin();
}

void RepoView::on_listWidget_itemClicked(QListWidgetItem* item)
{
	Repository* r = iAptInterface->repositories()->at( item->data(Qt::UserRole).toInt() );
	if( r!=0 ) {
		RepoEdit e(iAptInterface, r, item->data(Qt::UserRole).toInt(), this);
		if( e.exec() )
			iModified = true;
		openWin();
	}
}

void RepoView::on_actionRe_import_HAM_repo_settings_triggered()
{
	ConfirmDialog d(true, this);
	d.setText("Confirm repository import","You're about to re-read the repository settings from Hildon Application Manager. This will import the "
			  "repositories that are currently enabled in HAM and it will clear your current repository settings here. Continue?");
	if( d.exec() )
	{
		QFile r(KOwnRepoFile);
		QFile n(KOwnRepoNamesFile);
		r.remove();
		n.remove();
		iAptInterface->readRepositoryInfo();
		iModified = true;
		openWin();	// refresh view
	}
}
