#ifndef INSTALLFILE_H
#define INSTALLFILE_H

#include <QtCore>

class Repository;

class InstallFile
{
public:
    enum sections { sectNone, sectInstall, sectCatalogues, sectRepo, sectInvalid };

    explicit InstallFile(QString filename);
    virtual ~InstallFile();

    bool isValid() { return iIsValid; }
    QString errorString() { return iErrorString; }
    QList<Repository*> repositories() { return iRepos; }
    QStringList installPackages() { return iInstallPackages; }

private:
    InstallFile(const InstallFile& old);
    InstallFile operator= (const InstallFile& old);

    QStringList TrimList(QStringList l);

    bool iIsValid;
    QString iErrorString;

    QStringList iInstallPackages;
    QList<Repository*> iRepos;

};

#endif // INSTALLFILE_H
