/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include "settings.h"
#include "ui_settings.h"
#include "mainwindow.h"
#include "aaptinterface.h"
#include "packageview.h"
#include "confirmdialog.h"
#include "searchoptions.h"

Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings)
{
    ui->setupUi(this);

	iAptInterface = 0;
	iQSettings = new QSettings("/root/.fapman/settings.ini",QSettings::IniFormat);
}

Settings::~Settings()
{
	iQSettings->sync();
	delete iQSettings;
    delete ui;
}

void Settings::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Settings::openWin()
{
	ui->checkBox_fetchdates->setChecked( iQSettings->value("fetch_dates", false).toBool() );
	ui->checkBox_autorotation->setChecked( iQSettings->value("disable_autorotation", false).toBool() );
	ui->checkBox_autoremove->setChecked( iQSettings->value("enable_autoremove", true).toBool() );
	ui->checkBox_autoclean->setChecked( iQSettings->value("enable_autoclean", true).toBool() );
	ui->checkBox_remove_readfull->setChecked( iQSettings->value("remove_readfull", false).toBool() );

	ui->checkBox_proxies->setChecked( iQSettings->value("use_proxies", false).toBool() );
	ui->lineEdit_http_proxy->setText( iQSettings->value("http_proxy","").toString() );
	ui->lineEdit_https_proxy->setText( iQSettings->value("https_proxy","").toString() );

	ui->comboBox_sortorder->setCurrentIndex( iQSettings->value("default_sort_order",0).toInt() );

	ui->checkBox_playsound->setChecked( iQSettings->value("sound_notify", false).toBool() );
	ui->lineEdit_soundfile->setText( iQSettings->value("sound_file","/usr/share/sounds/ui-operation_ready.wav").toString() );

	open();
}

void Settings::on_btn_OK_clicked()
{
	if( ui->checkBox_fetchdates->isChecked() != iQSettings->value("fetch_dates",false).toBool() && iAptInterface ) {
		iAptInterface->setNeedRefresh(-1,-1,-1,1);
	}
	if( ui->comboBox_sortorder->currentIndex() != iQSettings->value("default_sort_order",0).toInt() ) {
		iPackageView->setSortOrder( (PackageView::sortOrder)ui->comboBox_sortorder->currentIndex() );
	}

	iQSettings->setValue("fetch_dates", ui->checkBox_fetchdates->isChecked() );
	iQSettings->setValue("disable_autorotation", ui->checkBox_autorotation->isChecked() );
	iQSettings->setValue("enable_autoremove", ui->checkBox_autoremove->isChecked() );
	iQSettings->setValue("enable_autoclean", ui->checkBox_autoclean->isChecked() );
	iQSettings->setValue("remove_readfull", ui->checkBox_remove_readfull->isChecked() );

	iQSettings->setValue("use_proxies", ui->checkBox_proxies->isChecked() );
	iQSettings->setValue("http_proxy", ui->lineEdit_http_proxy->text() );
	iQSettings->setValue("https_proxy", ui->lineEdit_https_proxy->text() );

	iQSettings->setValue("default_sort_order", ui->comboBox_sortorder->currentIndex() );

	iQSettings->setValue("sound_notify", ui->checkBox_playsound->isChecked() );
	iQSettings->setValue("sound_file", ui->lineEdit_soundfile->text() );

	if( ui->comboBox_sortorder->currentIndex() == (int)PackageView::SortDateDesc && !ui->checkBox_fetchdates->isChecked() ) {
		iQSettings->setValue("fetch_dates", true );
		iAptInterface->setNeedRefresh(-1,-1,-1,1);

		ConfirmDialog d(false, this);
		d.setText("Notice","You have selected date as the default sorting criterion. Fetching dates has been automatically enabled.");
		d.exec();
	}

#ifdef Q_WS_MAEMO_5
	if( !iQSettings->value("disable_autorotation",false).toBool() ) {
		dynamic_cast<MainWindow*>(this->parent())->setAttribute(Qt::WA_Maemo5AutoOrientation);
	} else {
		dynamic_cast<MainWindow*>(this->parent())->setAttribute(Qt::WA_Maemo5LandscapeOrientation);
	}
#endif

	accept();
}

void Settings::on_pushButton_picksound_clicked()
{
	//QFileInfo i( ui->lineEdit_soundfile->text() );
	QString f = QFileDialog::getOpenFileName(this, "Select sound file", "/", "Audio (*.wav *.mp3 *.ogg)");
	if( !f.isNull() ) {
		ui->lineEdit_soundfile->setText(f);
	}
}

void Settings::on_pushButton_searchOptions_clicked()
{
	SearchOptions s(this);
	s.setSelections( iQSettings->value("search_pkgnames",false).toBool(),
					 iQSettings->value("search_displaynames",true).toBool(),
					 iQSettings->value("search_descshort",false).toBool(),
					 iQSettings->value("search_desclong",false).toBool() );
	if( s.exec() )
	{
		iQSettings->setValue("search_pkgnames", s.searchPkgName() );
		iQSettings->setValue("search_displaynames", s.searchDisplayName() );
		iQSettings->setValue("search_descshort", s.searchDescShort() );
		iQSettings->setValue("search_desclong", s.searchDescLong() );

		iPackageView->setSearchOptions(s.searchPkgName(), s.searchDisplayName(),
									   s.searchDescShort(), s.searchDescLong() );
	}
}
