/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef PACKAGE_H
#define PACKAGE_H

#include <QtCore>
#include "blacklistselect.h"

class AAptInterface;
class Repository;

class Package
{
public:
	enum operation { PkgOpNone, PkgOpInstallUpgrade, PkgOpRemove };

	// the order must match status filter strings
	enum packageStatus { PkgStatUnknown, PkgStatNotInstalled, PkgStatUpgradeable, PkgStatInstalled };

	Package(QByteArray name_, AAptInterface* apt_);
	~Package();
	void setName(QByteArray n_) { iName=n_; }
	void setMaemoDisplayName(QByteArray n_) { iMaemoDisplayName=n_; }
	void setInstalled(bool i_) { iIsInstalled=i_; }
	void setMarkedForOperation(operation op_);
	void setVersion(QByteArray v_) { iVersion=v_; }
	void setDescShort(QByteArray d_) { iDescriptionShort=d_; }
	void appendDescLong(QByteArray d_) { iDescriptionLong.append(d_); }
	void setSection(QByteArray s_) { iSection=s_; }
	void setSize(int i_) { iSize=i_; }
	void setInstalledSize(int i_) { iInstalledSize=i_; }
	void appendIconData(QByteArray d_) { iIconData.append(d_); }
	void addFullFileName(QString f_) { iFullFileNames.append(f_); }
	void updateStatus();
	void addRepository(Repository* r_) { iRepositories.append(r_); }
	void setDate(QDateTime d_) { iDate=d_; }
	void setBlacklisted(BlacklistSelect::blackList bl_) { iBlacklist=bl_; }
	void setDepends(QByteArray depends_);
	void setConflicts(QByteArray conflicts_);
	void appendUpgradeDescription(QByteArray d_) { iUpgradeDescription.append(d_); }

	void convertIcon();

	QString name() { return iName; }
	QString maemoDisplayName() { return QString::fromUtf8(iMaemoDisplayName); }
	QString displayName();
	bool isInstalled() { return iIsInstalled; }
	bool isMarkedForOperation() { return iMarkedForOperation; }
	operation markedOperation() { return iMarkedOperation; }
	QString version() { return iVersion; }
	QString descShort() { return QString::fromUtf8(iDescriptionShort); }
	QString descLong() { return QString::fromUtf8(iDescriptionLong); }
	QString section() { return iSection; }
	int size() { return iSize; }
	int installedSize() { return iInstalledSize; }
	QPixmap* icon() { return iIcon; }
	bool hasIconData();
	bool isUpgradeable();
	QString upgradeableVersion();
	Package* availablePackage();
	packageStatus status();
	QString fileName();
	QStringList fullFileNames() { return iFullFileNames; }
	QDateTime date() { return iDate; }
	QList<Repository*> repositories() { return iRepositories; }
	BlacklistSelect::blackList blacklisted() { return iBlacklist; }
	bool isBlacklisted() { if(iBlacklist==BlacklistSelect::BlacklistNone) return false; else return true; }
	QStringList depends();
	QStringList conflicts();
	QString upgradeDescription() { return QString::fromUtf8(iUpgradeDescription); }

	static bool versionCompare(QString isNewer, QString compare);

private:
	AAptInterface* iAptInterface;

	QByteArray iName;
	QByteArray iMaemoDisplayName;
	bool iIsInstalled;
	bool iMarkedForOperation;
	packageStatus iPkgStatus;
	QByteArray iVersion;
	QByteArray iDescriptionShort;
	QByteArray iDescriptionLong;
	QByteArray iSection;
	int iSize;
	int iInstalledSize;
	operation iMarkedOperation;
	QStringList iFullFileNames;
	QDateTime iDate;
	QList<Repository*> iRepositories;
	BlacklistSelect::blackList iBlacklist;
	QByteArray iUpgradeDescription;

	QByteArray iIconData;
	QPixmap* iIcon;

	QList<QByteArray> iDepends;
	QList<QByteArray> iConflicts;
};

#endif // PACKAGE_H
