/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtCore>
#include <QMainWindow>
#include "aaptinterface.h"

class PackageView;
class Uninstall;
class Dialog;
class dimmer;
class RepoView;
class Settings;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
	enum nextOperation { OpNone, OpPromptSimulated, OpOpenPkgView };

    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
	void operationQueueFinished(QList<AAptInterface::interfaceMode> lastModes, bool success, QString title, QStringList msgs);
	void busyDialog(bool show_, QString title="", QString text="");
	void closeEvent(QCloseEvent *event);
	void GdkEventIconThemeReload();
	void notifyDialog(QString title, QString msg);

public slots:
	void on_btnUpdate_clicked();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;
	AAptInterface* iAptInterface;
	PackageView* iWinPackageView;
	RepoView* iWinRepoView;
	Dialog* iDlgBusy;
	Settings* iSettings;
	//operation iOperation;
	dimmer* iDimmer;
	bool iReposAutoUpdating;
	bool iUpgradeAutoUpdate;
	nextOperation iNextOperation;

private slots:
	void on_actionOptions_triggered();
 void on_actionView_log_triggered();
	void on_btnRepos_clicked();
	void on_actionClean_triggered();
	void on_actionAbout_triggered();
	void on_btnUpgrade_clicked();
	void on_btnListInstallable_clicked();
	void on_btnListInstalled_clicked();
};

#endif // MAINWINDOW_H
