#include "sortselector.h"
#include "ui_sortselector.h"
#include "packageview.h"

SortSelector::SortSelector(PackageView::sortOrder currOrder, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SortSelector)
{
    ui->setupUi(this);

	if( currOrder == PackageView::SortAlpha )
		ui->radioButton_name->setChecked(true);
	else if( currOrder == PackageView::SortDateDesc )
		ui->radioButton_date->setChecked(true);
	else if( currOrder == PackageView::SortSizeDesc )
		ui->radioButton_size->setChecked(true);
}

SortSelector::~SortSelector()
{
    delete ui;
}

void SortSelector::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

PackageView::sortOrder SortSelector::selectedOperation()
{
	if( ui->radioButton_name->isChecked() )
		return PackageView::SortAlpha;
	else if( ui->radioButton_date->isChecked() )
		return PackageView::SortDateDesc;
	else if( ui->radioButton_size->isChecked() )
		return PackageView::SortSizeDesc;

	return PackageView::SortAlpha;
}
