/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef REPOVIEW_H
#define REPOVIEW_H

#include <QtGui>

class MainWindow;
class AAptInterface;

namespace Ui {
    class RepoView;
}

class RepoView : public QMainWindow
{
    Q_OBJECT

public:
    explicit RepoView(QWidget *parent = 0);
    ~RepoView();
	void setAptInterface(AAptInterface* a_) { iAptInterface = a_; }
	void openWin();
	void closeEvent(QCloseEvent *event);

#ifdef Q_WS_MAEMO_5		// workaround for buggy Qt autorotation
	void show() {
		if( !isVisible() ) {
			QRect r = dynamic_cast<QMainWindow*>(this->parent())->rect();
			if(r.width() < r.height())
				this->setAttribute(Qt::WA_Maemo5PortraitOrientation);
			else {
				if( dynamic_cast<QMainWindow*>(this->parent())->testAttribute( Qt::WA_Maemo5AutoOrientation ) )
					this->setAttribute( Qt::WA_Maemo5AutoOrientation );
				else
					this->setAttribute( Qt::WA_Maemo5LandscapeOrientation );
			}
			this->setAttribute(Qt::WA_Maemo5StackedWindow);
			this->setWindowFlags(Qt::Window);
		}
		QMainWindow::show();
	}
#endif


protected:
    void changeEvent(QEvent *e);

private:
    Ui::RepoView *ui;
	bool iModified;

	MainWindow* iMainWindow;
	AAptInterface* iAptInterface;

private slots:
	void on_listWidget_itemClicked(QListWidgetItem* item);
	void on_btnNew_clicked();
};

#endif // REPOVIEW_H
