#include "packageselector.h"
#include "ui_packageselector.h"
#include "package.h"
#include "packageview.h"

PackageSelector::PackageSelector(Package* pkg, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::PackageSelector)
{
    ui->setupUi(this);

	if( pkg->icon()->isNull() ) {
		ui->label_appicon->setPixmap( QPixmap(":/icons/icons/appdefault.png") );
	} else {
		ui->label_appicon->setPixmap( *pkg->icon() );
	}
	this->setWindowTitle( pkg->name() );

	if( pkg->maemoDisplayName() != "" )
		ui->label_header->setText("<b>" + pkg->maemoDisplayName() + "</b>");
	else
		ui->label_header->setText("<b>" + pkg->name() + "</b>");

	QString longtext;

	longtext += "Category: " + pkg->section() + "<br>";
	if( pkg->isInstalled() ) {
		longtext += "Package is installed, version <b>" + pkg->versionInstalled() + "</b>";
		if( pkg->installedSize() > 0 )
			longtext += QString(" (%0 kB)").arg(pkg->installedSize()/1024 );
	} else {
		longtext += "Package is not installed";
	}
	longtext += "<br>";
	if( !pkg->isInstalled() || pkg->isUpgradeable() ){
		longtext += "Available version <b>" + pkg->versionAvailable() + "</b>";
		if( pkg->size() > 0 )
			longtext += QString(" (%0 kB)").arg(pkg->size()/1024 );
		longtext += "<br>";
	}
	if( pkg->markedOperation() == Package::PkgOpInstallUpgrade )
	{
		if( pkg->isUpgradeable() )
			longtext += "Package has been marked for <b>upgrade</b><br>";
		else
			longtext += "Package has been marked for <b>installation</b><br>";
	} else if(pkg->markedOperation() == Package::PkgOpRemove)
	{
		longtext += "Package has been marked for <b>removal</b><br>";
	}

	longtext += "<br>";
	if( pkg->descLong()!="" ) longtext+="<u>";
	longtext += pkg->descShort();
	if( pkg->descLong()!="" ) longtext+="</u>";
	longtext += "<br>" + pkg->descLong();

	ui->label_text->setText( longtext );

	if( pkg->isUpgradeable() )
		ui->radioInstall->setText("Upgrade");
	else
		ui->radioInstall->setText("Install");

	if( pkg->markedOperation() == Package::PkgOpNone )
	{
		if( pkg->isInstalled() && pkg->isUpgradeable() )
			ui->label_statusicon->setPixmap(QPixmap(":/icons/icons/pkg_nop_instupgr.png"));
		else if( pkg->isInstalled() )
			ui->label_statusicon->setPixmap(QPixmap(":/icons/icons/pkg_nop_installed.png"));
		else if( !pkg->isInstalled() )
			ui->label_statusicon->setPixmap(QPixmap(":/icons/icons/pkg_nop_notinstalled.png"));

		ui->radioNothing->setChecked(true);
	} else if( pkg->markedOperation() == Package::PkgOpInstallUpgrade ) {
		if( pkg->isUpgradeable() )
			ui->label_statusicon->setPixmap(QPixmap(":/icons/icons/pkg_upgrade.png"));
		else
			ui->label_statusicon->setPixmap(QPixmap(":/icons/icons/pkg_install.png"));
		ui->radioInstall->setChecked(true);
	} else if( pkg->markedOperation() == Package::PkgOpRemove ) {
		ui->label_statusicon->setPixmap(QPixmap(":/icons/icons/pkg_remove.png"));
		ui->radioRemove->setChecked(true);
	}

	if( pkg->isInstalled() && !pkg->isUpgradeable() )
	{
		ui->radioInstall->setEnabled(false);
		ui->radioInstall->hide();
	}
	if( !pkg->isInstalled() ) {
		ui->radioRemove->setEnabled(false);
		ui->radioRemove->hide();
	}

	//this->adjustSize();
}

PackageSelector::~PackageSelector()
{
    delete ui;
}

void PackageSelector::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

Package::operation PackageSelector::selectedOperation()
{
	if( ui->radioInstall->isChecked() )
		return Package::PkgOpInstallUpgrade;
	if( ui->radioRemove->isChecked() )
		return Package::PkgOpRemove;

	return Package::PkgOpNone;
}
