#ifndef REPOVIEW_H
#define REPOVIEW_H

#include <QMainWindow>

class MainWindow;
class AptInterface;

namespace Ui {
    class RepoView;
}

class RepoView : public QMainWindow
{
    Q_OBJECT

public:
    explicit RepoView(QWidget *parent = 0);
    ~RepoView();
	void setAptInterface(AptInterface* a_) { iAptInterface = a_; }
	void openWin();
	void closeEvent(QCloseEvent *event);

#ifdef Q_WS_MAEMO_5		// workaround for buggy Qt autorotation
	void show() {
		QRect r = static_cast<QMainWindow*>(this->parent())->rect();
		if(r.width() < r.height())
			this->setAttribute(Qt::WA_Maemo5PortraitOrientation);
		else
			this->setAttribute(Qt::WA_Maemo5AutoOrientation);
		QMainWindow::show();
	}
#endif


protected:
    void changeEvent(QEvent *e);

private:
    Ui::RepoView *ui;

	MainWindow* iMainWindow;
	AptInterface* iAptInterface;

	bool iModified;

private slots:
	void on_btnSave_clicked();
};

#endif // REPOVIEW_H
