#include <QtCore/QCoreApplication>
#include <QStringList>
#include <QX11Info>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xmu/CurUtil.h>
char *fore_color = NULL;
char *back_color = NULL;

/*
 * NameToXColor: Convert the name of a color to its Xcolor value.
 */
static XColor
NameToXColor(char *name, unsigned long pixel,Display * dpy,int screen)
{
    XColor c;

    if (!name || !*name) {
	c.pixel = pixel;
	XQueryColor(dpy, DefaultColormap(dpy, screen), &c);
    } else if (!XParseColor(dpy, DefaultColormap(dpy, screen), name, &c)) {

	/*QMessageBox::warning(0, QCoreApplication::applicationName(),
		  QObject::tr("Unknown color or bad color format: ").append(name));*/
    }
    return(c);
}

static
Cursor CreateCursorFromName(const char *name,Display * dpy,int screen)
{
    XColor fg, bg;
    int	    i;
    Font    fid;

    fg = NameToXColor(fore_color, BlackPixel(dpy, screen),dpy, screen);
    bg = NameToXColor(back_color, WhitePixel(dpy, screen),dpy, screen);

    i = XmuCursorNameToIndex (name);
    if (i == -1)
	return (Cursor) 0;
    fid = XLoadFont (dpy, "cursor");
    if (!fid)
	return (Cursor) 0;
    return XCreateGlyphCursor (dpy, fid, fid,
			       i, i+1, &fg, &bg);
}

void show_cursor_screen(Display * dpy,Window root,Cursor cursor)
{
    Window dummy, *children = NULL;
    unsigned int i, nchildren = 0;
    /*
	 * then, get the list of windows
	 */
	if (!XQueryTree (dpy, root, &dummy, &dummy, &children, &nchildren)) {
	    return;
	}

	for (i = 0; i < nchildren; i++)
	{
	    XDefineCursor (dpy, children[i], cursor);
	    show_cursor_screen(dpy, children[i], cursor);
	}
	XFree(children);
}

void hide_cursor_screen(Display * dpy,Window root)
{
    Window dummy, *children = NULL;
    unsigned int i, nchildren = 0;
    /*
	 * then, get the list of windows
	 */
	if (!XQueryTree (dpy, root, &dummy, &dummy, &children, &nchildren)) {
	    return;
	}

	for (i = 0; i < nchildren; i++)
	{
	    XUndefineCursor (dpy, children[i]);
	    hide_cursor_screen(dpy, children[i]);
	}
	XFree(children);
}

void hide_cursor()
{
    Display * dpy=XOpenDisplay(NULL);

    int i;

    for (i = 0; i < ScreenCount(dpy); i++)
    {
	XUndefineCursor (dpy, RootWindow(dpy,i));
	hide_cursor_screen(dpy, RootWindow(dpy,i));
    }

}
void show_cursor()
{
    Cursor cursor;
    Display * dpy=XOpenDisplay(NULL);
    int i;

    cursor = CreateCursorFromName ("left_ptr",dpy, DefaultScreen(dpy));
    if (cursor)
    {
	for (i = 0; i < ScreenCount(dpy); i++)
	{
	    XDefineCursor (dpy, RootWindow(dpy,i), cursor);
	    show_cursor_screen(dpy, RootWindow(dpy,i),cursor);
	}

	XFreeCursor (dpy, cursor);
    }

}

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);

    QStringList args = a.arguments();
    for (int i = 1; i < args.count(); i++) {
	QString s = args[i];

	if (s == QLatin1String("--show"))
	{
	    show_cursor();
	    break;
	}
	if (s == QLatin1String("--hide"))
	{
	    hide_cursor();
	    break;
	}
    }

    return 0;
}
