#include <QDBusInterface>
#include <QDBusObjectPath>
#include <QList>
#include <QDebug>
#include <QMaemo5InformationBox>

#define UUID_HID "00001124-0000-1000-8000-00805f9b34fb"
#include "qbtkeyboards.h"
bool addDevices(QBTKeyboards* _this,const QDBusReply< QMap<QString,QVariant> > & properties);

QBTKeyboards::QBTKeyboards(QWidget *parent):m_parent(parent)
{
    enumerateHIDDeviceProperties(addDevices);
}
bool addDevices(QBTKeyboards* _this,const QDBusReply< QMap<QString,QVariant> > & properties)
{
    _this->insert(
	    properties.value().value("Name").toString(),
	    properties.value()
	    );
    return true;
}

bool reconnectDevices(QBTKeyboards* _this,const QDBusReply< QMap<QString,QVariant> > & properties)
{
    if(properties.value().value("Paired").toBool())
    {
	QString deviceName=properties.value().value("Name").toString();
	QString deviceMAC=properties.value().value("Address").toString().replace(":","_");
	QDBusObjectPath hidDevicePath=properties.value().value("Adapter").value<QDBusObjectPath>();
	QString device = QString("%1/dev_%2").arg(hidDevicePath.path()).arg(deviceMAC);
	qDebug() << device;
	QDBusError error;
	QDBusInterface bt_input(   "org.bluez",device,
				    "org.bluez.Input",
				    QDBusConnection::systemBus());

	if(properties.value().value("Connected").toBool())
	{
	    QMaemo5InformationBox::information(_this->parent(), _this->parent()->tr("Disconnecting %1...").arg(deviceName));
	    bt_input.call(QDBus::BlockWithGui,"Disconnect");
	    error = bt_input.lastError();
	    if(error.isValid())
		QMaemo5InformationBox::information(_this->parent(),
						   _this->parent()->tr("An error occured while disconnecting %1<br><b>%2</b>").
						   arg(deviceName).arg(error.message()));
	}
	else
	{
	    if(_this->reconnectConnectedOnly())
		return true;
	}
	QMaemo5InformationBox::information(_this->parent(), _this->parent()->tr("Connecting %1...").arg(deviceName));

	error = bt_input.call(QDBus::BlockWithGui,"Connect");

	if(error.isValid())
	    QMaemo5InformationBox::information(_this->parent(),
					       _this->parent()->tr("An error occured while connecting %1<br><b>%2</b>").
					       arg(deviceName).arg(error.message()),
					       QMaemo5InformationBox::NoTimeout);


    }
    return true;
}

void QBTKeyboards::reconnect(bool connectedOnly)
{
    m_reconnectConnectedOnly=connectedOnly;
    enumerateHIDDeviceProperties(reconnectDevices);
}

bool QBTKeyboards::enumerateHIDDeviceProperties(bool (*enumFunc)(QBTKeyboards* _this,const QDBusReply< QMap<QString,QVariant> > & properties))
{
    QDBusInterface bt_manager(  "org.bluez", "/",
				"org.bluez.Manager",
				QDBusConnection::systemBus());

    QDBusReply<QDBusObjectPath> adapter=bt_manager.call("DefaultAdapter");

    if(!adapter.isValid())
    {
	QMaemo5InformationBox::information(m_parent, adapter.error().message(),
						QMaemo5InformationBox::NoTimeout);
	return false;
    }


    QDBusInterface bt_adapter(  "org.bluez", adapter.value().path(),
				"org.bluez.Adapter",
				QDBusConnection::systemBus());

    QDBusReply< QList<QDBusObjectPath> > device=bt_adapter.call("ListDevices");


    if ( device.isValid() )
    {
	for(int i=0;i<device.value().count();i++)
	{
	    //qDebug() << device.value().value(i).path();

	    QDBusInterface bt_device(  "org.bluez", device.value().value(i).path(),
					"org.bluez.Device",
					QDBusConnection::systemBus());
	    QDBusReply< QMap<QString,QVariant> > properties=bt_device.call("GetProperties");

	    if ( !properties.isValid() )
	    {
		QMaemo5InformationBox::information(m_parent, properties.error().message(),
						   QMaemo5InformationBox::NoTimeout);
		return false;
	    }
	    else
	    {
		if(properties.value().value("UUIDs").toStringList().contains(UUID_HID))
		{
		    if(true != enumFunc(this,properties))
			break;

		}
	    }
	}
    }
    else
	QMaemo5InformationBox::information(m_parent, device.error().message(),
						QMaemo5InformationBox::NoTimeout);
    return true;
}
