#include "halkeyboards.h"

#include <QTextStream>
#include <QStringList>
#include <QDebug>

#include <stdio.h>

HalKeyboards::HalKeyboards()
{
    FILE * fp=popen("hal-find-by-capability --capability input.keyboard","r");

    QString udi;
    QTextStream udi_stream( fp, QIODevice::ReadOnly );

    while(!(udi = udi_stream.readLine()).isNull())
    {
        FILE * fpudi=popen(QString("hal-get-property --udi %1 --key info.product").arg(udi).toLatin1(),"r");
        QTextStream kbd_udi_list( fpudi, QIODevice::ReadOnly );

        QString udi_info_product=kbd_udi_list.readLine();

        //qDebug()<<udi_info_product;

        if(     (!udi_info_product.isNull())
                &&
                (udi_info_product != "omap_twl4030keypad") //do not include internal keyboard
                )
        {
            insert(udi_info_product,udi);
        }

        fclose(fpudi);
    }

    fclose(fp);

}
