#include <QDBusInterface>
#include <QDBusReply>
#include <QDBusObjectPath>
#include <QList>
#include <QDebug>
#include <QMaemo5InformationBox>

#define UUID_HID "00001124-0000-1000-8000-00805f9b34fb"
#include "qbtkeyboards.h"

QBTKeyboards::QBTKeyboards(QWidget *parent)
{
    QDBusInterface bt_manager(  "org.bluez", "/",
                                "org.bluez.Manager",
                                QDBusConnection::systemBus());

    QDBusReply<QDBusObjectPath> adapter=bt_manager.call("DefaultAdapter");

    if(!adapter.isValid())
    {
        QMaemo5InformationBox::information(parent, adapter.error().message(),
                                                QMaemo5InformationBox::NoTimeout);
        return;
    }


    QDBusInterface bt_adapter(  "org.bluez", adapter.value().path(),
                                "org.bluez.Adapter",
                                QDBusConnection::systemBus());

    QDBusReply< QList<QDBusObjectPath> > device=bt_adapter.call("ListDevices");


    if ( device.isValid() )
    {
        for(int i=0;i<device.value().count();i++)
        {
            //qDebug() << device.value().value(i).path();

            QDBusInterface bt_device(  "org.bluez", device.value().value(i).path(),
                                        "org.bluez.Device",
                                        QDBusConnection::systemBus());
            QDBusReply< QMap<QString,QVariant> > properties=bt_device.call("GetProperties");

            if ( !properties.isValid() )
            {
                QMaemo5InformationBox::information(parent, properties.error().message(),
                                                   QMaemo5InformationBox::NoTimeout);
                return;
            }
            else
            {
                if(properties.value().value("UUIDs").toStringList().contains(UUID_HID))
                {
                    this->insert(
                            properties.value().value("Name").toString(),
                            properties.value()
                            );

                }
            }
        }
    }
    else
        QMaemo5InformationBox::information(parent, device.error().message(),
                                                QMaemo5InformationBox::NoTimeout);
}
