/*-*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *    Copyright (C) 2009 Luca Vaudano vaudano@gmail.com
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.Warning
 */
 /**
  * @file main.c
  * @author Luca Vaudano
  */
#include "estardict-gui.h"
#include "estardict-gui-logic.h"
#include "estardict-gui-utils.h"


/**
 * @brief Destroy the main window
 *
 * @param data
 * @param obj
 * @param event_info
 */
static void destroyWin(void *data, Evas_Object *obj, void *event_info) {
    destroy();
}


/**
 * @brief Main function
 *
 * @param argc
 * @param argv
 */
EAPI int elm_main(int argc, char **argv) {
    Evas_Object *win;

    // Set log level based on the command line parameter
    setLogLevel(argc, argv);
    g_debug("-> %s %s()", __FILE__, __FUNCTION__);

    // Init locale
    init_locale();

    // Create main window and destroy callback
    win = createMainWindow();
    evas_object_smart_callback_add(win, "delete,request", destroyWin, NULL);

    // Show main window
    evas_object_show(win);

    // Initialize application
    init();
    
    // TODO
    // For N900
    elm_finger_size_set(60);	

    elm_run();
    elm_shutdown();

    g_message(i18n("Bye bye"));
    return 0;
}
ELM_MAIN()
