/*-*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *    Copyright (C) 2009 Luca Vaudano vaudano@gmail.com
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.Warning
 */
 /**
  * @file estardict-gui-settingsPage.c
  * @author Luca Vaudano
  */
#include "estardict-gui-settingsPage.h"
#include "estardict-gui-logic.h"
#include "estardict-gui.h"
#include "i18n.h"
#include "estardict-config.h"


Evas_Object *playerEntry, *soundDictionaryEntry;


/**
 * @brief Create sound dictionary frame
 *
 * @param name Frame name
 */
Evas_Object* createSoundDictionaryFrame() {
    g_debug("-> %s %s()", __FILE__, __FUNCTION__);
    Evas_Object *frame, *bx, *entryBx, *ic, *bt;
    gchar buf[PATH_MAX];

    frame = elm_frame_add(win);
    elm_object_text_set(frame, SOUND_DICTIONARY_FRAME_LABEL);
    evas_object_size_hint_align_set(frame, EVAS_HINT_FILL, 0);
    evas_object_show(frame);

    // Box for dictionary section
    bx = elm_box_add(win);
    elm_box_horizontal_set(bx, EINA_FALSE);
    evas_object_size_hint_weight_set(bx, EVAS_HINT_EXPAND, 0);
    evas_object_show(bx);

    // Box object with 'New player' and 'PlayerPathEntry'
    entryBx = elm_box_add(win);
    elm_box_horizontal_set(entryBx, EINA_TRUE);
    evas_object_size_hint_weight_set(entryBx, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    evas_object_show(entryBx);

    // New sound dictionary button
    ic = elm_icon_add(win);
    snprintf(buf, sizeof(buf), FOLDER_ICON, ROOT_DIR);
    elm_icon_file_set(ic, buf, NULL);
    evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
    bt = elm_button_add(win);
    elm_object_part_content_set(bt, "icon", ic);
    evas_object_size_hint_weight_set(bt, 0, EVAS_HINT_EXPAND);
    evas_object_size_hint_align_set(bt, EVAS_HINT_FILL, EVAS_HINT_FILL);
    evas_object_show(bt);
    evas_object_show(ic);

    // Sound dictionary entry path
    soundDictionaryEntry = elm_entry_add(win);
    elm_entry_line_wrap_set(soundDictionaryEntry, EINA_FALSE);
    elm_entry_entry_set(soundDictionaryEntry, "");
    elm_entry_single_line_set(soundDictionaryEntry, EINA_TRUE);
    elm_object_scale_set(soundDictionaryEntry, 1.25);
    elm_entry_editable_set(soundDictionaryEntry, EINA_FALSE);
    evas_object_size_hint_align_set(soundDictionaryEntry, EVAS_HINT_FILL, EVAS_HINT_FILL);
    evas_object_show(soundDictionaryEntry);

    evas_object_smart_callback_add(bt, "clicked", addSoundDictionary, NULL);

    elm_box_pack_end(entryBx, bt);
    elm_box_pack_end(entryBx, soundDictionaryEntry);
    elm_box_pack_end(bx, entryBx);

    elm_object_content_set(frame, bx);
    return frame;
}


/**
 * @brief Create sound dictionary frame
 */
Evas_Object* createPlayerFrame() {
    g_debug("-> %s %s()", __FILE__, __FUNCTION__);
    Evas_Object *frame, *bx, *entryBx, *ic, *bt;
    gchar buf[PATH_MAX];

    frame = elm_frame_add(win);
    elm_object_text_set(frame, PLAYER_FRAME_LABEL);
    evas_object_size_hint_align_set(frame, EVAS_HINT_FILL, 0);
    evas_object_show(frame);

    // Box for dictionary section
    bx = elm_box_add(win);
    elm_box_horizontal_set(bx, EINA_FALSE);
    evas_object_size_hint_weight_set(bx, EVAS_HINT_EXPAND, 0);
    evas_object_show(bx);

    // Box object with 'New player' and 'PlayerPathEntry'
    entryBx = elm_box_add(win);
    elm_box_horizontal_set(entryBx, EINA_TRUE);
    evas_object_size_hint_weight_set(entryBx, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    evas_object_show(entryBx);

    // New player button
    ic = elm_icon_add(win);
    snprintf(buf, sizeof(buf), FOLDER_ICON, ROOT_DIR);
    elm_icon_file_set(ic, buf, NULL);
    evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
    bt = elm_button_add(win);
    elm_object_part_content_set(bt, "icon", ic);
    evas_object_size_hint_weight_set(bt, 0, EVAS_HINT_EXPAND);
    evas_object_size_hint_align_set(bt, EVAS_HINT_FILL, EVAS_HINT_FILL);
    evas_object_show(bt);
    evas_object_show(ic);

    // Player path entry
    playerEntry = elm_entry_add(win);
    elm_entry_line_wrap_set(playerEntry, EINA_FALSE);
    elm_entry_entry_set(playerEntry, "");
    elm_entry_single_line_set(playerEntry, EINA_TRUE);
    elm_object_scale_set(playerEntry, 1.25);
    elm_entry_editable_set(playerEntry, EINA_FALSE);
    evas_object_size_hint_align_set(playerEntry, EVAS_HINT_FILL, EVAS_HINT_FILL);
    evas_object_show(playerEntry);

    evas_object_smart_callback_add(bt, "clicked", addPlayer, NULL);

    elm_box_pack_end(entryBx, bt);
    elm_box_pack_end(entryBx, playerEntry);
    elm_box_pack_end(bx, entryBx);

    elm_object_content_set(frame, bx);
    return frame;
}


/**
 * @brief Create suggested words frame
 */
Evas_Object* createSuggestedWordFrame() {
    g_debug("-> %s %s()", __FILE__, __FUNCTION__);
    Evas_Object *frame, *tg;

    frame = elm_frame_add(win);
    elm_object_text_set(frame, SUGGESTED_WORD_FRAME_LABEL);
    evas_object_size_hint_align_set(frame, EVAS_HINT_FILL, 0);
    evas_object_show(frame);

    tg = elm_check_add(win);
    elm_object_style_set(tg, "toggle");
    elm_object_part_text_set(tg, "on", YES);
    elm_object_part_text_set(tg, "off", NO);
    elm_object_text_set(tg, SHOW_SUGGESTED_WORD);
    gboolean result = getSuggestedWordShow();
    elm_check_state_set(tg, result);
    evas_object_show(tg);

    evas_object_smart_callback_add(tg, "changed", suggestedWordToggleChanged, NULL);

    elm_object_content_set(frame, tg);
    return frame;
}


/**
 * @brief Create settings page, if needed
 */
void createSettingsPage() {
    g_debug("-> %s %s()", __FILE__, __FUNCTION__);
    Evas_Object *sc, *ic, *bx, *bt, *frame;
    char buf[PATH_MAX];

    // Box Window with scroller and quit button
    settingsBox = elm_box_add(win);
    elm_box_horizontal_set(settingsBox, EINA_FALSE);
    evas_object_size_hint_weight_set(settingsBox, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    evas_object_size_hint_align_set(settingsBox, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_win_resize_object_add(win, settingsBox);
    evas_object_show(settingsBox);

    // Scroller
    sc = elm_scroller_add(win);
    evas_object_size_hint_weight_set(sc, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    evas_object_size_hint_align_set(sc, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_scroller_bounce_set(sc, EINA_FALSE, EINA_FALSE);
    elm_box_pack_end(settingsBox, sc);
    evas_object_show(sc);

    // About button
    ic = elm_icon_add(win);
    snprintf(buf, sizeof(buf), INFO_ICON, ROOT_DIR);
    elm_icon_file_set(ic, buf, NULL);
    evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
    bt = elm_button_add(win);
    elm_object_part_content_set(bt, "icon", ic);
    elm_object_text_set(bt, ABOUT_BUTTON_LABEL);
    evas_object_size_hint_align_set(bt, EVAS_HINT_FILL, 0);
    elm_box_pack_end(settingsBox, bt);
    evas_object_show(bt);
    evas_object_show(ic);
    evas_object_smart_callback_add(bt, "clicked", promoteAboutPage, NULL);

    // Quit button
    ic = elm_icon_add(win);
    snprintf(buf, sizeof(buf), QUIT_ICON, ROOT_DIR);
    elm_icon_file_set(ic, buf, NULL);
    evas_object_size_hint_aspect_set(ic, EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);
    bt = elm_button_add(win);
    elm_object_part_content_set(bt, "icon", ic);
    elm_object_text_set(bt, QUIT_BUTTON_LABEL);
    evas_object_size_hint_align_set(bt, EVAS_HINT_FILL, 0);
    elm_box_pack_end(settingsBox, bt);
    evas_object_show(bt);
    evas_object_show(ic);
    evas_object_smart_callback_add(bt, "clicked", promoteDefinitionPage, NULL);

    // Box inside scroller
    bx = elm_box_add(win);
    elm_box_horizontal_set(bx, EINA_FALSE);
    evas_object_size_hint_weight_set(bx, EVAS_HINT_EXPAND, -1);
    elm_object_content_set(sc, bx);
    evas_object_show(bx);

    // Frame for sound dictionary section
    frame = createSoundDictionaryFrame();
    elm_box_pack_end(bx, frame);

    // Frame for player section
    frame = createPlayerFrame();
    elm_box_pack_end(bx, frame);

    // Frame for suggested words section
    frame = createSuggestedWordFrame();
    elm_box_pack_end(bx, frame);
}


/**
 * @brief Set the player entry with the given selected file
 *
 * @param selected Selected file
 */
void setPlayerEntry(gchar *selected) {
    g_debug("-> %s %s()", __FILE__, __FUNCTION__);
    elm_entry_entry_set(playerEntry, selected);
}


/**
 * @brief Set the sound dictionary entry with the given selected file
 *
 * @param selected Selected file
 */
void setSoundDictionaryEntry(gchar *selected) {
    g_debug("-> %s %s()", __FILE__, __FUNCTION__);
    elm_entry_entry_set(soundDictionaryEntry, selected);
}

