#!/usr/bin/python

"""

signal sender=:1.12 -> dest=(null destination) serial=1208 path=/org/freedesktop/Hal/devices/computer_logicaldev_input; interface=org.freedesktop.Hal.Device; member=Condition
   string "ButtonPressed"
      string "power"

signal sender=:1.11 -> dest=(null destination) serial=750 path=/com/nokia/mce/signal; interface=com.nokia.mce.signal; member=display_status_ind
   string "on"

signal sender=:1.11 -> dest=(null destination) serial=731 path=/com/nokia/mce/signal; interface=com.nokia.mce.signal; member=tklock_mode_ind
   string "locked"
"""

# mce/dbus-names.h
MCE_SERVICE		= "com.nokia.mce"
MCE_REQUEST_IF		= "com.nokia.mce.request"
MCE_SIGNAL_IF		= "com.nokia.mce.signal"
MCE_REQUEST_PATH	= "/com/nokia/mce/request"
MCE_SIGNAL_PATH		= "/com/nokia/mce/signal"
MCE_TKLOCK_MODE_SIG	= "tklock_mode_ind"
MCE_DISPLAY_SIG		= "display_status_ind"

import gobject
import dbus
import dbus.mainloop.glib
import time
import os

class SpeakTimeController(object):
	def __init__(self):
		bus = dbus.SystemBus()
		mce_req = dbus.Interface(
			bus.get_object(MCE_SERVICE, MCE_REQUEST_PATH),
			dbus_interface=MCE_REQUEST_IF)
		mce = dbus.Interface(
			bus.get_object(MCE_SERVICE, MCE_SIGNAL_PATH),
			dbus_interface=MCE_SIGNAL_IF)
		hal = dbus.Interface(
			bus.get_object("org.freedesktop.Hal", "/org/freedesktop/Hal/devices/computer_logicaldev_input"),
			dbus_interface="org.freedesktop.Hal.Device")

		self.sig_display_status(mce_req.get_display_status())
		self.sig_tklock_mode(mce_req.get_tklock_mode())

		mce.connect_to_signal(MCE_DISPLAY_SIG, self.sig_display_status)
		mce.connect_to_signal(MCE_TKLOCK_MODE_SIG, self.sig_tklock_mode)
		hal.connect_to_signal("Condition", self.sig_condition)



	def sig_display_status(self, status):
		print "display status [%s]" % status
		self.display_status = status

	def sig_tklock_mode(self, mode):
		print "lock mode [%s]" % mode
		self.tklock_mode = mode

	def sig_condition(self, name, *args):
		print "condition: name=[%s] args=[%r]" % (name, args)
		if name == 'ButtonPressed' and args[0] == 'power':
			print "power button"
			if self.display_status == "on" and self.tklock_mode == "locked":
				s = time.strftime("%H:%M")
				print "speak: [%s]" % s
				print os.system("espeak \"%s\"" % s)


def main():
	dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
	
	ctrl = SpeakTimeController()

	print "loop"
	mainloop = gobject.MainLoop()
	mainloop.run()

main()
