#!/usr/bin/env python
# Added: (0.6) Autostart espeakcaller-daemon on boot
# Thanks to fred123 @ http://talk.maemo.org/showthread.php?t=34982&page=8
# for pointing me to right direction :)
# 
import subprocess
import sys
import shlex
import os
import os.path
import codecs

daemonFile = '/opt/espeakcaller/espeakcaller-daemon.py'
pidFile = '/tmp/espeakcaller_pid.txt'
cfgFileLoc = "~/.espeakcaller/"
cfgGeneral = "espeakcaller_general.conf"
cfgUnknown = "espeakcaller_unknown.conf"
cfgBlocked = "espeakcaller_blocked.conf"

def CreateSettings(cfgTmp,text):
    pdFile = codecs.open(cfgTmp, 'w+','utf-8')
    pdFile.write("eSpeak:/usr/bin/espeak -m -a 100 -p 50 -s 170 '%text%'\n") 
    pdFile.write("Enabled:1" + '\n')    
    pdFile.write("Say:" + text + "\n")
    pdFile.write("Lang:0\n")
    pdFile.write("Vol:100\n")
    pdFile.write("Pitch:50\n")
    pdFile.write("Speed:170\n")
    pdFile.write("Nick:1\n")
    pdFile.write("RepeatCount:5\n")
    pdFile.write("Repeattime:7\n")
    pdFile.write("SaySilent:0\n")
    pdFile.write("Headphones:1\n")
    pdFile.write("Aparams:\n")
    pdFile.close()
    

try:
    # If espeakdaemon is running then stop it.
    # this is used when updating to newer version
    if os.path.exists(pidFile): 
        pdFile = open(pidFile, 'r+')
        pid = pdFile.readline().strip()
        subprocess.Popen("kill -9 " + str(pid), shell=True)
        pdFile.close()
        os.remove(pidFile)
        
    # Check if default config files exist. If not then create them.          
    if not os.path.exists(os.path.expanduser(cfgFileLoc)):
        os.makedirs(os.path.expanduser(cfgFileLoc))
    cfgTmp = os.path.expanduser(cfgFileLoc + cfgGeneral)
    if not os.path.exists(cfgTmp):
         CreateSettings(cfgTmp, "%nick% %first% %last% calls.")
    cfgTmp = os.path.expanduser(cfgFileLoc + cfgUnknown)
    if not os.path.exists(cfgTmp):
         CreateSettings(cfgTmp, "Call from number %number%.")         
    cfgTmp = os.path.expanduser(cfgFileLoc + cfgBlocked)
    if not os.path.exists(cfgTmp):
         CreateSettings(cfgTmp, "Call from private number.")   
                
except:
    pass
        
command = shlex.split("python " + daemonFile)
proc = subprocess.Popen(command, shell=False)

pdFile = open(pidFile, 'w+')
pdFile.write(str(proc.pid))
pdFile.close()
