#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import time
import gobject, dbus
from dbus.mainloop.glib import DBusGMainLoop
import sys
import evolution
import os.path
#import threading
import subprocess
import shlex
#import signal

cfgFile = "~/.espeakcaller/espeakcaller_daemon.conf"
myCommand = "espeak '%text%'"
sayName = "%name% is calling."
unkNum = "Call from Unknown number"
blNum = "Call from Blocked number"
useNickname = 0
eSpeakProc = 0
repeatTime = 5
#stopEvent = threading.Event()
eSpeakCommand = ""

def get_name_from_number(number):
    #  Taken from fMMS (modified)
    #  Should get caller name from phonebook
    #  I wonder if there is better/faster/less dirty way to do this...
    #
    # Fixed (0.3): "eSpeakCaller says the number even if the name is defined"-bug :)
    #              (number is in international format)
    # Thanks to Thnninen @ http://talk.maemo.org/showthread.php?t=34982&page=4
    #
    # Fixed: (0.4): "eSpeakCaller still has no clue about callername"-bug
    #              (number contains spaces)
    #
    # Fixed: (0.5): "eSpeakCaller doesn't understand callernumber with brackets()"-bug
    #
    
    if (len(number) == 0) :
        return "%blocked%"


   
    ab = evolution.ebook.open_addressbook("default")
    contacts = ab.get_all_contacts()
    for c in contacts:
        vcardlist = c.get_vcard_string().replace('\r', '').split('\n')
        fname = ""
        tmpNick = ""
        tmpFName = ""
        tmpLName = ""
        nr = ""
        my_num = ""
        c_num = ""
        
        for line in vcardlist:    
            if line.startswith("TEL"):
                nr = line.split(":")[1]
                             
                my_num = number.lstrip('0')      # Remove leading zero
                my_num = my_num.replace(' ', '') # Remove spaces 
                my_num = my_num.replace('(', '') # Remove brackets '()'
                my_num = my_num.replace(')', '')
                                
                c_num = nr.lstrip('0')
                c_num = c_num.replace(' ', '')
                c_num = c_num.replace('(', '') 
                c_num = c_num.replace(')', '')
                
                if c_num.endswith(my_num) or my_num.endswith(c_num):
                    fname = c.get_name()
                    print "Phonebook vcard: " + "\n".join(vcardlist)
                    print "Found name: " + fname
                    print "Incoming number: " + number
                    print "Stripped incoming number: " + my_num
                    print "Stripped phonebook number: " + c_num
                #end if
            #end if
            if line.startswith("NICKNAME"):
                tmpNick = line.split(":")[1]
            if line.startswith("N:"):
                tmpStr = line.split(":")[1]
                tmpFName = tmpStr.split(";")[1]
                tmpLName = tmpStr.split(";")[0]
            #end if
        #next
        
        if fname != "": 
            print "First name: " + tmpFName
            print "Last name: " + tmpLName
           
            return [fname, tmpFName, tmpLName, tmpNick]

        #end if
    #next
    
    # Number not found in phonebook.
    return "%number%"
    


# Incoming phonecall...
# There are so many options that code is getting pretty dirty & ugly (needs cleaning?)
def handle_call(obj_path, callernumber):
    global eSpeakCommand
    #stopEvent.clear()
    CallerNames = get_name_from_number(callernumber)

    eSpeakText = ""
    
    if CallerNames == "%number%": # Number not in phonebook :(
        if unkNum != "":
            # Split numbers. Possible fix for
            # "Phonenumber is over nine thouuusaaaannnddd!!!"-bug
            tmpNum = " ".join(list(callernumber))
            eSpeakText = unkNum.replace("%number%", tmpNum.encode("utf-8"))
    elif CallerNames == "%blocked%": # Number withheld. Probably phonesalesdude.
        if blNum != "":
            eSpeakText = blNum
    else: #we got lucky and found name from phonebook :)
        if useNickname == 1 and CallerNames[3] != "":  # Use nickname if available and wanted.
            eSpeakText = sayName.replace("%name%", "")
            eSpeakText = eSpeakText.replace("%first%", "")
            eSpeakText = eSpeakText.replace("%last%", "")
            eSpeakText = CallerNames[3] + eSpeakText
        else: 
            eSpeakText = sayName.replace("%name%", CallerNames[0])            
            eSpeakText = eSpeakText.replace("%first%", CallerNames[1])
            eSpeakText = eSpeakText.replace("%last%", CallerNames[2])      
        
    if eSpeakText != "":
        # Fixed: (0.4) "me speaks no umlauts"-bug (use utf-8)
        # Added: Repeat option. (just quick hack really)
        
        if repeatTime > 0:
            eSpeakText = (eSpeakText + '<break time="' + str(repeatTime) + 's"/>') * 10 # max repeat 10 times (enough?)
        
        eSpeakText = '<break time="2s"/>' + eSpeakText       
        eSpeakCommand = myCommand.replace("%text%", eSpeakText)


# Fixed: (0.5) "eSpeak starts shouting things after end ring"-bug
# Do things based on call status.
def call_status(state,ukn1,ukn2):
    #print "state: %d  ukn1: %d  ukn2: %d" % (state,ukn1,ukn2)
    global eSpeakProc
    global eSpeakCommand
    
    if state == 5: # STATUS_MT_ALERTING
        if eSpeakCommand != "":
            #eSpeakCommand = eSpeakCommand.encode("utf-8")
            #print eSpeakCommand 
            args = shlex.split(eSpeakCommand)
            eSpeakProc = subprocess.Popen(args, shell=False)
            eSpeakCommand = ""
    elif state == 15 or state == 7: # STATUS_TERMINATED or STATUS_ANSWERED
        eSpeakCommand = ""
        subprocess.Popen("kill -9 " + str(eSpeakProc.pid), shell=True)


            
# def Main
try:
    pdFile = open(os.path.expanduser(cfgFile), 'r+')
    myCommand = pdFile.readline().strip()
    sayName = pdFile.readline().strip()
    unkNum = pdFile.readline().strip()
    blNum = pdFile.readline().strip()
    useNickname = int(pdFile.readline().strip())
    repeatTime = int(pdFile.readline().strip())
    pdFile.close()
except:
    pass

DBusGMainLoop(set_as_default=True)
bus = dbus.SystemBus()
bus.add_signal_receiver(handle_call, path='/com/nokia/csd/call', dbus_interface='com.nokia.csd.Call', signal_name='Coming')
bus.add_signal_receiver(call_status, path=None, dbus_interface='com.nokia.csd.Call.Instance', signal_name='CallStatus')

gobject.MainLoop().run()
